<cfcomponent displayname="Componentes de Veculos"
		     hint="<b>KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Guto ( guto@kmm.com.br )</b><br>
				   <b>Data Criao</b> 		: 07/12/2004<br> 
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br> 
				   <b>Descrio				: </b><br> <div align='justify'>Componente de consultas sobre veculos.</div>"
		     extends="_transportes.funcoes.cfc_init">
	
    <!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->    	
	<cffunction name="get_veiculo_placa_frota" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<!---Terceiros--->	
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select 
                	p.placa 
                from oper.v$veiculo p 
                where 1=1		  
			<cfif Len(Trim(arguments.placa))>
			   and (p.placa = upper('#arguments.placa#')
			       or p.cod_veiculo = upper('#arguments.placa#'))                 
			</cfif>			
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os dados para o servio contratado
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 07/12/2005 - criado
	--->	
	<cffunction name="get_motorista_proprietario" displayname="Busca os dados para o servio contratado" access="remote" returntype="struct" output="false">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="data_emissao" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
        <cfargument name="trata_erro" required="no" default="0">
			<cftry>
				<cfscript>
					qrVeiculo = this.get_composicao(cod_veiculo = arguments.placa_controle);
				</cfscript>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_get_motorista_proprietario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#Replace(qrVeiculo.placa,'-','')#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.data_emissao#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnpj_prop">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.endereco">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cidade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.uf">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.proprietario_municipio_id">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cpf_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.nome_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_date"     variable="retorno.cnh_validade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnh_numero">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.pis_pasep_nit">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.retorno">
				</cfstoredproc>
                
				<cfset retorno.veiculo_proprietario = qrVeiculo.veiculo_proprietario>
				
				<cfscript>
					qrVeiculo = this.get_veiculo(placa = arguments.placa_controle);
				</cfscript>
                
				<cfset retorno.tag_ctf = qrVeiculo.tag_ctf>
                <cfset retorno.erro = false>
			<cfcatch>
            	<cfif arguments.trata_erro eq 0>
	            	<cfthrow detail="#cfcatch.Detail#">
                </cfif>
            	<cfif arguments.trata_erro eq 2>
					   <cfset retorno.mensagem = cfcatch>
                  <cfset retorno.erro = true>
               </cfif>
            	<cfif arguments.trata_erro eq 1>
					<cfset retorno = StructNew()>
                    <cfset retorno.cod_pessoa_proprietario = ''>
                    <cfset retorno.proprietario = 'Problemas com o veculo.'>
                    <cfset retorno.cnpj_prop = ''>
                    <cfset retorno.endereco = ''>
                    <cfset retorno.cidade = ''>
                    <cfset retorno.uf = ''>
                    <cfset retorno.proprietario_municipio_id = ''>
                    <cfset retorno.cod_pessoa_motorista = ''>
                    <cfset retorno.nome_motorista = ''>
                    <cfset retorno.cnh_validade = ''>
                    <cfset retorno.cnh_numero = ''>
                    <cfset retorno.pis_pasep_nit = ''>
                    <cfset retorno.retorno = ''>
                </cfif>
			</cfcatch>
			</cftry>
			<cfset retorno.placa = arguments.placa_controle>
		<cfreturn retorno>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os dados para o servio contratado
	-- NOTAS EXPLICATIVAS
	--  
	-- RAFAEL 03/01/2011 - CRIADO
	--->	
	<cffunction name="get_motorista_prop_doc" displayname="Busca os dados para o servio contratado" access="remote" returntype="struct" output="false">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="data_emissao" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
        <cfargument name="trata_erro" required="no" default="0">
			<cftry>
				<cfscript>
					qrVeiculo = this.get_composicao(cod_veiculo = arguments.placa_controle);
				</cfscript>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_get_motorista_prop_doc" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#Replace(qrVeiculo.placa,'-','')#">
					<cfprocparam type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.data_emissao#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.proprietario">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnpj_prop">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.endereco">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cidade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.uf">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.proprietario_municipio_id">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.cod_pessoa_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cpf_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.nome_motorista">
					<cfprocparam type="out" cfsqltype="cf_sql_date"     variable="retorno.cnh_validade">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.cnh_numero">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.pis_pasep_nit">
					<cfprocparam type="out" cfsqltype="cf_sql_integer"  variable="retorno.retorno">
				</cfstoredproc>
                
				<cfset retorno.veiculo_proprietario = qrVeiculo.veiculo_proprietario>

				<cfscript>
					qrVeiculo = this.get_veiculo(placa = arguments.placa_controle);
				</cfscript>
                
				<cfset retorno.tag_ctf = qrVeiculo.tag_ctf>
                <cfset retorno.erro = false>
			<cfcatch>
            	<cfif arguments.trata_erro eq 0>
	            	<cfthrow detail="#cfcatch.Detail#">
                </cfif>
            	<cfif arguments.trata_erro eq 2>
					<cfset retorno.mensagem = cfcatch>
                    <cfset retorno.erro = true>
                </cfif>
            	<cfif arguments.trata_erro eq 1>
					<cfset retorno = StructNew()>
                    <cfset retorno.cod_pessoa_proprietario = ''>
                    <cfset retorno.proprietario = 'Problemas com o veculo.'>
                    <cfset retorno.cnpj_prop = ''>
                    <cfset retorno.endereco = ''>
                    <cfset retorno.cidade = ''>
                    <cfset retorno.uf = ''>
                    <cfset retorno.proprietario_municipio_id = ''>
                    <cfset retorno.cod_pessoa_motorista = ''>
                    <cfset retorno.nome_motorista = ''>
                    <cfset retorno.cnh_validade = ''>
                    <cfset retorno.cnh_numero = ''>
                    <cfset retorno.pis_pasep_nit = ''>
                    <cfset retorno.retorno = ''>
                </cfif>
			</cfcatch>
			</cftry>
			<cfset retorno.placa = arguments.placa_controle>
		<cfreturn retorno>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a composicao do veiculo
	-- CRISTOFER  24/10/2006
	--->		
	<cffunction name="get_composicao" access="remote" returntype="any" output="true">
		<cfargument name="cod_veiculo" required="yes"> 
		<cfargument name="data" required="no" default=""> 
		<cfargument name="trata_erro" required="no" default="0"> 
        <cftry>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select t.column_value as placa,
                         oper.pkg_veiculo.fnc_get_cod_veiculo(t.column_value) as cod_veiculo,
                         oper.pkg_veiculo.fnc_veiculo_id(t.column_value) as veiculo_id,
                         case when t.column_value = '-1' then 0 else oper.pkg_veiculo.fnc_veiculo_proprietario(t.column_value) end as veiculo_proprietario,
                         a.capacidade,
                         oper.pkg_veiculo.FNC_VEICULO_MODALIDADE(t.column_value) as modalidade
                  from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#')<cfif len(trim(arguments.data))>,'#arguments.data#'</cfif>),'|')) t,
                       (select oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(oper.pkg_veiculo.fnc_get_placa('#JSStringFormat(arguments.cod_veiculo)#'),sysdate) as capacidade from dual) a
                 where t.column_value is not null
            </cfquery>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = "">
         	<cfcatch>
            	<cfif arguments.trata_erro eq 0>
                	<cfthrow object="#cfcatch#">
                <cfelseif arguments.trata_erro eq 1>
		            <cfset retorno.erro = true>
		            <cfset retorno.mensagem = cfcatch>
                    <cfset qr_result = retorno>
                </cfif>
            </cfcatch>
        </cftry>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<!---Terceiros--->	
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.veiculo_id, vd.placa,
                    vd.cod_veiculo,
                    vd.num_rastreador,
                    vd.rastreador_id,
                    vd.rastreador_com_problemas,
                    vd.marca_id,
                    vd.marca,
                    vd.modelo_id,
                    vd.situacao_id,
                    vd.uf,
                    vd.capacidade_tanque,
                    oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(vd.placa,sysdate) capacidade,
                    vd.km_revisao,
                    vd.modelo,
                    vd.proprietario,
                    vd.observacao,
                    vd.cor_predominante,
                    vd.ano,
                    vd.chassis,
                    vd.renavan,
                    va.agrupamento_id,
                    va.descricao as agrupamento,
                    vtc.tipo_carroceria_id,
               		vtc.descricao as tipo_carroceria,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TAG_CTF') as tag_ctf,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'NUMERO_EIXOS') as numero_eixos,
                    va.tracao,
                    vd.municipio_id,
                    (select municipio
                       from cep.municipio m
                      where m.municipio_id = vd.municipio_id) as municipio,
                    vd.tipo_carroceria_id,
                    vtc.descricao as tipo
              from oper.v$veiculo_dados vd
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vd.tipo_carroceria_id = vtc.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
                                                      and vp.data_fim is null
             where 1 = 1			  
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>	
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>		
			<cfif Len(Trim(arguments.proprietario))>
			   and vd.proprietario in (#arguments.proprietario#)
			</cfif>		
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('#arguments.frota#%')
			       or vd.cod_veiculo like upper('#arguments.frota#%'))
			</cfif>	
			<cfif Len(Trim(arguments.frota_exa))>
			   and (upper(vd.placa) = '#arguments.frota_exa#'
			       or upper(vd.cod_veiculo) = '#arguments.frota_exa#')
			</cfif>		
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Buscar a Modalidade do Veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_modalidade" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa_exa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.veiculo_id
                 , vd.placa
                 , vd.cod_veiculo
                 , vd.proprietario
              from oper.v$veiculo_dados vd
             where 1 = 1			  
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>	
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
  
    
    <!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_veiculo_modalidade_proprietario" returntype="query" access="remote">
		<cfargument name="placa" required="yes">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.FNC_VEICULO_MODALIDADE(v.placa) as modalidade
                 , (select razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_PESSOA_PROPRIETARIO(v.placa, sysdate) ) as proprietario
                 , (select kss.pkg_string.fnc_formata_cnpj_cpf( p.cnpj_cpf )
                      from kss.v$pessoa p
                     where p.cod_pessoa = oper.pkg_veiculo.FNC_PESSOA_PROPRIETARIO(v.placa, sysdate) ) as cnpj_cpf
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = v.municipio_id) as municipio
                 , v.uf
                 , vm.modelo
                 , va.marca
                 , (select upper(nvl(pep.logradouro,'') ||
                                 nvl2(pep.numero,', '||pep.numero, 'S/N') ||
                                 nvl2(pep.complemento,' - '||pep.complemento,'') ||
                                 nvl2(pep.bairro,' - '||pep.bairro,'') ||
                                 nvl2(pep.cep,' cep ' || substr(lpad(to_char(pep.cep),8,'0'),1,5) || '-' ||substr(lpad(to_char(pep.cep),8,'0'),6,8),'')||
                                 nvl2(pep.municipio,' - '||pep.municipio,'') ||
                                 nvl2(pep.uf,'/'||pep.uf,'')
                                 ) as endereco_completo
                      from kss.v$pessoa_endereco_padrao pep
                      where pep.cod_pessoa = oper.pkg_veiculo.fnc_pessoa_proprietario(v.placa, sysdate) ) as endereco
            from oper.v$veiculo v
           inner join oper.v$veiculo_modelo vm
              on vm.modelo_id = v.modelo_id
           inner join oper.v$veiculo_marca va
              on va.marca_id = v.marca_id
           where v.PLACA = '#arguments.PLACA#'
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna o nmero de eixos de uma determinada placa ou composio na data atual
	-- ANDERSONC 27/09/2010 15:41:18 - CRIADO
	--->
	<cffunction name='get_numero_eixos_composicao' displayname='Retorna o nmero de eixos de uma determinada placa ou composio na data atual' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_veiculo.prc_numero_eixos_composicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EIXOS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EIXOS_SUPENSOS' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca as validaes dos veculos
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 05/07/2013
	--->
    <cffunction name="get_validacao_veiculos" displayname="Busca o Tipo de Conhecimento" access="remote" returntype="query" output="false">
		<cfargument name="placas" required="yes"/>
        <cfargument name="data" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select x.cod_veiculo
                 , x.placa
                 , x.renavam
                 , x.tara
                 , x.cap_kg
                 , x.capm3
                 , x.tpprop
                 , x.tpprop_desc
                 , x.tpveic
                 , x.tpveic_desc
                 , x.tprod
                 , x.tprod_desc
                 , x.tpcar
                 , x.tpcar_desc
                 , x.uf
                 , x.classificacao
                 , x.agrupamento
                 , x.rntrc
                 , x.cod_veiculo_ok
                 , x.placa_ok
                 , x.renavam_ok
                 , x.tara_ok
                 , x.cap_kg_ok
                 , x.capm3_ok
                 , x.tpveic_ok
                 , x.tprod_ok
                 , x.tpcar_ok
                 , x.uf_ok
                 , x.rntrc_ok
                 , x.veiculo_ok                 
              from table(oper.pkg_veiculo.fnc_validacao_veiculos('#arguments.placas#', '#arguments.data#')) x
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca a validao da composicao
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 05/07/2013
	--->
    <cffunction name="get_validacao_composicao" access="remote" returntype="query" output="false">
		<cfargument name="placas" required="no" default=""/>
        <cfargument name="data" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select min(x.veiculo_ok) as composicao_ok
              from table(oper.pkg_veiculo.fnc_validacao_veiculos('#arguments.placas#', '#arguments.data#')) x
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO
	-- Busca a sincronia pendente com a Panorama
	-- NOTAS EXPLICATIVAS
	-- WELLINGTON 14/02/2019
	--->
	<cffunction name="get_sincronia_pendente" access="remote" returntype="query" output="false">
		<cfargument name="placa" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select fiscal.pkg_conhecimento.fnc_busca_sincronia_pendente('#arguments.placa#') as sincronia_pendente
	          from dual
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
</cfcomponent>
