 <cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca os Lotes para o localizar
	-- CRISTOFER  28/11/2006
	--->		
	<cffunction name="get_operacao_localizar" access="remote" returntype="query" output="true">
		<cfargument name="operacao_id" required="no" default="">
		<cfargument name="solicitacao_carga_id" required="no" default="">
		<cfargument name="viagem_carga_id" required="no" default="">
		<cfargument name="remetente" required="no" default="">
		<cfargument name="num_produto" required="no" default="">
		<cfargument name="org_municipio" required="no" default="">
		<cfargument name="fracionado" required="no" default="">
		<cfargument name="internacional" required="no" default="">
		<cfargument name="frete_proprio" required="no" default="">
		<cfargument name="filial_atual" required="no" default="0">
		<cfargument name="dedicado" required="no" default="">
		<cfargument name="modalidade" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="placa" required="no" default="">
		<cfquery name="qr_fitro_data" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select to_char(nvl(kss.pkg_parametro.fnc_valor_data('M309-P0012'),'01/07/2009'), 'dd/mm/yyyy') as data_filtro
            from dual
        </cfquery>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select z.*
		   from (
		 select y.*
			  , kss.fnc_get_cliente(y.motorista) as motorista_nome
              , logistica.pkg_agendamento.fnc_viagem_composicao(y.viagem_id, y.data_inicio_viagem, ' > ', 1) as composicao
              , logistica.pkg_agendamento.fnc_viagem_composicao(y.viagem_id, y.data_inicio_viagem, ' > ')    as composicao_frota
			  from (
				    select distinct logistica.pkg_agendamento.fnc_viagem_motorista(v.viagem_id) as motorista
				     , x.operacao_id
				     , x.operacao
				     , vc.viagem_carga_id
				     , ccc.carga_consolidada_id
				     , x.cod_remetente
				     , x.remetente
				     , x.org_municipio_id
				     , x.cod_destinatario
				     , x.dest_municipio_id
				     , x.rem_municipio_uf
				     , x.destinatario
				     , x.dest_municipio_uf
				     , sign(nvl(ccc.carga_consolidada_id,0)) as fracionado
				     , x.solicitacao_carga_id      
				     , v.viagem_id
				     , x.situacao
				     , v.num_romaneio
				     , v.data_inicio as data_inicio_viagem
                 , to_char(x.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_inicio
				     , to_char(x.data_carregamento_fim, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_fim
				     , to_char(x.data_entrega_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_inicio
				     , to_char(x.data_entrega_fim, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_fim
				     , to_char(con.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio
				     , to_char(con.data_termino, 'dd/mm/yyyy hh24:mi:ss') as data_termino
				     , coalesce((select rit.item_id
                               from oper.v$romaneio_item rit
                              where rit.carga_consolidada_id = ccc.carga_consolidada_id
                                and rit.num_romaneio = v.num_romaneio
                                and rownum = 1)
                           ,(select rit.item_id
                               from oper.v$romaneio_item rit
                              where rit.viagem_carga_id  = vc.viagem_carga_id
                                and rit.num_romaneio = v.num_romaneio
                                and rownum = 1)
                   ) as item_id
              from (select sc.operacao_id 
								 , o.descricao as operacao
								 , rem.cod_pessoa cod_remetente
								 , rem.cliente remetente
								 , rmun.municipio_id org_municipio_id
								 , dest.cod_pessoa cod_destinatario
								 , dmun.municipio_id dest_municipio_id
								 , rmun.municipio||'-'||rmun.uf_id rem_municipio_uf
								 , nvl(dest.cliente ,'-- Aberto --') destinatario
								 , nvl(decode(sc.destino_municipio_id,'','',dmun.municipio||'-'||dmun.uf_id),'-- Aberto --') dest_municipio_uf
								 , sc.solicitacao_carga_id
								 , o.frete_proprio
								 , kss.fnc_ref_code('LOGISTICA', 'SOLICITACAO_CARGA.SITUACAO_ID', sc.situacao_id) as situacao
								 , sc.data_carregamento_inicio
								 , sc.data_carregamento_fim
								 , sc.data_entrega_inicio
								 , sc.data_entrega_fim
							 from logistica.v$solicitacao_carga sc
							inner join kss.v$organograma org
							   on org.cod_organograma = sc.cod_organograma
							inner join logistica.v$operacao o
								on o.operacao_id = sc.operacao_id
     			       <cfif len(trim(arguments.operacao_id))>
                       and o.operacao_id in (#arguments.operacao_id#)
                   </cfif>								
							 left join kss.v$pessoa rem
							   on rem.cod_pessoa = sc.cod_remetente
							 left join cep.municipio rmun
							   on rmun.municipio_id = sc.origem_municipio_id
							 left join kss.v$pessoa dest
							   on dest.cod_pessoa = sc.cod_destinatario
							 left join cep.municipio dmun
							   on dmun.municipio_id = sc.destino_municipio_id
							where sc.data_carregamento_inicio >=  to_date('#qr_fitro_data.DATA_FILTRO#','dd/mm/yyyy')
							  and sc.situacao_id <> 5
							  and o.tipo_documento = 0
						      and not exists (select 1
												from logistica.v$solicitacao_carga_documento scd
											   where scd.solicitacao_carga_id = sc.solicitacao_carga_id
												 and scd.nf_es_id is not null)
							  and not exists (select 1
												from logistica.v$solicitacao_carga_documento scd
											   inner join fiscal.v$conhecimento c
												  on c.conhecimento_id = scd.conhecimento_id
											   where scd.solicitacao_carga_id = sc.solicitacao_carga_id
												 and c.modal = 1)
                       and exists (select 1
							                from logistica.v$operacao_filial_emissao ofe
												where ofe.operacao_id = sc.operacao_id
												  and ofe.cod_organograma = org.cod_organograma)
                   <cfif len(trim(arguments.fracionado))>
                       and o.fracionado in (#arguments.fracionado#)
                   </cfif>
                   <cfif len(trim(arguments.internacional))>
                       and o.internacional = #arguments.internacional#
                   </cfif>
                   <cfif len(trim(arguments.dedicado))>
                       and o.dedicado = #arguments.dedicado#
                   </cfif>
                   <cfif len(trim(arguments.frete_proprio))>
                       and o.frete_proprio = #arguments.frete_proprio#
                   </cfif>
                   <cfif len(trim(arguments.remetente))>
                       and upper(kss.pkg_string.fnc_string_clean(rem.cliente)) like '%'||upper(kss.pkg_string.fnc_string_clean('#arguments.remetente#'))||'%'
                   </cfif>
                   <cfif len(trim(arguments.org_municipio))>
                       and upper(kss.pkg_string.fnc_string_clean(dmun.municipio||'-'||dmun.uf_id)) like '%'||upper(kss.pkg_string.fnc_string_clean('#arguments.org_municipio#'))||'%'
                   </cfif>
                   <cfif arguments.filial_atual eq 1>
                       and org.cod_organograma = #session.cod_organograma#
                   </cfif>
                   <cfif len(trim(arguments.cod_pessoa))>
                       and org.cod_pessoa = #arguments.cod_pessoa#                 
                   </cfif>
                   <cfif len(trim(arguments.cod_centro_custo))>
                       and org.cod_centro_custo = #arguments.cod_centro_custo#
                   </cfif>            
                 ) x
				  left join logistica.v$carga_consolidada_carga ccc
				    on ccc.solicitacao_carga_id = x.solicitacao_carga_id
				   and ccc.situacao_id <> 0
				  left join logistica.v$carga_consolidada con
				    on con.carga_consolidada_id = ccc.carga_consolidada_id
				  left join logistica.v$carga_consolidada_viagem ccv
				    on ccv.carga_consolidada_id = ccc.carga_consolidada_id
				   and ccv.situacao_id <> 0
				  left join logistica.v$viagem_carga vc
				    on vc.solicitacao_carga_id = x.solicitacao_carga_id
			    inner join logistica.v$viagem v 
				    on v.viagem_id = nvl(ccv.viagem_id, vc.viagem_id)
				   and v.situacao_id <> 0
			    where not exists (select 1 
                                 from fiscal.v$conhecimento c 
                                inner join oper.v$romaneio_item rit
                                   on rit.item_id = c.item_id
                                where rit.viagem_carga_id = vc.viagem_carga_id)
               and not exists (select 1 
                                 from fiscal.v$nf_es_frete c 
                                inner join oper.v$romaneio_item rit
                                   on rit.item_id = c.item_id
                                where rit.viagem_carga_id = vc.viagem_carga_id)
			 <cfif len(trim(arguments.modalidade))>
				   and v.modalidade in (#ListQualify(arguments.modalidade,"'",',')#)
			 </cfif>
													 ) y
													 ) z
				 where 1 = 1
             <cfif len(trim(arguments.placa))>
                 and (z.composicao like upper('%' || '#arguments.placa#' || '%') or z.composicao_frota like upper('%' || '#arguments.placa#' || '%'))
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Converte entre unidades de medida
	-- CRISTOFER  14/11/2006
	--->		
	<cffunction name="converte_unidade" access="remote" returntype="numeric" output="true">
		<cfargument name="valor" required="yes">
		<cfargument name="unidade_origem" required="yes">
		<cfargument name="unidade_destino" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fiscal.pkg_fiscal.fnc_converte_peso(#arguments.valor#, '#arguments.unidade_origem#', '#arguments.unidade_destino#') valor
			  from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>
</cfcomponent>
