<cfcomponent displayname="Consultas da rea de impostos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Busca os impostos do conhecimento
	-- NOTAS EXPLICATIVAS
	-- Leandro Rocha 06/08/2014
	--->
    <cffunction name="get_impostos_ctrc" displayname="Busca o impostos do Conhecimento" access="remote" returntype="any" output="true">
		<cfargument name="NUM_PRODUTO" displayname="Identificador do produto do conhecimento" required="yes"/>
        <cfargument name="COD_PESSOA_FILIAL" displayname="Identificador do emitente do conhecimento" required="yes"/>
		<cfargument name="COD_REMETENTE" displayname="Identificador do remetente do conhecimento" required="yes"/>
        <cfargument name="COD_DESTINATARIO" displayname="Identificador do destinatrio do conhecimento" required="yes"/>
        <cfargument name="COD_REDESPACHO" displayname="Identificador da entrega do conhecimentoe" required="yes">
        <cfargument name="COLETA_COD_PESSOA" displayname="Identificador da coleta do conhecimento" required="yes"/>
        <cfargument name="COD_CLIENTE_COBRANCA" displayname="Identificador do tomador do conhecimento" required="yes"/>
        <cfargument name="CFOP" displayname="Identificador do cfop do conhecimento" required="yes"/>
        <cfargument name="VALOR_TOTAL_TRIBUTAVEL_CALC" displayname="Valor tributvel do conhecimento" required="yes"/>
        <cfargument name="TOTALCTRC_CALC" displayname="Valor da base de clculo do conhecimento" required="yes"/>
        <cfargument name="PEDAGIO_CALC" displayname="Valor do pedgio do conhecimento" required="yes"/>
        <cfargument name="ICMS_COMPOE_BASE_CALCULO" displayname="Define se o icms compoe a base de clculo do conhecimento" required="yes"/>
        <cfargument name="VALOR_ICMS" displayname="Valor do ICMS do CT-e" required="yes"/>
        <cfargument name="VALOR_ICMS_SUBSTITUTO" displayname="Valor do ICMS Substituto do CT-e" required="yes"/>
        <cfargument name="NUM_NATUREZA" displayname="Natureza da nota com maior valor" required="yes"/>
        <cfargument name="CFOP_TRANSPORTADO" displayname="CFOP da nota com maior valor" required="no"/>
        <cfargument name="ICMS_PARTILHADO" displayname="ICMS possui partilha" required="no"/>
        <cfargument name="BASE_CALCULO_ICMS" displayname="Base de clculo de ICMS" required="no"/>
        <cfargument name="DATA_EMISSAO" displayname="Data de emisso do documento" required="no"/>
        <cfargument name="ICMS_PART_COMPOE_BASE_CALC" displayname="Define se o icms de partilha compoe a base de clculo do conhecimento" required="no"/>
		<cfargument name="COD_MODELO" displayname="Cdigo do modelo do conhecimento" required="no"/>
		<cfargument name="COD_ENDERECO_DESTINATARIO" displayname="Cdigo do endereo do destinatrio" required="no"/>
		<cfargument name="COD_ENDERECO_ENTREGA" displayname="Cdigo do endereo da entrega" required="no"/>
		<cfargument name="COD_ENDERECO_COLETA" displayname="Cdigo do endereo da coleta" required="no"/>
		<cfargument name="COD_ENDERECO_TOMADOR" displayname="Cdigo do endereo do Tomador" required="no"/>
		<cfargument name="REM_MUNICIPIO_ID" displayname="Cdigo do endereo do Remetente" required="no"/>
		<cfargument name="ENTREGA_UF" displayname="UF de entrega" required="no"/>
		<cfargument name="COLETA_UF" displayname="UF da Coleta" required="no"/>
		<cfargument name="ENTREGA_MUNICIPIO_ID" displayname="Cdigo do municipio de entrega" required="no"/>
		<cfargument name="COLETA_MUNICIPIO_ID" displayname="Cdigo do municipio da coleta" required="no"/>
		<cfargument name="DEST_COD_ATIVIDADE_FISCAL" displayname="Cdigo de atividade fiscal destino" required="no"/>
		<cfargument name="TOMA_COD_ATIVIDADE_FISCAL" displayname="Cdigo de atividade fiscal tomador" required="no"/>
		<cfargument name="CONHECIMENTO_TIPO_ID" displayname="Cdigo do tipo de conhecimento" required="no"/>
		<cfargument name="EMIT_COD_ENDERECO" displayname="Cdigo endereo emitente" required="no"/>
		<cfargument name="NFE_PARTILHADA" displayname="Nfe partilhada" required="no"/>

           <cftry>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				with impostos as (
				  select *
					from table(fiscal.pkg_imposto_ctrc.fnc_pip_impostos_config_ctrc(p_num_produto                => #arguments.NUM_PRODUTO#
																				  , p_cod_pessoa_filial          => #arguments.COD_PESSOA_FILIAL#
																				  , p_cod_remetente              => #arguments.COD_REMETENTE#
																				  , p_cod_destinatario           => #arguments.COD_DESTINATARIO#
																				  , p_entrega_cod_pessoa         => #arguments.COD_REDESPACHO#
																				  , p_coleta_cod_pessoa          => #arguments.COLETA_COD_PESSOA#
																				  , p_cod_cliente_cobranca       => #arguments.COD_CLIENTE_COBRANCA#
																				  , p_cfop                       => #arguments.CFOP#
																				  , p_valor_base_calculo         => #arguments.TOTALCTRC_CALC#
																				  , p_valor_base_calculo_icms    => #arguments.VALOR_TOTAL_TRIBUTAVEL_CALC#
																				  , p_valor_pedagio              => #arguments.PEDAGIO_CALC#
																				  , p_icms_compoe_base_calculo   => #arguments.ICMS_COMPOE_BASE_CALCULO#
																				  , p_num_natureza               => #arguments.NUM_NATUREZA#
																				  , p_cfop_transportado          => <cfif len(trim(arguments.CFOP_TRANSPORTADO))>#arguments.CFOP_TRANSPORTADO# <cfelse> null </cfif>
																				  , p_data_base                  => to_date(trim('#arguments.DATA_EMISSAO#'),'dd/mm/yyyy hh24:mi')
																				  , p_cod_modelo                 => <cfif len(trim(arguments.COD_MODELO))>#arguments.COD_MODELO# <cfelse> null </cfif>
																				  , p_dest_cod_endereco          => <cfif len(trim(arguments.COD_ENDERECO_DESTINATARIO))>#arguments.COD_ENDERECO_DESTINATARIO# <cfelse> null </cfif>
																				  , p_entr_cod_endereco          => <cfif len(trim(arguments.COD_ENDERECO_ENTREGA))>#arguments.COD_ENDERECO_ENTREGA# <cfelse> null </cfif>
																				  , p_cole_cod_endereco          => <cfif len(trim(arguments.COD_ENDERECO_COLETA))>#arguments.COD_ENDERECO_COLETA# <cfelse> null </cfif>
																				  , p_toma_cod_endereco          => <cfif len(trim(arguments.COD_ENDERECO_TOMADOR))>#arguments.COD_ENDERECO_TOMADOR# <cfelse> null </cfif>
																				  , p_rem_municipio_id           => <cfif len(trim(arguments.REM_MUNICIPIO_ID))>#arguments.REM_MUNICIPIO_ID# <cfelse> null </cfif>
																				  , p_cole_uf                    => <cfif len(trim(arguments.COLETA_UF))>'#arguments.COLETA_UF#' <cfelse> null </cfif>
																				  , p_entr_uf                    => <cfif len(trim(arguments.ENTREGA_UF))>'#arguments.ENTREGA_UF#' <cfelse> null </cfif>
																				  , p_cole_municipio_id          => <cfif len(trim(arguments.COLETA_MUNICIPIO_ID))>#arguments.COLETA_MUNICIPIO_ID# <cfelse> null </cfif>
																				  , p_entr_municipio_id          => <cfif len(trim(arguments.ENTREGA_MUNICIPIO_ID))>#arguments.ENTREGA_MUNICIPIO_ID# <cfelse> null </cfif>
																				  , p_toma_cod_atividade_fiscal  => <cfif len(trim(arguments.TOMA_COD_ATIVIDADE_FISCAL))>#arguments.TOMA_COD_ATIVIDADE_FISCAL# <cfelse> null </cfif>
																				  , p_dest_cod_atividade_fiscal  => <cfif len(trim(arguments.DEST_COD_ATIVIDADE_FISCAL))>#arguments.DEST_COD_ATIVIDADE_FISCAL# <cfelse> null </cfif>
																				  , p_icms_part_compoe_base_calc => <cfif len(trim(arguments.ICMS_PART_COMPOE_BASE_CALC))>#arguments.ICMS_PART_COMPOE_BASE_CALC# <cfelse> null </cfif>
																				  , p_emit_cod_endereco          => <cfif len(trim(arguments.EMIT_COD_ENDERECO))>#arguments.EMIT_COD_ENDERECO# <cfelse> null </cfif>
																				  , p_conhecimento_tipo_id       => <cfif len(trim(arguments.CONHECIMENTO_TIPO_ID))>#arguments.CONHECIMENTO_TIPO_ID# <cfelse> null </cfif>
																				  , p_nfe_partilhada             => <cfif len(trim(arguments.NFE_PARTILHADA))>'#arguments.NFE_PARTILHADA#' <cfelse> null </cfif>
																					)))
			   select config_ctrc.imposto_tipo_id                            as imposto_tipo_id
					, config_ctrc.descricao                                  as descricao
					, it.descricao                                           as imp_tipo_desc
					, config_ctrc.aliquota                                   as aliquota
					, config_ctrc.reducao_base                               as reducao_base
					, config_ctrc.base_calculo                               as base_calculo
					, config_ctrc.base_calculo_reduzida                      as base_calculo_reduzida
					, config_ctrc.valor                                      as imposto_total
					, config_ctrc.imposto_situacao_id                        as imposto_situacao_id
					, config_ctrc.imposto_sit_trib_tipo_id                   as imposto_situacao_trib_tipo_id
					, config_ctrc.retido_fonte                               as retido_fonte
					, decode(config_ctrc.retido_fonte,1,'Sim','No')         as retido_fonte_desc
					, config_ctrc.imposto_cod_retencao_id                    as imposto_cod_retencao_id
					, config_ctrc.regime_cumulativo                          as regime_cumulativo
					, decode(config_ctrc.regime_cumulativo,1,'Sim','No')    as regime_cumulativo_desc
					, config_ctrc.imposto_origem_id                          as imposto_origem_id
					, config_ctrc.imposto_natureza_bc_id                     as imposto_natureza_bc_id
					, replace(config_ctrc.fundamentacao_legal, chr(10), ' ') as imp_fundamentacao_legal
					, config_ctrc.reservado_fisco                            as reservado_fisco
					, p.descricao                                            as produto_descricao
					, lpad(nvl(ltrim(st.cod_situacao, '0'),'0'),  2, '0')    as cod_situacao
					, st.cod_situacao||' - '||st.descricao                   as imp_cod_situacao
					, io.descricao                                           as ind_orig_cred
					, n.descricao                                            as nat_bc_cred
					, cr.cod_retencao                                        as cod_retencao
					, stt.descricao                                          as situacao_trib_tipo
				, (select con.gera_cpg_icms_antecipado
                     from fiscal.v$imposto_configuracao con
                    where con.imposto_config_id = config_ctrc.imposto_config_id) as gera_cpg_icms_antecipado
             from fiscal.v$imposto_tipo it
            inner join impostos config_ctrc
               on it.imposto_tipo_id = config_ctrc.imposto_tipo_id
             left join fiscal.v$imposto_cod_retencao cr
               on cr.imposto_cod_retencao_id = config_ctrc.imposto_cod_retencao_id
             left join fiscal.v$imposto_natureza_bc n
               on n.imposto_natureza_bc_id = config_ctrc.imposto_natureza_bc_id
             left join fiscal.v$imposto_origem io
               on io.imposto_origem_id = config_ctrc.imposto_origem_id
             left join fiscal.v$imposto_situacao_tributaria st
               on st.imposto_situacao_id = config_ctrc.imposto_situacao_id
             left join fiscal.v$imposto_situacao_trib_tipo stt
               on stt.imposto_situacao_trib_tipo_id = config_ctrc.imposto_sit_trib_tipo_id
             left join fiscal.v$produto p
               on p.produto_id = #arguments.NUM_PRODUTO#
            where config_ctrc.imposto_config_id is not null
            order by case when it.imposto_tipo_id = 1 or it.imposto_tipo_id = 15 then 0
                          when it.descricao like 'ICMS%' then 1
                          when it.descricao like 'PIS%' then 2
                          when it.descricao like 'COFINS%' then 3
                          else 4
                     end
                   , it.descricao
        </cfquery>
            <cfset retorno.erro = false>
			<cfset retorno.query = qr_result>
			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
    </cffunction>
</cfcomponent>
