<cfcomponent displayname="Consultas da referentes a CTE" extends="_transportes.funcoes.cfc_init">
    <!---
	-- PROPSITO
	-- Busca o Tipo de Conhecimento
	-- NOTAS EXPLICATIVAS
	-- WAGNERS 30/03/2011
	--->
    <cffunction name="get_conhecimento_tipo" displayname="Busca o Tipo de Conhecimento" access="remote" returntype="query" output="false">
		<cfargument name="conhecimento_tipo_id" displayname="Identificador do tipo de conhecimento" required="no"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select conhecimento_tipo_id,
                   descricao,
                   tipo_servico_id,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from fiscal.v$conhecimento_tipo ct

             where 1=1
             <cfif isDefined("arguments.conhecimento_tipo_id") and len(trim(arguments.conhecimento_tipo_id)) >
             	and ct.conhecimento_tipo_id = #arguments.conhecimento_tipo_id#
             </cfif>
             <cfif isDefined("arguments.descricao") and len(trim(arguments.descricao)) >
             	and upper(ct.descricao) like upper('%#arguments.descricao#%')
             </cfif>

             order by descricao
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca Organograma completo
	-- GUTO  20/12/2006
	--->
	<cffunction name="get_organograma" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select o.cod_organograma, o.cod_unidade_negocio,
				   p.cliente as filial, o.cod_pessoa,
				   d.descricao as departamento, o.cod_departamento,
				   s.descricao as setor, o.cod_setor,
				   cc.centro_custo, o.cod_centro_custo
			  from kss.v$organograma o
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = o.cod_pessoa
			 inner join kss.v$departamento d
					 on d.cod_departamento = o.cod_departamento
			 inner join kss.v$setor s
					 on s.cod_setor = o.cod_setor
			 inner join kss.v$centro_custo cc
					 on cc.cod_centro_custo = o.cod_centro_custo
             where 1=1
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and o.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_centro_custo))>
			   and o.cod_centro_custo = '#arguments.cod_centro_custo#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Consulta o ultimo numero de conhecimento
	-- NOTAS EXPLICATIVAS
	--
	-- LOUIS - 10/07/2007  - criado
	--->
	<cffunction name="get_num_conhecimento" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nvl(max(c.num_conhecimento),0) + 1 as num_conhecimento
              from fiscal.v$conhecimento c
             where c.cod_pessoa_filial 	= #session.cod_pessoa#
               and c.cod_setor			= #session.cod_setor#
               and c.cod_departamento	= #session.cod_departamento#
               and c.cod_centro_custo 	= #session.cod_centro_custo#
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Sries
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/02/2006
	--->
	<cffunction name="get_serie" displayname="Busca Sries" access="remote" returntype="query" output="false">
	    <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_pessoa" hint="Usado para algumas telas que usam o COD_PESSOA como o cdigo pessoa da filial" required="no" default=""/>
	    <cfargument name="cod_departamento" required="no">
	    <cfargument name="cod_setor" required="no">
	    <cfargument name="cod_centro_custo" required="no">
		<cfargument name="cod_modelo" required="no" default="">
	    <cfargument name="organograma" required="no" default="">
		<cfargument name="todas" required="no">
        <cfargument name="ordenada" required="no">
        <cfargument name="documento_proprio" required="no">
		<cfif Len(Trim(arguments.cod_pessoa)) and not Len(Trim(arguments.cod_pessoa_filial))>
			<cfset arguments.cod_pessoa_filial = arguments.cod_pessoa>
		</cfif>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cfif not isDefined("arguments.todas")>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				 <cfif Len(Trim(arguments.cod_pessoa_filial))>
					select ags.serie
					  from fiscal.v$modelo_serie ags
					 where ags.cod_pessoa       = #arguments.cod_pessoa_filial#
					   and ags.cod_departamento = #arguments.cod_departamento#
					   <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor))>
                       	and ags.cod_setor        = #arguments.cod_setor#
                       </cfif>
					   and ags.ativo 			= 1
					   <cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
					   </cfif>
                       <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
					  order by ags.cod_pessoa, ags.cod_departamento, ags.cod_setor
                      <cfif  isDefined("arguments.ordenada") and Len(Trim(arguments.ordenada))>
                      , lpad(ags.serie,3,'0')
                      </cfif>
				 <cfelse>
					select distinct ags.serie
					  from fiscal.v$modelo_serie ags
					 inner join oper.v$kss_usuario_lotacao ul
						on ags.cod_pessoa = ul.cod_pessoa
					   and ags.cod_departamento = ul.cod_departamento
					   and ags.cod_setor = ul.cod_setor
					  where ags.ativo 	 = 1
					  	<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
					   </cfif>
                       <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
					  order by ags.serie
				 </cfif>
			</cfquery>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				select distinct serie
				from fiscal.v$modelo_serie ags
				where ativo 	 = 1
				<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
				</cfif>
                <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
  			</cfquery>
	    </cfif>
		<cfreturn qr_serie>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca natureza
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 19/07/2009 - MODIFICADO
	--->
	<cffunction name="get_natureza" displayname="Busca Natureza" access="remote" returntype="query" output="false">
		<cfargument name="num_natureza" required="no" default="">
		<cfargument name="descricao" required="no" default="">
        <cfargument name="order_by" required="no" default="0" hint="0-Descrio Resumida, Descrio; 1-Descrio">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select n.num_natureza, n.descricao, n.grupo_natureza_id, gn.descricao_resumida grupo, gn.descricao as descricao_grupo, n.peso_especifico
              from oper.v$natureza n
             inner join oper.v$grupo_natureza gn
                     on gn.grupo_natureza_id = n.grupo_natureza_id
             where 1=1
			<cfif Len(Trim(arguments.num_natureza))>
			   and n.num_natureza = #arguments.num_natureza#
			</cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(n.descricao) like upper('%#arguments.descricao#%')
			</cfif>
            <cfif arguments.order_by eq 0>
			 order by gn.descricao_resumida, n.descricao
            <cfelseif arguments.order_by eq 1>
             order by n.descricao
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca espcie
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_especie" displayname="Busca Espcie" access="remote" returntype="query" output="false">
		<cfargument name="num_especie" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select  e.num_especie, e.descricao
			  from oper.v$especie e
			 where 1=1
			 <cfif len(trim(arguments.num_especie))>
			   and num_especie = #arguments.num_especie#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(e.descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by e.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca unidades de medida
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 20/04/2009
	--->
	<cffunction name="get_unidade" displayname="Busca unidades de medida" access="remote" returntype="query" output="false">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select u.cod_unidade,
            	   u.unidade,
                   u.cod_grupo_umedida,
                   nvl((select uc.equivalencia
                      from fiscal.v$unidade_medida_conversao uc
                     where uc.cod_unidade = u.cod_unidade
                       and uc.cod_unidade_eq = 'Kg'),1) as equivalencia_kg
			  from fiscal.v$unidade_medida u
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Retorna as situaes tributrias
    -- ANDERSON 26/08/2010 - CRIADO
    --->
    <cffunction name="get_situacao_tributaria" access="remote" returntype="query" output="true">
    	<cfargument name="st_icms_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.st_icms_id
                 , t.st_icms_descricao
              from fiscal.v$st_icms t
             where 1 = 1
			<cfif Len(Trim(arguments.st_icms_id))>
               and t.st_icms_id in (#PreserveSingleQuotes(arguments.st_icms_id)#)
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de frete
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_tipo_frete" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select produto_id, descricao
              from oper.v$produto t
	 		 where t.frete = 1
		</cfquery>
	<cfreturn qr_result>
	</cffunction>


	<!---
	-- PROPSITO
	-- Buscar dados da NFE
	-- RAFAEL 16/07/2010 17:37:17 - CRIADO
	--->
	<cffunction name='get_nfe_dados' displayname='Buscar dados da NFE' access='remote' returntype='Struct' output='true'>
		<cfargument name='NFE' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_nfe_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.NFE#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CHAVE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUMERO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.SERIE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DATA_EMISSAO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CNPJ_EMITENTE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.EMITENTE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CNPJ_DESTINATARIO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DESTINATARIO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MODELO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.PESO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ESPECIE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_ESPECIE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CFOP' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VOLUMES' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ICMS_PARTILHADO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.CONHECIMENTO_ID#' null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
    -- PROPSITO
    -- Buscar dados da NFE
    -- jaquelinef 08/04/2014 10:12:19 - CRIADO
    --->
    <cffunction name='get_cte_dados' displayname='Buscar dados da NFE' access='remote' returntype='Struct' output='true'>
        <cfargument name='CTE' required='yes'>
        <cfargument name='CHAVE' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_cte.prc_cte_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.CTE#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE#' variable='retorno.CHAVE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CUF' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.AAMM' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CNPJ' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MOD' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.SERIE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.NCT' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.TPEMIS' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CCT' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CDV' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.EMIT' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Chave do CTe lida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca os CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_cte_lista" displayname="" access="remote" returntype="query" output="false">
		<cfargument name="data_inicio" required="no" default="#DateFormat(now() - 7, 'DD/MM/YYYY')#">
        <cfargument name="data_termino" required="no" default="#DateFormat(now(), 'DD/MM/YYYY')#">
        <cfargument name="dacte_impresso" required="no" default="">
        <cfargument name="num_cte" required="no" default="">
        <cfargument name="num_romaneio_filtro" required="no" default="">
        <cfargument name="num_mdfe" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="cod_remetente" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="cod_cliente_cobranca" required="no" default="">
	    <cfargument name="num_docto_fatura" required="no" default="">
        <cfargument name="cte_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select cte.conhecimento_id
                 , cte.num_conhecimento
                 , cte.serie
                 , to_char(cte.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , cte.num_romaneio
                 , cte.rem_razao_social
                 , kss.pkg_string.fnc_formata_cnpj_cpf(cte.rem_cnpj_cpf) as rem_cnpj_cpf
                 , cte.dest_razao_social
                 , kss.pkg_string.fnc_formata_cnpj_cpf(cte.dest_cnpj_cpf) as dest_cnpj_cpf
                 , cte.cob_razao_social
                 , kss.pkg_string.fnc_formata_cnpj_cpf(cte.cob_cnpj_cpf) as cob_cnpj_cpf
                 , dc.documento_id
                 , ds.cod_status
                 , ds.descricao_status
                 , nvl(ds.situacao_id, 0) as situacao_id
                 , ds.emitido
                 , ds.permite_editar
                 , ds.permite_inutilizar
                 , ds.permite_cancelar
                 , ds.descricao_situacao
                 , cte.user_insert
                 , nvl(cte.status_email_remetente,0) as status_email_remetente
                 , nvl(cte.status_email_destinatario,0) as status_email_destinatario
                 , nvl(cte.status_email_recebedor,0) as status_email_recebedor
                 , nvl(cte.status_email_expedidor,0) as status_email_expedidor
                 , nvl(cte.status_email_tomador,0) as status_email_tomador
                 , nvl(cte.status_email_proprietario,0) as status_email_proprietario
                 , nvl(cte.status_email_emissor,0) as status_email_emissor
                 , nvl(cte.status_email_transportador,0) as status_email_transportador
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_remetente) as email_remetente
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_destinatario) as email_destinatario
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.entrega_cod_pessoa) as email_recebedor
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.coleta_cod_pessoa) as email_expedidor
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_consignatario) as email_tomador
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_proprietario) as email_proprietario
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_pessoa_filial) as email_emissor
                 , (select fiscal.pkg_cte_email.fnc_email_cte(sc.cod_transportador_sugerido)
                      from logistica.v$solicitacao_carga sc
                     where sc.solicitacao_carga_id = cte.solicitacao_carga_id) as email_transportador
                 , cte.cod_pessoa_filial
                 , (select p.cliente
                      from kss.v$pessoa p
                      where p.cod_pessoa = cte.cod_pessoa_filial) as filial
                 , cte.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = cte.cod_centro_custo) as centro_custo
                  , cte.coleta_municipio || ' - ' || cte.coleta_uf as coleta
                 , cte.entrega_municipio || ' - ' || cte.entrega_uf as entrega
                 , (select te.descricao
                      from sefaz.v$tipo_emissao te
                     where te.cod_docto = 'CTE'
                       and te.tipo_emissao_id =  d.tipo_emissao_id) as tipo_emissao
                 , d.tipo_emissao_id
                 , d.ambiente_id
                 , cTE.liberado_impressao
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(cte.placa_tracao) as cod_veiculo_tracao
                 , cte.placa_tracao
                 , cte.modalidade
                 , cte.nome_motorista
                 , cte.cod_organizacional || ' - ' ||
                   (select descricao
                      from kss.v$organizacional org
                     where org.organizacional_id = cte.organizacional_id ) as organizacional
                 , fiscal.pkg_cte.fnc_permite_liberar_impressao(cte.conhecimento_id) as libera_impressao
                 , fiscal.pkg_cte.fnc_permite_cancelar_cte(cte.conhecimento_id) as libera_cancelamento
                 , ds.permite_consulta_chave
                 , cte.conhecimento_tipo_id
                 , (select c.num_conhecimento || '/' || c.serie
                      from fiscal.v$conhecimento_substituto cs
                     inner join fiscal.v$conhecimento c
                        on c.conhecimento_id = cs.conhecimento_substituto_id
                     where cs.conhecimento_id = cte.conhecimento_id) as num_conhecimento_substituto
                 , (select c.substituto
                      from fiscal.v$conhecimento_substituto cs
                     inner join fiscal.v$conhecimento c
                        on c.conhecimento_id = cs.conhecimento_substituto_id
                     where cs.conhecimento_id = cte.conhecimento_id) as substituto
                 , (select c.num_conhecimento || '/' || c.serie
                      from fiscal.v$conhecimento_substituto cs
                     inner join fiscal.v$conhecimento c
                        on c.conhecimento_id = cs.conhecimento_id
                     where cs.conhecimento_substituto_id = cte.conhecimento_id) as num_conhecimento_substituido
                  , cte.substituto as tipo_substituto
                  , (select op.declaracao_cte_id
                       from logistica.v$operacao op
                      where cte.operacao_id = op.operacao_id) declaracao_id
                  , cte.coleta_uf
                  , cte.entrega_uf
                  /*MDFE*/
                  , m.mdfe_id
                  , m.num_mdfe
                  , m.serie as serie_mdfe
			      , to_char(m.data_emissao, 'dd/mm/yyyy') as data_emissao_mdfe
				  , m.ev_pag_oper_transp
				  , fiscal.pkg_mdfe.fnc_permite_ev_pag_oper_transp(m.mdfe_id) as permite_ev_pag_oper_transp
                  , mds.permite_editar as permite_editar_mdfe
                  , mds.situacao_id as situacao_id_mdfe
                  , mds.cod_status as mdfe_id_status
                  , mds.emitido as emitido_mdfe
                  , mds.documento_id as documento_id_mdfe
                  , mds.descricao_status as status_mdfe
                  , mds.permite_consulta_chave as permite_consulta_chave_mdfe
                  , mds.permite_inutilizar as permite_inutilizar_mdfe
                  , mds.tipo_emissao_id as tipo_emissao_id_mdfe
                  , m.data_cancelamento as data_cancelamento_mdfe
                  , m.data_encerramento as data_encerramento_mdfe
                  , case when cte.substituto = 1 or
                              (select sign(count(1))
                                from fiscal.v$conhecimento_complemento cc
                               where cc.conhecimento_complemento_id = cte.conhecimento_id) = 1
                         then 0 else fiscal.pkg_mdfe.fnc_permite_emissao(p_num_romaneio => cte.num_romaneio
														 , p_carga_consolidada_id => (select max(ccc.carga_consolidada_id) keep(dense_rank last order by ccc.date_insert)
																					    from logistica.v$carga_consolidada_carga ccc
																					   where ccc.solicitacao_carga_id = cte.solicitacao_carga_id
																					     and ccc.situacao_id not in (0))
														 , p_throw => 0
														 )
                    end as permite_mdfe
                  , (select case when count(1) = 0 and mds.situacao_id = 5 and mds.cod_status <> '204' then 1 else 0 end
                       from sefaz.requisicao r
                      where r.documento_id = mdoc.documento_id
                        and r.servico_id in (3,10)) permite_excluir_mdfe
                  , decode((select count(1)
                              from fiscal.v$carta_correcao_eletronica cce
                             where cce.conhecimento_id = cte.conhecimento_id
                               and cce.cod_status = 135), 0, 0, 1) as possui_cce
                 , (select ct.descricao
                      from fiscal.v$conhecimento_tipo ct
                     where ct.conhecimento_tipo_id =  cte.conhecimento_tipo_id) as tipo_conhecimento
                 , (select c.num_conhecimento || '/' || c.serie
                      from fiscal.v$conhecimento_anulacao ca
                     inner join fiscal.v$conhecimento c
                        on c.conhecimento_id = ca.conhecimento_id_original
                     where ca.conhecimento_id_anulacao = cte.conhecimento_id) as num_conhecimento_anulado
                 , (select c.num_conhecimento || '/' || c.serie
                      from fiscal.v$conhecimento_anulacao ca
                     inner join fiscal.v$conhecimento c
                        on c.conhecimento_id = ca.conhecimento_id_anulacao
                     where ca.conhecimento_id_original = cte.conhecimento_id
                       and ca.data_cancelamento is null) as num_conhecimento_anulacao
                 , (select max(ccc.carga_consolidada_id) keep (dense_rank last order by cc.data_termino, ccc.date_insert)
					  from logistica.v$carga_consolidada_carga ccc
					 inner join logistica.v$carga_consolidada cc
					    on cc.carga_consolidada_id = ccc.carga_consolidada_id
                     where ccc.solicitacao_carga_id = cte.solicitacao_carga_id
                       and ccc.situacao_id not in (0)) as carga_consolidada_id
                 , instr(upper(nvl(kss.pkg_parametro.fnc_valor_lista_multi(p_identificador => 'M309-P0198'), 'abc')), upper(ds.descricao_situacao)) as parametro_status_incluso
                 /*Vale Pedgio*/
                 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(to_char(vpr.num_comprovante_vazio), ','))  
					  from oper.v$vale_pedagio_conhecimento vpc            
					 inner join oper.v$vale_pedagio_romaneio vpr
					    on vpr.vale_pedagio_romaneio_id = vpc.vale_pedagio_romaneio_id
					 where vpc.conhecimento_id = cte.conhecimento_id
					   and vpc.data_cancelamento is null
					) as vale_pedagio_comprov_vazio
				 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(to_char(vpr.num_comprovante_carregado), ','))  
					  from oper.v$vale_pedagio_conhecimento vpc            
					 inner join oper.v$vale_pedagio_romaneio vpr
					    on vpr.vale_pedagio_romaneio_id = vpc.vale_pedagio_romaneio_id
					 where vpc.conhecimento_id = cte.conhecimento_id
					   and vpc.data_cancelamento is null
					) as vale_pedagio_comprov_carregado
				 , (select decode( count(vpc.vale_pedagio_conhecimento_id) , 0, 'No', 'Sim')
					  from oper.v$vale_pedagio_conhecimento vpc            
					 inner join oper.v$vale_pedagio_romaneio vpr
						on vpr.vale_pedagio_romaneio_id = vpc.vale_pedagio_romaneio_id
					 where vpc.conhecimento_id = cte.conhecimento_id
					   and vpc.data_cancelamento is null
					) as vale_pedagio_possui
				 , (select distinct vpo.identificador
					  from oper.v$vale_pedagio_conhecimento vpc            
				     inner join oper.v$vale_pedagio_romaneio vpr
					    on vpr.vale_pedagio_romaneio_id = vpc.vale_pedagio_romaneio_id
					 inner join oper.v$vale_pedagio_operadora vpo
					    on vpo.vale_pedagio_operadora_id = vpr.vale_pedagio_operadora_id
					 where vpc.conhecimento_id = cte.conhecimento_id
				       and vpc.data_cancelamento is null
					) as vale_pedagio_operadora
				 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(to_char( p.cliente ), ',')) 
					  from oper.v$vale_pedagio_conhecimento vpc            
					 inner join oper.v$vale_pedagio_romaneio vpr
					    on vpr.vale_pedagio_romaneio_id = vpc.vale_pedagio_romaneio_id
					 inner join kss.v$pessoa p
					    on p.cod_pessoa = vpr.cod_pessoa_fornecedora
					 where vpc.conhecimento_id = cte.conhecimento_id
					   and vpc.data_cancelamento is null
					) as vale_pedagio_fornecedora
              from fiscal.v$conhecimento cte
        inner join fiscal.v$documento_cte dc
                on dc.conhecimento_id = cte.conhecimento_id
        inner join sefaz.v$documento_status ds
                on ds.documento_id = dc.documento_id
        inner join sefaz.documento d
                on d.documento_id = dc.documento_id
          left join (
               select max(m.mdfe_id) keep(dense_rank last order by mcte.data_emissao) mdfe_id
                    , max(m.cte_id) keep(dense_rank last order by mcte.data_emissao) cte_id
                 from fiscal.v$mdfe_cte m
                inner join fiscal.v$mdfe mcte
                   on mcte.mdfe_id = m.mdfe_id
                group by m.cte_id
                  ) mdfe
            on mdfe.cte_id = cte.conhecimento_id
          left join fiscal.v$mdfe m
            on m.mdfe_id = mdfe.mdfe_id
          left join fiscal.v$documento_mdfe mdoc
            on mdoc.mdfe_id = m.mdfe_id
          left join fiscal.v$documento_status mds
            on mds.documento_id = mdoc.documento_id          
	         where 1 = 1
             <cfif (Len(Trim(arguments.cte_id)))>
             	and cte.conhecimento_id = #arguments.cte_id#
             </cfif>
             <cfif (Len(Trim(arguments.situacao_id)) and (arguments.situacao_id neq '0,1,2,3,4,5'))>
             	and nvl(ds.situacao_id, 0) in(#arguments.situacao_id#)
             </cfif>
             <cfif Len(Trim(arguments.cod_pessoa_filial))>
             	and cte.cod_pessoa_filial = #arguments.cod_pessoa_filial#
             </cfif>
             <cfif Len(Trim(arguments.serie)) and Len(Trim(arguments.serie))>
                and cte.serie in (#ListQualify(arguments.serie,"'",",")#)
             </cfif>
             <cfif isDefined("arguments.conhecimento_tipo_id") and Len(Trim(arguments.conhecimento_tipo_id)) >
               and cte.conhecimento_tipo_id = #arguments.conhecimento_tipo_id#
             </cfif>
			 <cfif Len(Trim(arguments.num_cte))>
             	and cte.num_conhecimento = #arguments.num_cte#
             <cfelse>
				 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino)) and not Len(Trim(arguments.num_docto_fatura)) and not Len(Trim(arguments.num_romaneio_filtro)) and not Len(Trim(arguments.num_mdfe))>
                    and cte.data_emissao between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                 </cfif>
                 <cfif arguments.dacte_impresso eq 0>
                    and cte.impressao_dacte is null
                 <cfelseif arguments.dacte_impresso eq 1>
                    and cte.impressao_dacte is not null
                 </cfif>
           	 </cfif>
             <cfif Len(Trim(arguments.cod_centro_custo))>
             	and cte.cod_centro_custo = #arguments.cod_centro_custo#
             </cfif>
             <cfif Len(Trim(arguments.cod_remetente))>
             	and cte.cod_remetente = #arguments.cod_remetente#
             </cfif>
             <cfif Len(Trim(arguments.cod_destinatario))>
             	and cte.cod_destinatario = #arguments.cod_destinatario#
             </cfif>
             <cfif Len(Trim(arguments.cod_cliente_cobranca))>
             	and cte.cod_cliente_cobranca = #arguments.cod_cliente_cobranca#
             </cfif>
             <cfif Len(Trim(arguments.num_romaneio_filtro))>
             	and cte.num_romaneio = #arguments.num_romaneio_filtro#
             </cfif>
             <cfif Len(Trim(arguments.num_mdfe))>
             	and m.num_mdfe = #arguments.num_mdfe#
             </cfif>
             <cfif Len(Trim(arguments.num_docto_fatura))>
                and cte.conhecimento_id in (select cr.conhecimento_id
                                              from fiscal.v$conhecimento_receber cr
                                             inner join finan.v$finan_contas_receber fcr
                                                     on fcr.contas_receber_id = cr.contas_receber_id
                                             where fcr.num_docto =  '#arguments.num_docto_fatura#')
             </cfif>
           order by lpad(cte.serie,3,'0') asc , cte.num_conhecimento desc
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os CTE's para complementar
	-- Rafael 01/10/2010 16:18 - CRIADO
	--->
	<cffunction name="get_cte_complementar" displayname="Busca os CTE's para complementar" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no">
		<cfargument name="cod_departamento" required="no">
		<cfargument name="cod_setor" required="no">
		<cfargument name="cod_centro_custo" required="no">
        <cfargument name="serie" required="yes">
		<cfargument name="pagador" required="yes">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" required="no">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="coleta_municipio_id" required="no">
        <cfargument name="entrega_municipio_id" required="no">
		<cfquery datasource="#session.dsn#" name="qr_conhecimentos" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED USE_HASH(C IT) USE_HASH(IT LF)*/
                   c.num_romaneio
                 , c.conhecimento_id
                 , c.num_conhecimento
                 , case
                      when nvl(l.regra_fiscal_id, 1) = 1 then
                       c.total_conhecimento
                      when l.regra_fiscal_id in (2) then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 3 and c.pagador = 0 then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 3 and c.pagador = 1 then
                       c.total_conhecimento
                      when l.regra_fiscal_id = 7 and c.pagador = 0 then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 7 and c.pagador = 1 and
                           c.coleta_cod_uf = c.entrega_cod_uf then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 7 and c.pagador = 1 and
                           c.coleta_cod_uf <> c.entrega_cod_uf then
                       c.total_conhecimento
                      when l.regra_fiscal_id in (4, 13) and c.pagador = 0 then
                       c.total_conhecimento - ((c.valor_icms_substit + c.valor_icms) * 0.80)
                   -- Gerdal desconta 80% do ICMS
                      when l.regra_fiscal_id in (4, 13) and c.pagador = 1 then
                       c.total_conhecimento -- Gerdal se pagador destinatario no desconta ICMS
                      when l.regra_fiscal_id = 6 then
                       c.total_conhecimento + c.pedagio -- Coamo
                      when l.regra_fiscal_id = 8 and c.pagador = 0 then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 8 and c.pagador = 1 then
                       c.total_conhecimento
                      else
                       c.total_conhecimento
                   end total_conhecimento
                 , oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso
                 , c.m3
                 , oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
                 , c.frete_unitario
                 , (select m.municipio || '/' || m.uf_id
                      from oper.v$municipio m
                     where m.municipio_id = c.coleta_municipio_id) as carregamento
                 , (select m.municipio || '/' || m.uf_id
                      from oper.v$municipio m
                     where m.municipio_id = c.entrega_municipio_id) as destino
                 , (select distinct count(rit2.cod_destinatario)
                      from oper.v$romaneio_item rit2
                     where rit2.num_romaneio = c.num_romaneio) as total_entregas
              from fiscal.v$cte c
              left join oper.v$romaneio r
                     on c.num_romaneio = r.num_romaneio
              left join oper.v$romaneio_item it
                     on c.num_romaneio = it.num_romaneio
                    and c.item_id = it.item_id
              left join oper.v$lote l
                     on it.num_lote = l.num_lote
			 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			   and c.cod_departamento  = #arguments.cod_departamento#
			   and c.cod_setor         = #arguments.cod_setor#
			   and c.cod_centro_custo  = #arguments.cod_centro_custo#
			   and c.situacao_id <> 1
               and not exists (select 1
                                 from oper.v$conhecimento_complemento cc
                                where c.conhecimento_id = cc.conhecimento_complemento_id
                                   or c.conhecimento_id = cc.conhecimento_id)
			<cfif isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio))>
            	and c.num_romaneio = '#arguments.num_romaneio#'
            <cfelse>
				<cfif isDefined("arguments.serie") and Len(Trim(arguments.serie))>
                   and c.serie = '#arguments.serie#'
                </cfif>
                <cfif isDefined("arguments.coleta_municipio_id") and Len(Trim(arguments.coleta_municipio_id))>
                   and c.coleta_municipio_id = #arguments.coleta_municipio_id#
                </cfif>
                <cfif isDefined("arguments.entrega_municipio_id") and Len(Trim(arguments.entrega_municipio_id))>
                   and c.entrega_municipio_id = #arguments.entrega_municipio_id#
                </cfif>
                   and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.pagador#
                <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
                   and data_emissao between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_final# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                </cfif>
            </cfif>
			 order by c.num_conhecimento
		</cfquery>
		<cfreturn qr_conhecimentos>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os dados do CTE para Complementar
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_cte_complemento" access="remote" returntype="query" output="false">
		<cfargument name="conhecimento_id" required="yes" default="">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
               select c.num_conhecimento
                    , c.serie
                    , c.num_romaneio
                    , it.num_lote
                    , it.item_id
                    , to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao
                    , oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
                    , c.rem_razao_social as remetente
                    , c.dest_razao_social as destinatario
                    , c.m3
                    , oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso
                    , oper.pkg_operacional.fnc_converte_peso(c.peso_cobrado, 'Kg', c.cod_unidade) as peso_cobrado
                    , c.volume
                    , c.frete_unitario
                    , 0 as valor_mercadoria
                    , c.frete_valor
                    , c.despacho
                    , c.ademe
                    , c.desconto
                    , c.coleta_entrega
                    , c.impostos
                    , case
                          when nvl(l.regra_fiscal_id, 1) = 1 then
                           c.total_conhecimento
                          when l.regra_fiscal_id in (2) then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 3 and c.pagador = 0 then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 3 and c.pagador = 1 then
                           c.total_conhecimento
                          when l.regra_fiscal_id = 7 and c.pagador = 0 then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 7 and c.pagador = 1 and
                               c.coleta_cod_uf = c.entrega_cod_uf then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 7 and c.pagador = 1 and
                               c.coleta_cod_uf <> c.entrega_cod_uf then
                           c.total_conhecimento
                          when l.regra_fiscal_id in (4, 13) and c.pagador = 0 then
                           c.total_conhecimento - ((c.valor_icms_substit + c.valor_icms) * 0.80)
                       -- Gerdal desconta 80% do ICMS
                          when l.regra_fiscal_id in (4, 13) and c.pagador = 1 then
                           c.total_conhecimento -- Gerdal se pagador destinatario no desconta ICMS
                          when l.regra_fiscal_id = 6 then
                           c.total_conhecimento + c.pedagio -- Coamo
                          when l.regra_fiscal_id = 8 and c.pagador = 0 then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 8 and c.pagador = 1 then
                           c.total_conhecimento
                          else
                           c.total_conhecimento
                       end total_conhecimento
                    , c.base_calculo_icms
                    , c.aliquota_icms
                    , c.valor_icms
                    , nvl(l.frete_em, 'PESO') as frete_em
                    , (select uf.sigla_uf
                         from cep.cep_ufs uf
                        where uf.cod_uf = c.entrega_cod_uf) as entrega_uf
                    , (select uf.sigla_uf
                         from cep.cep_ufs uf
                        where uf.cod_uf = c.coleta_cod_uf) as coleta_uf
                    , c.pagador
                    , c.cod_unidade
                    , c.num_produto
                    , c.num_natureza
                    , c.cod_remetente
                    , c.cod_destinatario
                    , c.st_icms_id
                 from fiscal.v$cte c
                inner join oper.v$romaneio r
                   on c.num_romaneio = r.num_romaneio
                inner join oper.v$romaneio_item it
                   on c.num_romaneio = it.num_romaneio
                  and c.item_id = it.item_id
                 left join oper.v$lote l
                   on it.num_lote = l.num_lote
                  and c.item_id = it.item_id
                where c.conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os pagadores com conhecimento em aberto para determinada agencia
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_pagador_cte" displayname="Busca os pagadores com conhecimento em aberto para determinada agencia" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
	    <cfargument name="cod_departamento" required="no">
	    <cfargument name="cod_setor" required="no">
		<cfargument name="cod_centro_custo" required="no"/>
		<cfargument name="serie" required="yes"/>
		<cfargument name="data_inicial" required="no"/>
		<cfargument name="data_final" required="no"/>
		<cfargument name="complemento" required="no"/>
		<cfargument name="ORGANOGRAMA" required="no" default=""/>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.ORGANOGRAMA,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.ORGANOGRAMA,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.ORGANOGRAMA,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.ORGANOGRAMA,4,'_')>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
        select x.pagador
             , p.razao_social
             , p.cnpj_cpf as codigo
             , oper.pkg_global.fnc_mascara_cnpj_cpf(p.cod_pessoa) as cnpj_cpf
             , pep.municipio
             , pep.uf
          from (select distinct decode(c.pagador, 0, c.cod_remetente, c.cod_destinatario) as pagador
                  from fiscal.v$cte c
                 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                   and c.cod_departamento  = #arguments.cod_departamento#
                   and c.cod_setor         = #arguments.cod_setor#
                   and c.cod_centro_custo  = #arguments.cod_centro_custo#
                   and c.situacao_id <> 1
			   <cfif arguments.serie neq 0>
				   and c.serie = '#arguments.serie#'
			   </cfif>
			   <cfif not isDefined("arguments.complemento")>
				   and not exists (select 'x'
									 from oper.v$cte_emitido_receber cr
									where c.conhecimento_id = cr.conhecimento_id)
			   </cfif>
			   <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
			  	  and data_emissao between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss')and to_date('#arguments.data_final# 23:59:59','dd/mm/yyyy hh24:mi:ss')
			   </cfif>
               ) x
      inner join kss.v$pessoa p
              on p.cod_pessoa = x.pagador
      inner join kss.v$pessoa_endereco_padrao pep
              on pep.cod_pessoa = p.cod_pessoa
        order by p.razao_social
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os locais de coleta e entrega
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_coleta_entrega" displayname="Busca os locais de coleta e entrega" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" />
		<cfargument name="cod_setor" 		 required="no" />
		<cfargument name="serie" 			 required="yes" />
		<cfargument name="clientes" 		 required="yes" />
		<cfargument name="coleta_entrega"    displayname="FLAG - 0 Coleta 1 Entrega" required="no" default="0">
		<cfargument name="data_inicial" 	 required="no" default="" />
		<cfargument name="data_final" 		 required="no" default=""/>
		<cfargument name="organograma" required="no" default="">
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select distinct m.uf_id, m.municipio, m.municipio_id as municipio_id
			  from fiscal.v$cte c
			  <cfif arguments.coleta_entrega eq 0>
		     inner join oper.v$municipio m
                     on m.municipio_id = c.coleta_municipio_id
			  <cfelse>
			 inner join oper.v$municipio m
                     on m.municipio_id = c.entrega_municipio_id
			  </cfif>
				 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                   and c.cod_departamento  = #arguments.cod_departamento#
                   and c.cod_setor         = #arguments.cod_setor#
                   and c.cod_centro_custo  = #arguments.cod_centro_custo#
                   and c.situacao_id <> 1
			  <cfif isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio))>
                   and c.num_romaneio = '#arguments.num_romaneio#'
              <cfelse>
				  <cfif arguments.serie neq 0>
                       and c.serie = '#arguments.serie#'
                  </cfif>
                  <cfif Len(Trim(arguments.DATA_INICIAL)) and Len(Trim(arguments.DATA_FINAL))>
                       and data_emissao between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_final# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                  </cfif>
                  <cfif Len(Trim(arguments.clientes))>
                       and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.clientes#
                  </cfif>
              </cfif>
                and not exists (select 1
                                  from oper.v$conhecimento_complemento cc
                                 where c.conhecimento_id = cc.conhecimento_complemento_id
                                    or c.conhecimento_id = cc.conhecimento_id)
			  order by m.uf_id, m.municipio
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca relaes de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_relacao_aberto" displayname="Busca relaes de complemento em aberto" access="remote" returntype="query" output="true">
        <cfargument name="relacao_id" required="no" default="" />
        <cfargument name="pagador" required="no" default="" />
        <cfargument name="todas" displayname="FLAG que indica a consulta por todas as relaes" required="no" />
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */
                   cc.relacao_id
                 , cc.conhecimento_id
                 , c.num_romaneio as num_romaneio
                 , decode(c.pagador, 0, c.cod_remetente, c.cod_destinatario) as pagador
                 , decode(c.pagador, 0, c.rem_razao_social, c.dest_razao_social) as razao_social
                 , decode(c.pagador, 0, oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente)
                 , oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario)) as cnpj_cpf
                 , c.num_conhecimento
                 , oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso_lancado
                 , oper.pkg_operacional.fnc_converte_peso(c.peso + cc.peso,'Kg',c.cod_unidade) as peso_correto
                 , c.m3 as m3_lancado
                 , c.m3 + cc.m3 as m3_correto
                 , cc.volume
                 , cc.m3
                 , c.frete_unitario as unit_lancado
                 , cc.valor_unitario as unit_correto
                 , c.frete_valor as frete_lancado
                 , cc.valor_frete_liquido + c.frete_valor as frete_correto
                 , cc.valor_frete_liquido as diferenca
                 , cc.cod_unidade
                 , oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
                 , c.cod_pessoa_filial
                 , c.cod_setor
                 , decode(cc.situacao, 1, 'Fechada', 'Aberta') as situacao
              from fiscal.v$conhecimento_complemento cc
             inner join fiscal.v$cte_emitido c
                on cc.conhecimento_id = c.conhecimento_id
             <cfif not isDefined("arguments.todas")>
                 inner join oper.v$kss_usuario_lotacao ul
                    on c.cod_pessoa_filial = ul.cod_pessoa
                   and ul.cod_aplicacao = 'EMISSAO_DOCUMENTO'
             </cfif>
             where 1=1
             <cfif not isDefined("arguments.todas")>
              and cc.situacao = 0
             </cfif>
             <cfif Len(Trim(arguments.RELACAO_ID))>
               and cc.relacao_id = #arguments.RELACAO_ID#
             </cfif>
             <cfif Len(Trim(arguments.pagador))>
               and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.pagador#
             </cfif>
            order by razao_social, cc.relacao_id , c.num_conhecimento
		</cfquery>
		<cfreturn qr_relacao_complemento>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os dados das relaes de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_relacao_dados" displayname="Busca os dados das relaes de complemento em aberto" access="remote" returntype="query" output="true">
		<cfargument name="relacao_id" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
            select c.rem_razao_social
                 , c.rem_uf
                 , c.rem_municipio
                 , c.dest_razao_social
                 , c.dest_municipio
                 , c.dest_uf
                 , c.cod_destinatario
                 , c.entrega_cod_uf
                 , c.entrega_cod_municipio
                 , c.entrega_cod_distrito
                 , c.entrega_cod_dv
                 , oper.fnc_monta_observacao_ctrc(c.num_romaneio) as observacao
              from fiscal.v$cte c
             where c.conhecimento_id = (select max(cc.conhecimento_id)
                                          from fiscal.v$conhecimento_complemento cc
                                         where cc.relacao_id = #arguments.RELACAO_ID#)
		</cfquery>
		<cfreturn qr_relacao_complemento>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os dados das relaes de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_nfe" displayname="Busca as NFE's Integradas" access="remote" returntype="query">
        <cfargument name="tipo_nfe" required="no" default="0" hint="0 - Todas / 1 - Transporte / 2 - Terceiro"/>
        <cfargument name="cpf_cnpj_destinatario" required="no" default=""/>
        <cfargument name="cpf_cnpj_emitente" required="no" default=""/>
        <cfargument name="documento_id" required="no" default=""/>
        <cfargument name="status_id" required="no" default="1"/>
        <cfargument name="chave" required="no" default=""/>
		<cfargument name="num_manifesto" required="no" default=""/>
		<cfargument name="avon" required="no" default="0"/>
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
            select ed.documento_id
                 , ed.email_id
                 , ed.tipo_documento_id as tipo_documento
                 , ed.chave
                 , substr(ed.chave, 4) as chave_numerica
                 , to_char(ed.numero_documento) as numero_documento
                 , ed.serie_documento
                 , ed.modelo_documento
                 , to_char(ed.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , ed.valor
                 , (select nvl(sum(peso),0)
                      from xmltable( XMLNamespaces(default 'http://www.portalfiscal.inf.br/nfe')
                                   , '//nfeProc/NFe/infNFe/transp/vol'
                                   passing xmltype.createxml((select dx.xml
                                                                from fiscal.v$integracao_documento_xml dx
                                                               where dx.integracao_documento_id = ed.integracao_documento_id
                                                                 and dx.em_vigor = 1))
                                   columns peso    number PATH 'pesoB')) as peso
                 , (select nvl(sum(peso),0)
                      from xmltable( XMLNamespaces(default 'http://www.portalfiscal.inf.br/nfe')
                                   , '//nfeProc/NFe/infNFe/transp/vol'
                                   passing xmltype.createxml((select dx.xml
                                                                from fiscal.v$integracao_documento_xml dx
                                                               where dx.integracao_documento_id = ed.integracao_documento_id
                                                                 and dx.em_vigor = 1))
                                   columns peso    number PATH 'pesoL')) as peso_liquido
                 , nvl(ed.cod_unidade, 'Kg') as cod_unidade
				 , ed.peso_utilizado
				 , decode(ed.cod_unidade
                        , 'TON'
                        , decode(ed.peso_utilizado, 'Lquido', ed.peso_liquido, ed.peso) * 1000
                        , decode(ed.peso_utilizado, 'Lquido', ed.peso_liquido, ed.peso)
                          ) as peso_calculado
			     , decode(ed.peso_utilizado, 'Lquido', ed.peso_liquido, ed.peso) as peso_calc
                 <cfif Len(Trim(arguments.num_manifesto)) or arguments.avon eq 1>
				 , n.volumes as volume
				 <cfelse>
				 ,(select min(volumes)
                     from xmltable(XMLNamespaces(default 'http://www.portalfiscal.inf.br/nfe')
                                   , '//nfeProc/NFe/infNFe/transp/vol'
                                   passing xmltype(dx.xml)
                                   columns volumes number PATH 'qVol')) as volume
                 </cfif>
				 , nvl(ed.especie, '-- NO INFORMADA -- ')  as especie
                 , ed.num_especie
                 , nvl((select e.descricao
                        from oper.v$especie e
                       where e.num_especie = ed.num_especie)
                    ,'-- NO MAPEADA -- ') as especie_mapeada
                 , ed.cfop
                 , kss.pkg_string.fnc_formata_cnpj_cpf(ed.cpf_cnpj_emitente) as cpf_cnpj_emitente
                 , ed.razao_social_emitente
                 , kss.pkg_string.fnc_formata_cnpj_cpf(ed.cpf_cnpj_destinatario) as cpf_cnpj_destinatario
                 , ed.razao_social_destinatario
                 , ed.status_id
                 , kss.fnc_ref_code('SEFAZ', 'EMAIL_DOCUMENTO.STATUS_ID', ed.status_id) as status
                 <cfif Len(Trim(arguments.num_manifesto)) or arguments.avon eq 1>
				 , null as placa
                 , null as pedido_shippment
                 , null as placa
                 , null as pedido_shippment
                 , 0 as icms_partilhado
				 <cfelse>
				 , (select extractvalue(xmltype(dx.xml),'nfeProc/NFe/infNFe/transp/veicTransp/placa','xmlns="http://www.portalfiscal.inf.br/nfe"')
                      from fiscal.v$integracao_documento_xml dx
                     where dx.integracao_documento_id= ed.integracao_documento_id
                       and dx.em_vigor = 1
                   ) as placa
                 , (select extractvalue(xmltype(dx.xml),'nfeProc/NFe/infNFe/infAdic/obsCont[@xCampo="DT"]/xTexto','xmlns="http://www.portalfiscal.inf.br/nfe"')
                      from fiscal.v$integracao_documento_xml dx
                     where dx.integracao_documento_id= ed.integracao_documento_id
                       and dx.em_vigor = 1
                  ) as pedido_shippment
                 , extractvalue(xmltype(dx.xml),'nfeProc/NFe/infNFe/transp/veicTransp/placa','xmlns="http://www.portalfiscal.inf.br/nfe"') as placa
                 , extractvalue(xmltype(dx.xml),'nfeProc/NFe/infNFe/infAdic/obsCont[@xCampo="DT"]/xTexto','xmlns="http://www.portalfiscal.inf.br/nfe"') as pedido_shippment
                 , case
                      when existsnode(xmltype.createxml(dx.xml),'//ICMSUFDest','xmlns="http://www.portalfiscal.inf.br/nfe"') = 1
                         and extractvalue(xmltype.createxml(dx.xml),'//pFCPUFDest','xmlns="http://www.portalfiscal.inf.br/nfe"') > 0 then 1
                      else 0
                   end as icms_partilhado
				 </cfif>
              from sefaz.v$email_documento ed
			  <cfif Len(Trim(arguments.num_manifesto))>
			 inner join ediavon.v$nfe n
               on 'NFe' || n.accesskey = ed.chave
              and n.num_manifesto = #arguments.num_manifesto#
			  </cfif>

			   <cfif arguments.avon eq 1>
			 inner join ediavon.v$nfe n
               on 'NFe' || n.accesskey = ed.chave
			  </cfif>

              left join fiscal.v$integracao_documento_xml dx
                on dx.integracao_documento_id= ed.integracao_documento_id
               and dx.em_vigor = 1
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_nfe))>
              <cfif arguments.tipo_nfe eq 1>
              and (ed.cpf_cnpj_destinatario is null or
                   ed.cpf_cnpj_destinatario not in (select p.cnpj_cpf
                                                      from kss.v$unidade_negocio u
                                                     inner join kss.v$pessoa p
                                                        on p.cod_pessoa = u.cod_pessoa))
              <cfelseif arguments.tipo_nfe eq 2>
              and ed.cpf_cnpj_destinatario in (select p.cnpj_cpf
                                                 from kss.v$unidade_negocio u
                                                inner join kss.v$pessoa p
                                                   on p.cod_pessoa = u.cod_pessoa)
              </cfif>
            </cfif>
            <cfif Len(Trim(arguments.cpf_cnpj_destinatario)) and not Len(Trim(arguments.num_manifesto))>
			  and ((ed.cpf_cnpj_destinatario = '#arguments.cpf_cnpj_destinatario#') or (ed.razao_social_destinatario = (select pe.nome
                                                                                                                        from kss.v$pessoa p
                                                                                                                       inner join kss.v$pessoa_estrangeira pe
                                                                                                                          on pe.cod_pessoa = p.cod_pessoa
                                                                                                                       where p.identificador = '#arguments.cpf_cnpj_destinatario#')))
            </cfif>
            <cfif Len(Trim(arguments.cpf_cnpj_emitente))>
              and ed.cpf_cnpj_emitente = '#arguments.cpf_cnpj_emitente#'
            </cfif>
            <cfif Len(Trim(arguments.documento_id))>
              and ed.documento_id in(#arguments.documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.status_id))>
              and ed.status_id = #arguments.status_id#
            </cfif>
            <cfif Len(Trim(arguments.chave))>
               and substr(ed.chave,4) = '#arguments.chave#'
            </cfif>
            order by ed.data_emissao desc
		</cfquery>
		<cfreturn qr_relacao_complemento>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os dados resumidos do CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 01/12/2010
	--->
	<cffunction name="get_cte_resumo" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select dc.documento_id
            	 , c.conhecimento_id

                 , c.num_conhecimento
                 , c.serie
                 , (select d.chave
                      from fiscal.v$dacte d
                     where d.documento_id = dc.documento_id) as chave_cte
                 , ds.cod_status
                 , ds.situacao_id
                 , ds.descricao_status
                 , ds.descricao_situacao
                 , ds.permite_editar
                 , ds.permite_inutilizar
                 , ds.emitido
				 , d.tipo_emissao_id
                 , c.liberado_impressao
                 , c.num_romaneio
                 , case when c.substituto = 1 or
                             (select sign(count(1))
                               from fiscal.v$conhecimento_complemento cc
                              where cc.conhecimento_complemento_id = c.conhecimento_id) = 1
                        then 0 else fiscal.pkg_mdfe.fnc_permite_emissao(c.num_romaneio)
                   end as permite_mdfe
                 , c.placa_tracao
                 , instr(upper(kss.pkg_parametro.fnc_valor_lista_multi(p_identificador => 'M309-P0198')), upper(ds.descricao_situacao)) as parametro_status_incluso
              from fiscal.v$conhecimento c
             inner join fiscal.v$documento_cte dc
                on dc.conhecimento_id = c.conhecimento_id
             inner join sefaz.documento d
                on d.documento_id = dc.documento_id
             inner join sefaz.v$documento_status ds
               on ds.documento_id = dc.documento_id
             where c.conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca o Ambiente de Emisso de CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 01/12/2010
	--->
	<cffunction name="get_cte_ambiente" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select fiscal.pkg_sefaz_cte.fnc_ambiente(#arguments.cod_pessoa_filial#) as ambiente
  			  from dual
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca se est Autorizado a emitir CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 14/05/2011
	--->
	<cffunction name="get_emite_cte" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select fiscal.pkg_sefaz_cte.fnc_emite_docto_fiscal(#arguments.cod_pessoa_filial#) as emite_cte
  			  from dual
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca documentos do pagador
	-- RAFAEL 01/12/2010
	--->

	<cffunction name="get_documentos_acerto_financeiro" access="remote" returntype="query" output="true">
		<cfargument name="cod_remetente" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_documentos_pagador" username="#session.usuario#" password="#session.senha#">
			   select cf.cod_documento
                   , dc.documento
                   , cf.num_romaneio
                   , to_char(cf.data_emissao, 'dd/mm/yyyy') as data_emissao
                   , cf.volume
                   , oper.pkg_operacional.fnc_converte_peso(cf.peso, 'Kg', cf.cod_unidade) peso
                   , cf.valor_unitario
                   , cf.valor_frete_liquido
                   , cf.valor_frete_bruto
                   , cf.lancto_id
                   , d.cod_pessoa destinatario
                   , d.nome_fantasia nome_destinatario
                   , oper.pkg_global.fnc_mascara_cnpj_cpf(d.codigo) cnpj_cpf_destinatario
                   , ri.cod_remetente
                   , d.municipio
                from oper.v$carta_frete cf
               inner join oper.v$remetente_destinatario d
                  on d.cod_pessoa = cf.cod_destinatario
               inner join oper.v$documento_frete dc
                  on dc.documento_id = cf.tipo_docto
               inner join oper.v$romaneio_item ri
                  on ri.num_romaneio = cf.num_romaneio
                 and ri.item_id = cf.item_id
               inner join oper.v$romaneio r
                  on r.num_romaneio = cf.num_romaneio
                 and r.situacao_id = 2
            <cfif Len(Trim(arguments.cod_remetente))>
                 and ri.cod_remetente = #arguments.cod_remetente#
            </cfif>
               where cf.conhecimento_id is null
                 and cf.crt_receber_id is null
            <cfif len(trim(arguments.num_romaneio))>
                 and cf.num_romaneio = #arguments.num_romaneio#
            </cfif>
            <cfif len(trim(arguments.data_inicial))>
                 and trunc(r.data_inicio) >= trunc(to_date('#arguments.data_inicial#', 'dd/mm/yyyy hh24:mi:ss'))
            </cfif>
            <cfif len(trim(arguments.data_final))>
                 and trunc(r.data_termino) <= trunc(to_date('#arguments.data_final#', 'dd/mm/yyyy hh24:mi:ss'))
            </cfif>
            order by cf.data_emissao
 		</cfquery>
		<cfreturn qr_documentos_pagador>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca a Mensagem de Alerta do CTE
	-- RAFAEL 01/12/2010
	--->
	<cffunction name="get_mensagem_cte" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
        <cfquery datasource="#session.dsn#" name="qr_mensagem" username="#session.usuario#" password="#session.senha#">
			   select fiscal.pkg_sefaz_cte.fnc_consulta_contingencia(p_cnpj_cpf => '',
               														 p_cod_pessoa => #arguments.cod_pessoa_filial#) as mensagem
                 from dual
 		</cfquery>
		<cfreturn qr_mensagem>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as filiais
	-- RAFAEL 14/03/2011
	--->
	<cffunction name="get_filial" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="todos" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select un.cod_pessoa
                 , un.unidade_negocio nome
                 , fiscal.pkg_sefaz_cte.fnc_consulta_contingencia('',un.cod_pessoa) as mensagem_contingencia
              from kss.v$unidade_negocio un
             inner join kss.v$pessoa p
                on p.cod_pessoa = un.cod_pessoa
             inner join sefaz.v$emitente_ambiente ea
                on ea.cnpj_cpf = p.cnpj_cpf
             where 1 = 1
             <cfif arguments.todos eq 0>
             	and ea.emite_docto_fiscal = 1
             </cfif>
             <cfif len(trim(arguments.operacao_id))>
			 		and un.cod_pessoa in (select o.cod_pessoa
                    						from logistica.v$operacao_filial_emissao ofe
                                           inner join kss.v$organograma o
                                           		   on o.cod_organograma = ofe.cod_organograma
                                           where ofe.operacao_id = #arguments.operacao_id#)
             </cfif>
             order by un.unidade_negocio
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Retorna o XML de Envio de um CTe
    -- RAFAEL 24/01/2011 - CRIADO
    --->
    <cffunction name="get_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="documento_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sefaz.pkg_sefaz.fnc_xml_distribuicao(#arguments.documento_id#) as xml_sefaz
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os motivos de Substituio de CTe
    -- RAFAEL 13/06/2013 - CRIADO
    --->
    <cffunction name="get_motivo_subst" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.motivo_substituicao_id
                 , m.descricao
              from fiscal.v$motivo_substituicao m
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os motivos de Cancelamento de CTe
    -- JAQUELINEF 03/04/2014 - CRIADO
    --->
    <cffunction name="get_motivo_cancelamento" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.motivo_cancelamento_id
                 , m.descricao
              from fiscal.v$motivo_cancelamento m
				 where m.ativo = 1
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os motivos de Inutilizao de CTe
    -- JAQUELINEF 03/04/2014 - CRIADO
    --->
    <cffunction name="get_motivo_inutilizacao" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.motivo_inutilizacao_id
                 , m.descricao
              from fiscal.v$motivo_inutilizacao m
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna o tipo de servio do CT-e
    -- JAQUELINEF 07/04/2014 - CRIADO
    --->
    <cffunction name="get_tipo_servico" access="remote" returntype="query" output="true">
    	<cfargument name="cod_remetente" required="yes" />
    	<cfargument name="coleta_cod_pessoa" required="yes" />
    	<cfargument name="cod_cliente_cobranca" required="yes" />
    	<cfargument name="operacao_id" required="yes" />
    	<cfargument name="cod_endereco_cob" required="yes" />
    	<cfargument name="solicitacao_carga_id" required="no" />
    	<cfargument name="modal" required="no" />
    	<cfargument name="cod_pessoa_filial" required="no" />
    	<cfargument name="cod_destinatario" required="no" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fiscal.pkg_cte.fnc_tipo_servico(p_cod_remetente        => #arguments.cod_remetente#
                                                 , p_coleta_cod_pessoa    => #arguments.coleta_cod_pessoa#
                                                 , p_cod_cliente_cobranca => #arguments.cod_cliente_cobranca#
                                                 , p_operacao_id          => #arguments.operacao_id#
                                                 , p_cod_endereco_cob     => #arguments.cod_endereco_cob#
                                                 , p_solicitacao_carga_id => <cfif len(trim(arguments.solicitacao_carga_id))>#arguments.solicitacao_carga_id# <cfelse> null </cfif>
                                                 , p_modal                => <cfif len(trim(arguments.modal))>#arguments.modal# <cfelse> 1 </cfif>
												 , p_cod_pessoa_filial    => <cfif len(trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial# <cfelse> null </cfif>
												 , p_cod_destinatario     => <cfif len(trim(arguments.cod_destinatario))>#arguments.cod_destinatario# <cfelse> null </cfif>
												 ) as tpServ
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>





 <!---
   -- PROPSITO
   -- Retorna as tags criadas pelo usurio para o XML  do CT-e
   -- RICARDOC 09/01/2014 - CRIADO
   --->
	 <!---  op.valor_padrao -- compatibilidade  para buscar a lista de valores   --->
   <cffunction name="get_tags_cte" access="remote" returntype="query" output="true">
      <cfargument name="conhecimento_id" required="no"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      	select co.conhecimento_obs_contrib_id
			 , co.conhecimento_id
     		 , co.operacao_obs_contrib_id
      		 , co.valor
     		 , op.valor_padrao
     		 , op.operacao_id
      		 , op.ordem
       		 , op.descricao
     		 , op.obrigatorio
			 , op.obrigatorio_complemento
             , decode(op.obrigatorio, 0, 'No', 'Sim') as obrigatorio_str
			 , decode(op.obrigatorio_complemento, 0, 'No', 'Sim') as obrigatorio_cpl_str
		     , op.tipo
   		  from fiscal.v$conhecimento_obs_contrib co
 		 inner join logistica.v$operacao_obs_contrib op
    		on op.operacao_obs_contrib_id = co.operacao_obs_contrib_id
	     inner join logistica.v$operacao_obs_contrib_setup ocs
            on ocs.tipo = op.tipo
            <cfif Len(Trim(arguments.conhecimento_id))>
               where co.conhecimento_id = #arguments.conhecimento_id#
           and op.tipo in ('MANUAL', 'XCARACAD', 'XCARACSER', 'LISTA_VALORES')
                 and ocs.exibe_emissao = 1
            <cfelse>
               where 1 = 0
            </cfif>

         order by op.ordem
        </cfquery>
        <cfreturn qr_result>
   </cffunction>


   <!---
   -- PROPSITO
   -- Retorna os valores das tags criadas pelo usurio para o XML  do CT-e
   -- RICARDOC 09/01/2014 - CRIADO
   --->
   <cffunction name="get_tags_operacao" access="remote" returntype="query" output="true">
      <cfargument name="operacao_id" required="yes"/>
	 <cfargument name="utilizado_em" required="no" default="">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	select o.operacao_obs_contrib_id
               , o.operacao_id
               , o.ordem
               , o.descricao
               , o.valor_padrao
               , o.obrigatorio
			   , o.obrigatorio_complemento
               , decode(o.obrigatorio, 0, 'No', 'Sim') as obrigatorio_str
		     , o.tipo
			   , decode(o.obrigatorio_complemento, 0, 'No', 'Sim') as obrigatorio_cpl_str
            from logistica.v$operacao_obs_contrib o
         inner join logistica.v$operacao_obs_contrib_setup ocs
            on ocs.tipo = o.tipo
           where o.operacao_id = #arguments.operacao_id#
           and ocs.exibe_emissao = 1
           and o.tipo in ('MANUAL', 'XCARACAD', 'XCARACSER', 'LISTA_VALORES')

		 <cfif Len(Trim(arguments.utilizado_em))>
           and o.utilizado_em in (#arguments.utilizado_em#, 0 )
		 </cfif>
           order by o.ordem
        </cfquery>
        <cfreturn qr_result>
   </cffunction>


      <!---
   -- PROPSITO
   -- Busca a lista de valores da tag informada
   -- LUIZG 16/02/2018 - CRIADO
   --->
   <cffunction name="get_tags_operacao_lista_valores" access="remote" returntype="query" output="true">
      <cfargument name="operacao_tag_lista_id" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select t.operacao_tag_lista_it_id
		     , t.valor
		     , t.descricao
		  from logistica.v$operacao_tag_lista_it t
		 where 1 = 1
		 <cfif Len(Trim(arguments.operacao_tag_lista_id))>
             and t.operacao_tag_lista_id  = #arguments.operacao_tag_lista_id#
         <cfelse>
		     and 1 = 0
         </cfif>

		 order by t.descricao
        </cfquery>
        <cfreturn qr_result>
   </cffunction>




      <!---
   -- PROPSITO
   -- Controla a exibio da tela das tags do CT-e
   -- RICARDOC 20/01/2014 - CRIADO
   --->
   <cffunction name="get_controle_recursos" access="remote" returntype="query" output="true">
      <cfargument name="cod_recurso" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	 select kss.pkg_controle.fnc_recurso_ativo(p_cod_recurso => '#arguments.cod_recurso#') as result
           from dual
        </cfquery>
        <cfreturn qr_result>
   </cffunction>

   <!---
   -- PROPSITO
   -- Retorna o XML do Danfe
   -- VICTOR 20/11/2015 - CRIADO
   --->
   <cffunction name="get_xml_danfe" access="remote" returntype="query" output="true">
    	<cfargument name="documento_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sefaz.pkg_email_nfe_impressao.fnc_visualizar_xml(#arguments.documento_id#) as arquivo
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

   <!---
	-- PROPSITO
	-- Gerar PDF do DANFE
	-- VICTOR 20/11/2015 - CRIADO
	--->
	<cffunction name='gerar_danfe' displayname='Gerar PDF do DACTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='sefaz.pkg_email_nfe_impressao.prc_gerar_danfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('DANFe gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Retorna se o ambiente de emisso esta em modo FSDA (contingencia)
    -- Matheus Barbosa 24/08/2017 - CRIADO
    --->
    <cffunction name="get_ambiente_emissao" access="remote" returntype="query" output="true">
    	<cfquery name="qr_empresa" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cnpj_cpf
              from kss.v$empresa e
             inner join kss.v$pessoa p
                on p.cod_pessoa = e.cod_pessoa
             inner join kss.v$pessoa_endereco_padrao t
                on t.cod_pessoa = p.cod_pessoa
        </cfquery>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.fsda as ambiente_fsda
             from sefaz.v$emitente_ambiente e
            where e.cnpj_cpf = '#qr_empresa.cnpj_cpf#'
              and e.cod_docto like 'MDFE'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPSITO
    -- Buscar dados do XML do CTe
    -- Nicolle 16/08/2017
    --->
    <cffunction name='get_dados_cte_xml' displayname='Buscar dados da NFE' access='remote' returntype='Struct' output='true'>
        <cfargument name='CTE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_cte.prc_dados_cte_xml' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'  value='#arguments.CTE#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CHAVE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.NUMERO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.SERIE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.SITUACAO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DATA_EMISSAO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.EMIT_CNPJ_CPF' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.EMIT_RAZAO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_CNPJ_CPF' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_IE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_RAZAO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO_NRO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO_BAIRRO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO_CMUN' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO_XMUN' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO_CEP' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO_UF' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.REM_ENDERECO_PAIS' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_CNPJ_CPF' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_IE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_RAZAO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO_NRO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO_BAIRRO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO_CMUN' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO_XMUN' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO_CEP' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO_UF' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.DEST_ENDERECO_PAIS' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MULTIMODAL' >
			</cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('XML do CTe lido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!---
	-- PROPSITO
	-- Retorna dizendo se cancelou vale pedgio durante o cancelamento de CT-e
	-- LEANDROSILVA 03/07/2018
	--->
	<cffunction name="verifica_vale_pedagio" displayname='Verifica se h vale pedgio no cancelado e vinculado ao CT-e' access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select sign(count(1)) as cancelar_vp_manual
			  from fiscal.v$conhecimento c
			 inner join oper.v$vale_pedagio_romaneio r
				on r.num_romaneio = c.num_romaneio
			 inner join oper.v$vale_pedagio_romaneio_it it
				on it.vale_pedagio_romaneio_id = r.vale_pedagio_romaneio_id
			 where c.conhecimento_id = #arguments.conhecimento_id#
			   and it.data_cancelamento is null
			   and it.vazio_carregado = 1
			   and exists(select 1
							from oper.v$vale_pedagio_conhecimento vpc
						   where vpc.conhecimento_id = c.conhecimento_id
							 and vpc.vale_pedagio_romaneio_id = r.vale_pedagio_romaneio_id
							 and vpc.data_cancelamento is null)
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
   <!---
   -- PROPSITO
   -- Retorna os ambientes de emisso
   -- NICOLLE 28/03/2018
   --->
   <cffunction name="get_ambiente" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct t.ambiente_id, t.descricao
			  from sefaz.v$ambiente t
			 where t.ambiente_id <> 0
			   and exists (select 0
							 from kss.system_data d, sefaz.v$emitente_ambiente ea
							where d.tipo_base <> 'P' or (ea.cod_docto = 'NFE' and ea.ambiente_id = t.ambiente_id))	
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
   <!---
   -- PROPSITO
   -- Retorna a imagem do captcha
   -- NICOLLE 28/03/2018
   --->
   <cffunction name="get_captcha" access="remote" returntype="query" output="true">
      <cfargument name="requisicao_id" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	select t.image
          from fiscal.v$integracao_doc_req t
           where t.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
   </cffunction>       
	
   <!---
   -- PROPSITO
   -- Retorna html do site
   -- NICOLLE 28/03/2018
   --->
   <cffunction name="get_html" access="remote" returntype="query" output="true">
      <cfargument name="requisicao_id" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	select t.html
          from fiscal.v$integracao_doc_req t
           where t.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
   </cffunction> 	
   
   <!---
   -- PROPSITO
   -- Retorna o imposto_documento_id que ir gerar o CPG para exibir mensagem ao confirmar CTe
   -- NICOLLE 28/03/2018
   --->
   <cffunction name="get_gera_CPG_ICMS_antecipado" access="remote" returntype="query" output="true">
      <cfargument name="conhecimento_id" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	select fiscal.pkg_conhecimento.fnc_imposto_icms_antecipado(p_conhecimento_id => #arguments.conhecimento_id#) as documento_imposto_id
          from dual 
        </cfquery>
        <cfreturn qr_result>
   </cffunction>
   
   <!--- 
	-- PROPSITO 
	-- Busca as filiais vinculadas ao usuario no grupo de acesso
	-- WELLINGTON  03/12/2018
	--->		
	<cffunction name="get_filial_usuario" access="remote" returntype="query" output="true">
		<cfargument name="web_url" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select un.cod_pessoa,
                   un.unidade_negocio nome
              from kss.v$unidade_negocio un
             where 1 = 1
			   and un.cod_pessoa in (select guf.cod_pessoa
									   from acesso.v$grupo_usuario_filial guf
									  inner join acesso.v$grupo_acesso_usuario gau
										 on gau.grupo_acesso_usuario_id = guf.grupo_acesso_usuario_id
									  where 1 = 1
										and upper(gau.usuario) = user
										and user <> 'ADMINCORP'
									    and (guf.cod_pessoa in (select pua.cod_pessoa
						 										  from kss.v$pessoa_usuario_aplicacao pua
															     where pua.cod_pessoa = guf.cod_pessoa)
											 or gau.acesso_irrestrito = 1)
								     union all
									 select un.cod_pessoa
								       from kss.v$unidade_negocio un
								      where 1 = 1
										and user = 'ADMINCORP')
                or exists (select 1
				             from acesso.v$grupo_acesso_usuario gau
							where upper(gau.usuario) = user
							  and gau.acesso_irrestrito = 1)
             order by un.unidade_negocio
		</cfquery>
		<cfreturn qr_result>
   </cffunction>
   
   <!---
   -- PROPSITO
   -- Retorna os documentos anteriores de um CT-e
   -- RAFAEL 03/12/2018
   --->
   <cffunction name="get_documentos_anteriores" access="remote" returntype="query" output="true">
      <cfargument name="conhecimento_id" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	select cda.cte_docto_anterior_id
			 , cda.chave
			 , cda.eletronico_papel
			 , cda.data_emissao
			 , cda.tipo
			 , cda.numero
			 , cda.serie
			 , cda.sub_serie
			 , cda.cod_emissor
			 , kss.pkg_pessoa.fnc_get_identificador(cda.cod_emissor, 1) as emissor_identificador
			 , kss.pkg_pessoa.fnc_get_cliente(cda.cod_emissor) as emissor_descricao
			 , kss.pkg_pessoa.fnc_get_identificador(cda.cod_emissor, 1) || ' - ' || kss.pkg_pessoa.fnc_get_cliente(cda.cod_emissor) as emissor
		  from fiscal.v$cte_docto_anterior cda
		 where cda.conhecimento_id = #arguments.conhecimento_id#
        </cfquery>
        <cfreturn qr_result>
   </cffunction>
   
   <!---
   -- PROPSITO
   -- Retorna os vale pedgio do CT-e
   -- RAFAEL 03/12/2018
   --->
   <cffunction name="get_cte_vale_pedagio" access="remote" returntype="query" output="true">
      <cfargument name="conhecimento_id" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
       	select cvp.conhecimento_vale_pedagio_id
			 , cvp.conhecimento_id
			 , cvp.ordem
			 , cvp.operadora_vale_pedagio as cod_pessoa_operadora
			 , kss.pkg_pessoa.fnc_get_identificador(cvp.operadora_vale_pedagio, 0) as cnpj_cpf_operadora
			 , kss.pkg_pessoa.fnc_get_cliente(cvp.operadora_vale_pedagio, 0) as operadora
			 , cvp.fornecedora_vale_pedagio as cod_pessoa_fornecedora
			 , kss.pkg_pessoa.fnc_get_identificador(cvp.fornecedora_vale_pedagio, 0) as cnpj_cpf_fornecedora
			 , kss.pkg_pessoa.fnc_get_cliente(cvp.fornecedora_vale_pedagio, 0) as fornecedora
			 , cvp.num_comprovante
			 , cvp.valor
			 , cvp.manual
			 , cvp.num_cartao_vale_pedagio
		  from fiscal.v$conhecimento_vale_pedagio cvp
		 where cvp.conhecimento_id = #arguments.conhecimento_id#
        </cfquery>
        <cfreturn qr_result>
   </cffunction>
   
   <!---
	-- PROPSITO
	-- Busca os itens de uma carta frete
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 02/12/2010
	--->
  	<cffunction name="get_carta_frete_nf" access="remote" returntype="query">
		<cfargument name="lancto_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_itens" username="#session.usuario#" password="#session.senha#">
			select to_char(cn.data_emissao,'dd/mm/yyyy') as data_emissao
                 , cn.modelo
                 , cn.serie
                 , cn.sub_serie
                 , cn.numero
                 , cn.valor_total
                 , cn.cfop
              from oper.v$carta_frete_nota_fiscal cn
			 where cn.lancto_id = #arguments.lancto_id#
			 order by numero
		</cfquery>
		<cfreturn qr_itens>
	</cffunction>

</cfcomponent>
