<cfcomponent extends="_transportes.consulta.cfc_contrato_transporte">
	<!--- 
	-- PROPSITO 
	-- Busca tipos de frete
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_tipo_frete" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select produto_id, descricao 
              from fiscal.v$produto t
	 		 where t.conhecimento = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Regras fiscais do Cliente
	-- Wagner //2006
	--->	
	<cffunction name="get_lote_regra_fiscal" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select distinct lr.regra_fiscal_id, lr.descricao
		      from fiscal.v$regra_fiscal lr
			where ativa = 1
		</cfquery>
		<cfreturn qr_lote>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca usurios que possuem alada para liberao
	--->
	<cffunction name="get_alcada_liberacao_controle" access="remote" returntype="query" output="true">
		<cfargument name="OPERACAO" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct al.operacao, al.usuario, u.nome
              from oper.v$alcada_liberacao_controle al
             inner join kss.v$kss_usuarios u
                     on u.usuario = al.usuario 
            where al.valor_alcada > 0
            <cfif Len(Trim(arguments.OPERACAO)) >
              and al.operacao in (#ListQualify(arguments.operacao, "'", ",")#)
            </cfif>
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
</cfcomponent>