<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de administrao" extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPSITO 
    -- Busca o centro custo
    -- NOTAS EXPLICATIVAS
    -- CRISTOFER  03/01/2006
    --->	
    <cffunction name="get_centro_custo" displayname="Busca o organograma" access="remote" returntype="query" output="true">
        <cfargument name="COD_PESSOA" 		required="no" default="">
        <cfargument name="COD_DEPARTAMENTO" required="no" default="">
        <cfargument name="COD_SETOR" 		required="no" default="">
        <cfargument name="COD_CENTRO_CUSTO" 		required="no" default="">
        <cfargument name="CENTRO_CUSTO" 		required="no" default="">
        <cfargument name="OPERACAO_ID" 		required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
            select /*+FIRST_ROWS*/ distinct c.cod_centro_custo, c.centro_custo
             from kss.v$organograma o 
            inner join kss.v$unidade_negocio u
               on o.cod_unidade_negocio = u.cod_unidade_negocio
            inner join kss.v$pessoa pj 
               on u.cod_pessoa = pj.cod_pessoa
            inner join kss.v$departamento d
               on o.cod_departamento = d.cod_departamento
            inner join kss.v$setor s
               on o.cod_setor = s.cod_setor				
            inner join kss.v$centro_custo c
               on o.cod_centro_custo = c.cod_centro_custo
            where 1=1
            <cfif len(trim(arguments.COD_PESSOA))>
              and u.cod_pessoa = #arguments.COD_PESSOA#
            </cfif>
            <cfif len(trim(arguments.COD_DEPARTAMENTO))>
              and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
            </cfif>
            <cfif len(trim(arguments.COD_SETOR))>
              and o.cod_setor = #arguments.COD_SETOR#
            </cfif>
            <cfif len(trim(arguments.COD_CENTRO_CUSTO))>
              and c.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
            </cfif>
            <cfif len(trim(arguments.CENTRO_CUSTO))>
              and upper(c.centro_custo) like upper('%#arguments.CENTRO_CUSTO#%')
            </cfif>
            <cfif len(trim(arguments.operacao_id))>
              and c.cod_centro_custo in (select o.cod_centro_custo
                                           from logistica.v$operacao_filial_emissao ofe
                                           inner join kss.v$organograma o
                                                   on o.cod_organograma = ofe.cod_organograma                                                   
                                           where ofe.operacao_id = #arguments.operacao_id#)
            </cfif>  
            order by c.centro_custo
        </cfquery>
        <cfreturn qr_organograma>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a UF da filial selecionada
	-- NOTAS EXPLICATIVAS
	-- RAFAEL  14/09/2009	
	--->	
	<cffunction name="get_filial_uf" displayname="Busca a UF da filial selecionada" access="remote" returntype="query" output="true">
		<cfargument name="COD_PESSOA" 		required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
			select uf
			  from oper.v$filial t
			 where 1=1
			<cfif len(trim(arguments.COD_PESSOA))>
			   and t.cod_pessoa = #arguments.COD_PESSOA#
			</cfif>
		</cfquery>
		<cfreturn qr_organograma>
	</cffunction>

</cfcomponent>	