<cfcomponent displayname="Componentes de consulta para controle de trfego"
		     extends="_transportes.funcoes.cfc_init"
			 hint="<b>KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Guto ( guto@kmm.com.br )</b><br>
				   <b>Data Criao</b> 		: 18/11/2004<br>
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br>
				   <b>Descrio				: </b><br> <div align='justify'>Componente de controle de acesso de usuario, com a nova estrutura de acesso.</div>">
	<cfparam name="session.dsn_menu" default="#session.dsn#">
    <!---
	-- PROPSITO
	-- Altera a linguagem do sistema
	-- CRISTOFER - 04/02/2008
	--->
	<cffunction name="set_language" displayname="Retorna menus que o usuario possui acesso" output="true" returntype="string" access="remote">
		<cfargument name="language" required="yes">
		<cfset session.language = arguments.language>
		<cfreturn 'OK'>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna menus que o usuario possui acesso
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO 18/11/2005 - criado
	--->
	<cffunction name="get_acesso" displayname="Retorna menus que o usuario possui acesso" output="true" returntype="query" access="public">
		<cfargument name="menu_inicial" required="no">
		<cfargument name="menu_id" required="no">
		<cfargument name="ITEM_ACESSO_COD" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ia.item_acesso_id, ia.item_acesso_pai, ia.item_acesso_cod,
				   ia.descricao, ia.web_url, ia.web_url_image, ia.web_target,
				   ia.act_hint as hint,
				   substr(replace(sys_connect_by_path(ia.descricao, ' > @@'),' > @@',' > '),2) as caminho_completo,
				   ia.descricao as raiz,
				   (select case
						   when max(ita2.item_acesso_id) is null then 1
						   else 0 end
					 from acesso.v$item_acesso_corrente ita2
					where ita2.item_acesso_pai = ia.item_acesso_id) as folha,
					nvl(ia.ajuda_id,-1) as ajuda_id
			  from acesso.v$item_acesso_corrente ia
			 where 1=1
			  <cfif IsDefined("arguments.menu_inicial")>
			   and ia.item_acesso_pai = #arguments.menu_inicial#
			  </cfif>
			  <cfif IsDefined("arguments.menu_id")>
			   and ia.item_acesso_id = #arguments.menu_id#
			  </cfif>
			  <cfif len(trim(arguments.item_acesso_cod))>
			   and ia.item_acesso_cod = '#arguments.item_acesso_cod#'
			  </cfif>
			  start with ia.item_acesso_pai is null
			  connect by prior ia.item_acesso_id = ia.item_acesso_pai
			  order siblings by  ia.ordem
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os itens acessiveis do modulo
	-- CRISTOFER 20/07/2005 - criado
	--->
	<cffunction name="get_acesso_modulo" displayname="Tarefas" access="remote" returntype="Query" output="true">
			<cfargument name="modulo_id" required="yes">
			<cfargument name="nivel_acesso" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select item_acesso_id,
					   modulo_id,
					   nivel_minimo
				  from acesso.v$item_acesso_modulo
				 where 1=1
				   and modulo_id = #arguments.modulo_id#
				   and nivel_minimo <= #arguments.nivel_acesso#
			</cfquery>
		<cfreturn qr />
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os itens acessiveis do usuario
	-- CRISTOFER 20/07/2005 - criado
	--->
	<cffunction name="get_acesso_usuario" displayname="Tarefas" access="remote" returntype="Query" output="true">
			<cfargument name="USUARIO" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select item_acesso_id,
  					   usuario
				  from acesso.v$item_acesso_usuario iu
				 where 1=1
				   and upper(usuario) = upper('#arguments.USUARIO#')
                   and item_acesso_id in (select i.item_acesso_id
                                            from acesso.item_acesso i
                                           start with i.item_acesso_pai = 1
                                          connect by prior i.item_acesso_id = i.item_acesso_pai)			</cfquery>
		<cfreturn qr />
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os itens do menu
	-- CRISTOFER 20/07/2005 - criado
	--->
	<cffunction name="get_item_acesso" displayname="Tarefas" access="remote" returntype="Query" output="true">
		<cfargument name="item_acesso_id" required="no" default="">
		<cfargument name="raiz" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select item_acesso_id,
				   item_acesso_pai,
				   nvl(item_acesso_pai,0) as item_acesso_pai_nvl,
				   item_acesso_cod,
				   descricao,
				   dll_name,
				   exported_function,
				   act_caption,
				   act_enabled,
				   act_visible,
				   act_hint,
				   act_image,
				   act_shortcut,
				   act_tag,
				   web_url,
				   web_url_image,
				   web_target,
				   ordem,
				   ajuda_id,
			<cfif len(trim(arguments.raiz))>
				   connect_by_isleaf as folha,
			</cfif>
				   separar,
				   publico
			  from acesso.v$item_acesso
			 where 1=1
			 <cfif len(trim(arguments.item_acesso_id))>
			   and item_acesso_id = #arguments.item_acesso_id#
			 </cfif>
			<cfif len(trim(arguments.raiz))>
			 start with item_acesso_id = #arguments.raiz#
		   connect by prior item_acesso_id = item_acesso_pai
			 order siblings by 2, ordem
			</cfif>
		</cfquery>
		<cfreturn qr />
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca a hierarquia acima do no especificado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  30/03/2006
	--->
	<cffunction name="get_hierarquia_item_acesso" access="remote" returntype="query" output="true">
		<cfargument name="item_acesso_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select item_acesso_id,
				   descricao
			  from acesso.v$item_acesso
			 start with item_acesso_id = #arguments.item_acesso_id#
			connect by prior item_acesso_pai = item_acesso_id
 			 order by level desc
    	</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Seleciona todos os itens do menu
	-- CRISTOFER 20/07/2005 - criado
	--->
	<cffunction name="get_itens_menu_completo" displayname="Tarefas" access="remote" returntype="Query" output="true">
		<cfargument name="root" required="no" default="">
		<cfargument name="item_acesso_pai" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select i.item_acesso_id,
				   nvl(i.item_acesso_pai, 0) as item_acesso_pai,
				   i.item_acesso_cod,
				   nvl(i.descricao,i.act_caption) as descricao_geral,
				   i.descricao,
				   i.dll_name,
				   i.exported_function,
				   i.act_caption,
				   i.act_enabled,
				   i.act_visible,
				   i.act_hint,
				   i.act_image,
				   i.act_shortcut,
				   i.act_tag,
				   i.web_url,
				   i.web_url_image,
				   i.web_target,
				   i.ordem,
				   i.separar,
				   case when exists (select 'x' from acesso.item_acesso where item_acesso_pai = i.item_acesso_id) then 1 else 0 end as possui_filhos
			  from acesso.item_acesso i
			 where 1=1
			<cfif len(trim(arguments.item_acesso_pai))>
				<cfif arguments.item_acesso_pai eq 0>
				   and i.item_acesso_pai is null
				<cfelse>
				   and i.item_acesso_pai = #arguments.item_acesso_pai#
				</cfif>
			</cfif>
			<cfif session.dsn_menu eq 'DELPOZO' or session.dsn_menu eq 'DELPOZO_KMM' or session.site eq 'rodomar/' or session.site eq 'bbm/'>
				 start with i.item_acesso_id = 1
			   connect by prior i.item_acesso_id = i.item_acesso_pai
					 order siblings by 2, i.ordem
			<cfelse>
				<cfif not len(trim(arguments.root))>
				 start with i.item_acesso_pai is null
				<cfelse>
				 start with i.item_acesso_pai = #arguments.root#
				</cfif>
			   connect by prior i.item_acesso_id = i.item_acesso_pai
					 order siblings by 2, i.ordem
			</cfif>
		</cfquery>
		<cfreturn qr />
	</cffunction>


	<!---
	-- PROPSITO
	-- Busca os modulos do sistema
	-- CRISTOFER 20/02/2006
	--->
	<cffunction name="get_modulos" displayname="Tarefas" access="remote" returntype="Query" output="true">
		<cfargument name="modulo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select modulo_id,
					   descricao,
					   role
				  from acesso.v$modulo
				 where 1=1
				 <cfif len(trim(arguments.descricao))>
				   and descricao like '%#arguments.descricao#%'
				 </cfif>
				 <cfif len(trim(arguments.modulo_id))>
				   and modulo_id = #arguments.modulo_id#
				 </cfif>
				 order by descricao
			</cfquery>
		<cfreturn qr />
	</cffunction>

	<!---
	-- PROPSITO
	-- Seleciona as tarefas
	-- CRISTOFER 20/02/2006
	--->
	<cffunction name="get_modulo_usuario" displayname="Tarefas" access="remote" returntype="Query" output="true">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="modulo_id" required="no" default="">
		<cfargument name="tipo" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select u.modulo_id,
				   u.usuario,
				   u.nivel_acesso,
				   n.descricao as nivel
			  from acesso.v$modulo_usuario u
			 inner join acesso.v$nivel_acesso n
					 on n.nivel_acesso = u.nivel_acesso
             inner join acesso.v$modulo m
                     on m.modulo_id = u.modulo_id
			 where 1=1
			 <cfif len(trim(arguments.modulo_id))>
			   and u.modulo_id = #arguments.modulo_id#
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(u.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 <cfif len(trim(arguments.tipo))>
			   and m.tipo = '#arguments.tipo#'
			 </cfif>
		</cfquery>
		<cfreturn qr />
	</cffunction>

	<!---
	-- PROPSITO
	-- Seleciona as tarefas
	-- CRISTOFER 20/02/2006
	--->
	<cffunction name="get_nivel_acesso" displayname="Tarefas" access="remote" returntype="Query" output="true">
		<cfargument name="nivel_acesso" required="no" default="">
		<cfargument name="descricao" required="no" default="">
        <cfargument name="modulo_id" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select nivel_acesso,
					   descricao
				  from acesso.v$nivel_acesso
				 where 1=1
				 <cfif len(trim(arguments.nivel_acesso))>
				   and nivel_acesso = #arguments.nivel_acesso#
				 </cfif>
				 <cfif len(trim(arguments.descricao))>
				   and descricao like '%#arguments.descricao#%'
				 </cfif>
                 <cfif len(trim(arguments.modulo_id))>
				   and modulo_id like '%#arguments.modulo_id#%'
				 </cfif>
			</cfquery>
		<cfreturn qr />
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna os usuarios
	-- CRISTOFER 20/02/2006
	--->
	<cffunction name="get_usuarios" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no"/>
		<cfargument name="usuario" required="no"/>
		<cfargument name="usuario_igual" required="no"/>
		<cfargument name="nome" required="no"/>
		<cfargument name="ativo" required="no" default="1"/>
		<cfquery name="qrUsuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select u.cod_pessoa, nvl(pj.nome_fantasia,pf.nome) as proprietario, u.usuario,
				   u.nome, u.descricao, u.email_id,
				   e.email_username || '@' || e.email_provedor as email,
				   u.ativo
			  from kss.kss_usuarios u
			 LEFT join kss.email e
					 on e.email_id = u.email_id
			 left join kss.pessoa_juridica pj
					on pj.cod_pessoa = u.cod_pessoa
			 left join kss.pessoa_fisica pf
					on pf.cod_pessoa = u.cod_pessoa
			 where 1=1
             <cfif len(trim(arguments.ativo)) >
               and ativo in (#arguments.ativo#)
             </cfif>
			<cfif IsDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa))>
			   and u.cod_pessoa = #arguments.cod_pessoa#
			</cfif>
			<cfif IsDefined("arguments.usuario") and Len(Trim(arguments.usuario))>
			   and usuario like upper('%#arguments.usuario#%')
			</cfif>
			<cfif IsDefined("arguments.usuario_igual") and Len(Trim(arguments.usuario_igual))>
			   and usuario = upper('#arguments.usuario_igual#')
			</cfif>
			<cfif IsDefined("arguments.nome") and Len(Trim(arguments.nome))>
			   and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			order by u.usuario
		</cfquery>
		<cfreturn qrUsuario />
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna os usuarios com acesso ao modulo
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_usuarios_modulo" displayname="Retorna menus que o usuario possui acesso" output="true" returntype="query" access="public">
		<cfargument name="modulo_id" required="no" default="">
		<cfargument name="role" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn_menu#" username="#session.usuario#" password="#session.senha#">

			select mu.usuario,
				   mu.nivel_acesso,
				   n.descricao as nivel,
				   mu.modulo_id,
				   m.descricao as modulo,
				   m.role
			  from acesso.v$modulo_usuario mu
			 inner join acesso.v$modulo m
					 on m.modulo_id = mu.modulo_id
			 inner join acesso.v$nivel_acesso n
					 on n.nivel_acesso = mu.nivel_acesso
			 where 1=1
			 <cfif len(trim(arguments.modulo_id))>
			   and mu.modulo_id = #arguments.modulo_id#
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(mu.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 <cfif len(trim(arguments.role))>
			   and upper(m.role) = upper('#arguments.role#')
			 </cfif>
             order by mu.usuario

		</cfquery>

		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna os usuarios
	-- CRISTOFER 26/04/2006
	--->
	<cffunction name="get_usuario_sistema" displayname="Busca todos os usurios da KM&M" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no"/>
		<cfargument name="usuario" required="no"/>
		<cfargument name="nome" required="no"/>
		<cfargument name="ativo" required="no" default="1"/>
		<cfquery name="qrUsuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select u.cod_pessoa, nvl(pj.nome_fantasia,pf.nome) as proprietario, u.usuario,
				   u.nome, u.descricao, u.email_id,
				   e.email_username || '@' || e.email_provedor as email,
				   u.ativo
			  from kss.kss_usuarios u
			 LEFT join kss.email e
					 on e.email_id = u.email_id
			 left join kss.pessoa_juridica pj
					on pj.cod_pessoa = u.cod_pessoa
			 left join kss.pessoa_fisica pf
					on pf.cod_pessoa = u.cod_pessoa
			 where ativo = #arguments.ativo#
			<cfif IsDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa))>
			   and u.cod_pessoa = #arguments.cod_pessoa#
			</cfif>
			<cfif IsDefined("arguments.usuario") and Len(Trim(arguments.usuario))>
			   and usuario like upper('%#arguments.usuario#%')
			</cfif>
			<cfif IsDefined("arguments.nome") and Len(Trim(arguments.nome))>
			   and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			order by u.usuario
		</cfquery>
		<cfreturn qrUsuario />
	</cffunction>

	<!---
	-- PROPSITO
	--
	-- NOTAS EXPLICATIVAS
	--
	-- CRISTOFER 01/02/2006 - criado
	--->
	<cffunction name="get_pessoa_light" access="remote" returntype="Query" output="true">
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">
			<cfargument name="cliente" required="no" default="">
			<cfargument name="cod_pessoa" required="no" default="">
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa,
					   p.tipo_pessoa,
					   p.cnpj_cpf,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.cliente,
					   p.cod_atividade_fiscal,
					   p.tipo_pessoa as tipo_pessoa_id

				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				 where 1=1
				 <cfif len(trim(arguments.cliente))>
				   and upper(p.cliente) like upper('%#arguments.cliente#%')
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf))>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#%' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif>
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa))>
				   and p.tipo_pessoa = #arguments.tipo_pessoa#
				 </cfif>
			</cfquery>
		<cfreturn qr />
	</cffunction>

	<cffunction name="get_nivel_acesso_autoriza" displayname="Busca nivel de acesso e se o usuario  ADMINISTRADOR" output="no" access="remote">
		<cfif IsDefined("session.cod_projeto") and IsDefined("session.cod_aplicacao")>
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select cod_pessoa_gestao
				  from kss.v$nivel_acesso_autoriza
				 where cod_projeto = #session.cod_projeto#
				   and cod_aplicacao = '#session.cod_aplicacao#'
			</cfquery>
			<cfset session.cod_pessoa_gestao = qr_result.cod_pessoa_gestao>
		</cfif>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna itens de ajuda
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO 07/07/2005 - criado
	--->
	<cffunction name="get_ajuda" displayname="Busca itens de ajuda" output="true" returntype="query" access="remote">
		<cfargument name="ajuda_id" required="no" default=""/>
		<cfargument name="titulo" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ajuda_id, titulo, descricao_campos, conteudo
			  from acesso.v$ajuda
			 where 1=1
			 <cfif Len(Trim(arguments.ajuda_id))>
			   and ajuda_id = #arguments.ajuda_id#
			 </cfif>
			 <cfif Len(Trim(arguments.titulo))>
			   and titulo like '%#arguments.titulo#%'
			 </cfif>
			order by titulo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna idiomas
	-- NOTAS EXPLICATIVAS
	--
	--->
	<cffunction name="get_idioma" displayname="Retorna idiomas" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_idioma, descricao
              from kss.v$idioma i
              where disponivel = 1
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Testar usuario e senha
	-- NOTAS EXPLICATIVAS
	--  SENGER 17/06/2010
	--->
	<cffunction name="testar_acesso" displayname="Testa usuario e senha informado" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 'x'
             from dual
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca o acesso do usuario
	-- NOTAS EXPLICATIVAS
	--  SENGER 17/06/2010
	--->
	<cffunction name="get_usuario_conexao" displayname="Testa usuario e senha informado" output="true" returntype="query" access="remote">
	    <cfargument name="usuario" required="yes" default=""/>
        <cfargument name="usuario_pesquisa" required="yes" default=""/>
        <cfargument name="ip" required="yes" default="" />
        <cfargument name="program" required="yes" default=""/>
        <cfargument name="machine"  required="yes" default=""/>
        <cfargument name="data_inicio"  required="yes" default=""/>
        <cfargument name="data_termino"  required="yes" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select conexao_id,
                   usuario,
                   to_char(data,'dd/mm/yyyy hh24:mi:ss') as data,
                   program,
                   ip,
                   machine,
                   cod_portal,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from acesso.v$usuario_conexao uc
             where 1=1
            <cfif len(trim(arguments.ip)) >
            	and uc.ip = '#arguments.ip#'
            </cfif>
            <cfif len(trim(arguments.program)) >
            	and uc.program like ('%#arguments.program#%')
            </cfif>
            <cfif len(trim(arguments.machine)) >
            	and upper(uc.machine) like upper('%#arguments.machine#%')
            </cfif>
            <cfif len(trim(arguments.usuario)) >
            	and upper(uc.usuario) like upper('%#arguments.usuario#%')
            </cfif>
            <cfif len(trim(arguments.usuario_pesquisa)) >
            	and upper(uc.usuario) like upper('%#arguments.usuario_pesquisa#%')
            </cfif>
            <cfif len(trim(arguments.data_inicio)) >
            	and uc.data >= '#arguments.data_inicio#'
            </cfif>
            <cfif len(trim(arguments.data_termino)) >
            	and uc.data <= '#arguments.data_termino#'
            </cfif>
            order by uc.usuario, uc.data desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

     <!---
	-- PROPSITO
	-- Busca o acesso do usuario
	-- NOTAS EXPLICATIVAS
	--  SENGER 18/06/2010
	--->
	<cffunction name="get_usuario_ultima_conexao" displayname="Testa usuario e senha informado" output="true" returntype="query" access="remote">
    	<cfargument name="usuario" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select  to_char(max(data_anterior), 'dd/mm/yyyy hh24:mi:ss') as data_anterior
                from (select lead(uc.data,1) over(partition by uc.usuario order by uc.data desc) data_anterior
                        from acesso.v$usuario_conexao uc
                        where 1=1
                          and upper(usuario) = upper('#arguments.usuario#') )
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as acoes disponiveis para o web_url informado, para o usuario que faz a requisicao
	-- NOTAS EXPLICATIVAS
	--  FELIPE B. 24/12/2014
	--->
	<cffunction name="get_acao_usuario" displayname="Busca as aes (nova estrutura) para o usurio informado" output="true" returntype="query" access="remote">
    	<cfargument name="web_url" required="yes"/>
		<cfargument name="cod_acao" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select column_value as cod_acao
			  from table(acesso.pkg_controle_acesso.fnc_get_acao_web(p_web_url => '#arguments.web_url#', p_usuario => user))
			 where 1 = 1
			 <cfif IsDefined("arguments.cod_acao")>
			   and column_value = '#arguments.cod_acao#'
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
