<html>
<cfscript>
	conn = CreateComponent("modulos.contratotransp._componentes.consulta.cfc_contrato_transporte");
	qrAlcadaLiberacaoControleUsuario = conn.get_alcada_liberacao_controle_usuario(operacao = 'CT');
</cfscript>
<cfif qrAlcadaLiberacaoControleUsuario.RecordCount eq 0>
	<script type="text/javascript">
		alert('Seu usurio no tem permisso para visualizar este item de menu.');
		history.back(-1);
    </script>
    <cfabort />
</cfif>
<cfif not IsDefined("vars.OPERACAO")>
    <cfparam name="vars.PENDENTE" default="1" />
	<cfparam name="vars.PENDENTE_DATA_INICIAL" default="#DateFormat(now()-1, 'DD/MM/YYYY')#">
	<cfparam name="vars.PENDENTE_DATA_FINAL" default="#DateFormat(now(), 'DD/MM/YYYY')#">
<cfelse>
	<cfparam name="vars.PENDENTE" default="0" />
</cfif>
<cfparam name="vars.APROVADA" default="0" />
<cfparam name="vars.REPROVADA" default="0" />
<cfscript>
	qrContratoTransp = conn.get_contrato_transp_pendente_aprovacao(argumentCollection = vars);
</cfscript>
<cfinclude template="/_scripts/scripts.cfm" />
<script src="/_scripts/dragdrop/drag.js" type="text/javascript"></script>
<cfinclude template="/_include/carregando.cfm" />
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Controle de Documentos');
	parent.f_set_texto('titulo_pagina', 'Lista de Cartas Frete Pendentes de Aprovao');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }
	
	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.f_hidden('btn_confirmar');
	
	// -------------------- //
	
	function f_buscar_cartas_frete() {
		with(document.forms[0]) {
			if(!PENDENTE.checked && !APROVADA.checked && !REPROVADA.checked) {
				alert('Selecione pelo menos umas das opes: "Pendentes", "Aprovadas" ou "Reprovadas".');
				return false;
			}
			
			if(PENDENTE.checked && (PENDENTE_DATA_INICIAL.value.trim() == '' || PENDENTE_DATA_FINAL.value.trim() == '')) {
				alert('Informe a data inicial e a final para buscar as cartas frete aprovadas.');
				return false;
			}
			
			if(APROVADA.checked && (APROVADA_DATA_INICIAL.value.trim() == '' || APROVADA_DATA_FINAL.value.trim() == '')) {
				alert('Informe a data inicial e a final para buscar as cartas frete aprovadas.');
				return false;
			}
			else if(APROVADA.checked && APROVADA_DATA_INICIAL.value.trim() != '' && APROVADA_DATA_FINAL.value.trim() != '') {
				if(Number(APROVADA_DATA_FINAL.value.getDateTime()) < Number(APROVADA_DATA_INICIAL.value.getDateTime())) {
					alert('A data de final para a opo "Aprovadas" no pode ser menor que a data inicial.');
					APROVADA_DATA_FINAL.select();
					return false;
				}
			}
			
			if(REPROVADA.checked && (REPROVADA_DATA_INICIAL.value.trim() == '' || REPROVADA_DATA_FINAL.value.trim() == '')) {
				alert('Informe a data inicial e a final para buscar as cartas frete reprovadas.');
				return false;
			}
			else if(REPROVADA.checked && REPROVADA_DATA_INICIAL.value.trim() != '' && REPROVADA_DATA_FINAL.value.trim() != '') {
				if(Number(REPROVADA_DATA_FINAL.value.getDateTime()) < Number(REPROVADA_DATA_INICIAL.value.getDateTime())) {
					alert('A data de final para a opo "Aprovadas" no pode ser menor que a data inicial.');
					REPROVADA_DATA_FINAL.select();
					return false;
				}
			}
			
			target = '_self';
			action = 'principal.cfm';		
			if(f_verifica_form(document.forms[0])) {
				submit();
			}
		}
		return false;
	}
	
	function f_ajustar_campos() {
		with(document.forms[0]) {
			var v_pendente  = PENDENTE.checked;
			var v_aprovada  = APROVADA.checked;
			var v_reprovada = REPROVADA.checked;
			
			PENDENTE_DATA_INICIAL.value = (v_pendente ? (PENDENTE_DATA_INICIAL.value ? PENDENTE_DATA_INICIAL.value : "<cfoutput>#DateFormat(Now()-1,'DD/MM/YYYY')#</cfoutput>" ): '');
			PENDENTE_DATA_FINAL.value   = (v_pendente ? (PENDENTE_DATA_FINAL.value ? PENDENTE_DATA_FINAL.value : "<cfoutput>#DateFormat(Now(),'DD/MM/YYYY')#</cfoutput>" ): '');
			PENDENTE_DATA_INICIAL.readOnly = !v_pendente;
			PENDENTE_DATA_FINAL.readOnly   = !v_pendente;
			document.getElementById('BTN_PENDENTE_DATA_INICIAL').disabled = !v_pendente;
			document.getElementById('BTN_PENDENTE_DATA_FINAL').disabled   = !v_pendente;
			
			APROVADA_DATA_INICIAL.value = (v_aprovada ? (APROVADA_DATA_INICIAL.value ? APROVADA_DATA_INICIAL.value : "<cfoutput>#DateFormat(Now()-1,'DD/MM/YYYY')#</cfoutput>" ): '');
			APROVADA_DATA_FINAL.value   = (v_aprovada ? (APROVADA_DATA_FINAL.value ? APROVADA_DATA_FINAL.value : "<cfoutput>#DateFormat(Now(),'DD/MM/YYYY')#</cfoutput>" ): '');
			APROVADA_DATA_INICIAL.readOnly = !v_aprovada;
			APROVADA_DATA_FINAL.readOnly   = !v_aprovada;
			document.getElementById('BTN_APROVADA_DATA_INICIAL').disabled = !v_aprovada;
			document.getElementById('BTN_APROVADA_DATA_FINAL').disabled   = !v_aprovada;
			
			REPROVADA_DATA_INICIAL.value = (v_reprovada ? (REPROVADA_DATA_INICIAL.value ? REPROVADA_DATA_INICIAL.value : "<cfoutput>#DateFormat(Now()-1,'DD/MM/YYYY')#</cfoutput>" ): '');
			REPROVADA_DATA_FINAL.value   = (v_reprovada ? (REPROVADA_DATA_FINAL.value ? REPROVADA_DATA_FINAL.value : "<cfoutput>#DateFormat(Now(),'DD/MM/YYYY')#</cfoutput>" ): '');
			REPROVADA_DATA_INICIAL.readOnly = !v_reprovada;
			REPROVADA_DATA_FINAL.readOnly   = !v_reprovada;
			document.getElementById('BTN_REPROVADA_DATA_INICIAL').disabled = !v_reprovada;
			document.getElementById('BTN_REPROVADA_DATA_FINAL').disabled   = !v_reprovada;
		}
	}
	
	function f_aprovar(p_lancto_id) {
		with(document.forms[0]) {
			if(confirm('Para aprovar a carta frete clique em OK.')) {
				OPERACAO.value  = 2;
				LANCTO_ID.value = p_lancto_id;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_aprovar_adi(p_lancto_id) {
		with(document.forms[0]) {
			if(confirm('Para aprovar o adiantamento clique em OK.')) {
				OPERACAO.value  = 4;
				LANCTO_ID.value = p_lancto_id;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_mostrar_div_reprovar(p_lancto_id) {
		with(document.forms[0]) {
			f_ocultar_div_reprovar();
			
			obj = document.getElementById('div_reprovar');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_reprovar').style.display = '';", 100);
				obj.style.top  = window.event.clientY + scrOfY;
				obj.style.left = 20 + scrOfX;
			}
			
			MOTIVO_REPROVACAO.disabled = false;
			document.getElementById('btn_ocultar_div_reprovar').disabled   = false;
			document.getElementById('btn_confirmar_div_reprovar').disabled = false;
			
			MOTIVO_REPROVACAO.setAttribute('obrigatorio', 1);
			LANCTO_ID.value = p_lancto_id;
		}
	}
	
	function f_ocultar_div_reprovar() {
		with(document.forms[0]) {
			document.getElementById('div_reprovar').style.display = 'none';
			
			MOTIVO_REPROVACAO.disabled = true;
			document.getElementById('btn_ocultar_div_reprovar').disabled   = true;
			document.getElementById('btn_confirmar_div_reprovar').disabled = true;
			
			MOTIVO_REPROVACAO.setAttribute('obrigatorio', 0);
			MOTIVO_REPROVACAO.value = '';
		}
	}
	
	function f_mostrar_div_reprovar_adi(p_lancto_id) {
		with(document.forms[0]) {
			f_ocultar_div_reprovar_adi();
			
			obj = document.getElementById('div_reprovar_adi');
			f_get_scroll();
			
			if(obj.style.display == 'none') {document.forms
				setTimeout("document.getElementById('div_reprovar_adi').style.display = '';", 100);
				obj.style.top  = window.event.clientY + scrOfY;
				obj.style.left = 20 + scrOfX;
			}
			
			MOTIVO_REPROVACAO_ADI.disabled = false;
			document.getElementById('btn_ocultar_div_reprovar_adi').disabled   = false;
			document.getElementById('btn_confirmar_div_reprovar_adi').disabled = false;
			
			MOTIVO_REPROVACAO_ADI.setAttribute('obrigatorio', 1);
			LANCTO_ID.value = p_lancto_id;
		}
	}
	
	function f_ocultar_div_reprovar_adi() {
		with(document.forms[0]) {
			document.getElementById('div_reprovar_adi').style.display = 'none';
			
			MOTIVO_REPROVACAO.disabled = true;
			document.getElementById('btn_ocultar_div_reprovar_adi').disabled   = true;
			document.getElementById('btn_confirmar_div_reprovar_adi').disabled = true;
			
			MOTIVO_REPROVACAO_ADI.setAttribute('obrigatorio', 0);
			MOTIVO_REPROVACAO_ADI.value = '';
		}
	}
	
	function f_reprovar() {
		with(document.forms[0]) {
			OPERACAO.value = 3;
			
			target = 'consultas';
			action = 'confirma.cfm';
			if(f_verifica_form(document.forms[0])) {
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_reprovar_adi() {
		with(document.forms[0]) {
			OPERACAO.value = 5;
			
			target = 'consultas';
			action = 'confirma.cfm';
			if(f_verifica_form(document.forms[0])) {
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_mostrar_div_conhecimentos(p_lancto_id, p_num_romaneio) {
		f_ocultar_div_conhecimentos();
		
		document.getElementById('div_lista_conhecimentos').innerHTML = '';
		
		obj = document.getElementById('div_conhecimentos');
		f_get_scroll();
		
		if(obj.style.display == 'none') {
			setTimeout("document.getElementById('div_conhecimentos').style.display = '';", 100);
			obj.style.top = window.event.clientY + scrOfY;
			obj.style.left = 20 + scrOfX;
		}
		
		if(!p_lancto_id || p_lancto_id == '') {
			return;
		}
		
		f_buscar_conhecimentos(p_lancto_id, p_num_romaneio);
	}
	
	function f_ocultar_div_conhecimentos() {
		document.getElementById('div_conhecimentos').style.display = 'none';
	}
	
	function f_buscar_conhecimentos(p_lancto_id, p_num_romaneio) {
		f_query_ajax('<cf_url>/modulos/contratotransp/lista_pendente_aprovacao/consultas.cfm</cf_url>' +
					'?consulta=1' +
					'&lancto_id=' + p_lancto_id +
					'&num_romaneio=' + p_num_romaneio
					,function(obj) {
						document.getElementById('div_lista_conhecimentos').innerHTML = obj;
					});
	}
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<script src="/_scripts/dragdrop.js" type="text/javascript"></script>
<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
    <input type="hidden" name="LANCTO_ID" id="LANCTO_ID" value="" sempre_ativo="1" />
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
    	<tr>
			<td>
                <fieldset><legend>Par&acirc;metros</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<tr style="height: 26px;">
                        <td nowrap class="texto"><input type="checkbox" name="PENDENTE" id="PENDENTE" class="check" value="1" <cfif vars.PENDENTE eq 1>checked</cfif> onClick="f_ajustar_campos()" /><label for="PENDENTE" style="margin-left: 5px;">Pendentes</label></td>
                        <td width="99%" class="texto"><input type="text" name="PENDENTE_DATA_INICIAL" id="PENDENTE_DATA_INICIAL" maxlength="10" tipo="data" display="PENDENTES / DATA INICIAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_PENDENTE_DATA_INICIAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "PENDENTE_DATA_INICIAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 				   // the date format
									button      : "BTN_PENDENTE_DATA_INICIAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script>
                            at&eacute;
                            <input type="text" name="PENDENTE_DATA_FINAL" id="PENDENTE_DATA_FINAL" maxlength="10" tipo="data" display="PENDENTES / DATA FINAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_PENDENTE_DATA_FINAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "PENDENTE_DATA_FINAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 				 // the date format
									button      : "BTN_PENDENTE_DATA_FINAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script></td>
                    </tr>
                    <tr>
                        <td width="1%"  nowrap class="texto"><input type="checkbox" name="APROVADA" id="APROVADA" class="check" value="1" <cfif vars.APROVADA eq 1>checked</cfif> onClick="f_ajustar_campos()" /><label for="APROVADA" style="margin-left: 5px;">Aprovadas</label></td>
                        <td width="99%" class="texto"><input type="text" name="APROVADA_DATA_INICIAL" id="APROVADA_DATA_INICIAL" maxlength="10" tipo="data" display="APROVADAS / DATA INICIAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_APROVADA_DATA_INICIAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "APROVADA_DATA_INICIAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 				   // the date format
									button      : "BTN_APROVADA_DATA_INICIAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script>
                            at&eacute;
                            <input type="text" name="APROVADA_DATA_FINAL" id="APROVADA_DATA_FINAL" maxlength="10" tipo="data" display="APROVADAS / DATA FINAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_APROVADA_DATA_FINAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "APROVADA_DATA_FINAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 				 // the date format
									button      : "BTN_APROVADA_DATA_FINAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><input type="checkbox" name="REPROVADA" id="REPROVADA" class="check" value="1" <cfif vars.REPROVADA eq 1>checked</cfif> onClick="f_ajustar_campos()" /><label for="REPROVADA" style="margin-left: 5px;">Reprovadas</label></td>
                        <td class="texto"><input type="text" name="REPROVADA_DATA_INICIAL" id="REPROVADA_DATA_INICIAL" maxlength="10" tipo="data" display="REPROVADAS / DATA INICIAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_REPROVADA_DATA_INICIAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "REPROVADA_DATA_INICIAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 				    // the date format
									button      : "BTN_REPROVADA_DATA_INICIAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script>
                            at&eacute;
                            <input type="text" name="REPROVADA_DATA_FINAL" id="REPROVADA_DATA_FINAL" maxlength="10" tipo="data" display="REPROVADAS / DATA FINAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_REPROVADA_DATA_FINAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "REPROVADA_DATA_FINAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 				  // the date format
									button      : "BTN_REPROVADA_DATA_FINAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script>&nbsp;
                            <button type="button" class="botao" onClick="f_buscar_cartas_frete()"><img src="/_imagens/botoes/16x16/filtro.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Buscar Cartas Frete</button></td>
                    </tr>
                </table>
                </fieldset>
			</td>
        </tr>
        <cfif qrContratoTransp.RecordCount gt 0>
           <tr>
        	     <td>
            	 <cfset grid_cod = 'LISTA_CARTA_FRETE_PENDENTE_APROVACAO'>
				    <cfset grid_query = 'qrContratoTransp'>
                <cfset grid_field_list    = ''>
                <cfset grid_field_caption = ''>
                <cfset grid_field_align   = ''>
                <cfset grid_field_type    = ''>		
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'APROVAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CF</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REPROVAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CF</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				    <cfset grid_field_list 	  = ListAppend(grid_field_list,'APROVAR_ADIANTAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Adiant.</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REPROVAR_ADIANTAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Adiant.</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'LANCTO_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Carta Frete</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_FORMULARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Formul&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_CONTRATO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tipo de Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_SERVICO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tipo de Servi&ccedil;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_CARGA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tipo de Carga</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_ROMANEIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Romaneio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CARREGAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Carregamento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'UNIDADE_NEGOCIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Unidade de Neg&oacute;cio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DEPARTAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Departamento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SETOR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Setor</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CENTRO_CUSTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Centro de Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_EMISSAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data de Emiss&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PESO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Peso</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_UNIDADE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Unidade</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VOLUME')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Volume</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'M3')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>M3</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'FRETE_EM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Frete Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TOTAL_PARCELA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Total de Parcelas</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_UNITARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Unit&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_FRETE_BRUTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Frete Bruto</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_FRETE_LIQUIDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Frete L&iacute;quido</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_FRETE_BRUTO_ACUM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor CF Acumulado</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TOTAL_CONHECIMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Total Conhecimento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'GANHO_BRUTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Ganho Bruto</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PERCENTUAL_GANHO_BRUTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>% Ganho Bruto</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
				    <cfset grid_field_list 	  = ListAppend(grid_field_list,'CTRC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Conhecimentos</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TOTAL_NF_ES_FRETE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Total NF Servi&ccedil;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TOTAL_CRT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Total CRT</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CONTROLE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cavalo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_REFERENCIA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Carreta</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PROPRIETARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Propriet&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MOTORISTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Motorista</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'RPA_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; RPA</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'IMPRESSO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Impresso</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USER_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATE_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USUARIO_CANCELAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_CANCELAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USUARIO_APROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Aprovado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_APROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Aprovado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USUARIO_REPROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reprovado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_REPROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reprovado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MOTIVO_REPROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Motivo de Reprova&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_ADIANTAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Adiantamento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_ADIANTAMENTO_PEDAGIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Adiantamento Pedgio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_ADTO_CARGA_DESCARGA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Adiantamento Carga/Desc.</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_TOTAL_ADTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Total Adiantamento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'OBSERVACAO_APROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Obs. Aprova&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_EMITIDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Emitido</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_PERMITIDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Permitido</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_td_context_eval 	   = 'fnc_grid_td_context_eval'>
				    <cfset grid_tr_class_function 	= 'fnc_grid_tr_class'>
                <cfset grid_tr_onclick_function = 'fnc_grid_tr_onclick'>
                <cfset grid_td_inline_function 	= 'fnc_grid_td_inline'>
                <cfset grid_td_class_function 	= 'fnc_grid_td_class'>
                <cfset grid_td_style_function	= 'fnc_grid_td_style'>
                
                <cfscript>
                    function fnc_grid_td_context_eval(field) {
                        switch(ucase(field)) {
							case "APROVAR":
								if(not Len(Trim(qrContratoTransp.DATA_CANCELAMENTO)) and not Len(Trim(qrContratoTransp.DATA_APROVACAO)) and not Len(Trim(qrContratoTransp.DATA_REPROVACAO))) {
									return '<button type="button" class="botao-16x16" onClick="f_aprovar(#qrContratoTransp.LANCTO_ID#)"><img src="/modulos/contratotransp/_imagens/botoes/16x16/aprovar.gif" alt="Aprovar" title="Aprovar" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '';
								}
                                
								break;
							case "REPROVAR":
								if(not Len(Trim(qrContratoTransp.DATA_CANCELAMENTO)) and not Len(Trim(qrContratoTransp.DATA_APROVACAO)) and not Len(Trim(qrContratoTransp.DATA_REPROVACAO))) {
									return '<button type="button" class="botao-16x16" onClick="f_mostrar_div_reprovar(#qrContratoTransp.LANCTO_ID#)"><img src="/modulos/contratotransp/_imagens/botoes/16x16/reprovar.gif" alt="Reprovar" title="Reprovar" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '';
								}
                                
								break;
						    case "APROVAR_ADIANTAMENTO":
								if(not Len(Trim(qrContratoTransp.DATA_CANCELAMENTO)) and not Len(Trim(qrContratoTransp.DATA_APROVACAO_ADIANT)) and not Len(Trim(qrContratoTransp.DATA_REPROVACAO_ADIANT)) and (qrContratoTransp.EXIGE_APROVACAO_ADIANTAMENTO == 1)) {
									return '<button type="button" class="botao-16x16" onClick="f_aprovar_adi(#qrContratoTransp.LANCTO_ID#)"><img src="/modulos/contratotransp/_imagens/botoes/16x16/aprovar.gif" alt="Aprovar" title="Aprovar" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '';
								}
                                
								break;
							case "REPROVAR_ADIANTAMENTO":
								if(not Len(Trim(qrContratoTransp.DATA_CANCELAMENTO)) and not Len(Trim(qrContratoTransp.DATA_APROVACAO_ADIANT)) and not Len(Trim(qrContratoTransp.DATA_REPROVACAO_ADIANT)) and (qrContratoTransp.EXIGE_APROVACAO_ADIANTAMENTO == 1)) {
									return '<button type="button" class="botao-16x16" onClick="f_mostrar_div_reprovar_adi(#qrContratoTransp.LANCTO_ID#)"><img src="/modulos/contratotransp/_imagens/botoes/16x16/reprovar.gif" alt="Reprovar" title="Reprovar" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '';
								}
                                
								break;
							case "VALOR_UNITARIO":
								return LSNumberFormat(qrContratoTransp.VALOR_UNITARIO, ',.__');
								break;
							case "VALOR_FRETE_BRUTO":
								return LSNumberFormat(qrContratoTransp.VALOR_FRETE_BRUTO, ',.__');
								break;
							case "VALOR_FRETE_LIQUIDO":
								return LSNumberFormat(qrContratoTransp.VALOR_FRETE_LIQUIDO, ',.__');
								break;
							case "VALOR_FRETE_BRUTO_ACUM":
								return LSNumberFormat(qrContratoTransp.VALOR_FRETE_BRUTO_ACUM, ',.__');
								break;
							case "TOTAL_CONHECIMENTO":
								return LSNumberFormat(qrContratoTransp.TOTAL_CONHECIMENTO, ',.__');
								break;
							case "GANHO_BRUTO":
								return LSNumberFormat(qrContratoTransp.GANHO_BRUTO, ',.__');
								break;
							case "PERCENTUAL_GANHO_BRUTO":
								return LSNumberFormat(qrContratoTransp.PERCENTUAL_GANHO_BRUTO, ',.__');
								break;
							case "CTRC":
								return '<button type="button" class="botao-16x16" onClick="f_mostrar_div_conhecimentos(#qrContratoTransp.LANCTO_ID#,#qrContratoTransp.NUM_ROMANEIO#)"><img src="/_imagens/botoes/16x16/visualizar.gif" alt="Visualizar CTRCs" title="Visualizar CTRCs" width="16" height="16" align="absmiddle" /></button>';
								break;
							case "TOTAL_NF_ES_FRETE":
								return LSNumberFormat(qrContratoTransp.TOTAL_NF_ES_FRETE, ',.__');
								break;
							case "TOTAL_CRT":
								return LSNumberFormat(qrContratoTransp.TOTAL_CRT, ',.__');
								break;							
							case "VALOR_ADIANTAMENTO":
								return LSNumberFormat(qrContratoTransp.VALOR_ADIANTAMENTO, ',.__');
								break;
							case "VALOR_ADIANTAMENTO_PEDAGIO":
								return LSNumberFormat(qrContratoTransp.VALOR_ADIANTAMENTO_PEDAGIO, ',.__');
								break;
							case "VALOR_ADTO_CARGA_DESCARGA":
								return LSNumberFormat(qrContratoTransp.VALOR_ADTO_CARGA_DESCARGA, ',.__');
								break;
							case "VALOR_TOTAL_ADTO":
								return LSNumberFormat(qrContratoTransp.VALOR_TOTAL_ADTO, ',.__');
								break;
							case "VALOR_EMITIDO":
								return LSNumberFormat(qrContratoTransp.VALOR_EMITIDO, ',.__');
								break;
							case "VALOR_PERMITIDO":
								return LSNumberFormat(qrContratoTransp.VALOR_PERMITIDO, ',.__');
								break;
							default:
								return Evaluate("#grid_query#.#field#");
								break;
						}
                    }
                    
                    function fnc_grid_tr_class() {
						return "linha_branca";
					}
					
					function fnc_grid_tr_onclick() {
						return "this.className = (this.className == 'linha_azul_escura' ? 'linha_branca' : 'linha_azul_escura');";
					}
					
					function fnc_grid_td_inline(field) {
						return " nowrap";
					}
					
					function fnc_grid_td_class(field) {
						switch(ucase(field)) {
							case "APROVAR":
								if(Len(Trim(qrContratoTransp.DATA_APROVACAO))) {
									return "linha_verde";
								}
								else {
									return "";
								}
								
								break;
							case "REPROVAR":
								if(Len(Trim(qrContratoTransp.DATA_REPROVACAO))) {
									return "linha_vermelha";
								}
								else {
									return "";
								}
								
								break;
						    case "APROVAR_ADIANTAMENTO":
								if(Len(Trim(qrContratoTransp.DATA_APROVACAO_ADIANT))) {
									return "linha_verde";
								}
								else {
									return "";
								}
								
								break;
							case "REPROVAR_ADIANTAMENTO":
								if(Len(Trim(qrContratoTransp.DATA_REPROVACAO_ADIANT))) {
									return "linha_vermelha";
								}
								else {
									return "";
								}
								
								break;
							case "IMPRESSO_DESC":
								if(qrContratoTransp.IMPRESSO eq 1) {
									return "linha_verde";
								}
								else {
									return "linha_vermelha";
								}
								
								break;
							case "USUARIO_CANCELAMENTO":
								if(Len(Trim(qrContratoTransp.USUARIO_CANCELAMENTO))) {
									return "linha_vermelha";
								}
								else {
									return "";
								}
								
								break;
							case "DATA_CANCELAMENTO":
								if(Len(Trim(qrContratoTransp.DATA_CANCELAMENTO))) {
									return "linha_vermelha";
								}
								else {
									return "";
								}
								
								break;
							case "USUARIO_APROVACAO":
								if(Len(Trim(qrContratoTransp.USUARIO_APROVACAO))) {
									return "linha_verde";
								}
								else {
									return "";
								}
								
								break;
							case "DATA_APROVACAO":
								if(Len(Trim(qrContratoTransp.DATA_APROVACAO))) {
									return "linha_verde";
								}
								else {
									return "";
								}
								
								break;
							case "USUARIO_REPROVACAO":
								if(Len(Trim(qrContratoTransp.USUARIO_REPROVACAO))) {
									return "linha_vermelha";
								}
								else {
									return "";
								}
								
								break;
							case "DATA_REPROVACAO":
								if(Len(Trim(qrContratoTransp.DATA_REPROVACAO))) {
									return "linha_vermelha";
								}
								else {
									return "";
								}
								
								break;
							default:
								return "";
								break;
						}
					}
					
					function fnc_grid_td_style(field) {
						switch(ucase(field)) {
							case "APROVAR":
								return "width: 23px; height: 21px;";
								break;
							case "REPROVAR":
								return "width: 23px; height: 21px;";
								break;
							default:
								return "height: 21px;";
								break;
						}
					}
                </cfscript>
                
                <cfset grid_fixed_header = 0>
                <cfinclude template="/_include/grid/grid.cfm">
            </td>
        </tr>
        <cfelse>
        <tr>
            <td align="center" valign="middle" class="obrigatorio" style="padding-top: 10px;">Nenhuma carta frete foi encontrada.</td>
        </tr>
        </cfif>
	</table>
    <div id="div_reprovar" style="position: absolute; width: 400px; height: 140px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_reprovar" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Reprovar Carta Frete</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
                        <tr>
                            <td width="1%"  nowrap class="texto" valign="top">Motivo:</td>
                            <td width="99%" class="texto" valign="top"><textarea name="MOTIVO_REPROVACAO" id="MOTIVO_REPROVACAO" rows="5" display="MOTIVO DA REPROVAO" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 100%;"></textarea></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" id="btn_ocultar_div_reprovar" class="botao" onClick="f_ocultar_div_reprovar()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                    <button type="button" id="btn_confirmar_div_reprovar" class="botao" onClick="f_reprovar()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button></td>
            </tr>
        </table>
    </div>
	
	<div id="div_reprovar_adi" style="position: absolute; width: 400px; height: 140px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_reprovar" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Reprovar Adiantamento</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
                        <tr>
                            <td width="1%"  nowrap class="texto" valign="top">Motivo:</td>
                            <td width="99%" class="texto" valign="top"><textarea name="MOTIVO_REPROVACAO_ADI" id="MOTIVO_REPROVACAO_ADI" rows="5" display="MOTIVO DA REPROVAO" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 100%;"></textarea></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" id="btn_ocultar_div_reprovar_adi" class="botao" onClick="f_ocultar_div_reprovar_adi()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                    <button type="button" id="btn_confirmar_div_reprovar_adi" class="botao" onClick="f_reprovar_adi()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button></td>
            </tr>
        </table>
    </div>
	
    <div id="div_conhecimentos" style="position: absolute; width: auto; height: auto; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_conhecimentos" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Conhecimentos</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
                        <tr>
                            <td height="100%" valign="top" class="texto"><div id="div_lista_conhecimentos" style="width: auto; height: auto; overflow: scroll;"></div></td>
                        </tr>                   
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" class="botao" onClick="f_ocultar_div_conhecimentos()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button></td>
            </tr>
        </table>
    </div>
</form>
</body>
<script type="text/javascript">
	<cfif IsDefined("vars.PENDENTE_DATA_INICIAL")>
        with(document.forms[0]) {
            <cfoutput>
                PENDENTE_DATA_INICIAL.value  = '#JSStringFormat(vars.PENDENTE_DATA_INICIAL)#';
				PENDENTE_DATA_FINAL.value  = '#JSStringFormat(vars.PENDENTE_DATA_FINAL)#';
            </cfoutput>
        }
	</cfif>
	<cfif IsDefined("vars.APROVADA_DATA_INICIAL")>
        with(document.forms[0]) {
            <cfoutput>
                APROVADA_DATA_INICIAL.value  = '#JSStringFormat(vars.APROVADA_DATA_INICIAL)#';
                APROVADA_DATA_FINAL.value 	= '#JSStringFormat(vars.APROVADA_DATA_FINAL)#';
				REPROVADA_DATA_INICIAL.value = '#JSStringFormat(vars.REPROVADA_DATA_INICIAL)#';
                REPROVADA_DATA_FINAL.value 	= '#JSStringFormat(vars.REPROVADA_DATA_FINAL)#';
            </cfoutput>
        }
	</cfif>
	
	f_hide_carregando();
	f_ajustar_campos();
	
	v_dragObj = new DragObj({ type: 'preview', moveOpacity : 60 });
	v_dragObj.addObj(document.getElementById('div_reprovar'), document.getElementById('tr_cabecalho_interno_reprovar'));
	v_dragObj.addObj(document.getElementById('div_conhecimentos'), document.getElementById('tr_cabecalho_interno_conhecimentos'));
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style=" display: none;"></iframe>
<cfset RequestEnd = 0>
