<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulação da área de caixa" extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPÓSITO
    -- Adicionar item de contrato
    -- jaquelinef 10/02/2014 15:27:56 - CRIADO
    --->
    <cffunction name='ins_contrato_transp_item' displayname='Adicionar item de contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>
        <cfargument name='VALOR' required='yes'>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_ins_contrato_transp_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
   	<!--- 
	-- PROPÓSITO
	-- Efetua a troca da carta frete
	-- 06/02/2014 - MATHEUS
	--->
	<cffunction name="troca_carta_frete" displayname="Troca efetivamente a carta frete" access="remote" returntype="struct" output="true">
		<cfargument name="contrato_transp_id" required="yes">
		<cfargument name="adiantamento_saldo" required="yes">
		<cfargument name="cod_pessoa_posto" required="yes">
  		<cfargument name="valor_original" required="yes">
		<cftry>
			<cftransaction action="begin">
                 <cfscript>
                    v_valor_item = this.ListaToArray (lista = arguments, variavel = "VALOR_ITEM_ITEM");
                    v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITEM");
  				 </cfscript>
            
                <cfloop from="1" to="#ArrayLen(v_valor_item)#" index="count">
					 <cfscript>
						retorno = this.ins_contrato_transp_item(lancto_id = arguments.contrato_transp_id,
														        item_id	  = v_item_id[count],
														        valor	  = v_valor_item[count]);
                    </cfscript>
                </cfloop>            
            
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_troca_carta_frete" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_contrato_transp_id" value="#arguments.contrato_transp_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_adiantamento_saldo" value="#arguments.adiantamento_saldo#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_posto" value="#arguments.cod_pessoa_posto#">
					<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_valor_original" value="#arguments.valor_original#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Troca da Carta frete efetuada com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Exclui lancto no contas a pagar do posto
	-- CRISTOFER  30/12/2005
	--->
	<cffunction name="del_contas_pagar" access="remote" returntype="struct" output="true">
		<cfargument name="LANCTO_ID" required="yes">
		<cfargument name="contas_pagar_id" required="yes">
		<cfargument name="num_recibo" required="yes">
		<cfargument name="adiantamento" required="yes">
		<cfargument name="saldo" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					delete oper.v$contrato_transp_pagar
					 where lancto_id = #arguments.lancto_id#
					   and contas_pagar_id = #arguments.contas_pagar_id#
					   and num_recibo = #arguments.num_recibo#
					   and adiantamento = #arguments.adiantamento#
					   and saldo = #arguments.saldo#
				</cfquery>
				<cfset retorno.mensagem = 'Documento excluído com sucesso!'>				
				<cfset retorno.erro = false>						
			</cftransaction>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cftransaction action="rollback" />
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
</cfcomponent>