<cfcomponent extends="_transportes.funcoes.cfc_init">

<!---
-- PROPSITO
-- Trocar carto do motorista
-- ricardocabral 24/08/2015 17:58:06 - CRIADO
--->
<cffunction name='troca_cartao_vale_pedagio' displayname='Trocar carto do motorista' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cfargument name='NUM_CARTAO_ANTIGO' required='yes'>
	<cfargument name='NUM_CARTAO_NOVO' required='yes'>
	<cfargument name='OPERADORA_VALE_PEDAGIO' required='yes'>
	<cftry>
			<cfstoredproc procedure='pagfrete.pkg_cartao.prc_troca_cartao_vale_pedagio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_CARTAO_ANTIGO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_CARTAO_NOVO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OPERADORA_VALE_PEDAGIO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Operao realizada com sucesso')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='finaliza_historico_romaneio' displayname='Finaliza histrico romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_finaliza_hist_rom_terc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao realizada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    <!--- 
    -- PROPSITO
    -- Transfere a permisso da impresso da carta frete
    -- guto 12/12/2008 15:19:26 - CRIADO
    --->
    <cffunction name='transfere_impressao' displayname='Transfere impresso' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes' default="">
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_transfere_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='cf_sql_numeric' SCALE='5'   value='#arguments.LANCTO_ID#'>
                    <cfprocparam type='IN' cfsqltype='cf_sql_numeric' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#' null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao realizada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!---  PROPSITO
	-- Gera um romaneio para terceiros
	-- cristofer 15/12/2006 11:24:28 - CRIADO
	--->
	<cffunction name='gera_romaneio_terceiro' displayname='Gera um romaneio para terceiros' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COMPOSICAO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='VIAGEM_CARGA_ID' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='CARGA_CONSOLIDADA_ID' required='no'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_romaneio.prc_gera_romaneio_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_ROMANEIO#' variable='retorno.NUM_ROMANEIO'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.ITEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPOSICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' variable='retorno.DATA_INICIO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VIAGEM_CARGA_ID#'  null='#iif(len(trim(arguments.VIAGEM_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#session.COD_PESSOA#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CARGA_CONSOLIDADA_ID#'  null='#iif(len(trim(arguments.CARGA_CONSOLIDADA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Romaneio gerado com sucesso')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Vincula contrato ao CTRC
    -- guto 12/12/2008 15:19:26 - CRIADO
    --->
    <cffunction name='ins_vinculo_contrato_conhecimento' displayname='Vincula contrato ao CTRC' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_vincula_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo executado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Desvincula contrato ao CTRC
    -- guto 12/12/2008 15:19:26 - CRIADO
    --->
    <cffunction name='del_vinculo_contrato_conhecimento' displayname='Vincula contrato ao CTRC' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_desvincula_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Conhecimento desvinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Insere um item vinculado a carta frete
	-- 11/01/2006 - criado
	--->
    <cffunction name="ins_item_contrato" displayname="Insere um item vinculado a carta frete" access="remote" returntype="struct" output="true">
	<cfargument name='LANCTO_ID' required='yes'>
	<cfargument name='ITEM_ID' required='yes'>
	<cfargument name='VALOR' required='yes'>
	<cfargument name="desconto" 	required="YES">
	<cfargument name="CENARIO_CONTRATO_ITEM_ID" 	required="NO" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_ins_contrato__item_web" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#LSDateFormat(now())# #TimeFormat(now(), "HH:MM:SS")#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_INTEGER'  variable='retorno.contrato_item_id' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CENARIO_CONTRATO_ITEM_ID#'  null='#iif(len(trim(arguments.CENARIO_CONTRATO_ITEM_ID)), de('no'), de('yes'))#'>

			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Item lanado com sucesso!")>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

    <!---
    -- PROPSITO
    -- Insere uma carga no contrato transporte
    -- cristofer 12/05/2008 16:06:22 - CRIADO
    --->
    <cffunction name='ins_contrato_transp_carga' displayname='Insere uma carga no contrato transporte' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CARGA_ID' required='yes'>
        <cfargument name='TIPO_OPERACAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_ins_contrato_transp_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_OPERACAO#'  null='#iif(len(trim(arguments.TIPO_OPERACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carga vinculada com sucesso!')>
           <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Insere contas a pagar para o contrato
	-- GUTO 12/01/2007 11:59:08 - CRIADO
	--->
	<cffunction name='ins_contrato_transp_contas_pagar' displayname='Insere contas a pagar para o contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_gera_contas_pagar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

    <!---
    -- PROPSITO
    -- Insere o contrato no CTF e vinculado ao contrato emitido.
    -- guto 11/02/2009 11:37:50 - CRIADO
    --->
    <cffunction name='ins_contrato_ctf' displayname='Insere o contrato no CTF e vinculado ao contrato emitido.' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_ins_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.TRANSACAO_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.COD_CONTRATO_CTF' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.mensagem' >
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset retorno.mensagem_str = cfcatch.Detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Insere um Contrato de transporte
	-- cristofer 27/11/2006 14:34:47 - CRIADO
	--->
	<cffunction name='ins_contrato_transporte' displayname='Insere um Contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='no' default=''>
		<cfargument name='NUM_FORMULARIO' required='no' default=''>
		<cfargument name='SERIE_FORMULARIO' required='no' default="U">
		<cfargument name='TIPO_CONTRATO' required='no' default="0">
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='TOLERANCIA_FALTA' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_FRETE_BRUTO' required='yes'>
		<cfargument name='VALOR_FRETE_LIQUIDO' required='yes'>
		<cfargument name='MOTORISTA_COD_PESSOA' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='PROPRIETARIO_COD_PESSOA' required='yes'>
		<cfargument name='PROPRIETARIO_ENDERECO' required='yes'>
		<cfargument name='PROPRIETARIO_COD_UF' required='no' default="" >
		<cfargument name='PROPRIETARIO_COD_MUNICIPIO' required='no' default="">
		<cfargument name='PROPRIETARIO_COD_DISTRITO' required='no' default="">
		<cfargument name='PROPRIETARIO_COD_DV' required='no' default="">
		<cfargument name='PROPRIETARIO_NIT' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='PROPRIETARIO_MUNICIPIO_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='TIPO_CARGA' required='no' default="">
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='TOTAL_PARCELA' required='no' default="0">
		<cfargument name='CARGA_ID_COLETA' required='no' default="">
		<cfargument name='CARGA_ID_ENTREGA' required='no' default="">
		<cfargument name='CTF' required='no' default="0">
        <cfargument name='COD_MODELO' required='yes'>
		<cfargument name='COD_REMETENTE' required='no' default="">
		<cfargument name='COD_DESTINATARIO' required='no' default="">
        <cfargument name='OPERACAO_ID' required='no' default=''>
        <cfargument name='CTRC_ID' required='no' default=''>
        <cfargument name='DIARIA_CTRC_ID' required='no' default=''>
        <cfargument name='DIARIA_CRT_ID' required='no' default=''>
        <cfargument name='USUARIO_LIBERACAO' required='no' default=''>
        <cfargument name='SENHA_LIBERACAO' required='no' default=''>
        <cfargument name='VALOR_MAXIMO' required='yes'>
        <cfargument name='DIVISAO_ID' required='no' default=''>
        <cfargument name='REPOM' required='no' default="0">
		<cfargument name='COD_ORGANIZACIONAL' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='AVULSA' required='no' default="0">
        <cfargument name='TIPO_SERVICO_COMERCIAL' required='no' default="">
      	<cfargument name='PAMCARD' required='no' default="0">
      	<cfargument name='CARTAO_PEDAGIO_NUMERO' required='no' default="">
      	<cfargument name='TABELA_FRETE_ROTA_ID' required='no' default="">
      	<cfargument name='ROTA_ID' required='no' default="">
      	<cfargument name='VIAGEM_CARGA_ID' required='no' default="">
      	<cfargument name='VALOR_MAXIMO_PEDAGIO' required='no' default="">
      	<cfargument name='VALOR_PEDAGIO_ROTA' required='no' default="">
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
		<cfargument name='CARTAO_NUMERO' required='no' default="">
        <cfargument name='PAGBEM' required='no' default="0">
        <cfargument name='TARGET' required='no' default="0">
		<cfargument name='CIOT' required='no' default="">
		<cfargument name='VALECARD' required='no' default="0">
		<cfargument name='NUM_CARTAO_VALE_PEDAGIO' required='no' default="">
		<cfargument name='PAGAMENTO_PEDAGIO_PAGBEM' required='no' default="">
        <cfargument name='RECEBEDOR_COD_PESSOA' required='no' default="">
		<cfargument name='REPOMFRETE' required='no' default="">
		<cfargument name='WEX' required='no' default="">
		<cfargument name='EXTRATTA' required='no' default="">
		<cfargument name='TIPO_PAGTO_ID' required='no' default="">
		<cfargument name='CARTAO_PEDAGIO' required='no' default="">
		<cfargument name='PAGAMENTO_PEDAGIO' required='no' default="">
		<cfargument name='LOCAL_QUITACAO' required='no' default="">
		<cfargument name='COD_TOMADOR' required='no' default="">
		<cfargument name='NUMERO_DOCUMENTO' required='no' default="">
		<cfargument name='ORGANIZACIONAL_ID_ORIGINAL' required='no' default="">
		<cfargument name='OBSERVACAO_APROVACAO' required='no' default="">
		<cfargument name='VALOR_PEDAGIO_TABELA_FRETE' required='no' default="">
		<cfargument name='CARTAO_NUMERO_PROPRIETARIO' required='no' default="">		
		<cfargument name='COD_EXPEDIDOR' required='no' default="">
		<cfargument name='COD_RECEBEDOR' required='no' default="">
		<cfargument name='ROTA_ID_VOLTA' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfset retorno.num_romaneio = arguments.num_romaneio>
				<cfset retorno.conhecimento_id = arguments.conhecimento_id>
                <cfset gerar_vale_pedagio_na_emissao = 0>
                <cfset gerar_vale_pedagio_manual = 0>

				<cfif arguments.tipo_carga eq 2>
					<!--- Gera um romaneio para o manifesto --->
					<cfscript>
						retorno_roo = this.gera_romaneio_manifesto(NUM_LOTE             = arguments.num_lote
																	         ,MANIFESTO_ID			 = arguments.manifesto_id
																	         ,CONHECIMENTO_ID		 = arguments.conhecimento_id
																	         ,COD_PESSOA_MOTORISTA = arguments.motorista_cod_pessoa
																	         ,DATA_EMISSAO			 = arguments.data_emissao
																	         ,OBSERVACAO				 = arguments.observacao
																				);
						retorno.num_romaneio = retorno_roo.num_romaneio;
					</cfscript>
				</cfif>

                <!--- Verifica se ser necessrio gerar vale pedgio --->
                <cfscript>
					v_vale_pedagio = this.ListaToArray (lista = arguments, variavel = "NUM_COMPROVANTE_VALE_PEDAGIO");
				</cfscript>

                <cfloop from="1" to="#ArrayLen(v_vale_pedagio)#" index="count">
					<cfscript>
						if (not Len(Trim(v_vale_pedagio[count]))){
							gerar_vale_pedagio_na_emissao = 1;
						}
                    </cfscript>
				</cfloop>

                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_ins_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.LANCTO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE_FORMULARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CONTRATO#'  null='#iif(len(trim(arguments.TIPO_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FRETE_EM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOLERANCIA_FALTA#'  null='#iif(len(trim(arguments.TOLERANCIA_FALTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FRETE_BRUTO#'  null='#iif(len(trim(arguments.VALOR_FRETE_BRUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FRETE_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_FRETE_LIQUIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOTORISTA_COD_PESSOA#'  null='#iif(len(trim(arguments.MOTORISTA_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROPRIETARIO_COD_PESSOA#'  null='#iif(len(trim(arguments.PROPRIETARIO_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROPRIETARIO_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROPRIETARIO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.PROPRIETARIO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROPRIETARIO_NIT#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_MODELO#' null='#iif(len(trim(arguments.COD_MODELO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CTRC_ID#'  null='#iif(len(trim(arguments.CTRC_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DIARIA_CTRC_ID#'  null='#iif(len(trim(arguments.DIARIA_CTRC_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DIARIA_CRT_ID#'  null='#iif(len(trim(arguments.DIARIA_CRT_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENHA_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_MAXIMO#'  null='#iif(len(trim(arguments.VALOR_MAXIMO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANIZACIONAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AVULSA#'  null='#iif(len(trim(arguments.AVULSA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_SERVICO_COMERCIAL#'  null='#iif(len(trim(arguments.TIPO_SERVICO_COMERCIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.TABELA_FRETE_ROTA_ID#' null='#iif(len(trim(arguments.TABELA_FRETE_ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_CARGA_ID#'  null='#iif(len(trim(arguments.VIAGEM_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_MAXIMO_PEDAGIO#'  null='#iif(len(trim(arguments.VALOR_MAXIMO_PEDAGIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PEDAGIO_ROTA#'  null='#iif(len(trim(arguments.VALOR_PEDAGIO_ROTA)), de('no'), de('yes'))#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#gerar_vale_pedagio_na_emissao#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.CIOT#'  null='#iif(len(trim(arguments.CIOT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.COD_TOMADOR#'  null='#iif(len(trim(arguments.COD_TOMADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.NUMERO_DOCUMENTO#'  null='#iif(len(trim(arguments.NUMERO_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.ORGANIZACIONAL_ID_ORIGINAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_ORIGINAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RECEBEDOR_COD_PESSOA#'  null='#iif(len(trim(arguments.RECEBEDOR_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO_APROVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PEDAGIO_TABELA_FRETE#'  null='#iif(len(trim(arguments.VALOR_PEDAGIO_TABELA_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID_VOLTA#'  null='#iif(len(trim(arguments.ROTA_ID_VOLTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.COD_EXPEDIDOR#'  null='#iif(len(trim(arguments.COD_EXPEDIDOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.COD_RECEBEDOR#'  null='#iif(len(trim(arguments.COD_RECEBEDOR)), de('no'), de('yes'))#'>
					
				</cfstoredproc>

                <!---Vincula ao CTRC--->
                <cfif Len(Trim(arguments.CONHECIMENTO_ID))>
					<cfscript>
                      	set_vinculo = this.ins_vinculo_contrato_conhecimento(lancto_id       = retorno.LANCTO_ID
                                                                            ,conhecimento_id = arguments.conhecimento_id
																			);
                    </cfscript>
                    <cfif set_vinculo.erro>
                    	<cfthrow object="#set_vinculo.mensagem#">
                    </cfif>
                </cfif>

			    <!--- Insere ITENS --->
			    <cfscript>
				    v_item_id 	      = this.ListaToArray (lista = arguments, variavel = "ACR_ITEM_ID");
				    v_descricao       = this.ListaToArray (lista = arguments, variavel = "ACR_DESCRICAO");
				    v_desconto        = this.ListaToArray (lista = arguments, variavel = "ACR_DESCONTO_COD");
				    v_valor		      = this.ListaToArray (lista = arguments, variavel = "ACR_VALOR");
				    v_parcelamento_id = this.ListaToArray (lista = arguments, variavel = "ACR_PARCELAMENTO_ID");
					v_cod_posto       = this.ListaToArray (lista = arguments, variavel = "POSTO_COD_PESSOA_ACRESCIMOS");
				    v_unitario	      = this.ListaToArray (lista = arguments, variavel = "POSTO_VALOR_UNITARIO_ACRESCIMOS");
				    v_quantidade      = this.ListaToArray (lista = arguments, variavel = "POSTO_QUANTIDADE_ACRESCIMOS");
					v_cenario_contrato_item_id	  = this.ListaToArray (lista = arguments, variavel = "ACR_CENARIO_CONTRATO_ITEM_ID");
			    </cfscript>

                <cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
				    <cfscript>
					    v_item_contrato = this.ins_item_contrato(lancto_id = retorno.lancto_id
													            ,item_id   = v_item_id[count]
													            ,descricao = v_descricao[count]
													            ,desconto  = v_desconto[count]
													            ,valor	   = v_valor[count]
																,cenario_contrato_item_id = v_cenario_contrato_item_id[count]
																);
                     </cfscript>

					 <cfif v_item_contrato.erro>
					    <cfthrow object="#v_item_contrato.mensagem#">
				    </cfif>

					<cfscript>   
						if (Len(Trim('v_parcelamento_id[count]')) and v_parcelamento_id[count] neq ''){
							v_vincula = this.vincula_taxa_parcelamento(lancto_id       = retorno.lancto_id
																	  ,parcelamento_id = v_parcelamento_id[count]
																	  ,contrato_item_id = v_item_contrato.contrato_item_id);
						}
					</cfscript>
					
					<cfif isdefined("v_vincula") and isdefined("v_vincula.erro") and v_vincula.erro>
						<cfthrow object="#v_vincula.mensagem#">
					</cfif>                        
			    </cfloop>

                <cfif arguments.tipo_carga eq 3>
                	<cfloop list="#arguments.carga_id_coleta#" index="v_id">
                    	<cfscript>
						    ret = this.ins_contrato_transp_carga(lancto_id     = retorno.lancto_id
													            ,carga_id      = v_id
													            ,tipo_operacao = 1
																);
					    </cfscript>

                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                   </cfloop>
                   
                	 <cfloop list="#arguments.carga_id_entrega#" index="v_id">
                      <cfscript>
						    ret = this.ins_contrato_transp_carga(lancto_id     = retorno.lancto_id
													            ,carga_id      = v_id
													            ,tipo_operacao = 2
																);
						    </cfscript>
                      <cfif ret.erro>
                         <cfthrow object="#ret.mensagem#">
                      </cfif>
                   </cfloop>
                </cfif>

                <!---Diviso do CRT--->
                <cfset v_validar_divisao = 0 />

                <cfloop list="#arguments.DIVISAO_ID#" index="v_divisao_id">
					<cfscript>
                    	conn = CreateComponent('modulos.contratotransp._componentes.manipulacao.cfc_transp_internacional');
                      	set_divisao = conn.embarque_divisao_contrato(lancto_id = retorno.lancto_id, divisao_id = v_divisao_id);
                   	</cfscript>

                   	<cfif set_divisao.erro>
                    	<cfthrow object="#set_divisao.mensagem#">
                  	</cfif>

                   	<cfset v_validar_divisao = 1 />
                </cfloop>

                <cfif v_validar_divisao eq 1>
                	<cfscript>
                        set_validar_divisao = conn.validar_divisao_contrato(lancto_id = retorno.lancto_id);
                    </cfscript>
                    <cfif set_validar_divisao.erro>
                    	<cfthrow object="#set_validar_divisao.mensagem#">
                    </cfif>
                </cfif>

				<cfif arguments.total_parcela gt 1>
                	<!--- Efetua o parcelamento da carta frete --->
                    <cfstoredproc procedure='oper.pkg_contrato_transp.prc_parcelar_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='in' cfsqltype='cf_sql_integer'  value='#retorno.lancto_id#' null='#iif(len(trim(retorno.lancto_id)),de('no'),de('yes'))#'>
                        <cfprocparam type='in' cfsqltype='cf_sql_integer'  value='#arguments.total_parcela#' null='#iif(len(trim(arguments.total_parcela)),de('no'),de('yes'))#'>
                    </cfstoredproc>
                <cfelse>
					<!--- Recalcula os impostos sobre a carta frete --->
                    <cfstoredproc procedure='oper.pkg_contrato_transp.prc_recalcula_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='in' cfsqltype='cf_sql_integer'     value='#retorno.lancto_id#' null='#iif(len(trim(retorno.lancto_id)),de('no'),de('yes'))#'>
						<cfprocparam type='in' cfsqltype='cf_sql_varchar'  value='#arguments.CARTAO_NUMERO#' null='#iif(len(trim(arguments.CARTAO_NUMERO)),de('no'),de('yes'))#'>
                    </cfstoredproc>

					<!--- Gerar contas a pagar somente quando no for REPOM, pois REPOM deve gerar cpg ao integrar o contrato. --->
                    <cfif arguments.REPOM eq 0 and arguments.PAGBEM eq 0 and arguments.TARGET eq 0 and arguments.VALECARD eq 0 and arguments.REPOMFRETE eq 0 and arguments.WEX eq 0 and arguments.EXTRATTA eq 0>
						<!--- Insere no contas a pagar --->
                        <cfscript>
                            this.ins_contrato_transp_contas_pagar(lancto_id = retorno.lancto_id);
                        </cfscript>
	                </cfif>
				</cfif>

				<!--- CPG EM ABERTO --->
                <cfif arguments.POSSUI_CPG_ABERTO eq 1>
					    <cfscript>
					       ret_cpg_aberto = this.ins_ct_cpg_aberto(LANCTO_ID           = retorno.LANCTO_ID
						                                          ,INF_ADIC_CPG_ABERTO = arguments.INF_ADIC_CPG_ABERTO
									   					      );						
					    </cfscript>
					    <cfif ret_cpg_aberto.erro>
					       <cfthrow object="#ret_cpg_aberto.mensagem#">
                        </cfif>
                </cfif>

                <!--- CTF --->
                <cfif arguments.CTF eq 1>
                   <cfscript>
                      conn_ct = CreateComponent("modulos.contratotransp._componentes.manipulacao.cfc_contrato_transporte");
                      set_ctf = conn_ct.ins_contrato_ctf(lancto_id = retorno.LANCTO_ID);
                   </cfscript>

                   <cfif set_ctf.erro>
                      <cfthrow object="#set_ctf.mensagem#">
                   <cfelse>
                      <cfset retorno.mensagem_ctf = set_ctf.mensagem>
                   </cfif>
                </cfif>

                <!--- REPOM --->
                <cfif arguments.REPOM eq 1>
					    <cfscript>
					       conn = CreateComponent("modulos.repom._componentes.manipulacao.cfc_repom");
						    ret_repom = conn.emitir_contrato(LANCTO_ID     = retorno.LANCTO_ID
							   					 	            ,ROTA_ID       = arguments.ROTA_ID
								   					            ,CARTAO_NUMERO = arguments.CARTAO_NUMERO
																,EIXO_SUSPENSO = arguments.EIXO_SUSPENSO
									   								);						
					    </cfscript>
					    <cfif ret_repom.erro>
					       <cfthrow object="#ret_repom.mensagem#">
                        <cfelse>
                    	    <cfset retorno.contrato_id = ret_repom.contrato_id>
				 	    </cfif>

					    <cfscript>
						   this.vincula_cartao_contrato(lancto_id     = retorno.lancto_id
						                               ,cartao_numero = arguments.CARTAO_NUMERO);
					    </cfscript>
                </cfif>
				
				<cfif arguments.REPOMFRETE eq 1 or arguments.WEX eq 1 or arguments.EXTRATTA eq 1>
					<cfscript>
						conn = CreateComponent("modulos.pagfrete._componentes.manipulacao.cfc_pagfrete");
						
						vars.params = '<params>' 
											 & '<operation>inserir_contrato</operation>'
											 & '<tipo_pagto_id>'            & arguments.TIPO_PAGTO_ID            & '</tipo_pagto_id>'
											 & '<lancto_id>'   	            & retorno.LANCTO_ID       	         & '</lancto_id>'
											 & '<rota_id>'   	            & arguments.ROTA_ID 	             & '</rota_id>'
											 & '<cartao_numero>'            & arguments.CARTAO_NUMERO            & '</cartao_numero>'
											 & '<eixo_suspenso>'            & arguments.EIXO_SUSPENSO            & '</eixo_suspenso>'
											 & '<modo_compra_vale_pedagio>' & arguments.MODO_COMPRA_VALE_PEDAGIO & '</modo_compra_vale_pedagio>'
											 & '<cartao_pedagio>'    	    & arguments.CARTAO_PEDAGIO           & '</cartao_pedagio>'
											 & '<local_quitacao>'           & arguments.LOCAL_QUITACAO           & '</local_quitacao>'
											 & 
								   '</params>';
						
						ret_pagfrete = conn.prc_module_gateway(operation = 'inserir_contrato'
						                                      ,params    = vars.params);						
					</cfscript>
					
					<cfif ret_pagfrete.erro>
						<cfthrow object="#ret_pagfrete.mensagem#">
                    <cfelse>
						<cfset retorno.contrato_id = ret_pagfrete.contrato_id>
				 	</cfif>
                </cfif>

                <!--- PAMCARD --->
                <cfif arguments.PAMCARD eq 1>
					    <cfscript>
					       conn = CreateComponent("modulos.pamcard._componentes.manipulacao.cfc_pamcard");
						    ret_pamcard = conn.inclui_contrato_frete(COD_PESSOA  = session.cod_pessoa
							   					 	                    ,LANCTO_ID   = retorno.LANCTO_ID
																				  ,ROTA_ID     = arguments.ROTA_ID
																				  ,CARTAO_FAV1 = arguments.CARTAO_NUMERO
																				  ,CARTAO_FAV2 = arguments.CARTAO_PEDAGIO_NUMERO
									   								        );
					    </cfscript>
					    <cfif ret_pamcard.erro>
					       <cfthrow object="#ret_pamcard.mensagem#">
                   <cfelse>
                 	    <cfset retorno.contrato_id = ret_pamcard.contrato_id>
				 	    </cfif>
                </cfif>

                <!--- PAGBEM --->
                <cfif arguments.PAGBEM eq 1>
					    <cfscript>
					       conn = CreateComponent("modulos.pagbem._componentes.manipulacao.cfc_pagbem");
						    ret_pagbem = conn.emitir_contrato(LANCTO_ID                  = retorno.LANCTO_ID
						                                     ,ROTA_ID                    = arguments.ROTA_ID
							   					 	         ,CARTAO_NUMERO              = arguments.CARTAO_NUMERO
															 ,PAGAMENTO_PEDAGIO          = arguments.PAGAMENTO_PEDAGIO_PAGBEM
															 ,CARTAO_NUMERO_PROPRIETARIO = arguments.CARTAO_NUMERO_PROPRIETARIO
									   						);
					    </cfscript>
					    <cfif ret_pagbem.erro>
					       <cfthrow object="#ret_pagbem.mensagem#">
                   <cfelse>
                 	    <cfset retorno.contrato_id = ret_pagbem.contrato_id>
				 	    </cfif>
                </cfif>
				
				<!--- TARGET --->
                <cfif arguments.TARGET eq 1>
					    <cfscript>
					       conn = CreateComponent("modulos.target._componentes.manipulacao.cfc_target");
						    ret_target = conn.emitir_contrato(LANCTO_ID                = retorno.LANCTO_ID
						                                     ,ROTA_ID                  = ''
							   					 	         ,CARTAO_NUMERO            = ''
															 ,MODO_COMPRA_VALE_PEDAGIO = arguments.PAGAMENTO_PEDAGIO_TARGET
															 ,CARTAO_PEDAGIO_NUMERO    = arguments.CARTAO_PEDAGIO_NUMERO
															 ,PERMITE_QUITACAO_POSTO   = arguments.TARGET_PERMITE_QUITACAO_POSTO
									   						);
					    </cfscript>
					    <cfif ret_target.erro>
					       <cfthrow object="#ret_target.mensagem#">
                        <cfelse>
                 	       <cfset retorno.contrato_id = ret_target.contrato_id>
				 	    </cfif>
												
						<cfscript>
							v_cartao     = this.ListaToArray (lista = arguments, variavel = "TARGET_PAGTO_CARTAO_TARGET_PAGTO");
							v_aliquota   = this.ListaToArray (lista = arguments, variavel = "TARGET_PAGTO_ALIQUOTA_TARGET_PAGTO");
							v_data_pagto = this.ListaToArray (lista = arguments, variavel = "TARGET_PAGTO_DATA_PAGTO_TARGET_PAGTO");
							v_automatico = this.ListaToArray (lista = arguments, variavel = "TARGET_PAGTO_PAGTO_AUTOMATICO_TARGET_PAGTO");
							v_tipo_pagto = this.ListaToArray (lista = arguments, variavel = "TARGET_PAGTO_TIPO_PAGTO_TARGET_PAGTO");
						</cfscript>
						
						<cfloop from="1" to="#ArrayLen(v_cartao)#" index="count">
							<cfscript>
								ret_cartao = conn.vincular_cartao_contrato( contrato_id          = retorno.contrato_id
																		  , cartao               = v_cartao[count]
																		  , aliquota             = v_aliquota[count]
																		  , tipo_pagamento       = v_tipo_pagto[count]
																		  , data_pagamento       = v_data_pagto[count]
																		  , pagamento_automatico = v_automatico[count]
																		  );
							</cfscript>
							<cfif ret_cartao.erro>
								<cfthrow object="#ret_cartao.mensagem#">
							</cfif>
						</cfloop>
						
						<cfscript>
							ret_cartao = conn.validar_vinculo_contrato_cartao(contrato_id = retorno.contrato_id);
						</cfscript>
						<cfif ret_cartao.erro>
							<cfthrow object="#ret_cartao.mensagem#">
						</cfif>
                </cfif>
				
				<!--- VALECARD --->
                <cfif arguments.VALECARD eq 1>
					    <cfscript>
					       conn = CreateComponent("modulos.valecard._componentes.manipulacao.cfc_valecard");
						    ret_target = conn.emitir_contrato(LANCTO_ID                = retorno.LANCTO_ID
							   					 	         ,CARTAO_NUMERO            = arguments.CARTAO_NUMERO
									   						);
					    </cfscript>
					    <cfif ret_target.erro>
					       <cfthrow object="#ret_target.mensagem#">
                   <cfelse>
                 	    <cfset retorno.contrato_id = ret_target.contrato_id>
				 	    </cfif>
                </cfif>

				<!--- Integra o CPG gerado com a TOTVS (Multilog - Contrato Transporte Empresa) --->
                <cfscript>
                    this.integra_cpg_ct_empresa(lancto_id = retorno.lancto_id);
                </cfscript>

                <cfscript>
					v_cod_fornecedora = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_FORNECEDORA_VALE_PEDAGIO");
					v_cod_operadora   = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_OPERADORA_VALE_PEDAGIO");
					v_manual 	      = this.ListaToArray (lista = arguments, variavel = "MANUAL_VALE_PEDAGIO");
				</cfscript>
                <cfdump var="#v_manual#">
				<cfloop from="1" to="#ArrayLen(v_cod_fornecedora)#" index="count">
                		<cfif v_manual[count] eq 0>
                        	<cfscript>
                        		ret_troca_cartao = this.troca_cartao_vale_pedagio( cod_pessoa_motorista   = arguments.motorista_cod_pessoa
													                             , num_cartao_antigo      = arguments.num_cartao_vale_pedagio_antigo
																				 , num_cartao_novo        = arguments.num_cartao_vale_pedagio
																				 , operadora_vale_pedagio = v_cod_operadora[count]);

							</cfscript>
                            <cfif ret_troca_cartao.erro>
								<cfthrow object="#ret_troca_cartao.mensagem#">
                            </cfif>
                        	<cfscript>
                        		ret_vale = this.emite_vale_pedagio(lancto_id              = retorno.lancto_id
								                                  ,cartao_numero          = arguments.NUM_CARTAO_VALE_PEDAGIO
																  ,placa_cavalo           = arguments.PLACA_CONTROLE
																  ,placa_carreta          = arguments.PLACA_REFERENCIA
																  ,cod_pessoa_fornecedora = v_cod_fornecedora[count]
    	                        							      ,cod_pessoa_operadora   = v_cod_operadora[count]);
							</cfscript>
                            <cfif ret_vale.erro>
								<cfthrow object="#ret_vale.mensagem#">
                            </cfif>
	                	<cfelse>
                        	<cfscript>
	                    		ret_vale = this.emite_vale_pedagio_manual( cod_pessoa_fornecedora = v_cod_fornecedora[count]
    	                        										 , cod_pessoa_operadora   = v_cod_operadora[count]
        	                                                             , num_romaneio           = arguments.num_romaneio
            	                										 , lancto_id              = retorno.lancto_id
																		 , cartao_numero          = arguments.NUM_CARTAO_VALE_PEDAGIO
																		 , placa_cavalo           = arguments.PLACA_CONTROLE
																         , placa_carreta          = arguments.PLACA_REFERENCIA);
							</cfscript>
                            <cfif ret_vale.erro>
								<cfthrow object="#ret_vale.mensagem#">
                            </cfif>
                    	</cfif>
				</cfloop>
				
                <cfscript>
				   set_email = this.enviar_email_aprovacao(lancto_id = retorno.lancto_id);
			    </cfscript>
                <cfif set_email.erro>
                    <cfthrow object="#set_email.mensagem#">
                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato de Transporte inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Cancela uma carta frete
    -- cristofer 08/05/2008 10:47:53 - CRIADO
    --->
    <cffunction name='cancelar_contrato_transporte' displayname='Cancela um contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='DATA_CANCELAMENTO' required='yes'>
        <cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_cancelar_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CANCELAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_CANCELAMENTO_ID#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato cancelado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Marca uma carta frete como impressa
    -- cristofer 08/05/2008 10:47:53 - CRIADO
    --->
    <cffunction name='imprimir_contrato_transporte' displayname='Imprime uma carta frete' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_imprimir_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carta frete impressa com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Gerar contrato em PDF.
    -- jaquelinef 18/11/2013 09:18:15 - CRIADO
    --->
    <cffunction name='gera_contrato' displayname='Gerar contrato em PDF.' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_gera_contrato_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO#'  null='#iif(len(trim(arguments.CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato gerado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Gerar contrato grupo em PDF.
    -- rafael 19/03/2014 - CRIADO
    --->
    <cffunction name='gera_contrato_grupo' displayname='Gerar contrato em PDF.' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_impressao_ct_grupo.prc_gerar_espelho_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO#'  null='#iif(len(trim(arguments.CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato gerado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Integrar CPG gerados com a TOTVS a partir de um contrato de transporte do tipo Empresa (Multilog - no interfere na baseline)
    -- FELIPEBUENO 13/06/2014 11:17:27 - CRIADO
    --->
    <cffunction name='integra_cpg_ct_empresa' displayname='Integrar CPG gerados com a TOTVS a partir de um contrato de transporte do tipo Empresa (Multilog - no interfere na baseline)' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_integra_cpg_ct_empresa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

	<!---
    -- PROPSITO
    -- Aprovar ou reprovar contrato de transporte, a partir do email de aprovao enviado para o gestor do CC. Gerencial do contrato
    -- FELIPEBUENO 08/01/2015 08:42:40 - CRIADO
    --->
    <cffunction name='confirmar_email_aprovacao' displayname='Aprovar ou reprovar contrato de transporte, a partir do email de aprovao enviado para o gestor do CC. Gerencial do contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CHAVE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_contrato_transp_aprov.prc_confirmar_email_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Aprovao/reprovao realizada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Emite um vale pedgio a partir do contrato de transporte
	-- thomasjensen 17/09/2014 14:43:12 - CRIADO
	--->
	<cffunction name='emite_vale_pedagio' displayname='Emite um vale pedgio a partir do contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='LANCTO_ID' required='no' default="">
		<cfargument name='ITINERARIO_ID' required='no' default="">
		<cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
		<cfargument name='VIAGEM_CARGA_ID' required='no' default="">
		<cfargument name='GERA_EXCECAO' required='no' default="">
		<cfargument name='CARTAO_NUMERO' required='no' default="">
		<cfargument name='PLACA_CAVALO' required='no' default="">
		<cfargument name='PLACA_CARRETA' required='no' default="">
		<cfargument name='COD_PESSOA_FORNECEDORA' required='no' default="">
		<cfargument name='COD_PESSOA_OPERADORA' required='no' default="">
        <cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_vale_pedagio.prc_emitir_vale_pedagio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_CARGA_ID#'  null='#iif(len(trim(arguments.VIAGEM_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERA_EXCECAO#'  null='#iif(len(trim(arguments.GERA_EXCECAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            value='#arguments.CARTAO_NUMERO#'  null='#iif(len(trim(arguments.CARTAO_NUMERO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'            null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'            null='yes' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FORNECEDORA#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDORA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OPERADORA#'  null='#iif(len(trim(arguments.COD_PESSOA_OPERADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            value='#arguments.PLACA_CAVALO#'  null='#iif(len(trim(arguments.PLACA_CAVALO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            value='#arguments.PLACA_CARRETA#'  null='#iif(len(trim(arguments.PLACA_CARRETA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vale pedgio emitido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Emite um vale pedgio a partir do contrato de transporte
	-- thomasjensen 17/09/2014 14:47:04 - CRIADO
	--->
	<cffunction name='emite_vale_pedagio_manual' displayname='Emite um vale pedgio a partir do contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FORNECEDORA' required='yes'>
		<cfargument name='COD_PESSOA_OPERADORA' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='LANCTO_ID' required='no' default="">
		<cfargument name='CARTAO_NUMERO' required='no' default="">
		<cfargument name='PLACA_CAVALO' required='no' default="">
		<cfargument name='PLACA_CARRETA' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_vale_pedagio.prc_emitir_vale_pedagio_manual' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FORNECEDORA#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OPERADORA#'  null='#iif(len(trim(arguments.COD_PESSOA_OPERADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.NUM_COMPROVANTE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            value='#arguments.CARTAO_NUMERO#'  null='#iif(len(trim(arguments.CARTAO_NUMERO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            value='#arguments.PLACA_CAVALO#'  null='#iif(len(trim(arguments.PLACA_CAVALO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'            value='#arguments.PLACA_CARRETA#'  null='#iif(len(trim(arguments.PLACA_CARRETA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vale pedgio emitido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 
    
     <!---
	-- PROPSITO
	-- Vincular taxa de crdito de agregado ao contrato
	-- FABIO 01/06/2016 14:30:37 - CRIADO
	--->
	<cffunction name='vincula_taxa_parcelamento' displayname='Vincular taxa de crdito de agregado ao contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='PARCELAMENTO_ID' required='yes'>
		<cfargument name='CONTRATO_ITEM_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_vincula_taxa_parcelamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PARCELAMENTO_ID#'  null='#iif(len(trim(arguments.PARCELAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ITEM_ID#'  null='#iif(len(trim(arguments.CONTRATO_ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualizar o numero do formulrio do contrato de transporte
	-- LUIZGODOY / FABIOG 21/12/2015 15:36:24 - CRIADO
	--->
	<cffunction name='set_num_formulario' displayname='Atualizar o numero do formulrio do contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='NUM_FORMULARIO' required='yes'>
        <cfargument name='VALIDA_NUM_FORMULARIO' required='no' default="1">
        <cfargument name='SERIE' required='yes' >
        <cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_set_num_formulario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALIDA_NUM_FORMULARIO#'  null='#iif(len(trim(arguments.VALIDA_NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>                    
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nmero de formulrio alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 


    <!--- 
	-- PROPSITO
	-- Valida se o contrato de transporte vinculado a estrutura de controle de formulrios foi impresso corretamente
	-- LUIZGODOY / FABIOG  23/12/2015 16:37:54 - CRIADO
	--->
	<cffunction name='valida_ctransp_impresso' displayname='Valida se o contrato de transporte vinculado a estrutura de controle de formulrios foi impresso corretamente' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_FORMULARIO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kss.pkg_controle_formulario.prc_valida_ctransp_impresso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato impresso com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Desfaz operao do contrato de transporte de vincular o formulrio e torna o formulrio disponvel novamente
	-- LUIZGODOY / FABIOG  23/12/2015 16:45:54 - CRIADO
	--->
	<cffunction name='valida_ctransp_desfaz_op' displayname='Desfaz operao do contrato de transporte de vincular o formulrio e torna o formulrio disponvel novamente' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_FORMULARIO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kss.pkg_controle_formulario.prc_valida_ctransp_desfaz_op' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operao cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
		<!--- 
    -- PROPSITO
    -- Inutiliza  o formulrio 
    -- LUIZGODOY / FABIOG  23/12/2015 16:48:57 - CRIADO
    --->
    <cffunction name='valida_ctransp_inutilizar' displayname='Inutiliza  o formulrio ' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_FORMULARIO' required='yes'>
        <cfargument name='SERIE' required='yes'>
        <cfargument name='CONTRATO_ITEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kss.pkg_controle_formulario.prc_valida_ctransp_inutilizar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  value='#arguments.CONTRATO_ITEM_ID#' null='#iif(len(trim(arguments.CONTRATO_ITEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Formulario inutilizado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Envia um e-mail com os dados da carta frete para ela ser aprovada ou reprovada
	-- RAFAELPENCZKOSKI 08/01/2016 19:36 - ADICIONADO
	--->
	<cffunction name='enviar_email_aprovacao' displayname='Envia um e-mail com os dados da carta frete para ela ser aprovada ou reprovada' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_enviar_email_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail enviado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 
    
    <!--- 
	-- PROPSITO
	-- Confirma o e-mail de aprovao de uma carta frete, podendo aprov-la ou reprov-la
	-- RAFAELPENCZKOSKI 12/01/2016 17:28:17 - ADICIONADO
	--->
	<cffunction name='aprova_contrato_transporte' displayname='Confirma o email de aprovao de uma carta frete, podendo aprov-la ou reprov-la' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='CHAVE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp_liberacao.prc_confirmar_email_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TIPO_RETORNO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MENSAGEM_RETORNO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 
	
	<!--- 
	-- PROPSITO
	-- Confirma o e-mail de adiantamento de viagem, podendo aprov-lo ou reprov-lo
	-- GUSTAVOR 04/10/2018 09:34 - ADICIONADO
	--->
	<cffunction name='aprova_adiantamento' displayname='Confirma o e-mail de adiantamento de viagem, podendo aprov-lo ou reprov-lo' access='remote' returntype='Struct' output='true'>
		<cfargument name='VIAGEM_ID' required='yes'>
		<cfargument name='CHAVE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_confirmar_email_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TIPO_RETORNO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MENSAGEM_RETORNO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
				<cfset retorno.TIPO_RETORNO = 0>
				<cfset retorno.MENSAGEM_RETORNO = JSStringFormat('No foi possvel prosseguir.')>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 
    
    <!--- 
	-- PROPSITO
	-- Aprova uma carta frete
	-- RAFAELPENCZKOSKI 13/01/2016 17:33:08 - ADICIONADO
	--->
	<cffunction name='aprovar_carta_frete' displayname='Aprova uma carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_aprovar_carta_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carta frete aprovada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Reprova uma carta frete
	-- RAFAELPENCZKOSKI 13/01/2016 17:34:01 - ADICIONADO
	--->
	<cffunction name='reprovar_carta_frete' displayname='Reprova uma carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='MOTIVO_REPROVACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_reprovar_carta_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_REPROVACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carta frete reprovada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	    <!--- 
	-- PROPSITO
	-- Aprova um adiantamento
	-- RAFAELPENCZKOSKI 13/01/2016 17:33:08 - ADICIONADO
	--->
	<cffunction name='aprovar_carta_frete_adi' displayname='Aprova o adiantamento da carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_aprovar_carta_frete_adi' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Adiantamento aprovado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Reprova um adiantamento
	-- RAFAELPENCZKOSKI 13/01/2016 17:34:01 - ADICIONADO
	--->
	<cffunction name='reprovar_carta_frete_adi' displayname='Reprova o adiantamento da carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='MOTIVO_REPROVACAO_ADI' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_reprovar_carta_frete_adi' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_REPROVACAO_ADI#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Adiantamento reprovado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
                    
    <!--- 
    -- PROPSITO
    -- Vincula contrato de transporte com o formulario
    -- LUIZGODOY / FABIOG 24/12/2015 10:24:52 - CRIADO
    --->
    <cffunction name='valida_ctransp_vincular' displayname='Vincula contrato de transporte com o formulario' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_FORMULARIO' required='yes'>
        <cfargument name='SERIE' required='yes'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kss.pkg_controle_formulario.prc_valida_ctransp_vincular' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Formulario inutilizado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    <!--- 
	-- PROPSITO
	-- Vincular o formulrio com o contrato de transporte
	-- LUIZGODOY / FABIOG 28/12/2015 09:28:26 - CRIADO
	--->
	<cffunction name='prc_valida_ctransp_vincular' displayname='Vincular o formulrio com o contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_FORMULARIO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kss.pkg_controle_formulario.prc_valida_ctransp_vincular' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Formulrio vinculado ao contrato com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Cancelar a impressao quando a nova funcionalidade de controlar formularios estiver ativa e for necessrio alterar o numero do formulario
	-- LUIZGODOY / FABIOG 04/01/2016 13:48:09 - CRIADO
	--->
	<cffunction name='prc_invalida_impressao' displayname=' cancelar a impressao quando a nova funcionalidade de controlar formularios estiver ativa e for necessrio alterar o numero do formulario' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_invalida_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impressao cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!---
    -- PROPSITO
    -- Vincular cartao a contrato de transporte
    -- LEANDROSILVA 23/11/2016 - CRIADO
    --->
    <cffunction name='vincula_cartao_contrato' displayname='Vincular cartao a contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID'     required='yes'>
        <cfargument name='CARTAO_NUMERO' required='yes'>
        <cfstoredproc procedure='oper.pkg_contrato_transp.prc_vincular_cartao_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
           <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
           <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.CARTAO_NUMERO#'  null='#iif(len(trim(arguments.CARTAO_NUMERO)), de('no'), de('yes'))#'>
		</cfstoredproc>
		
		<cfreturn structnew() />
    </cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gera o registro do motorista posuir cpg com saldo na insero de contrato
	-- RAFAEL 27/06/2018 22:05 - ADICIONADO
	--->
	<cffunction name='ins_ct_cpg_aberto' displayname='Gera o registro do motorista posuir cpg com saldo na insero de contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='INF_ADIC_CPG_ABERTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_ins_ct_cpg_aberto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.INF_ADIC_CPG_ABERTO#'  null='#iif(len(trim(arguments.INF_ADIC_CPG_ABERTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
    </cffunction>

</cfcomponent>
