<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de postos" extends="_transportes.funcoes.cfc_init">
<!--- 
	-- PROPSITO 
	-- Busca contratos confirmados nos postos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  10/01/2004
	--->
	<cffunction name="get_doctos_enviados_posto" displayname="Busca contratos confirmados nos postos" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" 	required="yes">
		<cfargument name="tipo" 		required="no" default="0" hint="1 - Pagas, 0 - No Pagas, 2 - Todas" >
		<cfargument name="endereco" 	required="no">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" 	required="no">
		<cfquery name="qr_doctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_formulario
                 , c.lancto_id
                 , c.num_romaneio
                 , to_char(ctp.date_insert, 'dd/mm/yyyy') as data_lancamento
                 , to_char(c.data_emissao, 'dd/mm/yyyy') as data_emissao	 
                 , decode(nvl(cp_reneg.situacao, cp.situacao),0,'Em Aberto','Paga') as situacao
                 , to_char(nvl(cp_reneg.data_vencto, cp.data_vencto), 'dd/mm/yyyy') as data_vencto
                 , nvl(cp_reneg.num_docto, cp.num_docto) as num_docto
                 , nvl(cp_reneg.parc_docto, cp.parc_docto) as parc_docto
                 , nvl(cp_reneg.situacao, cp.situacao) as situacao_id
                 , cp.valor_docto as valor_cf
                 , nvl(cp_reneg.valor_docto, cp.valor_docto) -
                   nvl((select sum(fcpd.valor_desconto)
                          from finan.v$finan_contas_pagar_desc fcpd
                         where fcpd.contas_pagar_id = nvl(cp_reneg.contas_pagar_id, cp.contas_pagar_id)
                           and fcpd.data_estorno is null),0) + 
                   nvl((select sum(fcpj.valor_juro)
                          from finan.v$finan_contas_pagar_juro fcpj
                         where fcpj.contas_pagar_id = nvl(cp_reneg.contas_pagar_id, cp.contas_pagar_id)
                           and fcpj.data_estorno is null),0) as valor
                 , sum(nvl(cp_reneg.valor_docto, cp.valor_docto) -
                       nvl((select sum(fcpd.valor_desconto)
                              from finan.v$finan_contas_pagar_desc fcpd
                             where fcpd.contas_pagar_id = nvl(cp_reneg.contas_pagar_id, cp.contas_pagar_id)
                               and fcpd.data_estorno is null),0) + 
                       nvl((select sum(fcpj.valor_juro)
                              from finan.v$finan_contas_pagar_juro fcpj
                             where fcpj.contas_pagar_id = nvl(cp_reneg.contas_pagar_id, cp.contas_pagar_id)
                               and fcpj.data_estorno is null),0)) over() as valor_total
                 , ctp.lancto_id
                 , nvl(cp_reneg.contas_pagar_id, cp.contas_pagar_id) as contas_pagar_id
                 , decode(ctp.adiantamento_saldo,0,'Adiantamento','Saldo') as tipo
                 , to_char(tcf.date_insert, 'dd/mm/yyyy') as data_troca
                 , tcf.user_insert as usuario_troca
                 , to_char(
                      coalesce(
                               (select max(fcpa.data_amortizacao)
                                  from finan.v$finan_contas_pagar_amort fcpa
                                 where fcpa.contas_pagar_id = nvl(cp_reneg.contas_pagar_id, cp.contas_pagar_id)
                                   and fcpa.data_estorno is null), (select max(fcpd.data_desconto)
                                  from finan.v$finan_contas_pagar_desc fcpd
                                 where fcpd.contas_pagar_id = nvl(cp_reneg.contas_pagar_id, cp.contas_pagar_id)
                                   and fcpd.data_estorno is null )
                              )
                      , 'dd/mm/yyyy') as data_pagamento
              from oper.v$contrato_transp c
             inner join oper.v$contrato_transp_pagar ctp
                on c.lancto_id = ctp.lancto_id
             inner join finan.v$finan_contas_pagar cp
                on ctp.contas_pagar_id = cp.contas_pagar_id
              left join finan.v$finan_contas_pagar cp_reneg
                on cp_reneg.contas_pagar_id = cp.contas_pagar_id_renog
              left join oper.v$troca_carta_frete tcf
                on tcf.contrato_transp_id = c.lancto_id
               and tcf.contas_pagar_id = ctp.contas_pagar_id
             where ctp.cod_pessoa_recebimento = #arguments.cod_pessoa#
			 <cfif arguments.tipo neq 2>
			   and cp.situacao = #arguments.tipo#
			 </cfif>
			 <cfif isDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial)) and isDefined("arguments.data_final") and Len(Trim(arguments.data_final))>
			   and trunc(ctp.date_insert) between '#arguments.data_inicial#' and '#arguments.data_final#'
			 </cfif>
			order by trunc(ctp.date_insert), cp.num_docto, cp.parc_docto
		</cfquery>		
		<cfreturn qr_doctos>							 
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Itens para a carta frete
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2006
	--->
	<cffunction name="get_carta_frete_item" displayname="Busca Itens para a carta frete" access="remote" returntype="query" output="true">
		<cfargument name="posto" 				required="no" default="0">
		<cfargument name="contrato_transporte" 	required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                select ctis.item_id
                     , ctis.descricao
                     , ctis.desconto
                     , ctis.compoe_frete
                     , ctis.deb_cred_motorista
                     , ctis.mostra_lancto_ct
                     , ctis.mostra_posto
                     , ctis.cod_evento_rpa
 				     , decode(ctis.desconto,1,'Desconto','Acrscimo') as tipo
                  from oper.v$contrato_transp_item_setup ctis
                 where 1=1
			  <cfif arguments.posto eq 1>
			   and mostra_posto = 1
			  </cfif>
			  <cfif arguments.contrato_transporte eq 1>
			   and mostra_lancto_ct = 1
			  </cfif>
			 order by descricao	
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados do contrato
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_contrato_transporte" displayname="Busca os dados do contrato" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" displayname="Identificador do lanamento" required="no" default="">
		<!--- Quando a consulta for pelo docto precisa informar o local de emisso --->
		<cfargument name="num_formulario" displayname="Nmero do contrato de transporte" required="no" default="">
		<cfargument name="placa" displayname="Placa do veculo" required="no" default="">
		<cfargument name="adiantamento_saldo" displayname="Adiantanento ou Saldo" required="yes">        
	
		<cfquery name="qr_contrato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select ctcf.lancto_id
              	   , ctcf.data_emissao
                   , ctcf.peso
                   , ctcf.cod_unidade
                   , ctcf.frete_em
                   , ctcf.m3
                   , ctcf.cod_departamento
                   , ctcf.cod_setor
                   , ctcf.cod_centro_custo
                   , ctcf.cod_pessoa_filial
                   , ctcf.serie_formulario
                   , ctcf.num_formulario
                   , ctcf.num_romaneio
                   , ctcf.volume
                   , ctcf.placa_controle
                   , ctcf.placa_referencia
                   , ctcf.observacao
                   , ctcf.impresso
                   , ctcf.cliente
                   , ctcf.lancto_id
                   , ctcf.adiantamento_saldo
                   , ctcf.contas_pagar_id
                   , ctcf.valor_frete_bruto
                   , ctcf.valor
                   , ctcf.num_docto
                   , ctcf.cod_pessoa
                   , ctcf.situacao
                   , ctcf.descricao_situacao
   				   , nvl((select 1
                            from oper.v$troca_carta_frete t 
                           where t.contrato_transp_id = ctcf.lancto_id
                             and t.adiantamento_saldo = '#arguments.adiantamento_saldo#'),0) as trocada                 
                from oper.v$contrato_transp_carta_frete ctcf
               where 1=1
			<cfif Len(Trim(arguments.lancto_id))>
			   and lancto_id = #arguments.lancto_id# 
            </cfif>
            <cfif Len(Trim(arguments.num_formulario))>
			   and num_formulario = '#arguments.num_formulario#'
            </cfif>           
            <cfif Len(Trim(arguments.placa))>
			   and (placa_controle = upper('#arguments.placa#') or placa_referencia = upper('#arguments.placa#') )
			</cfif>
               and ctcf.adiantamento_saldo = #arguments.adiantamento_saldo#
		</cfquery>			
		<cfreturn qr_contrato>
	</cffunction>
    
   	<!--- 
	-- PROPSITO 
	-- Busca os dados dos itens do contrato
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_contrato_transp_itens" displayname="Busca os dados dos itens do contrato" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" displayname="Identificador do lanamento" required="true">
		<cfargument name="item_id" displayname="Identificador do item" required="false">
		<cfquery name="qr_contrato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ci.lancto_id
                 , ci.item_id
                 , ci.valor
                 , ctis.descricao
                 , decode(ctis.desconto,1,'Desconto','Acrscimo') as tipo
                 , ctis.compoe_frete
              from oper.v$contrato_transp ct
             inner join oper.v$contrato_transp_item ci
                on ct.lancto_id = ci.lancto_id
             inner join oper.v$contrato_transp_item_setup ctis
                on ci.item_id = ctis.item_id
               and ctis.compoe_frete = 1
			 where ct.lancto_id = #arguments.lancto_id#
			 <cfif isDefined("arguments.item_id")>
			   and ci.item_id = #arguments.item_id# 
			 </cfif>
		</cfquery>			
		<cfreturn qr_contrato>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os valores dos cpg do contrato
	-- NOTAS EXPLICATIVAS
	-- RAFAEL  27/03/2014
	--->
	<cffunction name="get_contrato_transp_pagar" displayname="Busca os dados dos itens do contrato" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" displayname="Identificador do lanamento" required="true">
		<cfargument name="adiantamento_saldo" required="true">
		<cfquery name="qr_contrato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fcp.valor_docto + v.total_juro - v.total_desconto - v.total_amortizado as valor
                 , fcp.situacao
              from oper.v$contrato_transp_pagar ctp
             inner join finan.v$finan_contas_pagar fcp
                on fcp.contas_pagar_id = ctp.contas_pagar_id
             inner join table(finan.pkg_cpg.fnc_pip_cpg_total(fcp.contas_pagar_id,'1')) v
                on v.contas_pagar_id = fcp.contas_pagar_id  
             where ctp.lancto_id = #arguments.lancto_id#
               and ctp.adiantamento_saldo = #arguments.adiantamento_saldo#
		</cfquery>			
		<cfreturn qr_contrato>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Fluxo de doctos do contratos confirmados nos postos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_fluxo_doctos_enviados_posto" displayname="Busca Fluxo de doctos do contratos confirmados nos postos" access="remote" returntype="query" output="true">
		<cfargument name="contas_pagar_id" required="yes">
		<cfquery name="qr_doctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctp.lancto_id
                 , ctp.adiantamento_saldo
                 , ctp.contas_pagar_id
                 , ctp.valor
                 , ctp.cod_pessoa_recebimento
                 , fcp.num_docto
                 , fd.descricao as documento
              from oper.v$contrato_transp_pagar ctp
             inner join finan.v$finan_contas_pagar fcp
                on fcp.contas_pagar_id = ctp.contas_pagar_id
             inner join finan.v$finan_documento fd
                on fd.docto_id = fcp.docto_id
             where ctp.adiantamento_saldo = 1
      		<cfif isDefined("arguments.contas_pagar_id")>
               and ctp.contas_pagar_id = #arguments.contas_pagar_id# 
			 </cfif>

		</cfquery>		
	<cfreturn qr_doctos>							 
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os documentos exigidos na operao
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 25/03/2014
	--->
	<cffunction name="get_doctos" displayname="Busca os doctos" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" required="yes">
		<cfquery name="qr_doctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.fnc_concat_all(kss.to_concat_expr(rownum || '-' || f.documento, chr(10))) as documentos
              from logistica.v$operacao_documento od
             inner join oper.v$documento_frete f
                on f.documento_id = od.documento_id
             where od.motorista = 1
               and od.operacao_id = (select ct.operacao_id
                                       from oper.v$contrato_transp ct
                                      where ct.lancto_id = #arguments.lancto_id#)
       </cfquery>		
	<cfreturn qr_doctos>							 
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os documentos exigidos na operao
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 25/03/2014
	--->
	<cffunction name="get_conhecimentos" displayname="Busca os doctos" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" required="yes">
		<cfquery name="qr_doctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.conhecimento_id
                 , x.num_conhecimento
                 , x.serie
                 , x.data_emissao
                 , x.filial
                 , x.centro_custo
                 , x.num_romaneio
                 , x.peso_real
                 , x.baixado
                 , min(x.baixado) over() as baixas_ok            
              from (select c.conhecimento_id
                         , c.num_conhecimento
                         , c.serie
                         , to_char(c.data_emissao, 'dd/mm/yyyy') as data_emissao
                         , kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa_filial, 1) as filial
                         , (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = c.cod_centro_custo ) as centro_custo
                         , c.num_romaneio
                         , c.peso_real
                         , decode(c.baixado_em, null, 0, 1) as BAIXADO
                      from fiscal.v$conhecimento c
                      where c.conhecimento_id in (select ctc.conhecimento_id
                                            from oper.v$contrato_transp_conhecimento ctc
                                           where ctc.lancto_id = #arguments.lancto_id#)
                        and c.conhecimento_tipo_id <> 6
                        and c.cancelado is null) x
       </cfquery>		
	<cfreturn qr_doctos>							 
	</cffunction>    
</cfcomponent>