<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca a arvore de Operaes
	-- CRISTOFER  09/05/2009
	--->		
	<cffunction name="get_operacao_tree" access="remote" returntype="query" output="true">
    	<cfargument name="cod_organograma" required="no" default="">
        <cfargument name="internacional" required="no" default="">
        <cfargument name="somente_ativas" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.operacao_id, 
                   o.operacao_id_pai, 
                   nvl(o.operacao_id_pai,0) as operacao_id_pai_nvl,
                   descricao, 
                   substr(sys_connect_by_path(o.descricao, '->'),3) as operacao_completa, 
                   veiculos_dedicados, 
                   internacional, 
                   dedicado, 
                   fracionado, 
                   frete_proprio, 
                   num_especie, 
                   regra_fiscal_id, 
                   cod_negociador, 
                   frete_por_conta,
                   case (select count(o2.operacao_id)
                           from logistica.v$operacao o2
                          where o2.operacao_id_pai = o.operacao_id) 
                      when 0
                         then 'false'
                      else  'true'
                   end possui_filhos,
                   date_insert, 
                   user_insert, 
                   date_update, 
                   user_update, 
                   site 
              from (select o.* 
                       from logistica.v$operacao o
						 <cfif len(trim(arguments.cod_organograma))>
                               inner join (select distinct op.operacao_id
                                             from logistica.v$operacao op
                                            start with op.operacao_id in (select f.operacao_id 
                                                                         from logistica.v$operacao_filial_emissao f
                                                                        where f.cod_organograma in (#arguments.cod_organograma#))
                                           connect by op.operacao_id = prior op.operacao_id_pai) e
                                       on o.operacao_id = e.operacao_id
                         </cfif>
                               ) o
             where 1=1
             <cfif Len(Trim(arguments.internacional))>
             	and o.internacional = #arguments.internacional#
             </cfif>             
             <cfif arguments.somente_ativas eq 1>
               and o.ativo = 1
             </cfif>
             start with o.operacao_id_pai is null
            connect by  prior o.operacao_id = o.operacao_id_pai
             order siblings by o.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca a arvore de Operaes
	-- CRISTOFER  09/05/2009
	--->		
	<cffunction name="get_operacao" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="edi" required="no" default="">
        <cfargument name="cod_organograma" required="no" default="">
        <cfargument name="internacional" required="no" default="">
        <cfargument name="consultar_por" required="no" default="">
        <cfargument name="valor" required="no" default="">
        <cfargument name="somente_ativas" required="no" default="0">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="avulsa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select substr(sys_connect_by_path(o.descricao, '->'),3) as operacao_completa,
                   operacao_id, 
                   operacao_id_pai, 
                   nvl(o.operacao_id_pai,0) as operacao_id_pai_nvl,
                   (select o2.descricao
                      from logistica.v$operacao o2
                     where o2.operacao_id = o.operacao_id_pai) as operacao_pai_descricao,
                   descricao, 
                   veiculos_dedicados, 
                   internacional, 
                   dedicado, 
                   fracionado, 
                   frete_proprio, 
                   num_especie, 
                   regra_fiscal_id, 
                   cod_negociador,
                   (select oc.cod_pessoa
                      from logistica.v$operacao_cliente oc
                     where oc.tipo_cliente = 4
                       and oc.operacao_id = o.operacao_id
                       and rownum = 1 ) as cod_cliente_cobranca, 
                   frete_por_conta,
                   case (select count(o2.operacao_id)
                           from logistica.v$operacao o2
                          where o2.operacao_id_pai = o.operacao_id) 
                      when 0
                         then 'false'
                      else  'true'
                   end possui_filhos,
                   o.tipo_pagamento_id,
                   o.pedido_shipment,
                   o.adiantamento_frete_vazio,
                   o.tipo_servico_id,
                   o.tipo_docto_frete,
                   o.exige_xml_nfe,
                   date_insert, 
                   user_insert, 
                   date_update, 
                   user_update, 
                   site,
                   o.pagto_vale_pedagio
              from logistica.v$operacao o       
             where 1=1
		 <cfif len(trim(arguments.operacao_id))>
           	   and o.operacao_id = #arguments.operacao_id#
         </cfif>
         <cfif Len(Trim(arguments.internacional))>
            and o.internacional = #arguments.internacional#
         </cfif>
         <cfif Len(Trim(arguments.consultar_por)) and Len(Trim(arguments.valor))>
         	<cfif arguments.consultar_por eq 1>
            	and o.operacao_id = #arguments.valor#
            </cfif>
            <cfif arguments.consultar_por eq 2>
            	and upper(kss.pkg_string.fnc_string_clean(o.descricao)) like  upper(kss.pkg_string.fnc_string_clean('%#arguments.valor#%'))
            </cfif>
         </cfif>         
         <cfif Len(Trim(arguments.cod_centro_custo))>
               and operacao_id in (select operacao_id
                                     from logistica.v$operacao op
                                    start with operacao_id in (select operacao_id 
                                                                 from logistica.v$operacao_filial_emissao 
                                                                where cod_organograma in (select o.cod_organograma
                                                                                            from kss.v$organograma o
                                                                                           where 1=1
                                                                                           	<cfif Len(Trim(arguments.cod_pessoa_filial))>
                                                                                             and o.cod_pessoa = #arguments.cod_pessoa_filial#
                                                                                            </cfif>
                                                                                            <cfif Len(Trim(arguments.cod_departamento))>
                                                                                             and o.cod_departamento = #arguments.cod_departamento#
                                                                                            </cfif>
                                                                                            <cfif Len(Trim(arguments.cod_setor))>
                                                                                             and o.cod_setor = #arguments.cod_setor#
                                                                                            </cfif>
                                                                                            <cfif Len(Trim(arguments.cod_centro_custo))>
                                                                                             and o.cod_centro_custo = #arguments.cod_centro_custo#))
                                                                                            </cfif>
                                   connect by operacao_id = prior operacao_id_pai)
             <cfelse>
             	<cfif len(trim(arguments.cod_organograma)) and ((not(Len(Trim(arguments.avulsa))) or arguments.avulsa eq 1))>
                   and (operacao_id in (select operacao_id
                                         from logistica.v$operacao op
                                        start with operacao_id in (select operacao_id 
                                                                     from logistica.v$operacao_filial_emissao 
                                                                    where cod_organograma in (#arguments.cod_organograma#))
                                       connect by operacao_id = prior operacao_id_pai)
                        or (select count(1)
                              from logistica.v$operacao_filial_emissao o1
                             where o1.operacao_id = o.operacao_id) = 0)
                 </cfif>
             </cfif>
         <cfif arguments.somente_ativas eq 1>
           and o.ativo = 1
         </cfif>
          start with o.operacao_id_pai is null
  connect by prior o.operacao_id = o.operacao_id_pai
		 <cfif len(trim(arguments.edi))>
          order by operacao_pai_descricao, o.descricao
         <cfelseif Len(Trim(arguments.consultar_por)) and Len(Trim(arguments.valor))>
          order by o.descricao
         </cfif>
		</cfquery>

		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as naturezas de uma operacao
	-- CRISTOFER  09/05/2009
	--->		
	<cffunction name="get_operacao_natureza" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select n.operacao_id, 
                   n.num_natureza,
                   nat.descricao as natureza,
                   nat.peso_especifico
              from logistica.v$operacao_natureza n
             inner join oper.v$natureza nat
                     on nat.num_natureza = n.num_natureza
             where n.operacao_id = #arguments.operacao_id#
             order by nat.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca as pessoas de uma operacao
	-- CRISTOFER  09/05/2009
	--->		
	<cffunction name="get_operacao_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="tipo_cliente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.operacao_id
                 , c.cod_pessoa
                 , p.cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa,1) as cliente
                 , kss.pkg_pessoa.fnc_get_endereco(c.cod_pessoa, 1) as endereco
                 , nvl(ped.municipio_id, pe.municipio_id) as municipio_id
                 , nvl(ped.municipio, pe.municipio) || ' - ' || ped.uf as municipio_uf
              from logistica.v$operacao_cliente c
             inner join kss.v$pessoa p
                     on p.cod_pessoa = c.cod_pessoa
              left join kss.v$pessoa_estrangeira pe
                     on pe.cod_pessoa = c.cod_pessoa
              left join kss.v$pessoa_endereco_padrao ped
                     on ped.cod_pessoa = c.cod_pessoa
             where 1 = 1
			<cfif len(trim(arguments.tipo_cliente))>
               and c.tipo_cliente = #arguments.tipo_cliente#
            </cfif>
            <cfif len(trim(arguments.operacao_id))>
               and c.operacao_id = #arguments.operacao_id#
            </cfif>
             order by cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>      
    
	<!--- 
	-- PROPSITO 
	-- Busca os municipios da operacao
	-- CRISTOFER  11/05/2009
	--->		
	<cffunction name="get_operacao_municipio" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="origem_destino" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.operacao_id,
                   m.municipio_id,
                   cep.pkg_municipio.fnc_municipio_uf(m.municipio_id) as municipio,
                   (select u.nome_uf
                      from cep.cep_ufs u
                     inner join cep.municipio m2
                             on m2.uf_id = u.sigla_uf
                     where m2.municipio_id = m.municipio_id) uf
              from logistica.v$operacao_municipio m       	    
             where 1=1
             <cfif len(trim(arguments.operacao_id))>
               and m.operacao_id = #arguments.operacao_id#
             </cfif>
             <cfif len(trim(arguments.origem_destino))>
               and m.origem_destino = #arguments.origem_destino#
             </cfif>
             order by uf, municipio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de carroceria da operacao
	-- CRISTOFER  12/05/2009
	--->		
	<cffunction name="get_operacao_tipo_carroceria" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.operacao_id, 
                   s.tipo_carroceria_id, 
                   vt.descricao tipo_carroceria,
                   va.descricao as agrupamento,
                   s.date_insert, 
                   s.user_insert, 
                   s.date_update, 
                   s.user_update, 
                   s.site
              from logistica.v$operacao_tipo_carroceria s
             inner join oper.v$veiculo_tipo_carroceria vt
                     on vt.tipo_carroceria_id = s.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vt.agrupamento_id
             where 1=1
             <cfif len(trim(arguments.operacao_id))>
               and s.operacao_id = #arguments.operacao_id#
             </cfif>
             order by vt.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os acessorios da operacao
	-- CRISTOFER  12/05/2009
	--->		
	<cffunction name="get_operacao_acessorio" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oa.operacao_id, 
                   oa.material_id, 
                   ma.descricao as acessorio,
                   mc.descricao as categoria,
                   oa.date_insert, 
                   oa.user_insert, 
                   oa.date_update, 
                   oa.user_update, 
                   oa.site
              from logistica.v$operacao_acessorio oa
             inner join oper.v$material_acessorio ma
                     on ma.material_id = oa.material_id
             inner join oper.v$material_categoria mc
                     on mc.CATEGORIA_ID = ma.CATEGORIA_ID
             where 1=1
             <cfif len(trim(arguments.operacao_id))>
               and oa.operacao_id = #arguments.operacao_id#
             </cfif>
             order by ma.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os acessorios da operacao
	-- RAFAEL 22/03/2010
	--->		
	<cffunction name="get_operacao_gerenciadora" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select g.descricao
                      from logistica.v$gerenciadora g
                     where g.gerenciadora_id = prg.gerenciadora_id) as descricao
                 , (select g.gerenciadora_id
                      from logistica.v$gerenciadora g
                     where g.gerenciadora_id = prg.gerenciadora_id) as gerenciadora_id
                 , (select g.padrao
                      from logistica.v$gerenciadora g
                     where g.gerenciadora_id = prg.gerenciadora_id) as padrao
                 , prg.obrigatoria
              from logistica.v$plano_risco_gerenciadora prg
             where prg.plano_risco_id = (select o.plano_risco_id
                                           from logistica.v$operacao_risco o
                                          where o.operacao_id = #arguments.operacao_id#)
             order by obrigatoria desc, padrao desc, descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de pagamento
    -- ANDERSON 13/06/2011 - CRIADO
    --->		
    <cffunction name="get_tipo_pagamento" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tp.tipo_pagamento_id
                 , tp.descricao
              from logistica.v$tipo_pagamento tp
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>
