<cfcomponent displayname="Componente com funcoes gerais"
		     extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Utilizado para a visualizacao de arquivos salvos no banco de dados no browser.
	-- CRISTOFER - 01/02/2006
	--->
	<cffunction name="mostrar_arquivo" output="true" access="public">
		<cfargument name="conteudo" required="yes" />
		<cfargument name="type" required="yes" />
		<CFCONTENT type="#arguments.type#" variable="#toBinary(arguments.conteudo)#" reset="yes">
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as Ufs
	-- CRISTOFER  01/11/2006
	--->
	<cffunction name="get_uf" access="remote" returntype="query" output="true">
		<cfargument name="with_ex" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct uf_id
			  from cep.municipio
			 where uf_id <> 'EX'
			<cfif arguments.with_ex eq 1>
			union all
			select 'EX'
			  from dual
			</cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os municipios
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_municipio" access="remote" returntype="query" output="true">
		<cfargument name="uf_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select municipio_id,
				   municipio,
				   pais_id,
				   uf_id,
				   cod_pessoa_un
			  from cep.municipio
			 where 1=1
			 <cfif len(trim(arguments.uf_id))>
			   and uf_id = '#ucase(arguments.uf_id)#'
			 </cfif>
			 order by upper(municipio)
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o municipio da pessoa
	-- CRISTOFER  20/11/2006
	--->
	<cffunction name="get_municipio_pessoa" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.municipio_id,
				   m.municipio,
				   m.uf_id uf
			  from kss.v$pessoa_endereco pe
			 inner join cep.municipio m
					 on m.municipio_id = pe.municipio_id
			 where cod_pessoa = #arguments.cod_pessoa#
			   and endereco_padrao = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os paises
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_pais" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pais_id,
				   descricao,
				   id_3,
                   id_2
			  from cep.pais
			 where 1=1
			 order by upper(descricao)
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os paises
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_parametro_num" access="remote" returntype="string" output="true">
    	<cfargument name="cod_projeto" required="yes">
    	<cfargument name="cod_aplicacao" required="yes">
    	<cfargument name="parametro_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.FNC_OBTEM_PARAMETRO_NUM(#arguments.cod_projeto#,'#arguments.cod_aplicacao#',#arguments.parametro_id#) valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o dado de um parametro
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_parametro_valor" access="remote" returntype="string" output="true">
    	<cfargument name="cod_projeto" required="yes">
    	<cfargument name="cod_aplicacao" required="yes">
    	<cfargument name="parametro_grupo_id" required="yes">
    	<cfargument name="parametro_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.fnc_obtem_parametro_str(#arguments.cod_projeto#,'#arguments.cod_aplicacao#',#arguments.parametro_grupo_id#,#arguments.parametro_id#) valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca o dado de um parametro
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_parametro_valor_lista" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_lista('#arguments.identificador#') as valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o dado de um parametro
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_parametro_valor_numerico" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_numerico('#arguments.identificador#') as valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o dado de um parametro
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_parametro_valor_string" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_string('#arguments.identificador#') as valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os dados da CG_REF_CODES
	-- CRISTOFER  16/04/2009
	--->
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
    	<cfargument name="owner" required="yes">
    	<cfargument name="rv_domain" required="yes">
    	<cfargument name="rv_low_value" required="no" default="">
    	<cfargument name="order" required="no" default="rv_low_value">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rv_domain,
                   rv_low_value,
                   rv_high_value,
                   rv_abbreviation,
                   rv_meaning,
                   owner
              from kss.cg_ref_codes
             where 1=1
               and owner = '#arguments.owner#'
               and rv_domain = '#arguments.rv_domain#'
             <cfif len(trim(arguments.rv_low_value))>
               and rv_low_value in (#arguments.rv_low_value#)
             </cfif>
             order by #order#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna se permite que o usurio habilite o vale pedgio na emisso de Contrato de Transporte
	-- ROGERSP 08/05/2014 - CRIADO
	--->
 <cffunction name='verifica_emissao' displayname='Retorna se permite que o usurio habilite o vale pedgio na emisso de Contrato de Transporte' access='remote' returntype='Struct' output='true'>
	<cfargument name='OPERACAO_ID' required='yes'>
	<cfargument name='NUM_ROMANEIO' required='yes'>
	<cfargument name='SOLICITACAO_CARGA_ID' required='no'  default="">
	<cfargument name='VIAGEM_ID' required='no'  default="">
	<cftry>
			<cfstoredproc procedure='oper.pkg_vale_pedagio.prc_verifica_emissao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.NUM_COMPROVANTE' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EMITE_VALEPEDAGIO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MENSAGEM_RETORNO' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR' >
			</cfstoredproc>
			<cfset retorno.erro = false>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

 <cffunction name='verifica_emissao_vale_pedagio' displayname='Retorna se permite que o usu▒rio habilite o vale ped▒gio na emiss▒o de Contrato de Transporte' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
        <cfargument name='VIAGEM_ID' required='no' default="">
		<cfargument name='PLACA' required='no' default="">
		<cfargument name='EMISSAO_CONTRATO' required='no' default="">
        <cftry>
                        <cfstoredproc procedure='oper.pkg_vale_pedagio.prc_verifica_emissao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.NUM_COMPROVANTE' >
                                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EMITE_VALEPEDAGIO' >
                                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.MENSAGEM_RETORNO' >
                                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR' >
								<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.PLACA#'  null='#iif(len(trim(arguments.PLACA)), de('no'), de('yes'))#'>
								<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMISSAO_CONTRATO#'  null='#iif(len(trim(arguments.EMISSAO_CONTRATO)), de('no'), de('yes'))#'>
                        </cfstoredproc>
                        <cfset retorno.erro = false>
                <cfcatch>
                        <cfset retorno.erro = true>
						<cfset retorno.EMITE_VALEPEDAGIO = 0>
                        <cfset retorno.mensagem = cfcatch>
                        <cfset request.erro = cfcatch>
                </cfcatch>
        </cftry>
        <cfreturn retorno />
</cffunction>

<cffunction name="get_item_contrato_interface" access="remote" returntype="query" output="true">
	<cfargument name="TIPO_TAXA_ID" required="yes">
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select it.item_id
		  from oper.v$contrato_transp_item_setup it
		 inner join oper.v$contrato_transp_tipo_taxa tt
			on tt.item_id = it.item_id
		 where tt.tipo_taxa_id = '#arguments.TIPO_TAXA_ID#'
	</cfquery>
	<cfreturn qr_result>
</cffunction>

<!---
-- PROPSITO
-- Busca se um recurso est liberado
--->
<cffunction name="get_recurso_liberado" access="remote" returntype="string" output="true">
	<cfargument name="identificador" required="yes">
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select kss.pkg_controle.fnc_recurso_liberado('#arguments.identificador#') as liberado from dual
	</cfquery>
	<cfreturn qr_result.liberado>
</cffunction>

<!---
-- PROPSITO
-- Busca se um recurso est ativo
--->
<cffunction name="get_recurso_ativo" access="remote" returntype="string" output="true">
	<cfargument name="identificador" required="yes">
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select kss.pkg_controle.fnc_recurso_ativo('#arguments.identificador#') as liberado from dual
	</cfquery>
	<cfreturn qr_result.liberado>
</cffunction>

</cfcomponent>
