<cfcomponent extends="_transportes.funcoes.cfc_init">

  <!--- 
  -- PROPÓSITO 
  -- Busca histórico de transferencias
  -- NOTAS EXPLICATIVAS
  -- GUTO 06/05/2006
  --->
  <cffunction name="get_log_transferencias" access="remote" returntype="query" output="true">
      <cfargument name="LANCTO_ID" required="yes">    
    <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select l.log
                 , l.user_insert
                 , to_char(l.date_insert, 'dd/MM/yyyy hh24:mi:ss') as date_insert
              from oper.v$transferencia_impressao_log l
             where l.lancto_id = #arguments.LANCTO_ID#
             order by date_insert desc
    </cfquery>
  <cfreturn qr_result>
  </cffunction>

  <!--- 
  -- PROPÓSITO 
  -- Busca centros de custo
  -- NOTAS EXPLICATIVAS
  -- GUTO 06/05/2006
  --->
  <cffunction name="get_centros_custo" access="remote" returntype="query" output="true">
    <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
      select cc.cod_centro_custo
                 , cc.centro_custo 
              from kss.v$centro_custo cc
    </cfquery>
  <cfreturn qr_result>
  </cffunction>
    
  <!--- 
  -- PROPÓSITO 
  -- Busca centros de custo liberado
  -- NOTAS EXPLICATIVAS
  -- GUTO 06/05/2006
  --->
  <cffunction name="get_centro_custo_liberado" access="remote" returntype="query" output="true">
      <cfargument name="LANCTO_ID" required="yes">
    <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select cc.centro_custo
              from oper.v$contrato_transp ct
             inner join kss.v$centro_custo cc
                on cc.cod_centro_custo = ct.centro_custo_liberado_impr
             where ct.lancto_id = #arguments.LANCTO_ID#
    </cfquery>
  <cfreturn qr_result>
  </cffunction>    

  <!--- 
  -- PROPÓSITO 
  -- Busca tipos de frete
  -- NOTAS EXPLICATIVAS
  -- GUTO 06/05/2006
  --->
  <cffunction name="get_tipo_frete" access="remote" returntype="query" output="true">
    <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
      select produto_id, descricao
              from fiscal.v$produto t
       where t.conhecimento = 1
    </cfquery>
  <cfreturn qr_result>
  </cffunction>

    <!---
  -- PROPÓSITO
  -- Busca Regras fiscais do Cliente
  -- Wagner //2006
  --->
  <cffunction name="get_lote_regra_fiscal" access="remote" returntype="query" output="true">
    <cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
      select distinct lr.regra_fiscal_id, lr.descricao
          from fiscal.v$regra_fiscal lr
      where ativa = 1
    </cfquery>
  <cfreturn qr_lote>
  </cffunction>

    <!---
  -- PROPÓSITO
  -- Busca os dados da operacao
  -- CRISTOFER  24/11/2006
  --->
  <cffunction name="get_solicitacao_carga_dados" access="remote" returntype="query" output="true">
    <cfargument name="viagem_carga_id" required="no" default="">
                <cfargument name="solicitacao_carga_id" required="no" default="">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.operacao_id, o.descricao as operacao,
                   sc.valor_em as frete_em,
                   o.fracionado,
                   sc.cod_remetente cod_pessoa_remetente,
                   sc.cod_organograma,
                   (select nvl(min(scd.valor_pedagio_rota) keep(dense_rank first order by sc.data_carregamento_inicio), 0)
                      from repom.v$solicitacao_carga_dados scd
                     where scd.solicitacao_carga_id = sc.solicitacao_carga_id
                   ) as valor_pedagio_rota,
                   (select max(c.cartao_numero) keep(dense_rank last order by scd.date_insert)
                      from repom.v$solicitacao_carga_dados scd
                      left join repom.v$cartao c
                        on c.cartao_id = scd.cartao_id
                     where scd.solicitacao_carga_id = sc.solicitacao_carga_id
                   ) as cartao_numero,
                   ro.rota_id,
                   ro.descricao_rota,
                   ro.rota_possui_pedagio,
                   o.pagto_vale_pedagio,
           sc.cod_transportador_sugerido
                from logistica.v$operacao o
                inner join logistica.v$solicitacao_carga sc
                        on sc.operacao_id = o.operacao_id
                inner join logistica.v$viagem_carga vc
                        on vc.solicitacao_carga_id = sc.solicitacao_carga_id
                 left join oper.v$rota ro
                   on ro.origem_municipio_id = sc.origem_municipio_id
                  and ro.destino_municipio_id = sc.destino_municipio_id
                  and (ro.origem_cod_pessoa  is null or ro.origem_cod_pessoa  = nvl(sc.cod_consignatario,sc.cod_remetente))
                  and (ro.destino_cod_pessoa is null or ro.destino_cod_pessoa = nvl(sc.cod_redespacho,sc.cod_destinatario))
          and ro.data_cancelamento is null
               where 1=1
             <cfif len(trim(arguments.viagem_carga_id))>
                 and vc.viagem_carga_id = #arguments.viagem_carga_id#
       </cfif>
             <cfif len(trim(arguments.solicitacao_carga_id))>
     and sc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
             </cfif>
    </cfquery>
    <cfreturn qr_result>
  </cffunction>

    <!---
  -- PROPÓSITO
  -- Busca os dados do manifesto para
  -- CRISTOFER  24/11/2006
  --->
  <cffunction name="get_manifesto_ct" access="remote" returntype="query" output="true">
    <cfargument name="num_manifesto" required="no" default="">
    <cfargument name="cod_pessoa_filial" required="no" default="">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      select m.manifesto_id,
           m.num_manifesto,
           sum(c.peso) peso,
           fiscal.pkg_fiscal.fnc_converte_peso(sum(c.peso),min(cod_unidade),'Ton') peso_ton,
           sum(c.m3) m3,
           sum(c.volume) volume,
           min(cod_unidade) cod_unidade,
           m.placa_tracao,
           m.placa_reboque,
           oper.pkg_veiculo.fnc_veiculo_proprietario(m.placa_tracao) as veiculo_proprietario, /*1 - Frota, 2 - Agregado, 3 - Terceiro*/
           case when exists (select 0
                                        from oper.v$contrato_transp_manifesto ct
                                       where ct.manifesto_id = m.manifesto_id) then 1
              else 0
           end vinculado_ct,
           case when exists (select 0
                               from oper.v$romaneio roo
                                    inner join oper.v$contrato_transp ct
                                            on ct.num_romaneio = roo.num_romaneio
                    where roo.num_romaneio = c.num_romaneio
                      and ct.data_cancelamento is null) and m.roo_item_id is not null then 1
              else 0
           end vinculado_roo,
           m.num_lote
        from oper.v$manifesto m
       inner join oper.v$manifesto_conhecimento mc
           on mc.manifesto_id = m.manifesto_id
       inner join fiscal.v$conhecimento c
           on c.conhecimento_id = mc.conhecimento_id
       where 1=1
       <cfif len(trim(arguments.num_manifesto))>
         and m.num_manifesto = #arguments.num_manifesto#
       </cfif>
       <cfif len(trim(arguments.cod_pessoa_filial))>
             and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
       </cfif>
       group by m.manifesto_id,
            m.num_manifesto,
            m.placa_tracao,
            m.placa_reboque,
            m.num_lote,
            c.num_romaneio,
                      m.roo_item_id
    </cfquery>
    <cfreturn qr_result>
  </cffunction>

    <!---
  -- PROPÓSITO
  -- Busca os contratos de transporte
  -- ANDERSON - 14/07/2009 - ALTERADO
  --->
  <cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">
      <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="placa_controle" required="no" default="">
        <cfargument name="proprietario_cod_pessoa" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
      <cfargument name="tipo_contrato" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="tipo_pagto_id" required="no" default="">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */c.lancto_id
				 , c.num_romaneio
				 , c.num_formulario
				 , c.serie_formulario
				 , c.cod_modelo
				 , c.cod_pessoa_filial
				 , c.cod_departamento
				 , c.cod_setor
				 , c.cod_centro_custo
				 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
				 , c.peso
				 , c.volume
				 , c.m3
				 , c.frete_em
				 , c.cod_unidade
				 , c.tolerancia_falta
				 , c.valor_unitario
				 , c.valor_frete_bruto
				 , c.valor_frete_liquido
				 , (select nvl(sum(valor),0)
					  from oper.v$contrato_transp_item cti
					 where cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('PEDAGIO_NO_FRETE'))
					   and cti.lancto_id = c.lancto_id
					   and cti.data_cancelamento is null) as valor_pedagio
				 , (select nvl(sum(valor),0)
					  from oper.v$contrato_transp_item cti
					 where cti.lancto_id = c.lancto_id
					   and cti.adiantamento = 1
					   and cti.data_cancelamento is null) as valor_adiant
				 ,(select nvl(sum(valor),0)
					 from oper.v$contrato_transp_item cti
					where cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('IRRF')
										 ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('SEST')
										 ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('SENAT')
										 ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('INSS'))
					  and cti.lancto_id = c.lancto_id
					  and cti.data_cancelamento is null) as valor_total_impostos
				 , (nvl(c.valor_frete_liquido,0) + (select nvl(sum(valor * decode(cti.desconto,0,1,-1)),0)
													   from oper.v$contrato_transp_item cti
													  where cti.lancto_id = c.lancto_id
														and cti.compoe_frete = 1
														and cti.data_cancelamento is null)) as valor_saldo_frete
				 , c.motorista_cod_pessoa
				 ,(select mot.cnpj_cpf || ' - ' || upper(mot.razao_social)
					 from kss.v$pessoa mot
					where mot.cod_pessoa = c.motorista_cod_pessoa) as motorista
				 , c.placa_controle
				 , oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) as cod_veiculo_controle
				 , c.placa_referencia
				 , oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_referencia) as cod_veiculo_referencia
				 , c.proprietario_cod_pessoa
				 , (select upper(prop.razao_social)
					  from kss.v$pessoa prop
					 where prop.cod_pessoa = c.proprietario_cod_pessoa) as proprietario
				 , c.proprietario_endereco
				 , c.proprietario_municipio_id
				 , c.proprietario_nit
				 , c.recebedor_cod_pessoa
				 , kss.pkg_pessoa.fnc_get_cliente(c.recebedor_cod_pessoa) as recebedor
				 , case c.tipo_contrato
					  when 0 then -- Terceiro
						 case 
							when c.conhecimento_id is not null then
							   (select cep.fnc_municipio_uf(con.origem_municipio_id)
								  from fiscal.v$conhecimento con
								 where con.conhecimento_id = c.conhecimento_id)
							when c.conhecimento_id_diaria is not null then
							   (select cep.fnc_municipio_uf(con.origem_municipio_id)
								  from fiscal.v$conhecimento con
								 where con.conhecimento_id = c.conhecimento_id_diaria)
							else
							   (select cep.fnc_municipio_uf(r.org_municipio_id)
								  from oper.v$romaneio r
								 where r.num_romaneio = c.num_romaneio)
						 end
					  when 1 then -- Agregado
						 (select cep.fnc_municipio_uf(av.municipio_id_origem)
							from oper.v$agreg_viagem av
						   where av.lancto_id = c.lancto_id)
					  end as origem
				 , case c.tipo_contrato
					  when 0 then -- Terceiro
						 case
							when c.conhecimento_id is not null then
							   (select cep.fnc_municipio_uf(con.origem_municipio_id)
								  from fiscal.v$conhecimento con
								 where con.conhecimento_id = c.conhecimento_id)
							when c.conhecimento_id_diaria is not null then
							   (select cep.fnc_municipio_uf(con.origem_municipio_id)
								  from fiscal.v$conhecimento con
								 where con.conhecimento_id = c.conhecimento_id_diaria)
							else
							   (select cep.fnc_municipio_uf(r.dest_municipio_id,'-')
								  from oper.v$romaneio r
								 where r.num_romaneio = c.num_romaneio)
						 end
					  when 1 then -- Agregado
						 (select cep.fnc_municipio_uf(av.municipio_id_destino)
							from oper.v$agreg_viagem av
						   where av.lancto_id = c.lancto_id)
				   end as destino
				 , c.impresso
				 , c.observacao
				 , c.proprietario_municipio_id
				 , c.num_rpa
				 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
				 , c.usuario_cancelamento
				 , c.motivo_cancelamento
				 , c.tipo_contrato
				 , case
					  when oper.pkg_veiculo.fnc_veiculo_modalidade(c.placa_controle, c.data_emissao) = 'AGREGADO' then 'AGREGADO'
					  else 'TERCEIRO'
				   end as tipo_contrato_desc
				 , c.parcela
				 , c.total_parcela
				 , c.valor_parcelamento
				 , c.lancto_id_pai
				 , c.user_insert
				 , c.date_insert
				 , c.user_update
				 , c.date_update
				 , c.site
				 , av.viagem_id
				 , c.cod_organizacional
				 , c.organizacional_id
				 , (select descricao
					  from kss.v$organizacional o
					 where o.organizacional_id = c.organizacional_id) as organizacional
				 , c.status_aprovacao
				 , c.centro_custo_liberado_impr
				 , oper.pkg_contrato_transp.fnc_centro_custo_liberado_impr(c.lancto_id) as is_centro_custo_liberado
				 , (select sign(count(1))
					  from table (select acesso.pkg_controle_acesso.fnc_get_acao_web(p_web_url => '/modulos/contratotransp/relacao/principal.cfm', p_usuario => user)
									from dual)
					 where column_value = 'TRANSFERENCIA_IMPRESSAO_CF') as ACAO_TRANSFERENCIA
				 , c.usuario_aprovacao
				 , c.data_aprovacao
			  from oper.v$contrato_transp c
			  left join oper.v$agreg_viagem av
				on av.lancto_id = c.lancto_id
			 where 1 = 1
			   and c.lancto_id_pai is null
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and c.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.placa_controle))>
               and (c.placa_controle = '#arguments.placa_controle#'
                    or oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) = '#arguments.placa_controle#')
            </cfif>
            <cfif Len(Trim(arguments.proprietario_cod_pessoa))>
               and c.proprietario_cod_pessoa = #arguments.proprietario_cod_pessoa#
            </cfif>
      <cfif Len(Trim(arguments.num_formulario))>
               and c.num_formulario = #arguments.num_formulario#
            </cfif>
            <cfif Len(Trim(arguments.lancto_id))>
               and c.lancto_id = #arguments.lancto_id#
            </cfif>
            <cfif Len(Trim(arguments.cancelada))>
        <cfif arguments.cancelada eq 1>
                  and c.data_cancelamento is not null
                <cfelse>
                  and c.data_cancelamento is null
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.tipo_contrato))>
               and c.tipo_contrato = #arguments.tipo_contrato#
            </cfif>
            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
               and c.organizacional_id = #arguments.organizacional_id_gerencial#
            </cfif>
      <cfif Len(Trim(arguments.data_inicial))>
               and c.data_emissao >= trunc(to_date('#arguments.data_inicial#'))
            </cfif>
            <cfif Len(Trim(arguments.data_final))>
               and c.data_emissao <= trunc(to_date('#arguments.data_final#')) + 1 - 1/24/60/60
            </cfif>
            <cfif Len(Trim(arguments.tipo_pagto_id))>
               and c.tipo_pagto_id = #arguments.tipo_pagto_id#
            </cfif>
             order by c.data_emissao
    </cfquery>
    <cfreturn qr_result>
  </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados da Carta Frete a serem impressos
    -- ANDERSON 13/11/2009 - CRIADO
    --->
    <cffunction name="get_contrato_transp_form" access="remote" returntype="query" output="true">
        <cfargument name="documento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctf.documento_id
                 , ctf.cf_numero
                 , ctf.cf_num_romaneio
                 , ctf.cf_origem
                 , ctf.cf_destino
                 , ctf.cf_data_emissao
                 , ctf.cf_emissao_data
                 , ctf.cf_filial_dados
                 , ctf.cf_documentos_origem
                 , ctf.cf_proprietario
                 , ctf.cf_prop_endereco
                 , ctf.cf_prop_cep
                 , ctf.cf_prop_municipio
                 , ctf.cf_prop_uf
                 , ctf.cf_prop_cnpj_cpf
                 , ctf.cf_prop_inscricao_estadual
                 , ctf.cf_prop_pis
                 , ctf.cf_motorista
                 , ctf.cf_mot_endereco
                 , ctf.cf_mot_municipio
                 , ctf.cf_mot_uf
                 , ctf.cf_mot_cpf
                 , ctf.cf_mot_rg_uf
                 , ctf.cf_mot_cnh
                 , ctf.cf_mot_cnh_validade
                 , ctf.cf_mot_cnh_completa
                 , ctf.cf_placa_tracao
                 , ctf.cf_placa_carreta
                 , ctf.cf_uf_tracao
                 , ctf.cf_uf_carreta
                 , ctf.cf_veiculo_marca
                 , ctf.cf_quantidade
                 , ctf.cf_valor_unitario
                 , ctf.cf_valor_servico
                 , ctf.cf_irrf
                 , ctf.cf_pedagio
                 , ctf.cf_outros_cred
                 , ctf.cf_sest_senat
                 , ctf.cf_total_impostos
                 , ctf.cf_outros_deb
                 , ctf.cf_valor_liquido
                 , ctf.cf_inss
                 , ctf.cf_adiant_extenso
                 , ctf.cf_adiant
                 , ctf.cf_adiant_pedagio
                 , ctf.cf_adiant_frete
                 , ctf.cf_saldo_frete_ext
                 , ctf.cf_saldo_frete
                 , ctf.cf_observacao
                 , ctf.cf_data_cancelamento
                 , ctf.cf_descarga_motorista
         , ctf.cf_saldo_menos_adiant_frete
         , nvl(to_char((select sum(cti.valor)
                            from oper.v$contrato_transp_item cti
                           inner join oper.v$contrato_transp_item_setup ctis
                              on ctis.item_id = cti.item_id
                           where cti.data_cancelamento is null
                             and cti.lancto_id = ctf.documento_id
                             and cti.exibe_item_impressao = 1
                             and ctis.cod_evento_rpa is null
                             and ctis.desconto = 1),'FM999G990D00','nls_numeric_characters=,.'),'0,00') as outros_descontos
         , nvl(to_char((select sum(cti.valor)
                    from oper.v$contrato_transp_item cti
                 inner join oper.v$contrato_transp_item_setup ctis
                  on ctis.item_id = cti.item_id
                 where cti.data_cancelamento is null
                   and cti.lancto_id = ctf.documento_id
                   and ctis.cod_evento_rpa is null
                   and cti.exibe_item_impressao = 1
                   and ctis.item_id not in (oper.pkg_contrato_transp.fnc_get_tipo_taxa(p_tipo_taxa_id => 'PEDAGIO_NO_FRETE')) -- Tira o PEDAGIO
                   and ctis.desconto = 0),'FM999G990D00','nls_numeric_characters=,.'),'0,00') as outros_acrescimos
              from oper.v$contrato_transp_form ctf
             where ctf.documento_id = #arguments.documento_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o próximo número de formulário para o organograma definido
    -- ANDERSON 27/11/2009 - CRIADO
    --->
    <cffunction name="get_prox_num_formulario" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="yes">
        <cfargument name="cod_departamento" required="yes">
        <cfargument name="cod_setor" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select nvl(max(ct.num_formulario) + 1, 1) as prox_num_formulario
              from oper.v$contrato_transp ct
             where ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and ct.cod_departamento = #arguments.cod_departamento#
               and ct.cod_setor = #arguments.cod_setor#
               and ct.cod_centro_custo = #arguments.cod_centro_custo#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o próximo número de formulário para o organograma definido dentro dos limites configurados
    -- ANDERSON 27/11/2009 - CRIADO
    --->
    <cffunction name="get_prox_num_formulario_limite" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="yes">
        <cfargument name="cod_departamento" required="yes">
        <cfargument name="cod_setor" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfargument name="serie" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select to_char(oper.pkg_contrato_transp.fnc_prox_num_formulario(p_tipo_pagto_id     => 1
                                                                 , p_cod_pessoa_filial => #arguments.cod_pessoa_filial#
                                                                 , p_cod_departamento  => #arguments.cod_departamento#
                                                                 , p_cod_setor         => #arguments.cod_setor#
                                                                 , p_cod_centro_custo  => #arguments.cod_centro_custo#

                                                                 <cfif Len(Trim(arguments.serie))>
                                                                 , p_serie             => '#arguments.serie#'
                                                                 <cfelse>
                                                                 , p_serie             => null
                                                                 </cfif>

                                                                 <cfif Len(Trim(arguments.cod_modelo))>
                                                                 , p_cod_modelo        => '#arguments.cod_modelo#'
                                                                 <cfelse>
                                                                 , p_cod_modelo        => null
                                                                 </cfif>

                                                                 <cfif Len(Trim(arguments.num_romaneio))>
                                                                 , p_num_romaneio      => #arguments.num_romaneio#
                                                                 <cfelse>
                                                                 , p_num_romaneio      => null
                                                                 </cfif>

                                                                 <cfif Len(Trim(arguments.operacao_id))>
                                                                 , p_operacao_id       => #arguments.operacao_id#
                                                                 <cfelse>
                                                                 , p_operacao_id       => null
                                                                 </cfif>

                                                                )) as prox_num_formulario
            from dual
          
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
  -- PROPÓSITO
  -- Busca usuários que possuem alçada para liberação
  --->
  <cffunction name="get_alcada_liberacao_controle" access="remote" returntype="query" output="true">
    <cfargument name="OPERACAO" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct al.operacao, al.usuario, u.nome
              from oper.v$alcada_liberacao_controle al
             inner join kss.v$kss_usuarios u
                     on u.usuario = al.usuario
            where al.valor_alcada > 0
            <cfif Len(Trim(arguments.OPERACAO)) >
              and al.operacao in (#ListQualify(arguments.operacao, "'", ",")#)
            </cfif>
    </cfquery>
  <cfreturn qr_result>
  </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os veículos de um romaneio
    -- ANDERSON 14/09/2011 - CRIADO
    --->
    <cffunction name="get_veiculos_romaneio" access="remote" returntype="query" output="true">
      <cfargument name="num_romaneio" required="yes">
    <cfargument name="repom" required="no" default="0">
    <cfargument name="pagbem" required="no" default="0">
    <cfargument name="target" required="no" default="0">
        <cfargument name="valecard" required="no" default="0">
		<cfargument name="REPOMFRETE" required="no" default="0">
		<cfargument name="WEX" required="no" default="0">
		<cfargument name="EXTRATTA" required="no" default="0">
		<cfargument name="TIPO_PAGTO_ID" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rhv.placa_controle
                 , rhv.placa_referencia
                 , to_char(rhv.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio
              <cfif arguments.repom eq 1>
         , (select max(c.cartao_numero) keep(dense_rank last order by ct.date_insert)
                      from repom.v$contrato ct
                     inner join repom.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
         , null as cartao_numero_historico_prop
          <cfelseif arguments.pagbem eq 1>
             , (select max(c.cartao_numero) keep(dense_rank last order by ct.date_insert)
                      from pagbem.v$contrato ct
                     inner join pagbem.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
         , (select cs2.cartao_proprietario
            from pagbem.v$cartao_solicitacao cs2
                     where cs2.solicitacao_carga_id = (select max(c2.solicitacao_carga_id)
                                                         from oper.v$contrato_transp c2
                                                        where c2.tipo_pagto_id = 6
                                                          and c2.data_cancelamento is null
                                                          and c2.proprietario_cod_pessoa = (select vpa.cod_pessoa
                                                                                              from oper.v$veiculo_proprietario_atual vpa
                                                                                             where vpa.placa = rhv.PLACA_CONTROLE))) as cartao_numero_historico_prop
          <cfelseif arguments.target eq 1>
             , pagfrete.pkg_contrato.fnc_ultimo_cartao_usado(rhv.num_romaneio, 7, 1) as cartao_numero_historico
                 , pagfrete.pkg_contrato.fnc_ultimo_cartao_usado(rhv.num_romaneio, 7, 0) as cartao_numero_historico_prop
			  <cfelseif arguments.valecard eq 1 or arguments.REPOMFRETE eq 1 or arguments.WEX eq 1 or arguments.EXTRATTA eq 1>
		         , (select max(c.num_cartao) keep(dense_rank last order by ct.date_insert)
                      from pagfrete.v$contrato ct
                     inner join pagfrete.v$motorista_cartao c
                        on c.motorista_cartao_id = ct.motorista_cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.cancelamento_data is null
             and c.cartao_operadora_pagto_frete = #arguments.tipo_pagto_id#
                   ) as cartao_numero_historico
         , null as cartao_numero_historico_prop
        <cfelse>
             , null as cartao_numero_historico
         , null as cartao_numero_historico_prop
        </cfif>
              from oper.v$romaneio_hist_veiculo rhv
             where rhv.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os veículos de um romaneio
    -- ANDERSON 14/09/2011 - CRIADO
    --->
    <cffunction name="get_contrato_parcelamento" access="remote" returntype="query" output="true">
      <cfargument name="data_emissao" required="yes">
        <cfargument name="placa_controle" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.parcelamento_id
                 , x.item_id
                 , x.descricao
                 , x.valor
                 , x.parcela
                 , x.total_parcelas
              from table (select agreg.pkg_agreg.fnc_contrato_parcelamento(oper.pkg_veiculo.fnc_veiculo_id('#arguments.placa_controle#'),nvl('#arguments.data_emissao#', sysdate) )
                            from dual ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
  -- PROPÓSITO
  -- Retorna os valores disponíveis para uma carta frete
  -- ANDERSONC 24/06/2011 09:54:00 - CRIADO
  --->
  <cffunction name='valores_contrato' displayname='Retorna os valores disponíveis para uma carta frete' access='remote' returntype='Struct' output='true'>
    <cfargument name='NUM_ROMANEIO' required='yes'>
    <cfargument name='CONHECIMENTO_ID' required='yes'>
    <cfargument name='CRT_ID_DIARIA' required='yes'>
    <cfargument name='DIVISAO_ID' required='yes'>
    <cfargument name='LANCTO_ID' required='no' default="">
    <cfargument name='MOVIMENTO_AVULSO' required='no' default="0">
    <cftry>
            <cfstoredproc procedure='oper.pkg_contrato_transp.prc_valores_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CRT_ID_DIARIA#'  null='#iif(len(trim(arguments.CRT_ID_DIARIA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DIVISAO_ID#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_RECEITA' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_CF_ACUMULADO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_MAXIMO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOVIMENTO_AVULSO#'  null='#iif(len(trim(arguments.MOVIMENTO_AVULSO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
      <cfcatch>
        <cfset retorno.erro = true>
        <cfset retorno.mensagem = cfcatch>
        <cfset request.erro = cfcatch>
      </cfcatch>
    </cftry>
    <cfreturn retorno />
  </cffunction>

    <!---
    -- PROPÓSITO
    -- Dados para a impressão do contrato
    -- GUTO 19/10/2012 - CRIADO
    --->
    <cffunction name="get_contrato_transp_impressao_formulario" access="remote" returntype="query" output="true">
        <cfargument name="documento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ct.num_formulario as doc_contrato, ct.observacao, ct.lancto_id,
                   (select pe.municipio
                      from kss.v$pessoa_endereco pe
                     where pe.cod_pessoa = ct.cod_pessoa_filial
                       and pe.endereco_padrao = 1) as municipio_emissao,
                   to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   to_char(ct.data_emissao, 'dd')||' de '||to_char(ct.data_emissao, 'month')||' de '||to_char(ct.data_emissao, 'yyyy') as data_emissao_extenso,
                   (select p.razao_social from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_pessoa_filial) as emitente_razao_social,
                   (select p.endereco_completo
                      from kss.v$pessoa_endereco_padrao p
                     where p.cod_pessoa = ct.cod_pessoa_filial) as emitente_endereco,
                   kss.pkg_pessoa.fnc_get_identificador(ct.cod_pessoa_filial) as emitente_cnpj,
                   (select 'CNPJ: '||p.identificador
                      from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_pessoa_filial) as filial_cnpj_cpf
                , upper(prop.razao_social) as transportador_nome
                , upper(ct.proprietario_endereco) as transportador_endereco
                , upper(propm.municipio) as transportador_municipio
                , propm.uf_id as transportador_uf
                , (select ptp.telefone
                     from kss.v$pessoa_telefone_padrao ptp
                    where ptp.cod_pessoa = ct.proprietario_cod_pessoa) as transportador_telefone
                , prop.identificador as transportador_cnpj
                , mot.razao_social as motorista_nome
                , decode(mot.tipo_pessoa, 1, mote.logradouro || ', ' || mote.numero || ' ' || mote.bairro, (select pex.endereco
                                                                                                              from kss.v$pessoa_estrangeira pex
                                                                                                             where pex.cod_pessoa = mot.cod_pessoa))  as motorista_endereco
                , decode(mot.tipo_pessoa, 1, upper(mote.municipio), (select pex.municipio
                                                                       from kss.v$pessoa_estrangeira pex
                                                                      where pex.cod_pessoa = mot.cod_pessoa)) as motorista_municipio
                , decode(mot.tipo_pessoa, 1, mote.uf, (select pex.estado_provincia
                                                         from kss.v$pessoa_estrangeira pex
                                                        where pex.cod_pessoa = mot.cod_pessoa)) as motorista_uf
                , ct.placa_controle as placa_tracao
                , (select telefone
                    from kss.v$pessoa_telefone_padrao mt
                   where mt.cod_pessoa = ct.motorista_cod_pessoa) as motorista_telefone
                , mot.cnpj_cpf as motorista_cnpj
                , (select pf.cnh_num_registro
                     from kss.v$pessoa_fisica pf
                    where pf.cod_pessoa = ct.motorista_cod_pessoa) as motorista_cnh
                , ct.placa_controle as cf_placa_tracao
                , (select cor_predominante from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_cor,
                   (select ano from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_ano,
                   (select chassis from oper.v$veiculo v
                   where v.placa = ct.placa_controle) as tracao_chassis,
                   (select renavan from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_renavam,
                   (select vm2.marca|| ' ' || vm.modelo from oper.v$veiculo v
                         inner join oper.v$veiculo_modelo vm
                                 on vm.modelo_id = v.modelo_id
                         inner join oper.v$veiculo_marca vm2
                                 on vm2.marca_id = v.marca_id
                              where v.placa = ct.placa_controle) as tracao_modelo,

                   case
                       when ct.placa_controle <> ct.placa_referencia then ct.placa_referencia
                   end  as tracionado_placa,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.cor_predominante from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_cor,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.ano from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_ano,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.chassis from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_chassis,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.renavan from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_renavam
                ,  case ct.tipo_contrato
                       when 0 then -- Terceiro
                          case
                             when ct.conhecimento_id is not null then
                                (select cep.fnc_municipio_uf(c.origem_municipio_id)
                                   from fiscal.v$conhecimento c
                                  where c.conhecimento_id = ct.conhecimento_id)
                             when ct.conhecimento_id_diaria is not null then
                                (select cep.fnc_municipio_uf(c.origem_municipio_id)
                                   from fiscal.v$conhecimento c
                                  where c.conhecimento_id = ct.conhecimento_id_diaria)
                             else
                                (select cep.fnc_municipio_uf(r.org_municipio_id)
                                   from oper.v$romaneio r
                                  where r.num_romaneio = ct.num_romaneio)
                          end
                       when 1 then -- Agregado
                          (select cep.fnc_municipio_uf(av.municipio_id_origem)
                             from oper.v$agreg_viagem av
                            where av.lancto_id = ct.lancto_id)
                    end as coleta_municipio
                , case ct.tipo_contrato
                     when 0 then -- Terceiro
                          case
                             when ct.conhecimento_id is not null then
                                (select cep.fnc_municipio_uf(c.origem_municipio_id)
                                   from fiscal.v$conhecimento c
                                  where c.conhecimento_id = ct.conhecimento_id)
                             when ct.conhecimento_id_diaria is not null then
                                (select cep.fnc_municipio_uf(c.origem_municipio_id)
                                   from fiscal.v$conhecimento c
                                  where c.conhecimento_id = ct.conhecimento_id_diaria)
                             else
                                (select cep.fnc_municipio_uf(r.dest_municipio_id,'-')
                                   from oper.v$romaneio r
                                  where r.num_romaneio = ct.num_romaneio)
                          end
                       when 1 then -- Agregado
                          (select cep.fnc_municipio_uf(av.municipio_id_destino)
                             from oper.v$agreg_viagem av
                            where av.lancto_id = ct.lancto_id)
                    end as entrega_municipio

                , nvl2(ct.valor_frete_liquido, to_char(ct.valor_frete_liquido,'FM9G9999G990D00','nls_numeric_characters=,.'), '0,00')as frete_bruto
                  , to_char((select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              where cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('PEDAGIO_NO_FRETE'))
                                and cti.lancto_id = ct.lancto_id
                                and cti.data_cancelamento is null),'FM9G9999G990D00','nls_numeric_characters=,.') as frete_pedagio
                  , to_char((select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              where cti.item_id = oper.pkg_contrato_transp.fnc_get_tipo_taxa('IRRF')
                                and cti.lancto_id = ct.lancto_id
                                and cti.data_cancelamento is null),'FM9G9999G990D00','nls_numeric_characters=,.') as frete_irrf
                  , to_char((select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              where cti.item_id = oper.pkg_contrato_transp.fnc_get_tipo_taxa('INSS')
                                and cti.lancto_id = ct.lancto_id
                                and cti.data_cancelamento is null),'FM9G9999G990D00','nls_numeric_characters=,.') as frete_inss
                  , to_char((nvl(ct.valor_frete_liquido,0)
                           -(select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              inner join oper.v$contrato_transp_item_setup cs
                                 on cs.item_id = cti.item_id
                              where cti.lancto_id = ct.lancto_id
                                and cs.desconto = 1
                                and cs.compoe_frete = 1
                                and cti.data_cancelamento is null)
                           +(select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              inner join oper.v$contrato_transp_item_setup cs
                                 on cs.item_id = cti.item_id
                              where cti.lancto_id = ct.lancto_id
                                and cs.desconto = 0
                                and cs.compoe_frete = 1
                                and cti.data_cancelamento is null)),'FM9G9999G990D00','nls_numeric_characters=,.') as cf_liquido_a_pagar
                  , to_char((select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              where cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('PEDAGIO_NO_FRETE')
                                                   ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO'))
                                and cti.lancto_id = ct.lancto_id
                                and cti.data_cancelamento is null),'FM9G9999G990D00','nls_numeric_characters=,.') as adto_pedagio
                  , to_char((select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              where cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('SEST')
                                                   ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('SENAT'))
                                and cti.lancto_id = ct.lancto_id
                                and cti.data_cancelamento is null),'FM9G9999G990D00','nls_numeric_characters=,.') as frete_sest_senat
                  , to_char((nvl(ct.valor_frete_liquido,0) +
                            (select nvl(sum(valor * decode(cti.desconto,0,1,-1)),0)
                               from oper.v$contrato_transp_item cti
                              where cti.lancto_id = ct.lancto_id
                                and cti.compoe_frete = 1
                                and cti.data_cancelamento is null)),'FM9G9999G990D00','nls_numeric_characters=,.') as frete_liquido
                  , to_char((select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              where cti.lancto_id = ct.lancto_id
                                and cti.adiantamento = 1
                                and cti.data_cancelamento is null
                                and cti.item_id not in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('PEDAGIO_NO_FRETE')
                                                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO'))),'FM9G9999G990D00','nls_numeric_characters=,.') as frete_adiantamento
                  , to_char((nvl(ct.valor_frete_liquido,0) +
                            (select nvl(sum(valor * decode(cti.desconto,0,1,-1)),0)
                               from oper.v$contrato_transp_item cti
                              where cti.lancto_id = ct.lancto_id
                                and cti.compoe_frete = 1
                                and cti.data_cancelamento is null)-
                            (select nvl(sum(valor),0)
                               from oper.v$contrato_transp_item cti
                              where cti.lancto_id = ct.lancto_id
                                and cti.adiantamento = 1
                                and cti.data_cancelamento is null)),'FM9G9999G990D00','nls_numeric_characters=,.') as frete_saldo
                  , to_char(nvl(ct.valor_frete_liquido,0),'FM9G9999G990D00','nls_numeric_characters=,.') as valor_liquido
                  , fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as notas_fiscais
                  , (select pl.logotipo
                      from kss.v$pessoa_logotipo pl
                     where pl.cod_pessoa = ct.cod_pessoa_filial
                    ) as logo
                  , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_pessoa_filial
                     ) as razao_social_filial
                  , (select pep.logradouro || ', ' || pep.numero
                       from kss.v$pessoa_endereco_padrao pep
                      where pep.cod_pessoa = ct.cod_pessoa_filial) logradouro_numero
                  , (select pep.bairro || ' - CEP: ' || pep.cep
                       from kss.v$pessoa_endereco_padrao pep
                      where pep.cod_pessoa = ct.cod_pessoa_filial) bairro_cep
                  , (select pep.municipio || ' ' || pep.uf
                       from kss.v$pessoa_endereco_padrao pep
                      where pep.cod_pessoa = ct.cod_pessoa_filial) || ' - Telefone ' || (select '+'||ptp.fone_cod_pais || ' ' || ptp.telefone
                                                                                           from kss.v$pessoa_telefone_padrao ptp
                                                                                          where ptp.cod_pessoa = ct.cod_pessoa_filial) cidade_uf_telefone
                  ,'Pelo presente instrumento particular, de um lado ' || (select e.razao_social from kss.v$empresa e) || ', pessoa jurídica de direito privado, com sede e foro em ' || (select pep.municipio || ' - ' || pep.uf || ' à rua ' || pep.logradouro || ', ' || pep.numero || ', CNPJ ' || kss.fnc_get_identificador(p_cod_pessoa => pep.cod_pessoa)
  from kss.v$pessoa_endereco_padrao pep
 where pep.cod_pessoa = (select e.cod_pessoa from kss.v$empresa e)) || ', por seu representante legal, doravante denominada TOMADORA DE SERVIÇOS e o transportador supra citado, denominado de PRESTADOR DE SERVIÇOS, têm entre si, justo o seguinte:

CLÁUSULA PRIMEIRA:
DO OBJETO DO CONTRATO: O PRESTADOR DE SERVIÇOS realizará serviços de transporte rodoviário de carga para a TOMADORA DE SERVIÇOS conforme agendamento e número de carregamento recebidos no presente momento, inclusive as instruções e regras para carga e descarga, acomodação das mercadorias transportadas, prazos de início, fim dos serviços de transporte e horário de apresentação para entrega dos documentos transportados.
Parágrafo primeiro: Os veículos utilizados no transporte de carga serão de propriedade do PRESTADOR DE SERVIÇOS, o qual assume todos os riscos de avaria da caga, sinistro, roubos/furtos, manutenção e multas de trânsito, excluindo a TOMADORA DE SERVIÇOS quanto a qualquer responsabilidade relativa ao veículo transportador.
Parágrafo segundo: O PRESTADOR DE SERVIÇOS está obrigado a, antes de sair do local de embarque, entrar em contato com o setor responsável da TOMADORA DE SERVIÇOS para solicitar autorização de início de viagem, bem como para saber da necessidade de recolhimento de ICMS.
Parágrafo terceiro: Caso haja avaria na carga transportada pelo PRESTADOR DE SERVIÇOS e havendo recusa de recebimento do destinatário está obrigado o PRESTADOR DE SERVIÇOS a trazer a carga recusada, total ou parcialmente e sem frete de retorno até p local originário de embarque ou contratar às suas expensas alguém que o faça em seu nome (em nome do PRESTADOR DE SERVIÇOS).' as clausula_1
,
'CLÁUSULA SEGUNDA:
O PRESTADOR DE SERVIÇOS reconhece que a prestação de serviço ora efetuada é de maneira eventual, com o seu veículo e de acordo com as necessidades da TOMADORA DE SERVIÇOS.

CLÁUSULA TERCEIRA:
A responsabilidade pelo pagamento de quaisquer verbas trabalhistas decorrentes de ações impetradas por ex-funcionários da PRESTADORA DE SERVIÇOS que atinjam a TOMADORA DE SERVIÇOS será exclusiva da PRESTADORA DE SERVIÇOS, podendo a TOMADORA DE SERVIÇOS propor AÇÃO REAGRESSIVA contra a PRESTADORA DE SERVIÇOS caso tenha que efetuar algum pagamento de referidas verbas trabalhistas.' as clausula_2
,
'CLÁUSULA QUARTA:
DA REMUNERAÇÃO: A TOMADORA DE SERVIÇOS pagará à PRESTADORA DE SERVIÇOS a quantia total de acordo com detalhamento acima, pagos no ato da assinatura do presente e o restante sendo pago contra a prestação do comprovante de entrega regular (pontualidade e ausência de avarias) das mercadorias transportadas.
Parágrafo primeiro: No caso de pessoa física, valor constante da presente cláusula sofrerá o desconto de INSS, SEST/SENAT e IRRF incidente sobre o frete e será recolhido em favor do proprietário do cavalo mecânico.

CLÁUSULA QUINTA:
É de responsabilidade do PRESTADOR DE SERVIÇOS verificar a acomodação da carga e recusar o carregamento de carga avariada ou com defeitos de embalagem.
Presume-se que ao iniciar a viagem toda a carga saiu do embarcador sem avarias de produto ou embalagem.' as clausula_3
,'
CLÁUSULA SEXTA:
Qualquer litígio originado do presente contrato será definitivamente resolvido por arbitragem, de acordo com a Lei 9.307/96 e com o Regulamento de Arbitragem – Câmara de Mediação e Arbitragem da Associação Comercial do Paraná – ARBITAC, por um árbitro nomeado de conformidade com tal Regulamento sendo a arbitragem realizada no endereço da matriz da ' || (select e.razao_social from kss.v$empresa e) || '.

CLÁUSULA SÉTIMA:
Fica convencionado que na hipótese de ser efetuado o carregamento em local onde a ' || (select e.razao_social from kss.v$empresa e) || ' não disponha de escritório e/ou ponto de apoio, será efetuado adiantamento do vale pedágio mediante depósito em conta corrente bancária e/ou remessa de valores até o posto de combustível mais próximo com o qual a ' || (select e.razao_social from kss.v$empresa e) || ' mantenha convênio para este fim.

E por estarem às partes TOMADORA DE SERVIÇOS e PRESTADORA DE SERVIÇOS em pleno acordo em tudo quanto se encontra disposto neste instrumento particular, assinam-no na presença das testemunhas abaixo, em 02 (duas) via de igual teor e forma, destinando-se 01 (uma) via para cada uma das partes interessadas.' as clausula_4
                 , (select kss.fnc_concat_all(kss.to_concat_expr(decode(ctis.desconto,1,'(-) ','(+) ') || ctis.descricao || decode(ctis.adiantamento,1,'(A)','(S)') || '  R$ ' || to_char(sum(cti.valor),'FM999G990D00','nls_numeric_characters=,.'),chr(10)))
                       from oper.v$contrato_transp_item cti
                      inner join oper.v$contrato_transp_item_setup ctis
                         on ctis.item_id = cti.item_id
                      where cti.lancto_id = ct.lancto_id
                        and cti.data_cancelamento is null
                        and ctis.imprime_tarifa = 1
                      group by ctis.descricao,ctis.adiantamento,ctis.desconto) as itens_contrato
                 , nvl(to_char((select sum(cti.valor)
                                  from oper.v$contrato_transp_item cti
                                 inner join oper.v$contrato_transp_item_setup ctis
                                    on ctis.item_id = cti.item_id
                                 where cti.data_cancelamento is null
                                   and cti.lancto_id = ct.lancto_id
                                   and ctis.compoe_frete = 1
                                   and ctis.cod_evento_rpa is null
                                   and ctis.desconto = 1),'FM999G990D00','nls_numeric_characters=,.'),'0,00') as outros_descontos
                 , nvl(to_char((select sum(cti.valor)
                                  from oper.v$contrato_transp_item cti
                                 inner join oper.v$contrato_transp_item_setup ctis
                                    on ctis.item_id = cti.item_id
                                 where cti.data_cancelamento is null
                                   and cti.lancto_id = ct.lancto_id
                                   and ctis.cod_evento_rpa is null
                                   and ctis.compoe_frete = 1
                                   and ctis.item_id not in (1) /*Tira o PEDAGIO*/
                                   and ctis.desconto = 0),'FM999G990D00','nls_numeric_characters=,.'),'0,00') as outros_acrescimos
                 , (select ' ( ' || kss.fnc_concat_all(kss.to_concat_expr(f.documento, ',')) || ') '
                      from logistica.v$operacao_documento od
                     inner join oper.v$documento_frete f
                        on f.documento_id = od.documento_id
                     where od.motorista = 1
                       and od.operacao_id = ct.operacao_id
                     group by od.operacao_id
                    ) as doctos_obs
        from oper.v$contrato_transp ct
             inner join kss.v$pessoa prop
                on prop.cod_pessoa = ct.proprietario_cod_pessoa
              left join cep.municipio propm
                on propm.municipio_id = ct.proprietario_municipio_id
             inner join kss.v$pessoa mot
                on mot.cod_pessoa = ct.motorista_cod_pessoa
              left join kss.v$pessoa_endereco_padrao mote
                on mote.cod_pessoa = ct.motorista_cod_pessoa
              left join fiscal.v$conhecimento c 
                on ct.num_romaneio = c.num_romaneio
               and c.cancelado is null
              where 1 = 1
                and ct.lancto_id = #arguments.documento_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Busca o valor máximo do contrato com base nas divisões do CRT e margem
    -- JAQUELINEF 21/08/2014 11:18:00
    --->
    <cffunction name="get_valor_max_divisao" access="remote" returntype="query" output="true">
        <cfargument name="num_romaneio" required="yes">
        <cfargument name="valor_receita" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select round(nvl(case
                              when oper.pkg_veiculo.fnc_veiculo_modalidade(rhv.placa_controle, rhv.data_inicio) = 'TERCEIRO' then min(o.margem_terceiro)
                              else min(o.margem_agregado)
                           end,
                           kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 15, 8)
                          ) * #arguments.valor_receita# / 100, 2) as valor_maximo
            from oper.v$romaneio_item ri
           inner join logistica.v$operacao o
                   on o.operacao_id = ri.operacao_id
           inner join oper.v$romaneio_hist_veiculo rhv
                   on rhv.num_romaneio = ri.num_romaneio
                  and rhv.data_inicio = (select max(rhv2.data_inicio)
                                           from oper.v$romaneio_hist_veiculo rhv2
                                          where rhv2.num_romaneio = rhv.num_romaneio
                                        )
           where ri.num_romaneio = #arguments.num_romaneio#
           group by oper.pkg_veiculo.fnc_veiculo_modalidade(rhv.placa_controle, rhv.data_inicio)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
  -- PROPÓSITO
  -- Busca tipos de frete
  -- NOTAS EXPLICATIVAS
  -- GUTO 06/05/2006
  --->
  <cffunction name="get_tipo_pagto" access="remote" returntype="query" output="true">
     <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
      select tp.tipo_pagto_id
                 , tp.nome
              from oper.v$contrato_transp_tipo_pagto tp
             where exists (select 1
                             from oper.v$contrato_transp t
                            where t.tipo_pagto_id = tp.tipo_pagto_id
                           )
     </cfquery>
     <cfreturn qr_result>
  </cffunction>
    
    <!--- 
    -- PROPÓSITO 
    -- Retorna as cartas frete pendentes de aprovação
    -- RAFAELPENCZKOSKI 13/01/2016 - ADICIONADO
    --->  
    <cffunction name="get_contrato_transp_pendente_aprovacao" access="remote" returntype="query" output="true">
      <cfargument name="pendente" required="no" default="" />
    <cfargument name="pendente_data_inicial" required="no" default="" />
    <cfargument name="pendente_data_final" required="no" default="" />
        <cfargument name="aprovada" required="no" default="" />
        <cfargument name="aprovada_data_inicial" required="no" default="" />
        <cfargument name="aprovada_data_final" required="no" default="" />
        <cfargument name="reprovada" required="no" default="" />
        <cfargument name="reprovada_data_inicial" required="no" default="" />
        <cfargument name="reprovada_data_final" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.lancto_id
				 , x.num_formulario
				 , x.tipo_contrato
				 , x.tipo_servico
				 , x.tipo_carga
				 , x.num_romaneio
				 , x.carregamento
				 , x.destino
				 , x.unidade_negocio
				 , x.departamento
				 , x.setor
				 , x.centro_custo
				 , x.data_emissao
				 , x.peso
				 , x.cod_unidade
				 , x.volume
				 , x.m3
				 , x.frete_em
				 , x.total_parcela
				 , x.valor_unitario
				 , x.valor_frete_bruto
				 , x.valor_frete_liquido
				 , x.valor_frete_bruto_acum
				 , x.total_conhecimento
				 , x.ganho_bruto
				 , x.percentual_ganho_bruto
				 , x.total_nf_es_frete
				 , x.total_crt
				 , x.cod_veiculo_controle
				 , x.cod_veiculo_referencia
				 , x.proprietario
				 , x.motorista
				 , x.rpa_id
				 , x.impresso
				 , x.impresso_desc
				 , x.user_insert
				 , x.date_insert
				 , x.usuario_cancelamento
				 , x.data_cancelamento
				 , x.usuario_aprovacao
				 , x.data_aprovacao
				 , x.usuario_reprovacao
				 , x.data_reprovacao
				 , x.motivo_reprovacao
				 , x.valor_adiantamento
				 , x.valor_adiantamento_pedagio
				 , x.valor_adto_carga_descarga
				 , x.valor_total_adto
				 , x.usuario_aprovacao_adiant
				 , x.data_aprovacao_adiant
				 , x.usuario_reprovacao_adiant
				 , x.data_reprovacao_adiant
				 , x.motivo_reprovacao_adiant
				 , x.exige_aprovacao_adiantamento
				 , x.observacao_aprovacao
				 , x.valor_emitido
				 , x.valor_permitido
			   from xmltable('/contrato_transp_aprovacao/arrayItem' passing pagfrete.pkg_contrato_backend_aprovacao.fnc_get_lista_aprovacao_web(
			   xmltype('<params>' ||
							<cfif len(trim(arguments.pendente))>
								'<pendente>#arguments.pendente#</pendente>' ||
							</cfif>
							
							<cfif len(trim(arguments.aprovada))>
								'<aprovada>#arguments.aprovada#</aprovada>' ||
							</cfif>
				  
							<cfif len(trim(arguments.reprovada))>
								'<reprovada>#arguments.reprovada#</reprovada>' ||
							</cfif>
							
							<cfif len(trim(arguments.pendente_data_inicial))>
								'<pendente_data_inicial>#arguments.pendente_data_inicial#</pendente_data_inicial>' ||
							</cfif>
				  
							<cfif len(trim(arguments.pendente_data_final))>
								'<pendente_data_final>#arguments.pendente_data_final#</pendente_data_final>' ||
							</cfif>
							
							<cfif len(trim(arguments.aprovada_data_inicial))>
								'<aprovada_data_inicial>#arguments.aprovada_data_inicial#</aprovada_data_inicial>' ||
							</cfif>
							
							<cfif len(trim(arguments.aprovada_data_final))>
								'<aprovada_data_final>#arguments.aprovada_data_final#</aprovada_data_final>' ||
							</cfif>
							
							<cfif len(trim(arguments.reprovada_data_inicial))>
								'<reprovada_data_inicial>#arguments.reprovada_data_inicial#</reprovada_data_inicial>' ||
							</cfif>
							
							<cfif len(trim(arguments.reprovada_data_final))>
								'<reprovada_data_final>#arguments.reprovada_data_final#</reprovada_data_final>' ||
							</cfif>
				 '</params>'))
							columns
							   lancto_id                    number            path '/arrayItem/lancto_id'
							  ,num_formulario               varchar2(200)     path '/arrayItem/num_formulario'
							  ,tipo_contrato                varchar2(200)     path '/arrayItem/tipo_contrato'
							  ,tipo_servico                 varchar2(200)     path '/arrayItem/tipo_servico'
							  ,tipo_carga                   varchar2(200)     path '/arrayItem/tipo_carga'
							  ,num_romaneio                 number     	      path '/arrayItem/num_romaneio'
							  ,carregamento                 varchar2(200)     path '/arrayItem/carregamento'
							  ,destino                      varchar2(200)     path '/arrayItem/destino'
							  ,unidade_negocio              varchar2(200)     path '/arrayItem/unidade_negocio'
							  ,departamento                 varchar2(200)     path '/arrayItem/departamento'
							  ,setor                        varchar2(200)     path '/arrayItem/setor'
							  ,centro_custo                 varchar2(200)     path '/arrayItem/centro_custo'
							  ,data_emissao                 varchar2(200)     path '/arrayItem/data_emissao'
							  ,peso                         number            path '/arrayItem/peso'
							  ,cod_unidade                  varchar2(200)     path '/arrayItem/cod_unidade'
							  ,volume                       number            path '/arrayItem/volume'
							  ,m3                           number            path '/arrayItem/m3'
							  ,frete_em                     varchar2(200)     path '/arrayItem/frete_em'
							  ,total_parcela                number            path '/arrayItem/total_parcela'
							  ,valor_unitario               number            path '/arrayItem/valor_unitario'
							  ,valor_frete_bruto            number            path '/arrayItem/valor_frete_bruto'
							  ,valor_frete_liquido          number            path '/arrayItem/valor_frete_liquido'
							  ,valor_frete_bruto_acum       number            path '/arrayItem/valor_frete_bruto_acum'
							  ,total_conhecimento           number            path '/arrayItem/total_conhecimento'
							  ,ganho_bruto                  number            path '/arrayItem/ganho_bruto'
							  ,percentual_ganho_bruto       number            path '/arrayItem/percentual_ganho_bruto'
							  ,total_nf_es_frete            number            path '/arrayItem/total_nf_es_frete'
							  ,total_crt                    number            path '/arrayItem/total_crt'
							  ,cod_veiculo_controle         varchar2(200)     path '/arrayItem/cod_veiculo_controle'
							  ,cod_veiculo_referencia       varchar2(200)     path '/arrayItem/cod_veiculo_referencia'
							  ,proprietario                 varchar2(200)     path '/arrayItem/proprietario'
							  ,motorista                    varchar2(200)     path '/arrayItem/motorista'
							  ,rpa_id                       number            path '/arrayItem/rpa_id'
							  ,impresso                     number            path '/arrayItem/impresso'
							  ,impresso_desc                varchar2(200)     path '/arrayItem/impresso_desc'
							  ,user_insert                  varchar2(200)     path '/arrayItem/user_insert'
							  ,date_insert                  varchar2(200)     path '/arrayItem/date_insert'
							  ,usuario_cancelamento         varchar2(200)     path '/arrayItem/usuario_cancelamento'
							  ,data_cancelamento            varchar2(200)     path '/arrayItem/data_cancelamento'
							  ,usuario_aprovacao            varchar2(200)     path '/arrayItem/usuario_aprovacao'
							  ,data_aprovacao               varchar2(200)     path '/arrayItem/data_aprovacao'
							  ,usuario_reprovacao           varchar2(200)     path '/arrayItem/usuario_reprovacao'
							  ,data_reprovacao              varchar2(200)     path '/arrayItem/data_reprovacao'
							  ,motivo_reprovacao            varchar2(200)     path '/arrayItem/motivo_reprovacao'
							  ,valor_adiantamento           number            path '/arrayItem/valor_adiantamento'
							  ,valor_adiantamento_pedagio   number            path '/arrayItem/valor_adiantamento_pedagio'
							  ,valor_adto_carga_descarga    number            path '/arrayItem/valor_adto_carga_descarga'
							  ,valor_total_adto             number            path '/arrayItem/valor_total_adto'
							  ,usuario_aprovacao_adiant     varchar2(200)     path '/arrayItem/usuario_aprovacao_adiant'
							  ,data_aprovacao_adiant        varchar2(200)     path '/arrayItem/data_aprovacao_adiant'
							  ,usuario_reprovacao_adiant    varchar2(200)     path '/arrayItem/usuario_reprovacao_adiant'
							  ,data_reprovacao_adiant       varchar2(200)     path '/arrayItem/data_reprovacao_adiant'
							  ,motivo_reprovacao_adiant     varchar2(200)     path '/arrayItem/motivo_reprovacao_adiant'
							  ,exige_aprovacao_adiantamento number            path '/arrayItem/exige_aprovacao_adiantamento'
							  ,observacao_aprovacao         varchar2(200)     path '/arrayItem/observacao_aprovacao'
							  ,valor_emitido                number            path '/arrayItem/valor_emitido'
							  ,valor_permitido              number            path '/arrayItem/valor_permitido'
            ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
  -- PROPÓSITO 
  -- Verifica se usuário possui alçada para liberação
  -- RAFAELPENCZKOSKI 13/01/2016 - ADICIONADO
  --->
  <cffunction name="get_alcada_liberacao_controle_usuario" access="remote" returntype="query" output="true">
    <cfargument name="OPERACAO" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct al.operacao, al.usuario, u.nome
              from oper.v$alcada_liberacao_controle al
             inner join kss.v$kss_usuarios u
                     on u.usuario = al.usuario 
            where al.valor_alcada > 0
              and al.usuario = user
            <cfif Len(Trim(arguments.OPERACAO)) >
              and al.operacao = '#arguments.OPERACAO#'
            </cfif>
    </cfquery>
  <cfreturn qr_result>
  </cffunction>
    
    <!--- 
    -- PROPÓSITO 
    -- Retorna os itinerários a terem taxas cobradas
    -- RAFAEL COSTA 30/10/2015 - CRIADO
    --->    
    <cffunction name="get_agregado_itinerarios" access="remote" returntype="query" output="true">
      <cfargument name="placa_controle" required="yes">
        <cfargument name="placa_referencia" required="yes">
        <cfargument name="cod_pessoa_agregado" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ri.num_romaneio
                 , ri.rota_id
                 , ri.km_rota
                 , ro.descricao_rota
                 , ri.vazio_carregado
                 , decode(ri.vazio_carregado, 0 , 'Vazio', 1, 'Carregado') as vazio_carregado_descricao
                 , x.descricao_item
                 , x.valor as valor_km
                 , x.valor * ri.km_rota as valor
                 , x.tipo_cobranca
              from oper.v$romaneio r
             inner join oper.v$romaneio_itinerario ri
                on ri.num_romaneio = r.num_romaneio
             inner join oper.v$rota ro
                on ro.rota_id = ri.rota_id
         inner join oper.v$romaneio_hist_veiculo rhv
                on rhv.num_romaneio = r.num_romaneio
               and rhv.placa_controle  = '#arguments.placa_controle#'
             inner join (select y.veiculo_id
                              , y.item_id
                              , nvl(nullif(y.valor, 0), (select atvp.valor
                                                           from oper.v$agreg_taxa_valor_padrao atvp
                                                          where atvp.agreg_taxa_valor_padrao_id = y.agreg_taxa_valor_padrao_id )
                                    ) as valor
                              , y.descricao_item
                              , y.itinerario_cobranca_tipo
                              , kss.fnc_ref_code('OPER', 'AGREG_TAXA_VALOR_PADRAO.ITINERARIO_COBRANCA_TIPO', y.itinerario_cobranca_tipo, 0) as tipo_cobranca
                                       , y.data_inicio_vigencia
                           from (select t.veiculo_id
                                      , t.item_id
                                      , max(t.valor) keep(dense_rank last order by t.data) as valor
                                      , (select max(atvp.itinerario_cobranca_tipo) keep(dense_rank last order by atvp.data_vigencia)
                                          from oper.v$agreg_taxa_valor_padrao atvp
                                         where atvp.item_id = t.item_id
                                           and atvp.data_cancelamento is null
                                           and atvp.data_vigencia <= sysdate
                                           ) as itinerario_cobranca_tipo
                                      , (select max(atvp.agreg_taxa_valor_padrao_id) keep(dense_rank last order by atvp.data_vigencia)
                                                          from oper.v$agreg_taxa_valor_padrao atvp
                                                         where atvp.item_id = t.item_id
                                                           and atvp.data_cancelamento is null
                                                           and atvp.data_vigencia <= sysdate) as agreg_taxa_valor_padrao_id
                                      , (select ctis.descricao
                                           from oper.v$contrato_transp_item_setup ctis
                                           where ctis.item_id = t.item_id ) as descricao_item
                                               , t.data as data_inicio_vigencia
                                   from oper.v$agreg_taxa_manut_carreta t
                                  inner join oper.v$veiculo v
                                     on v.veiculo_id = t.veiculo_id
                                  where v.placa = '#arguments.placa_referencia#'
                                    and t.data_cancelamento is null
                                    and t.data <= sysdate
                                           group by t.veiculo_id, t.item_id, t.data
                                  ) y ) x
                                         on( ( x.itinerario_cobranca_tipo in (1,2) and ri.vazio_carregado = 0)
                                or (x.itinerario_cobranca_tipo in (1,3) and ri.vazio_carregado = 1)
                                             )
                                         and x.data_inicio_vigencia <= r.data_inicio
             where 1 = 1
               and exists (select distinct vp.cod_pessoa
               from oper.v$romaneio_hist_veiculo rhv
              inner join oper.v$veiculo_proprietario vp
                 on vp.placa = rhv.placa_controle
                where rhv.num_romaneio = r.num_romaneio
                and rhv.placa_controle = '#arguments.placa_controle#'
                and rhv.data_inicio between vp.data_inicio and nvl(vp.data_fim, sysdate)
                and vp.cod_pessoa = '#arguments.cod_pessoa_agregado#'
                  and exists (select 1
                      from oper.v$veiculo_proprietario_atual vpa
                       inner join kss.v$unidade_negocio un 
                          on un.cod_pessoa = vpa.cod_pessoa
                       where vpa.placa = rhv.placa_referencia)
               )
         and r.data_inicio > kss.pkg_parametro.fnc_valor_data('M217-P0174')
               and (((select t.termo_id
            from agreg.v$termo t
               where t.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id('#arguments.placa_controle#')
             and t.data_desagregacao is null) is null and ri.contrato_item_id is null)
                            or
                            (ri.contrato_item_id is null and not exists (select 1
                                                                           from agreg.v$taxa_config tc
                                                                          where tc.itinerario_id = ri.itinerario_id))
                            )
             order by r.data_inicio, ri.itinerario_id, x.descricao_item
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
  
    <!---
    -- PROPÓSITO
    -- Retorna os motivos de Cancelamento de Contrato
    -- WELLINGTONPEREIRA 04/07/2018 - CRIADO
    --->
    <cffunction name="get_motivo_cancelamento" access="remote" returntype="query" output="true">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mc.motivo_cancelamento_id
				 , mc.motivo
				 , mc.exige_detalhamento
				 , mc.numero_minimo_caracteres
				 , tpm.tipo_pagto_id
			  from pagfrete.v$motivo_cancelamento mc
			 inner join pagfrete.v$tipo_pagto_mapeamento tpm
				on tpm.id_registro_origem = mc.motivo_cancelamento_id
			   and tpm.id_tabela = 1
	     <cfif Len(Trim(arguments.TIPO_PAGTO_ID)) and arguments.TIPO_PAGTO_ID eq 6 >
             inner join pagbem.v$mapeamento_motivo mm
			    on mm.motivo_cancelamento_id = mc.motivo_cancelamento_id
			 inner join  pagbem.v$motivo_cancelamento pmc
			    on pmc.motivo_cancelamento_id = mm.motivo_id			   
         </cfif>
			 where 1 = 1
			 <cfif Len(Trim(arguments.TIPO_PAGTO_ID)) >
               and tpm.tipo_pagto_id = '#arguments.TIPO_PAGTO_ID#'			   
             </cfif>			 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
  
  <!--- 
  -- PROPÓSITO 
  -- Busca a quantidade de cpg em aberto do mesmo motorista
  -- RAFAEL 27/06/2018 - ADICIONADO
  --->
  <cffunction name="get_cpg_aberto" access="remote" returntype="query" output="true">
    <cfargument name="MOTORISTA_COD_PESSOA" required="no" default=""/>
    <cfargument name="PLACA_CONTROLE" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select sign(count(1)) as possui_cpg_aberto
        from oper.v$contrato_transp ct
       inner join oper.v$contrato_transp_pagar ctp
        on ctp.lancto_id = ct.lancto_id
       where 1 = 1
         and (1 = 2
           <cfif Len(Trim(arguments.MOTORISTA_COD_PESSOA)) >
          or ct.motorista_cod_pessoa = #arguments.MOTORISTA_COD_PESSOA#
           </cfif>
           <cfif Len(Trim(arguments.PLACA_CONTROLE)) >
          or ct.placa_controle = '#arguments.PLACA_CONTROLE#'
           </cfif>         
            )
      <cfif !Len(Trim(arguments.MOTORISTA_COD_PESSOA)) and !Len(Trim(arguments.PLACA_CONTROLE)) >
         and 1 = 2
      </cfif> 
         and ct.data_cancelamento is null 
         and exists (select 1
               from finan.v$finan_contas_pagar fcp
              where fcp.contas_pagar_id = ctp.contas_pagar_id 
                and fcp.situacao <> 1
               )
         and not exists (select 1
                                 from oper.v$contrato_transp_cpg_aberto ctca
                                where ctca.lancto_id_anterior = ct.lancto_id
                                  and ctca.data_cancelamento is null )       
    </cfquery>
  <cfreturn qr_result>
  </cffunction>
  
  <!---
  --PROPÓSITO 
  --Busca a situação do e-social de proprietários 
  --Gabriel S 06/11/2019
  --->
  
  <cffunction name="get_proprietario_esocial" access="remote" returntype="query" output="true">
    <cfargument name="PROPRIETATIO_COD_PESSOA" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
      
           select oper.pkg_contrato_transp.fnc_situacao_prop_esocial(p_proprietario_cod_pessoa => '#arguments.PROPRIETARIO_COD_PESSOA#') as validacao_esocial
             from dual  
      
    </cfquery>
  <cfreturn qr_result>
  </cffunction>
  
  <!--- 
  -- PROPÓSITO 
  -- Busca os dados dos cpg em aberto do mesmo motorista
  -- RAFAEL 05/07/2018 - ADICIONADO
  --->
  <cffunction name="get_cpg_aberto_dados" access="remote" returntype="query" output="true">
    <cfargument name="MOTORISTA_COD_PESSOA" required="no" default=""/>
    <cfargument name="PLACA_CONTROLE" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct ct.lancto_id
         , ct.num_formulario
         , ct.serie_formulario
         , to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
         , ct.num_romaneio
         , ct.placa_controle
         , ct.placa_referencia
         , (select r.descricao_rota
            from oper.v$rota r
            where r.rota_id = ct.rota_id ) as rota
         , (select p.razao_social
            from kss.v$pessoa p
           where p.cod_pessoa = ct.motorista_cod_pessoa ) as motorista
         , (select p.cliente
            from kss.v$pessoa p
           where p.cod_pessoa = ct.cod_destinatario ) as destinatario
        from oper.v$contrato_transp ct
       inner join oper.v$contrato_transp_pagar ctp
        on ctp.lancto_id = ct.lancto_id
       where 1 = 1
         and (1 = 2
           <cfif Len(Trim(arguments.MOTORISTA_COD_PESSOA)) >
          or ct.motorista_cod_pessoa = #arguments.MOTORISTA_COD_PESSOA#
           </cfif>
           <cfif Len(Trim(arguments.PLACA_CONTROLE)) >
          or ct.placa_controle = '#arguments.PLACA_CONTROLE#'
           </cfif>         
            )
      <cfif !Len(Trim(arguments.MOTORISTA_COD_PESSOA)) and !Len(Trim(arguments.PLACA_CONTROLE)) >
         and 1 = 2
      </cfif> 
         and ct.data_cancelamento is null 
         and exists (select 1
               from finan.v$finan_contas_pagar fcp
              where fcp.contas_pagar_id = ctp.contas_pagar_id 
                and fcp.situacao <> 1
               )
         and not exists (select 1
                                 from oper.v$contrato_transp_cpg_aberto ctca
                                where ctca.lancto_id_anterior = ct.lancto_id
                                  and ctca.data_cancelamento is null )
    </cfquery>
  <cfreturn qr_result>
  </cffunction>
  
  <!--- 
  -- PROPÓSITO 
  -- Busca os dados para a impressao da CFA
  -- CRISTOFER  28/04/2008
  --->    
  <cffunction name="get_cfa_print" access="remote" returntype="query" output="true">
      <cfargument name="lancto_id" required="yes" default="">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctf.cf_terceiro, 
                   ctf.cf_agregado, 
                   ctf.lancto_id, 
                   ctf.num_formulario, 
                   ctf.serie_formulario,
                   ctf.num_romaneio, 
                   ctf.previsao_chegada_dia, 
                   ctf.num_manifesto_ctrc_first, 
                   ctf.remetente, 
                   ctf.destinatario, 
                   ctf.origem, 
                   ctf.destino, 
                   ctf.proprietario_veiculo, 
                   ctf.proprietario_cnpj_cpf, 
                   ctf.placa_frota, 
                   ctf.proprietario_nit, 
                   ctf.proprietario_rg, 
                   ctf.motorista, 
                   ctf.cod_pessoa_filial, 
                   ctf.filial, 
                   ctf.cnpj_filial, 
                   ctf.data_emissao, 
                   ctf.descarga_por_conta, 
                   ctf.valor_total_servico, 
                   ctf.valor_carga_descarga, 
           (select nvl(sum(cti.valor),0)
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ctf.lancto_id
             and cti.item_id = oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO')
             and cti.compoe_frete = 1
             and cti.data_cancelamento is null) as valor_pedagio, 
                   ctf.valor_servico_prestado,
          (select nvl(sum(cti.valor),0)
                     from oper.v$contrato_transp_item cti
                    where cti.lancto_id = ctf.lancto_id
                      and cti.item_id <> oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO')
                      and cti.adiantamento = 1
            and cti.data_cancelamento is null) as valor_adiantamento,
           (select nvl(sum(cti.valor),0)
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ctf.lancto_id
             and cti.item_id in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('PEDAGIO_NO_FRETE')
                      ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('ADTO_PEDAGIO'))
             and cti.adiantamento = 1
             and cti.data_cancelamento is null) as valor_adiantamento_pedagio, 
                   ctf.valor_adto_carga_descarga, 
                   ctf.valor_total_adto, 
                   ctf.valor_irrf, 
                   ctf.valor_inss, 
                   ctf.valor_sest_senat, 
                   ctf.valor_consulta_cadastro, 
                   ctf.valor_transf_acerto, 
                   ctf.saldo_pagar, 
                   ctf.valor_falta_avaria, 
                   ctf.saldo_liquido_pagar, 
                   ctf.valor_novo_saldo_pagar, 
                   ctf.observacao, 
                   ctf.observacao2, 
                   ctf.observacao_final, 
                   ctf.cfi,
                   ctf.tipo_contrato,
                   ctf.impresso,
                   to_char(ctf.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') data_cancelamento,
                   to_char(ctf.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao,
           (select nvl(sum(it.valor),0)
                from oper.v$contrato_transp_item it
           where it.lancto_id = ctf.lancto_id
             and it.data_cancelamento is null
             and it.compoe_frete = 1
             and it.desconto = 1
             and it.adiantamento <> 1
             and it.item_id not in (oper.pkg_contrato_transp.fnc_get_tipo_taxa('IRRF')
                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('SEST')
                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('SENAT')
                       ,oper.pkg_contrato_transp.fnc_get_tipo_taxa('INSS'))) as total_descontos
              from oper.v$contrato_transp_form ctf
             where 1=1
             <cfif len(trim(arguments.lancto_id))>
               and ctf.lancto_id = #arguments.lancto_id#
             </cfif>
    </cfquery>
    <cfreturn qr_result>    
   </cffunction>
   
   <cffunction name="get_item_acesso_acao_repom" access="remote" returntype="string" output="true">
      <cfargument name="cod_acao" required="no">
     <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select (nvl((select decode(x.column_value, 'EDITAR_ROTA_REPOM', 1)
                  from table (
                       acesso.pkg_controle_acesso.fnc_get_acao_web(p_web_url => '/modulos/contratotransp/emitir/principal.cfm'
                                                                  ,p_usuario             => user
                                                                  )
                       ) x
                 where x.column_value = 'EDITAR_ROTA_REPOM'
             ), 0)) as valor
        from dual
     </cfquery>
     <cfreturn qr_result.valor>   
  </cffunction>

  
  <cffunction name="get_item_contrato_transp_pendente_aprovacao" access="remote" returntype="query" output="true">
      <cfargument name="pendente" required="no" default="" />
    <cfargument name="pendente_data_inicial" required="no" default="" />
    <cfargument name="pendente_data_final" required="no" default="" />
        <cfargument name="aprovada" required="no" default="" />
        <cfargument name="aprovada_data_inicial" required="no" default="" />
        <cfargument name="aprovada_data_final" required="no" default="" />
        <cfargument name="reprovada" required="no" default="" />
        <cfargument name="reprovada_data_inicial" required="no" default="" />
        <cfargument name="reprovada_data_final" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.ctransp_item_pendente_id
         , x.lancto_id
         , x.num_formulario
         , x.num_romaneio
         , x.item_descricao
         , x.valor_item
         , x.carregamento
         , x.destino
         , x.unidade_negocio
         , x.departamento
         , x.setor
         , x.centro_custo
         , x.data_emissao_contrato
         , x.cod_veiculo_controle
         , x.cod_veiculo_referencia
         , x.proprietario
         , x.motorista
         , x.user_insert
         , x.date_insert
         , x.aprovacao_usuario
         , x.aprovacao_data
         , x.aprovacao_observacao
         , x.reprovacao_usuario
         , x.reprovacao_data 
         from xmltable('/contrato_transp_item_aprovacao/arrayItem' passing pagfrete.pkg_contrato_backend_aprovacao.fnc_get_item_aprovacao_web(
         xmltype('<params>' ||
              <cfif len(trim(arguments.pendente))>
                '<pendente>#arguments.pendente#</pendente>' ||
              </cfif>
              
              <cfif len(trim(arguments.aprovada))>
                '<aprovada>#arguments.aprovada#</aprovada>' ||
              </cfif>
          
              <cfif len(trim(arguments.reprovada))>
                '<reprovada>#arguments.reprovada#</reprovada>' ||
              </cfif>
              
              <cfif len(trim(arguments.pendente_data_inicial))>
                '<pendente_data_inicial>#arguments.pendente_data_inicial#</pendente_data_inicial>' ||
              </cfif>
          
              <cfif len(trim(arguments.pendente_data_final))>
                '<pendente_data_final>#arguments.pendente_data_final#</pendente_data_final>' ||
              </cfif>
              
              <cfif len(trim(arguments.aprovada_data_inicial))>
                '<aprovada_data_inicial>#arguments.aprovada_data_inicial#</aprovada_data_inicial>' ||
              </cfif>
              
              <cfif len(trim(arguments.aprovada_data_final))>
                '<aprovada_data_final>#arguments.aprovada_data_final#</aprovada_data_final>' ||
              </cfif>
              
              <cfif len(trim(arguments.reprovada_data_inicial))>
                '<reprovada_data_inicial>#arguments.reprovada_data_inicial#</reprovada_data_inicial>' ||
              </cfif>
              
              <cfif len(trim(arguments.reprovada_data_final))>
                '<reprovada_data_final>#arguments.reprovada_data_final#</reprovada_data_final>' ||
              </cfif>
         '</params>'))
              columns

                 ctransp_item_pendente_id     number            path '/arrayItem/ctransp_item_pendente_id'
                ,lancto_id                    number            path '/arrayItem/lancto_id'
                ,num_formulario               varchar2(200)     path '/arrayItem/num_formulario'
                ,item_descricao               varchar2(200)     path '/arrayItem/item_descricao'
                ,valor_item                   number            path '/arrayItem/valor_item'
                ,num_romaneio                 number            path '/arrayItem/num_romaneio'
                ,carregamento                 varchar2(200)     path '/arrayItem/carregamento'
                ,destino                      varchar2(200)     path '/arrayItem/destino'
                ,unidade_negocio              varchar2(200)     path '/arrayItem/unidade_negocio'
                ,departamento                 varchar2(200)     path '/arrayItem/departamento'
                ,setor                        varchar2(200)     path '/arrayItem/setor'
                ,centro_custo                 varchar2(200)     path '/arrayItem/centro_custo'
                ,data_emissao_contrato        varchar2(200)     path '/arrayItem/data_emissao_contrato'
                ,cod_veiculo_controle         varchar2(200)     path '/arrayItem/cod_veiculo_controle'
                ,cod_veiculo_referencia       varchar2(200)     path '/arrayItem/cod_veiculo_referencia'
                ,proprietario                 varchar2(200)     path '/arrayItem/proprietario'
                ,motorista                    varchar2(200)     path '/arrayItem/motorista'
                ,user_insert                  varchar2(200)     path '/arrayItem/user_insert'
                ,date_insert                  varchar2(200)     path '/arrayItem/date_insert'
                ,aprovacao_usuario            varchar2(200)     path '/arrayItem/aprovacao_usuario'
                ,aprovacao_data               varchar2(200)     path '/arrayItem/aprovacao_data'
                ,aprovacao_observacao     varchar2(200)     path '/arrayItem/aprovacao_observacao'
                ,reprovacao_usuario           varchar2(200)     path '/arrayItem/reprovacao_usuario'
                ,reprovacao_data              varchar2(200)     path '/arrayItem/reprovacao_data'
            ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
     
    <!---
    -- PROPÓSITO
    -- Retorna o cenário de itens do contrato
    -- WELLINGTON 30/06/2019 - CRIADO
    --->
    <cffunction name="get_cenario_emissao" access="remote" returntype="query" output="true">
    <cfargument name="OPERACAO_ID" required="no" default="">
    <cfargument name="PROPRIETARIO_COD_PESSOA" required="no" default="">
    <cfargument name="MOTORISTA_COD_PESSOA" required="no" default="">
    <cfargument name="PLACA_CONTROLE" required="no" default="">
    <cfargument name="ROTA_ID" required="no" default="">
    <cfargument name="NUM_NATUREZA" required="no" default="">
    <cfargument name="NUM_ROMANEIO" required="no" default="">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">

      select x.cenario_id
           , x.cenario_descricao
      from xmltable('/cenario_emissao/arrayItem' passing pagfrete.pkg_cenario_backend.fnc_get_cenario_emissao(
      
      xmltype('<params>'  ||        

            <cfif len(trim(arguments.OPERACAO_ID))>
              '<operacao_id>#arguments.OPERACAO_ID#</operacao_id>' ||
            </cfif>
            
            <cfif len(trim(arguments.PROPRIETARIO_COD_PESSOA))>
              '<proprietario_cod_pessoa>#arguments.PROPRIETARIO_COD_PESSOA#</proprietario_cod_pessoa>' ||
            </cfif>
            
            <cfif len(trim(arguments.MOTORISTA_COD_PESSOA))>
              '<motorista_cod_pessoa>#arguments.MOTORISTA_COD_PESSOA#</motorista_cod_pessoa>' ||
            </cfif>
            
            <cfif len(trim(arguments.PLACA_CONTROLE))>
              '<placa_controle>#arguments.PLACA_CONTROLE#</placa_controle>' ||
            </cfif>

            <cfif len(trim(arguments.ROTA_ID))>
              '<rota_id>#arguments.ROTA_ID#</rota_id>' ||
            </cfif>
            
            <cfif len(trim(arguments.NUM_NATUREZA))>
              '<num_natureza>#arguments.NUM_NATUREZA#</num_natureza>' ||
            </cfif>

            <cfif len(trim(arguments.NUM_ROMANEIO))>
              '<num_romaneio>#arguments.NUM_ROMANEIO#</num_romaneio>' ||
            </cfif>

          '</params>'))
                columns
                   cenario_id               integer        path '/arrayItem/cenario_id'
                 , cenario_descricao        varchar2(4000) path '/arrayItem/cenario_descricao'
            ) x
    </cfquery>

    <cfreturn qr_result>
    </cffunction>
    

    <!---
    -- PROPÓSITO
    -- Retorna o as condições do cenario
    -- WELLINGTON 30/06/2019 - CRIADO
    --->
    <cffunction name="get_cenario_condicoes" access="remote" returntype="query" output="true">
      <cfargument name="CENARIO_ID" required="no">
      
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select ca.cenario_atributo_id
               , ca.cod_origem
               , ca.cod_atributo
               , (select coa.descricao
                    from kss.v$cenario_origem_atributo COA
                   where 1 =1
                     and coa.cod_atributo = ca.cod_atributo
                     and coa.cod_origem = ca.cod_origem) as atributo_desc
               , ca.valor
               , ca.valor_descricao
               , ca.operador
               , (select cg.rv_abbreviation
                    from kss.cg_ref_codes cg
                   where cg.rv_domain = 'CENARIO_ATRIBUTO.OPERADOR'
                     and cg.rv_low_value = ca.operador) as operador_desc
            from kss.v$cenario_atributo ca
           where 1 = 1
             and ca.cenario_id = #arguments.cenario_id#
          
      </cfquery>
      <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os itens cenario
    -- WELLINGTON 30/06/2019 - CRIADO
    --->
    <cffunction name="get_cenario_itens" access="remote" returntype="query" output="true">
      <cfargument name="CENARIO_ID" required="no">
      
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select cci.cenario_contrato_item_id
               , cci.item_id
               , cci.tipo_vinculo
               , (select cg.rv_abbreviation
                    from kss.cg_ref_codes cg
                   where cg.owner = 'PAGFRETE'
                     and cg.rv_domain = 'CENARIO_TIPO_VINCULO'
                     and cg.rv_low_value = cci.tipo_vinculo) as tipo_vinculo_desc
               , cci.tipo_valor
               , (select cg.rv_abbreviation
                    from kss.cg_ref_codes cg
                   where cg.owner = 'PAGFRETE'
                     and cg.rv_domain = 'CENARIO_TIPO_VALOR'
                     and cg.rv_low_value = cci.tipo_valor) as tipo_valor_desc
               , cci.valor
               , ctis.descricao as item_descricao
               , decode(ctis.desconto, 1, 'Desconto', 'Acréscimo') as tipo
               , ctis.desconto as desconto
               , ctis.compoe_frete as compoe_frete
               , ctis.deb_cred_motorista as deb_cred_motorista
            from pagfrete.v$cenario_contrato_item cci
           inner join pagfrete.v$cenario_contrato cc
              on cc.cenario_contrato_id = cci.cenario_contrato_id
           inner join oper.v$contrato_transp_item_setup ctis
              on ctis.item_id = cci.item_id
           where 1 = 1
             and cc.cenario_id =  #arguments.cenario_id#
          
      </cfquery>
      <cfreturn qr_result>
    </cffunction>
  
  <cffunction name="verifica_contrato_aprovado" access="remote" returntype="string" output="true">
    <cfargument name="LANCTO_ID" required="no">
    
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      select pagfrete.pkg_contrato.fnc_contrato_aprovado(p_lancto_id => #arguments.lancto_id#) as aprovado
        from dual
    </cfquery>
    <cfreturn qr_result.aprovado>
  </cffunction>
  
  <cffunction name="get_item_acesso_acao_pagbem" access="remote" returntype="string" output="true">
      <cfargument name="cod_acao" required="no">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select (nvl((select decode(x.column_value, 'EDITAR_ROTA_PAGBEM', 1)
                  from table (
                       acesso.pkg_controle_acesso.fnc_get_acao_web(p_web_url => '/modulos/contratotransp/emitir/principal.cfm'
                                                                  ,p_usuario             => user
                                                                  )
                       ) x
                 where x.column_value = 'EDITAR_ROTA_PAGBEM'
             ), 0)) as valor
        from dual
     </cfquery>
     <cfreturn qr_result.valor>   
  </cffunction>
  
  <cffunction name="get_item_acesso_acao_target" access="remote" returntype="string" output="true">
      <cfargument name="cod_acao" required="no">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select (nvl((select decode(x.column_value, 'EDITAR_ROTA_TARGET', 1)
                  from table (
                       acesso.pkg_controle_acesso.fnc_get_acao_web(p_web_url => '/modulos/contratotransp/emitir/principal.cfm'
                                                                  ,p_usuario             => user
                                                                  )
                       ) x
                 where x.column_value = 'EDITAR_ROTA_TARGET'
             ), 0)) as valor
        from dual
     </cfquery>
     <cfreturn qr_result.valor>   
  </cffunction>
  
  <cffunction name="obrigatorio_cartao_prop" access="remote" returntype="string" output="true">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select case
              when pagfrete.pkg_contrato.fnc_valor_atributo_tipo_pagto(p_tipo_pagto_id => 6, p_atributo_id => 101) = 'Sim' then 1
          else 0
         end as valor
          from dual
     </cfquery>
     <cfreturn qr_result.valor>
  </cffunction>
</cfcomponent>
