<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de administrao" extends="_transportes.funcoes.cfc_init">
<!--- 
-- PROPSITO 
-- Busca os parametros de configuracao da gestao atual
-- NOTAS EXPLICATIVAS
-- CRISTOFER  28/12/2005
--->		
<cffunction name="get_gestao" displayname="Busca os dados da gestao para a modalidade passada" access="remote" returntype="query" output="true">
	<cfargument name="modalidade" required="yes">
	<cfquery datasource="#session.dsn#" name="qrGestao" username="#session.usuario#" password="#session.senha#">
		<cfif Arguments.modalidade eq 'POSTOS'>
			select oper.pkg_global.fnc_get_parametro(8,'ABASTECIMENTO') as data_limite, 
				   oper.pkg_global.fnc_get_parametro(10,'ABASTECIMENTO') as km_limiar_final, 
				   oper.pkg_global.fnc_get_parametro(6,'ABASTECIMENTO') as intervalo_inventario_diesel,
				   oper.pkg_global.fnc_get_parametro(1,'CONTRATO_TRANSP') as perc_comissao,
				   oper.pkg_global.fnc_get_parametro(2,'CONTRATO_TRANSP') as perc_negociador, 
				   oper.pkg_global.fnc_get_parametro(3,'CONTRATO_TRANSP') as perc_embarcador, 
				   oper.pkg_global.fnc_get_parametro(4,'CONTRATO_TRANSP') as perc_emissor, 
				   oper.pkg_global.fnc_get_parametro(5,'CONTRATO_TRANSP') as perc_custo_financeiro,
				   oper.pkg_global.fnc_get_parametro(6,'CONTRATO_TRANSP') as dias_carencia, 
				   oper.pkg_global.fnc_get_parametro(7,'CONTRATO_TRANSP') as dias_pagto_postos, 
				   oper.pkg_global.fnc_get_parametro(8,'CONTRATO_TRANSP') as desconto_seguro,
				   oper.pkg_global.fnc_get_parametro(304,'CONTRATO_TRANSP') as perc_custo_financeiro_repom,
				   oper.pkg_global.fnc_get_parametro(305,'CONTRATO_TRANSP') as perc_custo_financeiro_empresa,
				   oper.pkg_global.fnc_get_parametro(8,'LOGISTICA') as frase_acidente,
				   oper.pkg_global.fnc_get_parametro(4,'LOGISTICA') as intervalo_revisao,
				   oper.pkg_global.fnc_get_parametro(12,'LOGISTICA') as multiplicador_km,
				   oper.pkg_global.fnc_get_parametro(13,'LOGISTICA') as tolerancia_conta_resultado,
				   oper.pkg_global.fnc_get_parametro(16,'LOGISTICA') as limite_debito_cartao_pedagio,
				   oper.pkg_global.fnc_get_parametro(17,'LOGISTICA') as limite_conta_corrente_mot,
				   oper.pkg_global.fnc_get_parametro(1,'PNEU') as tolerancia_inspecao,
				   oper.pkg_global.fnc_get_parametro(2,'PNEU') as mm_minimo_reforma, 
				   oper.pkg_global.fnc_get_parametro(3,'PNEU') as mm_liberacao_primeiro_eixo,
				   oper.pkg_global.fnc_get_parametro(4,'PNEU') as valor_por_conserto
			  from dual
		</cfif>		
		<cfif Arguments.modalidade eq 'RH'>
			select mes_ano_inicio, mes_ano_fim    
			  from delpozo.rh_gestao_internet		
		</cfif>		
	</cfquery>
	<cfreturn qrGestao>
</cffunction>

<!--- 
-- PROPSITO 
-- Busca os tipos de recado no mural internet
-- NOTAS EXPLICATIVAS
-- CRISTOFER  30/12/2005
--->		
<cffunction name="get_mural_internet_tipo_recado" access="remote" returntype="query" output="true">
	<cfquery datasource="#session.dsn#" name="qr" username="#session.usuario#" password="#session.senha#">
		select tipo_recado_id,
			   descricao,
			   user_insert,
			   date_insert,
			   user_update,
			   date_update,
			   site
		  from oper.v$mural_internet_tipo_recado
	</cfquery>
	<cfreturn qr>
</cffunction>

<!--- 
-- PROPSITO 
-- Busca as mensagens no mural internet
-- NOTAS EXPLICATIVAS
-- CRISTOFER  30/12/2005
--->		
<cffunction name="get_mural_internet" access="remote" returntype="query" output="true">
	<cfargument name="tipo_recado_id" required="no" default="">
	<cfargument name="titulo" 		  required="no" default="">
	<cfargument name="grupo_id" 	  required="no" default="">	
	<cfargument name="data_inicio"    required="no" default="">
	<cfargument name="data_termino"   required="no" default="">
	<cfargument name="ativo"   required="no" default="">
	<cfquery datasource="#session.dsn#" name="qr" username="#session.usuario#" password="#session.senha#">
		select mi.id,
			   mi.titulo,
			   mi.mensagem,
			   mi.data_inicio,
			   mi.data_termino,
			   mi.tipo_recado_id,
			   mt.descricao as tipo_recado,
			   mi.grupo_id,
			   mi.user_insert,
			   mi.date_insert,
			   mi.user_update,
			   mi.date_update,
			   mi.site
		  from oper.v$mural_internet mi
		 inner join oper.v$mural_internet_tipo_recado mt
		 	     on mi.tipo_recado_id = mt.tipo_recado_id
		 where 1=1
	
        <cfif len(trim(arguments.ativo))>
		   and trunc(mi.data_termino) >= trunc(sysdate)
		</cfif>       
        <cfif len(trim(arguments.data_inicio))>
		   and mi.data_inicio >= '#arguments.data_inicio#'
		</cfif>
        <cfif len(trim(arguments.data_termino))>
		   and mi.data_termino <= '#arguments.data_termino#'
		</cfif> 
		<cfif len(trim(arguments.tipo_recado_id))>
		   and mi.tipo_recado_id = '#arguments.tipo_recado_id#'
		</cfif>
		<cfif len(trim(arguments.titulo))>
		   and upper(mi.titulo) like upper('%#arguments.titulo#%')
		</cfif>
		<cfif Len(Trim(arguments.grupo_id))>
		   and mi.grupo_id = '#arguments.grupo_id#' 
		</cfif> 
		order by mi.id desc
	</cfquery>
	<cfreturn qr>
</cffunction>
<!--- 
-- PROPSITO 
-- Busca as bombas de combustvel da filial
-- NOTAS EXPLICATIVAS
-- CRISTOFER  02/01/2006
--->	
<cffunction name="get_bombas_combustivel" displayname="Busca as bombas de combustvel da filial" access="remote" returntype="query" output="true">
	<cfargument name="cod_pessoa_filial" required="yes">
	<cfquery datasource="#session.dsn#" name="qrBombas" username="#session.usuario#" password="#session.senha#">
		SELECT bomba_id, 
			   cod_pessoa,
			   to_char(num_bomba,'000') as num_bomba, 
			   contador, 
			   situacao, 
			   date_insert, 
			   date_update  
		  FROM oper.v$bomba_combustivel  
		 WHERE cod_pessoa = #arguments.cod_pessoa_filial#
		 order by num_bomba
	</cfquery>
	<cfreturn qrBombas>
</cffunction>
<!--- 
-- PROPSITO 
-- Busca saldo por perodo.
-- NOTAS EXPLICATIVAS
-- CRISTOFER  02/01/2006
--->	
<cffunction name="get_saldo_estoque" displayname="Busca saldo por perodo." access="remote" returntype="numeric" output="true">
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="data_inicial" required="false">
	<cfargument name="data_final" required="false">
	<cfquery datasource="#session.dsn#" name="qrResult" username="#session.usuario#" password="#session.senha#">
		<cfif isDefined("arguments.data_inicial")>
			select nvl(oper.pkg_almoxarifado.fnc_calcula_saldo_estoque(e.estoque_id, to_date('#arguments.data_inicial#','dd/mm/yyyy hh24:mi')-1/1440), 0) as saldo
			  from oper.v$estoque e
		inner join oper.v$produto_abastecimento pa
  				on pa.produto_id=e.produto_id  
			 where e.cod_pessoa_filial = #arguments.cod_pessoa#
			   and pa.produto_oper_id in (2,4)
		<cfelse>
			select nvl(oper.pkg_almoxarifado.fnc_calcula_saldo_estoque(e.estoque_id, sysdate), 0) as saldo
			  from oper.v$estoque e
			 inner join oper.v$produto_abastecimento pa
  				on pa.produto_id=e.produto_id  
			 where cod_pessoa_filial = #arguments.cod_pessoa#
			   and pa.produto_oper_id in (2,4)
		</cfif>
	</cfquery>
	<cfreturn qrResult.saldo>
</cffunction>
<!--- 
-- PROPSITO 
-- Busca o contador da bomba
-- NOTAS EXPLICATIVAS
-- CRISTOFER  02/01/2006
--->	
<cffunction name="get_estoque_id" access="remote" returntype="numeric" output="true" displayname="Busca o contador da bomba">
	<cfargument name="cod_pessoa" required="yes">
		<cfquery datasource="#session.dsn#" name="qrEstoque" username="#session.usuario#" password="#session.senha#">
			select e.estoque_id
			  from oper.v$estoque e
		inner join oper.v$produto_abastecimento pa
  				on pa.produto_id=e.produto_id  
			 where cod_pessoa_filial = #arguments.cod_pessoa#
			   and pa.produto_oper_id in (2,4)
		</cfquery>
	<cfreturn qrEstoque.ESTOQUE_ID>
</cffunction>
<!--- 
-- PROPSITO 
-- Busca a movimentao da filial
-- NOTAS EXPLICATIVAS
-- CRISTOFER  02/01/2006
--->	
<cffunction name="get_movimentacao_combustivel" displayname="Busca a movimentao da filial" access="remote" returntype="query" output="true">
	<cfargument name="estoque_id" required="true">
	<cfargument name="data_inicio" required="true">
	<cfargument name="data_fim" required="true">		
	<cfquery datasource="#session.dsn#" name="qrMovimentacao" username="#session.usuario#" password="#session.senha#">
		select num_documento, placa_veiculo, historico, nvl(quantidade,0) as quantidade, to_char(data,'dd/mm/yyyy HH24:mi') as data, 
			   tipo,usuario, num_bomba 
		from  (SELECT 0 as lancto_id, 0 as num_documento, '----' as placa_veiculo, 
					  'Inventrio de '||e.data_inventario as historico, e.qtde_estoque as quantidade, 
					  e.data_inventario as data, 'Inventrio' as tipo, e.user_insert as usuario, 0 as num_bomba 
				 from oper.v$estoque_inventario e 
				where e.estoque_id = #arguments.estoque_id#
				  and e.data_inventario between to_date('#Arguments.data_inicio#','dd/mm/yyyy HH24:mi') and to_date('#Arguments.data_fim#','dd/mm/yyyy HH24:mi')+1-1/86400
				union 
			   SELECT nfr.num_nota_fiscal as lancto_id, nfr.num_nota_fiscal as num_documento,                                       
           		    '----' as placa_veiculo, 
                  nvl(nfr.emit_razao_social,ee.utilizacao) as historico, nvl(nf_it.QTDE_VOLUME,ei.QUANTIDADE) as quantidade,                                       
						      nvl(nfr.data_entrada,ee.DATA_ENTRADA) as data, 'Entrada' as tipo, 
                  nvl(nfr.user_insert,ee.USER_INSERT) as usuario, 0 as num_bomba
 					   from oper.v$estoque_entrada ee
            inner join oper.v$estoque_entrada_it ei
                    on ei.num_entrada = ee.num_entrada
                   and ei.estoque_id = #arguments.estoque_id#
            left join fiscal.v$nf_terceiro nfr 
                   on nfr.NUM_NOTA_ID = ee.NUM_NOTA_REMESSA
					  left join oper.v$nf_terceiro_it nfr_it
					     on nfr.num_nota_id = nfr_it.num_nota_id
            left join oper.v$nf_item nf_it
                   on nf_it.num_nota_it_id = nfr_it.num_nota_it_id
  					left join oper.v$pessoa_juridica_filial pjf
	  				   on pjf.cod_pessoa = nfr.cod_pessoa_filial
			  		left join oper.pessoa_juridica pj
				  	   on pj.cod_pessoa = nfr.COD_EMITENTE
  					  and pj.modalidade_id = 14
            where trunc(ee.data_entrada) between to_date('#Arguments.data_inicio#','dd/mm/yyyy') and to_date('#Arguments.data_fim#','dd/mm/yyyy')
				union                                 
			   select /*+ NO_MERGE(PE) */  pe.controle_id as lancto_id,  
						 pe.num_requisicao as num_documento, nvl(pe.PLACA,'-----') as placa,
			 		    decode(pe.km,null,es.UTILIZACAO,'KM - ' || pe.km) as historico,                                       
		 			    round(es_it.quantidade,3) as quantidade, es.data_saida as data,                                         
					   'Sada' as tipo, pe.user_update as usuario, b.num_bomba
				 from oper.v$estoque_saida es
			    inner join oper.v$estoque_saida_it es_it
					    on es_it.num_saida = es.num_saida
			    inner join oper.v$estoque e
					    on e.estoque_id = es_it.estoque_id
					   and e.estoque_id = #arguments.estoque_id#
			    left join oper.v$abastecimento pe
					    on pe.num_saida = es.num_saida
					   and pe.data_confirmacao is not null
			    left join oper.v$bomba_combustivel b
					    on b.bomba_id = pe.bomba_id         
			    where es.data_saida between to_date('#Arguments.data_inicio#','dd/mm/yyyy HH24:mi') and to_date('#Arguments.data_fim#','dd/mm/yyyy HH24:mi')+1-1/86400
		ORDER BY data, num_documento,tipo)  
	</cfquery>
	<cfreturn qrMovimentacao>
</cffunction>
<!--- 
-- PROPSITO 
-- Busca todos os inventrios e acertos feitos
-- NOTAS EXPLICATIVAS
-- CRISTOFER  02/01/2006
--->	
<cffunction name="get_inventarios" displayname="Busca todos os inventrios e acertos feitos" access="remote" returntype="query" output="true">
	<cfargument name="estoque_id" required="no">
	<cfargument name="data_inicial" required="no">
	<cfargument name="data_final" required="no">
	<cfargument name="COD_PESSOA_FILIAL" required="no">
	<!--- Busca o estoque da pessoa --->
	<cfif isDefined("arguments.COD_PESSOA_FILIAL")>
		<cfquery datasource="#session.dsn#" name="qrEstoque" username="#session.usuario#" password="#session.senha#">
		  	select e.estoque_id
			  from oper.v$estoque e
		inner join oper.v$produto_abastecimento pa
  				on pa.produto_id=e.produto_id  
			 where cod_pessoa_filial = #arguments.cod_pessoa_filial#
			   and pa.produto_oper_id in (2,4)
		</cfquery>
		<cfset arguments.estoque_id = qrEstoque.estoque_id>
	</cfif>
	<cfquery datasource="#session.dsn#" name="qr_inventario" username="#session.usuario#" password="#session.senha#">
		select tipo, 
			   estoque_id, 
			   data, 
			   round(quantidade) as quantidade, 
			   decode(user_insert,'OPER','SISTEMA',user_insert) as user_insert, 
			   ordem
		  from (
			  select 'Inventrio' as tipo, estoque_id, data_inventario as data, qtde_estoque as quantidade, user_insert, 0 as ordem
				from oper.v$estoque_inventario
 			   union 
			  select 'Faltou' as tipo,  it.estoque_id, s.data_saida as data, it.quantidade, s.user_insert, 1 as ordem
				from oper.v$estoque_saida s
			   inner join oper.v$estoque_saida_it it
				  on s.num_saida = it.num_saida
			   inner join oper.v$estoque_inventario ei
				  on s.num_saida = ei.num_saida
			   union
			  select 'Sobrou' as tipo,  it.estoque_id, e.data_entrada as data, it.quantidade, e.user_insert, 1 as ordem
				from oper.v$estoque_entrada e
			   inner join oper.v$estoque_entrada_it it
				  on e.num_entrada = it.num_entrada
			   inner join oper.v$estoque_inventario ei
				  on e.num_entrada = ei.num_entrada)
		 where estoque_id = #arguments.estoque_id#
		  <cfif isDefined("arguments.data_inicial") and IsDefined("arguments.data_final")>
			and data between '#arguments.data_inicial#' and '#arguments.data_final#'
		  <cfelse>
			and data > sysdate - 120
		  </cfif>
		order by to_date(to_char(data,'dd/mm/yyyy'),'dd/mm/yyyy') desc, ordem
	</cfquery>
	<cfreturn qr_inventario>
</cffunction>
<!--- 
-- PROPSITO 
-- Busca todos os produtos da filial
-- NOTAS EXPLICATIVAS
-- CRISTOFER  02/01/2006
--->	
<cffunction name="get_produtos_filial" displayname="Busca todos os produtos da filial" access="remote" returntype="query" output="true">
	<cfargument name="cod_pessoa_filial" required="yes">
	<cfargument name="produto_id" required="no" default="">
	
	<cfquery datasource="#session.dsn#" name="qr_produtos" username="#session.usuario#" password="#session.senha#">
		SELECT (e.qtde_entrada + e.qtde_inventario) - e.qtde_saida as saldo_estoque,  
			   p.descricao as produto, e.produto_id, e.cod_pessoa_filial, e.cod_departamento, 
			   e.cod_setor, d.descricao as departamento,s.descricao as setor,          
			   e.custo_medio, e.custo_medio_inventario, e.qtde_inventario,          
			   e.qtde_entrada, 
			   e.qtde_saida, e.estoque_minimo, e.preco_venda,  
			   e.capacidade_maxima, decode(e.ativo,1,'Ativo','Inativo') as ativo ,
			   e.estoque_id
		  FROM oper.v$estoque e, kss.v$departamento d, kss.v$setor s,  oper.v$produto p  
		 WHERE e.cod_pessoa_filial = #arguments.cod_pessoa_filial#
		 <cfif len(trim(arguments.produto_id))>
		   and e.produto_id = #arguments.produto_id#
		 </cfif>
		   and e.cod_departamento = d.cod_departamento     
		   and e.cod_setor = s.cod_setor     
		   and e.produto_id = p.produto_id	
	</cfquery>
	<cfreturn qr_produtos>
</cffunction>
<!--- 
-- PROPSITO 
-- Busca o organograma
-- NOTAS EXPLICATIVAS
-- CRISTOFER  03/01/2006
--->	
<cffunction name="get_organograma" displayname="Busca o organograma" access="remote" returntype="query" output="true">
	<cfargument name="UNIDADE_NEGOCIO"  required="no" default="">
	<cfargument name="COD_PESSOA" 		required="no" default="">
	<cfargument name="COD_DEPARTAMENTO" required="no" default="">
	<cfargument name="COD_SETOR" 		required="no" default="">
	<cfargument name="COD_CENTRO_CUSTO"	required="no" default="">
	<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
		select /*+FIRST_ROWS*/ distinct u.cod_unidade_negocio, pj.cod_pessoa, 
        	   pj.cliente as nome_fantasia, d.cod_departamento, 
               d.descricao as departamento, s.cod_setor, s.descricao as setor, 
               c.cod_centro_custo, c.centro_custo,o.cod_organograma
		 from kss.v$organograma o 
		inner join kss.v$unidade_negocio u
		   on o.cod_unidade_negocio = u.cod_unidade_negocio
		inner join kss.v$pessoa pj 
		   on u.cod_pessoa = pj.cod_pessoa
		inner join kss.v$departamento d
		   on o.cod_departamento = d.cod_departamento
		inner join kss.v$setor s
		   on o.cod_setor = s.cod_setor				
		inner join kss.v$centro_custo c
		   on o.cod_centro_custo = c.cod_centro_custo
		where 1=1
		<cfif len(trim(arguments.UNIDADE_NEGOCIO))>
		  and upper(pj.cliente) like upper('%#arguments.UNIDADE_NEGOCIO#%')
		</cfif>
		<cfif len(trim(arguments.COD_PESSOA))>
		  and u.cod_pessoa = #arguments.COD_PESSOA#
		</cfif>
		<cfif len(trim(arguments.COD_DEPARTAMENTO))>
		  and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
		</cfif>
		<cfif len(trim(arguments.COD_SETOR))>
		  and o.cod_setor = #arguments.COD_SETOR#
		</cfif>
		<cfif len(trim(arguments.COD_CENTRO_CUSTO))>
		  and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
		</cfif>
		order by nome_fantasia, departamento, setor, c.centro_custo 
	</cfquery>
	<cfreturn qr_organograma>
</cffunction>

<!--- 
-- PROPSITO 
-- Busca o organograma
-- NOTAS EXPLICATIVAS
-- CRISTOFER  03/01/2006
--->	
<cffunction name="get_departamento" displayname="Busca o organograma" access="remote" returntype="query" output="true">
	<cfargument name="COD_PESSOA" 		required="no" default="">
	<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
		select /*+FIRST_ROWS*/ distinct pj.cod_pessoa, pj.cliente nome_fantasia, d.cod_departamento, d.descricao as departamento
		 from kss.v$organograma o 
		inner join kss.v$unidade_negocio u
		   on o.cod_unidade_negocio = u.cod_unidade_negocio
		inner join oper.v$pessoa pj 
		   on u.cod_pessoa = pj.cod_pessoa
		inner join kss.v$departamento d
		   on o.cod_departamento = d.cod_departamento
		inner join kss.v$setor s
		   on o.cod_setor = s.cod_setor				
		inner join kss.v$centro_custo c
		   on o.cod_centro_custo = c.cod_centro_custo
		where 1=1
		<cfif len(trim(arguments.COD_PESSOA))>
		  and u.cod_pessoa = #arguments.COD_PESSOA#
		</cfif>
		order by nome_fantasia, departamento
	</cfquery>
	<cfreturn qr_organograma>
</cffunction>

<!--- 
-- PROPSITO 
-- Busca o setor
-- NOTAS EXPLICATIVAS
-- CRISTOFER  03/01/2006
--->	
<cffunction name="get_setor" displayname="Busca o organograma" access="remote" returntype="query" output="true">
	<cfargument name="COD_PESSOA" 		required="no" default="">
	<cfargument name="COD_DEPARTAMENTO" required="no" default="">
	<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
		select /*+FIRST_ROWS*/ distinct u.cod_unidade_negocio, pj.cod_pessoa, pj.cliente nome_fantasia, s.cod_setor, s.descricao as setor
		 from kss.v$organograma o 
		inner join kss.v$unidade_negocio u
		   on o.cod_unidade_negocio = u.cod_unidade_negocio
		inner join oper.v$pessoa pj 
		   on u.cod_pessoa = pj.cod_pessoa
		inner join kss.v$departamento d
		   on o.cod_departamento = d.cod_departamento
		inner join kss.v$setor s
		   on o.cod_setor = s.cod_setor				
		inner join kss.v$centro_custo c
		   on o.cod_centro_custo = c.cod_centro_custo
		where 1=1
		<cfif len(trim(arguments.COD_PESSOA))>
		  and u.cod_pessoa = #arguments.COD_PESSOA#
		</cfif>
		<cfif len(trim(arguments.COD_DEPARTAMENTO))>
		  and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
		</cfif>
		order by nome_fantasia, setor
	</cfquery>
	<cfreturn qr_organograma>
</cffunction>

<!--- 
-- PROPSITO 
-- Busca o centro custo
-- NOTAS EXPLICATIVAS
-- CRISTOFER  03/01/2006
--->	
<cffunction name="get_centro_custo" displayname="Busca o organograma" access="remote" returntype="query" output="true">
	<cfargument name="COD_PESSOA" 		required="no" default="">
	<cfargument name="COD_DEPARTAMENTO" required="no" default="">
	<cfargument name="COD_SETOR" 		required="no" default="">
    <cfargument name="COD_CENTRO_CUSTO" 		required="no" default="">
    <cfargument name="CENTRO_CUSTO" 		required="no" default="">
    <cfargument name="OPERACAO_ID" 		required="no" default="">
	<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
		select /*+FIRST_ROWS*/ distinct c.cod_centro_custo, c.centro_custo
		 from kss.v$organograma o 
		inner join kss.v$unidade_negocio u
		   on o.cod_unidade_negocio = u.cod_unidade_negocio
		inner join kss.v$pessoa pj 
		   on u.cod_pessoa = pj.cod_pessoa
		inner join kss.v$departamento d
		   on o.cod_departamento = d.cod_departamento
		inner join kss.v$setor s
		   on o.cod_setor = s.cod_setor				
		inner join kss.v$centro_custo c
		   on o.cod_centro_custo = c.cod_centro_custo
		where 1=1
		<cfif len(trim(arguments.COD_PESSOA))>
		  and u.cod_pessoa = #arguments.COD_PESSOA#
		</cfif>
		<cfif len(trim(arguments.COD_DEPARTAMENTO))>
		  and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
		</cfif>
		<cfif len(trim(arguments.COD_SETOR))>
		  and o.cod_setor = #arguments.COD_SETOR#
		</cfif>
        <cfif len(trim(arguments.COD_CENTRO_CUSTO))>
		  and c.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
		</cfif>
        <cfif len(trim(arguments.CENTRO_CUSTO))>
		  and upper(c.centro_custo) like upper('%#arguments.CENTRO_CUSTO#%')
		</cfif>
        <cfif len(trim(arguments.operacao_id))>
	      and c.cod_centro_custo in (select o.cod_centro_custo
                                       from logistica.v$operacao_filial_emissao ofe
                                       inner join kss.v$organograma o
                                               on o.cod_organograma = ofe.cod_organograma                                                   
                                       where ofe.operacao_id = #arguments.operacao_id#)
        </cfif>  
		order by c.centro_custo
	</cfquery>
	<cfreturn qr_organograma>
</cffunction>

<!--- 
-- PROPSITO 
-- Busca a UF da filial selecionada
-- NOTAS EXPLICATIVAS
-- RAFAEL  14/09/2009	
--->	
<cffunction name="get_filial_uf" displayname="Busca a UF da filial selecionada" access="remote" returntype="query" output="true">
	<cfargument name="COD_PESSOA" 		required="no" default="">
	<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
		select UF
          from oper.v$filial t
		 where 1=1
		<cfif len(trim(arguments.COD_PESSOA))>
		   and t.cod_pessoa = #arguments.COD_PESSOA#
		</cfif>
	</cfquery>
	<cfreturn qr_organograma>
</cffunction>
</cfcomponent>	