<script type="text/javascript" src="/_scripts/scripts_db.js"></script>



<cfswitch expression="#vars.CONSULTA#">
	<cfcase value="1">
		<cfscript>
			conn = CreateComponent("modulos.compras._componentes.consulta.cfc_compras");
		   	qrSolicitacao = conn.get_solicitacao_compra(solicitacao_id = vars.SOLICITACAO_ID);
			qrMaterial 	  = conn.get_solicitacao_compra_material(solicitacao_id = vars.SOLICITACAO_ID);
			qrAtividade   = conn.get_solicitacao_compra_atividade(solicitacao_id = vars.SOLICITACAO_ID);
			qrArea		  = conn.get_area(cod_pessoa_fornecedor = qrSolicitacao.COD_PESSOA_FORNECEDOR);
		</cfscript>
        <cfif qrSolicitacao.RecordCount gt 0>
			<script type="text/javascript">
                with(parent.document.form_transportes) {
					parent.v_verificacao = false;
					parent.f_limpa_select(AREA_ID);
					parent.f_limpar_MATERIAL();
					parent.f_limpar_ATIVIDADE();
					
					<cfif qrArea.RecordCount gt 0>
						<cfif qrArea.RecordCount gt 1>
							v_opt_a = parent.f_cria_option('', '-- Selecione --', AREA_ID);
							v_opt_a.setAttribute('exige_romaneio', '');
						</cfif>							
						<cfoutput query="qrArea">
							v_opt_a = parent.f_cria_option(#qrArea.AREA_ID#, '#JSStringFormat(qrArea.DESCRICAO)#', AREA_ID)
							v_opt_a.setAttribute('exige_romaneio', #qrArea.EXIGE_ROMANEIO#);
						</cfoutput>
					</cfif>
					
					<cfoutput>
						COD_ORGANOGRAMA.value = '#JSStringFormat(qrSolicitacao.COD_ORGANOGRAMA)#';
						SITUACAO_ID.value = '#JSStringFormat(qrSolicitacao.SITUACAO_ID)#';
						NUM_CONTROLE.value = '#JSStringFormat(qrSolicitacao.NUM_CONTROLE)#';
						TITULO.value = '#JSStringFormat(qrSolicitacao.TITULO)#';
						COD_FUNCIONARIO.value = '#JSStringFormat(qrSolicitacao.COD_FUNCIONARIO)#';
						NOME_FUNCIONARIO.value = '#JSStringFormat(qrSolicitacao.NOME_FUNCIONARIO)#';
						COD_PESSOA_EMISSAO.value = '#JSStringFormat(qrSolicitacao.COD_PESSOA_EMISSAO)#';
						DATA_EMISSAO.value = '#JSStringFormat(qrSolicitacao.DATA_EMISSAO)#';
						COD_EQUIPAMENTO.value = '#JSStringFormat(qrSolicitacao.COD_EQUIPAMENTO)#';
						EQUIPAMENTO.value = '#JSStringFormat(qrSolicitacao.EQUIPAMENTO)#';
						EQUIPAMENTO_ID.value = '#JSStringFormat(qrSolicitacao.EQUIPAMENTO_ID)#';
						EQUIPAMENTO_CUSTO_ID.value = '#JSStringFormat(qrSolicitacao.EQUIPAMENTO_CUSTO_ID)#';
						EQUIPAMENTO_CUSTO.value = '#JSStringFormat(qrSolicitacao.EQUIPAMENTO_CUSTO)#';
						COD_EQUIPAMENTO_CUSTO.value = '#JSStringFormat(qrSolicitacao.COD_EQUIPAMENTO_CUSTO)#';
						CNPJ_FORNECEDOR.value = '#JSStringFormat(qrSolicitacao.CNPJ_FORNECEDOR)#';
						FORNECEDOR.value = '#JSStringFormat(qrSolicitacao.FORNECEDOR)#';
						COD_PESSOA_FORNECEDOR.value = '#JSStringFormat(qrSolicitacao.COD_PESSOA_FORNECEDOR)#';
						PRIORIDADE_ID.value = '#JSStringFormat(qrSolicitacao.PRIORIDADE_ID)#';
						AREA_ID.value = '#JSStringFormat(qrSolicitacao.AREA_ID)#';
						OBSERVACAO.value = '#JSStringFormat(qrSolicitacao.OBSERVACAO)#';
						COD_ORGANIZACIONAL.value = '#JSStringFormat(qrSolicitacao.COD_ORGANIZACIONAL)#';
						ORGANIZACIONAL_ID.value = '#JSStringFormat(qrSolicitacao.ORGANIZACIONAL_ID)#';
					</cfoutput>
                }
            </script>
            
            <cfif qrMaterial.RecordCount gt 0>
				<script type="text/javascript">
                    with(parent.document.form_transportes) {
                        <cfoutput query="qrMaterial">
							parent.f_incluir_MATERIAL();
							
							/* Campos */
							MATERIAL_CONTROLE_ID.value = '#JSStringFormat(qrMaterial.CONTROLE_ID)#';
							MATERIAL_ID_COMP.value = '#JSStringFormat(qrMaterial.MATERIAL_ID)#';
							MATERIAL_PRODUTO_ID.value = '#JSStringFormat(qrMaterial.PRODUTO_ID)#';
							
							parent.f_cria_option('#JSStringFormat(qrMaterial.MATERIAL_ID)#', '#JSStringFormat(qrMaterial.DESCRICAO_COMPLETA)#', MATERIAL_ID);
							MATERIAL_ID.value = '#JSStringFormat(qrMaterial.MATERIAL_ID)#';
							
							MATERIAL_DESCRICAO.value = '#JSStringFormat(qrMaterial.DESCRICAO)#';
							MATERIAL_TIPO_COMPRA_ID.value = '#JSStringFormat(qrMaterial.TIPO_COMPRA_ID)#';
							COD_UNIDADE.value = '#JSStringFormat(qrMaterial.COD_UNIDADE)#';
							MATERIAL_QUANTIDADE.value = '#JSStringFormat(qrMaterial.QUANTIDADE)#';
							MATERIAL_VALOR_SUGERIDO.value = Number('#JSStringFormat(qrMaterial.VALOR_SUGERIDO)#').toFixed(4);
							MATERIAL_VALOR_TOTAL.value = parent.toCurrency(Number('#JSStringFormat(qrMaterial.QUANTIDADE)#') * Number('#JSStringFormat(qrMaterial.VALOR_SUGERIDO)#'));
							ATIVO.value = '#JSStringFormat(qrMaterial.ATIVO)#';
							
							/* ------ */
							
							parent.f_salvar_MATERIAL();
							parent.f_limpa_select(MATERIAL_ID);
                        </cfoutput>
					}
				</script>
			</cfif>
            
            <cfif qrAtividade.RecordCount gt 0>
				<script type="text/javascript">
                    with(parent.document.form_transportes) {
                        <cfoutput query="qrAtividade">
							parent.f_incluir_ATIVIDADE();
							
							/* Campos */
							ATIVIDADE_CONTROLE_ID.value = '#JSStringFormat(qrAtividade.CONTROLE_ID)#';
							ATIVIDADE_ID_COMP.value = '#JSStringFormat(qrAtividade.ATIVIDADE_ID)#';
							ATIVIDADE_PRODUTO_ID.value = '#JSStringFormat(qrAtividade.PRODUTO_ID)#';
							
							parent.f_cria_option('#JSStringFormat(qrAtividade.ATIVIDADE_ID)#', '#JSStringFormat(qrAtividade.DESCRICAO)#', ATIVIDADE_ID);
							ATIVIDADE_ID.value = '#JSStringFormat(qrAtividade.ATIVIDADE_ID)#';
							
							ATIVIDADE_DESCRICAO.value = '#JSStringFormat(qrAtividade.DESCRICAO)#';
							ATIVIDADE_TIPO_COMPRA_ID.value = '#JSStringFormat(qrAtividade.TIPO_COMPRA_ID)#';
							ATIVIDADE_QUANTIDADE.value = '#JSStringFormat(qrAtividade.QUANTIDADE)#';
							ATIVIDADE_VALOR_SUGERIDO.value = Number('#JSStringFormat(qrAtividade.VALOR_SUGERIDO)#').toFixed(4);
							ATIVIDADE_VALOR_TOTAL.value = parent.toCurrency(Number('#JSStringFormat(qrAtividade.QUANTIDADE)#') * Number('#JSStringFormat(qrAtividade.VALOR_SUGERIDO)#'));
							/* ------ */
							
							parent.f_salvar_ATIVIDADE();
							parent.f_limpa_select(ATIVIDADE_ID);
                        </cfoutput>
					}
				</script>
			</cfif>
            
            <script type="text/javascript">
            	<cfif ListFindNoCase("0,1,2", qrSolicitacao.SITUACAO_ID, ',') neq 0>
					parent.f_habilitar_botao('editar', 'f_editar()');
					parent.f_habilitar_botao('excluir', 'f_excluir()');
            	</cfif>
            	
				parent.v_verificacao = true;
			</script>
        <cfelse>
        	<script type="text/javascript">
				alert('Nenhuma solicitao foi encontrada.');
		   	</script>
		</cfif>
	</cfcase>
    
    <cfcase value="2">
		<cfscript>
			conn = CreateComponent("modulos.compras._componentes.consulta.cfc_manutencao");
		   	qrEquipamento = conn.get_equipamentos(argumentCollection = vars);
		</cfscript>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
        		<td class="texto">
                    <table width="100%" border="0" cellspacing="1" cellpadding="1">
                        <tr class="titulo_2">
                            <td nowrap align="left">C&oacute;digo</td>
                            <td nowrap align="left">Placa</td>
                            <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                        </tr>
						<cfoutput query="qrEquipamento">
            			<tr class="linha_#(qrEquipamento.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrEquipamento.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrEquipamento.EQUIPAMENTO_ID)#', '#JSStringFormat(qrEquipamento.COD_EQUIPAMENTO)#', '#JSStringFormat(qrEquipamento.MATERIAL)#')">
                            <td nowrap align="left">#qrEquipamento.COD_EQUIPAMENTO#</td>
                            <td nowrap align="left">#qrEquipamento.PLACA#</td>
                            <td nowrap align="left">#qrEquipamento.MATERIAL#</td>
                        </tr>
						</cfoutput>
                        <cfif qrEquipamento.RecordCount eq 0>
		  				<tr>
		    				<td colspan="3" align="center" valign="middle" class="obrigatorio">Nenhum equipamento foi encontrado.</td>
		    			</tr>
						</cfif>
       				</table>
				</td>
			</tr>
		</table>
	</cfcase>
    
  <cfcase value="3">
		<cfscript>
			conn = CreateComponent("modulos.compras._componentes.consulta.cfc_manutencao");
			qrOrdemServico = conn.get_ordens_servico(ordem_servico_id = vars.ORDEM_SERVICO_ID);
			qrMaterial 	   = conn.get_os_materiais_agrupados(ordem_servico_id = vars.ORDEM_SERVICO_ID);
			qrAtividade	   = conn.get_os_atividades_agrupadas(ordem_servico_id = vars.ORDEM_SERVICO_ID);
			connG = CreateComponent("_transportes.consulta.cfc_global");		
			qrTipo = connG.get_parametro_valor(cod_projeto = 11, 
			                                 cod_aplicacao = 'OPERACIONAL',
								        parametro_grupo_id = 30,
										      parametro_id = 5);								  
		</cfscript>
        <cfif qrOrdemServico.RecordCount gt 0>
			<script type="text/javascript">
                with(parent.document.form_transportes) {
					parent.v_verificacao = false;
					parent.f_incluir();
					
					<cfoutput>
						COD_FUNCIONARIO.value = '#JSStringFormat(qrOrdemServico.COD_FUNCIONARIO)#';
						NOME_FUNCIONARIO.value = '#JSStringFormat(qrOrdemServico.RESPONSAVEL)#';
						COD_PESSOA_EMISSAO.value = '#JSStringFormat(qrOrdemServico.COD_PESSOA_RESPONSAVEL)#';
						COD_EQUIPAMENTO.value = '#JSStringFormat(qrOrdemServico.COD_EQUIPAMENTO)#';
						COD_EQUIPAMENTO.onchange();
						EQUIPAMENTO_ID.value = '#JSStringFormat(qrOrdemServico.EQUIPAMENTO_ID)#';
						CNPJ_FORNECEDOR.value = '#JSStringFormat(qrOrdemServico.CNPJ_OFICINA)#';
						FORNECEDOR.value = '#JSStringFormat(qrOrdemServico.OFICINA)#';
						COD_PESSOA_FORNECEDOR.value = '#JSStringFormat(qrOrdemServico.COD_PESSOA_OFICINA)#';
						TITULO.value = 'Manuteno do Equipamento Frota: #JSStringFormat(qrOrdemServico.COD_EQUIPAMENTO)#';
					</cfoutput>
					
                }
            </script>
            
            <cfif qrMaterial.RecordCount gt 0>
				<script type="text/javascript">
                    with(parent.document.form_transportes) {
                        <cfoutput query="qrMaterial">
							parent.f_incluir_MATERIAL();
							
							/* Cria o select com o valor do material pois quando a tela  aberta o campo ainda nao
							 * possui valores inseridos	 */
							f_limpa_select(MATERIAL_ID);
							f_cria_option('#JSStringFormat(qrMaterial.MATERIAL_ID)#','#JSStringFormat(qrMaterial.MATERIAL)#',MATERIAL_ID);
							
							/* Campos */
							MATERIAL_CONTROLE_ID.value = '';
							MATERIAL_ID_COMP.value = '#JSStringFormat(qrMaterial.MATERIAL_ID)#';
							MATERIAL_PRODUTO_ID.value = '#JSStringFormat(qrMaterial.PRODUTO_ID)#';
							MATERIAL_ID.value = '#JSStringFormat(qrMaterial.MATERIAL_ID)#';
							MATERIAL_DESCRICAO.value = '#JSStringFormat(qrMaterial.MATERIAL)#';
							COD_UNIDADE.value = '#JSStringFormat(qrMaterial.UNIDADE_ESTOQUE)#';
							MATERIAL_QUANTIDADE.value = '#JSStringFormat(qrMaterial.QUANTIDADE)#';
							MATERIAL_VALOR_SUGERIDO.value = parent.toCurrency('#JSStringFormat(qrMaterial.VALOR_UNITARIO)#');
							MATERIAL_VALOR_TOTAL.value = parent.toCurrency('#JSStringFormat(qrMaterial.VALOR_TOTAL)#');
							<cfif Len(Trim(qrTipo))>
								var comboTipo = MATERIAL_TIPO_COMPRA_ID.options
								for(var i=0; i<comboTipo.length;i++){
									if(comboTipo[i].value == #qrTipo#){
										MATERIAL_TIPO_COMPRA_ID.value = #qrTipo#;
										break;
									}
								}
							</cfif>
								if(MATERIAL_TIPO_COMPRA_ID.value == '')
							MATERIAL_TIPO_COMPRA_ID.value = MATERIAL_TIPO_COMPRA_ID.options[1].value;
							/* ------ */
							
							parent.f_salvar_MATERIAL();
							
							f_limpa_select(MATERIAL_ID);
                        </cfoutput>
					}
				</script>
			</cfif>
            <cfif qrAtividade.RecordCount gt 0>
				<script type="text/javascript">
                    with(parent.document.form_transportes) {
                        <cfoutput query="qrAtividade">
							parent.f_incluir_ATIVIDADE();
							
							/* Cria o select com o valor da atividade pois quando a tela  aberta o campo ainda nao
							 * possui valores inseridos
							 */
							f_limpa_select(ATIVIDADE_ID);
							f_cria_option('#JSStringFormat(qrAtividade.ATIVIDADE_ID)#','#JSStringFormat(qrAtividade.TITULO)#',ATIVIDADE_ID);
							
							/* Campos */
							ATIVIDADE_CONTROLE_ID.value = '';
							ATIVIDADE_ID_COMP.value = '#JSStringFormat(qrAtividade.ATIVIDADE_ID)#';
							ATIVIDADE_PRODUTO_ID.value = '#JSStringFormat(qrAtividade.PRODUTO_ID)#';
							ATIVIDADE_ID.value = '#JSStringFormat(qrAtividade.ATIVIDADE_ID)#';
							ATIVIDADE_DESCRICAO.value = '#JSStringFormat(qrAtividade.TITULO)#';
							ATIVIDADE_QUANTIDADE.value = '#JSStringFormat(qrAtividade.QUANTIDADE)#';
							ATIVIDADE_VALOR_SUGERIDO.value = number_format(Number('#JSStringFormat(qrAtividade.VALOR/qrAtividade.QUANTIDADE)#'),2,'.','');
							ATIVIDADE_VALOR_TOTAL.value = number_format(Number('#JSStringFormat(qrAtividade.VALOR)#'),2,'.','');
							<cfif Len(Trim(qrTipo))>
								var comboTipo = ATIVIDADE_TIPO_COMPRA_ID.options
								for(var i=0; i<comboTipo.length;i++){
									if(comboTipo[i].value == #qrTipo#){
										ATIVIDADE_TIPO_COMPRA_ID.value = #qrTipo#;
										break;
									}
								}
							</cfif>
								if(ATIVIDADE_TIPO_COMPRA_ID.value == '')
									ATIVIDADE_TIPO_COMPRA_ID.value = ATIVIDADE_TIPO_COMPRA_ID.options[1].value;		
							/* ------ */
							
							parent.f_salvar_ATIVIDADE();
                        </cfoutput>
						f_limpa_select(ATIVIDADE_ID);
					}
				</script>
			</cfif>
            
            <script type="text/javascript">
		     	parent.f_busca_tabela_preco_fixo();
				parent.v_verificacao = true;
			</script>
        <cfelse>
        	<script type="text/javascript">
				alert('Nenhuma ordem de servio foi encontrada.');
		   	</script>
		</cfif>
	</cfcase>
        
    <cfcase value="4">
    	<cfscript>
			conn = CreateComponent("modulos.compras._componentes.consulta.cfc_compras");
			qrTabelaPrecoFixo = conn.get_tabela_preco_fixo(cod_pessoa_fornecedor = vars.COD_PESSOA_FORNECEDOR);
			
			v_material_id  = conn.ListaToArray(lista = vars, variavel = 'MATERIAL_ID_COMP_MATERIAL');
			v_atividade_id = conn.ListaToArray(lista = vars, variavel = 'ATIVIDADE_ID_COMP_ATIVIDADE');
			v_materiais	   = '';
			v_atividades   = '';
		</cfscript>
        <cfif qrTabelaPrecoFixo.RecordCount gt 0>
        	<script type="text/javascript">
				var v_lista_material;
				var v_lista_atividade;
				var v_quantidade;
				var v_valor_sugerido;
				var v_valor_total
				
				parent.document.forms[0].TABELA_ID.value = '<cfoutput>#JSStringFormat(qrTabelaPrecoFixo.TABELA_ID)#</cfoutput>';
				parent.f_set_read_only_valores();
			</script>
            
            <cfloop from="1" to="#ArrayLen(v_material_id)#" index="count_mat">
                <cfset v_materiais = v_materiais & v_material_id[count_mat] & ';' />
            </cfloop>
            <cfloop from="1" to="#ArrayLen(v_atividade_id)#" index="count_atv">
                <cfset v_atividades = v_atividades & v_atividade_id[count_atv] & ';' />
            </cfloop>
            
            <cfif Len(Trim(v_materiais))>
                <cfset v_materiais = Mid(v_materiais, 1, Len(v_materiais) - 1) />
            </cfif>
            <cfif Len(Trim(v_atividades))>
                <cfset v_atividades = Mid(v_atividades, 1, Len(v_atividades) - 1) />
            </cfif>
            
            <cfscript>
                if(Len(Trim(v_materiais))) {
                    qrVerificacaoMateriais  = conn.get_verificacao_tabela_materiais(tabela_id = qrTabelaPrecoFixo.TABELA_ID, material_id = v_materiais);
                }
                if(Len(Trim(v_atividades))) {
                    qrVerificacaoAtividades = conn.get_verificacao_tabela_atividades(tabela_id = qrTabelaPrecoFixo.TABELA_ID, atividade_id = v_atividades);
                }
            </cfscript>
            
            <cfif IsDefined("qrVerificacaoMateriais")>
                <cfoutput query="qrVerificacaoMateriais">
                    <script type="text/javascript">
						v_lista_material = parent.f_listagem_MATERIAL();
						v_valor_sugerido = '#JSStringFormat(qrVerificacaoMateriais.VALOR)#';
						
						for(var i = 0; i < v_lista_material.length; i++) {
							if(Number(v_lista_material[i].MATERIAL_ID_COMP) == #qrVerificacaoMateriais.MATERIAL_ID#) {
								if(!v_valor_sugerido) {
									parent.f_excluir_MATERIAL(v_lista_material[i].id, true);
								}
								else {
									v_valor_sugerido = Number(v_valor_sugerido).toFixed(4);
									v_quantidade = parent.document.getElementById('MATERIAL_QUANTIDADE_MATERIAL_' + v_lista_material[i].id).value;
									v_valor_total = Number(v_quantidade) * Number(v_valor_sugerido);
									
									parent.document.getElementById('MATERIAL_VALOR_SUGERIDO_MATERIAL_' + v_lista_material[i].id).value = v_valor_sugerido;
									parent.document.getElementById('MATERIAL_VALOR_TOTAL_MATERIAL_' + v_lista_material[i].id).value = Number(v_valor_total).toFixed(2);
									parent.document.getElementById('tr_lista_MATERIAL_' + v_lista_material[i].id).cells[6].innerText = v_valor_sugerido;
									parent.document.getElementById('tr_lista_MATERIAL_' + v_lista_material[i].id).cells[7].innerText = Number(v_valor_total).toFixed(2);
								}
							}
						}
                    </script>
                </cfoutput>
            </cfif>
            
            <cfif IsDefined("qrVerificacaoAtividades")>
                <cfoutput query="qrVerificacaoAtividades">
                    <script type="text/javascript">
						v_lista_atividade = parent.f_listagem_ATIVIDADE();
						v_valor_sugerido = '#JSStringFormat(qrVerificacaoAtividades.VALOR)#';
						
						for(var i = 0; i < v_lista_atividade.length; i++) {
							if(Number(v_lista_atividade[i].ATIVIDADE_ID_COMP) == #qrVerificacaoAtividades.ATIVIDADE_ID#) {
								if(!v_valor_sugerido) {
									parent.f_excluir_ATIVIDADE(v_lista_atividade[i].id, true);
								}
								else {
									v_valor_sugerido = Number(v_valor_sugerido).toFixed(4);
									v_quantidade = parent.document.getElementById('ATIVIDADE_QUANTIDADE_ATIVIDADE_' + v_lista_atividade[i].id).value;
									v_valor_total = Number(v_quantidade) * Number(v_valor_sugerido);
									
									parent.document.getElementById('ATIVIDADE_VALOR_SUGERIDO_ATIVIDADE_' + v_lista_atividade[i].id).value = v_valor_sugerido;
									parent.document.getElementById('ATIVIDADE_VALOR_TOTAL_ATIVIDADE_' + v_lista_atividade[i].id).value = Number(v_valor_total).toFixed(2);
									parent.document.getElementById('tr_lista_ATIVIDADE_' + v_lista_atividade[i].id).cells[6].innerText = v_valor_sugerido;
									parent.document.getElementById('tr_lista_ATIVIDADE_' + v_lista_atividade[i].id).cells[7].innerText = Number(v_valor_total).toFixed(2);
								}
							}
						}
                    </script>
                </cfoutput>
            </cfif>
        <cfelse>
        	<script type="text/javascript">
				parent.document.forms[0].TABELA_ID.value = '';
				parent.f_set_read_only_valores();
			</script>
        </cfif>
        
        <script type="text/javascript">
			parent.f_hide_carregando_ajax();
		</script>
    </cfcase>
    
	<cfcase value="100">
		<cfscript>
			conn = CreateComponent("modulos.compras._componentes.consulta.cfc_acesso");
			qrUsuario = conn.get_usuarios_modulo(modulo_id = 23, usuario = session.usuario);
			
			if(qrUsuario.RecordCount and qrUsuario.NIVEL_ACESSO eq 10) {
				v_administrador = true;
			}
			else {
				v_administrador = false;
			}
			
			conn = CreateComponent("modulos.compras._componentes.consulta.cfc_compras");
			if(v_administrador) {
		   		qrSolicitacao = conn.get_solicitacao_compra(argumentCollection = vars);
			}
			else {
				qrSolicitacao = conn.get_solicitacao_compra(argumentCollection = vars, cod_pessoa_filial = session.cod_pessoa);
			}
		</cfscript>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
        		<td class="texto">
                    <table width="100%" border="0" cellspacing="1" cellpadding="1">
                        <tr class="titulo_2">
                            <td nowrap align="right">N&ordm; Controle</td>
                            <td nowrap align="left">T&iacute;tulo</td>
                            <td nowrap align="left">Data de Emiss&atilde;o</td>
                            <td nowrap align="left">Equipamento</td>
                            <td nowrap align="left">Prioridade</td>
                            <td nowrap align="left">&Aacute;rea</td>
                            <td nowrap align="left">Situa&ccedil;&atilde;o</td>
                        </tr>
						<cfoutput query="qrSolicitacao">
            			<tr class="linha_#(qrSolicitacao.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrSolicitacao.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrSolicitacao.SOLICITACAO_ID)#')">
                            <td nowrap align="right">#qrSolicitacao.NUM_CONTROLE#</td>
                            <td nowrap align="left">#qrSolicitacao.TITULO#</td>
                            <td nowrap align="left">#qrSolicitacao.DATA_EMISSAO#</td>
                            <td nowrap align="left">#qrSolicitacao.EQUIPAMENTO#</td>
                            <td nowrap align="left">#qrSolicitacao.PRIORIDADE#</td>
                            <td nowrap align="left">#qrSolicitacao.AREA#</td>
                            <td nowrap align="left">#qrSolicitacao.SITUACAO#</td>
                        </tr>
						</cfoutput>
                        <cfif qrSolicitacao.RecordCount eq 0>
		  				<tr>
		    				<td colspan="7" align="center" valign="middle" class="obrigatorio">Nenhuma solicita&ccedil;&atilde;o foi encontrada.</td>
		    			</tr>
						</cfif>
       				</table>
				</td>
			</tr>
		</table>
	</cfcase>
    
	<cfdefaultcase>
		<script defer="defer" language="javascript1.2">
	    	alert('Operao no programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>
