<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
    -- PROPSITO
    -- Libera solicitao para compra
    -- GUTO 08/02/2010 17:29:58 - CRIADO
    --->
    <cffunction name='aprova_compra_diretoria' displayname='Libera solicitao para compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_compras.prc_libera_solic_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Compra liberada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagemStr = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
	-- PROPSITO
	-- Aprovao da solicitao de compras feita por gestor
	-- WAGNERS 03/07/2012 16:46:39 - CRIADO
	--->
	<cffunction name='aprov_solicitacao_gestor' displayname='Aprovao da solicitao de compras feita por gestor' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='APROVADO_POR' required='no' default="">
        <cfargument name='FORNECEDOR' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_aprovacao_web.prc_aprov_solicitacao_gestor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.APROVADO_POR#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FORNECEDOR#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao de compras aprovada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Libera solicitaes vinculadas ao oramento que est sendo aprovado
	-- WAGNERS 13/07/2012 16:30:42 - CRIADO
	--->
	<cffunction name='libera_solic_orcamento' displayname='Libera solicitaes vinculadas ao oramento que est sendo aprovado' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORCAMENTO_ID' required='yes'>
        <cfargument name='APROVADO_POR' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_aprovacao_web.prc_lib_solicitacoes_orcamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORCAMENTO_ID#'  null='#iif(len(trim(arguments.ORCAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.APROVADO_POR#' null='#iif(len(trim(arguments.APROVADO_POR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitaes liberadas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
-- PROPSITO
-- Libera para solicitao de oramento
-- WAGNERS 16/07/2012 14:23:40 - CRIADO
--->
<cffunction name='libera_para_solic_orcamento' displayname='Libera para solicitao de oramento' access='remote' returntype='Struct' output='true'>
	<cfargument name='SOLICITACAO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='compras.pkg_compras.prc_libera_solic_orcamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Solicitao liberada para oramento com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

    <!---
    -- PROPSITO
    -- Aprova cotao
    -- GUTO 08/02/2010 17:29:58 - CRIADO
    --->
    <cffunction name='aprova_cotacao' displayname='Libera solicitao para compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='COTACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_compras.prc_aprova_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COTACAO_ID#'  null='#iif(len(trim(arguments.COTACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cotao aprovada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagemStr = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!---
    -- PROPSITO
    -- Desaprova cotao
    -- GUTO 08/02/2010 17:29:58 - CRIADO
    --->
    <cffunction name='desaprova_cotacao' displayname='Libera solicitao para compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='COTACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_compras.prc_desaprova_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COTACAO_ID#'  null='#iif(len(trim(arguments.COTACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cotao desaprovada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>

                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagemStr = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!---
	-- PROPSITO
	-- Confirma o pedido avanando da etapa de "Aberto" para "Aguardando entrada Fsica"
	-- WAGNERS 05/07/2012 17:34:01 - CRIADO
	--->
	<cffunction name='confirma_pedido' displayname='Confirma o pedido avanando da etapa de "Aberto" para "Aguardando entrada Fsica"' access='remote' returntype='Struct' output='true'>
		<cfargument name='PEDIDO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_compras.prc_confirma_pedido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_ID#'  null='#iif(len(trim(arguments.PEDIDO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pedido confirmado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Confirma o pedido avanando da etapa de "Aberto" para "Aguardando entrada Fsica"
	-- WAGNERS 05/07/2012 17:34:01 - CRIADO
	--->
	<cffunction name='upd_pedido_nf_itens' displayname='Confirma o pedido avanando da etapa de "Aberto" para "Aguardando entrada Fsica"' access='remote' returntype='Struct' output='true'>
    	<cfargument name="pedido_nf_id" required="no" default="" >
		<cftry>
        	<cfif len(trim(arguments.pedido_nf_id)) >
            	<cfset v_operacao = 3 >
            <cfelse>
	            <cfset v_operacao = 2 >
            </cfif>
        	<cfscript>
				v_materiais     = listatoarray(arguments,'MATERIAL_ID');
				v_atividades    = listatoarray(arguments,'ATIVIDADE_ID');
				v_lista_pedido  = listatoarray(arguments,'PEDIDO_ID');
				v_quantidade   	= listatoarray(arguments,'QUANTIDADE');
				v_item_id   	= listatoarray(arguments,'ITEM_ID');
				v_controle      = listatoarray(arguments,'CONTROLE');
			</cfscript>

			<cftransaction action='begin'>
            	<cfif v_operacao eq 3 >
					<cfscript>
                        conn = CreateComponent('modulos.compras._componentes.consulta.cfc_compras');

                        v_lista_consulta = ArrayNew(1);

                        for(i=1; i<=ArrayLen(v_item_id); i++){
                            if( len(trim(v_item_id[i])) )
                                arrayappend(v_lista_consulta,v_item_id[i]);
                        }

                        qrItens = conn.get_pedido_nf_item( not_item_id = arraytolist(v_lista_consulta,','), pedido_nf_id	= arguments.pedido_nf_id );

                        connMan = CreateComponent('modulos.compras._componentes.manipulacao.cfc_compras');
                    </cfscript>

                    <cfloop query="qrItens" >
                        <cfscript>
                            ret = connMan.del_pedido_nf_item( item_id = qrItens.ITEM_ID );
                        </cfscript>
                        <cfif ret.erro >
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>
				<cfscript>
					ret = this.upd_pedido_nf(   num_nota_fiscal = arguments.NOTA_NUMERO
											  , modelo			= arguments.NOTA_MODELO
											  , serie			= arguments.NOTA_SERIE
											  , subserie		= arguments.NOTA_SUB_SERIE
											  , data_emissao	= arguments.NOTA_DATA_EMISSAO
											  , data_entrada	= arguments.NOTA_DATA_ENTRADA
											  , pedido_nf_id	= arguments.pedido_nf_id
											  );
				</cfscript>
				<cfif ret.erro >
                	<cfthrow object="#ret.mensagem#" >
                </cfif>

				<cfif not len(trim(arguments.PEDIDO_NF_ID)) >
                	<cfset arguments.PEDIDO_NF_ID = ret.PEDIDO_NF_ID >
                </cfif>

                <cfloop from="1" index="i" to="#ArrayLen(v_controle)#" >
                    <cfparam name="arguments.MATERIAL_ID_#v_controle[i]#" default="">
                    <cfparam name="arguments.ATIVIDADE_ID_#v_controle[i]#" default="">
                    <cfif Len(Trim(evaluate("arguments.MATERIAL_ID_#v_controle[i]#")))>
                        <cfscript>
                            connAlmox = CreateComponent('modulos.compras._componentes.manipulacao.cfc_almoxarifado');
                            v_identificadores = ArrayNew(1);
                            if(evaluate("arguments.IDENTIFICADO_#v_controle[i]#") eq 0){
                                    ret = connAlmox.ins_movimentacao_private(OPERACAO_TIPO_ID  = 2
                                                                            ,DATA_LANCAMENTO   = arguments.NOTA_DATA_ENTRADA
                                                                            ,MATERIAL_ID       = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                            ,QUANTIDADE        = evaluate("arguments.QUANTIDADE_#v_controle[i]#")
                                                                            ,OBSERVACAO        = "Pedido N "&evaluate("arguments.NUM_PEDIDO_#v_controle[i]#")
																			,PEDIDO_ITEM_ID	   = evaluate("arguments.PEDIDO_ITEM_ID_#v_controle[i]#")
                                                                            ,COD_PESSOA_FILIAL = session.cod_pessoa
																									 ,COD_CENTRO_CUSTO  = session.cod_centro_custo
																			,ORGANIZACIONAL_ID = evaluate("arguments.ORGANIZACIONAL_ID_#v_controle[i]#")
																	);

                                    connAlmox.ins_movimentacao_atributo(LANCAMENTO_ID  = ret.LANCAMENTO_ID
                                                                       ,MATERIAL_ID	   = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                       ,ATRIBUTO_ID    = 23
                                                                       ,VALOR          = evaluate("arguments.VALOR_UNITARIO_#v_controle[i]#")
                                                                       );

									//Garante que o material tem o atributo para movimentao
									  connAlmox.ins_material_atributo(MATERIAL_ID = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
																	,ATRIBUTO_ID  = 12
																	,OBRIGATORIO  = 0
																	,VALOR_PADRAO = evaluate("arguments.LOCALIZACAO_#v_controle[i]#")
																	);

                                    connAlmox.ins_movimentacao_atributo(LANCAMENTO_ID  = ret.LANCAMENTO_ID
                                                                       ,MATERIAL_ID	   = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                       ,ATRIBUTO_ID    = 12
                                                                       ,VALOR          = evaluate("arguments.LOCALIZACAO_#v_controle[i]#")
                                                                       );
                            }
                            else{
                                v_identificadores = listatoarray(arguments,'IDENTIFICADOR_'&v_controle[i]);
                                for(j=1; j<=ArrayLen(v_identificadores); j++){
                                    ret = connAlmox.ins_movimentacao_private(OPERACAO_TIPO_ID  = 2
                                                                            ,DATA_LANCAMENTO   = arguments.NOTA_DATA_ENTRADA
                                                                            ,MATERIAL_ID       = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                            ,QUANTIDADE        = 1
                                                                            ,OBSERVACAO        = "Pedido N "&evaluate("arguments.NUM_PEDIDO_#v_controle[i]#")
																			,PEDIDO_ITEM_ID	   = evaluate("arguments.PEDIDO_ITEM_ID_#v_controle[i]#")
                                                                            ,COD_PESSOA_FILIAL = session.cod_pessoa
																									 ,COD_CENTRO_CUSTO  = session.cod_centro_custo
																			,ORGANIZACIONAL_ID = evaluate("arguments.ORGANIZACIONAL_ID_#v_controle[i]#")
                                                                            );


									//Garente que o material tem o atributo para movimentao
									  connAlmox.ins_material_atributo(MATERIAL_ID = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
																	,ATRIBUTO_ID  = 23
																	,OBRIGATORIO  = 0
																	,VALOR_PADRAO = ''
																	);

                                    connAlmox.ins_movimentacao_atributo(LANCAMENTO_ID  = ret.LANCAMENTO_ID
                                                                       ,MATERIAL_ID	   = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                       ,ATRIBUTO_ID    = 23
                                                                       ,VALOR          = evaluate("arguments.VALOR_UNITARIO_#v_controle[i]#")
                                                                       );

									//Garente que o material tem o atributo para movimentao
									  connAlmox.ins_material_atributo(MATERIAL_ID = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
																	,ATRIBUTO_ID  = 25
																	,OBRIGATORIO  = 0
																	,VALOR_PADRAO = ''
																	);

                                    connAlmox.ins_movimentacao_atributo(LANCAMENTO_ID  = ret.LANCAMENTO_ID
                                                                       ,MATERIAL_ID	   = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                       ,ATRIBUTO_ID    = 25
                                                                       ,VALOR          = evaluate("arguments.VALOR_UNITARIO_#v_controle[i]#")*evaluate("arguments.QUANTIDADE_#v_controle[i]#")
                                                                       );

									//Garente que o material tem o atributo para movimentao
									  connAlmox.ins_material_atributo(MATERIAL_ID = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
																	,ATRIBUTO_ID  = 12
																	,OBRIGATORIO  = 0
																	,VALOR_PADRAO = evaluate("arguments.LOCALIZACAO_#v_controle[i]#")
																	);

                                    connAlmox.ins_movimentacao_atributo(LANCAMENTO_ID  = ret.LANCAMENTO_ID
                                                                       ,MATERIAL_ID	   = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                       ,ATRIBUTO_ID    = 12
                                                                       ,VALOR          = evaluate("arguments.LOCALIZACAO_#v_controle[i]#")
                                                                       );

									//Garente que o material tem o atributo para movimentao
									  connAlmox.ins_material_atributo(MATERIAL_ID = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
																	,ATRIBUTO_ID  = 7
																	,OBRIGATORIO  = 0
																	,VALOR_PADRAO = ''
																	);

                                    connAlmox.ins_movimentacao_atributo(LANCAMENTO_ID  = ret.LANCAMENTO_ID
                                                                       ,MATERIAL_ID	   = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                                       ,ATRIBUTO_ID    = 7
                                                                       ,VALOR          = v_identificadores[j]
                                                                       );
                                }
                            }
                        </cfscript>


                        <cfscript>
							ret_custo_med = connAlmox.calcula_custo_medio(lancamento_id = ret.LANCAMENTO_ID);
						</cfscript>

						<cfif ret_custo_med.erro>
						   <cfthrow object="#ret_custo_med.mensagem#">
                   </cfif>
                   </cfif>
				   <cfif Len(Trim(evaluate("arguments.MATERIAL_ID_#v_controle[i]#"))) or Len(Trim(evaluate("arguments.ATIVIDADE_ID_#v_controle[i]#")))>
				   		<cfparam name="arguments.CANCELAR_ITENS_#v_controle[i]#" default="0" >
						<cfparam name="arguments.MOTIVO_#v_controle[i]#" default="" >
                        <cfscript>
                            ret2 = this.upd_pedido_nf_item(   pedido_id 	 = evaluate("arguments.PEDIDO_ID_#v_controle[i]#")
                                                            , material_id	 = evaluate("arguments.MATERIAL_ID_#v_controle[i]#")
                                                            , atividade_id	 = evaluate("arguments.ATIVIDADE_ID_#v_controle[i]#")
                                                            , quantidade	 = evaluate("arguments.QUANTIDADE_#v_controle[i]#")
                                                            , pedido_nf_id	 = arguments.pedido_nf_id
                                                            , pedido_item_id = evaluate("arguments.PEDIDO_ITEM_ID_#v_controle[i]#")
                                                            , cancelar_itens = evaluate("arguments.CANCELAR_ITENS_#v_controle[i]#")
                                                            , motivo		 = evaluate("arguments.MOTIVO_#v_controle[i]#")
                                                            );
                        </cfscript>

                        <cfif ret2.erro >
                            <cfthrow object="#ret2.mensagem#" >
                        </cfif>
                   </cfif>
                 </cfloop>

                <cfloop from="1" to="#ArrayLen(v_lista_pedido)#" index="i" >
                	<cfscript>
						ret3 = this.valida_saldo_itens_pedido( pedido_id 	= v_lista_pedido[i] );
					</cfscript>

                	<cfif ret3.erro >
                    	<cfthrow object="#ret2.mensagem#" >
                    </cfif>
                </cfloop>

			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Insere a nota fiscal de pedido
	-- WAGNERS 09/07/2012 14:00:48 - CRIADO
	--->
	<cffunction name='upd_pedido_nf' displayname='Insere a nota fiscal de pedido' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_FISCAL' required='yes'>
		<cfargument name='MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='PEDIDO_NF_ID' required='no' default="">
            <cfstoredproc procedure='compras.pkg_compras.prc_upd_pedido_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODELO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SUBSERIE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTRADA#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_NF_ID#' variable='retorno.PEDIDO_NF_ID'  null='#iif(len(trim(arguments.PEDIDO_NF_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>

            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Nota Fiscal registrada com sucesso!')>

		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Insere/Altera um item recebido na nota fiscal vinculada
	-- WAGNERS 09/07/2012 14:01:53 - CRIADO
	--->
	<cffunction name='upd_pedido_nf_item' displayname='Insere/Altera um item recebido na nota fiscal vinculada' access='remote' returntype='Struct' output='true'>
		<cfargument name='PEDIDO_ID' required='yes'>
		<cfargument name='PEDIDO_NF_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PEDIDO_ITEM_ID' required='yes'>
		<cfargument name='CANCELAR_ITENS' required='no'>
		<cfargument name='MOTIVO' required='no'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_compras.prc_upd_pedido_nf_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_ID#'  null='#iif(len(trim(arguments.PEDIDO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_NF_ID#'  null='#iif(len(trim(arguments.PEDIDO_NF_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ITEM_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_ITEM_ID#'  null='#iif(len(trim(arguments.PEDIDO_ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CANCELAR_ITENS#'  null='#iif(len(trim(arguments.CANCELAR_ITENS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO#'  null='#iif(len(trim(arguments.MOTIVO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Item registrado com sucesso!')>
            <cfcatch>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Exclui um item do pedido
	-- WAGNERS 11/07/2012 09:13:08 - CRIADO
	--->
	<cffunction name='del_pedido_nf_item' displayname='Exclui um item do pedido' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cfstoredproc procedure='compras.pkg_compras.prc_del_pedido_nf_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Item excludo com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Rejeita solicitao de compra
	-- WAGNERS 12/07/2012 18:05:17 - CRIADO
	--->
	<cffunction name='rejeita_solic_cotacao' displayname='Rejeita solicitao de compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='APROVADO_POR' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_aprovacao_web.prc_rejeita_solic_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.APROVADO_POR#' null='#iif(len(trim(arguments.APROVADO_POR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao rejeitada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Libera itens para compra
	-- WAGNERS 16/07/2012 15:54:16 - CRIADO
	--->
	<cffunction name='solic_libera_itens_compra' displayname='Libera itens para compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='COMPRA_LIBERADA' required='no' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_compras.prc_solic_libera_itens_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itens liberados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Valida itens do pedido alterando a situao se todos os itens ja tiverem sido recebidos.
	-- publico 16/07/2012 18:48:23 - CRIADO
	--->
	<cffunction name='valida_saldo_itens_pedido' displayname='Valida itens do pedido alterando a situao se todos os itens ja tiverem sido recebidos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PEDIDO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_compras.prc_valida_saldo_itens_pedido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_ID#'  null='#iif(len(trim(arguments.PEDIDO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itens liberados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Rejeita as solicitaes de um oramento
	-- WAGNERS 24/07/2012 09:45:08 - CRIADO
	--->
	<cffunction name='rej_solicitacoes_orcamento' displayname='Rejeita as solicitaes de um oramento' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORCAMENTO_ID' required='yes'>
        <cfargument name='APROVADO_POR' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_aprovacao_web.prc_rej_solicitacoes_orcamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORCAMENTO_ID#'  null='#iif(len(trim(arguments.ORCAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.APROVADO_POR#' null='#iif(len(trim(arguments.APROVADO_POR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitaes do oramento rejeitadas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Insere uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:49:14 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra' displayname='Insere uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_CONTROLE' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_PESSOA_EMISSAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='PRIORIDADE_ID' required='yes'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='TABELA_ID' required='yes'>
        <cfargument name='EQUIPAMENTO_CUSTO_ID' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='CONTROLE_ESTOQUE' required='no' default="0">
		<cfargument name='VALIDA_LIBERACAO' required='no' default="1">
		<cfargument name='ORDEM_SERVICO_ID' required='no' default="">
		<cfargument name='SOLICITACAO_ORIGEM_ID' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.SOLICITACAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_CONTROLE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='1' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_CUSTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_CUSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ESTOQUE#'  null='#iif(len(trim(arguments.CONTROLE_ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALIDA_LIBERACAO#'  null='#iif(len(trim(arguments.VALIDA_LIBERACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ORIGEM_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ORIGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null='yes'> 
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>

                <!--- Insero de Materiais --->
				<cfscript>
                    v_controle_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_CONTROLE_ID_MATERIAL');
					v_material_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_ID_COMP_MATERIAL');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_DESCRICAO_MATERIAL');
					v_cod_unidade 	 = this.ListaToArray(lista = arguments, variavel = 'COD_UNIDADE_MATERIAL');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_QUANTIDADE_MATERIAL');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_VALOR_SUGERIDO_MATERIAL');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_TIPO_COMPRA_ID_MATERIAL');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_material(SOLICITACAO_ID = retorno.SOLICITACAO_ID,
																   DESCRICAO	  = v_descricao[count],
																   MATERIAL_ID	  = v_material_id[count],
																   COD_UNIDADE	  = v_cod_unidade[count],
																   QUANTIDADE	  = v_quantidade[count],
																   VALOR_SUGERIDO = v_valor_sugerido[count],
																   TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Insero de Atividades --->
				<cfscript>
                    v_controle_id    = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_CONTROLE_ID_ATIVIDADE');
					v_atividade_id   = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_ID_COMP_ATIVIDADE');
					v_descricao      = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_DESCRICAO_ATIVIDADE');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_VALOR_SUGERIDO_ATIVIDADE');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_QUANTIDADE_ATIVIDADE');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_TIPO_COMPRA_ID_ATIVIDADE');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_atividade(SOLICITACAO_ID = retorno.SOLICITACAO_ID,
																    DESCRICAO	   = v_descricao[count],
																    ATIVIDADE_ID   = v_atividade_id[count],
																	VALOR_SUGERIDO = v_valor_sugerido[count],
																	QUANTIDADE	   = v_quantidade[count],
																	TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>


                <cfscript>
                    ret_termino = this.ins_termino_solicitacao( SOLICITACAO_ID = retorno.SOLICITACAO_ID );
                </cfscript>
                <cfif ret_termino.erro >
                    <cfthrow object="#ret_termino.mensagem#" >
                </cfif>

                <!--- Caso esteja definida uma tabela de preo fixo, gera o processo de compras automtico --->
                <cfif Len(Trim(arguments.TABELA_ID))>
                	<cfscript>
						ret_orcam = this.gera_orcamento_cotacao(SOLICITACAO_ID  = retorno.SOLICITACAO_ID,
															    TABELA_PRECO_ID = arguments.TABELA_ID);
                    </cfscript>
                    <cfif ret_orcam.erro>
                        <cfthrow object="#ret_orcam.mensagem#">
                    </cfif>
                </cfif>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de Compra n #retorno.NUM_CONTROLE# inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:51:10 - CRIADO
    --->
    <cffunction name='upd_solicitacao_compra' displayname='Altera uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='NUM_CONTROLE' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_PESSOA_EMISSAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='PRIORIDADE_ID' required='yes'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='NUM_ROMANEIO' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_solicitacao.prc_alt_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_CONTROLE#'  null='#iif(len(trim(arguments.NUM_CONTROLE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_CUSTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_CUSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                </cfstoredproc>

                <!--- Alterao de Materiais --->
				<cfscript>
                    v_controle_id	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_CONTROLE_ID_MATERIAL');
					v_material_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_ID_COMP_MATERIAL');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_DESCRICAO_MATERIAL');
					v_cod_unidade 	 = this.ListaToArray(lista = arguments, variavel = 'COD_UNIDADE_MATERIAL');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_QUANTIDADE_MATERIAL');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_VALOR_SUGERIDO_MATERIAL');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_TIPO_COMPRA_ID_MATERIAL');
                    v_excluir	     = this.ListDiff(lista1 = arguments.lista_deleted_MATERIAL, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_solicitacao_compra_material(CONTROLE_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_controle_id[count]))) {
							ret = this.ins_solicitacao_compra_material(SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																	   DESCRICAO	  = v_descricao[count],
																	   MATERIAL_ID	  = v_material_id[count],
																	   COD_UNIDADE	  = v_cod_unidade[count],
																	   QUANTIDADE	  = v_quantidade[count],
																	   VALOR_SUGERIDO = v_valor_sugerido[count],
																	   TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                        else {
							ret = this.upd_solicitacao_compra_material(CONTROLE_ID    = v_controle_id[count],
																	   SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																	   DESCRICAO	  = v_descricao[count],
																	   MATERIAL_ID	  = v_material_id[count],
																	   COD_UNIDADE	  = v_cod_unidade[count],
																	   QUANTIDADE	  = v_quantidade[count],
																	   VALOR_SUGERIDO = v_valor_sugerido[count],
																	   TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Alterao de Atividades --->
				<cfscript>
                    v_controle_id  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_CONTROLE_ID_ATIVIDADE');
					v_atividade_id   = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_ID_COMP_ATIVIDADE');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_DESCRICAO_ATIVIDADE');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_VALOR_SUGERIDO_ATIVIDADE');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_QUANTIDADE_ATIVIDADE');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_TIPO_COMPRA_ID_ATIVIDADE');
                    v_excluir	     = this.ListDiff(lista1 = arguments.lista_deleted_ATIVIDADE, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_solicitacao_compra_atividade(CONTROLE_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_controle_id[count]))) {
							ret = this.ins_solicitacao_compra_atividade(SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																		DESCRICAO	   = v_descricao[count],
																		ATIVIDADE_ID   = v_atividade_id[count],
																		VALOR_SUGERIDO = v_valor_sugerido[count],
																		QUANTIDADE	   = v_quantidade[count],
																		TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                        else {
							ret = this.upd_solicitacao_compra_atividade(CONTROLE_ID    = v_controle_id[count],
																		SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																		DESCRICAO	   = v_descricao[count],
																		ATIVIDADE_ID   = v_atividade_id[count],
																		VALOR_SUGERIDO = v_valor_sugerido[count],
																		QUANTIDADE	   = v_quantidade[count],
																		TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de compra alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:52:14 - CRIADO
    --->
    <cffunction name='del_solicitacao_compra' displayname='Exclui uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_solicitacao.prc_del_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de compra excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Insere uma solicitao de compra para manuteno
	-- FABIOG 10/11/2011 17:16:18 - CRIADO
	--->
	<cffunction name='ins_solicit_manutencao' displayname='Insere uma solicitao de compra para manuteno' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_PESSOA_EMISSAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='PLACA' required='yes'>
		<cfargument name='TITULO' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='ORDEM_SERVICO_ID_COMBO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicit_simplifi' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SOLICITACAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_CONTROLE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='1' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORDEM_SERVICO_ID_COMBO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_COMBO)), de('no'), de('yes'))#'>
                </cfstoredproc>


				<!--- Insero de Materiais --->
				<cfscript>
                    v_controle_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_CONTROLE_ID_MATERIAL');
					v_material_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_ID_COMP_MATERIAL');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_DESCRICAO_MATERIAL');
					v_cod_unidade 	 = this.ListaToArray(lista = arguments, variavel = 'COD_UNIDADE_MATERIAL');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_QUANTIDADE_MATERIAL');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_VALOR_SUGERIDO_MATERIAL');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_TIPO_COMPRA_ID_MATERIAL');
                </cfscript>

                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_material(SOLICITACAO_ID = retorno.SOLICITACAO_ID
																  ,DESCRICAO	  = v_descricao[count]
																  ,MATERIAL_ID	  = v_material_id[count]
																  ,COD_UNIDADE	  = v_cod_unidade[count]
																  ,QUANTIDADE	  = v_quantidade[count]
																  ,VALOR_SUGERIDO = v_valor_sugerido[count]
																  ,TIPO_COMPRA_ID = v_tipo_compra_id[count]
																  );
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Insero de Atividades --->
				<cfscript>
                    v_controle_id    = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_CONTROLE_ID_ATIVIDADE');
					v_atividade_id   = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_ID_COMP_ATIVIDADE');
					v_descricao      = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_DESCRICAO_ATIVIDADE');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_VALOR_SUGERIDO_ATIVIDADE');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_QUANTIDADE_ATIVIDADE');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_TIPO_COMPRA_ID_ATIVIDADE');
                </cfscript>

                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_atividade(SOLICITACAO_ID = retorno.SOLICITACAO_ID
																   ,DESCRICAO	   = v_descricao[count]
																   ,ATIVIDADE_ID   = v_atividade_id[count]
																   ,VALOR_SUGERIDO = v_valor_sugerido[count]
																   ,QUANTIDADE	   = v_quantidade[count]
																   ,TIPO_COMPRA_ID = v_tipo_compra_id[count]
																   );
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Caso esteja definida uma tabela de preo fixo, gera o processo de compras automtico --->
                <cfif Len(Trim(arguments.TABELA_ID))>
                	<cfscript>
						ret_orcam = this.gera_orcamento_cotacao(SOLICITACAO_ID  = retorno.SOLICITACAO_ID
															   ,TABELA_PRECO_ID = arguments.TABELA_ID
															   );
                    </cfscript>
                    <cfif ret_orcam.erro>
                        <cfthrow object="#ret_orcam.mensagem#">
                    </cfif>
                </cfif>

                <cfscript>
                	v_parc_numero = this.ListaToArray(lista = arguments, variavel = 'PARCELA_NUMERO');
					v_parc_data   = this.ListaToArray(lista = arguments, variavel = 'PARCELA_DATA_VENCTO');
					v_parc_dia    = this.ListaToArray(lista = arguments, variavel = 'PARCELA_DIA');
					v_parc_valor  = this.ListaToArray(lista = arguments, variavel = 'PARCELA_VALOR');
                </cfscript>

                <!--- Insere as parcelas em uma tabela temporaria para ser processada na solicitao de compras --->
                <cfloop from="1" to="#arrayLen(v_parc_numero)#" index="i">
                	<cfscript>
						ret = this.ins_solic_compras_temp( num_parcela 		= v_parc_numero[i]
														 , data_vencto 		= v_parc_data[i]
														 , dia_vencimento 	= v_parc_dia[i]
														 , valor  		  	= v_parc_valor[i]
														 );
					</cfscript>
                	<cfif ret.erro >
                    	<cfthrow object="#ret.mensagem#" >
                    </cfif>
                </cfloop>

                <!--- Realiza o processamento da solicitao de carga --->
                <cfscript>
                   ret_pro_sol = this.processa_solicit_compra(SOLICITACAO_ID = retorno.SOLICITACAO_ID
                                                             ,PLACA          = arguments.PLACA
                                                             );
	            </cfscript>

                <cfif ret_pro_sol.erro>
                    <cfthrow object="#ret_pro_sol.mensagem#">
                </cfif>


               <cfscript>
                    ret_termino = this.ins_termino_solicitacao( SOLICITACAO_ID = retorno.SOLICITACAO_ID );
                </cfscript>
                <cfif ret_termino.erro >
                    <cfthrow object="#ret_termino.mensagem#" >
                </cfif>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = ret_pro_sol.MENSAGEM_RETORNO>
            </cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


   <cffunction name='ins_termino_solicitacao' displayname='Realiza o processo de finalizao das validaes da solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_termino_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!---
    -- PROPSITO
    -- Insere um material para uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:53:59 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_material' displayname='Insere um material para uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='1' >                
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere uma atividade para uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:57:48 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_atividade' displayname='Insere uma atividade para uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='ATIVIDADE_ID' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Gera o processo de compras automtico para uma solicitao de compras
	-- ANDERSONC 16/06/2010 11:30:28 - CRIADO
	--->
	<cffunction name='gera_orcamento_cotacao' displayname='Gera o processo de compras automtico para uma solicitao de compras' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='TABELA_PRECO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='compras.pkg_compras.prc_gera_orcamento_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_PRECO_ID#'  null='#iif(len(trim(arguments.TABELA_PRECO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Exclui um material de uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:55:28 - CRIADO
    --->
    <cffunction name='del_solicitacao_compra_material' displayname='Exclui um material de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_del_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material excludo com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera um material de uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:54:41 - CRIADO
    --->
    <cffunction name='upd_solicitacao_compra_material' displayname='Altera um material de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_alt_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                
                
                
                
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material alterado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui uma atividade de uma solicitao de compra
    -- ANDERSONC 16/09/2009 15:07:32 - CRIADO
    --->
    <cffunction name='del_solicitacao_compra_atividade' displayname='Exclui uma atividade de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_del_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade excluda com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera uma atividade de uma solicitao de compra
    -- ANDERSONC 16/09/2009 15:00:27 - CRIADO
    --->
    <cffunction name='upd_solicitacao_compra_atividade' displayname='Altera uma atividade de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='ATIVIDADE_ID' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_compras.prc_alt_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade alterada com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Processar a solicitao de carga de manuteno
	-- FABIOG 11/11/2011 11:23:18 - CRIADO
	--->
	<cffunction name='processa_solicit_compra' displayname='Processar a solicitao de carga de manuteno' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_processa_solicit_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_LONGVARCHAR'  variable='retorno.MENSAGEM_RETORNO' >
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>0
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma parcela da solicitao de compras em uma tabela temporaria
	-- WAGNERS 26/04/2012 14:21:46 - CRIADO
	--->
	<cffunction name='ins_solic_compras_temp' displayname='Insere uma parcela da solicitao de compras em uma tabela temporaria' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_PARCELA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='DIA_VENCIMENTO' required='yes'>
		<cfargument name='DATA_VENCTO' required='yes'>
		<cftry>

            <cfstoredproc procedure='compras.pkg_compras.prc_ins_solic_compras_temp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PARCELA#'  null='#iif(len(trim(arguments.NUM_PARCELA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DIA_VENCIMENTO#'  null='#iif(len(trim(arguments.DIA_VENCIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VENCTO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Parcela registrada com sucesso!')>

			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Vincula uma solicitao de compra com uma OS
    -- EMANOELC 19/12/2014 11:50:48 - CRIADO
    --->
    <cffunction name='vincula_os_ordem_compra' displayname='Vincula uma solicitao de compra com uma OS' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_vincula_os_ordem_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.ORDEM_SERVICO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'    value='#arguments.SOLICITACAO_ID#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Solicitao vinculada com OS.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	   <!---
    -- PROPSITO
    -- Imprimir pedido em pdf
    -- IVANRIBEIRO 26/06/2015 18:24:06 - CRIADO
    --->
    <cffunction name='imprimir_pedido' displayname='Imprimir pedido em pdf' access='remote' returntype='Struct' output='true'>
        <cfargument name='PEDIDO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_pedido.prc_imprimir_pedido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_ID#'  null='#iif(len(trim(arguments.PEDIDO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.PDF' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Impresso bem sucedida.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

</cfcomponent>
