<cfcomponent displayname="Controle e manipulao" extends="_transportes.funcoes.cfc_init">

    <!--- 
	-- PROPSITO
	-- Inserir Ocorrncia para Solicitao de Compra
	-- RAFAEL 22/01/2010 14:27:17 - CRIADO
	--->
	<cffunction name='ins_ocorrencia_solicitacao' displayname='Inserir Ocorrncia para Solicitao de Compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_compras_ocorrencia.prc_ins_ocorrencia_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID' variable='retorno.OCORRENCIA_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfif arguments.TIPO_ID eq 20>
					<cfset retorno.mensagem = JSStringFormat('Solicitao Liberada com Sucesso.')>
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('Ocorrncia inserida com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma movimentacao de materiais
	-- cristofer 31/07/2006 11:04:27 - CRIADO
	--->
	<cffunction name='ins_movimentacao_private' displayname='Insere uma movimentacao de materiais' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LANCAMENTO_ID' required='no' default="">
		<cfargument name='OPERACAO_TIPO_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='OBSERVACAO' required='no' default="">
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='no' default="">
		<cfargument name='SOLICITACAO_ID' required='no' default="">  
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='PEDIDO_ITEM_ID' required='no' default="">        
      <cfargument name='COD_CENTRO_CUSTO' required='yes'>
			<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_movimentacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#' variable='retorno.LANCAMENTO_ID'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OPERACAO_TIPO_ID'  value='#arguments.OPERACAO_TIPO_ID#'  null='#iif(len(trim(arguments.OPERACAO_TIPO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MATERIAL_ID'  value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDIDO_ITEM_ID' value='#arguments.PEDIDO_ITEM_ID#'  null='#iif(len(trim(arguments.PEDIDO_ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCALIZACAO'  value=''>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
			</cfstoredproc>

			<!---Vincula a Solicitao--->
            <cfif Len(Trim(arguments.SOLICITACAO_ID))>
                <cfscript>
                    ret = this.confirma_solicitacao_material(SOLICITACAO_ID    = arguments.SOLICITACAO_ID,
                                                             LANCAMENTO_ID_MOV = retorno.lancamento_id,
                                                             DATA_ATENDIMENTO  = arguments.DATA_LANCAMENTO);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>	
            </cfif>	            
		<cfreturn retorno />
	</cffunction>	
    
	<!--- 
	-- PROPSITO
	-- Insere um atributo da movimentacao
	-- cristofer 01/08/2006 10:20:43 - CRIADO
	--->
	<cffunction name='ins_movimentacao_atributo' displayname='Insere um atributo da movimentacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>           
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_movimentacao_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MATERIAL_ID'  value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	    
    	
	<!--- 
	-- PROPSITO
	-- Insere um atributo no material
	-- cristofer 10/07/2006 16:44:07 - CRIADO
	--->
	<cffunction name='ins_material_atributo' displayname='Insere um atributo no material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='OBRIGATORIO' required='yes'>
		<cfargument name='VALOR_PADRAO' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_material_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MATERIAL_ID'  value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OBRIGATORIO'  value='#arguments.OBRIGATORIO#'  null='#iif(len(trim(arguments.OBRIGATORIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_PADRAO'  value='#arguments.VALOR_PADRAO#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Calcular o custo mdio do material
	-- fabiog 12/05/2015 11:18:17 - CRIADO
	--->
	<cffunction name='calcula_custo_medio' displayname='Calcular o custo mdio do material' access='remote' returntype='Struct' output='true'>
	   <cfargument name='LANCAMENTO_ID' required='yes'>
	   <cftry>
	      <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_calcula_custo_medio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
		     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
		  </cfstoredproc>
		  <cfset retorno.erro = false>
	   <cfcatch>
	      <cfset retorno.erro = true>
		  <cfset retorno.mensagem = cfcatch>
		  <cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno />
	</cffunction>

</cfcomponent>	