<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPÓSITO
	-- Retorna os Romaneios
	-- NOTAS EXPLICATIVAS
	-- Rafael - 06/10/2009 Criado
	--->	
	<cffunction name="get_romaneio" displayname="Retorna os Romaneios" access="remote" returntype="query" output="true">
    	<cfargument name="NUM_ROMANEIO" required="no" default=""/>
        <cfargument name="PLACA" required="no" default=""/>
        <cfargument name="NUM_CTE" required="no" default=""/>
        <cfargument name="NUM_CRT" required="no" default=""/>
        <cfargument name="NF_CLIENTE" required="no" default=""/>
        <cfargument name="NF_FRETE" required="no" default=""/>
        <cfargument name="DATA_INICIO" required="no" default=""/>
        <cfargument name="DATA_FIM" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select r.num_romaneio
                    , r.carregamento ||' \ '|| r.destino as origem_destino
                    , r.carregamento as origem
                    , r.remetente
                    , r.destino
                    , r.destinatario
                    , r.data_inicio
                    , r.placa_controle as placa
                    , case
                         when situacao_id = 0 then
                            'Aberto'
                         when situacao_id = 1 then
                            'Encerrado'
                         when situacao_id = 2 then
                            'OK'
                         end as situacao
                 from oper.v$romaneio r
			<cfif Len(Trim(arguments.NUM_CTE))>
                inner join fiscal.v$conhecimento c
                   on c.num_romaneio = r.num_romaneio
            </cfif>
            <cfif Len(Trim(arguments.NUM_CRT))>
                inner join oper.v$romaneio_intc_conhecimento ric
                   on ric.num_romaneio = r.num_romaneio
                inner join fiscal.v$intc_conhecimento ic
                   on ic.conhecimento_id = ric.conhecimento_id
            </cfif>
            <cfif Len(Trim(arguments.NF_CLIENTE))>
                inner join fiscal.v$conhecimento c
                   on c.num_romaneio = r.num_romaneio
                inner join fiscal.v$conhecimento_nota_fiscal cnf
                   on cnf.conhecimento_id = c.conhecimento_id
            </cfif>
            <cfif Len(Trim(arguments.NF_FRETE))>
                inner join fiscal.v$nf_es_frete nff
                   on nff.num_romaneio = r.num_romaneio
                inner join fiscal.v$nf_es nf
                   on nf.num_nota_id = nff.nf_es_id
            </cfif>
                 where 1= 1
				<cfif Len(Trim(arguments.NUM_ROMANEIO))>
                   and r.num_romaneio = '#arguments.NUM_ROMANEIO#'
                </cfif>
                   <cfif Len(Trim(arguments.NUM_CTE))>
                   and c.num_conhecimento = '#arguments.NUM_CTE#'
                </cfif>
                   
                <cfif Len(Trim(arguments.NUM_CRT))>
                   and replace(ic.num_crt_completo, '.', '') like replace(upper('#arguments.NUM_CRT#%'), '.', '')
                </cfif>
                   
                <cfif Len(Trim(arguments.NF_CLIENTE))>
                   and cnf.numero = '#arguments.NF_CLIENTE#'
                </cfif>
                   
                <cfif Len(Trim(arguments.NF_FRETE))>
                   and nf.num_nota_fiscal = '#arguments.NF_FRETE#'
                </cfif>
                <cfif Len(Trim(arguments.PLACA))>
                   and r.placa_controle = '#arguments.PLACA#'
                </cfif>
                <cfif Len(Trim(arguments.DATA_INICIO))>
                       and trunc(r.data_inicio) >= '#arguments.DATA_INICIO#'
                </cfif>
                <cfif Len(Trim(arguments.DATA_FIM))>
                       and trunc(r.data_termino) <= '#arguments.DATA_FIM#'
                </cfif>
                   and r.data_inicio >= sysdate - 60
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPÓSITO
	-- Retorna os Equipamentos Vinculados ao Romaneio
	-- NOTAS EXPLICATIVAS
	-- Rafael - 06/10/2009 Criado
	--->	
	<cffunction name="get_romaneio_equipamentos" displayname="Retorna os Equipamentos Vinculados ao Romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="NUM_ROMANEIO" required="no" default=""/>
        <cfargument name="PLACA" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select e.placa
                    , decode(rhv.placa_controle, e.placa, 1, 0) as tracao
                    , nvl(rhv.data_termino, sysdate) as data_encerr
                 from oper.v$romaneio_hist_veiculo rhv
                inner join almoxarifado.v$equipamento e
                   on e.placa in (rhv.placa_referencia, rhv.placa_controle)
                where rhv.num_romaneio = '#arguments.NUM_ROMANEIO#'
				<cfif Len(Trim(arguments.PLACA))>
                  and e.placa = '#arguments.PLACA#'                   
                </cfif>
                order by data_encerr desc, tracao desc
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    
    
    
    
</cfcomponent>