<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVA
	--  
	-- CRISTOFER 20/07/2005 - criado
	--->		
	<cffunction name="getPessoa" access="remote" returntype="Query" output="true">	  
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="rapida" displayname="Informa se a consulta  rapida" required="no" default="0">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">		
			<cfargument name="razao_social" required="no" default="">
            <cfargument name="cliente" required="no" default="">
            <cfargument name="municipio" required="no" default="">
			<cfargument name="cod_pessoa" required="no" default="">	
			<cfargument name="cod_funcionario" required="no" default="">	
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfargument name="completo" required="no" default="0">
			<cfargument name="excluir_filiais" required="no" default="">
			<cfif len(Trim(arguments.COD_FUNCIONARIO))>
				<cfquery name="qr_func" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.COD_FUNCIONARIO#),-1,#arguments.COD_FUNCIONARIO#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.COD_FUNCIONARIO#)) as cod_pessoa
					  from dual 
				</cfquery>
				<cfset arguments.COD_PESSOA = qr_func.COD_PESSOA>
			</cfif>
			<cfquery result="query" name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa,
					   p.tipo_pessoa,
                       pf.naturalidade,
                       <cfif session.site eq "delpozo/">
                       pf.cart_ident_emissao_uf,
                       to_char(pf.cnh_primeira_habilitacao,'dd/mm/yyyy') as primeira_cnh,
                       (select to_char(pcc.data_emissao_rntrc_tac, 'dd/mm/yyyy')
                          from kss.v$pessoa_cliente pcc
                         where pcc.cod_pessoa = p.cod_pessoa) as data_emissao_rntrc_tac,                       
                       to_char(pj.data_admissao,'dd/mm/yyyy') as data_admissao,
                       to_char(pf.cnh_data_emissao,'dd/mm/yyyy') as cnh_data_emissao,
					   (select to_char(pcc.data_validade_registro, 'dd/mm/yyyy')
                          from kss.v$pessoa_cliente pcc
                         where pcc.cod_pessoa = p.cod_pessoa) as data_validade_registro,
                       (select pcc.rntrc
                          from kss.v$pessoa_cliente pcc
                         where pcc.cod_pessoa = p.cod_pessoa) as rntrc,
                       </cfif>
                       <cfif session.site neq "delpozo/" and session.site neq "ouroverde/" and session.site neq "rodomar/" and session.site neq "bbm/">
                           decode(p.tipo_pessoa, 0, pj.rntrc_tac, 1, pf.rntrc_tac, 2, pe.rntrc_tac) as rntrc_tac,
                           decode(p.tipo_pessoa, 0, to_char(pj.data_vencimento_rntrc_tac,'dd/mm/yyyy'), 1, to_char(pf.data_vencimento_rntrc_tac,'dd/mm/yyyy'), 2, to_char(pe.data_vencimento_rntrc_tac,'dd/mm/yyyy')) as data_vencimento_rntrc_tac,
                           decode(p.tipo_pessoa, 0, to_char(pj.data_emissao_rntrc_tac,'dd/mm/yyyy'), 1, to_char(pf.data_emissao_rntrc_tac,'dd/mm/yyyy'), 2, to_char(pe.data_emissao_rntrc_tac,'dd/mm/yyyy')) as data_emissao_rntrc_tac,
                           to_char(pf.cnh_data_emissao,'dd/mm/yyyy') as cnh_data_emissao,
                           pf.cart_ident_uf,
                           to_char(pf.cnh_primeira_habilitacao, 'dd/mm/yyyy') as cnh_primeira_habilitacao,
                           pf.cnh_numero,
                           pf.cnh_uf as cnh_uf,
                       </cfif>
                       to_char(pf.cart_ident_emissao,'dd/mm/yyyy') as cart_ident_emissao,
                       pj.inscricao_municipal as ins_municipal,
      				   pf.uf_naturalidade,
                       pj.razao_social,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.cliente,                      
					   p.cod_atividade_fiscal,
					   p.tipo_pessoa as tipo_pessoa_id,
					   pf.cnh_num_registro as cnh,
					   trim(to_char(pf.cnh_validade, 'dd/mm/yyyy')) as validade_cnh,
					   pf.cnh_cod_categoria as categoria_cnh,
					   trim(to_char(pf.data_nascimento, 'dd/mm/yyyy')) as data_nascimento,
					   pf.cart_ident_num as rg,
					   pf.nome_pai,
					   pf.nome_mae,
                       pf.cod_estado_civil as estado_civil,
                       (select ec.estado_civil
                          from kss.estado_civil ec
                         where ec.cod_estado_civil = pf.cod_estado_civil) as estado_civil_desc,
					   pf.cart_ident_orgao as rg_orgao,
                       pf.cod_sexo,
                       <cfif session.site eq "delpozo/">
                       kss.pkg_pessoa.FNC_GET_ATRIBUTO(p.cod_pessoa, 4) as ja_carrega_empresa,
                       </cfif>
						<cfif session.site neq "transemba/" and session.site neq "portalkmm/" and session.site neq "delpozo/" >
						/* Relacionado ao pessoa_atributo */				   
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 1) as rntrc,
                       kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 18) as cart_ident_emissao_uf,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 2) as validade_rntrc,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 3) as primeira_cnh,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 4) as ja_carrega_empresa,				   
					   <cfif (session.site neq "ouroverde/") and (session.site neq "axon/")>
                       kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 5) as uf_cnh,
                       </cfif>
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 6) as permisso_numero,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 7) as permisso_data,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 8) as apolice_numero,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9) as apolice_vencimento,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 10) as IVA,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 11) as NOME_ESCRITORIO,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 12) as CONTATOS,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 13) as EMPRESAS_REPRESENTADAS,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 16) as COD_CONTA,
					   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 17) as CONTATO_CORRESPONDENCIA,
                       </cfif>
                       
						/* Relacionado ao pessoa_atributo */				   
	
					   case when p.tipo_pessoa = 0 then p.cnpj_cpf else null end as cnpj_completo,
					   case when p.tipo_pessoa = 0 then p.cliente else null end as nome_fantasia,
					   case when p.tipo_pessoa = 0 then p.inscricao_estadual else null end as inscricao_estadual_pj,
					   case when p.tipo_pessoa = 0 then p.razao_social else null end as razao_social,
					   case when p.tipo_pessoa = 0 then pj.cnae else null end as cnae,
                       <cfif session.site eq "rodomar/">
                       	case when p.tipo_pessoa = 0 then pj.alvara else null end as alvara_pj,
							case when p.tipo_pessoa = 1 then pf.alvara else null end as alvara_pf,  
                       </cfif>	
					   
                       case when p.tipo_pessoa = 1 then p.cliente else null end as nome,
					   case when p.tipo_pessoa = 1 then p.inscricao_estadual else null end as inscricao_estadual_pf,
					   case when p.tipo_pessoa = 1 then p.cnpj_cpf else null end as cpf,
                       
					   case when p.tipo_pessoa = 2 then p.cliente else null end as pe_nome,
					   case when p.tipo_pessoa = 2 then pe.municipio else null end as pe_municipio,
					   case when p.tipo_pessoa = 2 then pe.cod_cadastro_contribuinte else null end as cod_cadastro_contribuinte,
					   case when p.tipo_pessoa = 2 then pe.endereco else null end as pe_endereco,
					   case when p.tipo_pessoa = 2 then pe.estado_provincia else null end as estado_provincia,
					   case when p.tipo_pessoa = 2 then pe.codigo_postal else null end as codigo_postal,
					   case when p.tipo_pessoa = 2 then pe.pais else null end as pe_pais,
					   
                       pe.nome_fantasia as pe_nome_fantasia,
					   ped.logradouro as logradouro,
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.endereco, ped.logradouro || ', ' || ped.numero || decode(ped.complemento,null,'',' - ' || ped.complemento) || decode(ped.bairro,null,'',' - ' || ped.bairro)) as endereco,
					   ped.bairro, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.codigo_postal, to_char(ped.cep)) as cep, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio, ped.municipio) as municipio, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, 'EX', ped.uf) as uf, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio, ped.municipio) || decode(nvl(ped.uf,'EX'), 'EX', '', ' - ' || ped.uf) municipio_uf, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.municipio_ID, ped.municipio_id) municipio_id, 
					   decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone, 
					   m.pais_id, 
					   decode(p.tipo_pessoa,2/*Estrangeira*/, pe.pais,ps.descricao) as pais,
					   pf.pis_pasep_nit
					<cfif (session.site neq "granex/") and (session.site neq "transemba/") and (session.site neq "portalkmm/")>
					   ,oper.pkg_global.FNC_GET_COD_FUNCIONARIO(p.cod_pessoa) as cod_funcionario
					</cfif>
					<cfif (session.site eq "ouroverde/")>
                        ,pf.cnh_numero
                        ,pf.cnh_uf as uf_cnh
                    <cfelseif (session.site eq "axon/")>
                        ,pf.cnh_numero
                        ,pf.cnh_uf as uf_cnh
                    </cfif>
                    <cfif (session.site eq "transemba/" or session.site eq "axon/")>
                    	, p.tipo_transportador
                    </cfif>
				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_juridica pj
						 on pj.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_endereco ped 
						 on ped.cod_pessoa = p.cod_pessoa
						and ped.endereco_padrao = 1
				  left join kss.v$pessoa_telefone pt 
						 on pt.cod_pessoa = p.cod_pessoa
						and pt.telefone_padrao = 1
				  left join kss.v$telefone t 
						 on t.telefone_id = pt.telefone_id
				  left join cep.municipio m
						 on m.municipio_id = ped.municipio_id
				  left join cep.pais ps 
						 on ps.pais_id = m.pais_id					 
				 where 1 = 1
				 <cfif len(trim(arguments.razao_social))>
				   and upper(kss.pkg_string.fnc_string_clean(p.razao_social)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.razao_social#%'))
				 </cfif>
                 <cfif len(trim(arguments.cliente))>
				   and upper(kss.pkg_string.fnc_string_clean(p.cliente)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.cliente#%'))
				 </cfif>
                 <cfif len(trim(arguments.municipio))>
				   and upper(kss.pkg_string.fnc_string_clean(decode(p.tipo_pessoa, 2 /*Estrangeira*/, pe.municipio, ped.municipio))) like upper(kss.pkg_string.fnc_string_clean('%#arguments.municipio#%'))
				 </cfif>
				 <cfif len(trim(arguments.excluir_filiais))>
				   and  p.cnpj_cpf not like  '#Left(Replace(Replace(session.empresa.CNPJ,'C.N.P.J.: ','','ALL'),'.','','ALL'),8)#%'
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf)) and arguments.completo eq 0>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#%' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif> 
				 <cfif len(trim(arguments.cnpj_cpf)) and arguments.completo eq 1>
				   and p.cnpj_cpf = '#arguments.cnpj_cpf#'
				 </cfif> 
				 <cfif arguments.rapida eq 1>
				   and rownum = 1
				 </cfif>
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa)) >
				   and p.tipo_pessoa in (#arguments.tipo_pessoa#)
				 </cfif>	
				 <cfif len(trim(arguments.num_modalidade))>
                   and exists (select 1
                                 from kss.v$pessoa_modalidade pm 
                                where pm.cod_pessoa = p.cod_pessoa
                                  and pm.num_modalidade in (#arguments.num_modalidade#)
                                  and pm.situacao = 1)
				 </cfif>                 
				 order by p.cliente
			</cfquery>  
		<cfreturn qr />
	</cffunction>			
    
    <!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 01/02/2006 - criado
	--->		
	<cffunction name="get_pessoa_light" access="remote" returntype="Query" output="true">	  
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">		
			<cfargument name="cliente" required="no" default="">	
			<cfargument name="cod_pessoa" required="no" default="">	
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfargument name="modalidade_id" required="no" default="">
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="razao_social" required="no" default="">	
			<cfargument name="municipio" required="no" default="">
			<cfargument name="tipo" required="no" default="">
			<cfargument name="valor" required="no" default="">
			<cfargument name="rapida" required="no" default="0">
			<cfargument name="posto" required="no" default="0">			
			<cfargument name="oficina" required="no" default="0">
            <cfargument name="cod_atividade_fiscal" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select distinct p.cod_pessoa,
					   p.tipo_pessoa,
					   p.cnpj_cpf,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.razao_social,
					   p.cliente,
					   p.cod_atividade_fiscal,
                       po.numero,
                       po.logradouro,
					   p.tipo_pessoa as tipo_pessoa_id,
					   0 as cod_funcionario,
                       kss.pkg_pessoa.fnc_get_endereco(p.cod_pessoa,1) as endereco_completo,
					   nvl(po.municipio,pe.municipio) as municipio, po.uf, nvl(po.municipio_id, pe.municipio_id) as municipio_id,
                       nvl(po.municipio,pe.municipio) || ' - ' || po.uf as municipio_uf
					<cfif arguments.posto eq 1>
						,  (select preco
							  from oper.v$posto_historico_produto_prec php
							 where produto_id = 62
							   and cod_pessoa = p.cod_pessoa
							   and data_vigencia = (select max(data_vigencia)
													  from oper.v$posto_historico_produto_prec php2
													 where php2.cod_pessoa = php.cod_pessoa
													   and php2.produto_id = php.produto_id)) preco_diesel
					</cfif>
				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_endereco po
				         on po.cod_pessoa = p.cod_pessoa
						  and po.endereco_padrao = 1
				<cfif len(trim(arguments.modalidade_Id))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1  
						and pm.num_modalidade in (#arguments.modalidade_id#)
				</cfif>
				<cfif len(trim(arguments.num_modalidade))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1  
						and pm.num_modalidade in (#arguments.num_modalidade#)
				</cfif>
				 where 1=1
				 <cfif len(trim(arguments.cliente))>
				   and upper(p.cliente) like upper('%#arguments.cliente#%')
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf))>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#%' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif> 
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 3 >
				   and (p.cnpj_cpf like '#arguments.valor#%' or pe.cod_cadastro_contribuinte like '#arguments.valor#%')
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 2 >
				   and upper(p.cliente) like upper('%#arguments.valor#%')
				 </cfif> 
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa))>
				   and p.tipo_pessoa = #arguments.tipo_pessoa#
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 1 >
				   and upper(p.razao_social) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif isDefined('arguments.tipo') and arguments.tipo eq 4 >
				   and upper(po.municipio) like upper('%#arguments.valor#%')
   					or upper(pe.municipio) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif len(trim(arguments.razao_social))>
				   and upper(p.razao_social) like upper('%#arguments.razao_social#%')
				 </cfif>
				 <cfif arguments.rapida eq 1>
				   and rownum = 1
				 </cfif>
                 <cfif Len(Trim(arguments.cod_atividade_fiscal))>
				   and p.cod_atividade_fiscal = #arguments.cod_atividade_fiscal#
				 </cfif>
				   order by <cfif arguments.oficina eq 1>p.cliente, </cfif>p.razao_social
			</cfquery>  
		<cfreturn qr />
	</cffunction>

</cfcomponent>