<cfcomponent extends="modulos.manutencao._componentes.consulta.cfc_manutencao">    
    <!--- 
	-- PROPSITO 
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 08/04/2009
	--->
	<cffunction name="get_equipamentos" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfargument name="somente_placa" required="no" default="">
		<cfargument name="sem_modelo" required="no" default="0">
        <cfargument name="equipamento" required="no" default="">
        <cfargument name="analisados" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.equipamento_id
                 , m.cod_equipamento
                 , m.placa
                 , ma.material
                 , (select ce.contrato_id
                      from manutencao.v$contrato_equipamento ce
                     where ce.equipamento_id = m.equipamento_id
                       and ce.data_termino is null) as contrato_id
                 , (select cg.organizacional_id
                      from oper.v$veiculo_ccusto_gerencial cg
                     where cg.placa = m.placa
                       and cg.data_cancelamento is null) as organizacional_id
			        , (select cg.cod_centro_custo
                      from oper.v$veiculo_ccusto_atual cg
                     where cg.placa = m.placa) as cod_centro_custo
			     , (select min(o.cod_organograma)
					  from kss.v$organograma o
					 where (o.cod_pessoa, o.cod_centro_custo) in
						   (select cg.cod_pessoa_filial
								  ,cg.cod_centro_custo
						      from oper.v$veiculo_ccusto_atual cg
						     where cg.placa = m.placa)) as cod_organograma
                 <cfif Len(trim(arguments.NUM_ROMANEIO))>
                 , (select sign(count(1))
                      from oper.v$romaneio_hist_veiculo rhv
                     where rhv.num_romaneio = #arguments.NUM_ROMANEIO#
                      and (rhv.placa_referencia = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
                        or rhv.placa_controle = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'))
                    ) as permitido_romaneio
                 <cfelse>
                 , 1 as permitido_romaneio
                 </cfif>
              from almoxarifado.v$equipamento m
             inner join almoxarifado.v$material_dados ma
                     on ma.material_id = m.material_id
            <cfif Len(trim(arguments.analisados))>
              left join manutencao.v$equipamento_analise ea
                     on ea.equipamento_id = m.equipamento_id
            </cfif>
             where 1 = 1
            <cfif Len(Trim(arguments.equipamento_id))>
               and m.equipamento_id = #arguments.equipamento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
               and m.cod_equipamento = '#arguments.cod_equipamento#'
            </cfif>
            <cfif Len(Trim(arguments.somente_placa))>
               and upper(m.placa) = upper('#arguments.somente_placa#')
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (m.cod_equipamento = '#arguments.placa#'
                    or m.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
                   )
            </cfif>
            <cfif arguments.sem_modelo eq 1>
               and not exists (select 'x'
                                 from manutencao.v$equipamento_modelo em
                                where em.equipamento_id = m.equipamento_id
                                  and em.data_final is null)
            </cfif>
            <cfif Len(trim(arguments.equipamento))>
               and upper(ma.material) like upper('%#arguments.equipamento#%')
            </cfif>
            <cfif Len(trim(arguments.analisados))>
               and ea.data_analise is null
            </cfif>
             order by ma.material, m.cod_equipamento
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>           
        
    <!--- 
	-- PROPSITO 
	-- Busca materiais usados na OS
	-- NOTAS EXPLICATIVAS
	-- SENGER 16/08/2010
	--->
	<cffunction name="get_os_materiais_agrupados" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.material_id,
                   t.produto_id,
                   t.material,
                   t.unidade_estoque,
                   sum( t.quantidade ) as quantidade,
                   t.valor_unitario,
                   sum( t.valor_total ) as valor_total
            from (
                select om.material_id,
                      (select mp.produto_id
                                from almoxarifado.v$material_produto mp
                               where mp.material_id = om.material_id) as produto_id,
                       m.material,
                       
                       m.unidade_estoque,
                       om.quantidade,
                       om.valor_unitario,
                       om.valor_total
                       
                       
                  from manutencao.v$ordem_servico os
                 inner join manutencao.v$os_material om on om.ordem_servico_id = os.ordem_servico_id
                 inner join almoxarifado.v$material_dados m on m.material_id = om.material_id
                 inner join almoxarifado.v$material_dados mr on mr.material_id = om.material_id_retirado
                  left join kss.v$pessoa p on p.cod_pessoa = om.cod_pessoa_retirada
                  left join almoxarifado.v$equipamento e on e.equipamento_id = om.equipamento_id
                  left join manutencao.v$equipamento_posicao ep on ep.posicao_id = om.posicao_id
                  left join almoxarifado.v$equipamento er on er.equipamento_id = om.equipamento_id_retirado
                 where 1 = 1
                   and os.ordem_servico_id = #arguments.ordem_servico_id#
                 order by om.date_insert
            ) t
            
            group by t.material_id, t.material, t.produto_id, t.unidade_estoque, t.valor_unitario
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca atividades da OS agrupadas
	-- NOTAS EXPLICATIVAS
	-- SENGER 16/08/2010
	--->
	<cffunction name="get_os_atividades_agrupadas" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="verificacao" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.atividade_id,
                   t.titulo,
                   produto_id,
                   sum(nvl(t.valor,0)) as valor,
                   count(produto_id) as quantidade            
            from (
            select oa.atividade_id,
                   a.titulo,
                   (select ap.produto_id
                      from manutencao.v$atividade_produto ap
                     where ap.atividade_id = oa.atividade_id) as produto_id,
                   oa.valor_servico as valor
              from manutencao.v$ordem_servico os
             inner join manutencao.v$os_atividade oa on oa.ordem_servico_id = os.ordem_servico_id
             inner join manutencao.v$atividade a on a.atividade_id = oa.atividade_id
              left join manutencao.v$equipamento_posicao ep on ep.posicao_id = oa.posicao_id
             where 1 = 1
              	<cfif Len(Trim(arguments.ordem_servico_id))>
                    and os.ordem_servico_id = #arguments.ordem_servico_id#
                </cfif>
                <cfif Len(Trim(arguments.controle_id))>
                    and oa.controle_id = #arguments.controle_id#
                </cfif>
                <cfif arguments.verificacao eq 1>
                    and a.verificacao = 1
                </cfif>
             order by oa.date_insert
            ) t
            
            group by atividade_id, titulo, produto_id

 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Ordens de Servio pelo Npumero
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 21/05/2013
	--->
	<cffunction name="get_os_por_numero" returntype="query" access="remote">
		<cfargument name="NUM_ORDEM_SERVICO" required="no" default="">
        <cfargument name="ORDEM_SERVICO_ID" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                , os.ordem_servico_id
                , os.cod_pessoa_oficina
                , kss.pkg_pessoa.fnc_get_cliente(os.cod_pessoa_oficina) as oficina
                , kss.pkg_pessoa.fnc_get_identificador(os.cod_pessoa_oficina) as cnpj_oficina
                , (select e.cod_equipamento || decode(e.cod_equipamento , e.placa, null, '(' || e.placa || ')')
                     from almoxarifado.v$equipamento e
                    where e.equipamento_id = os.equipamento_id ) as equipamento
             from manutencao.v$ordem_servico os
            where 1 = 1
              and os.empresa = 0
            <cfif Len(Trim(arguments.NUM_ORDEM_SERVICO))>
              and os.num_ordem_servico = #arguments.NUM_ORDEM_SERVICO#
            </cfif>
            <cfif Len(Trim(arguments.ORDEM_SERVICO_ID))>
              and os.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
            </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

   <cffunction name="get_material_dados_por_codigo" returntype="query" access="remote">
      <cfargument name="material_id" required="no" default=""/>
      <cfargument name="cod_material" required="no" default=""/>
      <cfargument name="material" required="no" default=""/>
      <cfargument name="atributo" required="no" default=""/>
      <cfargument name="com_saldo_estoque" required="no" default="0"/>
      <cfargument name="cod_pessoa_filial" required="no" default=""/>
      <cfargument name="estoque" required="no" default="1"/>
      <cfargument name="niv_arvore" required="no" default=""/>
      <cfargument name="ativo" required="no" default="1"/>
      <cfargument name="tabela_id" required="no" default=""/>
      	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select material_id
              , material_pai
              , cod_material
              , titulo
              , descricao
              , compoe_descricao
              , estoque
              , unidade_estoque
              , unidade_comercializacao
              , identificado
              , cod_genuino
              , cod_fabricante
              , cod_paralelo
              , material
              , produto_id
              , valor
              , almoxarifado.pkg_almoxarifado.fnc_estoque_material(material_id, <cfif Len(Trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial#<cfelse>#session.cod_pessoa#</cfif>, sysdate) as saldo_estoque
              , nvl(almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(<cfif Len(Trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial#<cfelse>#session.cod_pessoa#</cfif>,material_id,12),'') as localizacao
              , exige_devolucao 
              , qtde_maxima 
              , qtde_minima
           from (
						<cfif Len(Trim(arguments.cod_material))>
							select m.material_id
								 , m.material_pai
								 , m.cod_material
								 , m.titulo
								 , m.descricao
								 , m.compoe_descricao
								 , m.estoque
								 , m.unidade_estoque
								 , m.unidade_comercializacao
								 , m.identificado
								 , nvl(almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 29),0) as exige_devolucao
                                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 9) cod_genuino
								 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 10) cod_fabricante
								 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 11) cod_paralelo
								 , descricao_completa as material
                                 , (select mp.produto_id
                                      from almoxarifado.v$material_produto mp
                                     where mp.material_id = m.material_id) as produto_id
                                 , (select max(level)
                                      from almoxarifado.v$material t
                                     start with t.material_id = m.material_id
                                     connect by prior t.material_id = t.material_pai) as niv_arvore
							     <cfif Len(Trim(arguments.tabela_id))>
                                 , t.valor
                                 <cfelse>
                                 , 0 as valor
                                 </cfif>
                                 , m.qtde_maxima
                                 , m.qtde_minima
							  from almoxarifado.v$material m
							 inner join almoxarifado.v$material_atributo ma
										on ma.material_id = m.material_id
							<cfif Len(Trim(arguments.tabela_id))>
                             inner join (select tpm.material_id
                                              , tpm.valor
                                           from compras.v$tabela_preco_material tpm
                                          where tpm.tabela_id = #arguments.tabela_id#
                                            and tpm.data_vigencia = (select max(tpm2.data_vigencia)

                                                                       from compras.v$tabela_preco_material tpm2
                                                                      where tpm2.material_id = tpm.material_id
                                                                        and tpm2.tabela_id = tpm.tabela_id
                                                                        and tpm2.data_vigencia <= sysdate
                                                                    )
                                        ) t
                                     on t.material_id = m.material_id
                            </cfif>
							 where 1 = 1
						        and ma.ATRIBUTO_ID in (9,10,11)
						        and upper(ma.valor_padrao) like upper('#arguments.cod_material#%')
                           <cfif arguments.estoque eq 1>
                                and m.estoque = 1
                           </cfif>
                           <cfif Len(Trim(arguments.ativo))>
                           and m.ativo = #arguments.ativo#
                           </cfif> 
						   <cfif Len(Trim(arguments.material))>
                                and upper(kss.pkg_string.fnc_string_clean(descricao_completa)) like upper('%#arguments.material#%')
                           </cfif>
							union all
						</cfif>
						select m.material_id
							 , m.material_pai
							 , m.cod_material
							 , m.titulo
							 , m.descricao
							 , m.compoe_descricao
							 , m.estoque
							 , m.unidade_estoque
							 , m.unidade_comercializacao
							 , m.identificado
							 , nvl(almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 29),0) as exige_devolucao
							 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 9) cod_genuino
							 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 10) cod_fabricante
							 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(m.material_id, 11) cod_paralelo
							 , descricao_completa as material
                             , (select mp.produto_id
                                  from almoxarifado.v$material_produto mp
                                 where mp.material_id = m.material_id) as produto_id
                             , (select max(level)
                                  from almoxarifado.v$material t
                                 start with t.material_id = m.material_id
                               connect by prior t.material_id = t.material_pai) as niv_arvore
                             <cfif Len(Trim(arguments.tabela_id))>
                             , t.valor
                             <cfelse>
                             , 0 as valor
                             </cfif>
                             , m.qtde_maxima
                             , m.qtde_minima
						  from almoxarifado.v$material m
						<cfif Len(Trim(arguments.tabela_id))>
                         inner join (select tpm.material_id
                                          , tpm.valor
                                       from compras.v$tabela_preco_material tpm
                                      where tpm.tabela_id = #arguments.tabela_id#
                                        and tpm.data_vigencia = (select max(tpm2.data_vigencia)
                                                                   from compras.v$tabela_preco_material tpm2
                                                                  where tpm2.material_id = tpm.material_id
                                                                    and tpm2.tabela_id = tpm.tabela_id
                                                                    and tpm2.data_vigencia <= sysdate
                                                                )
                                    ) t
                                 on t.material_id = m.material_id
                        </cfif>
						 where 1 = 1
                           <cfif arguments.estoque eq 1>
                           and m.estoque = 1
                           </cfif>
						   <cfif Len(Trim(arguments.material))>
                           and upper(kss.pkg_string.fnc_string_clean(descricao_completa)) like upper(kss.pkg_string.fnc_string_clean('%#Replace(arguments.material, ' ', '%', 'all')#%'))
                           </cfif>
						   <cfif Len(Trim(arguments.cod_material))>
						   and upper(m.cod_material) like upper('#arguments.cod_material#%')
						   </cfif>
                           <cfif Len(Trim(arguments.ativo))>
                           and m.ativo = #arguments.ativo#
                           </cfif> 
							)
						 where 1=1
						<cfif Len(Trim(arguments.material_id))>
						   and material_id = #arguments.material_id# 
						</cfif>
                        <cfif Len(Trim(arguments.niv_arvore))>
						   and niv_arvore <= #arguments.niv_arvore#
						</cfif>
                         order by material
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

</cfcomponent>
