<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init" output="yes">

	<!--- 
	-- PROPSITO 
	-- Busca o organograma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER - 03/01/2006 - criado
	-- GUTO 24/02/2006 - modificado, inserido o lag para montar a arvore no combo
	--->	
	<cffunction name="get_organograma" displayname="Busca o organograma" access="remote" returntype="query" output="true">
		<cfargument name="COD_PESSOA" 		required="no" default="">
        <cfargument name="COD_UNIDADE_NEGOCIO" 		required="no" default="">
        <cfargument name="COD_CENTRO_CUSTO" required="no" default="">
		<cfargument name="COD_DEPARTAMENTO" required="no" default="">
        <cfargument name="COD_SETOR" required="no" default="">
        <cfargument name="CENTRO_CUSTO" required="no" default="">
        <cfargument name="SETOR" required="no" default="">
		<cfargument name="NOME_FANTASIA" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
			select /*+FIRST_ROWS*/ distinct rownum, u.cod_unidade_negocio, p.cod_pessoa, 
  					 p.cliente nome_fantasia, d.cod_departamento, d.descricao as departamento,
   			    s.cod_setor,  s.descricao as setor,
  				    c.cod_centro_custo, c.centro_custo,
  				    sysdate as data, o.cod_organograma
			 from kss.v$organograma o 
			inner join kss.v$unidade_negocio u
					on o.cod_unidade_negocio = u.cod_unidade_negocio
			inner join kss.v$pessoa p
					on u.cod_pessoa = p.cod_pessoa
			inner join kss.v$departamento d
					  on o.cod_departamento = d.cod_departamento
			inner join kss.v$setor s
					on o.cod_setor = s.cod_setor				
			inner join kss.v$centro_custo c
					  on o.cod_centro_custo = c.cod_centro_custo
			where 1=1
			<cfif len(trim(arguments.COD_PESSOA))>
			  and u.cod_pessoa = #arguments.COD_PESSOA#
			</cfif>
            <cfif len(trim(arguments.COD_UNIDADE_NEGOCIO))>
			  and u.cod_unidade_negocio = #arguments.COD_UNIDADE_NEGOCIO#
			</cfif>
            <cfif len(trim(arguments.COD_CENTRO_CUSTO))>
            	and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
            </cfif>
			<cfif len(trim(arguments.COD_DEPARTAMENTO))>
			  and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
			</cfif>
			<cfif len(trim(arguments.COD_SETOR))>
			  and o.cod_setor = #arguments.COD_SETOR#
			</cfif>
            <cfif len(trim(arguments.NOME_FANTASIA))>
			  and upper(p.cliente) like upper('%#arguments.NOME_FANTASIA#%')
			</cfif>
            <cfif len(trim(arguments.CENTRO_CUSTO))>
			  and upper(c.centro_custo) like upper('%#arguments.CENTRO_CUSTO#%')
			</cfif>
            <cfif len(trim(arguments.SETOR))>
              and upper(s.descricao) like upper('%#arguments.setor#%')	
            </cfif>
			order by nome_fantasia, departamento, setor, c.centro_custo
		</cfquery>
		<cfreturn qr_organograma>
	</cffunction>	
    
    <!--- 
    -- PROPSITO 
    -- Retorna Funcionrio - XML
    -- LEOPOLDOS 02/06/2010 - CRIADO
    --->		
    <cffunction name="get_funcionario_xml" access="remote" returntype="query" output="true">
    	<cfargument name="cod_funcionario" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('		 
                 select distinct fma.num_matricula cod_funcionario,
                        f.nome_funcionario,
                        f.cpf_funcionario,
                        f.cod_pessoa,
                        f.cod_entreposto as empresa
                   from oper.v$rh_funcionario f
              left join kss.v$funcionario_matr_atual fma
                     on fma.cod_pessoa = f.cod_pessoa
                  where 1 = 1
                    and fma.num_matricula = #arguments.COD_FUNCIONARIO#
             ') as resultado
         from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consulta o funcionrio pelo cdigo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_funcionario" displayname="Consulta funcionrio pelo cdigo" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no" default="">
		<cfargument name="pessoa" required="no" default="0">
		<cfargument name="nome" required="no" default="">
		<cfargument name="ativos" required="no" default="0">
		<cfargument name="filtro" required="no" default="">
        <cfargument name="num_modalidade" required="no" default="">
		<cfif arguments.pessoa EQ 0>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				<cfif session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/' or session.site eq 'braf/'>
				 select distinct fma.num_matricula cod_funcionario,
                        f.nome_funcionario,
                        f.cpf_funcionario,
                        f.cod_pessoa,
                        f.cod_entreposto as empresa
                   from oper.v$rh_funcionario f
              left join kss.v$funcionario_matr_atual fma
                     on fma.cod_pessoa = f.cod_pessoa
                  where 1 = 1
                 <cfelse>
				 <cfif session.site eq 'bbmtransportes/'>
				select distinct
					   f.cod_funcionario, 
					   f.nome_funcionario, 
					   f.cpf_funcionario, 
					   f.cod_pessoa,
					   f.cod_entreposto as empresa
				  from oper.v$rh_funcionario f
				 where 1=1
				<cfelseif session.site eq 'transemba/' or session.site eq 'axon/'>
                select fd.matricula as cod_funcionario
                     , fd.nome as nome_funcionario
                     , fd.cpf as cpf_funcionario
                     , fd.cod_pessoa
                     , fd.cod_pessoa_empresa as empresa
                  from folha.v$funcionario_dados fd
                 where fd.data_demissao is null
                 	<cfif Len(Trim(session.cod_pessoa))>
                   		and fd.cod_pessoa_empresa = #session.cod_pessoa#
                   </cfif>
				<cfelse>
					select distinct
						   oper.pkg_global.fnc_get_cod_funcionario(f.cod_pessoa) cod_funcionario,                           
						   f.nome_funcionario, 
						   f.cpf_funcionario, 
						   oper.pkg_global.fnc_get_cod_pessoa_funcionario(to_char(f.cod_funcionario)) as cod_pessoa,
						   f.cod_entreposto as empresa
					  from oper.v$rh_funcionario f
					 where 1=1
                    <cfif Len(Trim(arguments.FILTRO))>
                    	<cfif IsNumeric(arguments.FILTRO)>
                        	and f.cod_funcionario = #arguments.FILTRO#
                        <cfelse>
                            and upper(kss.pkg_string.fnc_string_clean(f.nome_funcionario)) like upper('%#arguments.FILTRO#%')
                        </cfif>
                    </cfif>
					<cfif Isdefined("arguments.ativos") and arguments.ativos eq 1>
					   and oper.pkg_global.fnc_get_cod_pessoa_funcionario(to_char(f.cod_funcionario)) <> -1
					</cfif>
				</cfif>
                </cfif>
				<cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and session.site neq 'ouroverde/' and session.site neq 'transgires/' and session.site neq 'transemba/' and session.site neq 'vialacteos/' and session.site neq 'axon/'>
				   and to_char(f.cod_funcionario) = '#arguments.cod_funcionario#'
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/')>
				   and fma.num_matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'transemba/' or session.site eq 'axon/')>
				   and fd.matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif Len(Trim(arguments.num_modalidade)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'braf/')>
                   and fma.num_modalidade in (#arguments.num_modalidade#)
                </cfif>
				<cfif len(trim(arguments.nome)) and session.site neq 'transemba/' and session.site neq 'axon/'>
				   and upper(f.nome_funcionario) like upper('%#arguments.nome#%')
                <cfelseif len(trim(arguments.nome))>
                   and upper(fd.nome) like upper('%#arguments.nome#%')
				</cfif>
                
                <cfif session.site neq 'transemba/' and session.site neq 'axon/'>
				 order by f.nome_funcionario
                <cfelse>
				 order by fd.nome
				</cfif>
			</cfquery>
			<cfif qr_funcionario.RecordCount  EQ 0 and len(trim(arguments.cod_funcionario)) and session.site neq 'transemba/' and session.site neq 'vialacteos/' and session.site neq 'axon/' and session.site neq 'transgires/'>
				<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
					select p.cod_pessoa as cod_funcionario, p.nome as nome_funcionario, p.cod_pessoa, 0 as empresa
					 from kss.v$pessoa_fisica p
						where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
				</cfquery>			
			</cfif>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa as cod_funcionario, p.nome as nome_funcionario, p.cod_pessoa, 0 as empresa
				 from oper.v$pessoa_fisica p
				 where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#) 
			</cfquery>			
		</cfif>			
		
		<cfreturn qr_funcionario>
	</cffunction>
 </cfcomponent>
