<cfcomponent displayname="Componentes de consulta para o controle de trafego" extends="_transportes.funcoes.cfc_init">
    <!---
    -- PROPÓSITO
    -- Busca as solicitações de compras
    -- ANDERSON 16/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_compra" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="num_controle" required="no" default="">
        <cfargument name="titulo" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.solicitacao_id
                 , s.num_controle
                 , s.titulo
                 , s.cod_organograma
                 , s.cod_pessoa_emissao
                 , oper.pkg_global.fnc_get_cod_funcionario(s.cod_pessoa_emissao) as cod_funcionario
                 , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as nome_funcionario
                 , to_char(s.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , s.equipamento_id
                 , (select e.cod_equipamento
                      from almoxarifado.v$equipamento e
                     where e.equipamento_id = s.equipamento_id) as cod_equipamento
                 , s.equipamento_custo_id
                 , (select e.cod_equipamento
                      from almoxarifado.v$equipamento e
                     where e.equipamento_id = s.equipamento_custo_id) as cod_equipamento_custo
                 , (select ma.material
                      from almoxarifado.v$equipamento e
                 	 inner join almoxarifado.v$material_dados ma
                        on ma.material_id = e.material_id
                     where e.equipamento_id = s.equipamento_custo_id) as material_equipamento_custo
                 , (select ma.material
                      from almoxarifado.v$equipamento e
                     inner join almoxarifado.v$material_dados ma
                             on ma.material_id = e.material_id
                     where e.equipamento_id = s.equipamento_id) as equipamento
                 , (select ma.material
                      from almoxarifado.v$equipamento e
                     inner join almoxarifado.v$material_dados ma
                             on ma.material_id = e.material_id
                     where e.equipamento_id = s.equipamento_custo_id) as equipamento_custo
                 , s.observacao
                 , s.situacao_id
                 , (select cg.rv_abbreviation
                      from compras.v$cg_ref_codes cg
                     where cg.rv_low_value = s.situacao_id
                       and cg.rv_domain = 'SOLICITACAO SITUACAO') as situacao
                 , s.prioridade_id
                 , (select sp.descricao
                      from compras.v$solicitacao_prioridade sp
                     where sp.prioridade_id = s.prioridade_id) as prioridade
                 , s.area_id
                 , (select a.descricao
                      from compras.v$area a
                     where a.area_id = s.area_id) as area
                 , s.cod_pessoa_fornecedor
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = s.cod_pessoa_fornecedor) as cnpj_fornecedor
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = s.cod_pessoa_fornecedor) as fornecedor
                 , (select o.cod_organizacional
                      from kss.v$organizacional o
                     where o.organizacional_id = s.organizacional_id) as cod_organizacional
                 ,(select o.organizacional_id
                     from kss.v$organizacional o
                    where o.organizacional_id = s.organizacional_id) as organizacional_id
                 , (select razao_social
                      from kss.v$pessoa p
                     inner join kss.v$usuarios u
                        on u.cod_pessoa = p.cod_pessoa
                     where u.usuario = s.aprovacao_gestor) as gestor_aprovacao
                 , to_char(s.data_aprovacao_gestor,'dd/mm/yyyy hh24:mi:ss') as data_aprovacao_gestor
                 , (select razao_social
                      from kss.v$pessoa p
                     inner join kss.v$usuarios u
                        on u.cod_pessoa = p.cod_pessoa
                     where u.usuario = s.aprovado_por) as diretoria_aprovacao
                  , to_char(s.data_aprovacao,'dd/mm/yyyy hh24:mi:ss') as data_aprovacao_diretoria
              from compras.v$solicitacao s
             inner join kss.v$organograma o
                     on o.cod_organograma = s.cod_organograma
             where 1 = 1
			<cfif Len(Trim(arguments.solicitacao_id))>
               and s.solicitacao_id = #arguments.solicitacao_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and o.cod_pessoa = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.num_controle))>
               and s.num_controle = #arguments.num_controle#
            </cfif>
            <cfif Len(Trim(arguments.titulo))>
               and upper(s.titulo) like upper('#arguments.titulo#%')
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(s.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(s.data_emissao) <= '#arguments.data_fim#'
            </cfif>
             order by s.num_controle asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPÓSITO
    -- Retorna o logotipo da empresa
    -- Ricardo 16/02/2015 - CRIADO
    --->
    <cffunction name="get_logo_empresa" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.razao_social_resumida
                 , e.cod_pessoa
                 , e.logotipo
              from kss.v$empresa e
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPÓSITO
    -- Retorna os lista de pedidos
    -- WAGNERS 05/07/2012 - CRIADO
    --->
    <cffunction name="get_lista_pedidos" access="remote" returntype="query" output="true">
        <cfargument name="situacao_id" required="no" default="1">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="fornecedor" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pe.pedido_id
                 , pe.num_pedido
                 , to_char(pe.data_pedido,'dd/mm/yyyy') as data_pedido
                 , pe.valor_material
                 , pe.valor_atividade
                 , pe.valor_total_pedido
                 , pe.situacao_id
                 ,(select c.rv_abbreviation
                     from compras.v$cg_ref_codes c
                    where c.rv_low_value = pe.situacao_id
                      and c.rv_domain = 'PEDIDO SITUACAO') as situacao
                 , ftp.forma_descricao as forma_pagamento
                 , pen.descricao as prazo_entrega
                 , p.cnpj_cpf
                 , p.razao_social as fornecedor
                 , pe.user_insert
                 , pe.date_insert
                 , pe.user_update
                 , pe.date_update
                 , kss.pkg_pessoa.fnc_get_endereco(pe.cod_pessoa_fornecedor, 1) as endereco_fornecedor
                 , pe.data_vencimento
                 , pe.data_entrega
                 , pe.local_entrega
                 , decode(pe.enviado_email, 0, 'Não', 'Sim') as enviado_email
                 , pe.observacoes
                 , pe.enviado_para
              from compras.v$pedido pe
             inner join kss.v$faturamento_forma ftp
                     on ftp.forma_id = pe.forma_pagto_id
             inner join compras.v$prazo_entrega pen
                     on pen.prazo_entrega_id = pe.prazo_entrega_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = pe.cod_pessoa_fornecedor
            where 1=1
              and exists (select 'x'
              			    from compras.v$solicitacao_pedido_det spd
                		   where spd.pedido_id = pe.pedido_id)
              and exists ( select 'x'
                             from compras.v$area_responsavel ar
                            inner join compras.v$solicitacao s
                               on s.area_id = ar.area_id
                            inner join compras.v$solicitacao_pedido_det spd
                               on spd.solicitacao_id = s.solicitacao_id
                            where spd.pedido_id = pe.pedido_id
                              and ar.usuario = user)
            <cfif Len(Trim(arguments.situacao_id))>
                and pe.situacao_id in (#arguments.situacao_id#)
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(pe.data_pedido) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(pe.data_pedido) <= '#arguments.data_fim#'
            </cfif>
            order by pe.num_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna dados do pedido
    -- GUTO 02/02/2010 - CRIADO
    --->
    <cffunction name="get_pedido" access="remote" returntype="query" output="true">
        <cfargument name="pedido_id" required="no" default="">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="pedido_nf_id" required="no" default="">
        <cfargument name="not_pedido_nf_id" required="no" default="">
        <cfargument name="pedidos_disponiveis" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pedido_id
                 , p.num_pedido
                 , pe.identificador as cnpj
                 , pe.inscricao_estadual
                 , pe.razao_social
                 , pe.cliente as fornecedor
                 , pep.logradouro
                 , pep.numero
                 , pep.bairro
                 , pep.municipio
                 , pep.uf
                 , pep.cep
                 , ptp.telefone
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , to_char(nvl(p.data_vencimento, p.data_pedido + 35), 'dd/mm/yyyy') as data_vencto
                 , to_char(p.valor_total_pedido, 'FM999G999G990D00', 'nls_numeric_characters='',.''') as valor_total_pedido
                 , autenticacao
                 , to_char(p.data_entrega, 'dd/mm/yyyy') as data_entrega
                 , p.local_entrega
                 , p.observacoes
                 , compras.pkg_compras.fnc_get_equipamento_pedido(p.pedido_id) as equipamentos
                 , (select cg.rv_abbreviation
                      from compras.v$cg_ref_codes cg
                     where cg.rv_low_value = p.situacao_id
                       and cg.rv_domain = 'PEDIDO SITUACAO') as situacao
                 , (select kss.fnc_concat_all(kss.to_concat_expr(s.num_controle,'/'))
                      from compras.v$solicitacao s
                     inner join compras.v$solicitacao_pedido_det spd
                        on s.solicitacao_id = spd.solicitacao_id
                     where spd.pedido_id = p.pedido_id) as lista_solicitacoes
                 , compras.pkg_compras.fnc_get_pessoa_emissao_pedido(p.pedido_id) as cod_pessoa_emissao
              from compras.v$pedido p
             inner join kss.v$pessoa pe
                     on pe.cod_pessoa = p.cod_pessoa_fornecedor
              left join kss.v$pessoa_endereco_padrao pep
                     on pep.cod_pessoa = pe.cod_pessoa
              left join kss.v$pessoa_telefone_padrao ptp
                     on ptp.cod_pessoa = pe.cod_pessoa
             where 1=1
             <cfif len(trim(arguments.pedido_id)) >
             	and p.pedido_id = #arguments.pedido_id#
             </cfif>
             <cfif len(trim(arguments.num_pedido)) >
             	and p.num_pedido = #arguments.num_pedido#
             </cfif>
             <cfif len(trim(arguments.cod_pessoa_fornecedor)) >
             	and p.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
             </cfif>
             <cfif Len(Trim(arguments.data_inicio))>
               and trunc(p.data_pedido) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(p.data_pedido) <= '#arguments.data_fim#'
            </cfif>
            <cfif len(trim(arguments.pedido_nf_id)) >
            	and p.pedido_id in (select pedido_id
                 					from compras.v$pedido_nf_item pni
                                   where pni.pedido_nf_id = #arguments.pedido_nf_id#)
            </cfif>
            <cfif len(trim(arguments.not_pedido_nf_id)) >
            	and p.pedido_id not in (select pedido_id
                                          from compras.v$pedido_nf_item pni
                                         where pni.pedido_nf_id = #arguments.not_pedido_nf_id#)
            </cfif>
            <cfif len(trim(arguments.pedidos_disponiveis))>
               and  (select sum((c.quantidade - (
                                 nvl((select sum( mov.quantidade / fiscal.pkg_fiscal.fnc_converte_peso(p_peso                   => 1
                                                                                                   , p_cod_unidade_referencia => nvl(c.cod_unidade, m.unidade_estoque)
                                                                                                   , p_cod_unidade_conversao  => m.unidade_estoque)
                                       )
                                    from almoxarifado.v$movimentacao mov
                                    where mov.material_id = m.material_id
                                       and mov.pedido_item_id = pi.pedido_item_id
                                       and mov.data_cancelamento is null
                              ),0)
                              +
                              (select nvl(sum(pic.quantidade), 0)
                                 from compras.v$pedido_item_cancelamento pic
                                 where pic.pedido_item_id = pi.pedido_item_id)
                            )))
                       from compras.v$pedido_item pi
                      inner join compras.v$cotacao c
                         on c.cotacao_id = pi.cotacao_id
                      inner join compras.v$solicitacao_item sit
                         on sit.solicitacao_item_id = c.solicitacao_item_id
                        and sit.tipo_item = 1
                      inner join compras.v$solicitacao s
                         on s.solicitacao_id = sit.solicitacao_id
                      inner join almoxarifado.v$material_dados m
                         on m.material_id = c.material_id
                      where pi.pedido_id = p.pedido_id
                        and s.controle_estoque = 1
                        and s.equipamento_id is null
                  ) > 0
            </cfif>
            order by p.data_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna dados do pedido
    -- GUTO 02/02/2010 - CRIADO
    --->
    <cffunction name="get_pedido_material" access="remote" returntype="query" output="true">
        <cfargument name="pedido_id" required="no" default="">
        <cfargument name="pedido_nf_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pi.pedido_item_id
            	 , m.material_id
                 , pi.pedido_id
            	 , coalesce(m.cod_genuino, m.cod_fabricante, m.cod_paralelo, m.cod_material, to_char(m.material_id))  as codigo
                 , m.descricao_completa
                 , c.quantidade
                 , to_char(round(c.valor_negociado /
				                 fiscal.pkg_fiscal.fnc_converte_peso(p_peso                   =>  c.quantidade,
								                                     p_cod_unidade_referencia => nvl(c.cod_unidade,m.unidade_estoque),
																	 p_cod_unidade_conversao  => m.unidade_estoque)
								,4)
					      ,'FM999G999G990D00','nls_numeric_characters='',.''') as valor_unitario
                 , to_char(round(c.valor_negociado,2),'FM999G999G990D00','nls_numeric_characters='',.''') as valor_negociado
                 , to_char(sum(round(c.valor_negociado,2)) over(),'FM999G999G990D00','nls_numeric_characters='',.''') as valor_total
                 , nvl((select sum( mov.quantidade / fiscal.pkg_fiscal.fnc_converte_peso(p_peso                   => 1
				                                                                       , p_cod_unidade_referencia => nvl(c.cod_unidade, m.unidade_estoque)
				                                                                       , p_cod_unidade_conversao  => m.unidade_estoque)
				                       )
				          from almoxarifado.v$movimentacao mov
				         where mov.material_id = m.material_id
				           and mov.pedido_item_id = pi.pedido_item_id
				           and mov.data_cancelamento is null
                       ),0) as qtde_recebida_outros_ped
			     , (select nvl(sum(pic.quantidade), 0)
                      from compras.v$pedido_item_cancelamento pic
                     where pic.pedido_item_id = pi.pedido_item_id) as qtde_cancelada
                 , m.identificado
                 , (select ma.valor_padrao
                      from almoxarifado.v$material_atributo ma
                     where ma.atributo_id = 12
                       and ma.material_id = m.material_id) as localizacao
			     , (select max(s.organizacional_id)
			          from compras.v$cotacao c
			         inner join compras.v$solicitacao_item sm
			            on sm.solicitacao_item_id = c.solicitacao_item_id
			         inner join compras.v$solicitacao s
			            on s.solicitacao_id = sm.solicitacao_id
			         where c.cotacao_id = pi.cotacao_id) as organizacional_id
                 <cfif len(trim(arguments.pedido_nf_id)) >
                 , (select nvl(sum(quantidade),0)
                      from compras.v$pedido_nf_item pni
                     where pni.material_id = m.material_id

                       and pni.pedido_nf_id = #arguments.pedido_nf_id#
                     ) as quantidade_recebida
                 <cfelse>
                 , 0 as quantidade_recebida
                 </cfif>
                 <cfif len(trim(arguments.pedido_nf_id)) >
                 , (select item_id
                      from compras.v$pedido_nf_item pni
                     where pni.pedido_nf_id = #arguments.pedido_nf_id#
                       and pni.material_id = m.material_id) as item_id
                 <cfelse>
                 , '' as item_id
                 </cfif>
                 <cfif len(trim(arguments.pedido_nf_id)) >
                 ,(select count(*)
                     from compras.v$pedido_nf_item pni
                    where pni.pedido_nf_id = #arguments.pedido_nf_id#
                      and m.material_id = pni.material_id) as material_nf
                 <cfelse>
				 , 0 as material_nf
                 </cfif>
              from compras.v$pedido_item pi
              inner join compras.v$cotacao c
                      on c.cotacao_id = pi.cotacao_id
	          inner join compras.v$solicitacao_item sm
	                  on sm.solicitacao_item_id = c.solicitacao_item_id
                     and sm.tipo_item = 1
	          inner join compras.v$solicitacao s
	                  on sm.solicitacao_id = s.solicitacao_id
			  inner join almoxarifado.v$material_dados m
                      on m.material_id = c.material_id
            where pi.pedido_id = #arguments.pedido_id#
			  and s.controle_estoque = 1
			  and s.equipamento_id is null
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna dados do pedigo
    -- GUTO 02/02/2010 - CRIADO
    --->
    <cffunction name="get_pedido_atividade" access="remote" returntype="query" output="true">
        <cfargument name="pedido_id" required="no" default="">
        <cfargument name="pedido_nf_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.descricao as titulo
            	 , coalesce(m.cod_genuino, m.cod_fabricante, m.cod_paralelo, m.cod_material, to_char(m.material_id))  as cod_atividade
            	 , m.material_id as atividade_id
                 , pi.pedido_id
            	 , c.quantidade
                 , to_char(round(c.valor_negociado/c.quantidade,4),'FM999G999G990D00','nls_numeric_characters='',.''') as valor_unitario
                 , to_char(round(c.valor_negociado,2),'FM999G999G990D00','nls_numeric_characters='',.''') as valor_negociado
                 , to_char(sum(round(c.valor_negociado,2)) over(),'FM999G999G990D00','nls_numeric_characters='',.''') as valor_total
                 , nvl((select sum(quantidade)
                      from compras.v$pedido_nf_item pni
                     where pni.pedido_id = pi.pedido_id
                       and pni.material_id = m.material_id
                       <cfif len(trim(arguments.pedido_nf_id)) >
                       and pni.pedido_nf_id <> #arguments.pedido_nf_id#
                       </cfif>
                       ),0) as qtde_recebida_outros_ped
                 <cfif len(trim(arguments.pedido_nf_id)) >
                 , (select nvl(sum(quantidade),0)
                      from compras.v$pedido_nf_item pni
                     where pni.material_id = m.material_id
                       and pni.pedido_nf_id = #arguments.pedido_nf_id#
                     ) as quantidade_recebida
                 <cfelse>
                 , 0 as quantidade_recebida
                 </cfif>
                 <cfif len(trim(arguments.pedido_nf_id)) >
                 , (select item_id
                      from compras.v$pedido_nf_item pni
                     where pni.pedido_nf_id = #arguments.pedido_nf_id#
                       and pni.material_id = m.material_id) as item_id
                 <cfelse>
                 , '' as item_id
                 </cfif>
                 <cfif len(trim(arguments.pedido_nf_id)) >
                 , (select count(*)
                      from compras.v$pedido_nf_item pni
                     where pni.pedido_nf_id = #arguments.pedido_nf_id#
                       and pni.material_id = m.material_id) as atividade_nf
                 <cfelse>
                 , 0 as atividade_nf
                 </cfif>
              from compras.v$pedido_item pi
             inner join compras.v$cotacao c
                on c.cotacao_id = pi.cotacao_id
               and c.tipo_item = 2
             inner join almoxarifado.v$material m
                on m.material_id = c.material_id
            where pi.pedido_id = #arguments.pedido_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Consulta as informações de últimas compras de um determinado material
    -- GUSTAVOC - CRIADO 23/11/2010
    --->
    <cffunction name="get_informacoes_compra_material" access="remote" returntype="query" output="true">
    	<cfargument name="MATERIAL_ID" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.material_id
                 , kss.pkg_pessoa.fnc_get_identificador(p.cod_pessoa_fornecedor) as cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(p.cod_pessoa_fornecedor) as fornecedor
                 , p.data_pedido
                 , ct.valor_unitario
                 , nvl(almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, '102'), '-') as target
                 , m.cod_genuino
                 , m.cod_fabricante
                 , m.cod_paralelo
              from compras.v$pedido p
             inner join compras.v$pedido_item pi
                on pi.pedido_id = p.pedido_id
             inner join compras.v$cotacao ct
                on ct.cotacao_id = pi.cotacao_id
             inner join almoxarifado.v$material_dados m
                on m.material_id = ct.material_id
             where 1 = 1
             <cfif Len(Trim(arguments.MATERIAL_ID))>
               and ct.material_id = #arguments.MATERIAL_ID#
             <cfelse>
               and ct.material_id = -999999
             </cfif>
             order by p.data_pedido desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Consulta as informações de últimas compras de uma determinada atividade
    -- RAFAEL - CRIADO 20/05/2013
    --->
    <cffunction name="get_informacoes_compra_atividade" access="remote" returntype="query" output="true">
    	<cfargument name="ATIVIDADE_ID" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.pkg_pessoa.fnc_get_identificador(p.cod_pessoa_fornecedor) as cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(p.cod_pessoa_fornecedor) as fornecedor
                 , p.data_entrega
                 , ct.valor_unitario
                 , ct.quantidade
              from compras.v$pedido p
             inner join compras.v$pedido_item pi
                on pi.pedido_id = p.pedido_id
             inner join compras.v$cotacao ct
                on ct.cotacao_id = pi.cotacao_id
             where ct.material_id = (select ma.material_id
                                       from almoxarifado.v$material_atividade ma
                                      where ma.atividade_id = #arguments.ATIVIDADE_ID#
                                    )
             order by p.data_entrega desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna dados do pedigo
    -- GUTO 02/02/2010 - CRIADO
    --->
    <cffunction name="get_pedido_nota_fiscal" access="remote" returntype="query" output="true">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="pedido_nf_id" required="no" default="">
        <cfargument name="not_item_id" required="no" default="">
        <cfargument name="PED_ITENS_PENDENTES" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pedido_nf_id,
                   num_nota_fiscal,
                   modelo,
                   serie,
                   subserie,
                   to_char(data_emissao,'dd/mm/yyyy') as data_emissao,
                   to_char(data_entrada,'dd/mm/yyyy') as data_entrada,
                   (select kss.fnc_concat_all(kss.to_concat_expr( t.num_pedido, '/'))
                      from (select distinct num_pedido, pedido_nf_id
                              from compras.v$pedido p
                             inner join compras.v$pedido_nf_item pni
                                on p.pedido_id = pni.pedido_id) t
                     where t.pedido_nf_id = pn.pedido_nf_id ) as pedidos,
                   cod_gestao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from compras.v$pedido_nf pn
			 where 1=1
             <cfif len(trim(arguments.num_nota_fiscal)) >
             	and num_nota_fiscal = '#arguments.num_nota_fiscal#'
             </cfif>
             <cfif len(trim(arguments.data_inicio)) >
             	and data_entrada >= '#arguments.data_inicio#'
             </cfif>
             <cfif len(trim(arguments.data_fim)) >
             	and data_entrada <= '#arguments.data_fim#'
             </cfif>
             <cfif len(trim(arguments.num_pedido)) >
             	and exists (select 'x'
                             from compras.v$pedido_nf_item pn2
                            inner join compras.v$pedido p2
                               on pn2.pedido_id = p2.pedido_id
                           where p2.num_pedido = #arguments.num_pedido#
                             and pn2.pedido_nf_id = pn.pedido_nf_id)
             </cfif>
             <cfif len(trim(arguments.pedido_nf_id)) >
             	and pn.pedido_nf_id = #arguments.pedido_nf_id#
             </cfif>
             <cfif len(trim(arguments.not_item_id)) >
             	and item_id in (#arguments.not_item_id#)
             </cfif>
             <cfif len(trim(arguments.PED_ITENS_PENDENTES)) >
             	and pn.pedido_nf_id in (select pni.pedido_nf_id
                                          from compras.v$pedido_nf_item pni
                                         where compras.pkg_compras.fnc_saldo_remanescente(pni.pedido_id) > 0
                                           and (select sum(quantidade)
                                                  from compras.v$pedido_nf_item pni2
                                                 where pni2.pedido_nf_id = pni.pedido_nf_id) > 0
                                           and pni.pedido_nf_id = pn.pedido_nf_id)
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna dados dos itens do pedido
    -- WAGNERS 11/07/2012 - CRIADO
    --->
    <cffunction name="get_pedido_nf_item" access="remote" returntype="query" output="true">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="pedido_nf_id" required="no" default="">
        <cfargument name="not_item_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select item_id,
                   pedido_nf_id,
                   material_id,
                   atividade_id,
                   quantidade,
                   pedido_id,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from compras.v$pedido_nf_item pni
			 where 1=1
             <cfif len(trim(arguments.pedido_nf_id)) >
             	and pni.pedido_nf_id = #arguments.pedido_nf_id#
             </cfif>
             <cfif len(trim(arguments.not_item_id)) >
             	and pni.item_id not in (#arguments.not_item_id#)
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna dados dos itens do pedido
    -- WAGNERS 11/07/2012 - CRIADO
    --->
    <cffunction name="get_orcamento" access="remote" returntype="query" output="true">
        <cfargument name="orcamento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select orcamento_id,
                   num_orcamento,
                   titulo,
                   data_criacao,
                   data_fechamento,
                   situacao_id,
                   forma_pagto_id,
                   prazo_entrega_id,
                   user_insert,
                   date_insert,
                   user_update,
                   date_update,
                   site,
                   tipo_cotacao_id,
                   tipo_aprovacao_id,
                   observacao
              from compras.v$orcamento o
			 where 1=1
             <cfif len(trim(arguments.orcamento_id)) >
             	and o.orcamento_id = #arguments.orcamento_id#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
        -- PROPÓSITO
        -- Retorna dados dos itens do pedido
        -- WAGNERS 11/07/2012 - CRIADO
        --->
        <cffunction name="get_solicitacoes_orcamento" access="remote" returntype="query" output="true">
            <cfargument name="orcamento_id" required="yes" default="">
            <cfargument name="situacao_id" required="yes" default="">
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select distinct s.solicitacao_id
                  from compras.v$solicitacao s
                 inner join compras.v$solicitacao_orcamento_det det
                    on det.solicitacao_id = s.solicitacao_id
                 where det.orcamento_id = #arguments.orcamento_id# 
                 <cfif len(trim(arguments.situacao_id)) >
                    and s.situacao_id = #arguments.situacao_id#
                 </cfif>
            </cfquery>
            <cfreturn qr_result>
        </cffunction>

	<!---
    -- PROPÓSITO
    -- Retorna as solicitações de compras de acordo com o filtro selecionado
    -- ANDERSON 04/12/2009 - CRIADO
    --->
    <cffunction name="get_solicitacoes_compras" access="remote" returntype="query" output="true">
    	<cfargument name="num_controle" required="no" default="">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.solicitacao_id, s.num_controle, s.titulo, o.cod_pessoa as cod_pessoa_filial,
            	   to_char(s.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao,
                   to_char(s.data_emissao + sp.numero_horas/24,'dd/mm/yyyy hh24:mi') as data_previsao,
                   case
                      -- ainda não tem cotação
                      when s.situacao_id < 4 then
                         case
                            when s.data_emissao + sp.numero_horas/24 > sysdate then 'Dentro do Prazo'
                            else 'Atrasada'
                         end
                      -- rejeitada
                      when s.situacao_id = 7 then ''
                      -- cotado
                      else
                         case
                            when s.data_emissao + sp.numero_horas/24 > nvl(compras.pkg_compras.fnc_max_data_cotacao(s.solicitacao_id), sysdate) then 'Dentro do Prazo'
                            else 'Atrasada'
                         end
                   end status_previsao
                   ,oper.pkg_global.fnc_get_cod_funcionario(s.cod_pessoa_emissao) as cod_funcionario
                   ,kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as nome_funcionario,
                   s.situacao_id, sp.descricao as prioridade,
                   s.situacao_id ||' - '||sit.rv_abbreviation as desc_situacao,
                   sit.rv_abbreviation as situacao,
                   a.descricao as area,
                   (select count(*)
                      from compras.v$solicitacao_item sm
                     where sm.solicitacao_id = s.solicitacao_id)  as qtde_itens,
                   (select count(*)
                      from compras.v$solicitacao_item sm
                     inner join compras.v$cotacao co
                             on co.solicitacao_item_id = sm.solicitacao_item_id
                     where sm.solicitacao_id = s.solicitacao_id)  as qtde_itens_cotados,
                   s.user_insert,
                   to_char(s.date_insert,'dd/mm/yyyy hh24:mi') as date_insert,
                   s.user_update,
                   to_char(s.date_update,'dd/mm/yyyy hh24:mi') as date_update,
                   (select us.nome
                      from kss.v$usuarios us
                     where us.usuario = s.user_insert) as proprietario_insert,
                   (select us.nome
                      from kss.v$usuarios us
                     where us.usuario = s.user_update) as proprietario_update,
                   (select un.unidade_negocio
                     from kss.v$unidade_negocio un
                    where un.cod_unidade_negocio = org.cod_unidade_negocio) as unidade_negocio,
                   (select dp.descricao
                      from kss.v$departamento dp
                     where dp.cod_departamento = org.cod_departamento) as departamento,
                   (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = org.cod_setor) as setor,
                   (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = org.cod_centro_custo) as centro_custo,
                    compras.pkg_compras.fnc_get_pedido_solicitacao(s.solicitacao_id) as num_pedido,
                   p.identificador as cnpj_fornecedor,
                   p.razao_social as fornecedor,
                   nvl((select sum(ct.valor_negociado)
                                  from compras.v$solicitacao_item sm
                                  inner join compras.v$cotacao ct
                                     on ct.solicitacao_item_id = sm.solicitacao_item_id
                                   and ct.aprovada = 1
                          where sm.solicitacao_id = s.solicitacao_id),0)  as valor_solicitacao,
                     compras.pkg_compras.fnc_solicitacao_valor_minimo(s.solicitacao_id) as valor_minimo,
                    e.cod_equipamento, e.cod_equipamento as equipamento,
                    e.placa,
                    compras.pkg_compras.fnc_get_usuario_ocorrencia(s.solicitacao_id
                                                                 , kss.pkg_global.fnc_parametro_num(11,'OPERACIONAL',33,419)) as usuario_aprovacao,
                    kss.to_tempo((sysdate - s.date_insert) *24*60).retorno as tempo_tramite,
                    (sysdate - s.date_insert) *24*60 tempo_tramite_minutos,
                    (select count(*)
                       from compras.v$solicitacao_ocorrencia so
                      where so.solicitacao_id = s.solicitacao_id) as qtde_ocorrencias ,
                    (select o.cod_organizacional || ' - ' || o.descricao
                        from kss.v$organizacional o
                       where o.organizacional_id = s.organizacional_id) as organizacional,
                     s.num_romaneio
              from compras.v$solicitacao s
             inner join compras.v$solicitacao_prioridade sp
                     on sp.prioridade_id = s.prioridade_id
             inner join compras.v$area a
                     on a.area_id = s.area_id
             inner join kss.v$organograma o
                     on o.cod_organograma = s.cod_organograma
             inner join compras.v$cg_ref_codes sit
                     on sit.rv_domain = 'SOLICITACAO SITUACAO'
                    and sit.rv_low_value = s.situacao_id
             inner join kss.v$organograma org
                     on org.cod_organograma = s.cod_organograma
             left join almoxarifado.v$equipamento e
                     on e.equipamento_id = s.equipamento_id
              left join kss.v$pessoa p
                     on p.cod_pessoa = s.cod_pessoa_fornecedor
             where 1 = 1
            <cfif Len(Trim(arguments.num_controle))>
               and s.num_controle = #arguments.num_controle#
            <cfelseif Len(Trim(arguments.num_pedido))>
               and s.solicitacao_id in (select spd.solicitacao_id
                                          from compras.v$pedido p
                                         inner join compras.v$solicitacao_pedido_det spd 
                                            on spd.pedido_id = p.pedido_id
                                         where p.num_pedido = #arguments.num_pedido#
                                        )
            <cfelse>
				<cfif Len(Trim(arguments.data_inicio))>
					and s.data_emissao >= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
                <cfif Len(Trim(arguments.data_fim))>
					and s.data_emissao <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
                <cfif Len(Trim(arguments.equipamento_id))>
					and s.equipamento_id = #arguments.equipamento_id#
                </cfif>
                <cfif Len(Trim(arguments.cod_pessoa_fornecedor))>
					and s.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                </cfif>
                <cfif Len(Trim(arguments.area_id))>
					and s.area_id = #arguments.area_id#
                </cfif>
                <cfif Len(Trim(arguments.cod_pessoa_filial))>
					and o.cod_pessoa = #arguments.cod_pessoa_filial#
                </cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
					and o.cod_centro_custo = #arguments.cod_centro_custo#
                </cfif>
                <cfif Len(Trim(arguments.situacao_id))>
					and s.situacao_id in (#arguments.situacao_id#)
                </cfif>
			</cfif>
            order by s.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna as ocorrências de uma solicitação de compra
    -- ANDERSON 17/12/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_ocorrencias" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select ot.titulo
                      from compras.v$ocorrencia_tipo ot
                     where ot.ocorrencia_id = o.tipo_id) as tipo
                 , o.comentario
              from compras.v$solicitacao_ocorrencia so
             inner join compras.v$ocorrencia o
                     on o.ocorrencia_id = so.ocorrencia_id
             where so.solicitacao_id = #arguments.solicitacao_id#
             order by o.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os itens de uma solicitação de compra
    -- ANDERSON 04/12/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_itens" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as descricao_item
                 , sm.descricao
                 , sm.cod_unidade
                 , sm.quantidade
                 , sm.compra_liberada
                 , sm.valor_sugerido
                 , sm.quantidade * nvl(sm.valor_sugerido, 0) as valor_total
              from compras.v$solicitacao_item sm
             where sm.solicitacao_id = #arguments.solicitacao_id#

        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os itens cotados de uma solicitação de compra
    -- ANDERSON 04/12/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_itens_cotados" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select compras.pkg_compras.fnc_tipo_item_compra(p_tipo_item =>  sm.tipo_item) as tipo
                 , ct.num_cotacao
                 , ct.cotacao_id
                 , (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id ) as descricao
                 , sm.cod_unidade
                 , sm.quantidade
                 , ct.valor_negociado / sm.quantidade as valor_unitario
                 , ct.valor_negociado
                 , ct.aprovada
                 , kss.pkg_pessoa.fnc_get_identificador(ct.cod_pessoa_fornecedor) as cnpj_cpf_fornecedor
                 , (select p.razao_social
                     from kss.v$pessoa p
                    where p.cod_pessoa = ct.cod_pessoa_fornecedor) as fornecedor
                 , (select ff.forma_descricao
                     from kss.v$faturamento_forma ff
                    where ff.forma_id = ct.forma_pagto_id) as forma_pagamento
                 , (select pe.descricao
                      from compras.v$prazo_entrega pe
                     where pe.prazo_entrega_id = ct.prazo_entrega_id) as prazo_entrega
              from compras.v$solicitacao_item sm
             inner join compras.v$cotacao ct
                on ct.solicitacao_item_id = sm.solicitacao_item_id
             where sm.solicitacao_id = #arguments.solicitacao_id#

             order by cnpj_cpf_fornecedor, tipo, descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna se um fornecedor possui tabela de preço fixo
    -- ANDERSON 28/01/2010 - CRIADO
    --->
    <cffunction name="get_fornecedor_tabela_preco_fixo" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_fornecedor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select sign(count(*)) as possui_tabela
              from compras.v$tabela_preco_fixo tpf
             where tpf.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Retorna a tabela de preço fixo de um fornecedor
    -- ANDERSON 09/06/2010 - CRIADO
    --->
    <cffunction name="get_tabela_preco_fixo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_fornecedor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tpf.tabela_id
                 , tpf.cod_tabela
                 , tpf.cod_pessoa_fornecedor
                 , tpf.titulo
                 , to_char(tpf.data_vigencia, 'dd/mm/yyyy') as data_vigencia
                 , tpf.observacao
                 , tpf.aprovada
                 , to_char(tpf.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , tpf.ativa
                 , to_char(tpf.data_inativacao, 'dd/mm/yyyy hh24:mi:ss') as data_inativacao
              from compras.v$tabela_preco_fixo tpf
             where tpf.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
               and tpf.aprovada = 1
               and tpf.ativa = 1
               and tpf.data_vigencia = (select min(tpf2.data_vigencia)
                                          from compras.v$tabela_preco_fixo tpf2
                                         where tpf2.cod_pessoa_fornecedor = tpf.cod_pessoa_fornecedor
                                           and tpf2.aprovada = 1
                                           and tpf2.ativa = 1
                                           and tpf2.data_vigencia >= sysdate
                                        )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Verifica se uma lista de materiais pertence a uma tabela
    -- ANDERSON 11/06/2010 - CRIADO
    --->
    <cffunction name="get_verificacao_tabela_materiais" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
        <cfargument name="material_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.column_value as material_id
                 , x.valor
              from table(kss.pkg_string.fnc_split('#arguments.material_id#', ';')) t
              left join (select tpm.material_id
                              , tpm.valor
                           from compras.v$tabela_preco_material tpm
                          where tpm.tabela_id = #arguments.tabela_id#
                            and tpm.data_vigencia >= sysdate
                        ) x
                     on x.material_id = t.column_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Verifica se uma lista de atividades pertence a uma tabela
    -- ANDERSON 11/06/2010 - CRIADO
    --->
    <cffunction name="get_verificacao_tabela_atividades" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
        <cfargument name="atividade_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.column_value as atividade_id
                 , x.valor
              from table(kss.pkg_string.fnc_split('#arguments.atividade_id#', ';')) t
              left join (select tpa.atividade_id
                              , tpa.valor
                           from compras.v$tabela_preco_atividade tpa
                          where tpa.tabela_id = #arguments.tabela_id#
                            and tpa.data_vigencia >= sysdate
                        ) x
                     on x.atividade_id = t.column_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Retorna os pedidos de acordo com o filtro selecionado
    -- ANDERSON 08/02/2010 - CRIADO
    --->
    <cffunction name="get_pedidos" access="remote" returntype="query" output="true">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pedido_id
                 , compras.pkg_compras.fnc_get_pedido_placa(p.pedido_id) as placa
                 , p.num_pedido
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , to_char(nvl(p.data_vencimento, p.data_pedido + 35), 'dd/mm/yyyy') as data_vencimento
                 , p.valor_material
                 , p.valor_atividade
                 , p.valor_total_pedido
                 , kss.fnc_ref_code('COMPRAS', 'PEDIDO SITUACAO', p.situacao_id, 0) as situacao
                 , (select ff.forma_descricao
                      from kss.v$faturamento_forma ff
                     where ff.forma_id = p.forma_pagto_id) as forma_pagamento
                 , (select pe.descricao
                      from compras.v$prazo_entrega pe
                     where pe.prazo_entrega_id = p.prazo_entrega_id) as prazo_entrega
                 , to_char(p.data_entrega, 'dd/mm/yyyy') as data_entrega
                 , p.local_entrega
                 , p.observacoes
                 , (select distinct nf.num_nota_fiscal
             			from fiscal.v$nf_terceiro_pedido_item nfpi
            				inner join fiscal.v$nf_terceiro nf
			                    on nf.num_nota_id = nfpi.num_nota_id
            			where nfpi.pedido_id = p.pedido_id) as num_nota_fiscal
                 , p.autenticacao
              from compras.v$pedido p
             where p.cod_pessoa_fornecedor = (select u.cod_pessoa
                                                from kss.v$usuarios u
                                               where u.usuario = user)
			<cfif Len(Trim(arguments.num_pedido))>
               and p.num_pedido = #arguments.num_pedido#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and p.data_pedido >= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and p.data_pedido <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
             order by p.num_pedido asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os tipos de compra
    -- ANDERSON 13/02/2010 - CRIADO
    --->
    <cffunction name="get_tipo_compra" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select tp.tipo_compra_id
                 , tp.descricao
              from compras.v$tipo_compra tp
             order by tp.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna resumo de valor por área
    -- GUTO 19/03/2010 - CRIADO
    --->
    <cffunction name="get_resumo_areas" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="agrupar_filiais" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.area_id, area <cfif arguments.agrupar_filiais eq 0>,p.cod_pessoa as cod_pessoa_filial, p.cliente as filial<cfelse>,'' as cod_pessoa_filial, 'Todas as Filiais' as filial</cfif>
                   ,sum(valor_nf_lancada) as valor_nf_lancada
                   ,sum(valor_nf_nao_lancada) as valor_nf_nao_lancada
                   ,sum(valor_aprovada) as valor_aprovada
              from (
            select a.area_id, a.descricao as area<cfif arguments.agrupar_filiais eq 0>,y.cod_organograma</cfif>
                   ,case
                     when ar.column_value = 'NF Lançada' then nvl(y.valor, 0)
                   else 0 end valor_nf_lancada
                   ,case
                     when ar.column_value = 'NF não Lançada' then nvl(y.valor, 0)
                   else 0 end valor_nf_nao_lancada
                   ,case
                     when ar.column_value = 'Aprovadas' then nvl(y.valor, 0)
                   else 0 end valor_aprovada
            from compras.v$area a
            natural join table(kss.pkg_string.fnc_split('NF Lançada,NF não Lançada,Aprovadas',',')) ar
              left  join (select 'NF Lançada' as tipo, x.area_id, round(sum(x.valor_total),2) as valor
              					 <cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
                      from (select s.area_id
                              ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                              <cfif arguments.agrupar_filiais eq 0>,s.cod_organograma</cfif>
                              , nvl((select sum(valor)
                                   from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                           from compras.v$solicitacao_material sm
                                           inner join compras.v$orcamento_material_solic oms
                                                   on oms.solicitacao_material_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_material_id = oms.orcamento_material_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id
                                          union all
                                          select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                            from compras.v$solicitacao_atividade sm
                                           inner join compras.v$orcamento_atividade_solic oms
                                                   on oms.solicitacao_atividade_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id)
                                          where solicitacao_id = s.solicitacao_id),0) as valor_total
                      from compras.v$solicitacao s
                      inner join kss.v$organograma o
                              on o.cod_organograma = s.cod_organograma
                      where 1 = 1
                        <cfif Len(Trim(arguments.AREA_ID))>
                           and s.area_id in (#arguments.AREA_ID#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
                           and o.cod_pessoa in (#arguments.COD_PESSOA_FILIAL#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                           and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_INICIAL))>
                           and trunc(s.data_emissao) >= '#arguments.DATA_INICIAL#'
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_FINAL))>
                           and trunc(s.data_emissao) <= '#arguments.DATA_FINAL#'
                        </cfif>
                        ) x
                      where x.pedido_nf is not null
                    group by x.area_id<cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>

                    union all

                    select 'NF não Lançada' as tipo, x.area_id, round(sum(x.valor_total),2) as valor
                    	   <cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
                      from (select s.area_id
                              ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                              <cfif arguments.agrupar_filiais eq 0>,s.cod_organograma</cfif>
                              , nvl((select sum(valor)
                                   from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                           from compras.v$solicitacao_material sm
                                           inner join compras.v$orcamento_material_solic oms
                                                   on oms.solicitacao_material_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_material_id = oms.orcamento_material_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id
                                          union all
                                          select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                            from compras.v$solicitacao_atividade sm
                                           inner join compras.v$orcamento_atividade_solic oms
                                                   on oms.solicitacao_atividade_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id)
                                          where solicitacao_id = s.solicitacao_id),0) as valor_total
                      from compras.v$solicitacao s
                      inner join kss.v$organograma o
                              on o.cod_organograma = s.cod_organograma
                      where 1 = 1
                        <cfif Len(Trim(arguments.AREA_ID))>
                           and s.area_id in (#arguments.AREA_ID#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
                           and o.cod_pessoa in (#arguments.COD_PESSOA_FILIAL#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                           and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_INICIAL))>
                           and trunc(s.data_emissao) >= '#arguments.DATA_INICIAL#'
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_FINAL))>
                           and trunc(s.data_emissao) <= '#arguments.DATA_FINAL#'
                        </cfif>
                        and s.situacao_id in (10,6)) x
                      where x.pedido_nf is null
                    group by x.area_id<cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>

                    union all

                    select 'Aprovadas' as tipo, x.area_id, round(sum(x.valor_total),2) as valor
                    	   <cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
                      from (select s.area_id
                              ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                              <cfif arguments.agrupar_filiais eq 0>,s.cod_organograma</cfif>
                              , nvl((select sum(valor)
                                   from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                           from compras.v$solicitacao_material sm
                                           inner join compras.v$orcamento_material_solic oms
                                                   on oms.solicitacao_material_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_material_id = oms.orcamento_material_id
                                                  and c.aprovada = 1
                                          group by sm.solicitacao_id
                                          union all
                                          select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                            from compras.v$solicitacao_atividade sm
                                           inner join compras.v$orcamento_atividade_solic oms
                                                   on oms.solicitacao_atividade_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                                  and c.aprovada = 1
                                          group by sm.solicitacao_id)
                                          where solicitacao_id = s.solicitacao_id),0) as valor_total
                      from compras.v$solicitacao s
                      inner join kss.v$organograma o
                              on o.cod_organograma = s.cod_organograma
                      where 1 = 1
                        <cfif Len(Trim(arguments.AREA_ID))>
                           and s.area_id in (#arguments.AREA_ID#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
                           and o.cod_pessoa in (#arguments.COD_PESSOA_FILIAL#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                           and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_INICIAL))>
                           and trunc(s.data_emissao) >= '#arguments.DATA_INICIAL#'
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_FINAL))>
                           and trunc(s.data_emissao) <= '#arguments.DATA_FINAL#'
                        </cfif>
                        and s.situacao_id in (5)) x
                    group by x.area_id<cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>) y
               on y.area_id = a.area_id
              and y.tipo = ar.column_value
            order by a.descricao) t
              <cfif arguments.agrupar_filiais eq 0>
              inner join kss.v$organograma o
                      on o.cod_organograma = t.cod_organograma
              inner join kss.v$pessoa p
                      on p.cod_pessoa = o.cod_pessoa
              </cfif>
			<cfif Len(Trim(arguments.AREA_ID))>
               where t.area_id in (#arguments.AREA_ID#)
            </cfif>
            group by t.area_id, area<cfif arguments.agrupar_filiais eq 0>,p.cliente, p.cod_pessoa</cfif>
            order by filial, cod_pessoa_filial,area
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna resumo de valor por área
    -- GUTO 19/03/2010 - CRIADO
    --->
    <cffunction name="get_detalhamento_area" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="com_nota" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select *
              from (
            select s.solicitacao_id
                 , s.num_controle
                 , s.titulo
                 , to_char(s.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao
                 , s.cod_organograma
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where o.cod_unidade_negocio = un.cod_unidade_negocio) as unidade_negocio
                 , (select pf.nome
                      from kss.v$pessoa_fisica pf
                     where pf.cod_pessoa = s.cod_pessoa_emissao) as nome_funcionario
                 , e.cod_equipamento as equipamento
                 , e.placa as placa
                 , sit.rv_abbreviation as situacao
                 , sp.descricao as prioridade
                 , a.descricao as area
                 , p.identificador as cnpj_fornecedor
                 , p.razao_social as fornecedor
                 , s.user_insert
                 , to_char(s.date_insert,'dd/mm/yyyy hh24:mi') as date_insert
                 , s.user_update
                 , s.date_update
                 , nvl((select sum(sm.quantidade * c.valor_unitario)
                           from compras.v$solicitacao_material sm
                           inner join compras.v$orcamento_material_solic oms
                                   on oms.solicitacao_material_id = sm.controle_id
                           inner join compras.v$cotacao c
                                   on c.orcamento_material_id = oms.orcamento_material_id
                           inner join compras.v$pedido_item pi
                                   on pi.cotacao_id = c.cotacao_id
                          where sm.solicitacao_id = s.solicitacao_id),0) as valor_material
                      , nvl((select sum(sm.quantidade * c.valor_unitario)
                           from compras.v$solicitacao_atividade sm
                           inner join compras.v$orcamento_atividade_solic oms
                                   on oms.solicitacao_atividade_id = sm.controle_id
                           inner join compras.v$cotacao c
                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                           inner join compras.v$pedido_item pi
                                   on pi.cotacao_id = c.cotacao_id
                          where sm.solicitacao_id = s.solicitacao_id),0) as valor_atividade
                      , nvl((select sum(valor)
                           from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                   from compras.v$solicitacao_material sm
                                   inner join compras.v$orcamento_material_solic oms
                                           on oms.solicitacao_material_id = sm.controle_id
                                   inner join compras.v$cotacao c
                                           on c.orcamento_material_id = oms.orcamento_material_id
                                   inner join compras.v$pedido_item pi
                                           on pi.cotacao_id = c.cotacao_id
                                  group by sm.solicitacao_id
                                  union all
                                  select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                    from compras.v$solicitacao_atividade sm
                                   inner join compras.v$orcamento_atividade_solic oms
                                           on oms.solicitacao_atividade_id = sm.controle_id
                                   inner join compras.v$cotacao c
                                           on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                   inner join compras.v$pedido_item pi
                                           on pi.cotacao_id = c.cotacao_id
                                  group by sm.solicitacao_id)
                                  where solicitacao_id = s.solicitacao_id),0) as valor_total
                 ,compras.pkg_compras.fnc_get_pedido_solicitacao(s.solicitacao_id) as pedidos
                 ,to_char(compras.pkg_compras.fnc_get_pedido_data(s.solicitacao_id),'dd/mm/yyyy') as pedido_data
                 ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                 ,to_char(compras.pkg_compras.fnc_get_pedido_data_nf(s.solicitacao_id),'dd/mm/yyyy') as pedido_nf_data
                 ,nvl((select sum(valor)
                         from (select sum(sm.quantidade * nvl(sm.valor_sugerido,0)) as valor, sm.solicitacao_id
                                 from compras.v$solicitacao_material sm
                                 group by sm.solicitacao_id
                               union all
                               select sum(sm.quantidade * nvl(sm.valor_sugerido,0))as valor, sm.solicitacao_id
                               from compras.v$solicitacao_atividade sm
                               group by sm.solicitacao_id)
                         where solicitacao_id = s.solicitacao_id),0) as valor_total_solicitacao
                 ,to_char(compras.pkg_compras.fnc_get_pedido_data_nf(s.solicitacao_id,1),'dd/mm/yyyy') as pedido_nf_emissao_data
                 ,compras.pkg_compras.fnc_get_solitacao_ped_forn(s.solicitacao_id) as pedido_fornecedor
                 ,(select cc.centro_custo
                     from kss.v$centro_custo cc
                    where o.cod_centro_custo = cc.cod_centro_custo) as centro_custo

              from compras.v$solicitacao s
             inner join kss.v$organograma o
                     on o.cod_organograma = s.cod_organograma
             inner join compras.v$cg_ref_codes sit
                     on sit.rv_low_value = s.situacao_id
                    and sit.rv_domain = 'SOLICITACAO SITUACAO'
             inner join compras.v$solicitacao_prioridade sp
                     on sp.prioridade_id = s.prioridade_id
              left join kss.v$pessoa p
                     on p.cod_pessoa = s.cod_pessoa_fornecedor
              left join almoxarifado.v$equipamento e
                     on e.equipamento_id = s.equipamento_id
              left join compras.v$area a
                     on a.area_id = s.area_id
              where 1 = 1
                <cfif Len(Trim(arguments.AREA_ID))>
	                and s.area_id in (#arguments.AREA_ID#)
                </cfif>
                <cfif Len(Trim(arguments.COD_PESSOA))>
                	and o.cod_pessoa in (#arguments.COD_PESSOA#)
                </cfif>
                <cfif Len(Trim(arguments.DATA_INICIAL))>
                   and s.data_emissao >= '#arguments.DATA_INICIAL#'
                </cfif>
                <cfif Len(Trim(arguments.DATA_FINAL))>
                   and s.data_emissao <= to_date('#arguments.DATA_FINAL# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                </cfif>
                <cfif Len(Trim(arguments.SITUACAO_ID))>
                   and s.situacao_id in (#arguments.SITUACAO_ID#)
                </cfif>)
                where 1=1
                <cfif Len(Trim(arguments.COM_NOTA)) and arguments.COM_NOTA eq 1>
                   and pedido_nf is not null
                <cfelseif Len(Trim(arguments.COM_NOTA)) and arguments.COM_NOTA eq 0>
                   and pedido_nf is null
                </cfif>
                order by data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Consulta parcelamento pedido
    -- LINCOLNS - CRIADO 29/03/2011
    --->
    <cffunction name="get_parcelamento_pedido" access="remote" returntype="query" output="true">
    	<cfargument name="pedido_id" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pp.valor
                 , pp.num_parcela
                 , to_char(pp.data_vencimento, 'dd/mm/yyyy') as data_vencimento
                 , p.tipo_parcelamento
                 , p.dia_vencimento
             from compras.v$parcelamento_pedido pp
            inner join compras.v$pedido p
		       on p.pedido_id = pp.pedido_id
            where 1 = 1
            <cfif Len(Trim(arguments.pedido_id))>
              and pp.pedido_id = #arguments.pedido_id#
            </cfif>
            order by pp.data_vencimento
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPÓSITO
    -- Consulta parcelamento pedido
    -- LINCOLNS - CRIADO 29/03/2011
    --->
    <cffunction name="get_dados_parcelamento" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select pt.valor
                , pt.num_parcela
                , to_char(pt.data_vencto, 'dd/mm/yyyy') as data_vencto
             from compras.parcelamento_temp pt
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPÓSITO
    -- Consulta parcelamento pedido
    -- LINCOLNS - CRIADO 29/03/2011
    --->
    <cffunction name="get_equipamento_ultima_tracao" access="remote" returntype="query" output="true">
    	<cfargument name="equipamento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.equipamento_id_tracao
                 , e.cod_equipamento
                 , ma.material as material_equipamento_custo
              from (select compras.pkg_compras.fnc_get_equipamento_ult_tracao(#arguments.equipamento_id#) as equipamento_id_tracao
                      from dual) t
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = t.equipamento_id_tracao
             inner join almoxarifado.v$material_dados ma
                on ma.material_id = e.material_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- FUNÇÕES ESPECÍFICAS DO MÓDULO GERENCIAL
    --->
	<!---
    -- PROPÓSITO
    -- Retorna os números de tempo de aprovação das solicitações
    -- LEANDRO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_tempo_aprovacao_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APROV_SOLC_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APROV_SOLC_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APROV_SOLC_META') as meta
                 , x.qtde_dentro_prazo
                 , x.qtde_total
                 , case
          			   when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                       else 0
                   end percentual
              from (
                    select count(*) as qtde_total
                         , count(case
                                    when t.tempo_para_liberacao <= 719 then 1
                                    else null
                                 end
                                ) as qtde_dentro_prazo
                      from (
                            select round((sd.data_liberacao_compra-sd.data_emissao)*1440) as tempo_para_liberacao
                              from compras.v$solicitacao_datas sd
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sd.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                             where sd.data_pedido is not null
                               and sd.data_aprovacao is not null
                               and sd.data_pedido > sd.data_aprovacao
                               and sd.data_liberado_aprovacao > sd.data_orcamento
                               and sd.data_aprovacao > sd.data_liberado_aprovacao
                               and sd.data_orcamento > sd.data_liberacao_compra
                               and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
           					<cfif Len(Trim(arguments.cod_centro_custo))>
                                  and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                            </cfif>
                           ) t
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    	<!---
    -- PROPÓSITO
    -- Retorna os números de tempo de solicitação em orçamento
    -- LEANDRO 01/07/2010 - CRIADO
    --->
    <cffunction name="get_tempo_solicitacao_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_SOLIC_ORC_VERDE') as faixa_verde
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_SOLIC_ORC_AMARELO') as faixa_amarela
                 , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_SOLIC_ORC_META') as meta
                 , x.qtde_dentro_prazo
                 , x.qtde_total
                 , case
                      when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                       else 0
                   end percentual
              from (
                    select count(*) as qtde_total
                         , count(case
                                    when t.tempo_para_liberada_aprovacao <= 719 then 1
                                    else null
                                 end
                                ) as qtde_dentro_prazo
                      from (
                            select round((sd.data_orcamento-sd.data_liberacao_compra)*1440) as tempo_para_liberada_aprovacao
                              from compras.v$solicitacao_datas sd
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sd.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                             where sd.data_pedido is not null
                               and sd.data_aprovacao is not null
                               and sd.data_pedido > sd.data_aprovacao
                               and sd.data_liberado_aprovacao > sd.data_orcamento
                               and sd.data_aprovacao > sd.data_liberado_aprovacao
                               and sd.data_orcamento > sd.data_liberacao_compra
                               and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
           					<cfif Len(Trim(arguments.cod_centro_custo))>
                                  and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                            </cfif>
                           ) t
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

        	<!---
    -- PROPÓSITO
    -- Retorna os números de tempo de finalizar o pedido
    -- LEANDRO 05/07/2010 - CRIADO
    --->
    <cffunction name="get_tempo_finalizar_pedido" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_FINAL_PED_VERDE') as faixa_verde
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_FINAL_PED_AMARELO') as faixa_amarela
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_FINAL_PED_META') as meta
             , x.qtde_dentro_prazo
             , x.qtde_total
             , case
                  when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                   else 0
               end percentual
          from (
                select count(*) as qtde_total
                     , count(case
                                when t.tempo_para_pedido <= 719 then 1
                                else null
                             end
                            ) as qtde_dentro_prazo
                  from (
                        select round((sd.data_pedido-sd.data_aprovacao)*1440) as tempo_para_pedido
                          from compras.v$solicitacao_datas sd
                         inner join compras.v$solicitacao s
                                 on s.solicitacao_id = sd.solicitacao_id
                         inner join kss.v$organograma o
                                 on o.cod_organograma = s.cod_organograma
                         where sd.data_pedido is not null
                           and sd.data_aprovacao is not null
                           and sd.data_pedido > sd.data_aprovacao
                           and sd.data_liberado_aprovacao > sd.data_orcamento
                           and sd.data_aprovacao > sd.data_liberado_aprovacao
                           and sd.data_orcamento > sd.data_liberacao_compra
                           and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                        <cfif Len(Trim(arguments.cod_centro_custo))>
                              and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        </cfif>
                       ) t
               ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os números de tempo para liberar aprovação de orçamento
    -- LEANDRO 05/07/2010 - CRIADO
    --->
    <cffunction name="get_tempo_liberar_aprov_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_LIB_APR_ORC_VERDE') as faixa_verde
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_LIB_APR_ORC_AMARELO') as faixa_amarela
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_LIB_APR_ORC_META') as meta
             , x.qtde_dentro_prazo
             , x.qtde_total
             , case
                  when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                   else 0
               end percentual
          from (
                select count(*) as qtde_total
                     , count(case
                                when t.tempo_para_orcamento <= 719 then 1
                                else null
                             end
                            ) as qtde_dentro_prazo
                  from (
                        select round((sd.data_liberado_aprovacao-sd.data_orcamento)*1440) as tempo_para_orcamento
                          from compras.v$solicitacao_datas sd
                         inner join compras.v$solicitacao s
                                 on s.solicitacao_id = sd.solicitacao_id
                         inner join kss.v$organograma o
                                 on o.cod_organograma = s.cod_organograma
                         where sd.data_pedido is not null
                           and sd.data_aprovacao is not null
                           and sd.data_pedido > sd.data_aprovacao
                           and sd.data_liberado_aprovacao > sd.data_orcamento
                           and sd.data_aprovacao > sd.data_liberado_aprovacao
                           and sd.data_orcamento > sd.data_liberacao_compra
                           and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                        <cfif Len(Trim(arguments.cod_centro_custo))>
                              and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        </cfif>
                       ) t
               ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

        <!---
    -- PROPÓSITO
    -- Retorna os números de tempo para aprovar orçamento
    -- LEANDRO 05/07/2010 - CRIADO
    --->
    <cffunction name="get_tempo_aprov_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APR_ORC_VERDE') as faixa_verde
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APR_ORC_AMARELO') as faixa_amarela
             , gerencial.pkg_gerencial.fnc_valor_numerico('PAINEL_COMPRAS_TEMP_APR_ORC_META') as meta
             , x.qtde_dentro_prazo
             , x.qtde_total
             , case
                  when x.qtde_total > 0 then round(x.qtde_dentro_prazo / x.qtde_total * 100, 2)
                   else 0
               end percentual
          from (
                select count(*) as qtde_total
                     , count(case
                                when t.tempo_para_aprovar <= 719 then 1
                                else null
                             end
                            ) as qtde_dentro_prazo
                  from (
                        select round((sd.data_aprovacao-sd.data_liberado_aprovacao)*1440) as tempo_para_aprovar
                          from compras.v$solicitacao_datas sd
                         inner join compras.v$solicitacao s
                                 on s.solicitacao_id = sd.solicitacao_id
                         inner join kss.v$organograma o
                                 on o.cod_organograma = s.cod_organograma
                         where sd.data_pedido is not null
                           and sd.data_aprovacao is not null
                           and sd.data_pedido > sd.data_aprovacao
                           and sd.data_liberado_aprovacao > sd.data_orcamento
                           and sd.data_aprovacao > sd.data_liberado_aprovacao
                           and sd.data_orcamento > sd.data_liberacao_compra
                           and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                        <cfif Len(Trim(arguments.cod_centro_custo))>
                              and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        </cfif>
                       ) t
               ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

            <!---
    -- PROPÓSITO
    -- Retorna as porcentagem dos tempos de aprovação das solicitações
    -- LEANDRO 06/07/2010 - CRIADO
    --->
    <cffunction name="get_perc_aprov_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.faixa
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100), 2) as perc_solicitacoes
                 , y.qtde_solicitacoes
              from (
                    select x.faixa
                        , count(*) as qtde_solicitacoes
                     from(
                           select case
                                  when t.tempo_para_liberacao <= 719 then 'dentro_prazo'
                                  when t.tempo_para_liberacao > 719 and t.tempo_para_liberacao <= 1439 then 'fora_prazo1'
                                  when t.tempo_para_liberacao > 1439 and t.tempo_para_liberacao <= 2879 then 'fora_prazo2'
                                  when t.tempo_para_liberacao > 2879 and t.tempo_para_liberacao <= 4319 then 'fora_prazo3'
                                  else 'fora_prazo4'
                                  end as faixa
                            from (
                                 select round((sd.data_liberacao_compra-sd.data_emissao)*1440) as tempo_para_liberacao
                                   from compras.v$solicitacao_datas sd
                                  inner join compras.v$solicitacao s
                                          on s.solicitacao_id = sd.solicitacao_id
                                  inner join kss.v$organograma o
                                          on o.cod_organograma = s.cod_organograma
                                  where sd.data_pedido is not null
                                    and sd.data_aprovacao is not null
                                    and sd.data_pedido > sd.data_aprovacao
                                    and sd.data_liberado_aprovacao > sd.data_orcamento
                                    and sd.data_aprovacao > sd.data_liberado_aprovacao
                                    and sd.data_orcamento > sd.data_liberacao_compra
                                    and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                              			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        			</cfif>
                               ) t
                         ) x
                         group by x.faixa
                   ) y
               </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna as porcentagem dos tempos das solicitações em orçamento
    -- LEANDRO 06/07/2010 - CRIADO
    --->
    <cffunction name="get_perc_solic_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.faixa
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes
                 , y.qtde_solicitacoes
              from (
                    select x.faixa
                        , count(*) as qtde_solicitacoes
                     from(
                           select case
                                  when t.tempo_para_liberada_aprovacao <= 719 then 'dentro_prazo'
                                  when t.tempo_para_liberada_aprovacao > 719 and t.tempo_para_liberada_aprovacao <= 1439 then 'fora_prazo1'
                                  when t.tempo_para_liberada_aprovacao > 1439 and t.tempo_para_liberada_aprovacao <= 2879 then 'fora_prazo2'
                                  when t.tempo_para_liberada_aprovacao > 2879 and t.tempo_para_liberada_aprovacao <= 4319 then 'fora_prazo3'
                                  else 'fora_prazo4'
                                  end as faixa
                            from (
                                 select round((sd.data_orcamento-sd.data_liberacao_compra)*1440) as tempo_para_liberada_aprovacao
                                   from compras.v$solicitacao_datas sd
                                  inner join compras.v$solicitacao s
                                          on s.solicitacao_id = sd.solicitacao_id
                                  inner join kss.v$organograma o
                                          on o.cod_organograma = s.cod_organograma
                                  where sd.data_pedido is not null
                                    and sd.data_aprovacao is not null
                                    and sd.data_pedido > sd.data_aprovacao
                                    and sd.data_liberado_aprovacao > sd.data_orcamento
                                    and sd.data_aprovacao > sd.data_liberado_aprovacao
                                    and sd.data_orcamento > sd.data_liberacao_compra
                                    and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                              			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        			</cfif>
                               ) t
                         ) x
                         group by x.faixa
                   ) y
               </cfquery>
        <cfreturn qr_result>
    </cffunction>

        <!---
    -- PROPÓSITO
    -- Retorna as porcentagem dos tempos para finalizar pedido
    -- LEANDRO 06/07/2010 - CRIADO
    --->
    <cffunction name="get_perc_finalizar_pedido" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.faixa
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes
                 , y.qtde_solicitacoes
              from (
                    select x.faixa
                        , count(*) as qtde_solicitacoes
                     from(
                           select case
                                  when t.tempo_para_pedido <= 719 then 'dentro_prazo'
                                  when t.tempo_para_pedido > 719 and t.tempo_para_pedido <= 1439 then 'fora_prazo1'
                                  when t.tempo_para_pedido > 1439 and t.tempo_para_pedido <= 2879 then 'fora_prazo2'
                                  when t.tempo_para_pedido > 2879 and t.tempo_para_pedido <= 4319 then 'fora_prazo3'
                                  else 'fora_prazo4'
                                  end as faixa
                            from (
                                 select round((sd.data_pedido-sd.data_aprovacao)*1440) as tempo_para_pedido
                                   from compras.v$solicitacao_datas sd
                                  inner join compras.v$solicitacao s
                                          on s.solicitacao_id = sd.solicitacao_id
                                  inner join kss.v$organograma o
                                          on o.cod_organograma = s.cod_organograma
                                  where sd.data_pedido is not null
                                    and sd.data_aprovacao is not null
                                    and sd.data_pedido > sd.data_aprovacao
                                    and sd.data_liberado_aprovacao > sd.data_orcamento
                                    and sd.data_aprovacao > sd.data_liberado_aprovacao
                                    and sd.data_orcamento > sd.data_liberacao_compra
                                    and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                              			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        			</cfif>
                               ) t
                         ) x
                         group by x.faixa
                   ) y
               </cfquery>
        <cfreturn qr_result>
    </cffunction>

            <!---
    -- PROPÓSITO
    -- Retorna as porcentagem dos tempos para liberar aprovação de orçamento
    -- LEANDRO 06/07/2010 - CRIADO
    --->
    <cffunction name="get_perc_lib_aprov_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.faixa
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes
                 , y.qtde_solicitacoes
              from (
                    select x.faixa
                        , count(*) as qtde_solicitacoes
                     from(
                           select case
                                  when t.tempo_para_orcamento <= 719 then 'dentro_prazo'
                                  when t.tempo_para_orcamento > 719 and t.tempo_para_orcamento <= 1439 then 'fora_prazo1'
                                  when t.tempo_para_orcamento > 1439 and t.tempo_para_orcamento <= 2879 then 'fora_prazo2'
                                  when t.tempo_para_orcamento > 2879 and t.tempo_para_orcamento <= 4319 then 'fora_prazo3'
                                  else 'fora_prazo4'
                                  end as faixa
                            from (
                                 select round((sd.data_liberado_aprovacao-sd.data_orcamento)*1440) as tempo_para_orcamento
                                   from compras.v$solicitacao_datas sd
                                  inner join compras.v$solicitacao s
                                          on s.solicitacao_id = sd.solicitacao_id
                                  inner join kss.v$organograma o
                                          on o.cod_organograma = s.cod_organograma
                                  where sd.data_pedido is not null
                                    and sd.data_aprovacao is not null
                                    and sd.data_pedido > sd.data_aprovacao
                                    and sd.data_liberado_aprovacao > sd.data_orcamento
                                    and sd.data_aprovacao > sd.data_liberado_aprovacao
                                    and sd.data_orcamento > sd.data_liberacao_compra
                                    and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                              			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        			</cfif>
                               ) t
                         ) x
                         group by x.faixa
                   ) y
               </cfquery>
        <cfreturn qr_result>
    </cffunction>
<!---
    -- PROPÓSITO
    -- Retorna as porcentagem dos tempos para aprovar orçamento
    -- LEANDRO 06/07/2010 - CRIADO
    --->
    <cffunction name="get_perc_aprovar_orcamento" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.faixa
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes
                 , y.qtde_solicitacoes
              from (
                    select x.faixa
                        , count(*) as qtde_solicitacoes
                     from(
                           select case
                                  when t.tempo_para_aprovar <= 719 then 'dentro_prazo'
                                  when t.tempo_para_aprovar > 719 and t.tempo_para_aprovar <= 1439 then 'fora_prazo1'
                                  when t.tempo_para_aprovar > 1439 and t.tempo_para_aprovar <= 2879 then 'fora_prazo2'
                                  when t.tempo_para_aprovar > 2879 and t.tempo_para_aprovar <= 4319 then 'fora_prazo3'
                                  else 'fora_prazo4'
                                  end as faixa
                            from (
                                 select round((sd.data_aprovacao-sd.data_liberado_aprovacao)*1440) as tempo_para_aprovar
                                   from compras.v$solicitacao_datas sd
                                  inner join compras.v$solicitacao s
                                          on s.solicitacao_id = sd.solicitacao_id
                                  inner join kss.v$organograma o
                                          on o.cod_organograma = s.cod_organograma
                                  where sd.data_pedido is not null
                                    and sd.data_aprovacao is not null
                                    and sd.data_pedido > sd.data_aprovacao
                                    and sd.data_liberado_aprovacao > sd.data_orcamento
                                    and sd.data_aprovacao > sd.data_liberado_aprovacao
                                    and sd.data_orcamento > sd.data_liberacao_compra
                                    and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                                    <cfif Len(Trim(arguments.cod_centro_custo))>
                              			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
                        			</cfif>
                               ) t
                         ) x
                         group by x.faixa
                   ) y
               </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Retorna as porcentagem das solicitações de regularização por centro de custo
    -- LEANDRO 07/07/2010 - CRIADO
    --->
    <cffunction name="get_perc_solic_reg_centro_custo" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.centro_custo
                 , y.cod_centro_custo
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes
                 , y.qtde_solicitacoes
              from (
                    select t.centro_custo
                         , t.cod_centro_custo
                         , count(*) as qtde_solicitacoes
                      from (
                            select cc.centro_custo
                                 , cc.cod_centro_custo
                              from compras.v$solicitacao_datas sd
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sd.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                             inner join kss.v$centro_custo cc
                                     on cc.cod_centro_custo = o.cod_centro_custo
                             where sd.data_pedido is not null
                               and sd.data_aprovacao is not null
                               and sd.data_pedido > sd.data_aprovacao
                               and sd.data_liberado_aprovacao > sd.data_orcamento
                               and sd.data_aprovacao > sd.data_liberado_aprovacao
                               and sd.data_orcamento > sd.data_liberacao_compra
                               and s.cod_pessoa_fornecedor is not null
                               and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                               <cfif Len(Trim(arguments.cod_centro_custo))>
                          			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
							   </cfif>
                           ) t
                            group by t.centro_custo, t.cod_centro_custo
                   ) y
               </cfquery>
        <cfreturn qr_result>
    </cffunction>

            <!---
    -- PROPÓSITO
    -- Retorna as porcentagem das solicitações por tipo de validação
    -- LEANDRO 07/07/2010 - CRIADO
    --->
    <cffunction name="get_perc_solic_tipo_validacao" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		    select y.tipo_cotacao_id
                 , nvl((select tc.descricao
                      from compras.v$orcamento_tipo_cotacao tc
                     where tc.tipo_cotacao_id = y.tipo_cotacao_id),'Regularização') as tipo
                 , round((y.qtde_solicitacoes / sum(y.qtde_solicitacoes) over() * 100),2) as perc_solicitacoes
                 , y.qtde_solicitacoes
              from (
                     select case
                              when t.tipo_cotacao_id = 1 and possui_fornecedor = 1 then 0
                              when t.tipo_cotacao_id = 1 and possui_fornecedor = 0 then 1
                            else t.tipo_cotacao_id end tipo_cotacao_id, possui_fornecedor,
                            count(*) as qtde_solicitacoes
                       from (
                            select (select distinct a.tipo_cotacao_id
                                      from (select s.num_controle, o.tipo_cotacao_id
                                              from compras.v$orcamento o
                                             inner join compras.v$orcamento_atividade oa
                                                     on o.orcamento_id = oa.orcamento_id
                                             inner join compras.v$orcamento_atividade_solic oas
                                                     on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                                             inner join compras.v$solicitacao_atividade sa
                                                     on sa.controle_id = oas.solicitacao_atividade_id
                                             inner join compras.v$solicitacao s
                                                     on s.solicitacao_id = sa.solicitacao_id
                                             union all
                                            select s.num_controle, o.tipo_cotacao_id
                                              from compras.v$orcamento o
                                             inner join compras.v$orcamento_material om
                                                     on o.orcamento_id = om.orcamento_id
                                             inner join compras.v$orcamento_material_solic oms
                                                     on oms.orcamento_material_id = om.orcamento_material_id
                                             inner join compras.v$solicitacao_material sm
                                                     on sm.controle_id = oms.solicitacao_material_id
                                             inner join compras.v$solicitacao s
                                                     on s.solicitacao_id = sm.solicitacao_id
                                           ) a
                                           where a.num_controle = sd.num_controle) as tipo_cotacao_id,
                                           case
                                             when s.cod_pessoa_fornecedor is null then 0 else 1 end possui_fornecedor
                              from compras.v$solicitacao_datas sd
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sd.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                             where sd.data_pedido is not null
                               and sd.data_aprovacao is not null
                               and sd.data_pedido > sd.data_aprovacao
                               and sd.data_liberado_aprovacao > sd.data_orcamento
                               and sd.data_aprovacao > sd.data_liberado_aprovacao
                               and sd.data_orcamento > sd.data_liberacao_compra
                               and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                               <cfif Len(Trim(arguments.cod_centro_custo))>
                          			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
							   </cfif>
                          ) t
                          group by t.tipo_cotacao_id, t.possui_fornecedor
                   ) y
               </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna as solicitações de compras de forma detalhada de um gráfico e de uma faixa
    -- LEANDRO 07/07/2010 - CRIADO
    --->
    <cffunction name="get_solicitacoes_tempos" access="remote" returntype="query" output="true">
    	<cfargument name="grafico" required="yes">
        <cfargument name="faixa" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.num_controle
                 , t.unidade_negocio
                 , t.centro_custo
                 , to_char(t.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , to_char(t.data_liberacao_compra, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_compra
                 , t.area
                 , t.responsavel
                 , t.valor_materiais
                 , t.valor_atividades
                 , t.valor_materiais + t.valor_atividades as valor_total
                 , t.fornecedor
              from (
                    select sd.num_controle
                         , (select un.unidade_negocio
                              from kss.v$unidade_negocio un
                             where un.cod_unidade_negocio = o.cod_unidade_negocio) as unidade_negocio
                         , (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo
                         , sd.data_emissao
                         , sd.data_liberacao_compra
                         , (select a.descricao
                              from compras.v$area a
                             where a.area_id = s.area_id) as area
                         , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as responsavel
                         , (select nvl(sum(sm.quantidade * sm.valor_sugerido), 0)
                              from compras.v$solicitacao_material sm
                             where sm.solicitacao_id = sd.solicitacao_id) as valor_materiais
                         , (select nvl(sum(sa.quantidade * sa.valor_sugerido), 0)
                              from compras.v$solicitacao_atividade sa
                             where sa.solicitacao_id = sd.solicitacao_id) as valor_atividades
                         , (select spf.fornecedor
                              from compras.v$solic_pedido_fornecedor spf
                             where spf.solicitacao_id = sd.solicitacao_id) as fornecedor
						<cfif arguments.grafico eq 1>
                         , round((sd.data_liberacao_compra-sd.data_emissao)*1440) as tempo
                        <cfelseif arguments.grafico eq 2>
                         , round((sd.data_orcamento-sd.data_liberacao_compra)*1440) as tempo
                        <cfelseif arguments.grafico eq 3>
                         , round((sd.data_liberado_aprovacao-sd.data_orcamento)*1440) as tempo
                        <cfelseif arguments.grafico eq 4>
                         , round((sd.data_aprovacao-sd.data_liberado_aprovacao)*1440) as tempo
                        <cfelseif arguments.grafico eq 5>
                         , round((sd.data_pedido-sd.data_aprovacao)*1440) as tempo
                        </cfif>
                      from compras.v$solicitacao_datas sd
                     inner join compras.v$solicitacao s
                             on s.solicitacao_id = sd.solicitacao_id
                     inner join kss.v$organograma o
                             on o.cod_organograma = s.cod_organograma
                     where sd.data_pedido is not null
                       and sd.data_aprovacao is not null
                       and sd.data_pedido > sd.data_aprovacao
                       and sd.data_liberado_aprovacao > sd.data_orcamento
                       and sd.data_aprovacao > sd.data_liberado_aprovacao
                       and sd.data_orcamento > sd.data_liberacao_compra
                       and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       <cfif Len(Trim(arguments.cod_centro_custo))>
                   			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
					   </cfif>
                   ) t
			<cfif arguments.faixa eq 'dentro_prazo'>
             where t.tempo <= 719
            <cfelseif arguments.faixa eq 'fora_prazo1'>
             where t.tempo > 719 and t.tempo <= 1439
            <cfelseif arguments.faixa eq 'fora_prazo2'>
             where t.tempo > 1439 and t.tempo <= 2879
            <cfelseif arguments.faixa eq 'fora_prazo3'>
             where t.tempo > 2879 and t.tempo <= 4319
            <cfelse>
             where t.tempo > 4319
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

     <cffunction name="get_solicitacoes_centro_custo" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.num_controle
                 , t.unidade_negocio
                 , t.centro_custo
                 , to_char(t.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , to_char(t.data_liberacao_compra, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_compra
                 , t.area
                 , t.responsavel
                 , t.valor_materiais
                 , t.valor_atividades
                 , t.valor_materiais + t.valor_atividades as valor_total
                 , t.fornecedor
              from (
                    select sd.num_controle
                         , (select un.unidade_negocio
                              from kss.v$unidade_negocio un
                             where un.cod_unidade_negocio = o.cod_unidade_negocio) as unidade_negocio
                         , (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo
                         , sd.data_emissao
                         , sd.data_liberacao_compra
                         , (select a.descricao
                              from compras.v$area a
                             where a.area_id = s.area_id) as area
                         , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as responsavel
                         , (select nvl(sum(sm.quantidade * sm.valor_sugerido), 0)
                              from compras.v$solicitacao_material sm
                             where sm.solicitacao_id = sd.solicitacao_id) as valor_materiais
                         , (select nvl(sum(sa.quantidade * sa.valor_sugerido), 0)
                              from compras.v$solicitacao_atividade sa
                             where sa.solicitacao_id = sd.solicitacao_id) as valor_atividades
                         , (select spf.fornecedor
                              from compras.v$solic_pedido_fornecedor spf
                             where spf.solicitacao_id = sd.solicitacao_id) as fornecedor
                     from compras.v$solicitacao_datas sd
                    inner join compras.v$solicitacao s
                            on s.solicitacao_id = sd.solicitacao_id
                    inner join kss.v$organograma o
                            on o.cod_organograma = s.cod_organograma
                    inner join kss.v$centro_custo cc
                            on cc.cod_centro_custo = o.cod_centro_custo
                    where sd.data_pedido is not null
                      and sd.data_aprovacao is not null
                      and sd.data_pedido > sd.data_aprovacao
                      and sd.data_liberado_aprovacao > sd.data_orcamento
                      and sd.data_aprovacao > sd.data_liberado_aprovacao
                      and sd.data_orcamento > sd.data_liberacao_compra
                      and s.cod_pessoa_fornecedor is not null
                      and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                      and o.cod_centro_custo = #arguments.cod_centro_custo#
                   ) t
               </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <cffunction name="get_solicitacoes_tipo_cotacao" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_termino" required="yes">
        <cfargument name="tipo_cotacao_id" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.num_controle
                 , t.unidade_negocio
                 , t.centro_custo
                 , to_char(t.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , to_char(t.data_liberacao_compra, 'dd/mm/yyyy hh24:mi:ss') as data_liberacao_compra
                 , t.area
                 , t.responsavel
                 , t.valor_materiais
                 , t.valor_atividades
                 , t.valor_materiais + t.valor_atividades as valor_total
                 , t.fornecedor
                 , (select tc.descricao
                      from compras.v$orcamento_tipo_cotacao tc
                     where tc.tipo_cotacao_id = t.tipo_cotacao_id) as tipo
              from (
                    select sd.num_controle, s.cod_pessoa_fornecedor
                         , (select un.unidade_negocio
                              from kss.v$unidade_negocio un
                             where un.cod_unidade_negocio = o.cod_unidade_negocio) as unidade_negocio
                         , (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo
                         , sd.data_emissao
                         , sd.data_liberacao_compra
                         , (select a.descricao
                              from compras.v$area a
                             where a.area_id = s.area_id) as area
                         , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as responsavel
                         , (select nvl(sum(sm.quantidade * sm.valor_sugerido), 0)
                              from compras.v$solicitacao_material sm
                             where sm.solicitacao_id = sd.solicitacao_id) as valor_materiais
                         , (select nvl(sum(sa.quantidade * sa.valor_sugerido), 0)
                              from compras.v$solicitacao_atividade sa
                             where sa.solicitacao_id = sd.solicitacao_id) as valor_atividades
                         , (select spf.fornecedor
                              from compras.v$solic_pedido_fornecedor spf
                             where spf.solicitacao_id = sd.solicitacao_id) as fornecedor
                         , (select distinct a.tipo_cotacao_id
                              from (select s.num_controle, o.tipo_cotacao_id
                                      from compras.v$orcamento o
                                     inner join compras.v$orcamento_atividade oa
                                             on o.orcamento_id = oa.orcamento_id
                                     inner join compras.v$orcamento_atividade_solic oas
                                             on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                                     inner join compras.v$solicitacao_atividade sa
                                             on sa.controle_id = oas.solicitacao_atividade_id
                                     inner join compras.v$solicitacao s
                                             on s.solicitacao_id = sa.solicitacao_id
                                     union all
                                    select s.num_controle, o.tipo_cotacao_id
                                      from compras.v$orcamento o
                                     inner join compras.v$orcamento_material om
                                             on o.orcamento_id = om.orcamento_id
                                     inner join compras.v$orcamento_material_solic oms
                                             on oms.orcamento_material_id = om.orcamento_material_id
                                     inner join compras.v$solicitacao_material sm
                                             on sm.controle_id = oms.solicitacao_material_id
                                     inner join compras.v$solicitacao s
                                             on s.solicitacao_id = sm.solicitacao_id
                                   ) a
                                   where a.num_controle = sd.num_controle) as tipo_cotacao_id
                     from compras.v$solicitacao_datas sd
                    inner join compras.v$solicitacao s
                            on s.solicitacao_id = sd.solicitacao_id
                    inner join kss.v$organograma o
                            on o.cod_organograma = s.cod_organograma
                    inner join kss.v$centro_custo cc
                            on cc.cod_centro_custo = o.cod_centro_custo
                    where sd.data_pedido is not null
                      and sd.data_aprovacao is not null
                      and sd.data_pedido > sd.data_aprovacao
                      and sd.data_liberado_aprovacao > sd.data_orcamento
                      and sd.data_aprovacao > sd.data_liberado_aprovacao
                      and sd.data_orcamento > sd.data_liberacao_compra
                      and sd.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       <cfif Len(Trim(arguments.cod_centro_custo))>
                   			and o.cod_centro_custo in (#arguments.cod_centro_custo#)
					   </cfif>
               ) t
           where 1=1
             <cfif arguments.tipo_cotacao_id eq 0>
                 and t.tipo_cotacao_id = 1 and t.cod_pessoa_fornecedor is not null
             <cfelseif arguments.tipo_cotacao_id eq 1>
                 and t.tipo_cotacao_id = 1 and t.cod_pessoa_fornecedor is null
             <cfelse>
                 and t.tipo_cotacao_id = #arguments.tipo_cotacao_id#
             </cfif>
         </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Busca os materiais de um solicitação de compra
    -- ANDERSON 16/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_compra_material" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sm.solicitacao_item_id as controle_id
                 , sm.solicitacao_id
                 , sm.tipo_compra_id
                 , (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id ) as descricao
                 , sm.material_id
                 , sm.cod_unidade
                 , sm.quantidade
                 , sm.compra_liberada
                 , sm.valor_sugerido
                 , (select mp.produto_id
                      from almoxarifado.v$material_produto mp
                     where mp.material_id = sm.material_id) as produto_id
                 , (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as descricao_completa
                 , (select m.ativo
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as ativo
              from compras.v$solicitacao_item sm
             where sm.solicitacao_id = #arguments.solicitacao_id#
               and sm.tipo_item = 1
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Busca as atividades de um solicitação de compra
    -- ANDERSON 16/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_compra_atividade" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sm.solicitacao_item_id as controle_id
                 , sm.solicitacao_id
                 , sm.tipo_compra_id
                 , (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id ) as descricao
                 , sm.material_id as atividade_id
                 , sm.cod_unidade
                 , sm.quantidade
                 , sm.compra_liberada
                 , sm.valor_sugerido
                 , (select mp.produto_id
                      from almoxarifado.v$material_produto mp
                     where mp.material_id = sm.material_id) as produto_id
                 , (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as descricao_completa
                 , (select m.ativo
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as ativo
              from compras.v$solicitacao_item sm
             where sm.solicitacao_id = #arguments.solicitacao_id#
               and sm.tipo_item = 2
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Busca as prioridades para as solicitações de compras
    -- ANDERSON 16/09/2009 - CRIADO
    --->
    <cffunction name="get_solicitacao_prioridade" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select sp.prioridade_id
                 , sp.descricao
                 , sp.numero_horas
              from compras.v$solicitacao_prioridade sp
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- gera parcelas de acordo com a forma de vencimento
    -- WAGNER 24/04/2012 - CRIADO
    --->
    <cffunction name="get_simulacao_parcelas" access="remote" returntype="query" output="true">
        <cfargument name="DATA_PRIM_VENCTO" required="yes">
        <cfargument name="VALOR" required="yes">
        <cfargument name="QTDE_PARCELAS" required="yes" >
        <cfargument name="TIPO_VENCIMENTO" required="no" default="vencimento">
		<cfargument name="QTDE_DIAS_VENCTO" required="no" default="">
        <cftransaction action='begin'>
        	<cfif arguments.TIPO_VENCIMENTO eq 'vencimento' >
                <cfstoredproc procedure='compras.pkg_compras.prc_simular_parcelas_mes' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PRIM_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
                </cfstoredproc>
            <cfelse>
            	<cfstoredproc procedure='compras.pkg_compras.prc_simular_parcelas_dias' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PRIM_VENCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_DIAS_VENCTO#'  null='#iif(len(trim(arguments.QTDE_DIAS_VENCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				</cfstoredproc>
            </cfif>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Parcelas geradas com sucesso!')>

            <cfscript>
				qrParcelas = this.get_simulacao_parcelas_temp();
			</cfscript>

        </cftransaction>
        <cfreturn qrParcelas>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- consulta pedidos
    -- WAGNER 24/04/2012 - CRIADO
    --->
    <cffunction name="get_simulacao_parcelas_temp" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select valor
                     , num_parcela
                     , dia_vencimento
                     , to_char(data_vencto,'dd/mm/yyyy') as data_vencto
                     , to_char(data_vencto,'dd') as dia_vencto
                  from compras.parcelamento_temp
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Busca as áreas para as solicitações de compras
    -- ANDERSON 16/09/2009 - CRIADO
    --->
    <cffunction name="get_area" access="remote" returntype="query" output="true">
	    <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfargument name="situacao" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.area_id
                 , a.descricao
                 , a.exige_romaneio
                 , a.exige_os
              from compras.v$area a
             where visivel = 1
               and situacao = #arguments.situacao#
			<cfif len(trim(arguments.cod_pessoa_fornecedor))>
               and (
                    exists (select 0
                              from compras.v$fornecedor_area fa
                             where fa.area_id = a.area_id
                               and fa.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                            )
                    or not exists (select 0
                                     from compras.v$fornecedor_area fa
                                    where fa.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                                  )
                   )
			</cfif>
             order by a.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	   <!---
    -- PROPÓSITO
    -- Imprimir pedido em pdf
    -- IVANRIBEIRO 26/06/2015 18:24:06 - CRIADO
    --->
    <cffunction name='imprimir_pedido' displayname='Imprimir pedido em pdf' access='remote' returntype='Struct' output='true'>
        <cfargument name='PEDIDO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_pedido.prc_imprimir_pedido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDIDO_ID#'  null='#iif(len(trim(arguments.PEDIDO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.PDF' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Impressão bem sucedida.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


 <cffunction name='altera_gestao_aprovacao' displayname='alterar a gestao de acordo com a gestao passada' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_GESTAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_venda.prc_set_gestao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_GESTAO#'  null='#iif(len(trim(arguments.COD_GESTAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Gestão alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


</cfcomponent>
