<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!---
    -- PROPÓSITO
    -- Conulta os valores da tabela de frete
    -- RAFAEL 29/10/2018
    --->
    <cffunction name='consulta_valores' displayname='Verifica o cartão' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default=''>
        <cfargument name='DESTINO_MUNICIPIO_ID' required='no' default=''>
        <cfargument name='ROTA_ID' required='no' default=''>
        <cfargument name='CLASSIFICACAO_NATUREZA_ID' required='no' default=''>
        <cfargument name='CLASSIFICACAO_COMERCIAL_ID' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='comercial.pkg_tabela_frete.prc_consulta_valor_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#' null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#' null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   value='#arguments.ROTA_ID#' null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   value='#arguments.CLASSIFICACAO_NATUREZA_ID#' null='#iif(len(trim(arguments.CLASSIFICACAO_NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   value='#arguments.CLASSIFICACAO_COMERCIAL_ID#' null='#iif(len(trim(arguments.CLASSIFICACAO_COMERCIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   variable='retorno.MENOR_VMA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.MENOR_VMA_TABELA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   variable='retorno.MAIOR_VMA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.MAIOR_VMA_TABELA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   variable='retorno.MEDIA_VMA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' 	SCALE='5'   variable='retorno.ULTIMO_VMA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.ULTIMO_VMA_TABELA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.MENOR_VMT'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.MENOR_VMT_TABELA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.MAIOR_VMT'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.MAIOR_VMT_TABELA'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.MEDIA_VMT'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.ULTIMO_VMT'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   			variable='retorno.ULTIMO_VMT_TABELA'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                
				<cfif retorno.ULTIMO_VMA eq 0  and retorno.ULTIMO_VMT eq 0>				
				   <cfset retorno.mensagem = JSStringFormat('Nenhuma tabela com valores foi encontrada.')>
				<cfelse>
				   <cfset retorno.mensagem = JSStringFormat('Consulta dos valores de tabela de frete efetuada com sucesso.')>
				</cfif>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

</cfcomponent>
