<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna as classificaes de natureza
    -- ANDERSON 28/09/2010 - CRIADO
    --->		
    <cffunction name="get_classificacao_natureza" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cn.classificacao_natureza_id
                 , cn.descricao
              from comercial.v$classificacao_natureza cn
             order by cn.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as classificaes comerciais
    -- ANDERSON 28/09/2010 - CRIADO
    --->		
    <cffunction name="get_classificacao_comercial" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.classificacao_comercial_id
                 , cc.descricao
                 , cc.lotacao_minima
              from comercial.v$classificacao_comercial cc
             order by cc.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna a tabela de frete por rota internacional que deve ser utilizada atravs dos parmetros informados
	-- ANDERSONC 30/09/2010 14:04:55 - CRIADO
	--->
	<cffunction name='get_tabela_frete_rota_id_intc' displayname='Retorna a tabela de frete por rota internacional que deve ser utilizada atravs dos parmetros informados' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='CLASSIFICACAO_NATUREZA_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_COMERCIAL_ID' required='yes'>
        <cfargument name='TIPO_SERVICO_ID' required='no' default="0">
		<cftry>
            <cfstoredproc procedure='comercial.pkg_tabela_frete.prc_tabela_frete_rota_id_intc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CLASSIFICACAO_NATUREZA_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_NATUREZA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CLASSIFICACAO_COMERCIAL_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_COMERCIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TABELA_FRETE_ROTA_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_SERVICO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TABELA_FRETE_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>   
    

    
</cfcomponent>
