<cfcomponent displayname="Consultas da área de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPÓSITO 
	-- Busca os pares para o pneu no estoque
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_parceiros_disponiveis_estoque" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfquery name="qr_dados_pneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, pm.num_gabarito, pm.num_eixo, p.medida_roda_id, p.medida_id, p.marca_id, p.modelo_id, p.reformas, pr.borracha_id, pr.desenho_id, 
				   oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as sulco
			  from oper.v$pneu_dados p
			 inner join oper.v$pneu_movimentacao pm
					 on pm.pneu_id = p.pneu_id
			 left join oper.v$pneu_reforma pr
					on pr.pneu_id = p.pneu_id
			 where p.num_pneu = #arguments.num_pneu#
			   and p.situacao_id in (1,3,4,5,6,8,9,10)
			   and (pr.data_retorno_reforma = (select max(pr.data_retorno_reforma)
												from oper.v$pneu_reforma pr2
											   where pr2.pneu_id = pr.pneu_id)
					or pr.data_retorno_reforma is null)
   		</cfquery>		
		<cfif qr_dados_pneu.recordCount eq 0>
		 	<cfthrow detail="Pneu não encontrado ou sucateado." errorcode="1" />
		</cfif>
		<cfquery name="qr_conf_eixo"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reformas, integridade_marca, integridade_modelo, integridade_status,
				   integridade_borracha, integridade_desenho, pem.direcional, pem.tracionado,
        	       pem.suspenso, t.prefixo
			  from oper.v$pneu_gabarito_setup t
		     inner join oper.v$pneu_eixo_modelo pem
                on pem.modelo_eixo_id = t.modelo_eixo_id
			 where t.num_gabarito = #qr_dados_pneu.num_gabarito#
			   and t.num_eixo = #qr_dados_pneu.num_eixo# 
   		</cfquery>
        
		<cfif qr_dados_pneu.RecordCount eq 0 or qr_conf_eixo.RecordCount eq 0>
			<cfquery name="qr_pneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select pneu_id, num_pneu, situacao_id as situacao, marca_id, marca, modelo_id, modelo,
					   borracha_id, desenho_id, desenho, borracha, oper.pkg_pneu.fnc_sulco_atual(pneu_id) as sulco, 
					   medida_id, medida, reformas, medida_roda_id, medida_roda, 
					   status, substr(formato_borracha,1,1) as formato
				  from (
							select /*+ RULE */ p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
							 p.modelo_id, pm.descricao as modelo,
								   null borracha_id, null desenho_id, null as desenho, 
							 null as borracha, 
							 p.medida_roda_id, mr.medida_roda, 
								   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
								   p.medida_id, me.descricao as medida,
								   p.reformas, 'Novos' as status, pfb.descricao as formato_borracha
							  from oper.v$pneu p
						inner join oper.v$pneu_localizacao pl
								on pl.pneu_id = p.pneu_id
							   and pl.data_saida is null
						inner join oper.v$pneu_marca ma
								on ma.marca_id = p.marca_id
						inner join oper.v$pneu_modelo pm
								on pm.marca_id = p.marca_id
							   and pm.modelo_id = p.modelo_id
							   and pm.medida_id = p.medida_id
							   and pm.medida_roda_id = p.medida_roda_id
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.direcional eq 1>
							   and pm.eixo_direcional = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.tracionado eq 1>
							   and pm.eixo_tracionado = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.suspenso eq 1>
							   and pm.eixo_suspenso = 1
							</cfif>
						inner join oper.v$pneu_medida me
								on me.medida_id = p.medida_id
						inner join oper.v$pneu_medida_roda mr
								on mr.medida_roda_id = p.medida_roda_id
						inner join oper.v$pneu_formato_borracha pfb
								on pfb.formato_id = pm.formato_id
							 where p.situacao_id = 1
						 and p.reformas = 0
						 and pl.cod_pessoa = #session.cod_pessoa#
				union
							select /*+ RULE */ p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
								   p.modelo_id, pm.descricao as modelo,
								   pr.borracha_id, pr.desenho_id, 
								   pd.descricao as desenho, 
								   pb.descricao as borracha, 
								   p.medida_roda_id, mr.medida_roda, 
								   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
								   p.medida_id, me.descricao as medida,
								   p.reformas, 'Recapados' as status, pfb.descricao as formato_borracha
							  from oper.v$pneu p
						inner join oper.v$pneu_localizacao pl
								on pl.pneu_id = p.pneu_id
							   and pl.data_saida is null
						inner join oper.v$pneu_marca ma
								on ma.marca_id = p.marca_id
						inner join oper.v$pneu_modelo pm
								on pm.marca_id = p.marca_id
							   and pm.modelo_id = p.modelo_id
							   and pm.medida_id = p.medida_id
							   and pm.medida_roda_id = p.medida_roda_id
						inner join oper.v$pneu_medida me
								on me.medida_id = p.medida_id
						inner join oper.v$pneu_medida_roda mr
								on mr.medida_roda_id = p.medida_roda_id
						  inner join oper.v$pneu_reforma pr
									on pr.pneu_id = p.pneu_id
						inner join oper.v$pneu_borracha pb
								on pb.borracha_id = pr.borracha_id
						inner join oper.v$pneu_desenho pd
								on pd.borracha_id = pr.borracha_id
							   and pd.desenho_id = pr.desenho_id
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.direcional eq 1>
							   and pd.eixo_direcional = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.tracionado eq 1>
							   and pd.eixo_tracionado = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.suspenso eq 1>
							   and pd.eixo_suspenso = 1
							</cfif>
						inner join oper.v$pneu_formato_borracha pfb
								on pfb.formato_id = pd.formato_id
							 where p.situacao_id = 1
							   and p.reformas > 0
							   and pl.cod_pessoa = #session.cod_pessoa#) p
				 where 1 = 1
					and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
																		 from oper.v$pneu_reforma r2
																		where r2.pneu_id = pr.pneu_id
																		  and r2.data_retorno_reforma is not null
																		  and r2.conserto = 0)
						 or pr.data_retorno_reforma is null)
					 <cfif Len(Trim(qr_dados_pneu.sulco)) and qr_dados_pneu.num_eixo neq 0>
					   and #qr_dados_pneu.sulco#  between sulco - to_number(oper.pkg_global.FNC_GET_PARAMETRO(9,'PNEU')) and sulco + to_number(oper.pkg_global.FNC_GET_PARAMETRO(9,'PNEU'))
					 </cfif>
					 
					 <cfif Len(Trim(qr_dados_pneu.medida_roda_id)) and qr_dados_pneu.num_eixo neq 0>
					   and p.medida_roda_id = #qr_dados_pneu.medida_roda_id#			 
					 </cfif>

					 <cfif Len(Trim(qr_dados_pneu.medida_id)) and qr_dados_pneu.num_eixo neq 0>
					   and p.medida_id = #qr_dados_pneu.medida_id#			 
					 </cfif>
								 
					 <cfif qr_conf_eixo.reformas gte 0 and qr_dados_pneu.num_eixo neq 0 <!--- numero maximo de REFORMAS ---> >
					   and p.reformas <= #qr_conf_eixo.reformas#			 
					 </cfif>
		
					 <cfif qr_conf_eixo.integridade_status eq 1 and Len(Trim(qr_dados_pneu.reformas)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de STATUS ---> >
					   and p.reformas = #qr_dados_pneu.reformas#
					 </cfif>
		
					 <cfif qr_conf_eixo.integridade_marca eq 1 and Len(Trim(qr_dados_pneu.marca_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de MARCA --->>
					   and p.marca_id = #qr_dados_pneu.marca_id#			 
					 </cfif>
		
					 <cfif qr_conf_eixo.integridade_modelo eq 1 and Len(Trim(qr_dados_pneu.modelo_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de MODELO --->>
					   and p.modelo_id = #qr_dados_pneu.modelo_id#			 
					 </cfif>
		
					 <cfif qr_dados_pneu.reformas gt 0 and qr_conf_eixo.integridade_borracha eq 1 and Len(Trim(qr_dados_pneu.borracha_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de BORRACHA --->>
					   and p.borracha_id = #qr_dados_pneu.borracha_id#
					 </cfif>
		
					 <cfif qr_dados_pneu.reformas gt 0 and qr_conf_eixo.integridade_desenho eq 1 and Len(Trim(qr_dados_pneu.desenho_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de DESENHO --->>
					   and p.desenho_id = #qr_dados_pneu.desenho_id#
					 </cfif>
				 <cfif qr_conf_eixo.PREFIXO eq '1' and Len(Trim(qr_dados_pneu.sulco))>
					 or sulco < #session.mm_liberacao_primeiro_eixo# 
				 </cfif>
				 order by p.reformas, p.num_pneu, p.marca, p.modelo, 12 desc, p.borracha, p.desenho 
			</cfquery>						
			<cfreturn qr_pneus>
		<cfelse>
		 	<cfthrow detail="Dados do pneu ou veículo não encontrados" errorcode="1" />
		</cfif>
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca os pares perfeitos para o pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_parceiros_par_perfeito" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfquery name="qr_dados_pneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.medida_roda_id, p.marca_id, p.medida_id, p.medida_roda_id, p.modelo_id, p.reformas, pr.borracha_id, pr.desenho_id, 
				   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco
			  from oper.v$pneu_dados p
			  left join oper.v$pneu_reforma pr
					 on pr.pneu_id = p.pneu_id
					and pr.conserto = 0
			 where p.num_pneu = #arguments.num_pneu#
			   and p.situacao_id in (1,3,4,5,6,8,9,10)
			   and (pr.data_retorno_reforma = (select max(pr.data_retorno_reforma) 
												 from oper.v$pneu_reforma pr2
											    where pr2.pneu_id = pr.pneu_id
											  	  and pr2.conserto = 0)
				or pr.data_retorno_reforma is null)
   		</cfquery>		
		<cfif qr_dados_pneu.recordCount eq 0>
		 	<cfthrow detail="Pneu não encontrado ou sucateado." errorcode="1" />
		</cfif>
		<cfquery name="qr_pneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pd.pneu_id, pd.num_pneu, pd.marca, pd.modelo, pd.medida, pd.medida_roda, pd.reformas, 
				   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco, pb.descricao as borracha,
				   d.descricao as desenho
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_localizacao_atual pla
					 on pla.pneu_id = pd.pneu_id
			  left join oper.v$pneu_reforma pr
					 on pr.pneu_id = pd.pneu_id
					and pr.conserto = 0
			  left join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			  left join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			<cfif qr_dados_pneu.recordcount gt 0>
			 where pd.num_pneu <> #arguments.num_pneu#
			   and pla.cod_pessoa = #session.cod_pessoa#
			   and #qr_dados_pneu.SULCO# between oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)-to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 9)) and oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)+to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 9))
			   and pd.reformas = #qr_dados_pneu.REFORMAS#
			   and pd.marca_id = #qr_dados_pneu.MARCA_ID#
			   and pd.modelo_id = #qr_dados_pneu.MODELO_ID#
			   and pd.medida_id = #qr_dados_pneu.MEDIDA_ID#
			   and pd.medida_roda_id = #qr_dados_pneu.MEDIDA_RODA_ID#
			   and (pr.data_retorno_reforma = (select max(pr.data_retorno_reforma) 
												from oper.v$pneu_reforma pr2
											   where pr2.pneu_id = pr.pneu_id
												 and pr2.conserto = 0)
	            or pr.data_retorno_reforma is null)
			   <cfif qr_dados_pneu.REFORMAS GT 0>
				   and pr.borracha_id = #qr_dados_pneu.BORRACHA_ID#
				   and pr.desenho_id = #qr_dados_pneu.DESENHO_ID#
			   </cfif>
			 order by pd.reformas, pd.num_pneu, pd.marca, pd.modelo, 7 desc <cfif qr_dados_pneu.REFORMAS GT 0>, pb.descricao, d.descricao </cfif> 
			<cfelse>
				where 1=0
			</cfif>
   		</cfquery>						
		<cfreturn qr_pneus>
	</cffunction>
    
    
</cfcomponent>