<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Busca as ocorrencias da carga
	-- CRISTOFER  27/10/2006
	--->
	<cffunction name="get_carga_ocorrencia" access="remote" returntype="query" output="true">
		<cfargument name="carga_id" required="no" default="">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select co.carga_ocorrencia_id,
				   co.ocorrencia_id,
				   to_char(co.data,'dd/mm/yyyy hh24:mi:ss') as data,
				   co.carga_id,
				   co.observacao,
				   oe.descricao_resumida,
				   oe.descricao
			  from oper.v$carga_ocorrencia co
			 inner join oper.v$ocorrencia_empresa oe
					 on oe.ocorrencia_Id = co.ocorrencia_id
             <cfif len(trim(arguments.conhecimento_id))>
             inner join oper.v$carga_ctrc cc
                     on cc.carga_id = co.carga_id
                    and cc.conhecimento_id = #arguments.conhecimento_id#
             </cfif>
			 where 1=1
			 <cfif len(trim(arguments.carga_id))>
			   and co.carga_id = #arguments.carga_id#
			 </cfif>
			 order by co.data, co.carga_ocorrencia_id
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os clientes do grupo logistico carga/descarga
	-- CRISTOFER  05/12/2006
	--->
	<cffunction name="get_grupo_logistico_cliente" access="remote" returntype="query" output="true">
		<cfargument name="carga" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif lcase(len(trim(arguments.carga))) neq 1>
			select glc.cod_pessoa_descarga cod_pessoa,
				   p.identificador,
				   p.cliente,
                   p.cnpj_cpf
			  from oper.v$grupo_logistico_descarga glc
			 inner join oper.v$grupo_logistico_usuario glu
			         on glu.grupo_id = glc.grupo_id
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = glc.cod_pessoa_descarga
			 where glu.usuario = user
			 order by p.cliente
			<cfelse>
			select glc.cod_pessoa_carga cod_pessoa,
				   p.identificador,
				   p.cliente,
                    p.cnpj_cpf
			  from oper.v$grupo_logistico_carga glc
			 inner join oper.v$grupo_logistico_usuario glu
			         on glu.grupo_id = glc.grupo_id
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = glc.cod_pessoa_carga
			 where glu.usuario = user
			 order by p.cliente
			</cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os grupos logisticos do usurio corrente
	-- CRISTOFER  05/12/2006
	--->
	<cffunction name="get_grupo_logistico" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select gl.grupo_id,
				   gl.descricao
			  from oper.v$grupo_logistico gl
			 inner join oper.v$grupo_logistico_usuario glu
					 on glu.grupo_id = gl.grupo_id
			 where glu.usuario = user
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
    -- PROPSITO
    -- Busca os dados do veicuo do Conhecimento
    -- 17/03/2009 - criado
    --->
    <cffunction name="get_conhecimento_dados_veiculo" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="conhecimento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select conhecimento_id,
                   num_conhecimento,
                   placa,
                   placa_tracao,
                   oper.pkg_veiculo.FNC_GET_PLACA(placa) as cod_veiculo,
                   oper.pkg_veiculo.FNC_GET_PLACA(placa_tracao) as cod_veiculo_tracao,
                   nome_motorista as motorista,
                   prop_razao_social as proprietario
              from fiscal.v$conhecimento
             where 1=1
             <cfif len(trim(arguments.conhecimento_id))>
               and conhecimento_id = #arguments.conhecimento_id#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Relao de faturas e ctrc's
	-- NOTAS EXPLICATIVAS
	--
	-- LOUIS 05/07/2007 - criado
	--->
	<cffunction name="get_fatura_ctrc" displayname="Relao de faturas e ctrc's" access="remote" returntype="query" output="true">
        <cfargument name="num_docto" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="data_emissao_inicial" required="no" default="">
        <cfargument name="data_emissao_final" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
        select r.num_docto,
               trunc(c.data_emissao) data_emissao,
               trunc(r.data_vencto) data_vencto,
               r.valor_docto,
               c.num_conhecimento,
               c.serie,
               c.data_emissao,
               c.dest_razao_social,
               c.dest_municipio,
               c.dest_uf,
               c.total_conhecimento,
               c.aliquota_icms,
               c.base_calculo_icms,
               c.valor_icms,
               c.pedagio as valor_pedagio,
               pf.cnpj_cpf cnpj_cpf_filial,
               pf.cliente filial,
               c.peso,
               case
                  when c2.num_conhecimento is not null then 1
                  else 0
               end complementar,
               c2.num_conhecimento num_conhecimento_compl,
               c2.serie serie_compl,
               case
                  when c.cod_remetente in (#arguments.cod_pessoa#) then (select p1.cnpj_cpf
                                                                           from kss.v$pessoa p1
                                                                          where p1.cod_pessoa = c.cod_remetente)
                  when c.cod_destinatario in (#arguments.cod_pessoa#) then (select p1.cnpj_cpf
                                                                              from kss.v$pessoa p1
                                                                             where p1.cod_pessoa = c.cod_destinatario)
                  else null
               end filial_cliente,
               case
                  when c.cod_remetente in (#arguments.cod_pessoa#) then 'Saida'
                  when c.cod_destinatario in (#arguments.cod_pessoa#) then 'Entrada'
                  else null
               end tipo_nf,

               (select kss.fnc_concat_all(to_concat_expr(numero||'-'||serie,','))
                  from fiscal.v$conhecimento_nota_fiscal cnf
                 where cnf.conhecimento_id = c.conhecimento_id) notas_fiscais,
               (select kss.fnc_concat_all(to_concat_expr(numero,','))
                  from fiscal.v$conhecimento_nota_fiscal cnf
                 where cnf.conhecimento_id = c.conhecimento_id) notas_fiscais_sem_serie
          from finan.v$finan_contas_receber r
         inner join fiscal.v$conhecimento_receber cr
         	     on r.contas_receber_id = cr.contas_receber_id
         <cfif len(trim(arguments.cod_pessoa))>
         inner join finan.v$ccorrente cc
                 on cc.cod_conta = r.cc_sacado
                and cc.cod_pessoa in (#arguments.cod_pessoa#)
         </cfif>
         inner join fiscal.v$conhecimento c
         	     on cr.conhecimento_id = c.conhecimento_id
         inner join kss.v$pessoa pf
         	     on c.cod_pessoa_filial = pf.cod_pessoa
          left join fiscal.v$conhecimento_complemento cc1
                 on cc1.conhecimento_complemento_id = c.conhecimento_id
          left join fiscal.v$conhecimento c2
                 on c2.conhecimento_id = cc1.conhecimento_id
              where 1=1 --r.docto_id = 'DP' -- Alterado por Marcel
          <cfif len(trim(arguments.data_inicial)) and len(trim(arguments.data_final))>
               and trunc(r.data_emissao) between '#arguments.data_inicial#' and '#arguments.data_final#'
          </cfif>
          <cfif len(trim(arguments.data_emissao_inicial)) and len(trim(arguments.data_emissao_final))>
               and trunc(c.data_emissao) between '#arguments.data_emissao_inicial#' and '#arguments.data_emissao_final#'
          </cfif>
          <!---<cfif len(trim(arguments.cod_pessoa))>
               and exists
              (select 0
                      from finan.v$ccorrente cc
                     where cc.cod_conta = r.cc_sacado
                       and cc.cod_pessoa in (#arguments.cod_pessoa#))
          </cfif>--->
          <cfif len(trim(arguments.num_docto))>
              and r.num_docto in ('#arguments.num_docto#')
          </cfif>
			 order by num_docto, num_conhecimento
          </cfquery>
  	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os conhecimentos nos grupos logisticos para o periodo
	-- CRISTOFER  05/12/2006
	--->
	<cffunction name="get_conhecimentos_grupo" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_remetente" required="no" default="">
		<cfargument name="cod_destinatario" required="no" default="">
		<cfargument name="nf_numero" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="ordem_compra" required="no" default="">
		<cfargument name="num_pedido" required="no" default="">
		<cfif len(trim(arguments.nf_numero))>
			<cfquery name="qr_nf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select conhecimento_id
				  from fiscal.v$conhecimento_nota_fiscal
				 where numero in (#ListQualify(arguments.nf_numero,"'",",")#)
			</cfquery>
		</cfif>
		<cfif len(trim(arguments.ordem_compra))>
			<cfquery name="qr_ordem_compra" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select conhecimento_id
				  from fiscal.v$conhecimento_nota_fiscal
				 where ordem_compra_cliente in (#ListQualify(arguments.ordem_compra,"'",",")#)
			</cfquery>
		</cfif>
		<cfif len(trim(arguments.num_pedido))>
			<cfquery name="qr_pedido" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select c.conhecimento_id
                  from logistica.v$solicitacao_carga sc
                 inner join fiscal.v$conhecimento c
                    on c.solicitacao_carga_id = sc.solicitacao_carga_id
                 where sc.pedido_shipment in (#ListQualify(arguments.num_pedido,"'",",")#)
			</cfquery>
		</cfif>

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select con.conhecimento_id,
				   con.num_conhecimento,
				   con.data_emissao,
				   con.rem_razao_social remetente,
				   con.rem_cnpj_cpf,
				   con.dest_razao_social destinatario,
				   con.dest_cnpj_cpf,
				   mc.municipio||'-'||mc.uf_id coleta_municipio_uf,
				   me.municipio||'-'||me.uf_id entrega_municipio_uf,
				   (select kss.fnc_concat_all(kss.to_concat_expr(to_char(numero),' / '))
				      from fiscal.v$conhecimento_nota_fiscal cn
					 where cn.conhecimento_id = con.conhecimento_id) notas_fiscais,
				   (select sum(cn.valor_total)
				      from fiscal.v$conhecimento_nota_fiscal cn
					 where cn.conhecimento_id = con.conhecimento_id) valor_fiscal,
				   con.frete_peso,
				   con.pagador,
				   case con.pagador
				      when 0 then 'CIF'
					  when 1 then 'FOB'
					  else ''
				   end cif_fob,
				   con.frete_valor,
				   con.total_conhecimento,
				   con.pedagio,
				   con.valor_icms,
				   con.coleta_entrega,
				   con.DESPACHO,
				   con.peso,
           		   c.num_pedido,
				   (select kss.fnc_concat_all(kss.to_concat_expr(cnf.ordem_compra_cliente,' / '))
				      from fiscal.v$conhecimento_nota_fiscal cnf
          			 where cnf.conhecimento_id = con.conhecimento_id) ordem_compra,
			       (select sc.pedido_shipment
                      from logistica.v$solicitacao_carga sc
                     where sc.solicitacao_carga_id = con.solicitacao_carga_id) as pedido_shipment,
				   case
					  when exists (select 'x'
									 from oper.v$coleta col
									where col.carga_id = c.carga_id) then 'Coletada'
					  else 'Entregue'
				   end coletada,

				   con.prazo_entrega,
				   con.data_entrega,
				   nvl(r.data_termino_carga,con.data_emissao) as data_termino_carga,
	               r.situacao_id romaneio_situacao_id,
				   rf.latitude,
	               rf.longitude,
				   r.placa_controle,
				   decode(cd.descricao,'',cep.fnc_municipio_uf(c.municipio_id),'CD: '||cd.descricao) ultima_posicao,
				   rf.landmark,
                   (select crc.rv_meaning
                      from oper.cg_ref_codes crc
                     where crc.rv_domain = 'SITUACAO CARGA'
                       and crc.rv_low_value = c.situacao_id) situacao_carga,
                   ct.transferencia_id,
                   to_char(coalesce(ct.data_destino,ct.data_origem,c.date_insert),'dd/mm/yyyy hh24:mi:ss') data_situacao,
                   decode(rf.fracionado,1,'Sim','No') as fracionado
			  from fiscal.v$conhecimento con
			 inner join oper.v$grupo_logistico_usuario glu
					 on glu.usuario = user
	          left join oper.v$carga_ctrc cc
    	             on cc.conhecimento_id = con.conhecimento_id
       		  left join oper.v$carga c
                     on c.carga_id = cc.carga_id
			  left join oper.v$grupo_logistico_carga glc
					 on glc.cod_pessoa_carga = con.cod_remetente
					and glu.grupo_id = glc.grupo_id
			  left join oper.v$grupo_logistico_descarga gld
					 on gld.cod_pessoa_descarga = con.cod_destinatario
					and glu.grupo_id = gld.grupo_id
			 inner join cep.municipio mc
					 on mc.municipio_id = con.coleta_municipio_id
			 inner join cep.municipio me
					 on me.municipio_id = con.entrega_municipio_id

			   left join oper.v$romaneio r
					  on r.num_romaneio = con.NUM_ROMANEIO
			   left join oper.v$rank_frota rf
					  on rf.num_romaneio = r.num_romaneio

		      left join oper.v$centro_distribuicao cd
			         on cd.cod_pessoa_filial = c.cod_filial_atual
              left join oper.v$carga_transferencia ct
                     on ct.carga_id = c.carga_id
                    and ct.transferencia_id_posterior is null

			 where ( con.cod_remetente = glc.cod_pessoa_carga or
					 con.cod_destinatario = gld.cod_pessoa_descarga)
               and con.cancelado is null
			 <cfif len(trim(arguments.cod_remetente)) or len(trim(arguments.cod_destinatario))>
			 	and ( 1=0
				<cfif len(trim(arguments.cod_remetente))>
				   or con.cod_remetente in (#arguments.cod_remetente#)
				</cfif>
				<cfif len(trim(arguments.cod_destinatario))>
				   or con.cod_destinatario in (#arguments.cod_destinatario#)
				</cfif>
					)
			 </cfif>
			 <cfif len(trim(arguments.num_conhecimento))>
			   and con.num_conhecimento in (#arguments.num_conhecimento#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(con.data_emissao) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(con.data_emissao) <= '#arguments.data_final#'
			 </cfif>
			<cfif len(trim(arguments.nf_numero))>
				<cfif not qr_nf.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_nf.conhecimento_id)#)
				</cfif>
			</cfif>
			<cfif len(trim(arguments.ordem_compra))>
				<cfif not qr_ordem_compra.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_ordem_compra.conhecimento_id)#)
				</cfif>
			</cfif>
			<cfif len(trim(arguments.num_pedido))>
				<cfif not qr_pedido.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_pedido.conhecimento_id)#)
				</cfif>
			</cfif>

			 order by con.data_emissao desc, con.num_conhecimento
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

</cfcomponent>