<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!---
	-- PROPSITO
	-- Busca o grupo do usuario corrente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/02/2006
	--->
	<cffunction name="get_grupo_corrente" access="remote" returntype="query" output="true">
		<cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select grupo_id, somente_veiculos, remetente_definido, destinatario_definido
   			  from oper.v$grupo_logistico_user
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Busca a lista de grupo do usuario corrente
	-- NOTAS EXPLICATIVAS
	-- RAFAEL  08/01/2018
	--->
	<cffunction name="get_lista_grupo_corrente" access="remote" returntype="query" output="true">
		<cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.fnc_concat_all(distinct kss.to_concat_expr(to_char(gl.descricao), ',')) as lista_grupos 
			  from oper.v$grupo_logistico_user vgu
			 inner join oper.v$grupo_logistico gl
			    on vgu.grupo_id = gl.grupo_id
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o grupo do usuario corrente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/02/2006
	--->
	<cffunction name="get_detalhamento_motorista" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="GRUPO_CLIENTE" required="no" default="">
    	<cfargument name="FILTRO" required="no" default="">
    	<cfargument name="TODOS" required="no" default="">
		<cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select motorista, placa, to_char(data,'dd/mon hh24:mi') as data, tempo, grupo_cavalo, status,tempo_min
              from (
            select kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa) as motorista
                 , t.placa
                 , t.data_fim as data
                 , (sysdate - t.data_fim)*1440 as tempo_min
                 , kss.to_tempo((sysdate - t.data_fim)*1440,1).retorno as tempo
                 , (select vg.cod_grupo
                      from oper.v$veiculo_grupo vg
                     where vg.placa = nvl(oper.pkg_veiculo.fnc_primeira_carreta(t.placa),t.placa)
                     and vg.data_termino is null) as grupo_cavalo
                 , case
                     when exists (select 1
                                 from folha.v$funcionario f
                                inner join folha.v$ferias_aquisitivo fa
                                        on fa.funcionario_id = f.funcionario_id
                                inner join folha.v$ferias_concessivo fc
                                         on fa.aquisitivo_id = fc.aquisitivo_id
                               where f.cod_pessoa = t.cod_pessoa
                                 and sysdate between fc.data_inicial and fc.data_final) then 'Frias'
                     when exists (select 1
                                 from folha.v$funcionario f
                                inner join folha.v$funcionario_afastamento fa
                                        on fa.funcionario_id = f.funcionario_id
                                where f.cod_pessoa = t.cod_pessoa
                                  and sysdate between fa.data_afastamento and nvl(fa.data_retorno,sysdate)) then 'Afastado'
                     else 'Sem veculo' end status
              from oper.v$veiculo_motorista t
             where t.data_fim = (select max(t2.data_fim)
                                   from oper.v$veiculo_motorista t2
                                  where t2.cod_pessoa = t.cod_pessoa)
               and exists (select 1
                             from oper.v$motorista_reg_historico mrh
                            where mrh.cod_pessoa = t.cod_pessoa
                              and mrh.data_fim is null)
               and not exists (select 1
                             from oper.v$veiculo_motorista vm
                            where vm.cod_pessoa = t.cod_pessoa
                              and vm.data_fim is null)
               and exists (select 1
                             from kss.v$pessoa_modalidade pm
                            where pm.cod_pessoa = t.cod_pessoa
                              and pm.num_modalidade = 6
                              and pm.situacao = 1)
            union all
            select kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa) as motorista
                 , t.placa
                 , t.data_fim as data
                 , (sysdate - t.data_fim)*1440 as tempo_min
                 , kss.to_tempo((sysdate - t.data_fim)*1440,1).retorno as tempo
                 , (select vg.cod_grupo
                      from oper.v$veiculo_grupo vg
                     where vg.placa = nvl(oper.pkg_veiculo.fnc_primeira_carreta(t.placa),t.placa)
                     and vg.data_termino is null) as grupo_cavalo
                 ,'Com veculo' as status
              from oper.v$veiculo_motorista t
             where t.data_fim = (select max(t2.data_fim)
                                   from oper.v$veiculo_motorista t2
                                  where t2.cod_pessoa = t.cod_pessoa)
               and exists (select 1
                             from oper.v$motorista_reg_historico mrh
                            where mrh.cod_pessoa = t.cod_pessoa
                              and mrh.data_fim is null)
               and exists (select 1
                             from kss.v$pessoa_modalidade pm
                            where pm.cod_pessoa = t.cod_pessoa
                              and pm.num_modalidade = 6
                              and pm.situacao = 1) ) a
          where 1=1
             and status not in ('Afastado')
			 <cfif Len(Trim(arguments.COD_GRUPO))>
              and a.grupo_cavalo in (select vg.cod_grupo
                                     from oper.v$veiculo_grupo_setup vg
                                    start with vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'",',')#)
                                   connect by prior vg.cod_grupo = vg.cod_grupo_pai)
              </cfif>
              order by status, tempo_min desc
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca resumo por grupo de controle
	-- GUTO  11/07/2012
	--->
	<cffunction name="get_resumo_grupo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="cod_grupo_veiculo" required="no" default="">
    	<cfargument name="GRUPO_CLIENTE" required="no" default="">
    	<cfargument name="FILTRO" required="no" default="">
    	<cfargument name="TODOS" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.situacao
                 , count(1) as ativos
              from (select case
                              when e.status in ('Carga') then
                                 nvl(e.pais, 'Brasil') || ' - ' || 'Carga'
                              when e.status in ('Descarga') then
                                 nvl(e.pais, 'Brasil') || ' - ' || 'Descarga'
                              when e.status in ('Descarga Parcial') then
                                 nvl(e.pais, 'Brasil') || ' - ' || 'Descarga'
                              when e.status in ('Vazio') then
                                 nvl(e.pais, 'Brasil') || ' - ' || 'Vazio'
                              when e.status in ('Destinado') then
                                 nvl(e.pais, 'Brasil') || ' - ' || 'Destinado'
                              when e.status in ('Fronteira') then
                                 e.categoria || ' - ' || 'Fronteira'
                              when e.status in ('Viagem') then
                                 e.categoria || ' - ' || 'Trnsito'
                              when e.placa_referencia is null then
                                 'Cavalo Desengatado'
                              else
                                 'No Classificado'
                           end situacao
                     from (select distinct case
                                     when rf.uf_origem = 'EX'  and rf.uf_destino <> 'EX' then
                                      'Importao'
                                     when rf.uf_origem <> 'EX' and rf.uf_destino = 'EX' then
                                      'Exportao'
                                     when rf.uf_origem = 'EX'  and rf.uf_destino = 'EX' then
                                      'Internacional'
                                     else
                                      'Nacional'
                                  end as categoria
                                , oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_controle) as placa_tracao
                                , oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_referencia) as placa_reboque
                                , rf.placa_controle
                                , rf.placa_referencia
                                , rf.num_romaneio
                                , r.classe_id
                                ,(select pa.descricao
                                     from cep.municipio mr
                                    inner join cep.pais pa
                                       on mr.pais_id = pa.pais_id
                                    where mr.municipio_id = r.municipio_id) as pais
                                <cfif Len(Trim(arguments.GRUPO_CLIENTE)) and not Len(Trim(arguments.TODOS))>
                                , case
                                     when evo.num_evento = 25 and r.classe_id = 10 then
                                        'Fronteira'
                                     else
                                        evs.descricao_resumida
                                  end as status
                                <cfelse>
                                , (select case when evo.num_evento = 25 and r.classe_id = 10 then
                                            'Fronteira'
                                          else
                                            nvl(evs.descricao_resumida, 'Vazio')
                                          end
                                     from oper.v$evento_operacao evo
                                    inner join oper.v$evento_operacao_setup evs
                                       on evs.num_evento = evo.num_evento
                                    where evo.controle_evo_id = rf.roo_evo_id) as status
                                </cfif>
                                , rf.uf_origem
                                , rf.uf_destino
                             from oper.v$rank_frota rf
                             left join oper.v$referencia r
                               on r.referencia_id = rf.referencia_id
                            <cfif Len(Trim(arguments.GRUPO_CLIENTE)) and not Len(Trim(arguments.TODOS))>
                            inner join oper.v$evento_operacao evo
                               on evo.controle_evo_id = rf.roo_evo_id
                            inner join oper.v$evento_operacao_setup evs
                               on evs.num_evento = evo.num_evento
                              and evs.descricao_resumida in ('Carga', 'Descarga', 'Fronteira', 'Viagem')
                            </cfif>
                            <cfif Len(Trim(arguments.GRUPO_CLIENTE))>
                            inner join oper.v$romaneio_item ri
                               on ri.num_romaneio = rf.num_romaneio
                            inner join logistica.v$solicitacao_carga_viagem scv
                               on ri.carga_consolidada_id = scv.carga_consolidada_id
                               or ri.viagem_carga_id = scv.viagem_carga_id
                            inner join logistica.v$solicitacao_carga s
                               on scv.solicitacao_carga_id = s.solicitacao_carga_id
                            inner join oper.v$grupo_logistico_carga glc
                               on glc.cod_pessoa_carga = s.cod_remetente
                            inner join oper.v$grupo_logistico_descarga gld
                               on gld.cod_pessoa_descarga = s.cod_destinatario
                              and gld.grupo_id = glc.grupo_id
                            inner join oper.v$grupo_logistico gl
                               on gl.grupo_id = gld.grupo_id
                            inner join oper.v$grupo_logistico_usuario glu
                               on gl.grupo_id = glu.grupo_id
                              and glu.usuario = user
                            </cfif>
                            where 1 = 1
                              <cfif Len(Trim(arguments.COD_GRUPO))>
                              and rf.cod_grupo in (select vg.cod_grupo
                                                     from oper.v$veiculo_grupo_setup vg
                                                    start with vg.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'",',')#)
                                                   connect by prior vg.cod_grupo = vg.cod_grupo_pai)
                              </cfif>
							  
							  <cfif Len(Trim(arguments.cod_grupo_veiculo))>
                               and (exists (select 1
											  from oper.v$grupo_logistico gl
											  left join oper.v$grupo_logistico_veiculo glv
												on gl.grupo_id = glv.grupo_id
											 where gl.descricao in (#ListQualify(arguments.cod_grupo_veiculo,"'",',')#)
											   and (gl.somente_veiculos = 0)
										    )
								 or exists (select 1
											  from oper.v$grupo_logistico gl
											  left join oper.v$grupo_logistico_veiculo glv
												on gl.grupo_id = glv.grupo_id
											 where gl.descricao in (#ListQualify(arguments.cod_grupo_veiculo,"'",',')#)
											   and glv.placa in (rf.placa_controle, rf.placa_referencia)
											   and gl.somente_veiculos = 1
										    )
								or not exists (select 1
										         from oper.v$grupo_logistico gl											     
											    where gl.descricao in (#ListQualify(arguments.cod_grupo_veiculo,"'",',')#)
										       )
									)
                              </cfif>
							  
							  
							  
                              and (rf.engatada = 1 or (rf.engatada = 0 and rf.placa_referencia is null))) e
                    where 1 = 1
                    <cfif Len(Trim(arguments.FILTRO))>
                      and (e.placa_tracao = upper('#arguments.FILTRO#') or
                           e.placa_reboque = upper('#arguments.FILTRO#') or
                           e.placa_controle = replace(upper('#arguments.FILTRO#'),'-','') or
                           e.placa_referencia = replace(upper('#arguments.FILTRO#'),'-','') or
                           (select kss.fnc_concat_all(distinct kss.to_concat_expr(c.num_conhecimento,'/')) as conhecimento
                              from fiscal.v$conhecimento c
                              where c.num_romaneio = e.num_romaneio) like '%#arguments.FILTRO#%' or
                           (select kss.fnc_concat_all(distinct kss.to_concat_expr(nf.ordem_compra_cliente,'/')) as pedido
                              from fiscal.v$conhecimento c
                             inner join fiscal.v$conhecimento_nota_fiscal nf
                                on nf.conhecimento_id = c.conhecimento_id
                             where c.num_romaneio = e.num_romaneio
                               and nf.ordem_compra_cliente is not null) like '%#arguments.FILTRO#%' or
                           (select kss.fnc_concat_all(distinct kss.to_concat_expr(nf.numero,'/')) as numero
                              from fiscal.v$conhecimento c
                             inner join fiscal.v$conhecimento_nota_fiscal nf
                                on nf.conhecimento_id = c.conhecimento_id
                             where c.num_romaneio = e.num_romaneio
                               and nf.ordem_compra_cliente is not null) like '%#arguments.FILTRO#%' or
                           to_char(e.num_romaneio) = '#arguments.FILTRO#'
                          )
                   </cfif>) b
             group by b.situacao
             order by b.situacao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca detalhamento por grupo de controle
	-- GUTO  11/07/2012
	--->
	<cffunction name="get_detalhamento_grupo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_grupo" required="no" default="">
		<cfargument name="cod_grupo_veiculo" required="no" default="">
    	<cfargument name="grupo_cliente" required="no" default="">
    	<cfargument name="todos" required="no" default="">
    	<cfargument name="filtro" required="no" default="">
    	<cfargument name="origem" required="no" default="Solicitao">
    	<cfargument name="mostra_status" required="no" default="">
	    <cfscript>
			qrGrupo = this.get_grupo_corrente();
		</cfscript>
		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
	    select situacao
		    , total_veiculos
			, ordem_situacao
			, nome_motorista
			, nac_trajeto_concluido
			, nac_km_trajeto
			, nac_percentual_executado
			, nac_referencia_destino
			, nac_distancia_destino
			, nac_trajeto
			, data_lib_fronteira
			, data_chegada_fronteira
			, obs_fronteira
			, tempo_fronteira
			, nac_previsao_chegada
			, int_trajeto_concluido
			, int_km_trajeto
			, int_percentual_executado
			, int_referencia_destino
			, int_distancia_destino
			, int_trajeto
			, int_previsao_chegada
			, num_romaneio
			, tipo
			, categoria
			, pais
			, placa_tracao
			, placa_reboque
			, placa_controle
			, placa_referencia
			, carreta_2
			, cod_grupo
			, classe_id
			, referencia
			, status
			, tempo
			, distancia
			, rank_frota_id
			, latitude
			, longitude
			, ctrl_tempo
			, distancia_destino
			, tempo_evento
			, data_inicio
			, data_termino
			, origem
			, destino
			, cliente
			, status_tempo
			, direcao_frete
			, rumo
			, destino_ordem
			, possui_fronteira
			, conhecimento
			, ordem_compra_cliente
			, numero_nf_cliente
			, carregamento
			, nac_tt_programado_rota
			, int_tt_programado_rota
			, nac_no_prazo
			, nac_data_tt_programado
			, nac_tt_programado
			, nac_data_tt_executado
			, nac_tt_executado
			, nac_tt_executado_horas
			, nac_tt_programado_horas
			, nac_tt_status_atual
			, int_no_prazo
			, int_data_tt_programado
			, int_tt_programado
			, int_data_tt_executado
			, int_tt_executado
			, int_tt_executado_horas
			, int_tt_programado_horas
			, int_tt_status_atual

        from xmltable('/painel/arrayItem' passing oper.pkg_grupo_logistico_backend.fnc_get_painel_grupo(
			
			xmltype('<params>' ||

			<cfif Len(Trim(arguments.cod_grupo))>
			  '<cod_grupo>#Replace(ListQualify(arguments.cod_grupo,"''",','),'&', '&amp;', 'all')#</cod_grupo>' ||
			</cfif>
			
			<cfif Len(Trim(arguments.cod_grupo_veiculo))>
			  '<cod_grupo_veiculo>#Replace(ListQualify(arguments.cod_grupo_veiculo,"''",','),'&', '&amp;', 'all')#</cod_grupo_veiculo>' ||
			</cfif>
			
			<cfif Len(Trim(arguments.mostra_status))>
			   '<mostra_status>#ListQualify(arguments.mostra_status,"''",',')#</mostra_status>'  ||
			</cfif>

		    <cfif len(trim(arguments.grupo_cliente))>
			  '<grupo_cliente>#Replace(arguments.grupo_cliente,'&', '&amp;', 'all')#</grupo_cliente>'  ||
			</cfif>

            <cfif len(trim(arguments.todos))>
			  '<todos>#arguments.todos#</todos>'  ||
			</cfif>
			
		    <cfif len(trim(arguments.origem))>
			  '<origem>#arguments.origem#</origem>' ||
			</cfif>

			<cfif len(trim(arguments.filtro))>
			  '<filtro>#arguments.filtro#</filtro>'  ||
			</cfif>

			'</params>')				
			) 
                columns
				  situacao							varchar2(4000)   path	'/arrayItem/situacao'
				, total_veiculos 					varchar2(4000)   path '/arrayItem/total_veiculos'
				, ordem_situacao 					varchar2(4000)   path '/arrayItem/ordem_situacao'
				, nome_motorista 					varchar2(4000)   path '/arrayItem/nome_motorista'
				, nac_trajeto_concluido 			varchar2(4000)   path '/arrayItem/nac_trajeto_concluido'
				, nac_km_trajeto 					varchar2(4000)   path '/arrayItem/nac_km_trajeto'
				, nac_percentual_executado 			varchar2(4000)   path '/arrayItem/nac_percentual_executado'
				, nac_referencia_destino 			varchar2(4000)   path '/arrayItem/nac_referencia_destino'
				, nac_distancia_destino 			varchar2(4000)   path '/arrayItem/nac_distancia_destino'
				, nac_trajeto 						varchar2(4000)   path '/arrayItem/nac_trajeto'
				, data_lib_fronteira 				varchar2(4000)   path '/arrayItem/data_lib_fronteira'
				, data_chegada_fronteira 			varchar2(4000)   path '/arrayItem/data_chegada_fronteira'
				, obs_fronteira 					varchar2(4000)   path '/arrayItem/obs_fronteira'
				, tempo_fronteira 					varchar2(4000)   path '/arrayItem/tempo_fronteira'
				, nac_previsao_chegada 				varchar2(4000)   path '/arrayItem/nac_previsao_chegada'
				, int_trajeto_concluido 			varchar2(4000)   path '/arrayItem/int_trajeto_concluido'
				, int_km_trajeto 					varchar2(4000)   path '/arrayItem/int_km_trajeto'
				, int_percentual_executado 			varchar2(4000)   path '/arrayItem/int_percentual_executado'
				, int_referencia_destino 			varchar2(4000)   path '/arrayItem/int_referencia_destino'
				, int_distancia_destino 			varchar2(4000)   path '/arrayItem/int_distancia_destino'
				, int_trajeto 						varchar2(4000)   path '/arrayItem/int_trajeto'
				, int_previsao_chegada 				varchar2(4000)   path '/arrayItem/int_previsao_chegada'
				, num_romaneio 						varchar2(4000)   path '/arrayItem/num_romaneio'
				, tipo 								varchar2(4000)   path '/arrayItem/tipo'
				, categoria 						varchar2(4000)   path '/arrayItem/categoria'
				, pais 								varchar2(4000)   path '/arrayItem/pais'
				, placa_tracao 						varchar2(4000)   path '/arrayItem/placa_tracao'
				, placa_reboque 					varchar2(4000)   path '/arrayItem/placa_reboque'
				, placa_controle 					varchar2(4000)   path '/arrayItem/placa_controle'
				, placa_referencia 					varchar2(4000)   path '/arrayItem/placa_referencia'
				, carreta_2 						varchar2(4000)   path '/arrayItem/carreta_2'
				, cod_grupo 						varchar2(4000)   path '/arrayItem/cod_grupo'
				, classe_id 						varchar2(4000)   path '/arrayItem/classe_id'
				, referencia 						varchar2(4000)   path '/arrayItem/referencia'
				, status 							varchar2(4000)   path '/arrayItem/status'
				, tempo 							varchar2(4000)   path '/arrayItem/tempo'
				, distancia 						varchar2(4000)   path '/arrayItem/distancia'
				, rank_frota_id 					varchar2(4000)   path '/arrayItem/rank_frota_id'
				, latitude 							varchar2(4000)   path '/arrayItem/latitude'
				, longitude 						varchar2(4000)   path '/arrayItem/longitude'
				, ctrl_tempo 						varchar2(4000)   path '/arrayItem/ctrl_tempo'
				, distancia_destino 				varchar2(4000)   path '/arrayItem/distancia_destino'
				, tempo_evento 						varchar2(4000)   path '/arrayItem/tempo_evento'
				, data_inicio 						varchar2(4000)   path '/arrayItem/data_inicio'
				, data_termino 						varchar2(4000)   path '/arrayItem/data_termino'
				, origem 							varchar2(4000)   path '/arrayItem/origem'
				, destino 							varchar2(4000)   path '/arrayItem/destino'
				, cliente 							varchar2(4000)   path '/arrayItem/cliente'
				, status_tempo 						varchar2(4000)   path '/arrayItem/status_tempo'
				, direcao_frete 					varchar2(4000)   path '/arrayItem/direcao_frete'
				, rumo 								varchar2(4000)   path '/arrayItem/rumo'
				, destino_ordem 					varchar2(4000)   path '/arrayItem/destino_ordem'
				, possui_fronteira 					varchar2(4000)   path '/arrayItem/possui_fronteira'
				, conhecimento 						varchar2(4000)   path '/arrayItem/conhecimento'
				, ordem_compra_cliente 				varchar2(4000)   path '/arrayItem/ordem_compra_cliente'
				, numero_nf_cliente 				varchar2(4000)   path '/arrayItem/numero_nf_cliente'
				, carregamento 						varchar2(4000)   path '/arrayItem/carregamento'
				, nac_tt_programado_rota 			varchar2(4000)   path '/arrayItem/nac_tt_programado_rota'
				, int_tt_programado_rota 			varchar2(4000)   path '/arrayItem/int_tt_programado_rota'
				, nac_no_prazo 						varchar2(4000)   path '/arrayItem/nac_no_prazo'
				, nac_data_tt_programado 			varchar2(4000)   path '/arrayItem/nac_data_tt_programado'
				, nac_tt_programado 				varchar2(4000)   path '/arrayItem/nac_tt_programado'
				, nac_data_tt_executado 			varchar2(4000)   path '/arrayItem/nac_data_tt_executado'
				, nac_tt_executado 					varchar2(4000)   path '/arrayItem/nac_tt_executado'
				, nac_tt_executado_horas 			varchar2(4000)   path '/arrayItem/nac_tt_executado_horas'
				, nac_tt_programado_horas        	varchar2(4000)   path '/arrayItem/nac_tt_programado_horas'
				, nac_tt_status_atual            	varchar2(4000)   path '/arrayItem/nac_tt_status_atual'
				, int_no_prazo                   	varchar2(4000)   path '/arrayItem/int_no_prazo'
				, int_data_tt_programado         	varchar2(4000)   path '/arrayItem/int_data_tt_programado'
				, int_tt_programado              	varchar2(4000)   path '/arrayItem/int_tt_programado'
				, int_data_tt_executado 		 	varchar2(4000)   path '/arrayItem/int_data_tt_executado'
				, int_tt_executado 					varchar2(4000)   path '/arrayItem/int_tt_executado'
				, int_tt_executado_horas 			varchar2(4000)   path '/arrayItem/int_tt_executado_horas'
				, int_tt_programado_horas 			varchar2(4000)   path '/arrayItem/int_tt_programado_horas'
				, int_tt_status_atual 				varchar2(4000)   path '/arrayItem/int_tt_status_atual'
      )
	  order by ordem_situacao,situacao
		</cfquery>
		
		<cfreturn qr_result>
	</cffunction>

	<!---
    -- PROPSITO
    -- Busca parametros do painel
    -- 17/07/2012 - criado
    --->
    <cffunction name="get_parametros_painel" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="rank_frota_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_ATUALIZACAO') as tempo_atualizacao
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA') as tempo_fronteira
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_FRONTEIRA')*60,4).retorno as tempo_fronteira_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA') as tempo_carga
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_CARGA')*60,4).retorno as tempo_carga_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA') as tempo_descarga
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_DESCARGA')*60,4).retorno as tempo_descarga_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO') as tempo_vazio_destinado
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VAZIO_DESTINADO')*60,4).retorno as tempo_vazio_dest_formatado
                  ,gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM') as tempo_viagem
                   ,kss.to_tempo(gerencial.pkg_gerencial.fnc_valor_numerico('TEMPO_VIAGEM')*60,4).retorno as tempo_viagem_formatado
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPSITO
    -- Busca grupos de controle
    -- 13/12/2008 - criado
    --->
    <cffunction name="get_grupos" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vg.cod_grupo, vg.descricao
              from oper.v$veiculo_grupo_setup vg
             where vg.situacao_id = 1
             order by vg.cod_grupo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
	-- PROPSITO
	-- Busca valor do parmetro tipo lista na nova estrutura
	-- JAQUELINEF 24/02/2015
	--->
	<cffunction name="get_parametro_lista" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_lista('#arguments.identificador#') valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

<!--- 
    -- PROPSITO
    -- Busca carretas desengatadas
    --->
    <cffunction name="get_detalhamento_carretas" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_grupo" required="no" default="">
    	<cfargument name="FILTRO" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rf.placa_referencia, oper.pkg_veiculo.fnc_get_cod_veiculo(rf.placa_referencia) as cod_veiculo,
                   count(rf.placa_referencia) over(partition by nvl(vg.cod_grupo,'GERAL') order by nvl(vg.cod_grupo,'GERAL')) as qtde_grupo,
                   count(rf.placa_referencia) over(partition by rf.filial_mais_proxima order by rf.filial_mais_proxima) as qtde_filial,
                   eo.local as referencia,
                   case
                      when (select count(*)
                              from oper.v$rank_frota rf2
                              inner join oper.v$referencia re2
                              on re2.referencia_id = rf2.referencia_id
                              where re2.latitude = eo.latitude) > 1 then eo.latitude + (dbms_random.value(0,1)/1000)
                   else eo.latitude end latitude,
                   eo.longitude,
                   to_char(rf.data_hora_desengate,'dd/mm/yyyy hh24:mi') as data_hora_desengate ,
                   kss.to_tempo((sysdate-rf.data_hora_desengate)*1440,1).retorno as tempo_parado,
                   rf.filial_mais_proxima, nvl((select sum(c.total_conhecimento - c.valor_icms)
                                             from fiscal.v$conhecimento c
                                            where c.data_emissao >= trunc(sysdate,'month')
                                              and c.conhecimento_tipo_id <> 6
                                              and c.cancelado is null
                                              and c.placa = rf.placa_referencia),0) as faturamento,
                   rf.uf_atual, nvl(evs.descricao_resumida, 'Vazio') status, nvl(vg.cod_grupo,'GERAL') as cod_grupo,
                   va.descricao as agrupamento, vtc.descricao as classificacao, vma.marca, vm.modelo
                ,(select p.razao_social
                   from kss.v$pessoa p
                  where p.cod_pessoa = rf.cod_pessoa) as nome_motorista
              from oper.v$rank_frota rf
             inner join oper.v$veiculo v
                     on v.placa = rf.placa_referencia
             inner join oper.v$veiculo_hist_situacao_atual vhsa
                     on vhsa.placa = v.placa
                    and vhsa.situacao_id <> 0
             inner join oper.v$veiculo_modelo vm
                     on vm.modelo_id = v.modelo_id
             inner join oper.v$veiculo_marca vma
                     on vma.marca_id = v.marca_id
             inner join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
             inner join oper.v$veiculo_modalidade_atual vmo
                     on vmo.placa = v.placa
                    and vmo.modalidade <> 'TERCEIRO'
             left join oper.v$evento_operacao eo
                     on eo.controle_evo_id = rf.evo_id_desengate
              left join oper.v$veiculo_grupo vg
                     on vg.placa = v.placa
                    and sysdate between vg.data_inicio and nvl(vg.data_termino,sysdate)
              left join oper.v$evento_operacao evo
                     on evo.controle_evo_id = rf.roo_evo_id
              left join oper.v$evento_operacao_setup evs
                     on evs.num_evento = evo.num_evento
             where rf.placa_referencia is not null
               and rf.engatada = 0
			  <cfif Len(Trim(arguments.FILTRO))>
                and (rf.placa_reboque = upper('#arguments.FILTRO#') or
                     rf.placa_referencia = replace(upper('#arguments.FILTRO#'),'-','') or
                     to_char(rf.num_romaneio) = '#arguments.FILTRO#'
                     )
              </cfif>
               <cfif Len(Trim(arguments.cod_grupo)) >
                    and vg.cod_grupo in (select vg2.cod_grupo
                                           from oper.v$veiculo_grupo_setup vg2
                                          start with vg2.cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'",',')#)
                                         connect by prior vg2.cod_grupo = vg2.cod_grupo_pai)
               </cfif>
			   order by vg.cod_grupo, (sysdate-rf.data_hora_desengate)*1440 desc, rf.filial_mais_proxima
               
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

</cfcomponent>
