<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as notas fiscais do conhecimento
	-- CRISTOFER  06/12/2006
	--->		
	<cffunction name="get_conhecimento_nota_fiscal" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cnf.conhecimento_id,
				   cnf.numero,
				   cnf.data_emissao,
				   to_char(cnf.data_emissao,'dd/mm/yyyy') data_emissao_data,
				   cnf.modelo,
				   cnf.serie,
				   cnf.sub_serie,
				   cnf.valor_total,
				   cnf.user_insert,
				   cnf.date_insert,
				   cnf.user_update,
				   cnf.date_update,
				   cnf.site,
				   cnf.valor_segurado,
				   cnf.ordem_compra_cliente,
				   cnf.peso,
				   to_char(fiscal.pkg_fiscal.fnc_converte_peso(cnf.peso,cnf.cod_unidade,'Kg')) peso_kg_convertido,
				   cnf.peso_cubado,
				   cnf.peso_cobrado,
				   cnf.qtde_volume,
				   cnf.altura,
				   cnf.comprimento,
				   cnf.largura,
				   cnf.m3,
				   cnf.cubagem,
				   cnf.num_natureza,
				   nat.descricao natureza,
				   cnf.complemento,
				   cnf.num_especie,
				   esp.descricao especie,
				   cnf.cod_unidade,
				   cnf.premio_seguro_rctrc,
				   cnf.premio_seguro_rcfdc,
				   cnf.premio_seguro_rr,
                   (select cc.carga_id
                      from oper.v$carga_ctrc cc
                     where cc.conhecimento_id = cnf.conhecimento_id
                       and cc.num_nota_id = cnf.numero) as carga_id 
			  from fiscal.v$conhecimento_nota_fiscal cnf
			  left join oper.v$especie esp
					 on esp.num_especie = cnf.num_especie
			  left join oper.v$natureza nat
					 on nat.num_natureza = cnf.num_natureza
			 where 1=1
			   and cnf.conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
</cfcomponent>