<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de clientes" extends="_transportes.funcoes.cfc_init">
  <!---
  -- PROPSITO
  -- Busca o grupo do usuario corrente
  -- NOTAS EXPLICATIVAS
  -- CRISTOFER  13/02/2006
  --->
  <cffunction name="get_grupo_corrente" access="remote" returntype="query" output="true">
    <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      select grupo_id, somente_veiculos, remetente_definido, destinatario_definido
          from oper.v$grupo_logistico_user
    </cfquery>
    <cfreturn qr_grupo>
  </cffunction>

  <!---
  -- PROPSITO
  -- Busca o rank do cliente
  -- NOTAS EXPLICATIVAS
  -- ANDERSON 04/04/2012
  --->
  <cffunction name="get_rank_cliente" access="remote" returntype="query" output="true">
    <cfquery name="qr_rank" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      select t.rank_frota_id
                 , t.num_evento
                 , t.status
                 , t.cod_grupo
                 , t.placa_controle
                 , t.placa_tracao
                 , t.placa_reboque
                 , t.placa_reboque_placa
                 , t.carreta2 as placa_carreta_2
             , (select sign(count(1)) from oper.v$veiculo_ctrl_composicao vcar where vcar.tipo_carroceria1_id = t.tipo_carroceria_carreta1) as permite_engate_carreta1
                 , t.carretas
                 , t.carreta2
             , decode(carretas,'',decode(t.placa_reboque,'',0,1),regexp_count(carretas, '\|') + 2) quantidade_carretas
                 , t.notas_fiscais
                 , t.num_romaneio
                 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(to_char(n.descricao), ' / '))
                      from oper.v$romaneio r
                     inner join oper.v$romaneio_item ri
                             on ri.num_romaneio = r.num_romaneio
                     inner join logistica.v$operacao_natureza opn
                             on opn.operacao_id = ri.operacao_id
                     inner join oper.v$natureza n
                             on n.num_natureza = opn.num_natureza
                            and n.num_natureza = r.num_natureza
                     where r.num_romaneio = t.num_romaneio
                   ) as mercadoria
                 , t.segundos_tempo_evento
                 , t.tempo_evento
                 , to_char(t.data_evento, 'dd/mm/yyyy hh24:mi:ss') as data_evento
                 , t.segundos
                 , t.tempo
                 , t.cod_funcionario
                 , t.motorista_terceiro
                 , t.distancia
                 , t.referencia
                 , t.latitude
                 , t.longitude
                 , t.carregamento
                 , t.destino
                 , t.cliente
                 , to_char(nvl2(t.data_termino_carga, t.previsao_carregado, t.previsao_vazio), 'dd/mm/yyyy hh24:mi:ss') as previsao_determinada
                 , t.destinatario
                 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(logistica.pkg_operacao.fnc_busca_operacao_pai(o.operacao_id), ','))
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join logistica.v$operacao o
                             on o.operacao_id = sc.operacao_id
                     where v.num_romaneio = t.num_romaneio
                   ) as cliente_logistico
                 , t.operacao_reduzida
                 , to_char(t.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio
                 , t.tempo_viagem
                 , t.ignicao
                 , t.distancia_destino
                 , case
                      when t.distancia_destino is not null then to_char(sysdate + ((t.distancia_destino / 50) / 24), 'dd/mm/yyyy hh24:mi:ss')
                      else ''
                   end as chegada_estimada
                 , case
                      when t.distancia_destino is not null and sysdate + ((t.distancia_destino / 50) / 24) > nvl2(t.data_termino_carga, t.previsao_carregado, t.previsao_vazio) then 1
                      else 0
                   end as atrasado
                 , to_char(t.data_ultima_posicao, 'dd/mm/yyyy hh24:mi:ss') as data_ultima_posicao
                 , t.engatada
                 , t.status_id
                 , t.fracionado
              from (select distinct
                     ct.rank_frota_id
                         , ct.num_evento
                         , ct.status
                         , ct.cod_grupo
                         , ct.placa_controle
                         , ct.placa_tracao
                         , ct.placa_referencia
                         , ct.placa_reboque
                         , (select distinct vdi.tipo_carroceria_id from oper.v$veiculo_dados vdi where vdi.placa = ct.placa_referencia) as tipo_carroceria_carreta1
                         , replace(ltrim(rtrim(oper.pkg_veiculo.FNC_COMPOSICAO_BACKWARD(ct.placa_controle),'|'),'|'),'|','/') as carretas
                         , ct.rastreador_id
                         , (select kss.fnc_concat_all(kss.to_concat_expr(cnt.numero, ','))
                              from fiscal.v$conhecimento c
                             inner join fiscal.v$conhecimento_nota_fiscal cnt
                                     on cnt.conhecimento_id = c.conhecimento_id
                             where c.num_romaneio = ct.num_romaneio
                               and rownum <= 2
                           ) as notas_fiscais
                         , ct.num_romaneio
                         , ct.segundos_tempo_evento
                         , ct.tempo_evento
                         , ct.data_evento
                         , ct.segundos
                         , ct.tempo
                         , nvl(ct.cod_funcionario, ct.cod_pessoa) as cod_funcionario
                         , decode(ct.cod_funcionario,null,1,0) as motorista_terceiro
                         , ct.distancia
                         , ct.referencia
                         , ct.latitude
                         , ct.longitude
                         , ct.carregamento
                         , ct.destino
                         , ct.cliente
                         , ct.placa_tracao as placa_reboque_placa
                         , (select max(r.data_previsao)
                              from oper.v$romaneio_itinerario r
                             where r.num_romaneio = ct.num_romaneio
                               and r.vazio_carregado = 0
                           ) as previsao_vazio
                         , (select max(r.data_previsao)
                              from oper.v$romaneio_itinerario r
                             where r.num_romaneio = ct.num_romaneio
                               and r.vazio_carregado = 1
                           ) as previsao_carregado
                         , case
                              when ct.num_evento = 1 and ct.destinatario is null then
                                 'Retornando com' ||
                                 (select to_char(evd.valor, '000')
                                    from oper.v$evento_operacao_dado evd
                                   where evd.controle_evo_id = ct.roo_evo_id
                                     and evd.dado_id = 14
                                 ) ||
                                 ' Embalagens/Paletes'
                              else ct.destinatario
                           end as destinatario
                         , case ct.num_evento
                              when 100 then 1
                              when 1   then 1
                              when 2   then 2
                              when 3   then 3
                              when 4   then 4
                              when 8   then 4
                              else 5
                           end status_id
                         , ct.data_inicio
                         , nvl2(ct.data_inicio, oper.pkg_global.fnc_tempo_formatado((sysdate - ct.data_inicio) * 86400), null) as tempo_viagem
                         , p.ignicao
                         , case
                              when ct.num_evento = 100 then
                                 (select max(cep.pkg_coord_geografica.fnc_haversine2(p.latitude, p.longitude, rf.latitude, rf.longitude)) * 1.2
                                    from oper.v$romaneio r
                                   inner join oper.v$romaneio_item ri
                                           on ri.num_romaneio = r.num_romaneio
                                   inner join cep.municipio m
                                           on m.municipio_id = ri.rem_municipio_id
                                   inner join oper.v$referencia rf
                                           on rf.referencia_id = m.referencia_id
                                   where r.num_romaneio = ct.num_romaneio
                                 )
                              when ct.num_evento = 3 then
                                 (select max(cep.pkg_coord_geografica.fnc_haversine2(p.latitude, p.longitude, rf.latitude, rf.longitude)) * 1.2
                                    from oper.v$romaneio r
                                   inner join oper.v$romaneio_item ri
                                           on ri.num_romaneio = r.num_romaneio
                                   inner join cep.municipio m
                                           on m.municipio_id = ri.dest_municipio_id
                                   inner join oper.v$referencia rf
                                           on rf.referencia_id = m.referencia_id
                                   where r.num_romaneio = ct.num_romaneio
                                 )
                              else null
                           end as distancia_destino
                         , vpa.data_ultima_posicao
                         , ct.engatada
                         , ct.segunda_carreta as carreta2
                         , decode(ct.fracionado,1,'Sim','No') as fracionado
                         , ct.operacao_reduzida
             , ct.data_termino_carga
                      from oper.v$controle_trafego ct
                      left join oper.v$veiculo_posicao_atual vpa
                        on vpa.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id(ct.placa_controle)
                      left join oper.v$posicao p
                        on p.posicao_id = vpa.posicao_id
                     inner join oper.v$romaneio_item ri
                  on ri.num_romaneio = ct.num_romaneio
               inner join logistica.v$carga_consolidada_carga ccc
                  on ccc.carga_consolidada_id = ri.carga_consolidada_id
               inner join logistica.v$solicitacao_carga s
                  on s.solicitacao_carga_id = ccc.solicitacao_carga_id
                left join oper.v$grupo_logistico_carga glc
                  on glc.cod_pessoa_carga = s.cod_remetente
                left join oper.v$grupo_logistico_descarga gld
                  on gld.cod_pessoa_descarga = s.cod_destinatario
                left join oper.v$grupo_logistico_operacao glo
                  on glo.operacao_id = s.operacao_id
               inner join oper.v$grupo_logistico_user gl
                  on ((gl.grupo_id = glc.grupo_id or gl.remetente_definido    = 0) and
                      (gl.grupo_id = gld.grupo_id or gl.destinatario_definido = 0) and
                      (gl.grupo_id = glo.grupo_id or gl.operacao_definida     = 0))
               where ct.possui_rastreador = 1
                 and (gl.somente_veiculos = 0
                       or ri.num_romaneio in (select ct2.num_romaneio
                                                from oper.v$controle_trafego ct2
                                               where ct2.placa_controle in (select glv.placa
                                                                              from oper.v$grupo_logistico_veiculo_user glv)
                                                  or ct2.placa_referencia in (select glv.placa
                                                                                from oper.v$grupo_logistico_veiculo_user glv))
                     )
              union all
              select distinct
                     ct.rank_frota_id
                         , ct.num_evento
                         , ct.status
                         , ct.cod_grupo
                         , ct.placa_controle
                         , ct.placa_tracao
                         , ct.placa_referencia
                         , ct.placa_reboque
                         , (select distinct vdi.tipo_carroceria_id from oper.v$veiculo_dados vdi where vdi.placa = ct.placa_referencia) as tipo_carroceria_carreta1
                         , replace(ltrim(rtrim(oper.pkg_veiculo.FNC_COMPOSICAO_BACKWARD(ct.placa_controle),'|'),'|'),'|','/') as carretas
                         , ct.rastreador_id
                         , (select kss.fnc_concat_all(kss.to_concat_expr(cnt.numero, ','))
                              from fiscal.v$conhecimento c
                             inner join fiscal.v$conhecimento_nota_fiscal cnt
                                     on cnt.conhecimento_id = c.conhecimento_id
                             where c.num_romaneio = ct.num_romaneio
                               and rownum <= 2
                           ) as notas_fiscais
                         , ct.num_romaneio
                         , ct.segundos_tempo_evento
                         , ct.tempo_evento
                         , ct.data_evento
                         , ct.segundos
                         , ct.tempo
                         , nvl(ct.cod_funcionario, ct.cod_pessoa) as cod_funcionario
                         , decode(ct.cod_funcionario,null,1,0) as motorista_terceiro
                         , ct.distancia
                         , ct.referencia
                         , ct.latitude
                         , ct.longitude
                         , ct.carregamento
                         , ct.destino
                         , ct.cliente
                         , ct.placa_tracao as placa_reboque_placa
                         , (select max(r.data_previsao)
                              from oper.v$romaneio_itinerario r
                             where r.num_romaneio = ct.num_romaneio
                               and r.vazio_carregado = 0
                           ) as previsao_vazio
                         , (select max(r.data_previsao)
                              from oper.v$romaneio_itinerario r
                             where r.num_romaneio = ct.num_romaneio
                               and r.vazio_carregado = 1
                           ) as previsao_carregado
                         , case
                              when ct.num_evento = 1 and ct.destinatario is null then
                                 'Retornando com' ||
                                 (select to_char(evd.valor, '000')
                                    from oper.v$evento_operacao_dado evd
                                   where evd.controle_evo_id = ct.roo_evo_id
                                     and evd.dado_id = 14
                                 ) ||
                                 ' Embalagens/Paletes'
                              else ct.destinatario
                           end as destinatario
                         , case ct.num_evento
                              when 100 then 1
                              when 1   then 1
                              when 2   then 2
                              when 3   then 3
                              when 4   then 4
                              when 8   then 4
                              else 5
                           end status_id
                         , ct.data_inicio
                         , nvl2(ct.data_inicio, oper.pkg_global.fnc_tempo_formatado((sysdate - ct.data_inicio) * 86400), null) as tempo_viagem
                         , p.ignicao
                         , case
                              when ct.num_evento = 100 then
                                 (select max(cep.pkg_coord_geografica.fnc_haversine2(p.latitude, p.longitude, rf.latitude, rf.longitude)) * 1.2
                                    from oper.v$romaneio r
                                   inner join oper.v$romaneio_item ri
                                           on ri.num_romaneio = r.num_romaneio
                                   inner join cep.municipio m
                                           on m.municipio_id = ri.rem_municipio_id
                                   inner join oper.v$referencia rf
                                           on rf.referencia_id = m.referencia_id
                                   where r.num_romaneio = ct.num_romaneio
                                 )
                              when ct.num_evento = 3 then
                                 (select max(cep.pkg_coord_geografica.fnc_haversine2(p.latitude, p.longitude, rf.latitude, rf.longitude)) * 1.2
                                    from oper.v$romaneio r
                                   inner join oper.v$romaneio_item ri
                                           on ri.num_romaneio = r.num_romaneio
                                   inner join cep.municipio m
                                           on m.municipio_id = ri.dest_municipio_id
                                   inner join oper.v$referencia rf
                                           on rf.referencia_id = m.referencia_id
                                   where r.num_romaneio = ct.num_romaneio
                                 )
                              else null
                           end as distancia_destino
                         , vpa.data_ultima_posicao
                         , ct.engatada
                         , ct.segunda_carreta as carreta2
                         , decode(ct.fracionado,1,'Sim','No') as fracionado
                         , ct.operacao_reduzida
             , ct.data_termino_carga
                      from oper.v$controle_trafego ct
                      left join oper.v$veiculo_posicao_atual vpa
                        on vpa.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id(ct.placa_controle)
                      left join oper.v$posicao p
                        on p.posicao_id = vpa.posicao_id
                     inner join oper.v$romaneio_item ri
                  on ri.num_romaneio = ct.num_romaneio
               inner join logistica.v$viagem_carga vc
                  on vc.viagem_carga_id = ri.viagem_carga_id
               inner join logistica.v$solicitacao_carga s
                  on s.solicitacao_carga_id = vc.solicitacao_carga_id
                left join oper.v$grupo_logistico_carga glc
                  on glc.cod_pessoa_carga = s.cod_remetente
                left join oper.v$grupo_logistico_descarga gld
                  on gld.cod_pessoa_descarga = s.cod_destinatario
                left join oper.v$grupo_logistico_operacao glo
                  on glo.operacao_id = s.operacao_id
               inner join oper.v$grupo_logistico_user gl
                  on ((gl.grupo_id = glc.grupo_id or gl.remetente_definido    = 0) and
                      (gl.grupo_id = gld.grupo_id or gl.destinatario_definido = 0) and
                      (gl.grupo_id = glo.grupo_id or gl.operacao_definida     = 0))
               where ct.possui_rastreador = 1
                 and (gl.somente_veiculos = 0
                       or ri.num_romaneio in (select ct2.num_romaneio
                                                from oper.v$controle_trafego ct2
                                               where ct2.placa_controle in (select glv.placa
                                                                              from oper.v$grupo_logistico_veiculo_user glv)
                                                  or ct2.placa_referencia in (select glv.placa
                                                                                from oper.v$grupo_logistico_veiculo_user glv))
                     )
                 )t
             order by t.status_id
      </cfquery>
    <cfreturn qr_rank>
  </cffunction>

    <!---
    -- PROPSITO
    -- Retorna os veculos e as posies no mapa
    -- ANDERSON 15/03/2012 - CRIADO
    --->
    <cffunction name="get_veiculos_mapa" access="remote" returntype="query" output="true">
      <cfargument name="rank_frota_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.rank_frota_id
                 , t.status
                 , t.placa_tracao
                 , t.placa_reboque
                 , t.cod_funcionario
                 , t.funcionario
                 , t.funcionario_celular
                 , t.funcionario
                 , t.referencia
                 , t.latitude
                 , t.longitude
                 , t.carregamento
                 , t.destino
                 , t.distancia_destino
                 , case
                      when t.distancia_destino is not null then to_char(sysdate + ((t.distancia_destino / 50) / 24), 'dd/mm/yyyy hh24:mi:ss')
                      else ''
                   end as chegada_estimada
              from (select ct.rank_frota_id
                         , ct.status
                         , ct.placa_controle
                         , ct.placa_tracao
                         , ct.placa_referencia
                         , ct.placa_reboque
                         , ct.num_romaneio
                         , ct.cod_funcionario
                         , (select fd.nome_completo
                              from oper.v$funcionario_dados fd
                             where fd.cod_pessoa = ct.cod_pessoa
                           ) as funcionario
                         , (select fd.num_celular
                              from oper.v$funcionario_dados fd
                             where fd.cod_pessoa = ct.cod_pessoa
                           ) as funcionario_celular
                         , ct.referencia
                         , ct.latitude
                         , ct.longitude
                         , ct.carregamento
                         , ct.destino
                         , case
                              when ct.num_evento = 100 then
                                 (select max(cep.pkg_coord_geografica.fnc_haversine2(p.latitude, p.longitude, rf.latitude, rf.longitude)) * 1.2
                                    from oper.v$romaneio r
                                   inner join oper.v$romaneio_item ri
                                           on ri.num_romaneio = r.num_romaneio
                                   inner join cep.municipio m
                                           on m.municipio_id = ri.rem_municipio_id
                                   inner join oper.v$referencia rf
                                           on rf.referencia_id = m.referencia_id
                                   where r.num_romaneio = ct.num_romaneio
                                 )
                              when ct.num_evento = 3 then
                                 (select max(cep.pkg_coord_geografica.fnc_haversine2(p.latitude, p.longitude, rf.latitude, rf.longitude)) * 1.2
                                    from oper.v$romaneio r
                                   inner join oper.v$romaneio_item ri
                                           on ri.num_romaneio = r.num_romaneio
                                   inner join cep.municipio m
                                           on m.municipio_id = ri.dest_municipio_id
                                   inner join oper.v$referencia rf
                                           on rf.referencia_id = m.referencia_id
                                   where r.num_romaneio = ct.num_romaneio
                                 )
                              else null
                           end as distancia_destino
                      from oper.v$controle_trafego ct
                      left join oper.v$veiculo_posicao_atual vpa
                             on vpa.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id(ct.placa_controle)
                      left join oper.v$posicao p
                             on p.posicao_id = vpa.posicao_id
                     where ct.possui_rastreador = 1
          <cfif Len(Trim(arguments.rank_frota_id))>
                       and ct.rank_frota_id = #arguments.rank_frota_id#
          </cfif>
                         and (exists (select 1
                                 from oper.v$romaneio_item ri
                                inner join logistica.v$carga_consolidada_carga ccc
                                   on ccc.carga_consolidada_id = ri.carga_consolidada_id
                                inner join logistica.v$solicitacao_carga s
                                   on s.solicitacao_carga_id = ccc.solicitacao_carga_id
                                 left join oper.v$grupo_logistico_carga glc
                                   on glc.cod_pessoa_carga = s.cod_remetente
                                 left join oper.v$grupo_logistico_descarga gld
                                   on gld.cod_pessoa_descarga = s.cod_destinatario
                                 left join oper.v$grupo_logistico_operacao glo
                                   on glo.operacao_id = s.operacao_id
                                inner join oper.v$grupo_logistico_user gl
                            on ((gl.grupo_id = glc.grupo_id or gl.remetente_definido    = 0) and
                                (gl.grupo_id = gld.grupo_id or gl.destinatario_definido = 0) and
                                (gl.grupo_id = glo.grupo_id or gl.operacao_definida     = 0))
                                where ri.num_romaneio = ct.num_romaneio
                                  and (ri.num_romaneio in (select ct2.num_romaneio
                                                             from oper.v$controle_trafego ct2
                                                            where ct2.placa_controle in
                                                                  (select glv.placa
                                                                     from oper.v$grupo_logistico_veiculo_user glv)
                                                               or ct2.placa_referencia in
                                                                  (select glv.placa
                                                                     from oper.v$grupo_logistico_veiculo_user glv))
                                       or gl.somente_veiculos = 0))
                        or 
                        exists (select 1
                                   from oper.v$romaneio_item ri
                                  inner join logistica.v$viagem_carga vc
                                     on vc.viagem_carga_id = ri.viagem_carga_id
                                  inner join logistica.v$solicitacao_carga s
                                     on s.solicitacao_carga_id = vc.solicitacao_carga_id
                                   left join oper.v$grupo_logistico_carga glc
                                     on glc.cod_pessoa_carga = s.cod_remetente
                                   left join oper.v$grupo_logistico_descarga gld
                                     on gld.cod_pessoa_descarga = s.cod_destinatario
                                   left join oper.v$grupo_logistico_operacao glo
                                     on glo.operacao_id = s.operacao_id
                                  inner join oper.v$grupo_logistico_user gl
                              on ((gl.grupo_id = glc.grupo_id or gl.remetente_definido    = 0) and
                                  (gl.grupo_id = gld.grupo_id or gl.destinatario_definido = 0) and
                                  (gl.grupo_id = glo.grupo_id or gl.operacao_definida     = 0))
                                  where ri.num_romaneio = ct.num_romaneio
                                    and (ri.num_romaneio in (select ct2.num_romaneio
                                                               from oper.v$controle_trafego ct2
                                                              where ct2.placa_controle in
                                                                    (select glv.placa
                                                                       from oper.v$grupo_logistico_veiculo_user glv)
                                                                 or ct2.placa_referencia in
                                                                    (select glv.placa
                                                                       from oper.v$grupo_logistico_veiculo_user glv))
                                         or gl.somente_veiculos = 0))
                          )
                         ) t
             order by t.placa_tracao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Retorna as unidades de carga e descarga
    -- ANDERSON 15/03/2012 - CRIADO
    --->
    <cffunction name="get_unidades_carga_descarga" access="remote" returntype="query" output="true">
        <cfscript>
      qrGrupo = this.get_grupo_corrente();
    </cfscript>
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.cod_pessoa
                 , t.identificador
                 , t.razao_social
                 , t.cliente
                 , t.endereco_completo
                 , t.latitude
                 , t.longitude
                 , nvl(
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_controle) || '->' || oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_referencia), ' / '))
                          from oper.v$romaneio_carga rc
                         inner join oper.v$romaneio_item ri
                                 on ri.num_romaneio = rc.num_romaneio
                         inner join oper.v$romaneio_hist_veiculo rhv
                                 on rhv.num_romaneio = rc.num_romaneio
                                and rhv.data_termino is null
                         where ri.cod_remetente = t.cod_pessoa
                           and rc.termino_carga is null
            <cfif qrGrupo.SOMENTE_VEICULOS eq 1>
                           and (rhv.placa_controle in (select glv.placa
                                                         from oper.v$grupo_logistico_veiculo_user glv
                                                      )
                                or rhv.placa_referencia in (select glv.placa
                                                              from oper.v$grupo_logistico_veiculo_user glv
                                                           )
                               )
            </cfif>
                       ), 'Nenhum veculo em carga'
                      ) as veiculos_carregamento
                 , nvl(
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_controle) || '->' || oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_referencia), ' / '))
                          from oper.v$romaneio_descarga rd
                         inner join oper.v$romaneio_item ri
                                 on ri.num_romaneio = rd.num_romaneio
                         inner join oper.v$romaneio_hist_veiculo rhv
                                 on rhv.num_romaneio = rd.num_romaneio
                                and rhv.data_termino is null
                         where ri.cod_destinatario = t.cod_pessoa
                           and rd.termino_descarga is null
            <cfif qrGrupo.SOMENTE_VEICULOS eq 1>
                           and (rhv.placa_controle in (select glv.placa
                                                         from oper.v$grupo_logistico_veiculo_user glv
                                                      )
                                or rhv.placa_referencia in (select glv.placa
                                                              from oper.v$grupo_logistico_veiculo_user glv
                                                           )
                               )
            </cfif>
                       ), 'Nenhum veculo em descarga'
                      ) as veiculos_descarga
              from (
                    select p.cod_pessoa
                         , p.identificador
                         , p.razao_social
                         , p.cliente
                         , pep.endereco_completo
                         , r.latitude
                         , r.longitude
                      from oper.v$grupo_logistico_carga glc
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = glc.cod_pessoa_carga
                     inner join kss.v$pessoa_endereco_padrao pep
                             on pep.cod_pessoa = p.cod_pessoa
                     inner join kss.v$pessoa_ref_geografica pr
                             on pr.cod_pessoa = p.cod_pessoa
                     inner join oper.v$referencia r
                             on r.referencia_id = pr.referencia_id
                     where glc.grupo_id = #qrGrupo.GRUPO_ID#

                     union

                    select p.cod_pessoa
                         , p.identificador
                         , p.razao_social
                         , p.cliente
                         , pep.endereco_completo
                         , r.latitude
                         , r.longitude
                      from oper.v$grupo_logistico_descarga gld
                     inner join kss.v$pessoa p
                            on p.cod_pessoa = gld.cod_pessoa_descarga
                     inner join kss.v$pessoa_endereco_padrao pep
                             on pep.cod_pessoa = p.cod_pessoa
                     inner join kss.v$pessoa_ref_geografica pr
                             on pr.cod_pessoa = p.cod_pessoa
                     inner join oper.v$referencia r
                             on r.referencia_id = pr.referencia_id
                     where gld.grupo_id = #qrGrupo.GRUPO_ID#
                   ) t
             order by t.cliente
      </cfquery>
        <cfreturn qr_result>
    </cffunction>

  <!---
  -- PROPSITO
  -- Busca o fluxo de carga do cliente
  -- NOTAS EXPLICATIVAS
  -- CRISTOFER  13/02/2006
  --->
  <cffunction name="get_fluxo_carga" access="remote" returntype="query" output="true">
    <cfargument name="data_inicio" required="yes">
    <cfargument name="data_fim" required="yes">
    <cfargument name="grupo_id" required="no" default="">
    <cfscript>
        if (not len(trim(arguments.grupo_id))) {
        qrGrupo = this.get_grupo_corrente();
        arguments.grupo_id = qrGrupo.grupo_id;
      }
    </cfscript>
    <cfquery name="qrFluxoViagens" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfif DateCompare(arguments.data_fim,DateFormat(Now(),'dd/mm/yyyy')) eq 0>
          select /*+ ORDERED */
                         2 as tipo,
                           cod_remetente,
                           null as cod_destinatario,
                           'Carregando' as nome_fantasia,
                           num_romaneio,
                           placa_controle,
               motorista,
                           carregamento,
                           to_char(data_inicio_carga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga,
                           to_char(data_termino_carga,'dd/mm/yyyy hh24:mi:ss') as data_termino_carga,
                           to_char(data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada,
               decode(tempo_carga_seg,null,'  00 : 00',tempo_carga) as tempo_carga,
               tempo_parado,
               destino,
                           to_char(data_inicio_descarga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga,
                           to_char(data_chegada_descarga,'dd/mm/yyyy hh24:mi:ss') as data_chegada_descarga,
                           to_char(data_termino_descarga,'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga,
               decode(tempo_descarga_seg,null,'  00 : 00',tempo_descarga) as tempo_descarga,
               tempo_parado_descarga,
               avg(tempo_carga_seg) over() as media_geral_carga_seg,
               avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente) as media_tempo_carga_seg,
               oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over()) as media_geral_carga,
               oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_carga,
               oper.pkg_global.fnc_tempo_formatado(avg(tempo_parado_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_parado,
               oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga,
               oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga,
               (sum(peso_total) over())/1000 as peso_total_carga,
               (count(*) over()) as total_viagens_carga,
               (sum(peso_total) over(partition by cod_remetente order by cod_remetente))/1000 as peso_total,
               (count(*) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as total_viagens_dest,
               (count(*) over(partition by cod_remetente order by cod_remetente)) as total_viagens
            from (select rit.cod_remetente,
                               rit.cod_destinatario,
                                   r.num_romaneio,
                   r.placa_controle,
                                   (select pf.nome
                                      from kss.v$pessoa_fisica pf
                                     where pf.cod_pessoa = (select max(rhv.cod_pessoa) keep(dense_rank last order by rhv.data_inicio)
                                                              from oper.v$romaneio_hist_veiculo rhv
                                                             where rhv.num_romaneio = r.num_romaneio)) as motorista,
                                   r.carregamento,
                   rc.inicio_carga_veiculo as data_chegada,
                   rc.inicio_carga_fabrica as data_inicio_carga,
                   rc.termino_carga as data_termino_carga,
                                   r.peso_total,
                   oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_fabrica) * 86400) tempo_carga,
                   oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_veiculo) * 86400) tempo_parado,
                   case
                    when rc.termino_carga < rc.inicio_carga_fabrica then null
                    else nvl((rc.termino_carga -  rc.inicio_carga_fabrica),0) * 86400
                                   end tempo_carga_seg,
                   nvl((rc.termino_carga -  rc.inicio_carga_veiculo),0) * 86400 as tempo_parado_seg,
                   r.destino,
                                   rd.inicio_descarga_veiculo as data_chegada_descarga,
                                   rd.inicio_descarga_fabrica as data_inicio_descarga,
                   rd.termino_descarga as data_termino_descarga,
                   oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_fabrica) * 86400) as tempo_descarga,
                   oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_veiculo) * 86400) as tempo_parado_descarga,
                   case
                    when rd.termino_descarga < rd.inicio_descarga_fabrica then null
                    else nvl((rd.termino_descarga - rd.inicio_descarga_fabrica),0) * 86400
                                   end tempo_descarga_seg,
                   (rd.termino_descarga - rd.inicio_descarga_veiculo) * 86400 as tempo_parado_descarga_seg,
                   rank() over (partition by r.num_romaneio order by rit.item_id) rank
                from oper.v$romaneio r
               inner join oper.v$romaneio_item rit
                   on rit.num_romaneio = r.num_romaneio
                  and rit.redespacho = 0
               left join oper.v$romaneio_carga rc
                   on rc.num_romaneio = rit.num_romaneio
                  and rc.item_id = rit.item_id
               left join oper.v$romaneio_descarga rd
                 on rd.num_romaneio = rit.num_romaneio
                and rd.item_id = rit.item_id
               inner join oper.v$controle_trafego rev
                   on rev.num_romaneio = r.num_romaneio

               where rit.cod_remetente in (select cod_pessoa_carga
                               from oper.v$grupo_logistico_carga
                                where grupo_id = #arguments.grupo_id#)
                 and rev.num_evento = 2) a
          where rank = 1
              and (cod_destinatario is null and data_termino_carga is null)
        union
        </cfif>

                    select /*+ ORDERED */
                         1 as tipo,
                           cod_remetente,
                           cod_destinatario,
                           pj.nome_fantasia,
                           num_romaneio,
                           placa_controle,
                           motorista,
                           carregamento,
                           to_char(data_inicio_carga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga,
                           to_char(data_termino_carga,'dd/mm/yyyy hh24:mi:ss') as data_termino_carga,
                           to_char(data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada,
                           decode(tempo_carga_seg,null,'  00 : 00',tempo_carga) as tempo_carga,
                           tempo_parado,
                           destino,
                           to_char(data_inicio_descarga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga,
                           to_char(data_chegada_descarga,'dd/mm/yyyy hh24:mi:ss') as data_chegada_descarga,
                           to_char(data_termino_descarga,'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga,
                           decode(tempo_descarga_seg,null,'  00 : 00',tempo_descarga) as tempo_descarga,
                           tempo_parado_descarga,
                           avg(tempo_carga_seg) over() as media_geral_carga_seg,
                           avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente) as media_tempo_carga_seg,
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over()) as media_geral_carga,
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_carga,
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_parado_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_parado,
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga,
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga,
                           (sum(peso_total) over())/1000 as peso_total_carga,
                           (count(*) over()) as total_viagens_carga,
                           (sum(peso_total) over(partition by cod_remetente order by cod_remetente))/1000 as peso_total,
                           (count(*) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as total_viagens_dest,
                           (count(*) over(partition by cod_remetente order by cod_remetente)) as total_viagens
                      from (select rit.cod_remetente,
                               rit.cod_destinatario,
                                   r.num_romaneio,
                                   r.placa_controle,
                                   (select pf.nome
                                      from kss.v$pessoa_fisica pf
                                     where pf.cod_pessoa = (select max(rhv.cod_pessoa) keep(dense_rank last order by rhv.data_inicio)
                                                              from oper.v$romaneio_hist_veiculo rhv
                                                             where rhv.num_romaneio = r.num_romaneio)) as motorista,
                                   r.carregamento,
                                   rc.inicio_carga_veiculo as data_chegada,
                                   rc.inicio_carga_fabrica as data_inicio_carga,
                                   rc.termino_carga as data_termino_carga, r.peso_total,
                                   case
                                      when rc.termino_carga < rc.inicio_carga_fabrica then ' 00 : 00'
                                      when rc.termino_carga is not null and rc.inicio_carga_fabrica is not null then oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_fabrica) * 86400)
                                      else null
                                   end tempo_carga,
                                   oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_veiculo) * 86400) tempo_parado,
                                   case
                                      when rc.termino_carga < rc.inicio_carga_fabrica then 0
                                      when rc.termino_carga is not null and rc.inicio_carga_fabrica is not null then nvl((rc.termino_carga -  rc.inicio_carga_fabrica),0) * 86400
                                      else null
                                   end tempo_carga_seg,
                                   nvl((rc.termino_carga -  rc.inicio_carga_veiculo),0) * 86400 as tempo_parado_seg,
                                   r.destino,
                                   rd.inicio_descarga_veiculo as data_chegada_descarga,
                                   rd.inicio_descarga_fabrica as data_inicio_descarga,
                                   rd.termino_descarga as data_termino_descarga,
                                   case
                                      when nvl(rd.termino_descarga,sysdate) < rd.inicio_descarga_fabrica then ' 00 : 00'
                                      else oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_fabrica) * 86400)
                                   end tempo_descarga,
                                   oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_veiculo) * 86400) as tempo_parado_descarga,
                                   case
                                      when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
                                      when rd.termino_descarga is not null and rd.inicio_descarga_fabrica is not null then nvl((rd.termino_descarga - rd.inicio_descarga_fabrica),0) * 86400
                                      else null
                                   end tempo_descarga_seg,
                                   (rd.termino_descarga - rd.inicio_descarga_veiculo) * 86400 as tempo_parado_descarga_seg,
                                   rank() over (partition by r.num_romaneio order by rit.item_id) rank
                              from oper.v$romaneio r
                             inner join oper.v$romaneio_item rit
                                     on rit.num_romaneio = r.num_romaneio
                                    and rit.redespacho = 0
                             left join oper.v$romaneio_carga rc
                                     on rc.num_romaneio = rit.num_romaneio
                                    and rc.item_id = rit.item_id
                             left join oper.v$romaneio_descarga rd
                                     on rd.num_romaneio = rit.num_romaneio
                                    and rd.item_id = rit.item_id
                             where rit.cod_remetente in (select cod_pessoa_carga
                                                           from oper.v$grupo_logistico_carga
                                                          where grupo_id = #arguments.grupo_id#)

                               and trunc(r.data_termino_carga) between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#') a,
                           kss.v$pessoa_juridica pj
                     where pj.cod_pessoa = cod_destinatario
                       and rank = 1
                     order by carregamento, tipo, data_chegada
      </cfquery>
    <cfreturn qrFluxoViagens>
  </cffunction>

  <!---
  -- PROPSITO
  -- Busca as filas de carga do cliente
  -- NOTAS EXPLICATIVAS
  -- CRISTOFER  02/02/2006
  --->
  <cffunction name="get_fila_carga" access="remote" returntype="query" output="true">
      <cfscript>
      qrGrupo = this.get_grupo_corrente();
    </cfscript>
    <cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
      select /*+ ordered */
                 distinct
                   pj.nome_fantasia,
                   rhv.placa_controle,
           rd.num_romaneio,
                   rd.item_id,
                   to_char(rd.inicio_carga_veiculo,'dd/mm/yyyy hh24:mi') as inicio_carga_veiculo,
                   to_char(rd.inicio_carga_fabrica,'dd/mm/yyyy hh24:mi') as inicio_carga_fabrica,
           oper.pkg_global.fnc_tempo_formatado( (sysdate - rd.inicio_carga_fabrica)*60*60*24 ) as tempo_carga,
           (sysdate - rd.inicio_carga_fabrica)*60*60*24 as tempo_carga_seg,
             (select placa_2
            from oper.v$veiculo_composicao vc
             where vc.placa_1 = (select placa_2
                       from oper.v$veiculo_composicao vc2
                      where vc2.placa_1 = r.placa_controle
                        and vc2.data_hora_desengate is null)
             and vc.data_hora_desengate is null) as placa_bitrem,
           gld.fluxo_carga*60 as fluxo_carga
        from oper.v$romaneio_carga rd
         inner join oper.v$romaneio r
           on r.num_romaneio = rd.num_romaneio
          and r.data_inicio > sysdate - 30
            inner join (select distinct r.num_romaneio, #session.cod_pessoa_usuario#  cod_pessoa, nvl(cod_remetente,#session.cod_pessoa_usuario#) as cod_remetente, nvl(redespacho,0) as redespacho
                                                          from oper.v$romaneio r
                                                        <cfif qrGrupo.SOMENTE_VEICULOS eq 1>left<cfelse>inner</cfif> join oper.v$romaneio_item rit
                                                                on rit.num_romaneio = r.num_romaneio
                               <cfif qrGrupo.REMETENTE_DEFINIDO eq 1>
                                                             and rit.cod_remetente in (select gla.cod_pessoa_carga
                                                                                        from oper.v$grupo_logistico_acesso gla
                                                                                     )
                                                              </cfif>
                                                              <cfif qrGrupo.DESTINATARIO_DEFINIDO eq 1>
                                                             and rit.cod_destinatario in (select gla.cod_pessoa_descarga
                                                                                           from oper.v$grupo_logistico_acesso gla
                                                                                        )
                                                              </cfif>
                                                        where (r.num_romaneio in (select rhv.num_romaneio
                                                                                      from oper.v$controle_trafego rhv
                                                                                     where (rhv.placa_controle in (select glv.placa
                                                                                                                     from oper.v$grupo_logistico_veiculo_user glv)
                                                                                           or rhv.placa_referencia in (select glv.placa
                                                                                                                         from oper.v$grupo_logistico_veiculo_user glv))
                                                                                           )
                                                                )) cr
                                             on cr.num_romaneio = r.num_romaneio
       inner join oper.v$romaneio_item ri
           on ri.num_romaneio = rd.num_romaneio
          and ri.item_id = rd.item_id
       inner join oper.v$romaneio_hist_veiculo rhv
               on rhv.num_romaneio = r.num_romaneio
            and rhv.data_termino is null
       inner join oper.v$grupo_logistico_acesso gld
           on gld.cod_pessoa_carga = ri.cod_remetente
       inner join kss.v$pessoa_juridica pj
           on pj.cod_pessoa = ri.cod_remetente
       where rd.termino_carga is null
       order by pj.nome_fantasia, inicio_carga_fabrica
      </cfquery>
    <cfreturn qr_horario>
  </cffunction>

  <!---
  -- PROPSITO
  -- Busca o fluxo de descarga do cliente
  -- NOTAS EXPLICATIVAS
  -- CRISTOFER  14/02/2006
  --->
  <cffunction name="get_fluxo_descarga" access="remote" returntype="query" output="true">
    <cfargument name="grupo_id" required="yes">
    <cfargument name="data_inicio" required="yes">
    <cfargument name="data_fim" required="yes">
      <cfquery name="qrFluxoViagens" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select /*+ ORDERED */
                     cod_remetente,
                       cod_destinatario,
                       pj.nome_fantasia,
                       num_romaneio,
                       placa_controle,
             motorista,
                       carregamento,
                       to_char(data_inicio_carga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga,
                       to_char(data_termino_carga,'dd/mm/yyyy hh24:mi:ss') as data_termino_carga,
                       to_char(data_chegada_descarga,'dd/mm/yyyy hh24:mi:ss') as data_chegada_descarga,
               tempo_carga,
                     destino,
                       to_char(data_inicio_descarga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga,
                       to_char(data_termino_descarga,'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga,
                     tempo_descarga,
                       to_char(data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada,
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_carga,
                       avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario) as media_tempo_descarga_seg,
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga,
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over()) as media_geral_descarga,
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_parado_descarga_seg) over()) as media_geral_parado_descarga,
                       avg(tempo_descarga_seg) over(partition by cod_remetente order by cod_remetente) as media_geral_descarga_seg,
                       (sum(peso_total) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario))/1000 as peso_total,
                       (count(*) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as total_viagens_dest,
                       (count(*) over()) as total_viagens
          from (select rit.cod_remetente,
                           rit.cod_destinatario,
                               r.num_romaneio,
                 r.placa_controle,
                               pf.nome as motorista,
                               r.carregamento,
                               rc.inicio_carga_veiculo as data_chegada,
                               rc.inicio_carga_fabrica as data_inicio_carga,
                               rc.termino_carga as data_termino_carga, r.peso_total,
                               case
                                  when rc.termino_carga < rc.inicio_carga_fabrica then ' 00 : 00'
                                  when rc.termino_carga is not null and  rc.inicio_carga_fabrica is not null then oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_fabrica) * 86400)
                                  else null
                               end tempo_carga,
                               oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_veiculo) * 86400) as tempo_parado,
                               case
                                  when rc.termino_carga < rc.inicio_carga_fabrica then 0
                                  when rc.termino_carga is not null and  rc.inicio_carga_fabrica is not null then nvl((rc.termino_carga - rc.inicio_carga_fabrica),0) * 86400
                                  else null
                               end tempo_carga_seg,
                               nvl((rc.termino_carga -  rc.inicio_carga_veiculo),0) * 86400 as tempo_parado_seg,
                               r.destino,
                               rd.inicio_descarga_veiculo as data_chegada_descarga,
                               rd.inicio_descarga_fabrica as data_inicio_descarga,
                               rd.termino_descarga as data_termino_descarga,
                               case
                                  when rd.termino_descarga < rd.inicio_descarga_fabrica then ' 00 : 00'
                                  when rd.termino_descarga is not null and rd.inicio_descarga_fabrica is not null then oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_fabrica) * 86400)
                                  else null
                               end tempo_descarga,
                               oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_veiculo) * 86400) as tempo_parado_descarga,
                               case
                                  when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
                                  when rd.termino_descarga is not null and rd.inicio_descarga_fabrica is not null then nvl((rd.termino_descarga - rd.inicio_descarga_fabrica),0) * 86400
                                  else null
                               end tempo_descarga_seg,
                               (rd.termino_descarga - rd.inicio_descarga_veiculo) * 86400 as tempo_parado_descarga_seg,
                               rank() over (partition by r.num_romaneio order by rit.item_id) rank
                          from oper.v$romaneio r
                         inner join oper.v$romaneio_item rit
                                 on rit.num_romaneio = r.num_romaneio
                                and rit.redespacho = 0
                          left join oper.v$romaneio_carga rc
                                 on rc.num_romaneio = rit.num_romaneio
                                and rc.item_id = rit.item_id
                          left join oper.v$romaneio_descarga rd
                                 on rd.num_romaneio = rit.num_romaneio
                                and rd.item_id = rit.item_id
             inner join oper.v$romaneio_hist_veiculo rhv
                 on rhv.num_romaneio = r.num_romaneio
                and rhv.placa_controle = r.placa_controle
                and rhv.data_inicio = (select max(rhv2.data_inicio)
                               from oper.v$romaneio_hist_veiculo rhv2
                            where rhv2.num_romaneio = rhv.num_romaneio)
             inner join kss.v$pessoa_fisica pf
                                 on pf.cod_pessoa = rhv.cod_pessoa
             where rit.cod_remetente in (select cod_pessoa_carga
                             from oper.v$grupo_logistico_carga
                            where grupo_id = #arguments.grupo_id#)
               and rit.cod_destinatario in (select cod_pessoa_descarga
                              from oper.v$grupo_logistico_descarga
                             where grupo_id = #arguments.grupo_id#)
               and trunc(r.data_termino_descarga) between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#') a,
             kss.v$pessoa_juridica pj
         where pj.cod_pessoa = cod_destinatario
           and rank = 1
         order by cod_remetente, cod_destinatario, data_chegada_descarga
      </cfquery>
    <cfreturn qrFluxoViagens>
  </cffunction>

  <!---
  -- PROPSITO
  -- Busca as filas de descarga do cliente
  -- NOTAS EXPLICATIVAS
  -- CRISTOFER  02/02/2006
  --->
  <cffunction name="get_fila_descarga" access="remote" returntype="query" output="true">
      <cfscript>
      qrGrupo = this.get_grupo_corrente();
    </cfscript>
    <cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
      select /*+ LEADING(RD) USE_HASH(RD R) */  distinct pj.nome_fantasia,
           (select distinct eo.placa
                      from oper.v$romaneio_evento re
                   inner join oper.v$evento_operacao eo
                        on eo.controle_evo_id = re.controle_evo_id
                       and eo.num_evento = 4
                     where re.num_romaneio = r.num_romaneio) as placa_controle,
                   rd.num_romaneio, rd.item_id,
                   to_char(rd.inicio_descarga_veiculo,'dd/mm/yyyy hh24:mi') as inicio_descarga_veiculo,
                   to_char(rd.inicio_descarga_fabrica,'dd/mm/yyyy hh24:mi') as inicio_descarga_fabrica,

           oper.pkg_global.fnc_tempo_formatado( (sysdate - rd.inicio_descarga_fabrica)*60*60*24 ) as tempo_descarga,
           (sysdate - rd.inicio_descarga_fabrica)*60*60*24 as tempo_descarga_seg,
           (select /*+first_rows*/placa_2
            from oper.v$veiculo_composicao vc
             where vc.placa_1 = (select placa_2
                       from oper.v$veiculo_composicao vc2
                      where vc2.placa_1 = r.placa_controle
                        and vc2.data_hora_desengate is null)
             and vc.data_hora_desengate is null) as placa_bitrem,
             gld.fluxo_descarga*60 as fluxo_descarga, r.remetente
        from oper.v$romaneio_descarga rd
       inner join oper.v$romaneio r
           on r.num_romaneio = rd.num_romaneio
                and r.data_inicio > sysdate - 30
            inner join (select distinct r.num_romaneio, #session.cod_pessoa_usuario#  cod_pessoa, nvl(cod_remetente,#session.cod_pessoa_usuario#) as cod_remetente, nvl(redespacho,0) as redespacho
                                                          from oper.v$romaneio r
                                                        <cfif qrGrupo.SOMENTE_VEICULOS eq 1>left<cfelse>inner</cfif> join oper.v$romaneio_item rit
                                                                on rit.num_romaneio = r.num_romaneio
                               <cfif qrGrupo.REMETENTE_DEFINIDO eq 1>
                                                             and rit.cod_remetente in (select gla.cod_pessoa_carga
                                                                                        from oper.v$grupo_logistico_acesso gla
                                                                                     )
                                                              </cfif>
                                                              <cfif qrGrupo.DESTINATARIO_DEFINIDO eq 1>
                                                             and rit.cod_destinatario in (select gla.cod_pessoa_descarga
                                                                                           from oper.v$grupo_logistico_acesso gla
                                                                                        )
                                                              </cfif>
                                                        where (r.num_romaneio in (select rhv.num_romaneio
                                                                                      from oper.v$controle_trafego rhv
                                                                                     where (rhv.placa_controle in (select glv.placa
                                                                                                                     from oper.v$grupo_logistico_veiculo_user glv)
                                                                                           or rhv.placa_referencia in (select glv.placa
                                                                                                                         from oper.v$grupo_logistico_veiculo_user glv))
                                                                                           )
                                                                )) cr
                                             on cr.num_romaneio = r.num_romaneio
       inner join oper.v$romaneio_item ri
           on ri.num_romaneio = rd.num_romaneio
          and ri.item_id = rd.item_id
       inner join oper.v$grupo_logistico_acesso gld
           on gld.cod_pessoa_descarga = ri.cod_destinatario
       inner join kss.v$pessoa_juridica pj
           on pj.cod_pessoa = ri.cod_destinatario
       where rd.termino_descarga is null
         and ri.cod_remetente in (select cod_pessoa_carga
                                    from oper.v$grupo_logistico_acesso)
         and ri.cod_destinatario in (select cod_pessoa_descarga
                                         from oper.v$grupo_logistico_acesso)

      order by pj.nome_fantasia, inicio_descarga_fabrica desc
      </cfquery>
    <cfreturn qr_horario>
  </cffunction>

  <!---
  -- PROPSITO
  -- Busca as mdias de tempo de carga e descarga no periodo
  -- NOTAS EXPLICATIVAS
  -- CRISTOFER  14/02/2006
  --->
  <cffunction name="get_tempo_carga_descarga" displayname="Consulta veiculos" access="remote" returntype="query" output="true">
    <cfargument name="data_inicio" required="yes">
    <cfargument name="data_fim" required="yes">
    <cfargument name="grupo_id" required="no" default="">
    <cfscript>
      if(not len(trim(arguments.grupo_id))) {
        qrGrupo = this.get_grupo_corrente();
        arguments.grupo_id = qrGrupo.grupo_id;
      }
    </cfscript>
    <cfquery name="qr_rank" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ORDERED*/ distinct cod_remetente,
                     cod_destinatario,
                     oper.pkg_global.fnc_mascara_cnpj_cpf(pj.cod_pessoa) cnpj_remetente,
                     pjd.nome_fantasia destinatario,
                     pdd.municipio destinatario_mun,
                     pj.nome_fantasia remetente,
                     pd.municipio || '-' || pd.uf municipio,
                     oper.pkg_global.fnc_tempo_formatado(media_tempo_carga) media_tempo_carga,
                     oper.pkg_global.fnc_tempo_formatado(media_tempo_descarga) media_tempo_descarga,
                     media_tempo_carga as media_tempo_carga_seg,
                     media_tempo_descarga as media_tempo_descarga_seg,
                     qtde_viagem,
                     qtde_viagem_dest
         from (select distinct cod_remetente,  cod_destinatario,
                   sum(tempo_carga) over (partition by cod_remetente order by cod_remetente) tempo_carga,
                   sum(tempo_descarga) over (partition by cod_destinatario order by cod_remetente, cod_destinatario) tempo_descarga,
                   avg(tempo_carga) over (partition by cod_remetente order by cod_remetente)  media_tempo_carga,
                   avg(tempo_descarga) over (partition by cod_destinatario order by cod_remetente, cod_destinatario)  media_tempo_descarga,
                   count(distinct num_romaneio) over (partition by cod_remetente) as qtde_viagem,
                   count(distinct num_romaneio) over (partition by cod_destinatario) as qtde_viagem_dest
         from (select /*+ORDERED*/rit.cod_remetente, rit.cod_destinatario, rc.termino_carga as data_termino_carga, roo.num_romaneio,
                                case when rc.termino_carga < rc.inicio_carga_fabrica then 0
                     when rc.inicio_carga_fabrica is not null and rc.termino_carga is not null then
                                         (rc.termino_carga - rc.inicio_carga_fabrica)*60*60*24
                                else null end tempo_carga,
                                case when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
                     when rd.inicio_descarga_fabrica is not null and rd.termino_descarga is not null then
                                         (rd.termino_descarga - rd.inicio_descarga_fabrica)*60*60*24
                                else null end tempo_descarga,
                                rank() over (partition by roo.num_romaneio order by rit.item_id) rank
                      from oper.v$romaneio roo
                     inner join oper.v$romaneio_item rit
                                  on roo.num_romaneio = rit.num_romaneio
           inner join oper.v$romaneio_carga rc
                   on rc.num_romaneio = rit.num_romaneio
              and rc.item_id = rit.item_id
           left join oper.v$romaneio_descarga rd
                   on rd.num_romaneio = rit.num_romaneio
              and rd.item_id = rit.item_id)
            where rank = 1
              and trunc(data_termino_carga) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')
            ),
          kss.v$pessoa_juridica pj
          inner join kss.v$pessoa_endereco_padrao pd
                  on pd.cod_pessoa = pj.cod_pessoa,
          kss.pessoa_juridica pjd
          inner join kss.v$pessoa_endereco_padrao pdd
                  on pdd.cod_pessoa = pjd.cod_pessoa
        where pj.cod_pessoa = cod_remetente
          and pjd.cod_pessoa = cod_destinatario
      and pjd.cod_pessoa in (select cod_pessoa_descarga
                               from oper.v$grupo_logistico_descarga
                  where grupo_id = #arguments.grupo_id#)
      and pj.cod_pessoa in (select cod_pessoa_carga
                              from oper.v$grupo_logistico_carga
                 where grupo_id = #arguments.grupo_id#)
    </cfquery>
    <cfreturn qr_rank>
  </cffunction>


  <!---
  -- PROPSITO
  -- Retorna dados completos do motorista
  -- NOTAS EXPLICATIVAS
  --
  -- GUTO 22/11/2005 - criado
  --->
  <cffunction name="get_dados_motorista" output="false" returntype="query" access="remote">
    <cfargument name="cod_funcionario" required="no" default="">
    <cfargument name="com_foto" required="no" default="0">
    <cfargument name="nome" required="no" default="">
        <cfargument name="terceiro" required="no" default="0">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          <cfif arguments.terceiro eq 0>
                select cod_funcionario, nome_completo, endereco, cidade_uf,
                       telefone, rg, cpf, cnh, cnh_validade, data_admissao,
                       cobertura, num_celular, mopp,
                       cod_pessoa, empresa, agregado
                       <cfif arguments.com_foto eq 1>
                       ,foto
                       </cfif>
                  from oper.v$funcionario_dados
                 where 1=1
                 <cfif len(trim(arguments.cod_funcionario))>
                   and cod_funcionario = #arguments.cod_funcionario#
                 </cfif>
                 <cfif len(trim(arguments.nome))>
                   and upper(nome_completo) like upper('%#arguments.nome#%')
                 </cfif>
               <cfif arguments.com_foto eq 1>
                    and foto is not null
               </cfif>
          <cfelse>
            select p.cod_pessoa as cod_funcionario
                     , p.cod_pessoa || ' - ' || p.nome || decode(pt.telefone_contato,null,'',' (' || pt.telefone_contato || ')') as nome_completo
                     , pe.logradouro || ' ' || pe.numero || ' ' || pe.complemento || ' ' || pe.bairro as endereco
                     , pe.municipio || ' - ' || pe.uf as cidade_uf
                     , '(' || t.fone_ddd || ') ' || t.fone_prefixo || ' - ' || t.fone_numero as telefone
                     , p.cart_ident_num as rg
                     , oper.pkg_global.fnc_mascara_cnpj_cpf(p.cod_pessoa) as cpf
                     , p.cnh_num_registro as cnh
                     , p.cnh_validade as cnh_validade
                     , p.data_admissao
                     , nvl((select kss.fnc_concat_all(kss.to_concat_expr(pj.nome_fantasia||': '||grpe.cod_cobertura||'-'||grc.descricao||' - Vencto: '||to_char(grpe.data_vencimento, 'dd/mm/yyyy'),CHR(10)||CHR(13))) cobertura
                              from (select grp.cod_gerenciadora
                                         , grp.cod_pessoa_fisica
                                         , max(grp.data_vencimento) data_vencimento
                                     from grisco.v$gerenciadora_pessoa grp
                                    group by grp.cod_gerenciadora, grp.cod_pessoa_fisica) gr
                             inner join grisco.v$gerenciadora_pessoa grpe
                                on grpe.cod_pessoa_fisica = gr.cod_pessoa_fisica
                               and grpe.cod_gerenciadora = gr.cod_gerenciadora
                               and grpe.data_vencimento = gr.data_vencimento
                             inner join kss.v$pessoa_juridica pj
                                on pj.cod_pessoa = grpe.cod_gerenciadora
                             inner join grisco.v$gerenciadora_cobertura grc
                                on grc.cod_gerenciadora = grpe.cod_gerenciadora
                               and grc.cod_cobertura = grpe.cod_cobertura
                             where grpe.cod_pessoa_fisica = p.cod_pessoa), 'Cadastro em Gerenciadora de Risco: No registrado') as cobertura
                       , (select '(' || cel.fone_ddd || ') ' || cel.fone_prefixo || ' - ' || cel.fone_numero
                            from kss.v$pessoa_telefone pcel
                           inner join kss.v$telefone cel
                              on cel.telefone_id = pcel.telefone_id
                             and pcel.telefone_tipo_id = 3
                           where pcel.cod_pessoa = p.cod_pessoa
                             and rownum = 1) as num_celular
                       , decode(mo.num_controle
                              , null
                              , ''
                              , mo.instituicao || ' Verificado em: ' || to_char(mo.data_verificacao, 'dd/mm/yy') || ' Vencimento em: ' ||to_char(mo.data_vencimento, 'dd/mm/yy')
                         ) as mopp
                       , p.cod_pessoa
                       <cfif arguments.com_foto eq 1>
                       , case
                            when dbms_lob.getlength(pff.logotipo) < 80000 then pff.logotipo
                         end foto
                       </cfif>
                  from kss.v$pessoa_fisica p
                  left join oper.v$motorista_mopp mo
                    on mo.cod_pessoa = p.cod_pessoa
                  left join kss.v$pessoa_logotipo pff
                    on pff.cod_pessoa = p.cod_pessoa
                  left join kss.v$pessoa_endereco pe
                    on pe.cod_pessoa = p.cod_pessoa
                   and pe.endereco_padrao = 1
                  left join (kss.v$pessoa_telefone pt
                             inner join kss.v$telefone t
                               on t.telefone_id = pt.telefone_id)
                    on pt.cod_pessoa = p.cod_pessoa
                   and pt.telefone_padrao = 1
                 where 1 = 1
                 <cfif len(trim(arguments.cod_funcionario))>
                   and p.cod_pessoa = #arguments.cod_funcionario#
                 </cfif>
                 <cfif len(trim(arguments.nome))>
                   and upper(p.nome) like upper('%#arguments.nome#%')
                 </cfif>
               <cfif arguments.com_foto eq 1>
                    and dbms_lob.getlength(pff.logotipo) < 80000
               </cfif>
          </cfif>
    </cfquery>
    <cfreturn qr_result>
  </cffunction>
  
  <!---
    -- PROPSITO
    -- Retorna o token para ser utilizado ao abrir mapa do google
    -- WELLINGTON 05/04/2019 - CRIADO
    --->
    <cffunction name="get_token_google" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.pkg_parametro.fnc_valor_string(p_identificador => 'M208-P0152') as token
              from dual
            
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>
