<html>
<cfinclude template="/_scripts/scripts.cfm"/>
<cfparam name="vars.operacao_tipo_id" default="">
<cfparam name="vars.movimentacao_equipamento" default="0">
<cfparam name="vars.movimentacao_funcionario" default="0">
<cfparam name="vars.cod_pessoa_filial" default="#session.cod_pessoa#">
<cfparam name="vars.cod_centro_custo" default="#session.cod_centro_custo#">
<cfscript>
	conn = CreateComponent("modulos.almoxarifado._componentes.consulta.cfc_acesso");
	qrUsuario = conn.get_usuarios_modulo(usuario = session.usuario, cod_modulo = 'GESTAO_ESTOQUE');
	v_nivel_acesso = qrUsuario.nivel_acesso;
	conn = CreateComponent("modulos.almoxarifado._componentes.consulta.cfc_pessoa");
	qrFiliais = conn.get_filiais();
	qrCentroCusto = conn.get_centro_custo(cod_pessoa_filial = vars.cod_pessoa_filial);
	qrEstoqueOper = conn.get_estoque_oper();
	qrEstoqueOperRecurso = conn.get_estoque_oper_recurso();

	conn = CreateComponent("modulos.almoxarifado._componentes.consulta.cfc_almoxarifado");

	switch(vars.operacao_tipo_id) {
		case 1:
		case 2:
		  	qrTipo = conn.get_operacao_tipo_backend(movimentacao_entrada = 'true');
			v_titulo = "Entrada de Material";
			v_entrada = 1;
			v_saida = 0;
			break;
		case 3:
		    qrTipo = conn.get_operacao_tipo_backend(movimentacao_saida = 'true');
			v_titulo = "Sa&iacute;da de Material";
			v_entrada = 0;
			v_saida = 1;
			break;
		default:
			v_titulo = "Movimenta&ccedil;&otilde;es";
			v_entrada = 0;
			v_saida = 1;
			break;
	}
    conn = CreateComponent("modulos.almoxarifado._componentes.consulta.cfc_global");
	v_nf_obrigatorio = conn.get_parametro_valor(11, 'OPERACIONAL', 28, 2);
	v_permite_mat_sem_valor_unitario = conn.get_parametro_valor_lista(identificador = 'M221-P0150').valor;
    v_permite_alterar_ccg_veiculo = conn.get_parametro_valor_lista(identificador = 'M221-P0160').valor;
	v_permite_alterar_ccg_funcionario = conn.get_parametro_valor_lista(identificador = 'M221-P0163').valor;

</cfscript>
<script language="javascript1.2">
	// Configura botoes //
	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');

	parent.f_set_texto('titulo_aplicacao', '<cf_language>Controle de Estoque</cf_language>');
	parent.f_set_texto('titulo_pagina', '<cf_language><cfoutput>#v_titulo#</cfoutput></cf_language>');

	f_habilitar_botao('confirmar', 'f_confirmar()');
	parent.document.getElementById('btn_voltar').onclick = function() {window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }
    var permiteAtributoVazio = <cfif v_permite_mat_sem_valor_unitario eq 'SIM'>true<cfelse>false</cfif>;

 	f_cria_botao('imprimir', 'Imprimir', 'f_imprimir()');
 	function f_imprimir() {
		with(document.forms[0]) {
  			window.location = 'print.cfm?movimentacao_funcionario='+<cfoutput>#vars.movimentacao_funcionario#</cfoutput>;
		}
	}

	// -------------------- //

	function f_confirmar() {
		with(document.forms[0]) {
			if(Number(CONFIRMA.value) == 1){
				OPERACAO.value = 2;
				target = 'consultas';
				action = 'confirma.cfm';
				<cfif v_nf_obrigatorio eq 1>
				   if (Number(OPERACAO_TIPO_ID.value) == 2) {
					   NUM_NOTA_FISCAL.obrigatorio = 1;
				   }
				   else NUM_NOTA_FISCAL.obrigatorio = 0;
				</cfif>

				<cfif vars.operacao_tipo_id eq 3>
				   if(parseInt(OPERACAO_TIPO_ID.value) == 3 && parseInt(MOVIMENTACAO_EQUIPAMENTO.value) == 1){
				      if(COD_EQUIPAMENTO.value == '') {
						  alert("No  possvel realizar sada de material sem informar a placa.");
						  return false;
					  }
				   }
				</cfif>


				if(((parseInt(OPERACAO_TIPO_ID.value) == 3) ||
					(parseInt(OPERACAO_TIPO_ID.value) == 14) ||
					(parseInt(OPERACAO_TIPO_ID.value) == 16) ||
					(parseInt(OPERACAO_TIPO_ID.value) == 17) ||
					(parseInt(OPERACAO_TIPO_ID.value) == 18)
				 )&& (parseFloat(QUANTIDADE.value) <= 0)){
					alert("No  possvel realizar sada de material com quantidade zero.");
					return false;
				}
				if (parseInt(MOVIMENTACAO_EQUIPAMENTO.value) == 1) {
					if((parseInt(OPERACAO_TIPO_ID.value) == 3) && (ORDEM_SERVICO_ID_VINCULO.value != '') && (EQUIPAMENTO_ID.value == '')){
						alert("No  possivel realizar o vinculo com OS sem informar a placa.");
						return false;
					}
				}
				if (f_verifica_form(document.forms[0])){
					if (parseInt(MATERIAL_ID.options[MATERIAL_ID.selectedIndex].identificado) == 1 && (parseInt(OPERACAO_TIPO_ID.value) == 3) ) {
						alert('Para sada para uso de materiais identificados  necessria a abertura de uma O.S.');
						return false;
					}
				    document.getElementById('cod_pessoa_filial').removeAttribute('disabled');
					document.getElementById('cod_centro_custo').removeAttribute('disabled');
					CONFIRMA.value = 0;
					submit();
				}
			}  else { alert('O formulrio j foi confirmado. Aguarde...'); }
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;

	function f_excluir() {
		with(document.forms[0]) {
			OPERACAO.value = 4; // excluir
			OPERACAO.disabled     = false;
			GRUPO_ID.disabled = false;
			try { ATUALIZA_COMBO.disabled = false; } catch(e) {}
			target = 'consultas';
			action = 'confirma.cfm';
			if ( confirm('<cf_language>Para confirmar a excluso do registro clique em OK.</cf_language>') ) {
			   submit();
			}
		}
	}
	parent.f_excluir = f_excluir;

	function f_localizar() {
		NewWindow('localizar.cfm','Localizar','500','300','yes');
	}
	parent.f_localizar = f_localizar;

	function f_set_id(m_id) {
		with(document.forms[0]) {
			MATERIAL_ID.value = m_id;
			f_consulta_material();
		}
	}

	function f_consulta_material() {
		with(document.forms[0]) {
			target = 'consultas';
			action = 'consultas.cfm';
			CONSULTA.value = 1;
			submit();
		}
	}

	function f_busca_codigo_material() {
		with(document.forms[0]) {
				// Ajusta os cdigos do material selecionado
				document.getElementById('sp_unidade').innerHTML    	   = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('unidade_estoque');
				document.getElementById('td_saldo').innerHTML    	   = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('saldo');
				document.getElementById('td_cod_genuino').innerHTML    = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('cod_genuino');
				document.getElementById('td_cod_fabricante').innerHTML = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('cod_fabricante');
				document.getElementById('td_cod_paralelo').innerHTML   = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('cod_paralelo');
			if (Number(MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('identificado')) == 1) {
				QUANTIDADE.value = 1;
				QUANTIDADE.readyOnly = true;
			} else {
				QUANTIDADE.value = '';
				QUANTIDADE.readyOnly = false;
			}
			if ((Number(MATERIAL_ID.options[MATERIAL_ID.selectedIndex].exige_devolucao) ==1) || (Number(MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('identificado')) ==1)) {
				document.getElementById('sp_exige_devolucao').innerHTML = 'Esse material exige a devoluo da pea usada!';
			} else {
				document.getElementById('sp_exige_devolucao').innerHTML = '';
			}
			f_busca_montagem();
		}
	}

	function f_busca_atributos() {
		with(document.forms[0]) {
			if (MATERIAL_ID.value) {
				f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_almoxarifado.cfc?method=get_material_atributo'
							,'material_id='+MATERIAL_ID.value + '&ENTRADA=<cfoutput>#v_entrada#</cfoutput>&SAIDA=<cfoutput>#v_saida#</cfoutput>&COD_PESSOA_FILIAL='+COD_PESSOA_FILIAL.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									v_tbody = document.getElementById('tab_atributos').tBodies[0];
									while (v_tbody.rows.length > 0) {
										v_tbody.deleteRow(0);
									}

									for (var i=0;i<obj.struct.atributo.length;i++) {
										v_tr = document.createElement("TR");
										v_tr.className = 'texto';
										v_tbody.appendChild(v_tr);

										v_td = document.createElement("TD");
										v_td.innerHTML = '<nobr>' + obj.struct.atributo[i] + ':</nobr>';
										v_td.width = 50;
										v_tr.appendChild(v_td);
									<cfif v_saida eq 1>
										if(obj.struct.atributo_id[i] == 7) {
												v_input = document.createElement("INPUT");
												if(obj.struct.atributo[i]=='Identificador'){
													v_input.type = 'hidden';
												}else{
													v_input.type = 'text';
												}
											v_input.name = 'ATRIBUTO_ID_ATRIBUTOS_' + i;
											v_input.value = obj.struct.atributo_id[i];
											v_td.appendChild(v_input);

												v_td = document.createElement("TD");
												v_input = document.createElement("SELECT");
												v_option = 'VALOR_ATRIBUTOS_' + i;
												v_input.name = 'VALOR_ATRIBUTOS_' + i;
												v_input.obrigatorio = '1';
												v_input.id = v_option;
												v_input.display = 'Identificador';
												v_option_object = v_input;
												v_td.appendChild(v_input);
												v_tr.appendChild(v_td);
												f_query_wddx('/modulos/manutencao/_componentes/consulta/cfc_manutencao.cfc?method=get_equipamentos_estoque'
												,'transferencia=1&cod_pessoa_filial='+COD_PESSOA_FILIAL.value+'&MATERIAL_ID='+MATERIAL_ID.value+'&COD_EQUIPAMENTO='+EQUIPAMENTO_ID.value+'&COD_CENTRO_CUSTO='+COD_CENTRO_CUSTO.value
												,function(obj) {
													if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
														f_cria_option('','',v_option_object);
														for (var j=0; j < obj.struct.equipamento_id.length; j++) {
															f_cria_option(obj.struct.cod_equipamento[j],obj.struct.cod_equipamento[j],v_option_object);
														}
													}
												});

										} else {
											v_input = document.createElement("INPUT");
											v_input.type = 'hidden';
											v_input.name = 'ATRIBUTO_ID_ATRIBUTOS_' + i;
											v_input.value = obj.struct.atributo_id[i];
											v_td.appendChild(v_input);
										}
									<cfelse>
										v_input = document.createElement("INPUT");
										v_input.type = 'hidden';
										v_input.name = 'ATRIBUTO_ID_ATRIBUTOS_' + i;
										v_input.value = obj.struct.atributo_id[i];
										v_td.appendChild(v_input);
									</cfif>

									<cfif v_saida eq 1>
										if(obj.struct.atributo[i]=='Identificador'){
										//	 v_td.innerHTML = obj;
										}else{
									</cfif>
										v_td = document.createElement("TD");
										v_td.innerHTML = obj.struct.atributo[i];
										v_tr.appendChild(v_td);
										f_input_atributo(obj.struct.tipo_dado[i], 'VALOR_ATRIBUTOS_'+i, obj.struct.itens[i],
												function(obj) { v_td.innerHTML = obj }  );

										(inpt = document.getElementById('VALOR_ATRIBUTOS_'+i)).value = obj.struct.valor_padrao[i];
										if (obj.struct.tipo_dado[i] == 'NUMERO') {
										   (inpt = document.getElementById('VALOR_ATRIBUTOS_'+i)).tipo = 'numerico';
										}
										inpt.obrigatorio = obj.struct.obrigatorio[i];
										inpt.display = obj.struct.atributo[i];
										if (obj.struct.atributo_id[i] == 7 && <cfoutput>#v_entrada#</cfoutput> == 1) {
										    inpt.value = obj.struct.cod_equipamento[i];
											inpt.readOnly = true;
										}
										if (obj.struct.atributo_id[i] == 3 && (OPERACAO_TIPO_ID.value == 3)) {
										   inpt.value = obj.struct.valor_unitario[i];
										}
										if (obj.struct.atributo_id[i] == 12) {
										   inpt.value = obj.struct.ult_localizacao[i];
											inpt.onkeypress = function() { f_formata(this,event,'AAAAAAAAAAAA'); }
										}
										if (obj.struct.atributo_id[i] == 23) {
											inpt.onchange = function() { f_calcula_valor_total(); }
											inpt.readOnly = !permiteAtributoVazio;
											inpt.obrigatorio = permiteAtributoVazio ? inpt.obrigatorio : 0; // Se no permite material sem valor no atributo ento deixa o campo como no obrigatrio para conseguir finalizar a movimentao
										}
										if (obj.struct.atributo_id[i] == 25) {
											inpt.readOnly = !permiteAtributoVazio;
											inpt.obrigatorio = permiteAtributoVazio ? inpt.obrigatorio : 0; // Se no permite material sem valor no atributo ento deixa o campo como no obrigatrio para conseguir finalizar a movimentao
										}
										inpt.setAttribute("atributo_id",obj.struct.atributo_id[i]);
									 <cfif v_saida eq 1>
										}// fim else
									 </cfif>
									}
								}
							});
				f_busca_valor_data();
			}
		}
	}

	function f_filtra_material() {
		with(document.forms[0]) {
			f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_manutencao.cfc?method=get_material_dados_por_codigo'
						,'material='+f_limpa_acentos(MATERIAL.value)+ '&ESTOQUE=1+&COD_PESSOA_FILIAL=' + COD_PESSOA_FILIAL.value +
						 '&COD_CENTRO_CUSTO=' + COD_CENTRO_CUSTO.value <cfif v_saida eq 1>+'&COM_SALDO_ESTOQUE=1'</cfif>
						,f_material_result);
		}
	}

	function f_busca_material() {
		with(document.forms[0]) {
			f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_manutencao.cfc?method=get_material_dados_por_codigo'
						,'cod_material='+COD_MATERIAL.value + '&ESTOQUE=1+&COD_PESSOA_FILIAL=' + COD_PESSOA_FILIAL.value +
						 '&COD_CENTRO_CUSTO=' + COD_CENTRO_CUSTO.value<cfif v_saida eq 1>+'&COM_SALDO_ESTOQUE=1'</cfif>
						,f_material_result);
		}
	}

	function f_material_result(obj) {
		with(document.forms[0]) {
			if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
				f_limpa_select(MATERIAL_ID);
				if (obj.struct.material_id.length > 0) {
					if (obj.struct.material_id.length > 1) {
						v_opt = f_cria_option('', '-- Selecione o Material --', MATERIAL_ID);
						v_opt.setAttribute('unidade_estoque','');
						v_opt.setAttribute('cod_genuino','');
						v_opt.setAttribute('saldo','');
						v_opt.setAttribute('cod_fabricante','');
						v_opt.setAttribute('cod_paralelo','');
						v_opt.setAttribute('exige_devolucao','');
					}
					for (var i=0; i < obj.struct.material_id.length; i++) {
						v_opt = f_cria_option(obj.struct.material_id[i], obj.struct.material[i], MATERIAL_ID);
						v_opt.setAttribute('unidade_estoque',obj.struct.unidade_estoque[i]);
						v_opt.setAttribute('identificado',obj.struct.identificado[i]);
						v_opt.setAttribute('cod_genuino',obj.struct.cod_genuino[i]);
						v_opt.setAttribute('identificado',obj.struct.identificado[i]);
						v_opt.setAttribute('saldo',obj.struct.saldo_estoque[i]);
						v_opt.setAttribute('cod_fabricante',obj.struct.cod_fabricante[i]);
						v_opt.setAttribute('cod_paralelo',obj.struct.cod_paralelo[i]);
						v_opt.setAttribute('exige_devolucao',obj.struct.exige_devolucao[i]);
					}
				}
				if (obj.struct.material_id.length == 1) {
				  f_busca_codigo_material();
				  f_busca_solicitacao();
				  f_busca_atributos();
				  f_busca_etiquetas();
				}
			}
		}
	}

	function f_busca_material_posicao() {
		with(document.forms[0]) {
			// Ajusta os cdigos do material selecionado
			document.getElementById('sp_unidade').innerHTML    	   = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('unidade_estoque');
			document.getElementById('td_cod_genuino').innerHTML    = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('cod_genuino');
			document.getElementById('td_cod_fabricante').innerHTML = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('cod_fabricante');
			document.getElementById('td_cod_paralelo').innerHTML   = MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('cod_paralelo');
			if(parseInt(MATERIAL_ID.options[MATERIAL_ID.selectedIndex].getAttribute('identificado')) == 1) {
			   QUANTIDADE.value = 1;
			   QUANTIDADE.readOnly = true;
			}
			else {
			   QUANTIDADE.value = '';
			   QUANTIDADE.readOnly = false;
			}
		}
		f_busca_montagem();
	}

	function f_busca_nota_fiscal() {
		with(document.forms[0]) {
			f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_emissao_documentos.cfc?method=get_nf_terceiro'
			            ,'NUM_NOTA_FISCAL='+NUM_NOTA_FISCAL.value
							,function(obj) {
							  with(document.forms[0]) {
							  	 f_limpa_select(NUM_NOTA_ID);
							  	 if (obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								 	 if (obj.struct.num_nota_id.length) {
									 	 for(var i=0; i < obj.struct.num_nota_id.length; i++) {
										 	f_cria_option(obj.struct.num_nota_id[i],obj.struct.identificador[i] + ' ' + obj.struct.razao_social[i] + ' R$ ' + obj.struct.calc_valor_total_nota[i],NUM_NOTA_ID);
										 }
									 }
								 }
							  }
							});
		}
	}

	function f_busca_equipamento() {
		with(document.forms[0]) {
			if(COD_EQUIPAMENTO.value){
				EQUIPAMENTO_ID.value ='';
				MATERIAL_DESCRICAO.value ='';
			f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_manutencao.cfc?method=get_equipamentos'
					,'placa='+COD_EQUIPAMENTO.value
					,function(obj) {
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									if(obj.struct.equipamento_id.length > 0) {
										EQUIPAMENTO_ID.value = obj.struct.equipamento_id[0];
										MATERIAL_DESCRICAO.value = obj.struct.material[0];
										COD_ORGANIZACIONAL.value = obj.struct.cod_organizacional[0];

										<cfif v_permite_alterar_ccg_veiculo neq 'Sim'>
										   if(obj.struct.cod_organizacional[0] != ''){
										      COD_ORGANIZACIONAL.disabled = 'disabled';
											  document.getElementById('busca_ccg').style.display = 'none';
										   }else{
											  COD_ORGANIZACIONAL.disabled = '';
											  document.getElementById('busca_ccg').style.display = '';
										   }
										</cfif>

										if (<cfoutput>#v_saida#</cfoutput> == 1) {
											OBSERVACAO.value = 'Sada realizada para o veculo ' + COD_EQUIPAMENTO.value;
										}
										f_busca_gerencial();
										f_busca_montagem();
									} else {
										alert('Equipamento no encontrado!');
										COD_EQUIPAMENTO.value ='';
										if (<cfoutput>#v_saida#</cfoutput> == 1) {
											OBSERVACAO.value = '';
										}
									}
								}
							}
					});
			}
			else{
				EQUIPAMENTO_ID.value ='';
				MATERIAL_DESCRICAO.value ='';
				if (<cfoutput>#v_saida#</cfoutput> == 1) {
					OBSERVACAO.value = '';
				}
			}
		}
	}

	function f_busca_solicitacao() {
		with(document.forms[0]) {
			f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_almoxarifado.cfc?method=get_solicitacao_material'
						,'cod_pessoa_filial='+COD_PESSOA_FILIAL.value + '&material_id='+MATERIAL_ID.value + '&pendentes=1'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								f_limpa_select(SOLICITACAO_ID);
								f_cria_option('','-- Selecione a Solicitao --',SOLICITACAO_ID);
								if(obj.struct.solicitacao_id.length > 0) {
									for (var i=0;i<obj.struct.solicitacao_id.length;i++) {
										f_cria_option(obj.struct.solicitacao_id[i],obj.struct.material[i] + ' Quantidade: ' + obj.struct.quantidade[i],SOLICITACAO_ID);
									}
								} else {
										 f_limpa_select(SOLICITACAO_ID);
										 f_cria_option('','-- No possui Solicitao --',SOLICITACAO_ID);
								}
							}
						});
		}
	}

	function f_operacao_tipo() {
		with(document.forms[0]) {
			if (Number(OPERACAO_TIPO_ID.value) == 3)  {
				  if (Number(MOVIMENTACAO_EQUIPAMENTO.value) == 1) {
				      document.getElementById('COD_EQUIPAMENTO').setAttribute("obrigatorio", 1);
					  document.getElementById('tr_equipamento').style.display = '';
					  document.getElementById('tr_os_vinculo').style.display = '';
				  } else if (Number(MOVIMENTACAO_FUNCIONARIO.value) == 1) {
				  	  document.getElementById('tr_equipamento').style.display = '';
					  document.getElementById('tr_os_vinculo').style.display = 'none';
				  }

		         document.getElementById('tr_fornecedor').style.display = 'none';
				 document.getElementById('COD_PESSOA_FORNECEDOR').setAttribute("obrigatorio", 0);
    		} else if (Number(OPERACAO_TIPO_ID.value) == 16 || Number(OPERACAO_TIPO_ID.value) == 17  ){
			  try{
			        document.getElementById('COD_EQUIPAMENTO').setAttribute("obrigatorio", 0);
					document.getElementById('tr_equipamento').style.display = '';
					document.getElementById('tr_os_vinculo').style.display = 'none';
					<cfif qrEstoqueOperRecurso.recurso eq 1>
					  document.getElementById('tr_fornecedor').style.display = '';
		  		      document.getElementById('COD_PESSOA_FORNECEDOR').setAttribute("obrigatorio", 1);
					</cfif>
			  	} catch(e){}
			}else if (Number(OPERACAO_TIPO_ID.value) == 14 ){
			    document.getElementById('COD_EQUIPAMENTO').setAttribute("obrigatorio", 0);
				document.getElementById('tr_equipamento').style.display = 'none';
				document.getElementById('tr_os_vinculo').style.display = 'none';
               <cfif qrEstoqueOperRecurso.recurso eq 1>
                  document.getElementById('tr_fornecedor').style.display = '';
		  		  document.getElementById('COD_PESSOA_FORNECEDOR').setAttribute("obrigatorio", 1);
               </cfif>
			} else {
				  try{
					document.getElementById('tr_equipamento').style.display = 'none';
					document.getElementById('tr_os_vinculo').style.display = 'none';

                    document.getElementById('tr_fornecedor').style.display = 'none';
		  			document.getElementById('COD_PESSOA_FORNECEDOR').setAttribute("obrigatorio", 0);
			  	} catch(e){}
		    }
		}
	}

	function f_calcula_valor_total(){
		with(document.forms[0]) {
			var valor_unitario;
			for(var i=0;i<document.forms[0].elements.length;i++) {
				var v_elem = document.forms[0].elements[i];
				if (v_elem.getAttribute('atributo_id') == 23){
					valor_unitario = v_elem.value;
				}
				if (v_elem.getAttribute('atributo_id') == 25){
					v_elem.value =  number_format(valor_unitario * QUANTIDADE.value, 2,'.','');
				}
			}
		}
	}

	function f_busca_gerencial(){
		with(document.form_transportes){
			if(!COD_ORGANIZACIONAL.value){
				ORGANIZACIONAL_ID.value = '';
				DESCRICAO_COMPLETA.value = '';
			}else{
				f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_emissao_documentos.cfc?method=get_organizacional'
							 ,'cod_organizacional='+COD_ORGANIZACIONAL.value
							  +'&somente_ativos=1'
							  +'&somente_folhas=1'
							 ,function(obj){
								 if(obj.ajax.readyState == 4 && obj.ajax.status == 200){
									if(obj.struct.organizacional_id.length == 0){
										alert('Centro de custo gerencial no encontrado');
										ORGANIZACIONAL_ID.value = '';
										DESCRICAO_COMPLETA.value = '';
									}else if(obj.struct.organizacional_id.length > 1){
										alert('Foi encontrado mais de um centro de custo gerencial.');
										ORGANIZACIONAL_ID.value = '';
										DESCRICAO_COMPLETA.value = '';
									}else{
										ORGANIZACIONAL_ID.value = obj.struct.organizacional_id[0];
										DESCRICAO_COMPLETA.value = obj.struct.descricao_completa[0];
									}
								 }
							 });
			}
		}
	}

	function f_busca_pessoa_responsavel() {
		with(document.forms[0]) {
			RESPONSAVEL.value = '';
			COD_PESSOA_RESPONSAVEL.value = '';

			if(!COD_FUNCIONARIO.value) {
				return;
			}

			RESPONSAVEL.value = 'Buscando funcionrio...';
			f_query_wddx('<cf_url>/modulos/almoxarifado/_componentes/consulta/cfc_funcionario.cfc</cf_url>?method=get_funcionario'
						,'num_modalidade=4,6' +
						'&ativos=1' +
					    '&busca_ativos=1' +
						'&cod_funcionario=' + COD_FUNCIONARIO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_pessoa.length > 0) {
									RESPONSAVEL.value = obj.struct.nome_funcionario[obj.struct.cod_pessoa.length - 1];
									COD_PESSOA_RESPONSAVEL.value = obj.struct.cod_pessoa[obj.struct.cod_pessoa.length - 1];
									COD_ORGANIZACIONAL.value = obj.struct.cod_organizacional[obj.struct.cod_pessoa.length - 1];
									ORGANIZACIONAL_ID.value = obj.struct.organizacional_id[obj.struct.cod_pessoa.length - 1];
									DESCRICAO_COMPLETA.value = obj.struct.descricao[obj.struct.cod_pessoa.length - 1];

                                    <cfif v_permite_alterar_ccg_funcionario neq 'Sim'>										
										if(obj.struct.cod_organizacional[0] != ''){
											COD_ORGANIZACIONAL.disabled = 'disabled';
											document.getElementById('busca_ccg').style.display = 'none';
										}else{
											COD_ORGANIZACIONAL.disabled = '';
											document.getElementById('busca_ccg').style.display = '';
										}
									</cfif>
								}
								else {
									RESPONSAVEL.value = 'Funcionrio no encontrado.';
								}
							}
						});
		}
	}

	function f_filtra_centro_custo(){
	   with(document.forms[0]){
		   f_query_wddx('<cf_url>/modulos/almoxarifado/_componentes/consulta/cfc_pessoa.cfc</cf_url>?method=get_centro_custo'
			            ,'COD_PESSOA_FILIAL='+ COD_PESSOA_FILIAL.value
							,function(obj) {
							  with(document.forms[0]) {
							  	 f_limpa_select(COD_CENTRO_CUSTO);
							  	 if (obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								 	 if (obj.struct.cod_centro_custo.length) {
										 f_cria_option('', 'Selecione', COD_CENTRO_CUSTO);
									 	 for(var i=0; i < obj.struct.cod_centro_custo.length; i++) {
										 	f_cria_option(obj.struct.cod_centro_custo[i],obj.struct.centro_custo[i], COD_CENTRO_CUSTO);
										 }
									 }
								 }
							  }
							});
		}
	}

	function f_muda_centro_custo(){
	   with(document.forms[0]){
		   f_limpa_select(MATERIAL_ID);
		}
	}

 function localizarFunc() {
    btnLocalizar = document.getElementById('btnLocalizarFuncionario');
    if(btnLocalizar != null && typeof btnLocalizar != "undefined") {
       document.forms[0].COD_FUNCIONARIO.focus();
       btnLocalizar.click();
    }
 }

 function f_busca_montagem(p_equipamento) {
		with(document.forms[0]) {
			if(EQUIPAMENTO_ID.value != '' && MATERIAL_ID.value != ''){
				f_query_wddx('/modulos/manutencao/_componentes/consulta/cfc_manutencao.cfc?method=get_montagem'
							,'equipamento_id='+EQUIPAMENTO_ID.value+'&MATERIAL_ID='+MATERIAL_ID.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									if(obj.struct.data_previsao.length > 0) {
										if(obj.struct.garantia == 1) {
										   sp_previsao.innerHTML = '<span style="color:#FF0000">Dentro da garantia (at '+obj.struct.data_previsao+')</span>';
										}
										else{
										   sp_previsao.innerHTML = '<span style="color:#088A08">Garantia vencida (em '+obj.struct.data_previsao+')</span>';
										}
										sp_previsao.style.display = '';
									}
									else{
										sp_previsao.innerHTML = '';
										sp_previsao.style.display = 'none';
									}
								}
							});
			}
			else{
				sp_previsao.innerHTML = '';
				sp_previsao.style.display = 'none';
			}
		}
	}

   function f_busca_ordens_servico(p_alert) {
      with(document.forms[0]) {
	     f_limpa_select(ORDEM_SERVICO_ID_VINCULO);

		 if(!NUM_ORDEM_SERVICO_VINCULO.value) {
		    f_cria_option('', '-- Informe um N de O.S. --', ORDEM_SERVICO_ID_VINCULO);

		    if(p_alert == 1) {
		       alert(' necessrio informar um N de O.S. para realizar o filtro.');
		    }
		    return;
		 }

		 if(!EQUIPAMENTO_ID.value) {
		    f_cria_option('', '-- Informe um Equipamento --', ORDEM_SERVICO_ID_VINCULO);
			if(p_alert == 1) {
			   alert(' necessrio informar um equipamento para realizar o filtro.');
			}
			return;
		 }
		 f_query_wddx('<cf_url>/modulos/almoxarifado/_componentes/consulta/cfc_manutencao.cfc</cf_url>?method=get_os_equipamento'
		  			 ,'equipamento_id=' + EQUIPAMENTO_ID.value +
					  '&num_ordem_servico=' + NUM_ORDEM_SERVICO_VINCULO.value +
					  '&empresa=0'
					 ,function(obj) {
					     if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
						    if(obj.struct.ordem_servico_id.length > 0) {
							   f_cria_option('', '-- Selecione --', ORDEM_SERVICO_ID_VINCULO);

							   for(var i = 0; i < obj.struct.ordem_servico_id.length; i++) {
							      f_cria_option(obj.struct.ordem_servico_id[i], 'N ' + obj.struct.num_ordem_servico[i] + ' - ' + obj.struct.data_abertura[i] + ' - ' + obj.struct.oficina[i], ORDEM_SERVICO_ID_VINCULO);
							   }
						    }else {
							   f_cria_option('', '-- O.S. no encontrada --', ORDEM_SERVICO_ID_VINCULO);
							}
						 }
				     });
		 }
   }

	function f_busca_valor_data() {
		with(document.forms[0]) {
			if(DATA_LANCAMENTO.value != '' && MATERIAL_ID.value != ''){
				f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_almoxarifado.cfc?method=get_valor_unitario_data'
							,'data='+DATA_LANCAMENTO.value+'&MATERIAL_ID='+MATERIAL_ID.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									if(obj.struct.valor_unitario.length > 0) {
										//Atribui o valor unitrio com base na data
										for(var i=0;i<document.forms[0].elements.length;i++) {
											var v_elem = document.forms[0].elements[i];
											if (v_elem.getAttribute('atributo_id') == 23){
												v_elem.value = obj.struct.valor_unitario;
											}
										}


										//Verifica se possui valor
										if(obj.struct.valor_unitario != ''){
											//calcula o valor total
											f_calcula_valor_total();
										}else{
											alert('No  possvel inserir movimentao pois o material no possui movimentao anterior com custo mdio definido.');
										}


									}

								}
							});
			}else{
				for(var i=0;i<document.forms[0].elements.length;i++) {
					var v_elem = document.forms[0].elements[i];
					if (v_elem.getAttribute('atributo_id') == 23 || v_elem.getAttribute('atributo_id') == 25){
						v_elem.value = '';
					}
				}
			}
		}
	}

	function f_busca_etiquetas() {
		with (document.forms[0]) {
			if (MATERIAL_ID.value) {
			   url = "consultas.cfm?&consulta=99&MATERIAL_ID="+MATERIAL_ID.value;
			   f_query_ajax(url, f_mostra_resultado_etiquetas, null);
			}else{
				f_mostra_resultado_etiquetas('');
			}
		}
	}

	function f_mostra_resultado_etiquetas(p_result) {
		document.getElementById('td_results').innerHTML = p_result;
	}

   function f_busca_fornecedor() {
	   with(document.forms[0]) {
	   	  if (!RAZAO_SOCIAL_LOCAL.value) {
	   	     alert('Digite um fornecedor para busca.');
	   	     return;
	   	  }


	      f_query_wddx('/modulos/almoxarifado/_componentes/consulta/cfc_almoxarifado.cfc?method=get_fornecedor'
					  ,'razao_social='+RAZAO_SOCIAL_LOCAL.value
					  ,f_fornecedor_result);
	      }
	}


    function f_fornecedor_result(obj) {
		with(document.forms[0]) {
			if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
				f_limpa_select(COD_PESSOA_FORNECEDOR);
				if (obj.struct.cliente.length > 0) {
					if (obj.struct.cliente.length > 1) {
						v_opt = f_cria_option('', '-- Selecione o Fornecedor --', COD_PESSOA_FORNECEDOR);
					}
					for (var i=0; i < obj.struct.cliente.length; i++) {
						v_opt = f_cria_option(obj.struct.cod_pessoa_fornecedor[i], obj.struct.razao_social[i], COD_PESSOA_FORNECEDOR);
					}
				}
			}
		}
	}

</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M Transporte e Log&iacute;stica :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height:100%">
<table width="100%" border="0" cellpadding="0" cellspacing="0">
   <form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()">
     <cfif qrEstoqueOperRecurso.recurso eq 1 and 2 eq qrTipo.OPERACAO_TIPO_ID>
	    <legend><cf_language> Interface descontinuada. Utilizar a interface Corporativo / Fiscal / Estoque Operacional / Cadastros / Cadastro de Inventrio. </cf_language></legend>
        <cfabort>
     </cfif>
      <input name="OPERACAO" type="hidden" value="" sempre_ativo="1" fixo="1">
      <input name="CONSULTA" type="hidden" value="" sempre_ativo="1" fixo="1">
      <input name="MOVIMENTACAO_FUNCIONARIO" id="MOVIMENTACAO_FUNCIONARIO" type="hidden" value="<cfoutput>#vars.MOVIMENTACAO_FUNCIONARIO#</cfoutput>">
      <input name="MOVIMENTACAO_EQUIPAMENTO" id="MOVIMENTACAO_EQUIPAMENTO" type="hidden" value="<cfoutput>#vars.MOVIMENTACAO_EQUIPAMENTO#</cfoutput>">
      <input name="FUNCIONARIO" id="FUNCIONARIO" type="hidden" value="0" sempre_ativo="1" fixo="1">
      <input name="EQUIPAMENTO_ID" type="hidden" id="EQUIPAMENTO_ID">
      <input name="CONFIRMA" id="CONFIRMA" type="hidden" value="1" sempre_ativo="1" fixo="1">
      <tr>
         <td>
         <table width="100%" border="0" cellspacing="1" cellpadding="3">
	     <tr style="<cfif qrEstoqueOperRecurso.recurso eq 0 >display= none</cfif>">
		    <td class="texto">Local de Armazenagem:</td>
		     <td class="texto">
              <select name="ESTOQUE_OPER_ID"  fixo="1">
              <cfoutput query="qrEstoqueOper" >
                 <option value="#qrEstoqueOper.estoque_oper_id#">#qrEstoqueOper.estoque_oper#</option>
              </cfoutput>
             </select>
           </td>
		 </tr>
         <tr>
           <td class="texto">Filial:</td>
           <td class="texto">
              <select name="COD_PESSOA_FILIAL" onChange="f_filtra_centro_custo()" fixo="1" <cfif v_nivel_acesso lt 5>disabled</cfif>>
              <cfoutput query="qrFiliais" group="COD_PESSOA">
                 <option value="#qrFiliais.COD_PESSOA_FILIAL#"  <cfif vars.cod_pessoa_filial eq qrFiliais.COD_PESSOA_FILIAL>selected</cfif>>#qrFiliais.NOME#</option>
              </cfoutput>
             </select>
           </td>
        </tr>
        <tr>
          <td class="texto" nowrap>Centro de Custo:</td>
          <td colspan="3" class="texto">
             <select name="COD_CENTRO_CUSTO" fixo="1" onChange="f_muda_centro_custo()" <cfif v_nivel_acesso lt 5>disabled</cfif> >
             <cfoutput query="qrCentroCusto">
                <option value="#qrCentroCusto.COD_CENTRO_CUSTO#"  <cfif vars.cod_centro_custo eq qrCentroCusto.COD_CENTRO_CUSTO>selected</cfif>>#qrCentroCusto.CENTRO_CUSTO#</option>
             </cfoutput>
             </select>
          </td>
        </tr>
		   <cfif vars.OPERACAO_TIPO_ID eq 3>
           <tr <cfif vars.MOVIMENTACAO_FUNCIONARIO eq 1>style="display:none;"</cfif>>
             <td class="texto">Tipo Sa&iacute;da: </td>
             <td class="texto"><select name="OPERACAO_TIPO_ID" id="OPERACAO_TIPO_ID" onChange="f_operacao_tipo()">
               <cfoutput query="qrTipo">
			     <option value="#qrTipo.OPERACAO_TIPO_ID#"  <cfif 3 eq qrTipo.OPERACAO_TIPO_ID>selected</cfif>>#qrTipo.DESCRICAO#</option>
			   </cfoutput>
               </select>
             </td>
             <td nowrap class="texto">&nbsp;</td>
             <td class="texto_negrito">&nbsp;</td>
           </tr>
		   <cfelse>
           <tr>
             <td class="texto">Tipo Entrada: </td>
             <td class="texto"><select name="OPERACAO_TIPO_ID" id="OPERACAO_TIPO_ID" onChange="f_operacao_tipo()">
               <cfoutput query="qrTipo">
			     <option value="#qrTipo.OPERACAO_TIPO_ID#"  <cfif 3 eq qrTipo.OPERACAO_TIPO_ID>selected</cfif>>#qrTipo.DESCRICAO#</option>
			   </cfoutput>
               </select>
             </td>
             <td nowrap class="texto">&nbsp;</td>
             <td class="texto_negrito">&nbsp;</td>
           </tr>
		   </cfif>
           <tr>
             <td class="texto">Filtro:</td>
             <td class="texto"><input name="MATERIAL" type="text" id="MATERIAL" size="20" maxlength="20" onKeyPress="if(event.keyCode == 13) {f_filtra_material()}" />
                 <button type="button" class="botao-16x16" onClick="f_filtra_material()"><img src="/_imagens/botoes/16x16/filtro.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
             <td nowrap class="texto">Saldo:</td>
             <td class="texto_negrito" id="td_saldo">&nbsp;</td>
           </tr>
           <tr>
             <td width="16%" class="texto">Material:</td>
             <td class="texto"><nobr>
               <input name="COD_MATERIAL" type="text" id="COD_MATERIAL" size="20" maxlength="20" >
               <button type="button" class="botao-16x16" onClick="f_busca_material()"><img src="/_imagens/botoes/16x16/filtro.gif" alt="" width="16" height="16" align="absmiddle"></button>
               <select name="MATERIAL_ID" id="MATERIAL_ID" obrigatorio="1" display="MATERIAL" style="width:600px" onChange="f_busca_codigo_material();f_busca_solicitacao();f_busca_atributos();f_busca_etiquetas();">
                              </select>
               <button onClick="f_busca_material()" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle"></button>
               <input name="CONTROLE_ID_MAT" type="hidden" id="CONTROLE_ID_MAT">
             </nobr></td>
             <td width="1%" nowrap class="texto">C&oacute;d. Genu&iacute;no: </td>
             <td width="99%" class="texto_negrito" id="td_cod_genuino">&nbsp;</td>
           </tr>
           <tr>
             <td width="16%" class="texto">Data:</td>
             <td class="texto"><input name="DATA_LANCAMENTO" type="text" id="DATA_LANCAMENTO" maxlength="30" obrigatorio="0" display="DATA" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" value="<cfoutput>#LSDateFormat(now())# #lsTimeFormat(now())#</cfoutput>" fixo="1" onChange="f_busca_valor_data();"></td>
             <td nowrap class="texto">C&oacute;d. Fabricante: </td>
             <td class="texto_negrito"  id="td_cod_fabricante">&nbsp;</td>
           </tr>
           <tr>
             <td class="texto">Quantidade:</td>
             <td class="texto">
             <input name="QUANTIDADE" style="width: 80px" type="text" id="QUANTIDADE" maxlength="30" obrigatorio="1" display="QUANTIDADE" onKeyPress="if(event.keyCode == 13) localizarFunc(); return f_formata_numero_decimal(this,event)" value="" onChange="f_calcula_valor_total()">
             <span style="width:18%;" class="texto_negrito" id="sp_unidade" ></span>
             <span style="width:40%;" class="obrigatorio" id="sp_exige_devolucao"></span>
             <span style="width:28%;" class="obrigatorio" id="sp_previsao"></span>
             </td>
             <td nowrap class="texto">C&oacute;d. Paralelo: </td>
             <td class="texto_negrito" id="td_cod_paralelo">&nbsp;</td>
           </tr>
           <tr id="tr_num_nota" <cfif v_entrada eq 0>style="display:none"</cfif>>
             <td class="texto">Nota fiscal: </td>
             <td class="texto"><input name="NUM_NOTA_FISCAL" type="text" id="NUM_NOTA_FISCAL" onChange="f_busca_nota_fiscal()" size="10" maxlength="10" display="NUMERO DA NOTA FISCAL">
             &nbsp;
             <select name="NUM_NOTA_ID" id="NUM_NOTA_ID">
             </select>             </td>
             <td nowrap class="texto">&nbsp;</td>
             <td class="texto_negrito" id="td_cod_paralelo">&nbsp;</td>
           </tr>
           <cfif vars.MOVIMENTACAO_EQUIPAMENTO eq 1>
              <tr id="tr_equipamento">
                 <td class="texto">Placa:</td>
                 <td colspan="3" class="texto"><input name="COD_EQUIPAMENTO" type="text" obrigatorio=<cfif vars.MOVIMENTACAO_EQUIPAMENTO eq 1>"1"<cfelse>"0"</cfif>  id="COD_EQUIPAMENTO" onKeyPress="return f_formata(this,event,'AAAAAAAAAA')" size="18" maxlength="15" onChange="f_busca_equipamento();f_busca_montagem();" display="PLACA"> <input name="MATERIAL_DESCRICAO" type="text" disabled id="MATERIAL_DESCRICAO" style="width:450px" size="60" maxlength="70" readonly>
                    <button type="button" class="botao-16x16" onClick="NewWindow('/modulos/almoxarifado/_consultas/localizar_equipamento.cfm?cod_veiculo=COD_EQUIPAMENTO&funcao=f_busca_equipamento()','_blank',600,400,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Localizar Equipamento" width="16" height="16" align="absmiddle"></button>
                 </td>
              </tr>
           </cfif>
           <cfif vars.MOVIMENTACAO_FUNCIONARIO eq 1>
               <tr id="tr_equipamento">
                 <td class="texto">Funcionrio:</td>
                 <td colspan="3" class="texto"><input type="text" name="COD_FUNCIONARIO" id="COD_FUNCIONARIO" maxlength="10" tipo="numerico" display="MATRCULA DO FUNCIONRIO" onChange="f_busca_pessoa_responsavel()" onKeyPress="return f_formata(this, '0000000000')" style="width: 85px;" />
    <input type="text" name="RESPONSAVEL" id="RESPONSAVEL" obrigatorio="1" readonly display="FUNCIONRIO" style="width: 300px;" />
    <input type="hidden" name="COD_PESSOA_RESPONSAVEL" id="COD_PESSOA_RESPONSAVEL" obrigatorio="1" display="FUNCIONRIO" />
    <button id="btnLocalizarFuncionario" type="button" class="botao-16x16" onClick="NewWindow('/modulos/almoxarifado/_consultas/localizar_funcionario.cfm?funcao=f_busca_pessoa_responsavel()&field=COD_PESSOA,COD_FUNCIONARIO,NOME_FUNCIONARIO&campo=COD_PESSOA_RESPONSAVEL,COD_FUNCIONARIO,RESPONSAVEL&num_modalidade=4,6', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Respons&aacute;vel" title="Buscar Respons&aacute;vel" width="16" height="16" align="absmiddle" /></button></td>
           </tr>
           </cfif>
           <tr id="tr_os_vinculo" <cfif vars.MOVIMENTACAO_FUNCIONARIO eq 1>style="display:none;"</cfif>>
              <td class="texto">O.S. de V&iacute;nculo:</td>
              <td colspan="2" class="texto"><input type="text" name="NUM_ORDEM_SERVICO_VINCULO" id="NUM_ORDEM_SERVICO_VINCULO" maxlength="10" tipo="numerico" display="N O.S. DE VNCULO" onChange="f_busca_ordens_servico(0)" onKeyPress="return f_formata(this, '0000000000')" style="width: 110px;" />&nbsp;
                 <button type="button" class="botao-16x16" onClick="f_busca_ordens_servico(1)"><img src="/_imagens/botoes/16x16/filtro.gif" alt="Buscar O.S. de V&iacute;nculo" title="Buscar O.S. de V&iacute;nculo" width="16" height="16" align="absmiddle" /></button>
                 <select name="ORDEM_SERVICO_ID_VINCULO" id="ORDEM_SERVICO_ID_VINCULO" display="O.S. DE VNCULO">
                 <option value="">-- Informe um N&ordm; de O.S. --</option>
                 </select>
              </td>
           </tr>
           <tr>
                 <td class="texto">CC Gerencial:</td>
                 <td class="texto">
                 	<input type="hidden" name="ORGANIZACIONAL_ID" id="ORGANIZACIONAL_ID" >
                    <input type="text" name="COD_ORGANIZACIONAL" id="COD_ORGANIZACIONAL" obrigatorio="1" display="CC GERENCIAL" size="18" onChange="f_busca_gerencial()" >
					<input type="text" name="DESCRICAO_COMPLETA" id="DESCRICAO_COMPLETA" style="width:450px" readonly >
                    <button type="button" id="busca_ccg" class="botao-16x16" onClick="NewWindow('/modulos/almoxarifado/_componentes/consulta/localizar_ccusto_gerencial.cfm?field=COD_ORGANIZACIONAL,DESCRICAO_COMPLETA,ORGANIZACIONAL_ID&campo=COD_ORGANIZACIONAL,DESCRICAO_COMPLETA,ORGANIZACIONAL_ID&somente_ativos=1&somente_folhas=1','_blank',600,400,'yes')">
                    	<img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" />
                    </button>
                 </td>
               </tr>

		<tr id="tr_fornecedor">
          <td class="texto">Fornecedor:</td>
          <td class="texto">
		  	<nobr>
		  		<input name="RAZAO_SOCIAL_LOCAL" type="text" id="RAZAO_SOCIAL_LOCAL" size="18" >
                <button type="button" class="botao-16x16" onClick="f_busca_fornecedor()"><img src="/_imagens/botoes/16x16/filtro.gif" alt="" width="16" height="16" align="absmiddle"></button>
            	<select name="COD_PESSOA_FORNECEDOR" id="COD_PESSOA_FORNECEDOR"  display="FORNECEDOR" style="width:600px" ></select>
			</nobr>
		  </td>
         </tr>
			<tr>
             <td class="texto">Observa&ccedil;&atilde;o:</td>
             <td colspan="3" class="texto">
             <textarea name="OBSERVACAO" id="OBSERVACAO" style="width: 100%; height: 80px"></textarea></td>
           </tr>
           <tr <cfif vars.MOVIMENTACAO_FUNCIONARIO eq 1>style="display:none;"</cfif>>
             <td class="texto">Solicita&ccedil;&otilde;es:</td>
             <td colspan="3" class="texto"><select name="SOLICITACAO_ID" id="SOLICITACAO_ID">
             </select>
             </td>
           </tr>
           <tr>
             <td colspan="4" class="texto"><fieldset><legend>Atributos</legend>
               <table width="100%" border="0" cellspacing="1" cellpadding="3" id="tab_atributos">
					<tbody>
					</tbody>
               </table>
             </fieldset>
             </td>
           </tr>
		  <tr>
		  <td id='td_results' colspan="4" class="texto" style="<cfif qrEstoqueOperRecurso.recurso eq 0 >display= none</cfif>">
</td>
</tr>
        </table>
        </td>
      </tr>
   </form>
</table>
</body>
<cfset requestend = 0>
<script language="javascript1.2">
	window.onload = function() {
		f_controla_campos(1);
		document.forms[0].MATERIAL.focus();
        f_operacao_tipo();
		<cfif vars.MOVIMENTACAO_FUNCIONARIO eq 1>
			document.getElementById("FUNCIONARIO").setAttribute('value',1);
		</cfif>
	}
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="100%" style="display:none"></iframe>
