<cfcomponent extends="_transportes.funcoes.cfc_init">
    <!---
	-- PROPÓSITO
	-- Altera material vinculado ao equipamento na analise de equipamentos
	-- LOUIS 30/07/2007 10:44 - CRIADO
	--->
	<cffunction name='alt_material_analise' displayname='Altera recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_alt_material_analise' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Insere materiais a OS
	-- fabiog 07/03/2016 09:54:26 - CRIADO
	--->
	<cffunction name='ins_os_material' displayname='Insere materiais a OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='POSICAO_ID' required='no'>
		<cfargument name='COD_EQUIPAMENTO_MONTADO' required='yes'>
		<cfargument name='COD_EQUIPAMENTO_RETIRADO' required='no'>
		<cfargument name='COD_EQUIPAMENTO_COMPONENTE' required='no'>
		<cfargument name='VALOR_UNITARIO' required='no'>
		<cfargument name='VALOR_TOTAL' required='no'>
		<cfargument name='COD_PESSOA_RETIRADA' required='yes'>
		<cfargument name='FORA_CONTRATO' required='no'>
        <cfargument name='LANCAMENTO_ID_SAIDA' required='no'>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
		<cftry>
           <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_EQUIPAMENTO_MONTADO#' >
              <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_EQUIPAMENTO_RETIRADO#' >
              <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_EQUIPAMENTO_COMPONENTE#' >
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RETIRADA#'  null='#iif(len(trim(arguments.COD_PESSOA_RETIRADA)), de('no'), de('yes'))#'>
              <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
              <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FORA_CONTRATO#'  null='#iif(len(trim(arguments.FORA_CONTRATO)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCAMENTO_ID_SAIDA#'  null='#iif(len(trim(arguments.LANCAMENTO_ID_SAIDA)), de('no'), de('yes'))#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
		 </cfstoredproc>
           <cfset retorno.erro = false>
           <cfset retorno.mensagem = JSStringFormat('Material vinculado com sucesso')>
        <cfcatch>
           <cfset retorno.erro = true>
           <cfset retorno.mensagem = cfcatch>
           <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

</cfcomponent>
