<cfcomponent displayname="Controle e manipulao" extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Insere atributo
	-- GUTO 28/06/2006 14:04:11 - CRIADO
	--->
	<cffunction name='ins_atributo' displayname='Insere atributo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='TIPO_DADO' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cfargument name='ESTOQUE' required='yes'>
		<cfargument name='ENTRADA' required='yes'>
		<cfargument name='SAIDA' required='yes'>
        <cfargument name='DESCRICAO_INGLES' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   variable='retorno.ATRIBUTO_ID'  null='yes'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_DADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ESTOQUE#'  null='#iif(len(trim(arguments.ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ENTRADA#'  null='#iif(len(trim(arguments.ENTRADA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SAIDA#'  null='#iif(len(trim(arguments.SAIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO_INGLES#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>

				<!--- Insere os itens para atributo do tipo LISTA --->
				<cfscript>
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTO_ITEM");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_valor)#" index="count">
					<cfscript>
						this.ins_atributo_item(	atributo_id = retorno.atributo_id,
												valor       = v_valor[count]);
					</cfscript>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atributo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera dados do atributo
	-- GUTO 28/06/2006 14:40:30 - CRIADO
	--->
	<cffunction name='alt_atributo' displayname='Altera dados do atributo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='TIPO_DADO' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cfargument name='ESTOQUE' required='yes'>
		<cfargument name='ENTRADA' required='yes'>
		<cfargument name='SAIDA' required='yes'>
        <cfargument name='DESCRICAO_INGLES' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_DADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ESTOQUE#'  null='#iif(len(trim(arguments.ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ENTRADA#'  null='#iif(len(trim(arguments.ENTRADA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SAIDA#'  null='#iif(len(trim(arguments.SAIDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO_INGLES#' >
				</cfstoredproc>

				<!--- Insere os itens para atributo do tipo LISTA --->
				<cfscript>
					v_valor_item = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTO_ITEM");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ATRIBUTO_ITEM");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ATRIBUTO_ITEM, lista2 = ArrayToList(v_item_id));
				</cfscript>

				<!--- Excluir os itens --->
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_atributo_item ( atributo_id = arguments.atributo_id,
											     item_id     = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_valor_item)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_atributo_item(	atributo_id = arguments.atributo_id,
													valor       = v_valor_item[count]);
						}
						else {
							this.alt_atributo_item(	atributo_id = arguments.atributo_id,
													item_id     = v_item_id[count],
													valor       = v_valor_item[count]);
						}
					</cfscript>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atributo alterado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui atributo
	-- GUTO 28/06/2006 14:41:30 - CRIADO
	--->
	<cffunction name='del_atributo' displayname='Exclui atributo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atributo excludo com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere item ao atributo
	-- GUTO 28/06/2006 14:46:26 - CRIADO
	--->
	<cffunction name='ins_atributo_item' displayname='Insere item ao atributo' access='remote' output='false'>;
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_atributo_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable="retorno.ITEM_ID">
				</cfstoredproc>
		<cfreturn/>
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera item do atributo
	-- GUTO 28/06/2006 14:59:59 - CRIADO
	--->
	<cffunction name='alt_atributo_item' displayname='Altera item do atributo' access='remote' output='false'>;
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_atributo_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
				</cfstoredproc>
		<cfreturn/>
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui item do atributo
	-- GUTO 28/06/2006 14:47:29 - CRIADO
	--->
	<cffunction name='del_atributo_item' displayname='Exclui item do atributo' access='remote' output='false'>;
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_atributo_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn/>
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere um material
	-- cristofer 07/07/2006 09:05:27 - CRIADO
	--->
	<cffunction name='ins_material' displayname='Insere um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='MATERIAL_PAI' required='yes'>
		<cfargument name='COD_MATERIAL' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ESTOQUE' required='no' default="0">
		<cfargument name='COMPOE_DESCRICAO' required='no' default="0">
		<cfargument name='UNID_ESTOQUE' required='yes'>
		<cfargument name='UNID_COMERCIALIZACAO' required='yes'>
		<cfargument name='IDENTIFICADO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#' variable='retorno.MATERIAL_ID'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_PAI#'  null='#iif(len(trim(arguments.MATERIAL_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_MATERIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPOE_DESCRICAO#'  null='#iif(len(trim(arguments.COMPOE_DESCRICAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ESTOQUE#'  null='#iif(len(trim(arguments.ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UNID_ESTOQUE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UNID_COMERCIALIZACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.IDENTIFICADO#'  null='#iif(len(trim(arguments.IDENTIFICADO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<!--- Insere os itens para atributo do tipo LISTA --->
				<cfscript>
					//retorno.material_id = arguments.material_id;
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_ATRIBUTOS");
					v_valor_padrao = this.ListaToArray (lista = arguments, variavel = "VALOR_PADRAO_ATRIBUTOS");
					v_obrigatorio = this.ListaToArray (lista = arguments, variavel = "OBRIGATORIO_ATRIBUTOS");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.ins_material_atributo(material_id = retorno.material_id,
												   atributo_id = v_atributo_id[count],
												   valor_padrao = v_valor_padrao[count],
												   obrigatorio = v_obrigatorio[count]	);
					</cfscript>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera um material
	-- cristofer 07/07/2006 09:08:26 - CRIADO
	--->
	<cffunction name='upd_material_pai' displayname='Altera um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='MATERIAL_PAI' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_almoxarifado");
					qrMaterial = conn.get_material(material_id = arguments.material_id);
					if(arguments.material_pai eq 0)
						arguments.material_pai = '';
				</cfscript>
				<cfif not qrMaterial.recordcount>
					<cfthrow message="No foi possvel localizar o material!">
				</cfif>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.MATERIAL_ID#'  null='#iif(len(trim(qrMaterial.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_PAI#'  null='#iif(len(trim(arguments.MATERIAL_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.COD_MATERIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.COMPOE_DESCRICAO#'  null='#iif(len(trim(qrMaterial.COMPOE_DESCRICAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.ESTOQUE#'  null='#iif(len(trim(qrMaterial.ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.UNIDADE_ESTOQUE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.UNIDADE_COMERCIALIZACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.IDENTIFICADO#'  null='#iif(len(trim(qrMaterial.IDENTIFICADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.ATIVO#'  null='#iif(len(trim(qrMaterial.ATIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera um material
	-- cristofer 07/07/2006 09:08:26 - CRIADO
	--->
	<cffunction name='upd_material' displayname='Altera um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='MATERIAL_PAI' required='yes'>
		<cfargument name='COD_MATERIAL' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ESTOQUE' required='no' default="0">
		<cfargument name='COMPOE_DESCRICAO' required='no' default="0">
		<cfargument name='UNID_ESTOQUE' required='yes'>
		<cfargument name='UNID_COMERCIALIZACAO' required='yes'>
		<cfargument name='IDENTIFICADO' required='no' default="0">
		<cfargument name='ATIVO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_PAI#'  null='#iif(len(trim(arguments.MATERIAL_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_MATERIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPOE_DESCRICAO#'  null='#iif(len(trim(arguments.COMPOE_DESCRICAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ESTOQUE#'  null='#iif(len(trim(arguments.ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UNID_ESTOQUE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UNID_COMERCIALIZACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.IDENTIFICADO#'  null='#iif(len(trim(arguments.IDENTIFICADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Insere os itens para atributo do tipo LISTA --->
				<cfscript>
					retorno.material_id = arguments.material_id;
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_ATRIBUTOS");
					v_valor_padrao = this.ListaToArray (lista = arguments, variavel = "VALOR_PADRAO_ATRIBUTOS");
					v_obrigatorio = this.ListaToArray (lista = arguments, variavel = "OBRIGATORIO_ATRIBUTOS");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ATRIBUTOS, lista2 = ArrayToList(v_atributo_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_almoxarifado");
					qrAtributos = conn.get_material_atributo(material_id = retorno.material_id);
				</cfscript>
				<cfoutput query="qrAtributos">
					<cfscript>
						this.del_material_atributo(	material_id = retorno.material_id,
													atributo_id = qrAtributos.atributo_id);
					</cfscript>
				</cfoutput>
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.ins_material_atributo(material_id = retorno.material_id,
												   atributo_id = v_atributo_id[count],
												   valor_padrao = v_valor_padrao[count],
												   obrigatorio = v_obrigatorio[count]	);
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui um material
	-- cristofer 07/07/2006 09:09:17 - CRIADO
	--->
	<cffunction name='del_material' displayname='Exclui um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Vincula material ao modelo
	-- Guto 24/11/2007 - CRIADO
	--->
	<cffunction name='vincula_material_modelo' displayname='Vincula material ao MODELO' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_vincula_material_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material vinculado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Vincula material ao grupo
	-- Guto 24/11/2007 - CRIADO
	--->
	<cffunction name='vincula_material_grupo' displayname='Vincula material ao grupo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_vincula_material_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material vinculado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere um atributo no material
	-- cristofer 10/07/2006 16:44:07 - CRIADO
	--->
	<cffunction name='ins_material_atributo' displayname='Insere um atributo no material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='OBRIGATORIO' required='yes'>
		<cfargument name='VALOR_PADRAO' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_material_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OBRIGATORIO#'  null='#iif(len(trim(arguments.OBRIGATORIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR_PADRAO#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui um atributo do material
	-- cristofer 10/07/2006 16:45:10 - CRIADO
	--->
	<cffunction name='del_material_atributo' displayname='Exclui um atributo do material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_material_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere um atributo especifico para a filial
	-- guto 09/01/2007 10:45:41 - CRIADO
	--->
	<cffunction name='ins_material_atributo_filial' displayname='Insere um atributo especifico para a filial' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_ins_material_atr_filial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atributo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Desvincula material do atributo e da filial
	-- guto 09/01/2007 11:42:55 - CRIADO
	--->
	<cffunction name='del_material_atributo_filial' displayname='Desvincula material do atributo e da filial' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_del_material_atr_filial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atributo excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere as cotacoes para os materiais de uma requisicao
	-- cristofer 17/07/2006 09:08:26 - CRIADO
	--->
	<cffunction name='ins_cotacao' displayname='Altera um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name="REQUISICAO_ID" required="yes">
		<cfargument name="COD_PESSOA_FORNECEDOR" required="yes">
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					v_unitario = this.ListaToArray (lista = arguments, variavel = "UNITARIO_COTACOES");
					v_total = this.ListaToArray (lista = arguments, variavel = "TOTAL_COTACOES");
					v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_COTACOES");
					v_material_id = this.ListaToArray (lista = arguments, variavel = "MATERIAL_ID_COTACOES");
					v_quantidade = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_COTACOES");
					v_cod_unidade = this.ListaToArray (lista = arguments, variavel = "COD_UNIDADE_COTACOES");
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop from="1" to="#ArrayLen(v_material_id)#" index="count">
					<cfstoredproc procedure='oper.pkg_compras_dml.prc_ins_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.REQUISICAO_ID#'  null='#iif(len(trim(arguments.REQUISICAO_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#v_MATERIAL_ID[count]#'  null='#iif(len(trim(v_MATERIAL_ID[count])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#LSDateFormat(now())# #TimeFormat(now(), "HH:MM:SS")#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_COD_UNIDADE[count]#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#v_QUANTIDADE[count]#'  null='#iif(len(trim(v_QUANTIDADE[count])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#v_UNITARIO[count]#'  null='#iif(len(trim(v_UNITARIO[count])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#v_TOTAL[count]#'  null='#iif(len(trim(v_TOTAL[count])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_OBSERVACAO[count]#' >
						<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.COTACAO_ID' >
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'  null="yes" variable='retorno.ROWID'>
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cotao atualizada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere um inventario do material
	-- cristofer 27/07/2006 15:55:11 - CRIADO
	--->
	<cffunction name='inventario_material' displayname='Insere um inventario do material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_inventario_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.LANCAMENTO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Inventario inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>



	<!---
	-- PROPSITO
	-- Insere uma movimentacao de materiais
	-- cristofer 31/07/2006 11:04:27 - CRIADO
	--->
	<cffunction name='ins_movimentacao' displayname='Insere uma movimentacao de materiais' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LANCAMENTO_ID' required='no' default="">
		<cfargument name='OPERACAO_TIPO_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='no' default="">
		<cfargument name='SOLICITACAO_ID' required='no' default="">
      <cfargument name='EQUIPAMENTO_ID' required='no' default="">
      <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
      <cfargument name='COD_PESSOA_RESPONSAVEL' required='no' default="">
      <cfargument name='COD_CENTRO_CUSTO' required='yes'>
	 <cfargument name='ESTOQUE_OPER_ID' required='no' default="">
	 <cfargument name='ETIQUETA_ID' required='no' default="">
	 <cfargument name='COD_PESSOA_FORNECEDOR' required='no' default="">
  		<cftry>
			<cftransaction action='begin'>
				 <!--- Insero de Etiquetas--->
				 <cfif len(trim(arguments.ETIQUETA_ID))>
					<cfscript>
	                    v_etiqueta_id = ListToArray(arguments.ETIQUETA_ID);
	                </cfscript>

	                <cfloop from="1" to="#ArrayLen(v_etiqueta_id)#" index="count">
	                    <cfscript>
	                       retorno = this.ins_lista_temp(VALOR = v_etiqueta_id[count]
	                                                   , TIPO  = 'EOPER_ETIQUETA_ID' );
	                    </cfscript>
	                    <cfif retorno.erro>
	                        <cfthrow object="#ret.mensagem#">
	                    </cfif>
	                </cfloop>
 				</cfif>

				<cfif (arguments.OPERACAO_TIPO_ID eq 3 or arguments.OPERACAO_TIPO_ID eq 16 or  arguments.OPERACAO_TIPO_ID eq 17  ) >
                    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                            select mc.atividade_id
                              from (select t.material_id, material_pai, material
                                      from almoxarifado.v$material_dados t
                                     start with t.material_id = #arguments.MATERIAL_ID#
                                   connect by t.material_id = prior t.material_pai) a
                              inner join manutencao.v$material_atividade_baixa mc
                                      on mc.material_id = a.material_id
                    </cfquery>
                    <cfif qr_result.RecordCount gt 0>
                        <cfthrow message="Para materiais que exigem ATIVIDADES para baixa de estoque  necessrio a abertura de uma O.S.">
                    </cfif>
                </cfif>
                  <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_movimentacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                      <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#' variable='retorno.LANCAMENTO_ID'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OPERACAO_TIPO_ID#'  null='#iif(len(trim(arguments.OPERACAO_TIPO_ID)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_LANCAMENTO#' >
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null='yes'>
                      <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value=''>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					  <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ESTOQUE_OPER_ID#'  null='#iif(len(trim(arguments.ESTOQUE_OPER_ID)), de('no'), de('yes'))#'>
     		          <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null='yes'>
	                  <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null='yes'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null='yes'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
				      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null='yes'>
					  <cfif arguments.OPERACAO_TIPO_ID eq 3 or arguments.OPERACAO_TIPO_ID eq 16 or  arguments.OPERACAO_TIPO_ID eq 17>
					     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
				      
					      <cfif arguments.operacao_tipo_id eq 3 and Len(Trim(arguments.ordem_servico_id_vinculo)) >
							 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORDEM_SERVICO_ID_VINCULO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_VINCULO)), de('no'), de('yes'))#'>
						  <cfelse>
                             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null='yes'>
						  </cfif>
					  <cfelse>
                          <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'    null='yes'>
                          <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null='yes'>
					  </cfif>

				  </cfstoredproc>
                <cfscript>
                    v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_ATRIBUTOS");
                    v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTOS");
                </cfscript>

                <cfset v_valor_unitario = 0>
                <cfset v_valor_total = 0>

                <!--- Excluir os itens --->
                <cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
                    <cfscript>
                        this.ins_movimentacao_atributo( lancamento_id = retorno.lancamento_id,
                                                        material_id	= arguments.material_id,
                                                        atributo_id = v_atributo_id[count],
                                                        valor		= v_valor[count]);

                       if(v_atributo_id[count] eq 23){ //Valor Unitrio
					      v_valor_unitario = v_valor[count];
					   }else if(v_atributo_id[count] eq 25){//Valor Total
					      v_valor_total = v_valor[count];
					   }
                    </cfscript>
                </cfloop>

             

                <!--- Vincula a OS (caso informada) --->
                <cfif arguments.operacao_tipo_id eq 3 and Len(Trim(arguments.ordem_servico_id_vinculo))>
                   <cfscript>
                      conn_manut = CreateComponent("modulos.almoxarifado._componentes.manipulacao.cfc_manutencao");
					  ins_os_mat = conn_manut.ins_os_material(ordem_servico_id           = arguments.ordem_servico_id_vinculo
                                                             ,material_id	             = arguments.material_id
                                                             ,quantidade	             = arguments.QUANTIDADE
                                                             ,posicao_id                 = ''
                                                             ,cod_equipamento_montado    = ''
                                                             ,cod_equipamento_retirado   = ''
                                                             ,cod_equipamento_componente = ''
                                                             ,valor_unitario             = v_valor_unitario
                                                             ,valor_total                = v_valor_total
                                                             ,cod_pessoa_retirada        = #session.cod_pessoa_usuario#
                                                             ,fora_contrato              = ''
															 ,lancamento_id_saida	     = retorno.lancamento_id
															 ,organizacional_id          = arguments.organizacional_id
															 );

				   </cfscript>

                   <cfif ins_os_mat.erro>
                      <cfthrow object="#ins_os_mat.mensagem#">
                   </cfif>
                </cfif>

                <cfscript>
                    // Se for saida ou devolucao de funcionario vincula a um funcionario
                    if ((arguments.OPERACAO_TIPO_ID eq 3 or arguments.OPERACAO_TIPO_ID eq 8) and len(trim(arguments.cod_pessoa_responsavel))) {
                        this.ins_movimentacao_funcionario( lancamento_id = retorno.lancamento_id,
                                                           cod_pessoa = arguments.cod_pessoa_responsavel);
                    }
                </cfscript>

                <!--- Vincula a Solicitao --->
                <cfif Len(Trim(arguments.SOLICITACAO_ID))>
                    <cfscript>
                        ret = this.confirma_solicitacao_material(SOLICITACAO_ID    = arguments.SOLICITACAO_ID,
                                                                 LANCAMENTO_ID_MOV = retorno.lancamento_id,
                                                                 DATA_ATENDIMENTO  = arguments.DATA_LANCAMENTO);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>

                <cfscript>
                   this.prc_validar_atributo_obrigatorio( material_id = arguments.material_id);
                </cfscript>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Movimentao inserida com sucesso')>

			    <cfscript>
				    ret_custo_med = this.calcula_custo_medio(lancamento_id = retorno.lancamento_id);
				</cfscript>

				<cfif ret_custo_med.erro>
                   <cfthrow object="#ret_custo_med.mensagem#">
                </cfif>
            </cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

  <!---
	-- PROPSITO
	-- Insere registros nalista temp
	-- Luiz 16/05/2017 - CRIADO
	--->
    <cffunction name='ins_lista_temp' displayname='Inserir registros na lista temporria' access='remote' returntype='Struct' output='true'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
           <cfstoredproc procedure='kss.pkg_lista_temp.prc_ins_lista_temp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
			  <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'    value='#arguments.TIPO#' >
           </cfstoredproc>
           <cfset retorno.erro = false>
           <cfset retorno.mensagem = JSStringFormat('Itens inseridos com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!---
	-- PROPSITO
	-- Insere uma movimentacao de materiais baseado nos itens selecionados do pedido
	-- GUSTAVOC 22/10/2010 13:47 - CRIADO - 19999 3/7 - Criar nova tela de entrada de material
	--->
	<cffunction name='ins_movimentacao_pedido' displayname='Insere uma movimentacao de materiais' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LANCAMENTO_ID' required='no' default="">
		<cfargument name='OPERACAO_TIPO_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='SOLICITACAO_ID' required='no' default="">
		<cfargument name='COD_CENTRO_CUSTO' required='no' default="">
        <cfargument name='LOCALIZACAO' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>

            	<!--- PEGA AS VARIVEIS DOS ARRAYS --->
				<cfscript>
                    v_material_id = this.ListaToArray (lista = arguments, variavel = "MATERIAL_ID");
                    v_qtde_util   = this.ListaToArray (lista = arguments, variavel = "QTDE_UTILIZADA");
					v_localizacao   = this.ListaToArray (lista = arguments, variavel = "LOCALIZACAO");
                    v_observacao  = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO");
					v_pedido_item = this.ListaToArray (lista = arguments, variavel = "PEDIDO_ITEM_ID");
                </cfscript>

            	<cfloop from="1" to="#ArrayLen(v_material_id)#" index="indice">

					<cfif arguments.OPERACAO_TIPO_ID eq 3>
                        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                                select mc.atividade_id
                                  from (select t.material_id, material_pai, material
                                          from almoxarifado.v$material_dados t
                                         start with t.material_id = #v_material_id[indice]#
                                       connect by t.material_id = prior t.material_pai) a
                                  inner join manutencao.v$material_atividade_baixa mc
                                          on mc.material_id = a.material_id
                        </cfquery>
                        <cfif qr_result.RecordCount gt 0>
                            <cfthrow message="Para materiais que exigem ATIVIDADES para baixa de estoque  necessrio a abertura de uma O.S.">
                        </cfif>
                    </cfif>
                    <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_movimentacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#' variable='retorno.LANCAMENTO_ID'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OPERACAO_TIPO_ID#'  null='#iif(len(trim(arguments.OPERACAO_TIPO_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_LANCAMENTO#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#v_material_id[indice]#'  null='#iif(len(trim(v_material_id[indice])), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#v_qtde_util[indice]#'  null='#iif(len(trim(v_qtde_util[indice])), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_observacao[indice]#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value=''  null='yes'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#v_pedido_item[indice]#'  null='#iif(len(trim(v_pedido_item[indice])), de('no'), de('yes'))#'>
                        <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_localizacao[indice]#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                    <cfscript>
                        v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_ATRIBUTOS");
                        v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTOS");
                    </cfscript>
                    <!--- Excluir os itens --->
                    <cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
                        <cfscript>
                            this.ins_movimentacao_atributo( lancamento_id = retorno.lancamento_id,
                                                            material_id	= arguments.material_id,
                                                            atributo_id = v_atributo_id[count],
                                                            valor		= v_valor[count]);
                        </cfscript>
                    </cfloop>

                    <cfscript>
                        // Se for saida para uso vincula a uma placa
                        if (arguments.OPERACAO_TIPO_ID eq 3) {
                            this.ins_movimentacao_equipamento( lancamento_id = retorno.lancamento_id,
                                                               equipamento_id = arguments.equipamento_id);
                        }
                    </cfscript>

                    <!---Vincula a Solicitao--->
                    <cfif Len(Trim(arguments.SOLICITACAO_ID))>
                        <cfscript>
                            ret = this.confirma_solicitacao_material(SOLICITACAO_ID    = arguments.SOLICITACAO_ID,
                                                                     LANCAMENTO_ID_MOV = retorno.lancamento_id,
                                                                     DATA_ATENDIMENTO  = arguments.DATA_LANCAMENTO);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>

                </cfloop>

                <cfset retorno.erro = false>
            	<cfset retorno.mensagem = JSStringFormat('Movimentacao inserida com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere um atributo da movimentacao
	-- cristofer 01/08/2006 10:20:43 - CRIADO
	--->
	<cffunction name='ins_movimentacao_atributo' displayname='Insere um atributo da movimentacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_movimentacao_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Vincula a movimentao de estoque ao equipamento
	-- GUTO 30/01/2007 15:00:07 - CRIADO
	--->
	<cffunction name='ins_movimentacao_equipamento' displayname='Vincula a movimentao de estoque ao equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='LANCAMENTO_ID_SAIDA' required='no' default="">
            <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_mov_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID_SAIDA#'  null='#iif(len(trim(arguments.LANCAMENTO_ID_SAIDA)), de('no'), de('yes'))#'>
            </cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!---
	-- PROPSITO
	-- Atualiza a movimentao de estoque com os dados do equipamento de origem
	-- LuizG 14/05/2018 13:52:23 - CRIADO
	--->
	<cffunction name='atualiza_movimentacao_equipamento_origem' displayname='Atualiza a movimentao de estoque do equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
            <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_atualiza_mov_equip_orig' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>               
            </cfstoredproc>
		<cfreturn structnew() />
	</cffunction>




	<!---
	-- PROPSITO
	-- Inicia a transferencia de uma material
	-- cristofer 01/08/2006 14:28:44 - CRIADO
	--->
	<cffunction name='ins_transferencia' displayname='Inicia a transferencia de uma material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='DATA_SAIDA' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL_SAIDA' required='yes'>
      <cfargument name='COD_CENTRO_CUSTO_SAIDA' required='yes'>
      <cfargument name='COD_PESSOA_FILIAL_DESTINO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO_DESTINO' required='yes'>
		<cfargument name='COD_EQUIPAMENTO' required='no' default="">
		<cfargument name='ETIQUETA_ID' required='no' default="">

        <!-- Argumento que identifica se a transferencia  feita pela tela de transferencia de materiais usados --->
        <cfargument name='COM_CHECKS' required='no' default="0">
        <cftry>
			<cftransaction action='begin'>
				<!--- Insero de Etiquetas--->
                <cfif len(trim(arguments.ETIQUETA_ID))>
				<cfscript>
                    v_etiqueta_id = ListToArray(arguments.ETIQUETA_ID);
                </cfscript>

                <cfloop from="1" to="#ArrayLen(v_etiqueta_id)#" index="count">
                    <cfscript>
                       retorno = this.ins_lista_temp(VALOR = v_etiqueta_id[count]
                                                   , TIPO  = 'EOPER_ETIQUETA_ID' );
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
				</cfif>

				<cfif arguments.com_checks eq 1>
               	 	<cfloop list="#arguments.material_id#" delimiters="," index="mat_id">
                        <cfscript>
							if ( ListLen(mat_id,'_') gt 2 ) {
								v_cod_equipamento = ListGetAt(mat_id,3,'_');
							} else { v_cod_equipamento = ''; }
						</cfscript>

                    	<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_ins_tranferencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#ListGetAt(mat_id,1,'_')#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SAIDA#' >
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL_SAIDA#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL_SAIDA)), de('no'), de('yes'))#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL_DESTINO#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL_DESTINO)), de('no'), de('yes'))#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#ListGetAt(mat_id,2,'_')#'  null='#iif(len(trim(ListGetAt(mat_id,2,'_'))), de('no'), de('yes'))#'>
                            <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   variable='retorno.LANCAMENTO_ID'>
                            <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.TRANSFERENCIA_ID'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_cod_equipamento#' >
                            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='' >
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO_SAIDA#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO_SAIDA)), de('no'), de('yes'))#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO_DESTINO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO_DESTINO)), de('no'), de('yes'))#'>
                  	     	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID_ORIGEM#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_ORIGEM)), de('no'), de('yes'))#'>
					        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID_DESTINO#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_DESTINO)), de('no'), de('yes'))#'>

						</cfstoredproc>
                        <cfscript>
							if ( ListLen(mat_id,'_') gt 2 ) {
								this.ins_movimentacao_atributo( lancamento_id = retorno.lancamento_id,
																material_id	  = ListGetAt(mat_id,1,'_'),
																atributo_id   = 7,
																valor		  = ListGetAt(mat_id,3,'_'));
							}
	                    </cfscript>

                        <cfscript>
							ret_custo_med = this.calcula_custo_medio(lancamento_id = retorno.lancamento_id);
						</cfscript>

						<cfif ret_custo_med.erro>
						   <cfthrow object="#ret_custo_med.mensagem#">
						</cfif>
                    </cfloop>
                <cfelse>
                    <cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_ins_tranferencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SAIDA#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL_SAIDA#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL_SAIDA)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL_DESTINO#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL_DESTINO)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null="yes">
                        <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   variable='retorno.LANCAMENTO_ID'>
                        <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.TRANSFERENCIA_ID'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_EQUIPAMENTO#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO_SAIDA#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO_SAIDA)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO_DESTINO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO_DESTINO)), de('no'), de('yes'))#'>
                    	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID_ORIGEM#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_ORIGEM)), de('no'), de('yes'))#'>
					    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID_DESTINO#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_DESTINO)), de('no'), de('yes'))#'>
					</cfstoredproc>
                    <cfscript>
                        if ( Len(Trim(arguments.COD_EQUIPAMENTO)) ){
                            this.ins_movimentacao_atributo( lancamento_id = retorno.lancamento_id,
                                                            material_id	  = arguments.material_id,
                                                            atributo_id   = 7,
                                                            valor		  = arguments.COD_EQUIPAMENTO);
                        }
                    </cfscript>

                    <cfscript>
						ret_custo_med = this.calcula_custo_medio(lancamento_id = retorno.lancamento_id);
					</cfscript>

					<cfif ret_custo_med.erro>
					   <cfthrow object="#ret_custo_med.mensagem#">
					</cfif>
				</cfif>
	            <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Transferencia iniciada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Confirma a transferencia de um material
	-- cristofer 01/08/2006 14:29:30 - CRIADO
	--->
	<cffunction name='confirma_transferencia' displayname='Confirma a transferencia de um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TRANSFERENCIA_ID' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
		<cfargument name='USUARIO_ENTRADA' required='yes'>
		<cfargument name='ORGANIZACIONAL_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_confirma_transferencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TRANSFERENCIA_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENTRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_ENTRADA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   variable='retorno.LANCAMENTO_ID'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_ATRIBUTOS");
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTOS");
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.ins_movimentacao_atributo( lancamento_id = retorno.lancamento_id,
														material_id	= arguments.material_id,
														atributo_id = v_atributo_id[count],
														valor		= v_valor[count]);
					</cfscript>
				</cfloop>

                <cfscript>
				    ret_custo_med = this.calcula_custo_medio(lancamento_id = retorno.lancamento_id);
				</cfscript>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transferencia confirmada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Recusa a transferencia de um material
	-- cristofer 01/08/2006 14:30:13 - CRIADO
	--->
	<cffunction name='recusa_transferencia' displayname='Recusa a transferencia de um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TRANSFERENCIA_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='USUARIO_CANCELAMENTO' required='yes'>
		<cfargument name='ORGANIZACIONAL_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_recusa_transferencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TRANSFERENCIA_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_CANCELAMENTO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   variable='retorno.LANCAMENTO_ID'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'    value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
<!---				<cfscript>
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_ATRIBUTOS");
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTOS");
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.ins_movimentacao_atributo( lancamento_id = retorno.lancamento_id,
														material_id	= arguments.material_id,
														atributo_id = v_atributo_id[count],
														valor		= v_valor[count]);
					</cfscript>
				</cfloop>
--->				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transferencia recusada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui a transferencia de um material
	-- cristofer 01/08/2006 14:31:05 - CRIADO
	--->
	<cffunction name='del_transferencia' displayname='Exclui a transferencia de um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TRANSFERENCIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
 				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_del_transferencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TRANSFERENCIA_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transferencia excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Recusa a transferencia de um material
	-- cristofer 01/08/2006 14:30:13 - CRIADO
	--->
	<cffunction name='ins_material_componente' displayname='Recusa a transferencia de um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					v_material_id_componente = this.ListaToArray (lista = arguments, variavel = "MATERIAL_ID_COMPONENTE_COMPONENTES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_COMPONENTES, lista2 = ArrayToList(v_material_id_componente));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_excluir#" index="v_item">
					<cfscript>
							this.del_material_componente_private( 	material_id = arguments.material_id,
																	material_id_componente	= v_item);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_material_id_componente)#" index="count">
					<cfscript>
						this.ins_material_componente_private( 	material_id = arguments.material_id,
																material_id_componente	= v_material_id_componente[count]);
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material atualizado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Insere um componente no material
	-- cristofer 30/11/2006 11:15:16 - CRIADO
	--->
	<cffunction name='ins_material_componente_private' displayname='Insere um componente no material' access='remote' returntype='Struct' output='true'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='MATERIAL_ID_COMPONENTE' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_material_componente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID_COMPONENTE#'  null='#iif(len(trim(arguments.MATERIAL_ID_COMPONENTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui um componente no material
	-- cristofer 30/11/2006 11:15:16 - CRIADO
	--->
	<cffunction name='del_material_componente_private' displayname='Insere um componente no material' access='remote' returntype='Struct' output='true'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='MATERIAL_ID_COMPONENTE' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_material_componente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID_COMPONENTE#'  null='#iif(len(trim(arguments.MATERIAL_ID_COMPONENTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>


	<!---
	-- PROPSITO
	-- Insere uma movimentacao de materiais
	-- cristofer 31/07/2006 11:04:27 - CRIADO
	--->
	<cffunction name='ins_movimentacao_private' displayname='Insere uma movimentacao de materiais' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LANCAMENTO_ID' required='no' default="">
		<cfargument name='OPERACAO_TIPO_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='OBSERVACAO' required='no' default="">
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='no' default="">
		<cfargument name='SOLICITACAO_ID' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='COD_CENTRO_CUSTO' required='no' default="">
		<cfargument name='ESTOQUE_OPER_ID' required='no' default="">
		<cfargument name='TRANSFERENCIA_ID' required='no' default="">
		<cfargument name='MAT_OS_CONTROLE_ID' required='no' default="">
		<cfargument name='LANCAMENTO_ID_ANTERIOR' required='no' default="">
		<cfargument name='COD_PESSOA_FORNECEDOR' required='no' default="">
        <cfargument name='EQUIPAMENTO_ID' required='no' default="">		


			<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_movimentacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#' variable='retorno.LANCAMENTO_ID'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OPERACAO_TIPO_ID#'  null='#iif(len(trim(arguments.OPERACAO_TIPO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_LANCAMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null='yes'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value=''>
            	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
		        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ESTOQUE_OPER_ID#'  null='#iif(len(trim(arguments.ESTOQUE_OPER_ID)), de('no'), de('yes'))#'>
		        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TRANSFERENCIA_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_ID)), de('no'), de('yes'))#'>
 	    	    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MAT_OS_CONTROLE_ID#'  null='#iif(len(trim(arguments.MAT_OS_CONTROLE_ID)), de('no'), de('yes'))#'>
		    	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID_ANTERIOR#'  null='#iif(len(trim(arguments.LANCAMENTO_ID_ANTERIOR)), de('no'), de('yes'))#'>
			
	            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
			
			
			</cfstoredproc>

			<!---Vincula a Solicitao--->
            <cfif Len(Trim(arguments.SOLICITACAO_ID))>
                <cfscript>
                    ret = this.confirma_solicitacao_material(SOLICITACAO_ID    = arguments.SOLICITACAO_ID,
                                                             LANCAMENTO_ID_MOV = retorno.lancamento_id,
                                                             DATA_ATENDIMENTO  = arguments.DATA_LANCAMENTO);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfif>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere estoque minimo e maximo para o material na filial
	-- guto 02/02/2007 16:47:12 - CRIADO
	--->
	<cffunction name='ins_material_estoque_min_max' displayname='Insere estoque minimo e maximo para o material na filial' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ESTOQUE_MINIMO' required='yes'>
		<cfargument name='ESTOQUE_MAXIMO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_ins_estoque_min_max' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ESTOQUE_MINIMO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ESTOQUE_MAXIMO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atributos gravados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui um equipamento
	-- louis 25/04/2007 11:02 - CRIADO
	--->
	<cffunction name='del_equipamento' displayname='Exclui um equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		    <cftry>
			 	<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Equipamento excludo com sucesso')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere um laudo de sucateamento.
	-- louis 17/08/2007 17:46:04 - CRIADO
	--->
	<cffunction name='ins_sucateamento_laudo' displayname='Insere um laudo de sucateamento.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_sucateamento_laudo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.LAUDO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Laudo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere um laudo de sucateamento
	-- louis 20/08/2007 10:16 - CRIADO
	--->
	<cffunction name='ins_laudo_sucateamento' displayname='Insere um laudo de sucateamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='no'>
        <cfargument name='CADASTRAR_LAUDO' required='no'>
		<cfargument name='LAUDO_ID' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cftry>
			<cftransaction action='begin'>
			<cfscript>
				v_laudo_id = this.ListaToArray (lista = arguments, variavel = "LAUDO_ID_LAUDOS");
				v_cadastrar_laudo = this.ListaToArray (lista = arguments, variavel = "CADASTRAR_LAUDO_LAUDOS");
			    v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_LAUDOS, lista2 = ArrayToList(v_laudo_id));
	        </cfscript>

            <!--- Excluir os itens --->
            <cfloop list="#arguments.LISTA_DELETED_LAUDOS#" index="i" delimiters=",">
				<cfscript>
				    if (ListLen(i,'_') gt 0){
					ret = this.del_laudo_sucateamento_mat(laudo_id = ListGetAt(i,1,'_'),
														  material_id = arguments.material_id);
					}
				</cfscript>
				<cfif ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>
			 </cfloop>

			<!--- Insere um novo laudo --->
            <cfloop from="1" to="#ArrayLen(v_laudo_id)#" index="count">
           		<cfscript>
					if (v_laudo_id[count] eq '-1'){
						ret = ins_laudo_sucateamento_novo(descricao = v_cadastrar_laudo[count]);
               			ret = ins_laudo_sucateamento_mat(material_id = arguments.material_id
														,laudo_id    = ret.LAUDO_ID);
					}else{
						ret = ins_laudo_sucateamento_mat(material_id = arguments.material_id
														,laudo_id    = ListGetAt(v_laudo_id[count],1,'_'));
					}

                </cfscript>
		    </cfloop>
           	<cfif ret.erro>
				<cfthrow object="#ret.mensagem#">
			</cfif>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Laudos vinculados com sucesso!')>
            </cftransaction>
            <cfcatch>
            <cftransaction action='rollback'/>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
    </cftry>
    <cfreturn retorno />
</cffunction>

	<!---
	-- PROPSITO
	-- Insere um novo laudo de sucateamento
	-- LOUIS 20/08/2007 10:57 - CRIADO
	--->
	<cffunction name='ins_laudo_sucateamento_novo' displayname='Insere um novo laudo de sucateamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_sucateamento_laudo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.LAUDO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Laudo de sucateamento inserido com sucesso!')>
		<cfcatch>
   			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula um laudo de sucateamento a um material
	-- LOUIS 20/08/2007 11:22 - CRIADO
	--->
	<cffunction name='ins_laudo_sucateamento_mat' displayname='Vincula um laudo de sucateamento a um material' access='remote' returntype='Struct' output='true'>
		<cfargument name='LAUDO_ID' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>

		<cftry>
			<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_laudo_sucateamento_mat' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
            <cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Laudo de sucateamento inserido com sucesso!')>
		<cfcatch>
   			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Desvincula um laudo de sucateamento de um material
	-- LOUIS 20/08/2007 13:37 - CRIADO
	--->
	<cffunction name='del_laudo_sucateamento_mat' displayname='Desvincula um laudo de sucateamento de um material' access='remote' returntype='Struct' output='true'>
		<cfargument name='LAUDO_ID' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
     	<cftry>
			<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_laudo_sucateamento_mat' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
		<cfcatch>
   			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera um laudo de sucateamento
	-- LOUIS 20/08/2007 17:43 - CRIADO
	--->
	<cffunction name='upd_laudo_sucateamento' displayname='Altera um laudo de sucateamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='LAUDO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
			<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_sucateamento_laudo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
		    	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
            </cfstoredproc>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Laudo de sucateamento alterado com sucesso!')>
		<cfcatch>
   			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera o proprietrio de um equipamento
	-- louis 21/08/2007 10:59:43 - CRIADO
	--->
	<cffunction name='alt_proprietario_equipamento' displayname='Altera o proprietrio de um equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Proprietrio alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Insere solicitao de material
    -- guto 01/10/2007 17:54:07 - CRIADO
    --->
    <cffunction name='manip_solicitacao_material' displayname='Insere solicitao de material' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
                    v_solicitacao_id = this.ListaToArray (lista = arguments, variavel = "SOLICITACAO_ID_SOLICITACOES");
                    v_material_id	 = this.ListaToArray (lista = arguments, variavel = "MATERIAL_ID_SOLICITACOES");
                    v_cod_pessoa_filial = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_FILIAL_SOLICITACOES");
						  v_cod_centro_custo = this.ListaToArray (lista = arguments, variavel = "COD_CENTRO_CUSTO_SOLICITACOES");
                    v_data_solicitacao  = this.ListaToArray (lista = arguments, variavel = "DATA_SOLICITACAO_SOLICITACOES");
                    v_cod_pessoa_responsavel = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_RESPONSAVEL_SOLICITACOES");
                    v_quantidade  			 = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_SOLICITACOES");
                    v_urgencia 				 = this.ListaToArray (lista = arguments, variavel = "URGENCIA_SOLICITACOES");
                    v_observacao  		     = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_SOLICITACOES");

                    v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_SOLICITACOES, lista2 = ArrayToList(v_solicitacao_id));
                </cfscript>

                <!--- Excluir os itens --->
                <cfloop list="#v_item_excluir#" index="i" delimiters=",">
                    <cfscript>
                        ret = this.del_solicitacao_material(solicitacao_id = i);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                 </cfloop>

                <!--- Insere solicitacao --->
                <cfloop from="1" to="#ArrayLen(v_material_id)#" index="count">
                    <cfscript>
                        if (Len(Trim(v_solicitacao_id[count]))) {
                            ret = this.alt_solicitacao_material(SOLICITACAO_ID 			= v_solicitacao_id[count]
                                                               ,MATERIAL_ID	   		= v_material_id[count]
                                                               ,COD_PESSOA_FILIAL 		= v_cod_pessoa_filial[count]
                                                               ,DATA_SOLICITACAO       = v_data_solicitacao[count]
                                                               ,COD_PESSOA_RESPONSAVEL = v_cod_pessoa_responsavel[count]
                                                               ,QUANTIDADE			   	= v_quantidade[count]
                                                               ,URGENCIA			   	= v_urgencia[count]
                                                               ,OBSERVACAO			   	= v_observacao[count]
																					,COD_CENTRO_CUSTO    	= v_cod_centro_custo[count]
																					);
                        }
                        else {
                            ret = this.ins_solicitacao_material(MATERIAL_ID	   		= v_material_id[count]
                                                               ,COD_PESSOA_FILIAL      = v_cod_pessoa_filial[count]
                                                               ,DATA_SOLICITACAO       = v_data_solicitacao[count]
                                                               ,COD_PESSOA_RESPONSAVEL = v_cod_pessoa_responsavel[count]
                                                               ,QUANTIDADE			   	= v_quantidade[count]
                                                               ,URGENCIA			   	= v_urgencia[count]

                                                               ,OBSERVACAO			   	= v_observacao[count]
																					,COD_CENTRO_CUSTO    	= v_cod_centro_custo[count]
																					);
                        }
                    </cfscript>
                </cfloop>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao executada com sucesso!')>
            </cftransaction>
        <cfcatch>
            <cftransaction action='rollback'/>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Insere solicitao de material
    -- guto 01/10/2007 17:54:07 - CRIADO
    --->
    <cffunction name='ins_solicitacao_material' displayname='Insere solicitao de material' access='remote' returntype='Struct' output='true'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='DATA_SOLICITACAO' required='yes'>
        <cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='URGENCIA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cftry>
        <cfdump var="#arguments#">
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_solicitacao_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SOLICITACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.URGENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.SOLICITACAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera solicitao de material
    -- guto 01/10/2007 18:00:04 - CRIADO
    --->
    <cffunction name='alt_solicitacao_material' displayname='Altera solicitao de material' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='DATA_SOLICITACAO' required='yes'>
        <cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='URGENCIA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cftry>
            <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_solicitacao_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SOLICITACAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.URGENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Solicitao alterada com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Exclui solicitao de material
    -- guto 01/10/2007 18:04:25 - CRIADO
    --->
    <cffunction name='del_solicitacao_material' displayname='Exclui solicitao de material' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_del_solicitacao_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao excluda com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Cancela solicitao de material
    -- guto 01/10/2007 18:05:08 - CRIADO
    --->
    <cffunction name='cancela_solicitacao_material' displayname='Cancela solicitao de material' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_cancela_solicitacao_mat' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#DateFormat(Now(),"dd/mm/yyyy")# #TimeFormat(Now(),"HH:MM")#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_CANCELAMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao cancelada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Confirma solicitao de material
    -- guto 01/10/2007 18:05:53 - CRIADO
    --->
    <cffunction name='confirma_solicitacao_material' displayname='Confirma solicitao de material' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='LANCAMENTO_ID_MOV' required='yes'>
        <cfargument name='DATA_ATENDIMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_confirma_solicitacao_mat' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID_MOV#'  null='#iif(len(trim(arguments.LANCAMENTO_ID_MOV)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ATENDIMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao confirmada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    	<!---
    -- PROPSITO
    -- estorna sucateamento
    -- wagnerlv 15/01/2008 14:17:34 - CRIADO
    --->
    <cffunction name='estorna_sucateamento' displayname='estorna sucateamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='MOTIVO' required='yes'>
        <cfdump var="#arguments#" >
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_estorna_sucateamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Estornado com sucesso')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Insere uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:49:14 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra' displayname='Insere uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_CONTROLE' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_PESSOA_EMISSAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='LOG_ALTERACAO' required='yes'>
        <cfargument name='PRIORIDADE_ID' required='yes'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='TABELA_ID' required='yes'>
        <cfargument name='EQUIPAMENTO_CUSTO_ID' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.SOLICITACAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_CONTROLE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='8' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.LOG_ALTERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_CUSTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_CUSTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>

                <!--- Insero de Materiais --->
				<cfscript>
                    v_controle_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_CONTROLE_ID_MATERIAL');
					v_material_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_ID_COMP_MATERIAL');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_DESCRICAO_MATERIAL');
					v_cod_unidade 	 = this.ListaToArray(lista = arguments, variavel = 'COD_UNIDADE_MATERIAL');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_QUANTIDADE_MATERIAL');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_VALOR_SUGERIDO_MATERIAL');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_TIPO_COMPRA_ID_MATERIAL');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_material(SOLICITACAO_ID = retorno.SOLICITACAO_ID,
																   DESCRICAO	  = v_descricao[count],
																   MATERIAL_ID	  = v_material_id[count],
																   COD_UNIDADE	  = v_cod_unidade[count],
																   QUANTIDADE	  = v_quantidade[count],
																   VALOR_SUGERIDO = v_valor_sugerido[count],
																   TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Insero de Atividades --->
				<cfscript>
                    v_controle_id    = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_CONTROLE_ID_ATIVIDADE');
					v_atividade_id   = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_ID_COMP_ATIVIDADE');
					v_descricao      = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_DESCRICAO_ATIVIDADE');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_VALOR_SUGERIDO_ATIVIDADE');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_QUANTIDADE_ATIVIDADE');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_TIPO_COMPRA_ID_ATIVIDADE');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_atividade(SOLICITACAO_ID = retorno.SOLICITACAO_ID,
																    DESCRICAO	   = v_descricao[count],
																    ATIVIDADE_ID   = v_atividade_id[count],
																	VALOR_SUGERIDO = v_valor_sugerido[count],
																	QUANTIDADE	   = v_quantidade[count],
																	TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Caso esteja definida uma tabela de preo fixo, gera o processo de compras automtico --->
                <cfif Len(Trim(arguments.TABELA_ID))>
                	<cfscript>
						ret_orcam = this.gera_orcamento_cotacao(SOLICITACAO_ID  = retorno.SOLICITACAO_ID,
															    TABELA_PRECO_ID = arguments.TABELA_ID);
                    </cfscript>
                    <cfif ret_orcam.erro>
                        <cfthrow object="#ret_orcam.mensagem#">
                    </cfif>
                </cfif>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de Compra n #retorno.NUM_CONTROLE# inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:51:10 - CRIADO
    --->
    <cffunction name='upd_solicitacao_compra' displayname='Altera uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='NUM_CONTROLE' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_PESSOA_EMISSAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='LOG_ALTERACAO' required='yes'>
        <cfargument name='PRIORIDADE_ID' required='yes'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_solicitacao.prc_alt_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_CONTROLE#'  null='#iif(len(trim(arguments.NUM_CONTROLE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.LOG_ALTERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.EQUIPAMENTO_CUSTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_CUSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>

                <!--- Alterao de Materiais --->
				<cfscript>
                    v_controle_id	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_CONTROLE_ID_MATERIAL');
					v_material_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_ID_COMP_MATERIAL');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_DESCRICAO_MATERIAL');
					v_cod_unidade 	 = this.ListaToArray(lista = arguments, variavel = 'COD_UNIDADE_MATERIAL');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_QUANTIDADE_MATERIAL');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_VALOR_SUGERIDO_MATERIAL');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_TIPO_COMPRA_ID_MATERIAL');
                    v_excluir	     = this.ListDiff(lista1 = arguments.lista_deleted_MATERIAL, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_solicitacao_compra_material(CONTROLE_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_controle_id[count]))) {
							ret = this.ins_solicitacao_compra_material(SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																	   DESCRICAO	  = v_descricao[count],
																	   MATERIAL_ID	  = v_material_id[count],
																	   COD_UNIDADE	  = v_cod_unidade[count],
																	   QUANTIDADE	  = v_quantidade[count],
																	   VALOR_SUGERIDO = v_valor_sugerido[count],
																	   TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                        else {
							ret = this.upd_solicitacao_compra_material(CONTROLE_ID    = v_controle_id[count],
																	   SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																	   DESCRICAO	  = v_descricao[count],
																	   MATERIAL_ID	  = v_material_id[count],
																	   COD_UNIDADE	  = v_cod_unidade[count],
																	   QUANTIDADE	  = v_quantidade[count],
																	   VALOR_SUGERIDO = v_valor_sugerido[count],
																	   TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Alterao de Atividades --->
				<cfscript>
                    v_controle_id  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_CONTROLE_ID_ATIVIDADE');
					v_atividade_id   = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_ID_COMP_ATIVIDADE');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_DESCRICAO_ATIVIDADE');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_VALOR_SUGERIDO_ATIVIDADE');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_QUANTIDADE_ATIVIDADE');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_TIPO_COMPRA_ID_ATIVIDADE');
                    v_excluir	     = this.ListDiff(lista1 = arguments.lista_deleted_ATIVIDADE, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_solicitacao_compra_atividade(CONTROLE_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_controle_id[count]))) {
							ret = this.ins_solicitacao_compra_atividade(SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																		DESCRICAO	   = v_descricao[count],
																		ATIVIDADE_ID   = v_atividade_id[count],
																		VALOR_SUGERIDO = v_valor_sugerido[count],
																		QUANTIDADE	   = v_quantidade[count],
																		TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                        else {
							ret = this.upd_solicitacao_compra_atividade(CONTROLE_ID    = v_controle_id[count],
																		SOLICITACAO_ID = arguments.SOLICITACAO_ID,
																		DESCRICAO	   = v_descricao[count],
																		ATIVIDADE_ID   = v_atividade_id[count],
																		VALOR_SUGERIDO = v_valor_sugerido[count],
																		QUANTIDADE	   = v_quantidade[count],
																		TIPO_COMPRA_ID = v_tipo_compra_id[count]);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de compra alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:52:14 - CRIADO
    --->
    <cffunction name='del_solicitacao_compra' displayname='Exclui uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_solicitacao.prc_del_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de compra excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere um material para uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:53:59 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_material' displayname='Insere um material para uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='1'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera um material de uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:54:41 - CRIADO
    --->
    <cffunction name='upd_solicitacao_compra_material' displayname='Altera um material de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_alt_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
			    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
			</cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material alterado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui um material de uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:55:28 - CRIADO
    --->
    <cffunction name='del_solicitacao_compra_material' displayname='Exclui um material de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_del_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material excludo com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere uma atividade para uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:57:48 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_atividade' displayname='Insere uma atividade para uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='ATIVIDADE_ID' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera uma atividade de uma solicitao de compra
    -- ANDERSONC 16/09/2009 15:00:27 - CRIADO
    --->
    <cffunction name='upd_solicitacao_compra_atividade' displayname='Altera uma atividade de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='ATIVIDADE_ID' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_alt_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
			    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade alterada com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui uma atividade de uma solicitao de compra
    -- ANDERSONC 16/09/2009 15:07:32 - CRIADO
    --->
    <cffunction name='del_solicitacao_compra_atividade' displayname='Exclui uma atividade de uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_del_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade excluda com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Vincula COD NCM ao material
    -- 25/09/2009 - Criado - GUTO
    --->
    <cffunction name='vincula_ncm_material' displayname='Vincula COD NCM ao material' access='remote' returntype='Struct' output='true'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_NCM' required='yes'>
        <cftry>
            <cfstoredproc procedure='almoxarifado.pkg_almoxarifado.prc_vincula_ncm_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_NCM#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material vinculado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Inserir Ocorrncia para Solicitao de Compra
	-- RAFAEL 22/01/2010 14:27:17 - CRIADO
	--->
	<cffunction name='ins_ocorrencia_solicitacao' displayname='Inserir Ocorrncia para Solicitao de Compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_compras_ocorrencia.prc_ins_ocorrencia_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.COMENTARIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.OCORRENCIA_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfif arguments.TIPO_ID eq 20>
					<cfset retorno.mensagem = JSStringFormat('Solicitao Liberada com Sucesso.')>
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('Ocorrncia inserida com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Gera o processo de compras automtico para uma solicitao de compras
	-- ANDERSONC 16/06/2010 11:30:28 - CRIADO
	--->
	<cffunction name='gera_orcamento_cotacao' displayname='Gera o processo de compras automtico para uma solicitao de compras' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='TABELA_PRECO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='compras.pkg_compras.prc_gera_orcamento_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_PRECO_ID#'  null='#iif(len(trim(arguments.TABELA_PRECO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere uma solicitao de compra para manuteno
	-- FABIOG 10/11/2011 17:16:18 - CRIADO
	--->
	<cffunction name='ins_solicit_manutencao' displayname='Insere uma solicitao de compra para manuteno' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_PESSOA_EMISSAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='LOG_ALTERACAO' required='yes'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='PLACA' required='yes'>
		<cfargument name='TITULO' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicit_simplifi' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SOLICITACAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_CONTROLE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.LOG_ALTERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='8' >					
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>


				<!--- Insero de Materiais --->
				<cfscript>
                    v_controle_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_CONTROLE_ID_MATERIAL');
					v_material_id 	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_ID_COMP_MATERIAL');
					v_descricao   	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_DESCRICAO_MATERIAL');
					v_cod_unidade 	 = this.ListaToArray(lista = arguments, variavel = 'COD_UNIDADE_MATERIAL');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_QUANTIDADE_MATERIAL');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_VALOR_SUGERIDO_MATERIAL');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'MATERIAL_TIPO_COMPRA_ID_MATERIAL');
                </cfscript>

                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_material(SOLICITACAO_ID = retorno.SOLICITACAO_ID
																  ,DESCRICAO	  = v_descricao[count]
																  ,MATERIAL_ID	  = v_material_id[count]
																  ,COD_UNIDADE	  = v_cod_unidade[count]
																  ,QUANTIDADE	  = v_quantidade[count]
																  ,VALOR_SUGERIDO = v_valor_sugerido[count]
																  ,TIPO_COMPRA_ID = v_tipo_compra_id[count]
																  );
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Insero de Atividades --->
				<cfscript>
                    v_controle_id    = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_CONTROLE_ID_ATIVIDADE');
					v_atividade_id   = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_ID_COMP_ATIVIDADE');
					v_descricao      = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_DESCRICAO_ATIVIDADE');
					v_valor_sugerido = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_VALOR_SUGERIDO_ATIVIDADE');
					v_quantidade  	 = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_QUANTIDADE_ATIVIDADE');
					v_tipo_compra_id = this.ListaToArray(lista = arguments, variavel = 'ATIVIDADE_TIPO_COMPRA_ID_ATIVIDADE');
                </cfscript>

                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                        ret = this.ins_solicitacao_compra_atividade(SOLICITACAO_ID = retorno.SOLICITACAO_ID
																   ,DESCRICAO	   = v_descricao[count]
																   ,ATIVIDADE_ID   = v_atividade_id[count]
																   ,VALOR_SUGERIDO = v_valor_sugerido[count]
																   ,QUANTIDADE	   = v_quantidade[count]
																   ,TIPO_COMPRA_ID = v_tipo_compra_id[count]
																   );
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Caso esteja definida uma tabela de preo fixo, gera o processo de compras automtico --->
                <cfif Len(Trim(arguments.TABELA_ID))>
                	<cfscript>
						ret_orcam = this.gera_orcamento_cotacao(SOLICITACAO_ID  = retorno.SOLICITACAO_ID
															   ,TABELA_PRECO_ID = arguments.TABELA_ID
															   );
                    </cfscript>
                    <cfif ret_orcam.erro>
                        <cfthrow object="#ret_orcam.mensagem#">
                    </cfif>
                </cfif>

                <cfscript>
                	v_parc_numero = this.ListaToArray(lista = arguments, variavel = 'PARCELA_NUMERO');
					v_parc_data   = this.ListaToArray(lista = arguments, variavel = 'PARCELA_DATA_VENCTO');
					v_parc_dia    = this.ListaToArray(lista = arguments, variavel = 'PARCELA_DIA');
					v_parc_valor  = this.ListaToArray(lista = arguments, variavel = 'PARCELA_VALOR');
                </cfscript>

                <!--- Insere as parcelas em uma tabela temporaria para ser processada na solicitao de compras --->
                <cfloop from="1" to="#arrayLen(v_parc_numero)#" index="i">
                	<cfscript>
						ret = this.ins_solic_compras_temp( num_parcela 		= v_parc_numero[i]
														 , data_vencto 		= v_parc_data[i]
														 , dia_vencimento 	= v_parc_dia[i]
														 , valor  		  	= v_parc_valor[i]
														 );
					</cfscript>
                	<cfif ret.erro >
                    	<cfthrow object="#ret.mensagem#" >
                    </cfif>
                </cfloop>

                <!--- Realiza o processamento da solicitao de carga --->
                <cfscript>
                   ret_pro_sol = this.processa_solicit_compra(SOLICITACAO_ID = retorno.SOLICITACAO_ID
                                                             ,PLACA          = arguments.PLACA
                                                             );
	            </cfscript>

                <cfif ret_pro_sol.erro>
                    <cfthrow object="#ret_pro_sol.mensagem#">
                </cfif>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = ret_pro_sol.MENSAGEM_RETORNO>
            </cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Processar a solicitao de carga de manuteno
	-- FABIOG 11/11/2011 11:23:18 - CRIADO
	--->
	<cffunction name='processa_solicit_compra' displayname='Processar a solicitao de carga de manuteno' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_processa_solicit_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_LONGVARCHAR'  variable='retorno.MENSAGEM_RETORNO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>0
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma parcela da solicitao de compras em uma tabela temporaria
	-- WAGNERS 26/04/2012 14:21:46 - CRIADO
	--->
	<cffunction name='ins_solic_compras_temp' displayname='Insere uma parcela da solicitao de compras em uma tabela temporaria' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_PARCELA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='DIA_VENCIMENTO' required='yes'>
		<cfargument name='DATA_VENCTO' required='yes'>
		<cftry>

            <cfstoredproc procedure='compras.pkg_compras.prc_ins_solic_compras_temp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PARCELA#'  null='#iif(len(trim(arguments.NUM_PARCELA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DIA_VENCIMENTO#'  null='#iif(len(trim(arguments.DIA_VENCIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VENCTO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Parcela registrada com sucesso!')>

			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Registra movimentao de estoque para funcionario
    -- JAQUELINEF 27/02/2013 13:52:23 - CRIADO
    --->
	<cffunction name='ins_movimentacao_funcionario' displayname='Registra movimentao de estoque para funcionario' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='LANCTO_SAIDA' required='no' default="">
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_mov_funcionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_SAIDA#'  null='#iif(len(trim(arguments.LANCTO_SAIDA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!---
    -- PROPSITO
    -- Atualiza movimentao de estoque para funcionario
    -- LuizG 14/05/2018 13:52:23 - CRIADO
    --->
	<cffunction name='atualiza_movimentacao_func_origem' displayname='Registra movimentao de estoque para funcionario' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_atualiza_mov_func_orig' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>



	<!---
    -- PROPSITO
    -- Registra movimentao de estoque para funcionario
    -- JAQUELINEF 27/02/2013 13:52:23 - CRIADO
    --->
	<cffunction name='devolucao_movimentacao_funcionario' displayname='Registra movimentao de devlucao de estoque por funcionario' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='ETIQUETA_ID' required='no' default="">

  		<cftry>
			<cftransaction action='begin'>
			<cfscript>
                v_mats   = this.ListaToArray(lista = arguments, variavel = 'MATERIAIS');
                v_qnts   = this.ListaToArray(lista = arguments, variavel = 'QNT');
                v_filial = this.ListaToArray(lista = arguments, variavel = 'FILIAL');
				v_cod_cc = this.ListaToArray(lista = arguments, variavel = 'CENTRO_CUSTO');
                v_cod_eq = this.ListaToArray(lista = arguments, variavel = 'IDENTIFICADOR');
                v_lancto = this.ListaToArray(lista = arguments, variavel = 'LANCTO');
                v_ccg    = this.ListaToArray(lista = arguments, variavel = 'ORGANIZACIONAL_ID');
            </cfscript>

			<!--- Insero de Etiquetas--->
		    <cfif len(trim(arguments.ETIQUETA_ID))>
			<cfscript>
                v_etiqueta_id = ListToArray(arguments.ETIQUETA_ID);
            </cfscript>
            <cfloop from="1" to="#ArrayLen(v_etiqueta_id)#" index="count">
                 <cfscript>
                    retorno = this.ins_lista_temp(VALOR = v_etiqueta_id[count]
                                                , TIPO  = 'EOPER_ETIQUETA_ID' );
                 </cfscript>
                 <cfif retorno.erro>
                      <cfthrow object="#ret.mensagem#">
                 </cfif>
            </cfloop>
			</cfif>

            <cfloop from="1" to="#ArrayLen(v_qnts)#" index="i">
				<cfif v_qnts[i] gt 0>
                    <cfscript>
                        ret = this.ins_movimentacao_private(OPERACAO_TIPO_ID       = 8
														   ,DATA_LANCAMENTO        = DateFormat(now(), 'DD/MM/YYYY')&' '&TimeFormat(now(), "HH:MM:SS")
														   ,MATERIAL_ID            = v_mats[i]
														   ,QUANTIDADE             = v_qnts[i]
														   ,OBSERVACAO             = 'Devoluo: '&arguments.COD_FUNCIONARIO&' - '&arguments.RESPONSAVEL
														   ,COD_PESSOA_FILIAL 	   = v_filial[i]
														   ,COD_CENTRO_CUSTO       = v_cod_cc[i]
														   ,LANCAMENTO_ID_ANTERIOR = v_lancto[i]
														   );

						ret_func = this.atualiza_movimentacao_func_origem(LANCAMENTO_ID = ret.LANCAMENTO_ID);

                        if(LEN(TRIM(v_cod_eq[i])))
                            this.ins_movimentacao_atributo(LANCAMENTO_ID = ret.LANCAMENTO_ID
                                                          ,MATERIAL_ID   = v_mats[i]
                                                          ,ATRIBUTO_ID   = 7
                                                          ,VALOR         = v_cod_eq[i]);
                    </cfscript>

	                <cfscript>
					    ret_custo_med = this.calcula_custo_medio(lancamento_id = ret.LANCAMENTO_ID);
					</cfscript>

					<cfif ret_custo_med.erro>
	                   <cfthrow object="#ret_custo_med.mensagem#">
	                </cfif>
                </cfif>


            </cfloop>

             <!---Para cada posicao do vetor add uma ins_movimentacao_private com tipo 8,
			      descricao RESPONSAVEL e COD_FUNCIONARIO, cod_repsonsavel p/ gravar na tabela de movimentacao_funcionario e
				  tem q testar o identificador p/ usar a funcao almoxarifado.pkg_almoxarifado_dml.prc_ins_movimentacao_atributo p/ atributo 7
				  e o cod_equipaento (add num hidden no consultas<strong></strong> o cod_equipamento p/ usar aqui)
		     --->
             <cfset retorno.erro = false>
             <cfset retorno.mensagem = JSStringFormat('Devoluo realizada com sucesso.')>

			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<cffunction name='devolucao_movimentacao_veiculo' displayname='Registra movimentao de devolucao de estoque por veiculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
		<cfargument name='ETIQUETA_ID' required='no' default="">
  		<cftry>
			<cftransaction action='begin'>
			<cfscript>
                v_mats   = this.ListaToArray(lista = arguments, variavel = 'MATERIAIS');
                v_qnts   = this.ListaToArray(lista = arguments, variavel = 'QNT');
                v_filial = this.ListaToArray(lista = arguments, variavel = 'FILIAL');
				v_cod_cc = this.ListaToArray(lista = arguments, variavel = 'CENTRO_CUSTO');
                v_cod_eq = this.ListaToArray(lista = arguments, variavel = 'IDENTIFICADOR');
                v_lancto = this.ListaToArray(lista = arguments, variavel = 'LANCTO');
            </cfscript>


			<!--- Insero de Etiquetas--->
			<cfif len(trim(arguments.ETIQUETA_ID))>
				<cfscript>
	                v_etiqueta_id = ListToArray(arguments.ETIQUETA_ID);
	            </cfscript>
	            <cfloop from="1" to="#ArrayLen(v_etiqueta_id)#" index="count">
	                 <cfscript>
	                    retorno = this.ins_lista_temp(VALOR = v_etiqueta_id[count]
	                                                , TIPO  = 'EOPER_ETIQUETA_ID' );
	                 </cfscript>
	                 <cfif retorno.erro>
	                      <cfthrow object="#ret.mensagem#">
	                 </cfif>
	            </cfloop>
			 </cfif>

            <cfloop from="1" to="#ArrayLen(v_qnts)#" index="i">
                <cfif v_qnts[i] gt 0>
                    <cfscript>
                        ret = this.ins_movimentacao_private(OPERACAO_TIPO_ID       = 8
														   ,DATA_LANCAMENTO        = DateFormat(now(), 'DD/MM/YYYY')&' '&TimeFormat(now(), "HH:MM:SS")
														   ,MATERIAL_ID            = v_mats[i]
														   ,QUANTIDADE             = v_qnts[i]
														   ,OBSERVACAO             = 'Devoluo: '&arguments.PLACA
														   ,COD_PESSOA_FILIAL 	   = v_filial[i]
														   ,COD_CENTRO_CUSTO       = v_cod_cc[i]
														   ,LANCAMENTO_ID_ANTERIOR = v_lancto[i]
														   ,EQUIPAMENTO_ID		   = '#arguments.EQUIPAMENTO_ID#' 
														   );

                        this.atualiza_movimentacao_equipamento_origem(LANCAMENTO_ID  = ret.LANCAMENTO_ID);

                        if(LEN(TRIM(v_cod_eq[i])))
                            this.ins_movimentacao_atributo(LANCAMENTO_ID = ret.LANCAMENTO_ID
                                                          ,MATERIAL_ID   = v_mats[i]
                                                          ,ATRIBUTO_ID   = 7
                                                          ,VALOR         = v_cod_eq[i]);
                    </cfscript>

                    <cfscript>
						ret_custo_med = this.calcula_custo_medio(lancamento_id = ret.LANCAMENTO_ID);
					</cfscript>

					<cfif ret_custo_med.erro>
					   <cfthrow object="#ret_custo_med.mensagem#">
					</cfif>
                </cfif>
            </cfloop>

             <cfset retorno.erro = false>
             <cfset retorno.mensagem = JSStringFormat('Devoluo realizada com sucesso.')>

			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Altera os proprietrios de um equipamento
    -- RAFAEL 04/02/2013 11:08:12 - CRIADO
    --->
    <cffunction name='atualiza_prop_veiculos' displayname='Altera os proprietrios de um equipamento' access='remote' returntype='Struct' output='true'>
        <cftry>
            <cftransaction action='begin'>
                <!--- Criao de variaveis --->
				<cfscript>
                    v_equipamento_proprietario_id 	= this.ListaToArray(lista = arguments, variavel = 'EQUIPAMENTO_PROPRIETARIO_ID_EQUIP_PROPRIETARIO');
					v_cod_pessoa_proprietario 		= this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_PROPRIETARIO_EQUIP_PROPRIETARIO');
					v_data_inicio 					= this.ListaToArray(lista = arguments, variavel = 'DATA_INICIO_EQUIP_PROPRIETARIO');
					v_data_fim						= this.ListaToArray(lista = arguments, variavel = 'DATA_FIM_EQUIP_PROPRIETARIO');
					v_excluir						= this.ListDiff(lista1 = lista_deleted_EQUIP_PROPRIETARIO, lista2 = ArrayToList(v_equipamento_proprietario_id));
                </cfscript>


                <cfdump var="#v_equipamento_proprietario_id#">
                <cfdump var="#v_cod_pessoa_proprietario#">
                <cfdump var="#v_data_inicio#">
                <cfdump var="#v_data_fim#">
                <cfdump var="#arguments.EQUIPAMENTO_ID#">

                <!--- Exclui os Proprietrios --->
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
					<cfscript>
                        ret = this.del_proprietario_web(EQ_PROPRIETARIO_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Insere/Atualiza os Proprietrios --->
                <cfloop from="1" to="#ArrayLen(v_equipamento_proprietario_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_equipamento_proprietario_id[count]))) {
							ret_ins_upd = this.ins_proprietario_web(EQUIPAMENTO_ID			= arguments.EQUIPAMENTO_ID
							                                       ,COD_PESSOA_PROPRIETARIO	= v_cod_pessoa_proprietario[count]
																   ,DATA_INICIO				= v_data_inicio[count]
																   ,DATA_TERMINO			= v_data_fim[count]);
						}
						else{
							ret_ins_upd = this.upd_proprietario_web(EQ_PROPRIETARIO_ID 		= v_equipamento_proprietario_id[count]
							                                       ,EQUIPAMENTO_ID			= arguments.EQUIPAMENTO_ID
							                                       ,COD_PESSOA_PROPRIETARIO	= v_cod_pessoa_proprietario[count]
																   ,DATA_INICIO				= v_data_inicio[count]
																   ,DATA_TERMINO			= v_data_fim[count]);
						}
                    </cfscript>
                    <cfif ret_ins_upd.erro>
                        <cfthrow object="#ret_ins_upd.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Valida os histricos dos Proprietrios --->
                <cfscript>
					retValida = this.prc_validar_hist_pop_eq(EQUIPAMENTO_ID = arguments.EQUIPAMENTO_ID);
				</cfscript>
				<cfif retValida.erro>
					<cfthrow object="#retValida.mensagem#">
				</cfif>



                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Histrico de proprietrios do equipamento atualizado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!---
	-- PROPSITO
	-- Inserir proprietrio de equipamento
	-- RAFAEL 04/02/2013 11:05:03 - CRIADO
	--->
	<cffunction name='ins_proprietario_web' displayname='Inserir proprietrio de equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_TERMINO' required='yes'>
		<cftry>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_proprietario_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Alterar proprietrio de equipamento
	-- RAFAEL 04/02/2013 11:07:42 - CRIADO
	--->
	<cffunction name='upd_proprietario_web' displayname='Alterar proprietrio de equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQ_PROPRIETARIO_ID' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cftry>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_proprietario_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQ_PROPRIETARIO_ID#'  null='#iif(len(trim(arguments.EQ_PROPRIETARIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

     <!---
	-- PROPSITO
	-- Validar histricos dos Proprietrios do equipamento
	-- RAFAEL 04/02/2013 11:12:08 - CRIADO
	--->
	<cffunction name='prc_validar_hist_pop_eq' displayname='Validar histricos dos Proprietrios do equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_validar_hist_pop_eq' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Gera solicitaao de compra para reposiao de estoque
    -- guto 30/07/2014 22:51:28 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_reposicao' displayname='Gera solicitaao de compra para reposiao de estoque' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='SOLICITACAO_MATERIAL_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_compra_reposicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SOLICITACAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_CONTROLE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_CENTRO_CUSTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
                </cfstoredproc>

                <cfloop list="#arguments.SOLICITACAO_MATERIAL_ID#" index="v_material_id">
                  <cfscript>
				     set_item = this.ins_solicitacao_compra_reposicao_item(SOLICITACAO_ID = retorno.SOLICITACAO_ID,
																		   MATERIAL_ID = v_material_id,
																		   QUANTIDADE = arguments['QUANTIDADE_MATERIAL_ID_'&v_material_id],
																		   COD_UNIDADE_COMPRA = arguments['COD_UNIDADE_'&v_material_id]);
				  </cfscript>
				  <cfif set_item.erro>
                        <cfthrow object="#set_item.mensagem#">
                  </cfif>
                </cfloop>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitaao de compra ' & #retorno.NUM_CONTROLE# & ' gerada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Gera item da solicitaao de compra de reposiao
    -- guto 30/07/2014 22:52:48 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_reposicao_item' displayname='Gera item da solicitaao de compra de reposiao' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_ins_compra_reposicao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.COD_UNIDADE_COMPRA#'  null='#iif(len(trim(arguments.COD_UNIDADE_COMPRA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitaao de compra gerada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Calcular o custo mdio do material
	-- fabiog 12/05/2015 11:18:17 - CRIADO
	--->
	<cffunction name='calcula_custo_medio' displayname='Calcular o custo mdio do material' access='remote' returntype='Struct' output='true'>
	   <cfargument name='LANCAMENTO_ID' required='yes'>
	   <cftry>
	      <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_calcula_custo_medio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
		     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
		  </cfstoredproc>
		  <cfset retorno.erro = false>
	   <cfcatch>
	      <cfset retorno.erro = true>
		  <cfset retorno.mensagem = cfcatch>
		  <cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno />
	</cffunction>

	<cffunction name='prc_validar_atributo_obrigatorio' displayname='Valida se os materiais devem possuir valor unitrio e valor total' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_valida_atr_obrigatorio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

		<!---
	-- PROPSITO 
	-- Gerar Relatrio de movimentaocoes saida para funcionarios
	-- IGOR NOBREGA 23/04/2020
	--->
	<cffunction name='gerar_relatorio_mov_saida_funcionario' displayname='Gerar Relatorio de Movimentacoes de saida para funcionarios' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_FUNCIONARIO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO_SAIDA' required='yes'>
		<cfargument name='COD_PESSOA_ORIGEM' required='yes'>
		<cfargument name='REL_TRANS_DATA_INI' required='yes'>
		<cfargument name='REL_TRANS_DATA_FIM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='almoxarifado.pkg_almoxarifado_backend.prc_rel_saida_funcionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.COD_FUNCIONARIO#' null='#iif(len(trim(arguments.COD_FUNCIONARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.COD_CENTRO_CUSTO_SAIDA#' null='#iif(len(trim(arguments.COD_CENTRO_CUSTO_SAIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.COD_PESSOA_ORIGEM#' null='#iif(len(trim(arguments.COD_PESSOA_ORIGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='6'   value='#arguments.REL_TRANS_DATA_INI#' null='#iif(len(trim(arguments.REL_TRANS_DATA_INI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='6'   value='#arguments.REL_TRANS_DATA_FIM#' null='#iif(len(trim(arguments.REL_TRANS_DATA_FIM)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Relatrio impresso com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
