<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as inspecoes em aberto nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_grupos_veiculos" access="remote" returntype="query" output="true">
		<cfargument name="cod_grupo" required="no">
		<cfquery datasource="#session.dsn#" name="qr_grupos" username="#session.usuario#" password="#session.senha#">
			select cod_grupo, cod_grupo || decode(situacao_id,1,' (Ativo)',' (Inativo)')  as cod_grupo_situacao, descricao
            		/*,  limite_veiculo*/
			  from oper.v$veiculo_grupo_setup
             where 1=1
			<cfif IsDefined("arguments.COD_GRUPO") and Len(Trim(arguments.COD_GRUPO))>
			   and cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
			</cfif>
			order by situacao_id desc, cod_grupo
   		</cfquery>	
		<cfreturn qr_grupos>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pneus apartir de uma lista
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_pneus" returntype="query" access="remote">
		<cfargument name="lista_pneus" required="no">
		<cfargument name="lista_localizacao" required="no">
		<cfargument name="pneu_id" required="no">
		<cfargument name="num_pneu" required="no">
		<cfargument name="situacao_id" required="no">
		<cfargument name="transferencia" required="no">
		<cfargument name="varios" required="no" default="">	
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, p.num_pneu, p.situacao_id, 
            	   to_char(p.data_aquisicao,'dd/mm/yyyy') as data_aquisicao,  p.custo, 
				   p.nota_fiscal_numero, p.nota_fiscal_serie, pj2.cnpj_cpf as cnpj_cpf, p.ano_fabricacao, p.marca_id, p.marca,
				   p.modelo_id, p.modelo, pb.borracha_id, pb.descricao as borracha, pd.desenho_id, pd.descricao as desenho, 
				   p.sulco, p.medida_id, p.medida, p.medida_roda_id,
				   p.medida_roda, p.reformas, decode(p.reformas,0,'Novo','Reforma ' || p.reformas) as status,
				   oper.pkg_pneu.fnc_valor_pneu(p.pneu_id) as valor_estimado,
				   p.situacao,p.situacao_id,p.formato_borracha,
				   pj.cliente as filial, pl.cod_pessoa,
				   pr.data_retorno_reforma,
				   p.observacoes,
                   pj.cod_pessoa as cod_filial,
				   oper.pkg_pneu.fnc_km_rodado_pneu(p.pneu_id) as km_rodado_total,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 0) quant_reparos,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 1) quant_furos,
					oper.pkg_pneu.fnc_reforma_bloqueada(p.pneu_id) as reforma_bloqueada, 
					p.libera_reforma_manual,
					nvl(p.usuario_bloqueio,'Sistema') as usuario_bloqueio,
					oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as sulco_estimado,
					oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco_atual,
					nvl((select pm.placa
					  from oper.v$pneu_movimentacao pm
					 where pm.pneu_id = p.pneu_id
					   and pm.data_desmontagem is null),'Desmontado') as montado_em,
					 pj2.razao_social as proprietario, 
					 (select cliente
					    from kss.v$pessoa pj
                       inner join oper.v$pneu_reformador_bandeira pb1
                               on pb1.cod_pessoa = pj.cod_pessoa
					   where pb1.reformador_id = pr.reformador_id) as reformador,
					 0 as conserto_estrada,
					  (select nvl(sum(custo),0)
						 from oper.v$pneu_reforma pc
					    where pc.pneu_id = p.pneu_id
						  and pc.conserto = 1) as outros_consertos					 			
			  from oper.v$pneu_dados p
			 left join oper.v$pneu_localizacao_atual pl 
			         on pl.pneu_id = p.pneu_id
	         left join kss.v$pessoa pj
                    on pj.cod_pessoa = pl.cod_pessoa
	         left join oper.v$pneu_proprietario pp
                    on p.pneu_id = pp.pneu_id
				   and pp.data_fim is null
			 left join kss.v$pessoa pj2
	 			    on pj2.cod_pessoa = pp.cod_pessoa
			 left join oper.v$pneu_reforma pr
			        on pr.pneu_id = p.pneu_id
				   and pr.conserto = 0
			left join oper.v$pneu_borracha pb
					on pb.borracha_id = pr.borracha_id
			left join oper.v$pneu_desenho pd
					on pd.borracha_id = pr.borracha_id
				   and pd.desenho_id = pr.desenho_id													 
			 where 1=1
			 and (pr.data_retorno_reforma is null or pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                         from oper.v$pneu_reforma pr2
                                        where pr2.pneu_id = pr.pneu_id
                                         and pr2.conserto = 0))
			 <cfif IsDefined("arguments.lista_pneus") and Len(Trim(arguments.lista_pneus))>
			   and p.pneu_id in (#arguments.lista_pneus#)
			 </cfif>  			 
			 <cfif ((Len(trim(arguments.varios))) and (IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))))>
			   	and p.pneu_id in (#arguments.pneu_id#)
			 <cfelse>
			 		<cfif IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))>
			   			and p.pneu_id = #arguments.pneu_id#
			 		</cfif>
			 </cfif>
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = #arguments.num_pneu#
			 </cfif>  
			 <cfif IsDefined("arguments.lista_localizacao") and Len(Trim(arguments.lista_localizacao))>
			   and pl.localizacao_id in (#arguments.lista_localizacao#)
			 </cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
			   and p.situacao_id = #arguments.situacao_id#
			 </cfif>
			 order by p.num_pneu		 
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
</cfcomponent>