<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	--
	-- NOTAS EXPLICATIVAS
	--
	-- CRISTOFER 01/02/2006 - criado
	--->
	<cffunction name="get_pessoa_light" access="remote" returntype="Query" output="true">
			<cfargument name="cnpj_cpf" required="no" default="">
			<cfargument name="cod_cadastro_contribuinte" required="no" default="">
			<cfargument name="cliente" required="no" default="">
			<cfargument name="cod_pessoa" required="no" default="">
			<cfargument name="tipo_pessoa" required="no" default="">
			<cfargument name="modalidade_id" required="no" default="">
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="razao_social" required="no" default="">
			<cfargument name="municipio" required="no" default="">
			<cfargument name="tipo" required="no" default="">
			<cfargument name="valor" required="no" default="">
			<cfargument name="rapida" required="no" default="0">
			<cfargument name="posto" required="no" default="0">
			<cfargument name="oficina" required="no" default="0">
            <cfargument name="cod_atividade_fiscal" required="no" default="">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select distinct p.cod_pessoa,
					   p.tipo_pessoa,
					   p.cnpj_cpf,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.identificador) as identificador,
					   decode(p.tipo_pessoa,2, nvl(pe.cod_cadastro_contribuinte,pe.cod_pessoa),p.cnpj_cpf) as cnpj_cpf,
					   p.inscricao_estadual,
					   p.razao_social,
					   p.cliente,
					   p.cod_atividade_fiscal,
                       po.numero,
                       po.logradouro,
					   p.tipo_pessoa as tipo_pessoa_id,
					   nvl(fma.num_matricula,0) as cod_funcionario,
                       kss.pkg_pessoa.fnc_get_endereco(p.cod_pessoa,1) as endereco_completo,
					   nvl(po.municipio,pe.municipio) as municipio, po.uf, nvl(po.municipio_id, pe.municipio_id) as municipio_id,
                       nvl(po.municipio,pe.municipio) || ' - ' || po.uf as municipio_uf
					<cfif arguments.posto eq 1>
						,  (select preco
							  from oper.v$posto_historico_produto_prec php
							 where produto_id = 62
							   and cod_pessoa = p.cod_pessoa
							   and data_vigencia = (select max(data_vigencia)
													  from oper.v$posto_historico_produto_prec php2
													 where php2.cod_pessoa = php.cod_pessoa
													   and php2.produto_id = php.produto_id)) preco_diesel
					</cfif>
				  from kss.v$pessoa p
				  left join kss.v$pessoa_fisica pf
						 on pf.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_estrangeira pe
						 on pe.cod_pessoa = p.cod_pessoa
				  left join kss.v$pessoa_endereco po
				         on po.cod_pessoa = p.cod_pessoa
					     and po.endereco_padrao = 1
	              left join kss.v$funcionario_matr_atual fma
    	                 on fma.cod_pessoa = p.cod_pessoa
				<cfif len(trim(arguments.modalidade_Id))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1
						and pm.num_modalidade in (#arguments.modalidade_id#)
				</cfif>
				<cfif len(trim(arguments.num_modalidade))>
				 inner join kss.v$pessoa_modalidade pm
				         on pm.cod_pessoa = p.cod_pessoa
                        and pm.situacao = 1
						and pm.num_modalidade in (#arguments.num_modalidade#)
				</cfif>
				 where 1=1
				 <cfif len(trim(arguments.cliente))>
				   and upper(p.cliente) like upper('%#arguments.cliente#%')
				 </cfif>
				 <cfif len(trim(arguments.cnpj_cpf))>
				   and (p.cnpj_cpf like '#arguments.cnpj_cpf#%' or pe.cod_cadastro_contribuinte like '#arguments.cnpj_cpf#%')
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 3 >
				   and (p.cnpj_cpf like '#arguments.valor#%' or pe.cod_cadastro_contribuinte like '#arguments.valor#%')
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 2 >
				   and upper(p.cliente) like upper('%#arguments.valor#%')
				 </cfif>
				 <cfif len(trim(arguments.cod_cadastro_contribuinte))>
				   and pe.cod_cadastro_contribuinte = '#arguments.cod_cadastro_contribuinte#'
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa))>
				   and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.tipo_pessoa))>
				   and p.tipo_pessoa = #arguments.tipo_pessoa#
				 </cfif>
				 <cfif isDefined('arguments.tipo') and arguments.tipo eq 1 >
				   and upper(p.razao_social) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif isDefined('arguments.tipo') and arguments.tipo eq 4 >
				   and upper(po.municipio) like upper('%#arguments.valor#%')
   					or upper(pe.municipio) like upper('%#arguments.valor#%')
				 </cfif>
                 <cfif len(trim(arguments.razao_social))>
				   and upper(p.razao_social) like upper('%#arguments.razao_social#%')
				 </cfif>
				 <cfif arguments.rapida eq 1>
				   and rownum = 1
				 </cfif>
                 <cfif Len(Trim(arguments.cod_atividade_fiscal))>
				   and p.cod_atividade_fiscal = #arguments.cod_atividade_fiscal#
				 </cfif>
				   order by <cfif arguments.oficina eq 1>p.cliente, </cfif>p.razao_social
			</cfquery>
		<cfreturn qr />
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca todos os setores
	-- NOTAS EXPLICATIVAS
	--
	-- CRISTOFER 04/01/2006 - criado
	--->
	<cffunction name="get_setores" displayname="Busca todos os setores" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" 	required="no">
		<cfargument name="borracharia" 			required="no">
		<cfquery name="qr_agencias" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct  s.cod_setor,
                   pj.nome_fantasia as descricao,
                   pj.nome_fantasia as setor,
                   s.cod_pessoa_filial as cod_pessoa,
                   s.cod_pessoa_filial, pj.cnpj_basico, pj.cnpj_ordem, pj.nome_fantasia as filial
              from kss.v$setor_informacoes s
             inner join kss.v$pessoa_juridica pj
                     on s.cod_pessoa_filial = pj.cod_pessoa
			 where 1=1
			 <cfif isDefined("arguments.borracharia")>
				and s.possui_borracharia = 1
			 </cfif>
			 <cfif isDefined("arguments.cod_pessoa_filial")>
				and s.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 <cfelse>
			  order by s.cod_pessoa_filial
			 </cfif>
		</cfquery>
		<cfreturn qr_agencias>
	</cffunction>

	<!---
    -- PROPSITO
    -- Busca todas as filiais
    -- ANDERSON 14/08/2009 - EDITADO
    --->
    <cffunction name="get_filiais" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="caixa_ativo" required="no" default="">
				<cfargument name="rec_estoque_oper" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct o.cod_pessoa
                 , o.cod_pessoa as cod_pessoa_filial --compatibilidade
                 , o.cod_unidade_negocio
                 , substr(p.cnpj_cpf, 1, 8) as cnpj_basico
                 , substr(p.cnpj_cpf, 9, 4) as cnpj_ordem
                 , p.cnpj_cpf as cnpj_completo
                 , (select pe.municipio
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa= o.cod_pessoa) as municipio
                 , (select pe.uf
                      from kss.v$pessoa_endereco_padrao pe
                     where pe.cod_pessoa= o.cod_pessoa) as uf
                 , p.cliente as nome_fantasia
                 , p.cliente as nome
              from kss.v$organograma o
             inner join kss.v$pessoa p
                     on p.cod_pessoa = o.cod_pessoa
             where 1 = 1


          <cfif Len(Trim(arguments.rec_estoque_oper)) and arguments.rec_estoque_oper eq 1>
             and exists (select 1
                           from estoque.v$estoque_oper eo
                          where eo.cod_organograma = o.cod_organograma
													  and eo.ativo = 1
             		   )


          </cfif>

			    <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and o.cod_pessoa = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.caixa_ativo)) >
            	and exists ( select 'x'
                               from finan.v$caixa_gestao cg
                              where cg.cod_pessoa = p.COD_PESSOA
                                and cg.ativo = 1)
            </cfif>
             order by p.cliente
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <cffunction name="get_estoque_oper" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.estoque_id as estoque_oper_id
			     , t.descricao as estoque_oper
			  from estoque.v$estoque_oper t
			 where 1 = 1
		   and exists (select 1
			                 from kss.v$lotacao l
			                inner join kss.v$usuario_lotacao ul
			                   on ul.cod_lotacao = l.cod_lotacao
			                inner join kss.v$unidade_negocio un
			                   on un.cod_pessoa = l.cod_pessoa
			                where ul.usuario = user
			                  and t.cod_centro_custo = l.cod_centro_custo
			                  and t.cod_setor = l.cod_setor
			                  and t.cod_departamento = l.cod_departamento
			                  and t.cod_unidade_negocio = un.cod_unidade_negocio )

        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <cffunction name="get_estoque_oper_recurso" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select kss.pkg_controle.fnc_recurso_ativo(p_cod_recurso => 'M322-REC00001') as recurso
               from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


	<!---
	-- PROPSITO
	-- Busca todos os setores de origem na transferencia de materiais
	-- NOTAS EXPLICATIVAS
	--
	-- LOUIS 30/08/2006 - criado
	--->
	<cffunction name="get_setores_origem" access="remote" returntype="query" output="true">
		<cfargument name="cod_centro_custo" required="no">
		<cfquery name="qr_agencias" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct (select t.nome
                    		   from oper.v$filial t
                  		  	  where t.cod_pessoa =  mo.cod_pessoa_filial) as filial_origem,
                  			(select t.nome
                    		   from oper.v$filial t
                  			  where t.cod_pessoa =  tr.cod_pessoa_filial_destino) as filial_destino,
                            mo.cod_pessoa_filial as origem,
                            tr.cod_pessoa_filial_destino as destino
              from almoxarifado.v$movimentacao_dados mo
        inner join almoxarifado.v$transferencia tr
                on tr.lancamento_id_saida = mo.lancamento_id
         where 1=1
         <cfif len(trim(arguments.cod_pessoa_filial))>
           and mo.cod_pessoa_filial = #arguments.cod_pessoa_filial#
         </cfif>
         and tr.data_entrada is null
		</cfquery>
		<cfreturn qr_agencias>
	</cffunction>

   <!---
	-- PROPSITO
	-- Busca todos os setores de origem na transferencia de materiais
	-- NOTAS EXPLICATIVAS
	--
	-- LOUIS 30/08/2006 - criado
	--->
	<cffunction name="get_centro_custo" access="remote" returntype="query" output="true">
		<cfargument name="cod_centro_custo" required="no" default="">
      <cfargument name="cod_pessoa_filial" required="no" default="">
      <cfargument name="estoque" required="no" default="">
			<cfargument name="rec_estoque_oper" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cc.cod_centro_custo
              , cc.centro_custo
              , cc.formacao_custo
           from kss.v$centro_custo cc
          where 1 = 1


        <cfif Len(Trim(arguments.rec_estoque_oper)) and arguments.rec_estoque_oper eq 1>
             and exists (select 1
                           from kss.v$organograma o
                          inner join estoque.v$estoque_oper eo
						     on eo.cod_organograma = o.cod_organograma
							and eo.ativo = 1 
                          where o.cod_centro_custo = cc.cod_centro_custo
			  <cfif len(trim(arguments.cod_pessoa_filial))>
                           and o.cod_pessoa in (#arguments.cod_pessoa_filial#)
              </cfif>	 
						  
             		   )


        </cfif>


		   <cfif len(trim(arguments.cod_centro_custo))>
           and cc.cod_centro_custo = arguments.cod_centro_custo
         </cfif>
         <cfif len(trim(arguments.cod_pessoa_filial))>
            and exists (select 1
                          from kss.v$organograma o
                         where o.cod_centro_custo = cc.cod_centro_custo
                           and o.cod_pessoa in (#arguments.cod_pessoa_filial#)
                        )
         </cfif>
         <cfif Len(Trim(arguments.estoque)) and arguments.estoque eq 1>
            and exists (select 1
						        from almoxarifado.v$movimentacao m
                         where cc.cod_centro_custo = m.cod_centro_custo
						      )
         </cfif>
         order by cc.centro_custo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
