<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Busca modelos de equipamentos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 06/10/2006
	--->
	<cffunction name="get_modelos" returntype="query" access="remote">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select modelo_id, descricao
				  from manutencao.v$modelo m
    		     where 1=1
 			  <cfif Len(Trim(arguments.modelo_id))>
				and m.modelo_id = #arguments.modelo_id#
			  </cfif>
 			  <cfif Len(Trim(arguments.descricao))>
				and upper(m.descricao) like upper('%#arguments.descricao#%')
			  </cfif>
 			  order by m.descricao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca modelos de equipamentos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 06/10/2006
	--->
	<cffunction name="get_equipamento_modelo" returntype="query" access="remote">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ORDERED*/ em.controle_id, em.modelo_id, em.equipamento_id,
				       m.descricao, e.cod_equipamento,
                       to_char(em.data_inicial,'dd/mm/yyyy') as data_inicial,
                       to_char(em.data_final,'dd/mm/yyyy') as data_final,
						 md.material
				  from manutencao.v$equipamento_modelo em
				 inner join manutencao.v$modelo m
				          on em.modelo_id = m.modelo_id
				  inner join almoxarifado.v$equipamento e
				 	       on em.equipamento_id = e.equipamento_id
              inner join almoxarifado.v$material_dados md
				          on md.material_id = e.material_id
		    	  where 1=1
 			  <cfif Len(Trim(arguments.modelo_id))>
				and em.modelo_id in (#arguments.modelo_id#)
			  </cfif>
			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(e.cod_equipamento) like upper('%#arguments.descricao#%')
			  </cfif>
 			  order by em.controle_id
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca grupo de atividades
	-- NOTAS EXPLICATIVAS
	-- ARLEN 05/10/2006
	--->
	<cffunction name="get_atividade_grupo" returntype="query" access="remote">
		<cfargument name="grupo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select ag.grupo_id
			      , trim(substr(replace(sys_connect_by_path(ag.descricao, '@@'),'@@',' / '),4)) as descricao
			   from manutencao.v$atividade_grupo ag
			  where 1 = 1
  			  <cfif Len(Trim(arguments.grupo_id))>
			 	and grupo_id in (#arguments.compartimento_id#)
			  </cfif>
  			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(descricao) like upper('%#arguments.descricao#%')
			  </cfif>
			  start with ag.grupo_id_pai is null
            connect by prior ag.grupo_id = ag.grupo_id_pai
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca compartimentos do veculo
	-- NOTAS EXPLICATIVAS
	-- ARLEN 04/10/2006
	--->
	<cffunction name="get_atividade_compartimento" returntype="query" access="remote">
		<cfargument name="compartimento_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select compartimento_id, descricao, ordem
			   from manutencao.v$atividade_compartimento
			  where 1=1
  			  <cfif Len(Trim(arguments.compartimento_id))>
			 	and compartimento_id = #arguments.compartimento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(kss.pkg_string.fnc_string_clean(descricao)) like upper('%#arguments.descricao#%')
			  </cfif>
			  order by ordem
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca POSIES
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/09/2006
	--->
	<cffunction name="get_equipamento_posicao" returntype="query" access="remote">
		<cfargument name="posicao_id" required="no" default="">
		<cfargument name="posicao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select posicao_id, posicao
			  from manutencao.v$equipamento_posicao p
  		     where 1=1
 			  <cfif Len(Trim(arguments.posicao_id))>
				and p.posicao_id = #arguments.posicao_id#
			  </cfif>
 			  <cfif Len(Trim(arguments.posicao))>
				and upper(p.posicao) like upper('%#arguments.posicao#%')
			  </cfif>
			  order by p.posicao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca posies dos materiais
	-- NOTAS EXPLICATIVAS
	-- arlen 16/10/2006
	--->
	<cffunction name="get_posicao_material" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mp.item_id, mp.material_id, mp.posicao_id, ep.posicao, ep.posicao_id
				from manutencao.v$material_posicao mp
               inner join manutencao.v$equipamento_posicao ep
				  on ep.posicao_id = mp.posicao_id
               where 1 = 1
			  <cfif Len(Trim(arguments.material_id))>
				and mp.material_id = #arguments.material_id#
			  </cfif>
			  order by ep.posicao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca processo
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_processo" returntype="query" access="remote">
		<cfargument name="processo_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="titulo_full" required="no" default="">
		<cfargument name="sem_detalhamento" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.processo_id, p.titulo,
				   <cfif arguments.sem_detalhamento eq 0>to_char(p.detalhamento) as detalhamento, </cfif>
				   to_char(p.tempo_execucao)  as tempo_execucao,
 	            trim(to_char(extract( day from p.tempo_execucao) + extract( hour from p.tempo_execucao),'00')) as tempo_execucao_horas,
               trim(to_char(extract( minute from p.tempo_execucao),'00')) as tempo_execucao_minutos
			  from manutencao.v$processo p
		     where 1=1
 			  <cfif Len(Trim(arguments.processo_id))>
				and p.processo_id = #arguments.processo_id#
			  </cfif>
			  <cfif Len(Trim(arguments.titulo))>
				and upper(p.titulo) like upper('%#arguments.TITULO#%')
			  </cfif>
			  <cfif Len(Trim(arguments.titulo_full))>
				and upper(p.titulo) like upper('#arguments.TITULO_full#')
			  </cfif>
			  order by p.titulo
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca niveis de especialidade dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/08/2006
	--->
	<cffunction name="get_recurso_nivel" returntype="query" access="remote">
		<cfargument name="nivel_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select substr(sys_connect_by_path(rn.descricao, ','),2) as niveis,
				   rn.descricao, rn.nivel_id
			  from manutencao.v$recurso_nivel rn
			  where 1=1
			  <cfif Len(Trim(arguments.nivel_id))>
			 	 and rn.nivel_id = #arguments.nivel_id#
			  </cfif>
			 start with rn.nivel_pai is null
			connect by prior rn.nivel_id = rn.nivel_pai
			order siblings by rn.descricao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca especialidade dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/08/2006
	--->
	<cffunction name="get_recurso_especialidade" returntype="query" access="remote">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="especialidade_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select especialidade_id, descricao
			  from manutencao.v$recurso_especialidade
			 where 1=1
			  <cfif Len(Trim(arguments.descricao))>
				and upper(descricao) like upper('%#arguments.descricao#%')
			  </cfif>
			  <cfif Len(Trim(arguments.especialidade_id))>
				and especialidade_id = #arguments.especialidade_id#
			  </cfif>
			  order by descricao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de atividades
	-- GUTO 16/09/2006
	--->
	<cffunction name="get_atividade_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.tipo_id, a.nome, a.descricao
			  from manutencao.v$atividade_tipo a
			order by a.nome
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de oficina
	-- GUTO 16/09/2006
	--->
	<cffunction name="get_tipo_oficina" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oficina_tipo_id, descricao, num_modalidade
              from manutencao.v$oficina_tipo t
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as atividades
	-- CRISTOFER  10/08/2006
	--->
	<cffunction name="get_atividade" access="remote" returntype="query" output="true">
		<cfargument name="cod_atividade"  required="no" default="">
		<cfargument name="titulo" 			 required="no" default="">
		<cfargument name="atividade_id" 	 required="no" default="">
		<cfargument name="importancia" 	 required="no" default="">
		<cfargument name="grupo_id" 		 required="no" default="">
		<cfargument name="tabela_id" 		 required="no" default="">
      <cfargument name="situacao_ativo" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select a.atividade_id
              , a.cod_atividade
              , a.titulo
              , to_char(a.tempo_execucao) as tempo_execucao
              , (sysdate + a.tempo_execucao - sysdate) as tempo_execucao_total
              , trim(to_char((extract(day from a.tempo_execucao) * 24) + extract( hour from a.tempo_execucao), '00')) as tempo_execucao_horas
              , trim(to_char(extract(minute from a.tempo_execucao), '00')) as tempo_execucao_minutos
              , a.garantia_km
              , a.garantia_horas_trabalhadas
              , a.garantia_dias
              , a.garantia_lts_combustivel
              , a.alerta_km
              , a.alerta_horas_trabalhadas
              , a.alerta_dias
              , a.alerta_lts_combustivel
              , a.multiplo
              , a.grupo_id
              , a.tipo_id
              , a.compartimento_id
              , ag.descricao as grupo
              , a.importancia
              , a.verificacao
              , a.tempo_indefinido
              , a.nivel_id
              , round((sysdate + a.tempo_execucao - sysdate) * 1440) as tempo_minutos
              , (select ap.produto_id
                   from manutencao.v$atividade_produto ap
                  where ap.atividade_id = a.atividade_id
                ) as produto_id
         <cfif Len(Trim(arguments.tabela_id))>
              , t.valor
         <cfelse>
              , 0 as valor
         </cfif>
              , a.ativo
           from manutencao.v$atividade a
           left join manutencao.v$atividade_grupo ag
                  on ag.grupo_id = a.grupo_id
         <cfif Len(Trim(arguments.tabela_id))>
          inner join (select ma.atividade_id
                           , tpa.valor
                        from compras.v$tabela_preco_material tpm
                       inner join almoxarifado.v$material_atividade ma
                          on ma.material_id = tpm.material_id
                       where tpm.tabela_id = #arguments.tabela_id#
                         and tpm.data_vigencia =  (select max(tpm2.data_vigencia)
                                                       from compras.v$tabela_preco_material tpm2
                                                      where tpm2.material_id = tpm.material_id
                                                        and tpm2.tabela_id = tpm.tabela_id
                                                        and tpm2.data_vigencia <= sysdate
                                                  )
                     ) t
                  on t.atividade_id = a.atividade_id
         </cfif>
          where 1 = 1
         <cfif len(trim(arguments.titulo))>
            and upper(kss.pkg_string.fnc_string_clean(a.titulo)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.titulo#%'))
         </cfif>
         <cfif len(trim(arguments.COD_ATIVIDADE))>
            and upper(a.cod_atividade) like upper('%#arguments.COD_ATIVIDADE#%')
         </cfif>
         <cfif len(trim(arguments.atividade_id))>
            and a.atividade_id in (#arguments.atividade_id#)
         </cfif>
         <cfif len(trim(arguments.importancia))>
            and a.importancia = #arguments.importancia#
         </cfif>
         <cfif len(trim(arguments.grupo_id))>
            and a.grupo_id = #arguments.grupo_id#
         </cfif>
         <cfif len(trim(arguments.situacao_ativo)) and arguments.situacao_ativo eq 1>
            and a.ativo = 1
         </cfif>
          order by ag.descricao, a.titulo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca processo recurso
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_processo_recurso" returntype="query" access="remote">
		<cfargument name="processo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select item_id, processo_id, especialidade_id, quantidade, nivel_id, percentual_participacao,
											(select kss.fnc_concat_all(kss.to_concat_expr(nivel_id,','))
														from manutencao.v$recurso_nivel rn
													where rn.nivel_id <= p.nivel_id) as niveis_permitidos,
											(select count(*)
														from manutencao.v$processo_recurso pr
													where pr.processo_id = p.processo_id) as num_funcionarios
						from manutencao.v$processo_recurso p
			    where 1=1
 			  <cfif Len(Trim(arguments.processo_id))>
	 	  		and p.processo_id = #arguments.processo_id#
			  </cfif>
			  order by p.processo_id
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os processos da atividade
	-- CRISTOFER  11/08/2006
	--->
	<cffunction name="get_atividade_processo" access="remote" returntype="query">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.item_id,
				   ap.item_pai,
				   ap.ordem,
				   ap.atividade_id,
				   ap.processo_id,
				   p.titulo as processo,
				   ap.user_insert,
				   ap.date_insert,
				   ap.user_update,
				   ap.date_update,
				   ap.site
			  from manutencao.v$atividade_processo ap
			 inner join manutencao.v$processo p
			         on p.processo_id = ap.processo_id
			 where ap.atividade_id in (#arguments.atividade_id#)
			 start with ap.item_pai is null
			connect by prior ap.item_id = ap.item_pai
			order siblings by ap.ordem
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as posices da atividade
	-- CRISTOFER  11/08/2006
	--->
	<cffunction name="get_atividade_posicao" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.posicao_id,
				   ap.atividade_id,
				   ep.posicao
			  from manutencao.v$atividade_posicao ap
			 inner join manutencao.v$equipamento_posicao ep
			         on ep.posicao_id = ap.posicao_id
			 where atividade_id in (#arguments.atividade_id#)
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dependencia entre as atividades
	-- GUTO 30/10/2006
	--->
	<cffunction name="get_atividade_dependencia" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id_principal" required="no" default="">
		<cfargument name="atividade_id_dependente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ad.atividade_id_principal, ad.atividade_id_dependente, ad.obrigatoria,
					 a1.titulo as atividade_principal, a2.titulo as atividade_dependente,
					 a1.cod_atividade as cod_atividade_principal, a2.cod_atividade as cod_atividade_dependente
			  from manutencao.v$atividade_dependencia ad
			 inner join manutencao.v$atividade a1
						on a1.atividade_id = ad.atividade_id_principal
			 inner join manutencao.v$atividade a2
						on a2.atividade_id = ad.atividade_id_dependente
			 where 1=1
			   <cfif Len(Trim(arguments.atividade_id_principal))>
				   and ad.atividade_id_principal = #arguments.atividade_id_principal#
				</cfif>
			   <cfif Len(Trim(arguments.atividade_id_dependente))>
				   and ad.atividade_id_dependente = #arguments.atividade_id_dependente#
				</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividades conjugadas
	-- GUTO 11/07/2008
	--->
	<cffunction name="get_atividade_conjugada" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id_principal" required="no" default="">
		<cfargument name="atividade_id_conjugada" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ad.atividade_id_principal, ad.atividade_id_conjugada, ad.baixa_obrigatoria,
                   a1.titulo as atividade_principal, a2.titulo as atividade_conjugada,
                   a1.cod_atividade as cod_atividade_principal, a2.cod_atividade as cod_atividade_conjugada,
				   ad.garantia_km, ad.garantia_horas_trabalhadas, ad.garantia_dias, ad.garantia_lts_combustivel,
				   ad.alerta_km, ad.alerta_horas_trabalhadas, ad.alerta_dias, ad.alerta_lts_combustivel
              from manutencao.v$atividade_conjugada ad
             inner join manutencao.v$atividade a1
                     on a1.atividade_id = ad.atividade_id_principal
             inner join manutencao.v$atividade a2
                     on a2.atividade_id = ad.atividade_id_conjugada
             where 1=1
		     <cfif Len(Trim(arguments.atividade_id_principal))>
               and ad.atividade_id_principal = #arguments.atividade_id_principal#
             </cfif>
             <cfif Len(Trim(arguments.atividade_id_conjugada))>
               and ad.atividade_id_conjugada = #arguments.atividade_id_conjugada#
             </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividade tipos de oficina
	-- GUTO 16/09/2006
	--->
	<cffunction name="get_atividade_oficina_tipo" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atividade_id, oficina_tipo_id as tipo_id
			  from manutencao.v$atividade_oficina_tipo
			 where atividade_id = #arguments.atividade_id#
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca oficinas cadastradas
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_oficinas" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="interna" required="no" default=""/>
		<cfargument name="com_os" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select o.cod_pessoa, o.cnpj_cpf, o.identificador, o.inscricao_estadual,
				   o.razao_social, o.cliente
			  from manutencao.v$oficinas o
			 where 1=1
			 <cfif Len(Trim(arguments.COD_PESSOA))>
			   and cod_pessoa = #arguments.COD_PESSOA#
			 </cfif>
			 <cfif Len(Trim(arguments.INTERNA))>
			   and interna= #arguments.INTERNA#
			 </cfif>
			 <cfif Len(Trim(arguments.COM_OS))>
			   and exists (select 'x'
			                 from manutencao.v$ordem_servico os
							where os.cod_pessoa_oficina = o.cod_pessoa)
			 </cfif>
			 order by cliente
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as oficinas distintas a que os funcionrios esto vinculados
	-- NOTAS EXPLICATIVAS
	-- ERICG 21/10/2010
	--->
	<cffunction name="get_distinct_oficina_recurso" returntype="query" access="remote">
		<cfargument name="RECURSO_ID" required="no" default="" >
		<cfargument name="COD_PESSOA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select distinct ro.cod_pessoa_oficina
               , to_char(ro.data_inicio, 'dd/mm/yyyy') data_inicio
               , to_char(ro.data_fim, 'dd/mm/yyyy') data_fim
            from manutencao.v$recurso_oficina ro
           inner join manutencao.v$recurso re
                   on re.recurso_id in ro.recurso_id
           where 1 = 1
			<cfif len(Trim(arguments.RECURSO_ID))>
			   and ro.recurso_id in (#arguments.RECURSO_ID#)
		    </cfif>
			<cfif len(Trim(arguments.COD_PESSOA))>
			    and re.COD_PESSOA = #arguments.COD_PESSOA#
		    </cfif>
		    order by data_inicio desc
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_recurso" returntype="query" access="remote">
		<cfargument name="recurso_id" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="nivel_id" required="no" default="">
		<cfargument name="especialidade_id" required="no" default="">
		<cfargument name="todos" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct r.recurso_id,
				   r.cod_pessoa, pf.cliente as nome_funcionario,
				   oper.pkg_global.fnc_get_cod_funcionario(r.cod_pessoa) as cod_funcionario,
				   r.especialidade_id,
				   re.descricao as especialidade,
				   r.nivel_id, rn.descricao as nivel
			  from manutencao.v$recurso r
			 inner join manutencao.v$recurso_especialidade re
					 on re.especialidade_id = r.especialidade_id
			 inner join manutencao.v$recurso_nivel rn
					 on rn.nivel_id = r.nivel_id
			 inner join kss.v$pessoa pf
					 on pf.cod_pessoa = r.cod_pessoa
		     where 1=1
			  <cfif arguments.todos eq 0>
			 	 and (exists (select 'x'
				               from manutencao.v$recurso_oficina ro
                      inner join manutencao.v$recurso r2
                              on r2.recurso_id = ro.recurso_id
                      where r2.cod_pessoa = r.cod_pessoa
                        and ro.cod_pessoa_oficina = #session.cod_pessoa#)
      			 	 or not exists (select 'x'
      				                  from manutencao.v$recurso_oficina ro
                               inner join manutencao.v$recurso r2
                                       on r2.recurso_id = ro.recurso_id
                               inner join oper.v$filial f
                                       on f.cod_pessoa = ro.cod_pessoa_oficina
                               where r2.cod_pessoa = r.cod_pessoa) )
			  </cfif>
 			  <cfif Len(Trim(arguments.cod_pessoa))>
							and r.cod_pessoa = #arguments.cod_pessoa#
			   </cfif>
			   <cfif Len(Trim(arguments.recurso_id))>
				   and r.recurso_id = #arguments.recurso_id#
			   </cfif>
			   <cfif Len(Trim(arguments.especialidade_id))>
				   and re.especialidade_id in (#arguments.especialidade_id#)
			   </cfif>
			   <cfif Len(Trim(arguments.nivel_id))>
				   and rn.nivel_id in (#arguments.nivel_id#)
			   </cfif>
			  order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/08/2006
	--->
	<cffunction name="get_tabela_manutencao" returntype="query" access="remote">
		<cfargument name="tabela_id" required="no" default="" />
		<cfargument name="titulo" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select replace(substr(sys_connect_by_path(replace(nome,'/','@@'), '/'),2),'@@','/') as path,
				   nome || ' [' || replace(substr(sys_connect_by_path(replace(nome,'/','@@'), '/'),2),'@@','/')  || ']' as tabelas,
				   nome, substr(sys_connect_by_path(tabela_id, ','),2) as lista_tabelas,
                   nome, substr(sys_connect_by_path('|' || tabela_id || '|', ','),2) as lista_tabela_separador,
				   descricao, tabela_id, tabela_pai, obrigatoria,
				   intervalo_km, intervalo_dias,
				   intervalo_horas_trabalhadas, intervalo_lts_combustivel, alerta_km,
				   alerta_dias, alerta_horas_trabalhadas, alerta_lts_combustivel,
				   verificacao_pneus, atualiza_revisao, exige_lavagem,tipo_execucao
			  from manutencao.v$tabela_manutencao
			 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and tabela_id = #arguments.tabela_id#
			 </cfif>
			 <cfif Len(Trim(arguments.titulo))>
			   and upper(nome) like upper('%#arguments.titulo#%')
			 </cfif>
			 start with tabela_pai = 0
		    connect by prior tabela_id = tabela_pai
		    order siblings by tabela_pai
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuteno (ATIVIDADE)
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_tabela_atividade" returntype="query" access="remote">
		<cfargument name="tabela_id" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ta.tabela_id, ta.atividade_id, a.titulo,
					round((sysdate + a.tempo_execucao - sysdate) * 1440) as tempo_minutos
			  from manutencao.v$tabela_atividade ta
			 inner join manutencao.v$atividade a
		  		     on a.atividade_id = ta.atividade_id
	      	 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and ta.tabela_id = #arguments.tabela_id#
			 </cfif>
		     order by ta.tabela_id
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuteno vinculadas a um modelo
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_tabela_modelo" returntype="query" access="remote">
		<cfargument name="tabela_id" required="no" default=""/>
		<cfargument name="modelo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tm.tabela_id, tm.modelo_id, m.descricao as modelo,
					 tma.nome as tabela
			  from manutencao.v$tabela_modelo tm
			 inner join manutencao.v$modelo m
						on m.modelo_id = tm.modelo_id
			 inner join manutencao.v$tabela_manutencao tma
						on tma.tabela_id = tm.tabela_id
			 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and tm.tabela_id = #arguments.tabela_id#
			 </cfif>
			 <cfif Len(Trim(arguments.modelo_id))>
			   and tm.modelo_id = #arguments.modelo_id#
			 </cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os valores dos nveis de especialidades
	-- NOTAS EXPLICATIVAS
	-- ARLEN 11/12/2006
	--->
	<cffunction name="get_especialidade_valor" returntype="query" access="remote">
		<cfargument name="CONTROLE_ID" required="no" default="" >
		<cfargument name="ESPECIALIDADE_ID" required="no" default="" >
		<cfargument name="NIVEL_ID" required="no" default="" >
		<cfargument name="ABERTOS" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ev.controle_id,
				   ev.especialidade_id,
				   ev.nivel_id,
				   ev.valor_empresa,
				   ev.valor_terceiro,
				   to_char(ev.data_inicio,'dd/mm/yyyy hh24:mi:ss') data_inicio_char,
				   to_char(ev.data_fim,'dd/mm/yyyy hh24:mi:ss') data_fim_char,
				   re.descricao as especialidade_nome,
				   rn.descricao as nivel_nome
			from manutencao.v$especialidade_valor ev
			inner join manutencao.v$recurso_especialidade re
					   on re.especialidade_id = ev.especialidade_id
			inner join manutencao.v$recurso_nivel rn
					   on rn.nivel_id = ev.nivel_id
			where 1=1
			<cfif len(Trim(arguments.ABERTOS))>
			  and ev.data_fim is null
			</cfif>
			<cfif len(Trim(arguments.CONTROLE_ID))>
			  and ev.controle_id = #arguments.CONTROLE_ID#
			</cfif>
			<cfif len(Trim(arguments.ESPECIALIDADE_ID))>
			  and ev.especialidade_id = #arguments.ESPECIALIDADE_ID#
			</cfif>
			<cfif len(Trim(arguments.NIVEL_ID))>
			  and ev.nivel_id = #arguments.NIVEL_ID#
			</cfif>
			order by ev.data_inicio desc, re.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 08/04/2009
	--->
	<cffunction name="get_equipamentos" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="placa" required="no" default="">
		<cfargument name="sem_modelo" required="no" default="0">
        <cfargument name="equipamento" required="no" default="">
        <cfargument name="analisados" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.equipamento_id
                 , m.cod_equipamento
                 , m.placa
                 , ma.material
                 , (select ce.contrato_id
                      from manutencao.v$contrato_equipamento ce
                     where ce.equipamento_id = m.equipamento_id
                       and ce.data_termino is null) as contrato_id
                 , kss.pkg_organizacional.fnc_cod_organizacional(oper.pkg_veiculo.fnc_veiculo_ccusto_gerencial(m.placa)) as cod_organizacional
              from almoxarifado.v$equipamento m
             inner join almoxarifado.v$material_dados ma
                     on ma.material_id = m.material_id
            <cfif Len(trim(arguments.analisados))>
              left join manutencao.v$equipamento_analise ea
                     on ea.equipamento_id = m.equipamento_id
            </cfif>
             where 1 = 1
            <cfif Len(Trim(arguments.equipamento_id))>
               and m.equipamento_id = #arguments.equipamento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
               and m.cod_equipamento = '#arguments.cod_equipamento#'
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (m.cod_equipamento = '#arguments.placa#'
                    or m.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
                   )
            </cfif>
            <cfif arguments.sem_modelo eq 1>
               and not exists (select 'x'
                                 from manutencao.v$equipamento_modelo em
                                where em.equipamento_id = m.equipamento_id
                                  and em.data_final is null)
            </cfif>
            <cfif Len(trim(arguments.equipamento))>
               and upper(ma.material) like upper('%#arguments.equipamento#%')
            </cfif>
            <cfif Len(trim(arguments.analisados))>
               and ea.data_analise is null
            </cfif>
             order by ma.material, m.cod_equipamento
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna todos os vinculos de Atividades/Modelos
	-- Rafael Rudnik 20/05/2008
	--->
    <cffunction name="get_atividade_modelo" returntype="query" access="remote">
        <cfargument name="modelo_id" required="no"/>
        <cfargument name="atividade_id" required="no"/>
        <cfargument name="controle_id" required="no"/>
        <cfargument name="titulo" required="no"/>
        <cfargument name="descricao_atividade" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select ma.controle_id
              , ma.modelo_id
              , ma.atividade_id
              , ma.garantia_km
              , ma.garantia_horas_trabalhadas
              , ma.garantia_dias
              , ma.garantia_lts_combustivel
              , ma.alerta_km
              , ma.alerta_horas_trabalhadas
              , ma.alerta_dias
              , ma.alerta_lts_combustivel
              , ma.user_insert
              , ma.date_insert
              , ma.user_update
              , ma.date_update
              , ma.site
              , at.titulo
              , at.cod_atividade
              , mo.descricao
           from manutencao.v$atividade_modelo ma
          inner join manutencao.v$atividade at
                  on at.atividade_id = ma.atividade_id
          inner join manutencao.v$modelo mo
                  on mo.modelo_id = ma.modelo_id
          where 1 = 1
			<cfif isDefined("arguments.controle_id") and len(trim(arguments.controle_id))>
            and ma.controle_id = '#arguments.controle_id#'
		   </cfif>
           <cfif isDefined("arguments.modelo_id") and len(trim(arguments.modelo_id))>
            and ma.modelo_id = '#arguments.modelo_id#'
		   </cfif>
           <cfif isDefined("arguments.atividade_id") and len(trim(arguments.atividade_id))>
            and ma.atividade_id = '#arguments.atividade_id#'
		   </cfif>
           <cfif isDefined("arguments.titulo") and len(trim(arguments.titulo))>
            and upper(at.titulo) LIKE upper('%#arguments.titulo#%')
		   </cfif>
          order by ma.controle_id desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Retorna os tipos de ordem de servio
    -- ANDERSON 08/12/2009 - CRIADO
    --->
    <cffunction name="get_tipo_ordem_servico" access="remote" returntype="query" output="true">
        <cfargument name="tipo_ordem_servico_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select tos.tipo_ordem_servico_id
                 , tos.descricao
              from manutencao.v$tipo_ordem_servico tos
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_ordem_servico_id))>
               and tos.tipo_ordem_servico_id = #arguments.tipo_ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(tos.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by tos.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca todas as atividades vinculadas ao equipamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 27/12/2006
	--->
	<cffunction name="get_equipamento_atividades_vinculadas" returntype="query" access="remote">
		<cfargument name="EQUIPAMENTO_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ea.controle_id, a.atividade_id, a.cod_atividade, a.titulo as atividade,
				    decode(a.importancia,1,'Baixa',2,'Mdia','Alta') as importancia ,
					 e.cod_equipamento, ea.data_previsao, po.posicao,
					 ea.km_previsao, ea.km_rodado, ea.lts_previsao,
					 ea.data_previsao, ose.data_abertura as data_execucao,
					 manutencao.to_manut_atividade(ea.atividade_id, em.MODELO_ID).garantia_km as garantia_km,
					 manutencao.to_manut_atividade(ea.atividade_id, em.MODELO_ID).garantia_dias as garantia_dias
			  from manutencao.v$equipamento_atividade ea
			 inner join almoxarifado.v$equipamento e
						on e.equipamento_id = ea.equipamento_id
			 inner join manutencao.v$atividade a
						on a.atividade_id = ea.atividade_id
			 left join manutencao.v$equipamento_modelo em
						on em.equipamento_id = e.equipamento_id
					  and em.data_final is null
		      left join manutencao.v$equipamento_posicao po
			         on nvl(po.posicao_id,0) = nvl(ea.posicao_id,0)
			  left join manutencao.v$ordem_servico ose
						on ose.ordem_servico_id = ea.ordem_servico_id_execucao
			where 1=1
			<cfif len(Trim(arguments.EQUIPAMENTO_ID))>
			  and e.equipamento_id = #arguments.EQUIPAMENTO_ID#
			</cfif>
			order by ea.atividade_id, ose.data_abertura desc nulls first
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna tabelas em aberto no equipamento
	-- Guto 01/08/2008
	--->
    <cffunction name="get_equipamento_tabela_manutencao" returntype="query" access="remote">
        <cfargument name="cod_equipamento" required="no" default=""/>
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="abertas" required="no" default="1"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tabela_id, t.nome, et.controle_id,
		           et.km_previsao, nvl(oper.pkg_pneu.fnc_km_atual(e.cod_equipamento),0) as km_atual,
                   et.km_previsao - nvl(oper.pkg_pneu.fnc_km_atual(e.cod_equipamento),0) as diferenca,
                   t.atualiza_revisao,
                   case
                       when t.tipo_execucao = 0 then ''
                       when t.tipo_execucao = 1 then 'Completa'
                       when t.tipo_execucao = 2 then 'Parcial'
                   end tipo_execucao,
                   case
                     when et.ordem_servico_id_execucao = -1 then 'Inicial'
                   else nvl(to_char(os.data_fechamento,'dd/mm/yyyy'),'Previso') end data_execucao,
                   et.km_rodado, t.tipo_execucao, et.ordem_servico_id_execucao, os.num_ordem_servico as NUM_OS_EXECUCAO,
                   et.ordem_servico_id_previsao, osp.num_ordem_servico as num_os_previsao
                from almoxarifado.v$equipamento e
                inner join manutencao.v$equipamento_tabela_manut et
                                on et.equipamento_id = e.equipamento_id
                inner join manutencao.v$tabela_manutencao t
                                on t.tabela_id = et.tabela_id
                left join manutencao.v$os_tabela_manutencao otm
                       on otm.ordem_servico_id = et.ordem_servico_id_execucao
                left join manutencao.v$ordem_servico os
                       on os.ordem_servico_id = otm.ordem_servico_id
                left join manutencao.v$ordem_servico osp
                       on osp.ordem_servico_id = et.ordem_servico_id_previsao
            where 1=1
          <cfif arguments.ABERTAS eq 1>
            and et.ordem_servico_id_execucao is null
          </cfif>
          <cfif len(trim(arguments.cod_equipamento))>
                and e.cod_equipamento = '#arguments.cod_equipamento#'
		  </cfif>
          <cfif len(trim(arguments.equipamento_id))>
                and e.equipamento_id = #arguments.equipamento_id#
		  </cfif>
          <cfif arguments.ABERTAS eq 1>
	          order by e.cod_equipamento, et.km_previsao
          <cfelse>
             order by et.tabela_id, et.km_previsao desc
          </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca o contratos cadastrados
	-- GUTO 11/06/2008
	--->
	<cffunction name="get_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="cod_pessoa_concessionaria" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cm.contrato_id, cm.titulo, cm.cod_pessoa_concessionaria,
            	   to_char(cm.data_inicial,'dd/mm/yyyy') as data_inicial,
                   to_char(cm.data_final,'dd/mm/yyyy') as data_final,
                   p.cliente as concessionaria,
                   p.cnpj_cpf as cnpj_concessionaria
              from manutencao.v$contrato_manutencao cm
             inner join kss.v$pessoa p
                     on p.cod_pessoa = cm.cod_pessoa_concessionaria
              where 1=1
              <cfif Len(Trim(arguments.contrato_id))>
                and contrato_id = #arguments.contrato_id#
              </cfif>
              <cfif Len(Trim(arguments.cod_pessoa_concessionaria))>
                and cod_pessoa_concessionaria = #arguments.cod_pessoa_concessionaria#
              </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca o tabelas de custo
	-- GUTO 11/06/2008
	--->
	<cffunction name="get_contrato_tabela_custo" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="modelo_id" required="no" default="">
    	<cfargument name="atual" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctc.contrato_id
                 , ctc.tabela_id
                 , ctc.titulo
                 , to_char(ctc.data_vigencia,'dd/mm/yyyy') as data_vigencia
                 , ctc.modelo_id
                 , m.descricao as modelo
                 , ctf.num_faixa
                 , ctf.km_inicial
                 , ctf.km_final
                 , ctf.ano_fabricacao_inicial
                 , ctf.ano_fabricacao_final
                 , ctf.valor_km
              from manutencao.v$contrato_tabela_custo ctc
             inner join manutencao.v$contrato_tabela_faixa ctf
                     on ctc.tabela_id = ctf.tabela_id
             inner join manutencao.v$modelo m
                     on m.modelo_id = ctc.modelo_id
             where 1=1
            <cfif Len(Trim(arguments.tabela_id))>
              and ctc.tabela_id = #arguments.tabela_id#
            </cfif>
  	  	    <cfif Len(Trim(arguments.contrato_id))>
              and ctc.contrato_id = #arguments.contrato_id#
            </cfif>
            <cfif Len(Trim(arguments.modelo_id))>
              and ctc.modelo_id = #arguments.modelo_id#
            </cfif>
            <cfif Len(Trim(arguments.atual))>
              and ctc.data_vigencia = (select max(ctc2.data_vigencia)
                                         from manutencao.v$contrato_tabela_custo ctc2
                                        where ctc2.contrato_id = ctc.contrato_id
                                          and ctc2.modelo_id = ctc.modelo_id)
            </cfif>
            order by ctc.contrato_id, ctc.tabela_id, ctf.km_inicial
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca vinculos entre equipamentos e contratos
	-- GUTO 03/09/2008
	--->
	<cffunction name="get_contrato_equipamento" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="cod_equipamento" required="no" default="">
    	<cfargument name="situacao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ce.controle_id
                 , c.titulo
                 , ce.equipamento_id
                 , e.cod_equipamento
                 , m.descricao_completa as material
                 , to_char(ce.data_inicio,'dd/mm/yyyy') as data_inicio
                 , to_char(ce.data_termino,'dd/mm/yyyy') as data_termino
              from manutencao.v$contrato_manutencao c
             inner join manutencao.v$contrato_equipamento ce
                     on ce.contrato_id = c.contrato_id
             inner join manutencao.v$equipamento e
                     on e.equipamento_id = ce.equipamento_id
             inner join almoxarifado.v$material m
                     on m.material_id = e.material_id
              where 1=1
              <cfif Len(Trim(arguments.contrato_id))>
                and c.contrato_id = #arguments.contrato_id#
              </cfif>
              <cfif Len(Trim(arguments.cod_equipamento))>
                and e.cod_equipamento = '#arguments.cod_equipamento#'
              </cfif>
              <cfif Len(Trim(arguments.situacao))>
                <cfif arguments.situacao eq 1>
                  and ce.data_termino is null
                <cfelse>
                 and ce.data_termino is not null
                </cfif>
              </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados do fechamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.fechamento_id
                 , f.contrato_id
                 , to_char(f.data_fechamento,'dd/mm/yyyy') as data_fechamento
                 , to_char(f.data_inicial,'dd/mm/yyyy') as data_inicial
                 , to_char(f.data_final,'dd/mm/yyyy') as data_final
                 , nvl(f.valor_acordo,0) valor_acordo
                 , nvl(f.desconto,0) desconto
                 , nvl(f.total_acordo,0) as total_acordo
                 , c.titulo as contrato
                 , to_char(f.data_inicial,'dd/mm/yyyy') || ' at ' || to_char(f.data_final,'dd/mm/yyyy') as periodo
              from manutencao.v$contrato_fechamento f
             inner join manutencao.v$contrato_manutencao c
                on c.contrato_id = f.contrato_id
             where 1=1
             <cfif Len(Trim(arguments.contrato_id))>
			   and f.contrato_id = #arguments.contrato_id#
             </cfif>
             <cfif Len(Trim(arguments.fechamento_id))>
			   and f.fechamento_id = #arguments.fechamento_id#
             </cfif>
             <cfif Len(Trim(arguments.data_inicial))>
			   and f.data_fechamento >= '#arguments.data_inicial#'
             </cfif>
             <cfif Len(Trim(arguments.data_final))>
			   and f.data_fechamento <= '#arguments.data_final#'
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>


	<!---
	-- PROPSITO
	-- Busca dados dos itens fechamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento_it" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fi.fechamento_id
                 , fi.item_id
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(fi.placa) as cod_equipamento
                 , fi.placa
                 , to_char(cf.data_inicial,'dd/mm/yyyy') as data_inicial
                 , to_char(cf.data_final,'dd/mm/yyyy') as data_final
                 , fi.km_inicial
                 , fi.km_final
                 , fi.km_final-fi.km_inicial as km_rodado
                 , fi.tabela_id
                 , fi.num_faixa
                 , fi.valor_km
                 , fi.valor_km * (fi.km_final-fi.km_inicial) as total
                 , cm.titulo as contrato
              from manutencao.v$contrato_fechamento_it fi
             inner join manutencao.v$contrato_fechamento cf
                on cf.fechamento_id = fi.fechamento_id
             inner join manutencao.v$contrato_manutencao cm
                on cm.contrato_id = cf.contrato_id
             where 1=1
             <cfif Len(Trim(arguments.placa))>
			   and fi.placa = '#arguments.placa#'
             </cfif>
             <cfif Len(Trim(arguments.contrato_id))>
			   and cf.contrato_id = #arguments.contrato_id#
             </cfif>
             <cfif Len(Trim(arguments.fechamento_id))>
			   and cf.fechamento_id = #arguments.fechamento_id#
             </cfif>
             <cfif Len(Trim(arguments.data_inicial))>
			   and cf.data_fechamento >= '#arguments.data_inicial#'
             </cfif>
             <cfif Len(Trim(arguments.data_final))>
			   and cf.data_fechamento <= '#arguments.data_final#'
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca dados dos descontos fechamentos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento_desconto" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct fd.controle_id
                 , fd.fechamento_id
                 , fd.num_nota_id
                 , fd.placa
                 , fd.valor_desconto
                 , nf.num_nota_fiscal
                 , nf.emit_razao_social
                 , nf.emit_cnpj_cpf
                 , to_char(nf.data_emissao,'dd/mm/yyyy') as data_emissao
                 , fd.placa
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(fd.placa) as cod_veiculo
              from manutencao.v$contrato_fechamento_desconto fd
              left join fiscal.v$nf_terceiro nf
                on nf.num_nota_id = fd.num_nota_id
              left join fiscal.v$nf_terceiro_rateio nr
                on nr.num_nota_id = nf.num_nota_id
            where 1=1
             <cfif Len(Trim(arguments.fechamento_id))>
			   and fd.fechamento_id = #arguments.fechamento_id#
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca fechamento de manutencao
	-- NOTAS EXPLICATIVAS
	-- IGOR 07/10/2008
	--->
	<cffunction name="get_fechamento_manutencao" returntype="query" access="remote">
		<cfargument name="data_inicial" required="no" default="">
   		<cfargument name="data_final" required="no" default="">
   		<cfargument name="contrato_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select placa, contrato, equipamento_id, cod_equipamento,
                	   to_char(data_final,'dd/mm/yyyy hh24:mi:ss') as data_final,
                       to_char(data_inicial,'dd/mm/yyyy hh24:mi:ss') as data_inicial,
                       tabela_id,
                	   contrato_id, num_faixa, valor_km, sum(km_faixa) as km_rodado, (sum(km_faixa) * valor_km) as total,
                 case
                        when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  alfa_i
                        when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  beta_i
                        when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_i
                        when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_i
                        when alfa_i > beta_i and alfa_i > beta_t then 0
                        when alfa_t < beta_i and alfa_t < beta_t then 0
                        end km_inicial,
                 case
                        when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  beta_t
                        when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t
                        when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_t
                        when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t
                        when alfa_i > beta_i and alfa_i > beta_t then 0
                        when alfa_t < beta_i and alfa_t < beta_t then 0
                        end km_final
              from (select placa, contrato, equipamento_id, cod_equipamento,  contrato_id, alfa_i,
                           alfa_t, beta_i, beta_t, num_faixa, valor_km, data_final, data_inicial, tabela_id,
                         case
                                when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  beta_t - alfa_i
                                when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t - beta_i
                                when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_t - beta_i
                                when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t - alfa_i
                                when alfa_i > beta_i and alfa_i > beta_t then 0
                                when alfa_t < beta_i and alfa_t < beta_t then 0
                                end km_faixa
                            from (
                            select cm.titulo as contrato, e.placa, e.cod_equipamento, ce.equipamento_id,  ct.contrato_id,
                                   t.km_inicial alfa_i, nvl(t.km_final, power(10, 38)) alfa_t,
                                   z.primeiro_km beta_i, z.ultimo_km beta_t, t.num_faixa, t.valor_km, em.data_final, em.data_inicial,
								   t.tabela_id
                             from manutencao.v$contrato_equipamento ce
                            inner join manutencao.v$contrato_manutencao cm
                                            on cm.contrato_id = ce.contrato_id
                            inner join manutencao.v$equipamento_modelo em
                                            on em.equipamento_id = ce.equipamento_id
                            inner join almoxarifado.v$equipamento e
                                            on e.equipamento_id = ce.equipamento_id
                            inner join manutencao.v$contrato_tabela_custo ct
                                            on ct.contrato_id = ce.contrato_id
                                         and ct.modelo_id = em.modelo_id
                            inner join manutencao.v$contrato_tabela_faixa t
                                            on t.tabela_id = ct.tabela_id
                            inner join (
                            			  select y.placa, ultimo_km, primeiro_km, max(dt) as data_final, min(dta) as data_inicial
                                            from (select x.placa, x.dt, x.km, x.dta, x.kma,
                                                         last_value(x.km) over (partition by x.placa) ultimo_km, first_value(x.kma) over (partition by x.placa) primeiro_km
                                                    from (select t.placa, t.data_hora dt,t.km,
                                                                 lag(t.data_hora, 1,(select nvl(max(i.data_hora), to_date('#arguments.data_inicial#','dd/mm/yyyy'))
                                                            from oper.v$veiculo_km i
                                                           where 1=1
                                                             and i.data_hora < to_date('#arguments.data_inicial#','dd/mm/yyyy')
                                                             and i.placa = t.placa)) over (partition by t.placa order by t.data_hora) dta,
                                                                 lag(t.km, 1, (select z.km
                                                                                 from oper.v$veiculo_km z
                                                                                where z.data_hora = (select nvl(max(i.data_hora), to_date('#arguments.data_inicial#','dd/mm/yyyy'))
                                                                                                                             from oper.v$veiculo_km i
                                                                                                                            where 1=1
                                                                                                                                and i.data_hora < to_date('#arguments.data_inicial#','dd/mm/yyyy')
                                                                                                                                and i.placa = t.placa)
                                                                                    and z.placa = t.placa)) over (partition by t.placa order by t.data_hora) kma
                                                                            from oper.v$veiculo_km t
                                                                         inner join oper.v$veiculo_proprietario vp
                                                                                         on vp.placa = t.placa
                                                                                        and t.data_hora between vp.data_inicio and nvl(vp.data_fim,sysdate)
                                                                            where 1=1
                                                                                     and trunc(t.data_hora) between to_date('#arguments.data_inicial#','dd/mm/yyyy') and to_date('#arguments.data_final#','dd/mm/yyyy'))x
                                                                                     ) y
                            group by y.placa, ultimo_km, primeiro_km) z
                            on z.placa = e.PLACA
                            )
                            <cfif Len(Trim(arguments.contrato_id))>
                            	where contrato_id = #arguments.contrato_id#
                            </cfif>
                            order by placa, alfa_i
            )
            where km_faixa > 0
            group by placa, contrato, equipamento_id, cod_equipamento, contrato_id, tabela_id, num_faixa, valor_km, alfa_i, alfa_t, beta_i, beta_t,
					data_final, data_inicial
            order by cod_equipamento
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Nota fiscal de terceiro e Ordem de Compra
	-- GUTO  20/12/2006
	--->
	<cffunction name="get_nf_terceiro" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nf.num_nota_id
                 , nf.num_nota_fiscal
                 , nfpi.valor_utilizado
                 , p.identificador as cnpj_oficina
                 , p.razao_social as razao_social_oficina
                 , p.cliente as nome_fantasia_oficina
                 , p.cod_pessoa as cod_pessoa_oficina
                 , nf.calc_valor_total_nota
                 , sp.equipamento as frota
			  from fiscal.v$nf_terceiro nf
			 inner join kss.v$pessoa p
 				on p.cod_pessoa = nf.cod_emitente
 		     inner join fiscal.v$nf_terceiro_pedido_item nfpi
                on nfpi.num_nota_id = nf.num_nota_id
             inner join compras.v$solicitacao_pedido sp
                on sp.pedido_id = nfpi.pedido_id
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca servicos vencidos ou a vencer para a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_veiculo_atividade" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="nao_executada" required="no" default="">
		<cfargument name="km" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.PLACA, equipamento_id = arguments.EQUIPAMENTO_ID)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.equipamento_id, r.controle_id, r.cod_equipamento, r.atividade_id, r.posicao_id, r.posicao, r.cod_atividade,
				   r.titulo, r.data_previsao, r.km_previsao, r.importancia, r.alerta_km,
				   r.alerta_dias, r.dias,
			       manutencao.to_veiculo_km(r.cod_equipamento,r.data_previsao,r.data_previsao).km_data_inicial km_real,
					   case
						  when r.ordem_servico_id_execucao is null
						   and (
                               (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and manutencao.to_manut_atividade(r.atividade_id).garantia_km > 0)
							   <cfif Len(Trim(arguments.km))>
							   or (r.km_previsao < #arguments.km# and manutencao.to_manut_atividade(r.atividade_id).garantia_km > 0)
							   </cfif>
							   or (sysdate > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id).garantia_dias > 0)) then 'Vencido'
						  when r.ordem_servico_id_execucao is null
						   and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_atividade(r.atividade_id).alerta_km > r.km_previsao and manutencao.to_manut_atividade(r.atividade_id).garantia_km > 0)
							   or (sysdate + manutencao.to_manut_atividade(r.atividade_id).alerta_dias > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id).garantia_dias > 0)) then 'A Vencer'
						  when r.ordem_servico_id_execucao is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 'Ok'
					   else 'Executada' end status,
					   case
						  when r.ordem_servico_id_execucao is null
						   and (
                               (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and manutencao.to_manut_atividade(r.atividade_id).garantia_km > 0)
							   <cfif Len(Trim(arguments.km))>
							   or (r.km_previsao < #arguments.km# and manutencao.to_manut_atividade(r.atividade_id).garantia_km > 0)
							   </cfif>
							   or (sysdate > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id).garantia_dias > 0)) then -2
						  when r.ordem_servico_id_execucao is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_atividade(r.atividade_id).alerta_km > r.km_previsao
							   or (sysdate + manutencao.to_manut_atividade(r.atividade_id).alerta_dias > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id).garantia_dias > 0)) then -1
						  when r.ordem_servico_id_execucao is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 1
					   else 0 end status_id,
					   r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto
			  from (
						select /*+ ORDERED */ e.equipamento_id, ea.controle_id, e.cod_equipamento, a.atividade_id, ap.posicao_id, nvl(ap.posicao, 'nica') as posicao,
						   a.cod_atividade, a.titulo, ea.data_previsao, ea.km_previsao,
						   a.importancia, ea.ordem_servico_id_execucao,
								   manutencao.to_manut_atividade(ea.atividade_id).alerta_km as alerta_km,
								   manutencao.to_manut_atividade(ea.atividade_id).alerta_dias as alerta_dias,
								   decode(manutencao.to_manut_atividade(ea.atividade_id).garantia_dias,0,0,round(ea.data_previsao - sysdate)) as dias
							  from manutencao.v$equipamento_atividade ea
							 inner join manutencao.v$atividade a
									 on a.atividade_id = ea.atividade_id
							 inner join almoxarifado.v$equipamento e
									 on e.equipamento_id = ea.equipamento_id
							 left join manutencao.v$equipamento_posicao ap
									 on ea.posicao_id = ap.posicao_id
							 where 1=1
							  <cfif Len(Trim(arguments.nao_executada))>
							   and ea.ordem_servico_id_execucao is null
							   and a.verificacao = 0
							  </cfif>
							  <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
							   and e.equipamento_id in (#v_composicao#)
							  </cfif>
							  <cfif Len(Trim(arguments.atividade_id))>
							   and a.atividade_id = #arguments.atividade_id#
							  </cfif>
						 ) r
			  order by r.cod_equipamento, r.posicao, r.km_previsao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais com a garantia vencida para a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_veiculo_material" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfargument name="km_atual" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.equipamento_id, r.cod_equipamento, r.controle_id, r.material_id, r.posicao,
				   r.cod_material, r.material, r.data_previsao, r.km_previsao,
				   r.alerta_km, r.alerta_dias, r.dias, r.ordem_servico_id_desmontagem,
					   case
						  when r.km_previsao = 0 then 'Ok'
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
							   or sysdate > r.data_previsao) then 'Vencido'
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(r.material_id).alerta_km > r.km_previsao
							   or sysdate + manutencao.to_manut_material(r.material_id).alerta_dias > r.data_previsao) then 'A Vencer'
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 'Ok'
					   else 'Executada' end status,
					   case
						  when r.km_previsao = 0 then 1
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
							   or sysdate > r.data_previsao) then -2
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(r.material_id).alerta_km > r.km_previsao
							   or sysdate + manutencao.to_manut_material(r.material_id).alerta_dias > r.data_previsao) then -1
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 1
					   else 0 end status_id,
					   r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto,
						cod_equipamento_identificado
			  from (select e.equipamento_id, e.cod_equipamento, em.controle_id, nvl(ap.posicao, 'nica') as posicao,
						   		m.material_id, m.cod_material, m.material, em.data_previsao, em.km_previsao,
								   manutencao.to_manut_material(em.material_id).alerta_km as alerta_km,
								   manutencao.to_manut_material(em.material_id).alerta_dias as alerta_dias,
								   round(sysdate - em.data_previsao) as dias, em.ordem_servico_id_desmontagem,
									mp.cod_equipamento as cod_equipamento_identificado
						  from manutencao.v$equipamento_material em
						 inner join almoxarifado.v$material_dados m
									 on m.material_id = em.material_id
						 inner join almoxarifado.v$equipamento e
									 on e.equipamento_id = em.equipamento_id
						  left join manutencao.v$equipamento_posicao ap
								   on em.posicao_id = ap.posicao_id
						  left join almoxarifado.v$equipamento mp
						         on mp.equipamento_id = em.equipamento_id_identificado
						 where em.ordem_servico_id_desmontagem is null
						 <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
						   and e.equipamento_id in (#v_composicao#)
						 </cfif>
						 ) r
			 where 1=1
			  order by r.cod_equipamento, r.posicao, r.data_previsao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca solicitaes enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/10/2006
	--->
	<cffunction name="get_equipamento_solicitacao" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="abertas" required="no" default="1">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select /*+ first_rows */ e.cod_equipamento
                  , ms.solicitacao_id
                  , ms.equipamento_id
                  , to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao
                  , ms.texto
                  , ms.atendida
                  , ms.ordem_servico_id_execucao
                  , ms.user_insert
                  , ms.date_insert
                  , (select cod_pessoa
          			   from oper.v$veiculo_motorista vm
         			  where vm.placa = e.cod_equipamento
           				and vm.data_inicio = (select max(vm2.data_inicio)
                                   				from oper.v$veiculo_motorista vm2
                                  			   where vm.placa = e.cod_equipamento)) as cod_pessoa_motorista
                  , oper.pkg_global.fnc_busca_nome_pessoa((select cod_pessoa
                                                			 from oper.v$veiculo_motorista vm
                                              				where vm.placa = e.cod_equipamento
                                                			  and vm.data_inicio = (select max(vm2.data_inicio)
                                                                        			  from oper.v$veiculo_motorista vm2
                                                                       				 where vm.placa = e.cod_equipamento))) as motorista
			   from manutencao.v$equipamento_solicitacao ms
			  inner join almoxarifado.v$equipamento e
			     on e.equipamento_id = ms.equipamento_id
  			  where 1=1
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and ms.equipamento_id = #arguments.equipamento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.placa))>
			 	and ms.equipamento_id in (#v_composicao#)
			  </cfif>

  			  <cfif Len(Trim(arguments.abertas)) eq 1>
			 	and ms.ordem_servico_id_execucao is null
			  </cfif>
			  order by ms.data_solicitacao desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuteno vincculadas a um veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/10/2006
	--->
	<cffunction name="get_equipamento_tabela" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select r.equipamento_id, r.cod_equipamento, r.nome as tabela, r.obrigatoria,
               r.data_previsao, r.km_previsao, r.ordem_servico_id_execucao,
               nvl(r.controle_id, to_number(r.tabela_id||r.equipamento_id)) as identificador,
               r.controle_id, r.tabela_id, r.atualiza_revisao,
               r.dias_previsto, r.alerta_km, r.alerta_dias,
               nvl(manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial,0) as km_atual,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then 'Sem execuo'
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 'Executada'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then 'Vencida'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then 'A vencer'
                 else 'OK' end status,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then -3
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 0
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then -2
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then -1
                 else 1 end status_id,
                     r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto
            from (select e.equipamento_id, e.cod_equipamento, t.nome,
                   t.obrigatoria, t.tabela_id, et.data_previsao, et.km_previsao,
                   et.ordem_servico_id_execucao, et.controle_id ,
                   round(sysdate - et.data_previsao) as dias_previsto,
                   manutencao.to_manut_tabela(et.tabela_id).alerta_km as alerta_km,
                   manutencao.to_manut_tabela(et.tabela_id).alerta_dias as alerta_dias,
                               t.atualiza_revisao
                from almoxarifado.v$equipamento e
               inner join manutencao.v$equipamento_tabela_manut et
                   on et.equipamento_id = e.equipamento_id
               inner join manutencao.v$tabela_manutencao t
                   on et.tabela_id = t.tabela_id
               where e.equipamento_id in (#v_composicao#)
                 and (t.intervalo_km <> 0 or t.intervalo_dias <> 0 or t.intervalo_horas_trabalhadas <> 0 or t.intervalo_lts_combustivel <> 0)) r
            where 1=1
                and r.ordem_servico_id_execucao  is null
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and r.equipamento_id = #arguments.equipamento_id#
			  </cfif>
        union
          select r.equipamento_id, r.cod_equipamento, r.nome as tabela, r.obrigatoria,
               r.data_previsao, r.km_previsao, r.ordem_servico_id_execucao,
               nvl(r.controle_id, to_number(r.tabela_id||r.equipamento_id)) as identificador,
               r.controle_id, r.tabela_id, r.atualiza_revisao,
               r.dias_previsto, r.alerta_km, r.alerta_dias,
               manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_atual,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then 'Sem execuo'
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 'Executada'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then 'Vencida'
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then 'A vencer'
                 else 'OK' end status,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then -3
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 0
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                    or sysdate > r.data_previsao) then -2
                 when r.ordem_servico_id_execucao is null
                  and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao
                    or sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao) then -1
                 else 1 end status_id,
                     r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto
            from (select e.equipamento_id, e.cod_equipamento, t.nome,
                   t.obrigatoria, t.tabela_id, null as data_previsao, null as km_previsao,
                   null as ordem_servico_id_execucao, null as controle_id ,
                   null as dias_previsto,
                   manutencao.to_manut_tabela(tm.tabela_id).alerta_km as alerta_km,
                   manutencao.to_manut_tabela(tm.tabela_id).alerta_dias as alerta_dias,
                               t.atualiza_revisao
                from almoxarifado.v$equipamento e
               inner join manutencao.v$equipamento_modelo em
                   on em.equipamento_id = e.equipamento_id
                   and em.data_final is null
               inner join manutencao.v$tabela_modelo tm
                   on tm.modelo_id = em.modelo_id
               inner join manutencao.v$tabela_manutencao t
                   on t.tabela_id = tm.tabela_id
               where e.equipamento_id in (#v_composicao#)
                   and not exists (select 1
                                       from manutencao.v$equipamento_tabela_manut et
                          where et.equipamento_id = e.equipamento_id
                            and et.tabela_id = t.tabela_id
                                                            and et.ordem_servico_id_execucao  is null)) r
            where 1=1
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and r.equipamento_id = #arguments.equipamento_id#
			  </cfif>
			  order by km_previsto

 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna o KM baseado o parametro de limite de revisao
	-- Se o KM limite for negativo no ser permitida a incluso de tabelas que atualizam reviso
	-- Se o KM estiver positivo a reviso pode ser executada
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/07/2007
	--->
	<cffunction name="get_permite_revisao" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfargument name="km_veiculo" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (#arguments.km_veiculo# - (rf.revisao_km + vc.km_revisao - to_number(kss.pkg_global.fnc_parametro_num(11,'OPERACIONAL',18,4)))) as km_limite
              from oper.v$rank_frota rf
		     inner join oper.v$veiculo_controle vc
                on vc.placa = rf.placa_controle
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and rf.placa_controle = '#arguments.placa#'
            </cfif>
            <cfif Len(Trim(arguments.equipamento_id))>
               and rf.placa_controle = (select e.placa
                                          from almoxarifado.v$equipamento e
                                         where e.equipamento_id = #arguments.equipamento_id#)
            </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de Solicitao
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 15/12/2009
	--->
	<cffunction name="get_solicitacao_equip_tipo" returntype="query" access="remote">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="controle_trafego" required="no" default="">
        <cfargument name="bloqueia_veiculo" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select est.tipo_id
                 , est.descricao
                 , est.dados_adicionais
                 , est.nivel_importancia
                 , est.controle_trafego
                 , decode(est.controle_trafego, 0,'No','Sim') as controle_trafego_descricao
                 , est.bloqueia_veiculo
                 , decode(est.bloqueia_veiculo, 0,'No','Sim') as bloqueia_veiculo_descricao
                 , est.lista_email
              from manutencao.v$equipamento_solicitacao_tipo est
             where 1 = 1
        	<cfif Len(Trim(arguments.descricao))>
              and upper(est.descricao) like upper('%#arguments.descricao#%')
        	</cfif>
            <cfif Len(Trim(arguments.controle_trafego))>
              and est.controle_trafego = #arguments.controle_trafego#
        	</cfif>
            <cfif Len(Trim(arguments.bloqueia_veiculo))>
              and est.bloqueia_veiculo = #arguments.bloqueia_veiculo#
        	</cfif>
            <cfif Len(Trim(arguments.tipo_id))>
              and est.tipo_id = #arguments.tipo_id#
        	</cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os proprietarios dos equipamentos
	-- NOTAS EXPLICATIVAS
	-- WAGNER 29/12/2006
	--->
	<cffunction name="get_proprietario_equipamento" returntype="query" access="remote">
		<cfargument name="EQUIPAMENTO_ID" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select t.cod_pessoa_proprietario, p.cliente as nome
               from almoxarifado.equipamento_proprietario t
              inner join kss.v$pessoa p
                      on p.cod_pessoa = t.cod_pessoa_proprietario
     	      where t.equipamento_id = #arguments.equipamento_id#
			    and t.date_fim is null
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca km atual do veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_km_atual" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="data" required="no" default="">
        <cfif Len(Trim(arguments.data))>
        	<cfset v_data = "to_date('#arguments.data#', 'dd/mm/yyyy hh24:mi')">
        <cfelse>
        	<cfset v_data = "sysdate">
        </cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select manutencao.to_veiculo_km(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'), #PreserveSingleQuotes(v_data)#, #PreserveSingleQuotes(v_data)#).km_data_inicial as km_atual,
			       manutencao.to_equipamento_dados(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'), #PreserveSingleQuotes(v_data)#).equipamento_id as equipamento_id
			  from dual
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Busca as ordens de servios de um equipamento
    -- ANDERSON 11/09/2009 - CRIADO
    --->
    <cffunction name="get_os_equipamento" access="remote" returntype="query" output="true">
    	<cfargument name="equipamento_id" required="yes">
        <cfargument name="ordem_servico_id" required="no" default="" hint="Busca as ordens de servio exceto esta">
        <cfargument name="num_ordem_servico" required="no" default="">
        <cfargument name="empresa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select os.ordem_servico_id
                 , os.num_ordem_servico
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
                 , kss.pkg_pessoa.fnc_get_cliente(os.cod_pessoa_oficina, 1) as oficina
              from manutencao.v$ordem_servico os
             where os.equipamento_id = #arguments.equipamento_id#
			<cfif Len(Trim(arguments.ordem_servico_id))>
               and os.ordem_servico_id <> #arguments.ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.num_ordem_servico))>
               and os.num_ordem_servico like '#arguments.num_ordem_servico#%'
            </cfif>
            <cfif Len(Trim(arguments.empresa))>
               and os.empresa = #arguments.empresa#
            </cfif>
             order by os.num_ordem_servico asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca as ordens de servio
	-- ANDERSON 30/11/2009 - CRIADO
	--->
	<cffunction name="get_ordens_servico" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_pessoa_oficina" required="no" default="">
		<cfargument name="abertas" required="no" default="1">
		<cfargument name="check_list" required="no" default="0">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="status" required="no" default="">
		<cfargument name="socorro" required="no" default="0">
        <cfargument name="tipo_ordem_servico_id" required="no" default="">
        <cfargument name="ordem_servico_id_lista" required="no" default="">
        <cfargument name="ordem" required="no" default="">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select /*+ ORDERED*/ os.ordem_servico_id
                 , os.num_ordem_servico
                 , os.empresa
                 , os.equipamento_id
                 , e.material_id
                 , e.cod_equipamento
                 , e.placa
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(e.placa) as cod_veiculo
                 , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
                 , os.cod_pessoa_responsavel
                 , oper.pkg_global.fnc_get_cod_funcionario(os.cod_pessoa_responsavel) as cod_funcionario
                 , oper.pkg_global.fnc_busca_nome_pessoa(os.cod_pessoa_responsavel) as responsavel
                 , os.cod_pessoa_oficina
                 , p.cnpj_cpf as cnpj_oficina
                 , p.identificador as identificador_oficina
                 , p.razao_social as razao_social_oficina
                 , p.cliente as oficina
                 , os.km_rodado
                 , os.observacao
                 , to_char(os.data_previsao_liberacao, 'dd/mm/yyyy hh24:mi') as data_previsao_liberacao
                 , case
                      when to_number((nvl(os.data_fechamento, sysdate) - os.data_abertura)) > 100 then
                         'Mais de 100 dias'
                      else
                         to_char(manutencao.to_tempo_execucao(numtodsinterval(to_number((nvl(os.data_fechamento, sysdate) - os.data_abertura)), 'DAY'), 2).retorno)
                   end as tempo_aberto
                 , case
                      when os.data_fechamento is null then
                         almoxarifado.to_ponto(e.cod_equipamento, sysdate).landmark
                      when os.data_fechamento is not null then
                         'OS Finalizada'
                   end posicao_atual
                 , to_char(os.data_saida, 'dd/mm/yyyy hh24:mi') as data_saida
                 , to_char(os.data_chegada, 'dd/mm/yyyy hh24:mi') as data_chegada
                 , to_char(os.data_atendimento, 'dd/mm/yyyy hh24:mi') as data_atendimento
                 , to_char(os.data_fechamento, 'dd/mm/yyyy hh24:mi') as data_fechamento
                 , os.log_alteracoes
                 , (select oser.valor_servico
                      from manutencao.v$ordem_servico oser
                     where oser.ordem_servico_id = os.ordem_servico_id) as valor_servico
                 , os.socorro
                 , nft.num_nota_fiscal
                 , os.ordem_servico_id_vinculo
                 , (select oser.num_ordem_servico
                      from manutencao.v$ordem_servico oser
                     where oser.ordem_servico_id = os.ordem_servico_id_vinculo) as num_ordem_servico_vinculo
                 , (select to_char(oser.data_abertura, 'dd/mm/yyyy hh24:mi')
                      from manutencao.v$ordem_servico oser
                     where oser.ordem_servico_id = os.ordem_servico_id_vinculo) as data_abertura_os_vinculo
                 , os.tipo_ordem_servico_id
                 , (select tos.descricao
                      from manutencao.v$tipo_ordem_servico tos
                     where tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id) as tipo_ordem_servico
                 /*, os.km_abertura */
                 , (select oser.valor_servico_fechamento + oser.valor_materiais_fechamento
                      from manutencao.v$ordem_servico oser
                     where oser.ordem_servico_id = os.ordem_servico_id) as valor_total_os
                 , nvl((select ccl.valor_lancamento
                          from manutencao.v$ordem_servico oser
                    inner join finan.v$ccorrente_lancamento ccl
                            on ccl.num_lancamento = oser.num_lancamento
                         where oser.ordem_servico_id = os.ordem_servico_id), 0) as valor_lancto
                 , os.km_abertura
                 , (select s.num_controle
                      from compras.v$solicitacao s
                      where s.solicitacao_id = os.solicitacao_compra_id) as solicitacao_compra
              from manutencao.v$ordem_servico_dados os
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_oficina
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
              left join fiscal.v$nf_terceiro nft
                     on nft.num_nota_id = os.num_nota_id
             where 1 = 1
			<cfif Len(Trim(arguments.cod_equipamento))>
			   and e.cod_equipamento = '#arguments.cod_equipamento#'
			</cfif>
			<cfif Len(Trim(arguments.ordem_servico_id))>
               and os.ordem_servico_id = #arguments.ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.ordem_servico_id_lista))>
               and os.ordem_servico_id in (#arguments.ordem_servico_id_lista#)
            </cfif>
            <cfif arguments.socorro neq -1>
               and os.socorro = #arguments.socorro#
            </cfif>
            <cfif arguments.abertas eq 1>
               and os.data_fechamento is null
            </cfif>
			<cfif arguments.check_list eq 1>
               and exists (select 'x'
                             from manutencao.v$os_atividade oa
                            inner join manutencao.v$atividade a
                                    on a.atividade_id = oa.atividade_id
                            where oa.ordem_servico_id = os.ordem_servico_id
                              and a.verificacao = 1
                              and oa.executada = 0)
            </cfif>
			<cfif Len(Trim(arguments.cod_pessoa_oficina))>
               and os.cod_pessoa_oficina = #arguments.cod_pessoa_oficina#
            </cfif>
            <cfif Len(Trim(arguments.empresa)) and (arguments.empresa eq 1)>
               and os.empresa = #arguments.empresa#
            </cfif>
            <cfif Len(Trim(arguments.num_ordem_servico))>
               and os.num_ordem_servico = #arguments.num_ordem_servico#
            </cfif>
            <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final)) >
               and os.data_abertura between '#LSDateFormat(arguments.data_inicial)#' and '#LSDateFormat(arguments.data_final)# 23:59:59'
            </cfif>
            <cfif Len(Trim(arguments.status)) and arguments.status eq 0>
               and os.data_fechamento is null
            </cfif>
            <cfif Len(Trim(arguments.status)) and arguments.status eq 1>
               and os.data_fechamento is not null
            </cfif>
            <cfif Len(Trim(arguments.tipo_ordem_servico_id))>
               and os.tipo_ordem_servico_id = #arguments.tipo_ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.equipamento_id)) or Len(Trim(arguments.placa))>
               and os.equipamento_id in (#v_composicao#)
             order by instr('#v_composicao#', to_char(os.equipamento_id)), os.data_abertura desc
            <cfelseif len(trim(arguments.ordem)) >
            	order by #arguments.ordem#
            <cfelse>
             order by os.cod_pessoa_responsavel, os.tipo_ordem_servico_id, os.cod_pessoa_oficina, os.data_abertura desc
            </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca composicao
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_composicao" returntype="string" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select
			       <cfif Len(Trim(arguments.PLACA))>
				   manutencao.to_equipamento_dados('#arguments.PLACA#',sysdate).composicao as composicao
				   </cfif>
			       <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
				   manutencao.to_equipamento_dados(#arguments.EQUIPAMENTO_ID#,sysdate).composicao as composicao
				   </cfif>
			  from dual
		</cfquery>
		<cfreturn qr_result.composicao>
	</cffunction>


    <!---                                                                                              REMOVER
	-- PROPSITO
	-- Busca atividades da ordem de compra
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/02/2007
	--->
	<cffunction name="get_ordem_compra_atividade" returntype="query" access="remote">
		<cfargument name="NUM_ORDEM_COMPRA" required="no" default="" >
		<cfargument name="NF_TERCEIRO_ID" required="no" default="" >
		<cfargument name="EQUIPAMENTO_ID" required="no" default="" >
		<cfargument name="COD_EQUIPAMENTO" required="no" default="" >
		<cfargument name="ABERTAS" required="no" default="0" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ea.controle_id, ea.equipamento_id, ea.atividade_id, ag.descricao as grupo,
                   ea.posicao_id, ea.num_ordem_compra, ea.ordem_servico_id_execucao,
                   e.cod_equipamento, a.titulo, ep.posicao,
                   oc.data_emissao, oc.cod_pessoa_autorizacao, p.cliente as responsavel,
                   fr.identificador as cnpj_fornecedor,
                   oc.num_controle, fr.cliente as fornecedor, a.cod_atividade,
                   nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) + sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                          from manutencao.v$os_ordem_compra ooc
                         where ooc.num_controle = oc.num_controle),0) as total_utilizado_os
                from manutencao.v$equipamento_atividade_oc ea
               inner join manutencao.v$ordem_compra oc
                   on oc.num_controle = ea.num_ordem_compra
               inner join kss.v$pessoa p
                   on p.cod_pessoa = oc.cod_pessoa_autorizacao
               inner join kss.v$pessoa fr
                   on fr.cod_pessoa = oc.cod_pessoa_fornecedor
               inner join almoxarifado.v$equipamento e
                   on e.equipamento_id = ea.equipamento_id
               inner join manutencao.v$atividade a
                      on a.atividade_id = ea.atividade_id
               inner join manutencao.v$atividade_grupo ag
                       on ag.grupo_id = a.grupo_id
                left join manutencao.v$equipamento_posicao ep
                   on ep.posicao_id = ea.posicao_id
			  where 1=1
				<cfif len(Trim(arguments.COD_EQUIPAMENTO))>
				  and e.COD_EQUIPAMENTO = '#arguments.COD_EQUIPAMENTO#'
				</cfif>
				<cfif len(Trim(arguments.EQUIPAMENTO_ID))>
				  and ea.equipamento_id = #arguments.EQUIPAMENTO_ID#
				</cfif>
				<cfif len(Trim(arguments.NUM_ORDEM_COMPRA))>
				  and ea.num_ordem_compra = #arguments.NUM_ORDEM_COMPRA#
				</cfif>
				<cfif arguments.ABERTAS eq 1>
				  and ea.ordem_servico_id_execucao is null
				</cfif>
                order by grupo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    <!---                                                                                              REMOVER                                                                             	--->

    <!---
	-- PROPSITO
	-- Busca todos os processos da OS
	-- NOTAS EXPLICATIVAS
	-- arlen 16/10/2006
	--->
	<cffunction name="get_os_processos_atividades" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select /*+ ORDERED*/ tipo
                     , ordem_servico_id
                     , equipamento_id
                     , cod_equipamento
                     , num_ordem_servico
                     , grupo_id
                     , grupo
                     , compartimento_id
                     , compartimento
                     , posicao_id
                     , nvl(posicao, 'nica') as posicao
                     , atividade
                     , nvl(processo,atividade) as processo
                     , controle_id_processo
                     , controle_id_atividade
                     , executada
                     , execucao_id
                     , cod_pessoa_principal
                     , oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa_principal) as principal
                     , cod_pessoa_auxiliar
                     , oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa_auxiliar) as auxiliar
                     , data_inicio
                     , data_termino
                     , tempo_estimado
                     , tempo_execucao
                from (select 2 as tipo
                           , os.ordem_servico_id
                           , e.equipamento_id
                           , e.cod_equipamento
                           , os.num_ordem_servico
                           , a.grupo_id
                           , ag.descricao as grupo
                           , a.compartimento_id
                           , ac.descricao as compartimento
                           , ep.posicao_id
                           , ep.posicao
                           , manutencao.to_tempo_execucao(p.tempo_execucao).retorno as tempo_estimado
                           , a.titulo as atividade
                           , p.titulo as processo
                           , op.controle_id as controle_id_processo
                           , oa.controle_id as controle_id_atividade
                           , opa.executado as executada
                           , ope.execucao_id
                           , ope.cod_pessoa_principal
                           , ope.cod_pessoa_auxiliar
                           , ope.data_inicio
                           , ope.data_termino
                           , manutencao.to_tempo_execucao(numtodsInterval(nvl(ope.data_termino,sysdate) - ope.data_inicio,'DAY')).retorno as tempo_execucao
                        from manutencao.v$ordem_servico os
                       inner join almoxarifado.v$equipamento e
                          on e.equipamento_id = os.equipamento_id
                       inner join manutencao.v$os_atividade oa
                          on oa.ordem_servico_id = os.ordem_servico_id
                       inner join manutencao.v$atividade a
                          on a.atividade_id = oa.atividade_id
                        left join manutencao.v$atividade_compartimento ac
                          on ac.compartimento_id = a.compartimento_id
                        left join manutencao.v$atividade_grupo ag
                          on ag.grupo_id = a.grupo_id
                       inner join manutencao.v$os_processo_atividade opa
                          on opa.controle_id_atividade = oa.controle_id
                       inner join manutencao.v$os_processos op
                          on op.controle_id = opa.controle_id_processo
                       inner join manutencao.v$processo p
                          on p.processo_id = op.processo_id
                        left join manutencao.v$os_processo_execucao ope
                          on ope.controle_id = op.controle_id
                        left join manutencao.v$equipamento_posicao ep
                          on ep.posicao_id = oa.posicao_id
                       where os.data_fechamento is null)
			   where 1=1
			<cfif Len(Trim(arguments.ordem_servico_id))>
				 and ordem_servico_id = #arguments.ordem_servico_id#
			</cfif>
			<cfif IsDefined("v_composicao")>
				 and equipamento_id in (#v_composicao#)
			</cfif>
		    order by ordem_servico_id, compartimento, grupo, posicao, data_inicio
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca processos da OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_processos" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">
		<cfargument name="execucao_id" required="no" default="">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select os.ordem_servico_id
                     , oa.controle_id as controle_id_atividade
                     , oa.atividade_id
                     , a.titulo as atividade
                     , nvl(p.titulo,a.titulo) as processo
                     , opa.CONTROLE_ID_PROCESSO
                     , case
                          when oa.gerada_por = 1 then 'Sistema'
                          when oa.gerada_por = 2 then 'Solicitao Mot.'
                          else 'Check List' end gerada_por, oa.executada
                     , manutencao.to_tempo_execucao(nvl(oa.tempo_execucao_oficina,numtodsinterval(0,'DAY'))).retorno as tempo_execucao
                     , oa.date_insert
                     , p.processo_id
                     , nvl(ope.data_inicio,sysdate) as date_inicio
                     , nvl(ep.posicao,'nica') as posicao
                     , ope.execucao_id
                     , ope.cod_pessoa_principal
                     , oper.pkg_global.fnc_busca_nome_pessoa(ope.cod_pessoa_principal) as principal
                     , ope.cod_pessoa_auxiliar
                     , oper.pkg_global.fnc_busca_nome_pessoa(ope.cod_pessoa_auxiliar) as auxiliar
                     , to_char( nvl(ope.data_inicio, sysdate) , 'dd/mm/yyyy hh24:MM') as data_formatada
				  from manutencao.v$ordem_servico os
				 inner join manutencao.v$os_atividade oa
				    on oa.ordem_servico_id = os.ordem_servico_id
				 inner join manutencao.v$atividade a
					on a.atividade_id = oa.atividade_id
				 inner join manutencao.v$os_processo_atividade opa
					on opa.controle_id_atividade = oa.controle_id
				 inner join manutencao.v$os_processos op
					on op.controle_id = opa.controle_id_processo
				 inner join manutencao.v$processo p
					on p.processo_id = op.processo_id
				  left join manutencao.v$equipamento_posicao ep
					on ep.posicao_id = oa.posicao_id
				  left join manutencao.v$os_processo_execucao ope
					on ope.controle_id = op.controle_id
				 where 1=1
				<cfif Len(Trim(arguments.ordem_servico_id))>
				   and os.ordem_servico_id = #arguments.ordem_servico_id#
				</cfif>
				<cfif Len(Trim(arguments.controle_id))>

				   and op.controle_id = #arguments.controle_id#
				   and (ope.execucao_id = (select max(ope2.execucao_id)
					                          from manutencao.v$os_processo_execucao ope2
											 where ope2.controle_id = op.controle_id)
										or (select max(ope2.execucao_id)
					                          from manutencao.v$os_processo_execucao ope2
											where ope2.controle_id = op.controle_id) is null)
				</cfif>
				<cfif Len(Trim(arguments.execucao_id))>
					and ope.execucao_id = #arguments.execucao_id#
				</cfif>
			order by oa.date_insert, op.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais usados na OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_materiais" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select os.ordem_servico_id
                 , om.controle_id
                 , om.material_id
                 , om.cod_pessoa_retirada
                 , p.cliente as responsavel
                 , m.material
                 , e.cod_equipamento
                 , nvl(ep.posicao,'nica') as posicao
                 , nvl(om.posicao_id, '-1') as posicao_id
                 , er.cod_equipamento as cod_equipamento_retirado
                 , om.quantidade
                 , manutencao.to_os_material(om.controle_id).atividade_ok as atividade_ok
                 , m.unidade_estoque
                 , om.valor_unitario
                 , mr.descricao_completa as material_retirado
                 , om.observacao
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(om.material_id, 9) as cod_genuino
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(om.material_id, 10) as cod_fabricante
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(om.material_id, 11) as cod_paralelo
                 , m.identificado
                 , om.valor_total
			  from manutencao.v$ordem_servico os
			 inner join manutencao.v$os_material om
			    on om.ordem_servico_id = os.ordem_servico_id
			 inner join almoxarifado.v$material_dados m
				on m.material_id = om.material_id
			 inner join almoxarifado.v$material_dados mr
				on mr.material_id = om.material_id_retirado
		      left join kss.v$pessoa p
			    on p.cod_pessoa = om.cod_pessoa_retirada
              left join almoxarifado.v$equipamento e
				on e.equipamento_id = om.equipamento_id
			  left join manutencao.v$equipamento_posicao ep
				on ep.posicao_id = om.posicao_id
			  left join almoxarifado.v$equipamento er
				on er.equipamento_id = om.equipamento_id_retirado
			 where 1=1
			   and os.ordem_servico_id = #arguments.ordem_servico_id#
		  order by om.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamento montado
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_equipamento_montado" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="yes">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.equipamento_id
                 , e.cod_equipamento
                 , e.material_id
                 , md.material
              from almoxarifado.v$equipamento  e
			 inner join manutencao.v$equipamento_material em
				on em.equipamento_id_identificado = e.equipamento_id
			   and em.ordem_servico_id_desmontagem is null
		     inner join almoxarifado.v$material_dados md
			    on md.material_id = e.material_id
			 where 1=1
			   and em.equipamento_id = #arguments.equipamento_id#
			<cfif Len(Trim(arguments.material_id))>
			   and e.material_id = #arguments.material_id#
			</cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamentos no estoque
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/09/2006
	--->
	<cffunction name="get_equipamentos_estoque" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="transferencia" required="no" default="0"/>
		<cfargument name="cod_equipamento" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.cod_equipamento
                 , e.equipamento_id
                 , max(el.data_entrada) data_entrada
                 , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
			  from almoxarifado.v$equipamento e
			 inner join almoxarifado.v$equipamento_localizacao el
				on el.equipamento_id = e.equipamento_id
			 where el.data_saida is null
               and e.data_inativacao is null
             <cfif arguments.transferencia eq 0>
                and not exists (select 'x'
                                  from manutencao.v$equipamento_analise ea
                                 where ea.equipamento_id = e.equipamento_id
                                   and ea.data_analise is null)
             </cfif>
			 <cfif Len(Trim(arguments.cod_equipamento))>
			   and e.cod_equipamento = '#arguments.cod_equipamento#'
			 </cfif>
			 <cfif Len(Trim(arguments.material_id))>
			   and e.material_id = #arguments.material_id#
			 </cfif>
			 <cfif  Len(Trim(arguments.cod_pessoa_filial))>
             	and el.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 group by e.cod_equipamento, e.equipamento_id,  almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ')
		     order by e.cod_equipamento
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamento componente
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_material_componente" returntype="query" access="remote">
		<cfargument name="material_id" required="yes">
		<cfargument name="material_id_os" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select mc.material_id, almoxarifado.pkg_almoxarifado.FNC_GET_MATERIAL_DESCRICAO(mc.material_id,' ') as material
				  from (select t.material_id, material_pai, material
							  from almoxarifado.v$material_dados t
							 start with t.material_id = #arguments.material_id#
							connect by t.material_id = prior t.material_pai) a
				 inner join almoxarifado.v$material_componente mc
							on mc.material_id_componente = a.material_id
			 <cfif Len(Trim(arguments.material_id_os))>
			 where not exists (select t.material_id, material_pai, material
									   from almoxarifado.v$material_dados t
									  where t.material_id = mc.material_id
									  start with t.material_id = #arguments.material_id_os#
									 connect by t.material_id = prior t.material_pai)
			 and not exists (select t.material_id, material_pai, material
									   from almoxarifado.v$material_dados t
									  where t.material_id = #arguments.material_id_os#
									  start with t.material_id = mc.material_id
									 connect by t.material_id = prior t.material_pai)
			 </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados completos do material atraves do codigo
	-- NOTAS EXPLICATIVAS
	-- GUTO 20/09/2006
	--->
	<cffunction name="get_material_dados_por_codigo" returntype="query" access="remote">
      <cfargument name="material_id" required="no" default=""/>
      <cfargument name="cod_material" required="no" default=""/>
      <cfargument name="material" required="no" default=""/>
      <cfargument name="atributo" required="no" default=""/>
      <cfargument name="com_saldo_estoque" required="no" default="0"/>
      <cfargument name="cod_pessoa_filial" required="no" default=""/>
      <cfargument name="cod_centro_custo" required="no" default=""/>
      <cfargument name="estoque" required="no" default="1"/>
      <cfargument name="niv_arvore" required="no" default=""/>
      <cfargument name="ativo" required="no" default="1"/>
      <cfargument name="tabela_id" required="no" default=""/>
      <cfargument name="data_base" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">

		<cfif not Len(Trim(arguments.cod_pessoa_filial))>
         <cfset arguments.cod_pessoa_filial = session.cod_pessoa>
      </cfif>
		<cfif not Len(Trim(arguments.cod_centro_custo))>
         <cfset arguments.cod_centro_custo = session.cod_centro_custo>
      </cfif>
	  
	  <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
	    select material_id             
			, material_pai            
			, cod_material            
			, titulo                  
			, descricao               
			, compoe_descricao        
			, estoque                 
			, unidade_estoque         
			, unidade_comercializacao 
			, identificado            
			, cod_genuino             
			, cod_fabricante          
			, cod_paralelo            
			, valor_unitario          
			, material                
			, produto_id              
			, valor                   
			, saldo_estoque           
			, localizacao             
			, exige_devolucao         
			, qtde_maxima             
			, qtde_minima             
			, niv_arvore   
			, categoria           
        from xmltable('/estoque_material/arrayItem' passing almoxarifado.pkg_almoxarifado_backend.fnc_material_saldo(
			
			xmltype('<params>' ||

			<cfif len(trim(arguments.material_id))>
			  '<material_id>#arguments.material_id#</material_id>' ||
			</cfif>

		    <cfif len(trim(arguments.cod_material))>
			  '<cod_material>#arguments.cod_material#</cod_material>'  ||
			</cfif>

            <cfif len(trim(arguments.material))>
			  '<material>#arguments.material#</material>'  ||
			</cfif>

			<cfif len(trim(arguments.atributo))>
			  '<atributo>#arguments.atributo#</atributo>'  ||
			</cfif>

            <cfif len(trim(arguments.com_saldo_estoque))>
			  '<com_saldo_estoque>#arguments.com_saldo_estoque#</com_saldo_estoque>' ||
			</cfif>

            <cfif len(trim(arguments.cod_pessoa_filial))>
			  '<cod_pessoa_filial>#arguments.cod_pessoa_filial#</cod_pessoa_filial>'  ||
			</cfif>

			<cfif len(trim(arguments.cod_centro_custo))>
			  '<cod_centro_custo>#arguments.cod_centro_custo#</cod_centro_custo>'  ||
			</cfif>

			<cfif len(trim(arguments.estoque))>
			  '<estoque>#arguments.estoque#</estoque>'  ||
			</cfif>

            <cfif len(trim(arguments.niv_arvore))>
			  '<niv_arvore>#arguments.niv_arvore#</niv_arvore>'  ||
			</cfif>

			<cfif len(trim(arguments.ativo))>
			  '<ativo>#arguments.ativo#</ativo>'  ||
			</cfif>

			<cfif len(trim(arguments.tabela_id))>
			  '<tabela_id>#arguments.tabela_id#</tabela_id>'  ||
			</cfif>

			<cfif len(trim(arguments.data_base))>
			  '<data_base>#arguments.data_base#</data_base>'  ||
			</cfif>

			'</params>')				
			) 
                columns
                   material_id             integer        path '/arrayItem/material_id'
                 , material_pai            integer        path '/arrayItem/material_pai'
                 , cod_material            varchar2(30)   path '/arrayItem/cod_material'
                 , titulo                  varchar2(160)  path '/arrayItem/titulo'
                 , descricao               varchar2(160)  path '/arrayItem/descricao'
                 , compoe_descricao        integer        path '/arrayItem/compoe_descricao'
                 , estoque                 integer        path '/arrayItem/estoque'
                 , unidade_estoque         varchar2(10)   path '/arrayItem/unidade_estoque'
                 , unidade_comercializacao varchar2(10)   path '/arrayItem/unidade_comercializacao'
                 , identificado            integer        path '/arrayItem/identificado'
                 , cod_genuino             varchar2(4000) path '/arrayItem/cod_genuino'
                 , cod_fabricante          varchar2(4000) path '/arrayItem/cod_fabricante'
                 , cod_paralelo            varchar2(4000) path '/arrayItem/cod_paralelo'
                 , valor_unitario          number         path '/arrayItem/valor_unitario'
                 , material                varchar2(255)  path '/arrayItem/material'
                 , produto_id              integer        path '/arrayItem/produto_id'
                 , valor                   number         path '/arrayItem/valor'
                 , saldo_estoque           number         path '/arrayItem/saldo_estoque'
                 , localizacao             varchar2(4000) path '/arrayItem/localizacao'
                 , exige_devolucao         varchar2(4000) path '/arrayItem/exige_devolucao'
                 , qtde_maxima             number 		  path '/arrayItem/qtde_maxima'
                 , qtde_minima             number 		  path '/arrayItem/qtde_minima'
                 , niv_arvore              integer        path '/arrayItem/niv_arvore'
                 , categoria               varchar2(4000) path '/arrayItem/categoria'
      )
	  
	  
	  

	
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca posies que um material pode assumir
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_material_posicao" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct mp.material_id, ep.posicao_id, ep.posicao
			  from manutencao.v$material_posicao mp
			 inner join manutencao.v$equipamento_posicao ep
						 on ep.posicao_id = mp.posicao_id
			 where mp.material_id in (
						select m.material_id
						  from almoxarifado.v$material m
					 start with m.material_id = #arguments.material_id#
					connect by m.material_id = prior m.material_pai)
		     order by ep.posicao
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- GUTO 18/10/2006
	--->
	<cffunction name="get_oficina_processos" returntype="query" access="remote">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 					select /*+ ORDERED USE_HASH(PO PR) PARALLEL*/ distinct po.tipo
                         , po.ordem_servico_id
                         , po.empresa
                         , po.cod_pessoa_oficina
                         , po.equipamento_id
                         , po.cod_equipamento
                         , po.num_ordem_servico
                         , po.grupo_id
                         , nvl(po.grupo,'Veculo') as grupo
                         , po.compartimento_id
                         , nvl(po.compartimento,'Veculo') as compartimento
                         , po.posicao_id
                         , po.posicao, po.atividade, po.atividade_id, po.processo_id, po.processo, po.executada, po.execucao_id,
							 po.controle_id_processo, po.controle_id_atividade,
							 po.cod_pessoa_principal, po.principal, po.cod_pessoa_auxiliar, po.auxiliar,
							 po.data_inicio, po.data_termino, po.tempo_estimado, po.tempo_execucao, po.tempo_execucao_min,
							 po.ordem_processo, po.verificacao,
                             manutencao.to_tempo_execucao(manutencao.sum_dsinterval(po.tempo_execucao_interval) over(partition by po.ordem_servico_id order by po.ordem_servico_id) ).retorno as tempo_total_os,
                             manutencao.to_tempo_execucao(manutencao.sum_dsinterval(po.tempo_execucao_interval) over() ).retorno as tempo_total_oficina
					  from manutencao.v$processos_oficina po
					 inner join manutencao.v$processo_recurso pr
					    on po.processo_id = pr.processo_id
				     where po.cod_pessoa_oficina = #session.cod_pessoa#
					   and po.executada = 0
					   and not exists (select 'x'
						                 from manutencao.v$os_processo_execucao ope2
                                        where ope2.controle_id = po.controle_id_processo
                                          and ope2.data_termino is null)
				<cfif Len(Trim(arguments.cod_pessoa))>
					   and exists (select 'x'
                                     from manutencao.v$recurso re
                                    where (re.especialidade_id = pr.especialidade_id
                                        or pr.especialidade_id is null)
                                       and re.nivel_id <= nvl(pr.nivel_id,po.nivel_id)
                                       and re.cod_pessoa = #arguments.cod_pessoa#)
			     </cfif>
						order by ordem_servico_id, compartimento, grupo, posicao, atividade, atividade_id, ordem_processo, data_inicio
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca servicos executados na OS
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_veiculo_atividade_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select osa.controle_id, atv.titulo, nvl(mep.posicao, 'nica') as posicao,
                   atv.cod_atividade,
                   manutencao.to_os_atividade(osa.controle_id).material_ok as material_ok,
                   manutencao.to_material_dados(manutencao.to_os_atividade(osa.controle_id).material_id).descricao_completa as material_utilizado,
                   manutencao.to_tempo_execucao(osa.tempo_execucao_ajustado,3).retorno as tempo_execucao,
                   case
                       when os.empresa = 1 then
                         round(manutencao.to_tempo_convertido(osa.tempo_execucao_ajustado).horas * (select sum(decode(os.empresa,1,ova.valor_empresa,ova.valor_terceiro))
                                                                                                    from manutencao.mv$os_valor_atividade ova
                                                                                                   where ova.ordem_servico_id = os.ordem_servico_id
                                                                                                     and ova.atividade_id = osa.atividade_id),2)
                       else osa.valor_servico
                   end valor,
                   case
                     when osa.gerada_por = 1 then 'Sistema'
                     when osa.gerada_por = 2 then 'Solicitao do Motorista'
                     when osa.gerada_por = 3 then 'Check List'
                   else '' end gerada_por, os.observacao
              from manutencao.v$ordem_servico os
          inner join manutencao.v$os_atividade osa
                        on osa.ordem_servico_id = os.ordem_servico_id
          inner join manutencao.v$atividade atv
              on atv.atividade_id = osa.atividade_id
           left join manutencao.v$equipamento_posicao mep
              on mep.posicao_id = osa.posicao_id
           where osa.ordem_servico_id = #arguments.ordem_servico_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais com a garantia na OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 15/06/2009 - ALTERADO
	--->
	<cffunction name="get_veiculo_material_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select om.controle_id,
                   om.posicao_id,
                   nvl(ep.posicao, 'nica') as posicao,
                   round(nvl(om.valor_unitario, almoxarifado.to_material(om.material_id).valor_unitario), 2) as valor_unitario,
                   round(nvl(om.valor_total, almoxarifado.to_material(om.material_id).valor_unitario * om.quantidade), 2) as valor_total,
                   md.material,
                   mdr.material as material_retirado,
                   om.quantidade,
                   e.cod_equipamento
              from manutencao.v$os_material om
             inner join almoxarifado.v$material_dados md
                     on md.material_id = om.material_id
             inner join almoxarifado.v$material_dados mdr
                     on mdr.material_id = om.material_id_retirado
              left join manutencao.v$equipamento_posicao ep
                     on ep.posicao_id = om.posicao_id
              left join almoxarifado.v$equipamento e
                     on e.equipamento_id = om.equipamento_id
   		     where om.ordem_servico_id = #arguments.ordem_servico_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuteno vincculadas a um veculo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->

	<cffunction name="get_equipamento_tabela_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select tm.nome as tabela, ost.ordem_servico_id,
				       case
                           when tm.tipo_execucao is null then ''
                           when tm.tipo_execucao = 1 then 'Completa'
                           when tm.tipo_execucao = 2 then 'Parcial'
                       else '' end tipo_execucao
				  from manutencao.v$os_tabela_manutencao ost
           inner join manutencao.v$tabela_manutencao tm
          		   on tm.tabela_id = ost.tabela_id
				where ost.ORDEM_SERVICO_ID = #arguments.ordem_servico_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca solicitaes (por OS) enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_equipamento_solicitacao_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.cod_equipamento,
                   ms.solicitacao_id,
                   ms.equipamento_id,
                   to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao,
                   ms.texto,
                   ms.atendida,
                   ms.ordem_servico_id_execucao,
                   ms.user_insert,
                   ms.date_insert,
                   (select cod_pessoa
                      from oper.v$veiculo_motorista vm
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as cod_pessoa_motorista,
                   (select p.cliente
                      from oper.v$veiculo_motorista vm
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = vm.cod_pessoa
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as motorista
              from manutencao.v$equipamento_solicitacao ms
             inner join almoxarifado.v$equipamento e
                      on e.equipamento_id = ms.equipamento_id
  			  where ms.ordem_servico_id_execucao = #arguments.ordem_servico_id#
			  order by ms.data_solicitacao desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atendimentos vinculados a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/07/2007
	--->
	<cffunction name="get_os_atendimento" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default=""/>
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
        <cfargument name="recurso_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.controle_id, os.ordem_servico_id, os.cod_pessoa_mecanico, p.cliente as mecanico,
                   os.placa_veiculo_socorro,
                   to_char(os.data_saida,'dd/mm/yyyy hh24:mi') as data_saida,
                   to_char(os.data_retorno,'dd/mm/yyyy hh24:mi') as data_retorno, os.km_deslocamento,
                   o.num_ordem_servico, p2.cliente as oficina
              from manutencao.v$os_atendimento os
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_mecanico
             inner join manutencao.v$ordem_servico o
                     on o.ordem_servico_id = os.ordem_servico_id
             inner join kss.v$pessoa p2
                     on p2.cod_pessoa = o.cod_pessoa_oficina
             where 1=1
             <cfif Len(Trim(arguments.ORDEM_SERVICO_ID))>
               and os.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
             </cfif>
             <cfif Len(Trim(arguments.DATA_INICIO))>
               and o.data_abertura >= '#arguments.DATA_INICIO#'
             </cfif>
             <cfif Len(Trim(arguments.DATA_FIM))>
               and o.data_abertura <= '#arguments.DATA_FIM#'
             </cfif>
             <cfif Len(Trim(arguments.recurso_id))>
               and os.cod_pessoa_mecanico in (#arguments.recurso_id#)
             </cfif>
             order by os.cod_pessoa_mecanico
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuteno na OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_tabelas" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes">
        <cfargument name="somente_folhas" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ot.controle_id
                 , os.ordem_servico_id
                 , os.num_ordem_servico
                 , ot.confirmada
                 , ot.tabela_id
                 , tm.nome
                 , nvl((select min(oa.executada)
                          from manutencao.v$os_atividade oa
                         where oa.controle_id_tabela = ot.controle_id),1) as executada
                 , manutencao.to_tempo_execucao(numtodsinterval(nvl((select sum(sysdate+oa.tempo_execucao_oficina-sysdate)
																	   from manutencao.v$os_atividade oa
																	  where oa.controle_id_tabela = ot.controle_id),0),'DAY')).retorno as tempo_execucao
                  , (select substr(sys_connect_by_path('|' || tabela_id || '|', ','),2)
                        from manutencao.v$tabela_manutencao tm2
                       where tm2.tabela_id = ot.tabela_id
                       start with tabela_pai = 0
                     connect by prior tabela_id = tabela_pai
                       ) as lista_tabela_separador
			 from manutencao.v$ordem_servico os
			inner join manutencao.v$os_tabela_manutencao ot
				 on ot.ordem_servico_id = os.ordem_servico_id
			inner join manutencao.v$tabela_manutencao tm
					   on tm.tabela_id = ot.tabela_id
			where 1=1
			  and os.ordem_servico_id = #arguments.ordem_servico_id#
		  <cfif arguments.somente_folhas eq 1>
              and tm.tabela_id not in ( select tm2.tabela_pai
                                          from manutencao.v$os_tabela_manutencao ot2
                                         inner join manutencao.v$tabela_manutencao tm2
                                            on tm2.tabela_id = ot2.tabela_id
                                         where ot2.ordem_servico_id = ot.ordem_servico_id)
          </cfif>
			order by ot.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividades da OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/04/2010 - ALTERADO
	--->
	<cffunction name="get_os_atividades" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="verificacao" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.ordem_servico_id
                 , op.controle_id
                 , oa.atividade_id
                 , oa.controle_id_tabela
                 , oa.controle_id as controle_id_atividade
                 , a.titulo
                 , manutencao.to_os_atividade(oa.controle_id).material_ok as material_ok
                 , manutencao.to_material_dados(manutencao.to_os_atividade(oa.controle_id).material_id).descricao_completa as material_utilizado
                 , case
                      when oa.gerada_por = 1 then 'Sistema'
                      when oa.gerada_por = 2 then 'Solicitao Mot.'
                      else 'Check List'
                   end gerada_por
                 , oa.executada
                 , manutencao.to_tempo_execucao(nvl(oa.tempo_execucao_ajustado, numtodsinterval(0, 'DAY'))).retorno as tempo_execucao
                 , oa.date_insert
                 , oa.posicao_id
                 , nvl(ep.posicao, 'nica') as posicao
                 , nvl(oa.valor_servico,0) as valor_atividade
            from manutencao.v$ordem_servico os
           inner join manutencao.v$os_atividade oa
              on oa.ordem_servico_id = os.ordem_servico_id
           inner join manutencao.v$atividade a
              on a.atividade_id = oa.atividade_id
    	  left join manutencao.v$os_processo_atividade pa
              on pa.controle_id_atividade = oa.controle_id
	      left join manutencao.v$os_processos op
              on op.controle_id = pa.controle_id_processo
            left join manutencao.v$equipamento_posicao ep
              on ep.posicao_id = oa.posicao_id
             where 1=1
            <cfif Len(Trim(arguments.ordem_servico_id))>
                and os.ordem_servico_id = #arguments.ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.controle_id))>
                and op.controle_id = #arguments.controle_id#
            </cfif>
            <cfif arguments.verificacao eq 1>
                and a.verificacao = 1
            </cfif>
			order by oa.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca solicitaes (por OS) enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- RAFAEL COSTA 30/04/2010
	--->
	<cffunction name="get_equipamento_solicitacao_gerada_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.cod_equipamento,
                   ms.solicitacao_id,
                   ms.equipamento_id,
                   to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao,
                   ms.texto,
                   ms.atendida,
                   ms.ordem_servico_id_execucao,
                   ms.user_insert,
                   ms.date_insert,
                   (select cod_pessoa
                      from oper.v$veiculo_motorista vm
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as cod_pessoa_motorista,
                   (select p.cliente
                      from oper.v$veiculo_motorista vm
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = vm.cod_pessoa
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as motorista,
                   oses.ordem_servico_id
              from manutencao.v$equipamento_solicitacao ms
        inner join almoxarifado.v$equipamento e
                on e.equipamento_id = ms.equipamento_id
        inner join manutencao.v$os_equipamento_solicitacao oses
                on oses.solicitacao_id = ms.solicitacao_id
             where 1 = 1
          <cfif Len(Trim(arguments.ordem_servico_id))>
               and oses.ordem_servico_id = #arguments.ordem_servico_id#
          </cfif>
          <cfif Len(Trim(arguments.equipamento_id))>
               and ms.equipamento_id = #arguments.equipamento_id#
          </cfif>
               and ms.atendida = 0
          order by ms.data_solicitacao desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/09/2009 - EDITADO
	--->
	<cffunction name="print_oficina_processos" returntype="query" access="remote" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="aberta" required="no" default="">
		<cfargument name="controle_id_processo" required="no" default="">
        <cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="verificacao" required="no" default="0">
        <cfargument name="externa" required="no" default="0" hint="0-No; 1-Sim">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo, rownum as linha_controle, ordem_servico_id,empresa,cod_pessoa_oficina,equipamento_id,
                   cod_equipamento,agrupamento,num_ordem_servico,grupo_id,grupo,
                   compartimento_id,compartimento,posicao_id,posicao,atividade,
                   processo_id,processo,executada,execucao_id,controle_id_processo,
                   controle_id_atividade,cod_pessoa_principal,principal,cod_pessoa_auxiliar,
                   auxiliar,data_inicio,data_termino,tempo_estimado,tempo_execucao,
                   ordem_processo,nome_mecanico,nivel_id,especialidade_id
              from (select distinct po.tipo,
                           po.ordem_servico_id,
                           po.empresa,
                           po.cod_pessoa_oficina,
                           po.equipamento_id,
                           po.cod_equipamento,
                           po.cod_equipamento || ' > ' || nvl(po.compartimento, 'Veculo') as agrupamento,
                           po.num_ordem_servico,
                           po.grupo_id,
                           nvl(po.grupo, 'Veculo') as grupo,
                           po.compartimento_id,
                           nvl(po.compartimento, 'Veculo') as compartimento,
                           po.posicao_id,
                           po.posicao,
                           po.atividade || ' > ' || nvl(po.grupo, 'Veculo') as atividade,
                           po.processo_id,
                           po.processo,
                           po.executada,
                           po.execucao_id,
                           po.controle_id_processo,
                           po.controle_id_atividade,
                           po.cod_pessoa_principal,
                           po.principal,
                           po.cod_pessoa_auxiliar,
                           po.auxiliar,
                           po.data_inicio,
                           po.data_termino,
                           po.tempo_estimado,
                           po.tempo_execucao,
                           po.ordem_processo,
                           p.cliente as nome_mecanico,
                           0 as nivel_id,
                           0 as especialidade_id
                      from manutencao.v$processos_oficina po
                     inner join manutencao.v$processo_recurso pr
                             on po.processo_id = pr.processo_id
                    <cfif arguments.externa eq 1>
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_oficina
                    <cfelse>
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_principal
                     inner join manutencao.v$recurso r
                             on r.cod_pessoa = p.cod_pessoa
                            and r.especialidade_id = pr.especialidade_id
                    </cfif>
                     where 1 = 1
                       and po.executada = 0
                    <cfif arguments.externa eq 0>
                       and po.execucao_id is not null
                       and po.cod_pessoa_oficina = #session.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and po.cod_pessoa_principal = #arguments.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.aberta))>
                       and po.data_termino is null
                    </cfif>
                    <cfif Len(Trim(arguments.controle_id_processo))>
                       and po.controle_id_processo in (#arguments.controle_id_processo#)
                    </cfif>
                    <cfif Len(Trim(arguments.ordem_servico_id))>
                       and po.ordem_servico_id = #arguments.ordem_servico_id#
                    </cfif>
                    <cfif Len(Trim(arguments.equipamento_id))>

                       and po.equipamento_id = #arguments.equipamento_id#
                    </cfif>
                    <cfif arguments.verificacao eq 1>
                       and po.verificacao = 1
                    </cfif>
                     order by ordem_servico_id, compartimento, grupo, posicao, atividade, ordem_processo, data_inicio)
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca recursos que podem executar o processo
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/10/2007
	--->
	<cffunction name="get_recursos_processo" returntype="query" access="remote">
		<cfargument name="processo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select distinct r.recurso_id,
                   r.cod_pessoa, pf.cliente as nome_funcionario,
                   oper.pkg_global.fnc_get_cod_funcionario(r.cod_pessoa) as cod_funcionario,
                   r.especialidade_id,
                   re.descricao as especialidade,
                   r.nivel_id, rn.descricao as nivel
                from manutencao.v$recurso r
               inner join manutencao.v$recurso_especialidade re
                   on re.especialidade_id = r.especialidade_id
               inner join manutencao.v$recurso_nivel rn
                   on rn.nivel_id = r.nivel_id
               inner join kss.v$pessoa pf
                   on pf.cod_pessoa = r.cod_pessoa
               inner join manutencao.v$processo_recurso pr
                       on pr.especialidade_id = re.especialidade_id
                      and pr.nivel_id >= rn.nivel_id
                      and pr.processo_id = #arguments.processo_id#
                 where 1=1
                           and re.especialidade_id in (select especialidade_id
                                                         from manutencao.v$processo_recurso p
                                                        where 1=1
                                                          and p.processo_id = #arguments.processo_id#)
                  order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca recursos de processos abertos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 01/11/2006
	--->
	<cffunction name="get_recurso_processo_aberto" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct r.cod_pessoa,
							pf.cliente as nome_funcionario,
							(select manutencao.sum_dsinterval(p.tempo_execucao) + min(ope.DATA_INICIO)
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao ope
                                 on opa.controle_id_processo = ope.controle_id
                         inner join manutencao.v$os_processos op
                                 on opa.controle_id_processo = op.controle_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
        								 where ope.cod_pessoa_principal = pf.cod_pessoa
        									and ope.data_termino is null) - sysdate as no_horario,
							manutencao.to_tempo_execucao((select manutencao.sum_dsinterval(p.tempo_execucao)
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao ope
                                 on opa.controle_id_processo = ope.controle_id
                         inner join manutencao.v$os_processos op
                                 on opa.controle_id_processo = op.controle_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
        								 where ope.cod_pessoa_principal = pf.cod_pessoa
        									and ope.data_termino is null)).retorno as tempo_execucao
			  from manutencao.v$recurso r
		inner join kss.v$pessoa pf
		        on pf.cod_pessoa = r.cod_pessoa
	    	 where 1 = 1
			   and exists (select /*+PUSH_SUBQ*/ 'x'
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao op
                                 on opa.controle_id_processo = op.controle_id
        								 where op.cod_pessoa_principal = pf.cod_pessoa
        									and op.data_termino is null)
			   and (exists (select 'x'
              from manutencao.v$recurso_oficina ro
        inner join manutencao.v$recurso r2
                on r2.recurso_id = ro.recurso_id
             where r2.cod_pessoa = r.cod_pessoa
               and ro.cod_pessoa_oficina = #session.cod_pessoa#)
  	 or not exists (select 'x'
  	                  from manutencao.v$recurso_oficina ro
                inner join manutencao.v$recurso r2
                        on r2.recurso_id = ro.recurso_id
                inner join oper.v$filial f
                        on f.cod_pessoa = ro.cod_pessoa_oficina
                     where r2.cod_pessoa = r.cod_pessoa) )
			 order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os recursos de processos que no possuem execuo atribudas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 10/08/2009 - EDITADO
	--->
	<cffunction name="get_recurso_processo_sem_execucao" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct r.cod_pessoa
                 , pf.cliente as nome_funcionario
              from manutencao.v$recurso r
             inner join kss.v$pessoa pf
                     on pf.cod_pessoa = r.cod_pessoa
             where 1 = 1
               and not exists (select 'x'
                                 from manutencao.v$ordem_servico os
                                inner join manutencao.v$os_atividade oa
                                        on oa.ordem_servico_id = os.ordem_servico_id
                                inner join manutencao.v$os_processo_atividade opa
                                        on opa.controle_id_atividade = oa.controle_id
                                inner join manutencao.v$os_processo_execucao op
                                        on opa.controle_id_processo = op.controle_id
                                where op.cod_pessoa_principal = pf.cod_pessoa
                                  and op.data_termino is null)
               and exists (select 'x'
                             from manutencao.v$recurso_oficina ro
                            inner join manutencao.v$recurso r2
                                    on r2.recurso_id = ro.recurso_id
                            where r2.cod_pessoa = r.cod_pessoa
                              and ro.cod_pessoa_oficina = #session.cod_pessoa#)
             order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Busca os equipamentos vinculados a um recurso de um processo aberto
    -- ANDERSON 01/12/2009 - ALTERADO
    --->
    <cffunction name="get_recurso_processo_equipamentos" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_principal" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.equipamento_id
                 , t.cod_equipamento
                 , kss.fnc_concat_all(kss.to_concat_expr(to_char(t.num_ordem_servico), ', ')) as num_ordem_servico
              from (
                    select po.equipamento_id
                         , po.cod_equipamento
                         , os.num_ordem_servico
                      from manutencao.v$processos_oficina po
                     inner join manutencao.v$ordem_servico os
                             on os.ordem_servico_id = po.ordem_servico_id
                     where po.cod_pessoa_oficina = #session.cod_pessoa#
                       and po.execucao_id is not null
                       and po.executada = 0
                       and po.cod_pessoa_principal = #arguments.cod_pessoa_principal#
                     group by po.equipamento_id, po.cod_equipamento, os.num_ordem_servico
                   ) t
             group by t.equipamento_id, t.cod_equipamento
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca as ocorrncias de Previso de Liberaco
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_liberacao" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" default="" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			select t.previsao_id,
				   t.ordem_servico_id,
			       to_char(t.data_previsao,'dd/mm/yyyy hh24:mi') as data_previsao,
    			   t.responsavel as responsavel,
     			   t.motivo_adiamento,
				   t.date_update
  			  from manutencao.v$os_previsao_liberacao t
  			 where t.ordem_servico_id = #arguments.ordem_servico_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca itens de ordens vinculadas a OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/04/2010 - ALTERADO
	--->
	<cffunction name="get_ordem_compra_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select oc.num_controle
                  ,p.razao_social as titulo
                 , (select pf.cliente
                      from kss.v$pessoa pf
                     where pf.cod_pessoa = oc.cod_pessoa_fornecedor) as fornecedor
                  ,to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao
                  ,oc.total_orcado
                  ,oc.total_desconto
                  ,oc.total_combinado
                  ,e.cod_equipamento as placa
                  ,nvl(nvl(manutencao.to_ordem_servico(os.ordem_servico_id).valor_total_servicos,0) +
                       nvl(manutencao.to_ordem_servico(os.ordem_servico_id).valor_total_material, 0), 0
                      ) as total_utilizado
              from manutencao.v$ordem_compra oc
             inner join manutencao.v$os_ordem_compra ooc
                     on ooc.num_controle = oc.num_controle
             inner join manutencao.v$ordem_servico_dados os
                     on os.ordem_servico_id = ooc.ordem_servico_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_oficina
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             where 1 = 1
            <cfif len(Trim(arguments.ordem_servico_id))>
               and ooc.ordem_servico_id = #arguments.ordem_servico_id#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca itens de ordens vinculadas a OS
	-- NOTAS EXPLICATIVAS
	-- RAFAEL COSTA 09/06/2009
	--->
	<cffunction name="get_ordem_compra_nf_terceiro" returntype="query" access="remote">
		<cfargument name="ORDEM_SERVICO_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select osd.num_nota_id
                    ,toc.ordem_compra_id
                    ,p.razao_social as titulo
                    ,to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao
                    ,oc.total_orcado
                    ,oc.total_desconto
                    ,oc.total_combinado
                    ,nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) +
                                 sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                           from manutencao.v$os_ordem_compra ooc
                          where ooc.num_controle = oc.num_controle),0) as valor_utilizado
                    ,oc.num_controle
                    ,e.cod_equipamento as placa
                from manutencao.v$ordem_servico_dados osd
          inner join manutencao.v$nf_terceiro_ordem_compra toc
                  on toc.nf_terceiro_id = osd.num_nota_id
          inner join manutencao.v$ordem_compra oc
                  on oc.num_controle = toc.ordem_compra_id
          inner join kss.v$pessoa p
                  on p.cod_pessoa = osd.cod_pessoa_oficina
          inner join almoxarifado.v$equipamento e
                  on e.equipamento_id = osd.equipamento_id
               where 1 = 1
            <cfif len(Trim(arguments.ORDEM_SERVICO_ID))>
               and osd.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca ordens de servio vinculadas a nf de terceiro
	-- NOTAS EXPLICATIVAS
	-- JONAS 03/07/2009
	--->
	<cffunction name="get_ordem_servico_nf_terceiro" returntype="query" access="remote">
		<cfargument name="ORDEM_SERVICO_ID" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select osd.num_nota_id,
         		 osd.num_ordem_servico,
                osd.ordem_servico_id,
                p.razao_social as titulo,
                e.cod_equipamento as placa,
                to_char(osd.data_abertura, 'dd/mm/yyyy') as data_abertura,
                nvl(
                    nvl(manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_servicos,0) +-- + manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_material) as valor,
                    nvl(manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_material,0)
                ,0) as valor
           from manutencao.v$ordem_servico_dados osd
          inner join kss.v$pessoa p
             on p.cod_pessoa = osd.cod_pessoa_oficina
          inner join almoxarifado.v$equipamento e
             on e.equipamento_id = osd.equipamento_id
          where 1 = 1
            and osd.num_nota_id = (select num_nota_id from manutencao.v$ordem_servico_dados where ordem_servico_id = #arguments.ordem_servico_id#)
          order by osd.data_abertura
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 16/12/2009
	--->
	<cffunction name="get_solicitacao_equipamento" returntype="query" access="remote">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select es.solicitacao_id
                     , es.equipamento_id
                     , es.data_solicitacao
                     , es.texto
                     , es.atendida
                     , es.ordem_servico_id_execucao
                     , e.cod_equipamento
                     , es.cod_pessoa_responsavel
                     , oper.pkg_global.fnc_get_cod_funcionario(es.cod_pessoa_responsavel) as cod_funcionario
                     , kss.pkg_pessoa.fnc_get_cliente(es.cod_pessoa_responsavel) as nome_funcionario
                     , es.tipo_id
                     , est.descricao as tipo
				  from manutencao.v$equipamento_solicitacao es
                 inner join almoxarifado.v$equipamento e
                    on e.equipamento_id = es.equipamento_id
                 inner join manutencao.v$equipamento_solicitacao_tipo est
                    on est.tipo_id = es.tipo_id
    		     where 1=1
 			  <cfif Len(Trim(arguments.solicitacao_id))>
				and es.solicitacao_id = #arguments.solicitacao_id#
			  </cfif>
			  <cfif Len(Trim(arguments.equipamento_id))>
				and es.equipamento_id = #arguments.equipamento_id#
			  </cfif>
			  <cfif Len(Trim(arguments.cod_equipamento))>
				and upper(e.cod_equipamento) like upper('%#arguments.cod_equipamento#%')
			  </cfif>
 			  order by e.cod_equipamento
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- GUTO 18/10/2006
	--->
	<cffunction name="get_material_atividade" returntype="query" access="remote">
		<cfargument name="MATERIAL_ID" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 				select mab.material_id,
					   mab.atividade_id,
					   atv.titulo
				  from manutencao.v$material_atividade_baixa mab
	    	inner join manutencao.v$atividade atv
					on atv.atividade_id = mab.atividade_id
				 where 1=1
				   and mab.material_id = #arguments.MATERIAL_ID#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	- Busca veculos em manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO 15/12/2009
	--->
	<cffunction name="get_veiculos_manutencao" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.ordem_servico_id, os.num_ordem_servico,
                   e.placa, e.cod_equipamento, o.cliente as oficina,
                   nvl(tos.descricao, 'No identificado') as tipo_os,
                   to_char(os.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura,
                   kss.to_tempo(numtodsinterval((nvl(os.data_fechamento,sysdate) - os.data_abertura),'day'),1).retorno as tempo_total,
                   numtodsinterval((nvl(os.data_fechamento,sysdate) - os.data_abertura),'day') as tempo_internval, os.observacao,
                   r.cliente as responsavel, os.user_insert,
                   to_char(os.date_insert,'dd/mm/yyyy hh24:mi') as date_insert,
                   to_char(manutencao.to_os_liberacao(e.placa).data_previsao,'dd/mm/yyyy hh24:mi') as data_prev_liberacao
                   ,manutencao.to_os_liberacao(e.placa).motivo as motivo
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             inner join kss.v$pessoa o
                     on o.cod_pessoa = os.cod_pessoa_oficina
              left join manutencao.v$tipo_ordem_servico tos
                     on tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id
             inner join kss.v$pessoa r
                     on r.cod_pessoa = os.cod_pessoa_responsavel
             where os.data_fechamento is null
            order by tempo_internval desc
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os processos da atividade detalhado
	-- CRISTOFER  11/08/2006
	--->
	<cffunction name="get_atividade_processos" access="remote" returntype="query">
		<cfargument name="atividade_id" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.atividade_id, a.titulo as atividade, a.cod_atividade,
					 manutencao.to_tempo_execucao(manutencao.sum_dsinterval(nvl(p.tempo_execucao,a.tempo_execucao)) over(partition by a.atividade_id order by a.atividade_id)).retorno as tempo_total,
					 p.processo_id, p.titulo as processo,
					 manutencao.to_tempo_execucao(nvl(p.tempo_execucao,a.tempo_execucao)).retorno as tempo_execucao,
					 ap.ordem, ap.item_id
			  from manutencao.v$atividade a
			 left join manutencao.v$atividade_processo ap
						on ap.atividade_id = a.atividade_id
			 left join manutencao.v$processo p
						on p.processo_id = ap.processo_id
			 order by a.atividade_id, ap.ordem
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca horas dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_horas_recursos" returntype="query" access="remote">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="recurso_id" required="no">
		<cfargument name="data_inicio" required="no">
		<cfargument name="data_termino" required="no">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select cod_pessoa_principal, principal, cod_pessoa_auxiliar,
 			 	    auxiliar, tempo_execucao,
 				    especialidade_id, especialidade, nivel, nivel_id,
				    valor_hora, valor_total_horas,
					manutencao.to_tempo_execucao(manutencao.sum_dsinterval(tempo_exec_interval) over(partition by cod_pessoa_principal order by cod_pessoa_principal),3).retorno as tempo_total_func,
					sum(nvl(valor_total_horas,0)) over(partition by cod_pessoa_principal order by cod_pessoa_principal) as valor_total_func
			from (
			select ope.cod_pessoa_principal, pe.cliente as principal,
					 ope.cod_pessoa_auxiliar, pea.cliente as auxiliar,
					 manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100)) / decode(ope.cod_pessoa_auxiliar,null,1,2) as tempo_exec_interval,
					 manutencao.to_tempo_execucao(manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100))/ decode(ope.cod_pessoa_auxiliar,null,1,2),3) .retorno as tempo_execucao,
					 e.especialidade_id, e.descricao as especialidade,
					 n.descricao as nivel, n.nivel_id,
					 avg(manutencao.to_recurso_valor(ope.cod_pessoa_principal,e.especialidade_id,n.nivel_id,ope.data_termino).valor_hora) as valor_hora,
					 round((((sysdate + manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100)) - sysdate)*24) * avg(manutencao.to_recurso_valor(ope.cod_pessoa_principal,e.especialidade_id,n.nivel_id,ope.data_termino).valor_hora)) / decode(ope.cod_pessoa_auxiliar,null,1,2) ,2) as valor_total_horas
			  from manutencao.v$ordem_servico os
             inner join manutencao.v$os_processos op
                     on os.ordem_servico_id = op.ordem_servico_id
			 inner join manutencao.v$os_processo_execucao ope
               on op.controle_id = ope.controle_id
			 inner join manutencao.v$processo p
               on p.processo_id = op.processo_id
			 inner join manutencao.v$processo_recurso pr on pr.item_id = op.processo_recurso_id
			 inner join manutencao.v$recurso_nivel n on n.nivel_id = pr.nivel_id
			 inner join manutencao.v$recurso_especialidade e on e.especialidade_id =
																				 pr.especialidade_id
			 inner join kss.v$pessoa pe on pe.cod_pessoa = ope.cod_pessoa_principal
			  left join kss.v$pessoa pea on pea.cod_pessoa = ope.cod_pessoa_auxiliar
			 where op.executado = 1
				and ope.fecha_execucao = 1
			<cfif Len(Trim(arguments.COD_PESSOA_RESPONSAVEL))>
				and ope.cod_pessoa_principal = #arguments.COD_PESSOA_RESPONSAVEL#
			</cfif>
			<cfif IsDefined("arguments.RECURSO_ID") and arguments.RECURSO_ID neq "">
				and (ope.cod_pessoa_principal in (#arguments.RECURSO_ID#) or
				     ope.cod_pessoa_auxiliar in (#arguments.RECURSO_ID#) )
			</cfif>
			<cfif Len(Trim(arguments.DATA_INICIO)) and Len(Trim(arguments.DATA_TERMINO))>
				and trunc(os.data_abertura) between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_termino#','dd/mm/yyyy')
			</cfif>
			 group by ope.cod_pessoa_principal, pe.cliente, ope.cod_pessoa_auxiliar,
						 pea.cliente, e.descricao, e.especialidade_id, n.descricao,
						 n.nivel_id) a
			  order by a.cod_pessoa_principal
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- ARLEN 13/12/2006
	--->
	<cffunction name="get_atividade_equipamento" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct po.tipo, po.ordem_servico_id, po.num_ordem_servico, po.empresa, po.cod_pessoa_oficina, po.equipamento_id,
				   po.cod_equipamento,
				   po.cod_equipamento || ' > ' || nvl(po.compartimento,'Veculo')  || ' > ' || nvl(po.grupo,'Veculo') as agrupamento,
				   po.num_ordem_servico, po.grupo_id, nvl(po.grupo,'Veculo') as grupo, po.compartimento_id, nvl(po.compartimento,'Veculo') as compartimento, po.posicao_id,
				   po.posicao, po.atividade, po.processo_id, po.processo, po.executada, po.execucao_id,
				   po.controle_id_processo, po.controle_id_atividade,
				   po.cod_pessoa_principal, po.principal, po.cod_pessoa_auxiliar, po.auxiliar,
				   po.data_inicio, po.data_termino, po.tempo_estimado, po.tempo_execucao,
				   po.ordem_processo,
				   os.data_abertura as data_abertura
			  from manutencao.v$processos_oficina po
			 inner join manutencao.v$processo_recurso pr
					 on po.processo_id = pr.processo_id
			 inner join manutencao.v$ordem_servico os
       				 on os.ordem_servico_id = po.ordem_servico_id
			 <cfif len(Trim(atividade_id))>
			 inner join manutencao.v$atividade_processo ap
			 		 on ap.processo_id = po.processo_id
			 inner join manutencao.v$atividade a
            		 on a.atividade_id = ap.atividade_id
			 </cfif>
			 where 1=1
			 <cfif len(Trim(ordem_servico_id))>
			   and po.ordem_servico_id = #arguments.ordem_servico_id#
			 </cfif>
			 <cfif len(Trim(num_ordem_servico))>
			   and po.num_ordem_servico = #arguments.num_ordem_servico#
			 </cfif>
			 <cfif len(Trim(equipamento_id))>
			   and po.equipamento_id = #arguments.equipamento_id#
			 </cfif>
			 <cfif len(Trim(atividade_id))>
			   and a.atividade_id in (#arguments.atividade_id#)
			 </cfif>
			 <cfif Len(Trim(arguments.empresa))>
			   and os.empresa= #arguments.empresa#
			  </cfif>
			  <cfif Len(Trim(arguments.data_inicio))	and Len(Trim(arguments.data_fim))>
			   and os.data_abertura between '#LSDateFormat(arguments.data_inicio,'dd/mm/yyyy')#' and '#LSDateFormat(arguments.data_fim,'dd/mm/yyyy')#'
			 </cfif>
			 order by ordem_servico_id, compartimento, grupo, posicao,  atividade, ordem_processo, data_inicio
 		 </cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca processos relacionados aos recursos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 18/12/2006
	--->
	<cffunction name="get_processos_recursos" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pr.item_id,
				   pr.processo_id,
				   pr.especialidade_id,
				   pr.nivel_id,
				   pr.quantidade,
				   pr.percentual_participacao,
				   p.titulo as titulo_processo,
				   p.detalhamento,
				   manutencao.to_tempo_execucao(p.tempo_execucao, 3) .retorno as tempo_execucao,
				   a.atividade_id,
				   a.cod_atividade,
				   a.titulo,
				   re.descricao as descricao_especialidade,
				   rn.descricao as descricao_nivel,
				   ag.grupo_id,
				   ag.descricao
			  from manutencao.v$processo_recurso pr
			 inner join manutencao.v$processo p
			 			on pr.processo_id = p.processo_id
			 inner join manutencao.v$atividade_processo ap
			 			on ap.processo_id = p.processo_id
			 inner join manutencao.v$atividade a
			 			on a.atividade_id = ap.atividade_id
			 inner join manutencao.v$recurso_especialidade re
			 			on re.especialidade_id = pr.especialidade_id
			 inner join manutencao.v$recurso_nivel rn
			 			on rn.nivel_id = pr.nivel_id
			 inner join manutencao.v$atividade_grupo ag
            			on ag.grupo_id = a.grupo_id
			 where 1 = 1
 			<cfif len(Trim(arguments.ATIVIDADE_ID))>
			  and a.atividade_id = #arguments.ATIVIDADE_ID#
			</cfif>
			order by ag.descricao, a.titulo, p.titulo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividades executadas
	-- NOTAS EXPLICATIVAS
	-- GUTO 31/01/2007
	--->
	<cffunction name="get_atividades_executadas" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="">
		<cfargument name="DATA_INICIO" required="no" default="">
		<cfargument name="DATA_FIM" required="no" default="">
		<cfargument name="PLACA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select placa, ordem_servico_id, num_ordem_servico, atividade, km_execucao,
				   nvl(lag(km_execucao) over(partition by placa order by placa, data_execucao),0) as km_anterior,
				   data_execucao,
				   nvl(lag(data_execucao) over(partition by placa order by placa, data_execucao),data_execucao) as data_anterior
			from (
				  select os.ordem_servico_id, e.cod_equipamento as placa, os.num_ordem_servico, os.data_abertura as data_execucao, a.cod_atividade || '-' || a.titulo as atividade,
						 (select nvl(max(km), 0)
							from oper.v$veiculo_km
						   where placa = e.cod_equipamento
							 and data_hora <= os.data_abertura) as km_execucao
					from manutencao.v$equipamento_atividade ea
				   inner join manutencao.v$atividade a
						   on a.atividade_id = ea.atividade_id
				   inner join manutencao.v$ordem_servico os
						   on os.ordem_servico_id = ea.ordem_servico_id_execucao
				   inner join almoxarifado.v$equipamento e
						   on e.equipamento_id = os.equipamento_id
				  where 1=1
                 <cfif len(trim(arguments.ATIVIDADE_ID))>
                    and a.atividade_id = #arguments.ATIVIDADE_ID#
                 </cfif>
                  )
             where 1=1
			 <cfif Len(Trim(arguments.DATA_INICIO))>
			   and data_execucao >= '#arguments.DATA_INICIO#'
			 </cfif>
			 <cfif Len(Trim(arguments.DATA_FIM))>
			   and data_execucao <= '#arguments.DATA_FIM#'
			 </cfif>
			 <cfif Len(Trim(arguments.PLACA))>
			   and placa = '#arguments.PLACA#'
			 </cfif>
			order by placa, data_execucao
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Veculos que possuem uma determinada atividade.
	-- NOTAS EXPLICATIVAS
	-- WAGNER 29/12/2006
	--->
	<cffunction name="get_atividade_veiculo" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="">
		<cfargument name="MODALIDADE" required="no" default="">
		<cfargument name="STATUS_ID" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select *
                  from (
                select /*+ ORDERED */
					   r.equipamento_id,
					   r.controle_id,
					   r.cod_equipamento,
					   r.atividade_id,
					   r.posicao_id,
					   r.posicao,
					   r.cod_atividade,
					   r.titulo,
					   r.data_previsao,
					   r.km_previsao,
					   r.importancia,
					   r.alerta_km,
					   r.alerta_dias,
					   r.dias,
					   case
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo > r.km_previsao or
							  r.km_previsao < r.km_atual_veiculo or
							  (sysdate > r.data_previsao and
							  manutencao.to_manut_atividade(r.atividade_id)
							  .garantia_dias > 0) then -2
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo +
							  manutencao.to_manut_atividade(r.atividade_id)
							  .alerta_km > r.km_previsao or
							  (sysdate + manutencao.to_manut_atividade(r.atividade_id)
							  .alerta_dias > r.data_previsao and
							   manutencao.to_manut_atividade(r.atividade_id)
							  .garantia_dias > 0) then -1
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo <= r.km_previsao or
							  sysdate <= r.data_previsao then 1
						   else 0 end status_id,
							  r.km_previsao - r.km_atual_veiculo as km_previsto
				  from (select e.equipamento_id,
							   ea.controle_id,
							   e.cod_equipamento,
							   a.atividade_id,
							   ap.posicao_id,
							   nvl(ap.posicao, 'nica') as posicao,
							   a.cod_atividade,
							   a.titulo,
							   ea.data_previsao,
							   ea.km_previsao,
							   a.importancia,
							   ea.ordem_servico_id_execucao,
							   (select nvl(max(km), 0)
								  from oper.v$veiculo_km
								 where placa = e.cod_equipamento
								   and data_hora < sysdate) as km_atual_veiculo,
							   manutencao.to_manut_atividade(ea.atividade_id) .alerta_km as alerta_km,
							   manutencao.to_manut_atividade(ea.atividade_id) .alerta_dias as alerta_dias,
							   decode(manutencao.to_manut_atividade(ea.atividade_id).garantia_dias,0,0,
							   round(ea.data_previsao - sysdate)) as dias
						  from manutencao.v$equipamento_atividade ea
                    inner join manutencao.v$equipamento_manutencao em
                            on ea.equipamento_id = em.equipamento_id
                           and em.controla_manutencao = 1
					inner join manutencao.v$atividade a
							on a.atividade_id = ea.atividade_id
					inner join almoxarifado.v$equipamento e
							on e.equipamento_id = ea.equipamento_id
					 left join manutencao.v$equipamento_posicao ap

							on ea.posicao_id = ap.posicao_id
						 where 1 = 1
						<cfif Len(Trim(arguments.atividade_id))>
				   		   and a.atividade_id in (#arguments.atividade_id#)
						</cfif>
						<cfif Len(Trim(arguments.importancia))>
						   and a.importancia = #arguments.importancia#
						</cfif>
	  					   and ea.ordem_servico_id_execucao is null
						) r )
                      <cfif Len(Trim(arguments.STATUS_ID))>
                      where status_id = #arguments.STATUS_ID#
                      </cfif>
                      order by cod_atividade, cod_equipamento, posicao, km_previsao
			</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca horas de recursos agrupados, para o RH
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_horas_recursos_agrupado" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
        <cfargument name="recurso_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select t.cod_pessoa, p.cliente as recurso,
				   manutencao.to_tempo_execucao(numtodsinterval(sum(tempo_pago), 'DAY'), 3) .retorno as tempo_pago,
       			   manutencao.to_tempo_execucao(numtodsinterval(sum(tempo_gasto), 'DAY'), 3) .retorno as tempo_gasto,
				   round(sum(valor_servico),2) as valor_total, ro.interna,
                   nvl((select sum(os.km_deslocamento)
                      from manutencao.v$os_atendimento os
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = os.cod_pessoa_mecanico
                     inner join manutencao.v$ordem_servico o
                             on o.ordem_servico_id = os.ordem_servico_id
                     where o.data_abertura >= '#arguments.DATA_INICIO#'
                       and o.data_abertura <= '#arguments.DATA_FIM#'
                       and os.cod_pessoa_mecanico = t.cod_pessoa),0) as km_deslocamento
			  from (
					select /*+ ordered */ pe.cod_pessoa_principal as cod_pessoa,
						   sum(sysdate + (op.tempo_execucao_ajustado * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,
				           sum(sysdate + (pe.tempo_execucao) - sysdate) as tempo_gasto,
						   sum(manutencao.to_tempo_convertido(op.tempo_execucao_ajustado*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
	                  	     on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_principal in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_principal

					UNION ALL

					select /*+ ordered */ pe.cod_pessoa_principal cod_pessoa,
						   sum(sysdate + (op.tempo_execucao_ajustado * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,
         				   sum(sysdate + (pe.tempo_execucao) - sysdate) as tempo_gasto,
						   sum(manutencao.to_tempo_convertido((op.tempo_execucao_ajustado/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
                    	    on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_principal in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_principal

					UNION ALL

					select /*+ ordered */  pe.cod_pessoa_auxiliar cod_pessoa,
						   sum(sysdate + (op.tempo_execucao_ajustado * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,
        				   sum(sysdate + (pe.tempo_execucao) - sysdate) as tempo_gasto,
						   sum(manutencao.to_tempo_convertido((op.tempo_execucao_ajustado/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
                            on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_auxiliar in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_auxiliar
					  ) t
			  inner join kss.v$pessoa p
					  on p.cod_pessoa = t.cod_pessoa
			  inner join (select distinct r.cod_pessoa as cod_pessoa_funcionario, o.interna
							from manutencao.v$recurso r
						   inner join manutencao.v$recurso_oficina ro
								   on ro.recurso_id = r.recurso_id
						   inner join manutencao.v$oficinas o
								   on o.cod_pessoa = ro.cod_pessoa_oficina
						  where ro.data_fim is null) ro
					  on ro.cod_pessoa_funcionario = p.cod_pessoa
			group by t.cod_pessoa, p.cliente, ro.interna
			order by p.cliente, ro.interna
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os Execuo de Tabelas de Manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO 13/07/2007
	--->
	<cffunction name="get_tabela_veiculo" returntype="query" access="remote">
    	<cfargument name="tabela_id" required="no" default="">
      <cfargument name="status" required="no" default="">
      <cfargument name="somente_ativos" required="no" default="0">

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_equipamento, tabela, data_previsao, km_previsao, km_atual_veiculo,
                   alerta_km, alerta_dias, intervalo_km, intervalo_dias, status_id, km_previsto, dias
              from (select cod_equipamento, tabela, data_previsao, km_previsao, km_atual_veiculo,
                           alerta_km, alerta_dias, intervalo_km, intervalo_dias,
                           case
                             when km_atual_veiculo > km_previsao
                               or sysdate > data_previsao then -2
                             when km_atual_veiculo + alerta_km > km_previsao
                               or sysdate + alerta_dias > data_previsao then -1
                             else 1 end status_id,
                           km_previsao - km_atual_veiculo as km_previsto,
                           round(data_previsao - sysdate) as dias
                      from (select e.cod_equipamento, tm.nome as tabela, et.ordem_servico_id_execucao,
                                   et.data_previsao, et.km_previsao,
                                   (select nvl(max(km), 0)
                                              from oper.v$veiculo_km
                                             where placa = e.cod_equipamento
                                               and data_hora < sysdate) as km_atual_veiculo,
                                   tm.alerta_km, tm.alerta_dias, tm.intervalo_km, tm.intervalo_dias
                              from almoxarifado.v$equipamento e
                             inner join manutencao.v$equipamento_tabela_manut et
                                     on e.equipamento_id = et.equipamento_id
                             inner join manutencao.v$tabela_manutencao tm
                                     on et.tabela_id = tm.tabela_id
                             where et.ordem_servico_id_execucao is null
                               <cfif Len(Trim(arguments.TABELA_ID))>
                               	and tm.tabela_id in (#arguments.TABELA_ID#)
                               </cfif>
                               <cfif arguments.somente_ativos eq 1>
                               	and e.data_inativacao is null
                               </cfif>
                               ) r)
             where 1=1
             <cfif Len(Trim(arguments.STATUS_ID))>
             	and status_id = #arguments.STATUS_ID#
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca relatrios de materiais
	-- WAGNER  19/02/2007
	--->
	<cffunction name="get_relatorio_materiais" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" 			required="no" default="">
		<cfargument name="data_final" 				required="no" default="">
		<cfargument name="material_id" 				required="no" default="">
		<cfargument name="modelo_id" 				required="no" default="">
		<cfargument name="operacao_tipo_id" 		required="no" default="">
		<cfargument name="cod_pessoa_filial" 		required="no" default="">
		<cfargument name="COD_PESSOA_PROPRIETARIO" 	required="no" default="">
		<cfargument name="cod_grupo" 				required="no" default="">
		<cfargument name="cod_equipamento" 			required="no" default="">
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id, ' ') as material,
                                        m.material_id, m.operacao_tipo_id,
                                        m.data_lancamento, m.quantidade,
                                        a.num_ordem_servico,
                                        case
                                            when m.operacao_tipo_id = 2 then to_number(ma.valor,'99999999D009999999999999999999999999999','nls_numeric_characters=''.,''')
                                        else almoxarifado.to_material_estoque(md.material_id).valor_unitario end unitario,
                                        case
                                            when m.operacao_tipo_id = 2 then m.quantidade * to_number(ma.valor,'99999999D009999999999999999999999999999','nls_numeric_characters=''.,''')
                                        else m.quantidade * almoxarifado.to_material_estoque(md.material_id).valor_unitario end valor_total,
                                        ot.descricao as operacao, m.observacao, m.cod_pessoa_filial,
                                        p.cliente as filial, a.empresa,
                                        a.cod_equipamento as cod_equipamento,
                                        a.equipamento_id as equipamento_id,
                                        a.cod_pessoa_proprietario,
                                        a.proprietario,a.cod_grupo, a.modelo_equipamento,
                                        manutencao.to_equipamento_dados(m.equipamento_id).cod_equipamento as identificador,
                                        a.material_equipamento, (select ag.descricao
                                                                   from table (almoxarifado.pkg_almoxarifado.fnc_material_antecessores(md.material_id)) t
                                                                  inner join almoxarifado.v$material m
                                                                          on m.material_id = t.material_id
                                                                   inner join manutencao.v$atividade_grupo ag
                                                                          on ag.grupo_id = m.grupo_id
                                                                  where rownum = 1) as sistema
                         from almoxarifado.v$material md
                 inner join almoxarifado.v$movimentacao m
                         on m.material_id = md.material_id
                 inner join kss.v$pessoa p
                         on p.cod_pessoa = m.cod_pessoa_filial
                 inner join almoxarifado.v$operacao_tipo ot
                         on ot.operacao_tipo_id = m.operacao_tipo_id
                    left join almoxarifado.v$movimentacao_atributo ma
                                                 on ma.lancamento_id = m.lancamento_id
                                                and ma.atributo_id = 23
                    left join (select om.lancamento_id_saida as lancamento_id, om.equipamento_id, e.cod_equipamento,
                                      ep.cod_pessoa_proprietario, os.grupo as cod_grupo,
                                      os.empresa, em.modelo_id, os.num_ordem_servico,
                                                        mo.descricao as modelo_equipamento, pp.cliente as proprietario, ma.descricao_completa as material_equipamento
                                                             from manutencao.v$os_material om
                                                            inner join manutencao.v$ordem_servico_grupo os
                                                             on om.ordem_servico_id = os.ordem_servico_id
                                                            inner join almoxarifado.v$equipamento e
                                                             on e.equipamento_id = os.equipamento_id
                                                            inner join almoxarifado.v$material ma
                                                                    on ma.material_id = e.material_id
                                                             left join manutencao.v$equipamento_modelo em
                                                                            on em.equipamento_id = os.equipamento_id
                                                                         and em.data_final is null
                                                            left join manutencao.v$modelo mo
                                                                   on mo.modelo_id = em.modelo_id
                                                            left join almoxarifado.v$equipamento_proprietario ep
                                                                    on ep.equipamento_id = e.equipamento_id
                                                                         and os.data_abertura	between ep.data_inicio and nvl(ep.date_fim,sysdate)
                                                            left join kss.v$pessoa pp
                                                                   on pp.cod_pessoa = ep.cod_pessoa_proprietario
                                                        union

                                                        select me.lancamento_id, me.equipamento_id, e.cod_equipamento, ep.cod_pessoa_proprietario, manutencao.pkg_manutencao.fnc_placa_grupo(e.equipamento_id,m.data_lancamento) as cod_grupo,
                                                                     1 as empresa, em.modelo_id, null as num_ordem_servico,
                                                                     mo.descricao as modelo_equipamento, pp.cliente as proprietario,
                                                                     ma.descricao_completa as material_equipamento
                                                            from almoxarifado.v$movimentacao_equipamento me
                                                            inner join almoxarifado.v$movimentacao m
                                                                            on m.lancamento_id = me.lancamento_id
                                                            inner join almoxarifado.v$equipamento e
                                                                            on e.equipamento_id = me.equipamento_id
                                                            inner join almoxarifado.v$material ma
                                                                    on ma.material_id = e.material_id
                                                            left join almoxarifado.v$equipamento_proprietario ep
                                                                         on ep.equipamento_id = e.equipamento_id
                                                                        and m.data_lancamento	between ep.data_inicio and nvl(ep.date_fim,sysdate)
                                                            left join kss.v$pessoa pp
                                                                   on pp.cod_pessoa = ep.cod_pessoa_proprietario
                                                            left join manutencao.v$equipamento_modelo em
                                                                         on em.equipamento_id = e.equipamento_id
                                                                        and em.data_final is null
                                                            left join manutencao.v$modelo mo
                                                                   on mo.modelo_id = em.modelo_id) a
                                 on a.lancamento_id = m.lancamento_id

                 where 1=1
					<cfif len(trim(arguments.MODELO_ID))>
					    and a.modelo_id = #arguments.MODELO_ID#
					</cfif>
					<cfif len(trim(arguments.COD_EQUIPAMENTO))>
					    and a.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
					</cfif>
					<cfif (len(trim(arguments.data_inicial)) and len(trim(arguments.data_final)))>
			 		    and trunc(m.data_lancamento) >= '#arguments.data_inicial#'
					    and trunc(m.data_lancamento) <= '#arguments.data_final#'
					</cfif>
					<cfif len(trim(arguments.cod_pessoa_filial))>
					    and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
					</cfif>
					<cfif len(trim(arguments.operacao_tipo_id))>
					    and m.operacao_tipo_id = #arguments.operacao_tipo_id#
					</cfif>
					<cfif len(trim(arguments.material_id))>
					    and md.material_id in(#arguments.material_id#)
					</cfif>
					<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					    and a.cod_pessoa_proprietario = #arguments.cod_pessoa_proprietario#
					</cfif>
					<cfif len(trim(arguments.cod_grupo))>
					    and a.cod_grupo in(#ListQualify(arguments.COD_GRUPO,"'")#)
					</cfif>
			</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca pessoas que so proprietarias de equipamentos na empresa
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_proprietarios" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="controla_manutencao" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select p.cod_pessoa
                 , p.cnpj_cpf
                 , p.identificador
                 , p.inscricao_estadual
                 , p.razao_social
                 , p.cliente
              from manutencao.v$proprietarios p
             where 1 = 1
			<cfif Len(Trim(arguments.controla_manutencao))>
               and (oper.pkg_agregado.fnc_consulta_valor(40, sysdate, p.cod_pessoa, 1) = #arguments.controla_manutencao#
                    or exists (select 1
                                 from kss.v$pessoa_modalidade pm
                                where pm.cod_pessoa = p.cod_pessoa
                                  and pm.num_modalidade in (9,23)
                              )
                   )
			</cfif>
             order by p.cliente
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais inseridos em OSs externas
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_material_externo" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="DATA_INICIO" required="no" default=""/>
		<cfargument name="DATA_FIM" required="no" default=""/>
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="no" default=""/>
		<cfargument name="COD_PESSOA_OFICINA" required="no" default=""/>
		<cfargument name="MATERIAL_ID" required="no" default=""/>
		<cfargument name="COD_EQUIPAMENTO" required="no" default=""/>
		<cfargument name="MODELO_ID" required="no" default=""/>
		<cfargument name="GRUPO" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
              select /*+ ORDERED USE_HASH(OS OM M)  */
                         'Material Externo' as tipo,
                             oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) as grupo,
                             m.descricao_completa as material, m.material_id, os.num_ordem_servico,
                   os.data_abertura, om.quantidade, om.valor_unitario,
                   om.valor_total, e.cod_equipamento as placa, p.cod_pessoa as cod_pessoa_oficina,
                             p.cliente as oficina, pp.cliente as empresa,
                             mo.descricao as modelo_equipamento, me.descricao_completa as material_equipamento,
                             manutencao.to_equipamento_dados(om.equipamento_id).cod_equipamento as identificador,
                             om.equipamento_id as equipamento_id_montado,
                   (select ag.descricao
                      from table (almoxarifado.pkg_almoxarifado.fnc_material_antecessores(om.material_id)) t
                     inner join almoxarifado.v$material m
                             on m.material_id = t.material_id
                     inner join manutencao.v$atividade_grupo ag
                             on ag.grupo_id = m.grupo_id
                     where rownum = 1) as sistema
                from manutencao.v$ordem_servico_grupo os
               inner join manutencao.v$os_material om
                   on om.ordem_servico_id = os.ordem_servico_id
               inner join almoxarifado.v$material m
                   on m.material_id = om.material_id
               inner join almoxarifado.v$equipamento e
                   on e.equipamento_id = os.equipamento_id
                     inner join almoxarifado.v$material me
                             on me.material_id = e.material_id
               inner join almoxarifado.v$equipamento_proprietario epa
                   on epa.equipamento_id = e.equipamento_id
                   and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
               inner join kss.v$pessoa pp
                   on pp.cod_pessoa = epa.cod_pessoa_proprietario
               inner join kss.v$pessoa p
                   on p.cod_pessoa = os.cod_pessoa_oficina
                     left  join manutencao.v$equipamento_modelo em
                                     on em.equipamento_id = e.equipamento_id
                                    and em.data_final is null
                     left join manutencao.v$modelo mo
                                     on mo.modelo_id = em.modelo_id

              where os.empresa = 0
   			  <cfif Len(Trim(arguments.DATA_INICIO))>
			  	and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
			  </cfif>
			  <cfif Len(Trim(arguments.DATA_FIM))>
			  	and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
			  </cfif>
			  <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
				 and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_OFICINA#)
			  </cfif>
			  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
				 and epa.cod_pessoa_proprietario in (#arguments.COD_PESSOA_PROPRIETARIO#)
			  </cfif>
			  <cfif Len(Trim(arguments.MATERIAL_ID))>
			  	and m.material_id in (#arguments.MATERIAL_ID#)
			  </cfif>
			  <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
			  	and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
			  </cfif>

			  <cfif Len(Trim(arguments.MODELO_ID))>
			  	and em.modelo_id = #arguments.MODELO_ID#
			  </cfif>
			  <cfif Len(Trim(arguments.GRUPO))>
			     and os.grupo in(#ListQualify(arguments.GRUPO,"'")#)
			  </cfif>
			order by os.data_abertura
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Relatrio de fechamento de custo de OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 26/11/2007
	--->
	<cffunction name="get_os_fechamento_custo" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
		<cfargument name="empresa" required="no" default=""/>
		<cfargument name="socorro" required="no" default=""/>
		<cfargument name="COD_PESSOA_OFICINA" required="no" default=""/>
		<cfargument name="COD_PESSOA_FORNECEDOR" required="no" default=""/>
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="no" default=""/>
		<cfargument name="COD_EQUIPAMENTO_ATRIBUIDO" required="no" default=""/>
		<cfargument name="tipo_tabela_revisao_os" required="no" default=""/>
		<cfargument name="grupo" required="no" default=""/>
		<cfargument name="modelo_id" required="no" default=""/>
		<cfargument name="equipamento_id" required="no" default=""/>
		<cfargument name="cod_equipamento" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.ordem_servico_id, o.equipamento_id, o.cod_equipamento,
            	   /*manutencao.to_veiculo_km(o.cod_equipamento,o.data_abertura,o.data_abertura).km_data_inicial as km_abertura,*/
                   o.km_rodado as km_abertura,
                   o.data_abertura, o.grupo, o.data_abertura, o.tipo_os, o.num_nota_fiscal,
                     o.num_ordem_servico, o.custo_servico, o.custo_material,
                     o.modelo, o.material, o.oficina,
                     o.ap.ordem_servico_id as aprop_ordem_servico_id,
                     o.ap.num_ordem_servico as aprop_num_ordem_servico,
                     o.ap.cod_equipamento as aprop_cod_equipamento,
                     o.ap.modelo as aprop_modelo,
                     o.ap.material as aprop_material,
                     o.ap.grupo as aprop_grupo, km_revisao_ct,
                     (select decode(nvl(min(tm.tipo_execucao),0),1,'Completa',2,'Parcial','')
                        from manutencao.v$os_tabela_manutencao ot
                       inner join manutencao.v$tabela_manutencao tm
                               on tm.tabela_id = ot.tabela_id
                       where ot.ordem_servico_id = o.ordem_servico_id
                       and tm.tipo_execucao > 0) as tabela_execucao
              from ( select os.ordem_servico_id, e.equipamento_id, e.cod_equipamento, nft.num_nota_fiscal, os.km_revisao_ct,
                                             oper.pkg_pneu.fnc_placa_grupo(e.cod_equipamento, os.data_abertura) as grupo,
                                             os.data_abertura,
                                             os.km_rodado,
                                             case
                                                 when os.socorro = 1 then 'Socorro'
                                                 when os.empresa = 1 then 'Atendimento'
                                                 when os.empresa = 0 then 'Externo'
                                             else '' end tipo_os, os.num_ordem_servico,
                                             case
                                               when socorro = 1 then round((select sum((manutencao.to_tempo_convertido(p.tempo_execucao_ajustado).horas * ev.valor_empresa) * pr.percentual_participacao / 100) as valor
                                                              from manutencao.v$os_processos p
                                                              inner join manutencao.v$processo_recurso pr
                                                                  on pr.item_id = p.processo_recurso_id
                                                              inner join manutencao.v$especialidade_valor ev
                                                                  on ev.especialidade_id = pr.especialidade_id
                                                                  and ev.nivel_id = pr.nivel_id
                                                             where p.ordem_servico_id = os.ordem_servico_id),2)
                                               when empresa = 1 then
                                                     nvl((select /*+ ordered */ sum(ova.valor_pago)
                                                            from manutencao.v$os_valor_processo ova
                                                     where ova.ordem_servico_id = os.ordem_servico_id),0)
                                             else os.valor_servico end custo_servico,
                                             case
                                               when empresa = 1 then
                                                            nvl((select sum(almoxarifado.to_material_estoque(om.material_id).valor_unitario*om.quantidade)
                                                                   from manutencao.v$os_material om
                                                                  where om.ordem_servico_id = os.ordem_servico_id),0)
                                             else nvl((select sum(om.valor_total)
                                                         from manutencao.v$os_material om
                                                        where om.ordem_servico_id = os.ordem_servico_id),0) end custo_material,
                                             mo.descricao as modelo, m.descricao_completa as material, p.cliente as oficina,
                                             case
                                                 when to_number(m.veiculo) = 1 then null
                                                 when to_number(m.veiculo) = 0 then manutencao.to_os_custo(os.EQUIPAMENTO_ID,os.data_abertura)
                                             end ap
                                    from manutencao.v$ordem_servico os
                                    inner join almoxarifado.v$equipamento e
                                                    on e.equipamento_id = os.equipamento_id
                                    inner join almoxarifado.v$equipamento eat
                                                    on eat.equipamento_id = os.equipamento_id_aprop
                                    inner join almoxarifado.v$material_dados m
                                                    on m.material_id = e.material_id
                                    inner join kss.v$pessoa p
                                                    on p.cod_pessoa = os.cod_pessoa_oficina
                                   <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
                                    inner join almoxarifado.v$equipamento_proprietario epa
                                                    on epa.equipamento_id = os.equipamento_id
                                                   and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
                                    inner join table(oper.fnc_empresa_completo(#arguments.COD_PESSOA_PROPRIETARIO#)) e
                                            on e.column_value = epa.cod_pessoa_proprietario
                                    </cfif>
                                    left join manutencao.v$equipamento_modelo em
                                                    on em.equipamento_id = e.equipamento_id
                                                 and em.data_final is null

                                    left join manutencao.v$modelo mo
                                                 on mo.modelo_id = em.modelo_id
                                    left join fiscal.v$nf_terceiro nft
                                           on nft.num_nota_id = os.num_nota_id
                                where 1=1
                                <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
                                  and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
                                </cfif>
                                <cfif Len(Trim(arguments.COD_EQUIPAMENTO_ATRIBUIDO))>
                                  and eat.cod_equipamento = '#arguments.COD_EQUIPAMENTO_ATRIBUIDO#'
                                </cfif>
                                <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
                                  and os.equipamento_id = #arguments.EQUIPAMENTO_ID#
                                </cfif>
                                <cfif Len(Trim(arguments.DATA_INICIO))>
                                  and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
                                </cfif>
                                <cfif Len(Trim(arguments.DATA_FIM))>
                                  and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
                                </cfif>
                                <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
                                  and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_OFICINA#)
                                </cfif>
                                <cfif Len(Trim(arguments.COD_PESSOA_FORNECEDOR))>
                                  and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_FORNECEDOR#)
                                </cfif>
                                <cfif Len(Trim(arguments.SOCORRO))>
                                  and os.socorro = #arguments.SOCORRO#
                                </cfif>
                                <cfif Len(Trim(arguments.EMPRESA))>
                                  and os.empresa = #arguments.EMPRESA#
                                </cfif>
                                <cfif Len(Trim(arguments.MODELO_ID))>
                                  and em.modelo_id in (#arguments.MODELO_ID#)
                                </cfif>
								<cfif Len(Trim(arguments.tipo_tabela_revisao_os))>
                                    <cfswitch expression="#arguments.tipo_tabela_revisao_os#">
                                       <cfcase value="1">
                                          and exists (select 1
                                                        from manutencao.v$os_tabela_manutencao tm
                                                       inner join manutencao.v$tabela_manutencao t
                                                               on t.tabela_id = tm.tabela_id
                                                              and t.atualiza_revisao = 1
                                                       where tm.ordem_servico_id = os.ordem_servico_id)
                                       </cfcase>
                                       <cfcase value="0">
                                          and not exists (select 1
                                                            from manutencao.v$os_tabela_manutencao tm
                                                           inner join manutencao.v$tabela_manutencao t
                                                                   on t.tabela_id = tm.tabela_id
                                                                  and t.atualiza_revisao = 1
                                                           where tm.ordem_servico_id = os.ordem_servico_id)
                                       </cfcase>
                                     </cfswitch>
                                </cfif>
                                ) o
                                where 1=1
                                <cfif Len(Trim(arguments.grupo))>
                                  and o.grupo in (#ListQualify(arguments.grupo,"'",",")#)
                                </cfif>

        </cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca servicos executados
	-- GUTO  15/02/2007
	--->
	<cffunction name="get_relatorio_atividade" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="cod_pessoa_oficina" required="no" default="">
		<cfargument name="grupo" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="cod_pessoa_proprietario" required="no" default="">
		<cfargument name="verificacao" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo, ordem_servico_id, num_nota_fiscal,grupo, num_ordem_servico, atividade_id, atividade, posicao, data_abertura,
                          importancia, verificacao, grupo_id, compartimento_id, cod_equipamento, filial, empresa,
                          valor_rateio, horas, proprietario, modelo_equipamento, material, sistema,
                       case
                        when a.empresa = 1 then
                          round(manutencao.to_tempo_convertido(a.tempo_execucao_ajustado).horas * (select avg(decode(a.empresa,1,ova.valor_empresa,ova.valor_terceiro))
                                                                from manutencao.mv$os_valor_atividade ova
                                                               where ova.ordem_servico_id = a.ordem_servico_id
                                                                and ova.atividade_id = a.atividade_id),2)
                       else 0
                       end valor
                     from (
                   select /*+ USE_HASH(E M) USE_HASH(OS P) */
                                      'Servio' as tipo,
                                      os.ordem_servico_id, nft.num_nota_fiscal,
                                      oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) as grupo,
                                      os.num_ordem_servico,
                                      a.atividade_id,
                                      a.titulo as atividade,
                                      ep.posicao,
                                      os.data_abertura,
                                      a.importancia,
                                      a.verificacao,
                                      a.grupo_id,
                                      a.compartimento_id,
                                      e.cod_equipamento,
                                      p.cliente as filial, os.empresa,
                                      oa.tempo_execucao_ajustado,
                                      round(os.valor_servico / decode((select count(*)
                                                                          from manutencao.v$os_atividade oa2
                                                                         where oa2.ordem_servico_id = os.ordem_servico_id),0,1,(select count(*)
                                                                          from manutencao.v$os_atividade oa2
                                                                         where oa2.ordem_servico_id = os.ordem_servico_id)),2) as valor_rateio,
                                      manutencao.to_tempo_execucao(oa.tempo_execucao_ajustado,3).retorno as horas,
                                      pp.cliente as proprietario, mo.descricao as modelo_equipamento,
                                      m.descricao_completa as material, mg.descricao as sistema
                                  from almoxarifado.v$equipamento e
                                  inner join almoxarifado.v$material m
                                          on m.material_id = e.material_id
                                  inner join manutencao.v$ordem_servico os
                                          on e.equipamento_id = os.equipamento_id
                                  inner join kss.v$pessoa p
                                         on p.cod_pessoa = os.cod_pessoa_oficina
                                  inner join almoxarifado.v$equipamento_proprietario epa
                                      on epa.equipamento_id = e.equipamento_id
                                     and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
                                  inner join kss.v$pessoa pp
                                          on pp.cod_pessoa = epa.cod_pessoa_proprietario
                                  left join manutencao.v$os_atividade oa
                                      on oa.ordem_servico_id = os.ordem_servico_id
                                  left join manutencao.v$atividade a
                                      on a.atividade_id = oa.atividade_id
                                  left join manutencao.v$atividade_grupo mg
                                         on mg.grupo_id = a.grupo_id
                                  left join fiscal.v$nf_terceiro nft
                                         on nft.num_nota_id = os.num_nota_id
                                  left join manutencao.v$equipamento_posicao ep
                                      on nvl(ep.posicao_id,0) = nvl(oa.posicao_id,0)
                                  left join manutencao.v$equipamento_modelo em
                                         on em.equipamento_id = e.equipamento_id
                                        and em.data_final is null
                                  left join manutencao.v$modelo mo
                                         on mo.modelo_id = em.modelo_id
                                   where 1=1
					  <cfif Len(Trim(arguments.DATA_INICIO))>
                       and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
                      </cfif>
                      <cfif Len(Trim(arguments.DATA_FIM))>
                       and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
                      </cfif>
                      <cfif Len(Trim(arguments.ATIVIDADE_ID))>
                       and a.atividade_id in (#arguments.ATIVIDADE_ID#)
                      </cfif>
                      <cfif Len(Trim(arguments.VERIFICACAO))>
                       and a.verificacao = #arguments.VERIFICACAO#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
                       and epa.cod_pessoa_proprietario = #arguments.COD_PESSOA_PROPRIETARIO#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
                       and os.cod_pessoa_oficina = #arguments.COD_PESSOA_OFICINA#
                      </cfif>
                      <cfif Len(Trim(arguments.EMPRESA))>
                       and os.empresa = #arguments.EMPRESA#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
                       and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
                      </cfif>
                      <cfif Len(Trim(arguments.MODELO_ID))>
                       and em.modelo_id = #arguments.MODELO_ID#
                      </cfif>
                               <cfif Len(Trim(arguments.GRUPO))>
                       and oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) = '#arguments.GRUPO#'
                      </cfif> ) a
			  order by a.num_ordem_servico
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca todas as atividades vinculadas ao equipamento
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 13/05/2010 - ALTERADO
	--->
	<cffunction name="get_tabela_atividade_posicao" returntype="query" access="remote">
		<cfargument name="TABELA_ID" required="no" default="" >
        <cfargument name="TABELAS_ARVORE" required="no" default="0" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct <cfif arguments.TABELAS_ARVORE eq 0>ta.tabela_id,</cfif> a.atividade_id, a.titulo as atividade, ep.posicao_id, ep.posicao
              from manutencao.v$tabela_atividade ta
             inner join manutencao.v$atividade a
                     on a.atividade_id = ta.atividade_id
              left join manutencao.v$atividade_posicao ap
                     on ap.atividade_id = a.atividade_id
              left join manutencao.v$equipamento_posicao ep
                     on ep.posicao_id = ap.posicao_id
			 where 1 = 1
			  <cfif Len(Trim(arguments.TABELA_ID))>
			     <cfif arguments.TABELAS_ARVORE eq 0>
                    and ta.tabela_id = #arguments.TABELA_ID#
                 <cfelse>
                    and ta.tabela_id in (select tm.tabela_id
                                           from manutencao.v$tabela_manutencao tm
                                          start with tm.tabela_id = #arguments.TABELA_ID#
                                        connect by prior tm.tabela_pai = tm.tabela_id
                                        )
            </cfif>
              </cfif>

             order by ep.posicao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados do fechamento para relatorio
	-- NOTAS EXPLICATIVAS
	-- IGOR 27/10/2008
	--->
	<cffunction name="get_contrato_fechamento_relatorio" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select fi.item_id,
                oper.pkg_veiculo.fnc_get_cod_veiculo(fi.placa) as cod_equipamento,
                fi.placa,
                f.fechamento_id,
                f.contrato_id,
                fi.km_inicial, fi.km_final, fi.km_final-fi.km_inicial as km_rodado,
                fi.tabela_id, fi.num_faixa, fi.valor_km,
                fi.valor_km * (fi.km_final-fi.km_inicial) as total,
                to_char(f.data_fechamento,'dd/mm/yyyy') as data_fechamento,
                to_char(f.data_inicial,'dd/mm/yyyy') as data_inicial,
                to_char(f.data_final,'dd/mm/yyyy') as data_final,
                nvl(f.valor_acordo,0) valor_acordo, nvl(f.desconto,0) desconto,
                nvl(f.total_acordo,0) as total_acordo, c.titulo as contrato,
                to_char(f.data_inicial,'dd/mm/yyyy') || ' at ' || to_char(f.data_final,'dd/mm/yyyy') as periodo
            from manutencao.v$contrato_fechamento f
            inner join manutencao.v$contrato_fechamento_it fi
                  on fi.fechamento_id = f.fechamento_id
            inner join manutencao.v$contrato_manutencao c
                  on c.contrato_id = f.contrato_id
            where 1=1
             <cfif Len(Trim(arguments.fechamento_id))>
			   and f.fechamento_id = #arguments.fechamento_id#
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca veculos p/ manuteno/controle de estoque
	-- JAQUELINEF 18/10/2013
	--->
	<cffunction name="get_veiculos" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="placa" required="no" default="">
		<cfargument name="sem_modelo" required="no" default="0">
        <cfargument name="equipamento" required="no" default="">
        <cfargument name="analisados" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.equipamento_id
                 , m.cod_equipamento
                 , m.placa
                 , ma.material
                 , (select ce.contrato_id
                      from manutencao.v$contrato_equipamento ce
                     where ce.equipamento_id = m.equipamento_id
                       and ce.data_termino is null) as contrato_id
                  , vm.marca
                  , vmo.modelo
              from almoxarifado.v$equipamento m
             inner join oper.v$veiculo v
                on v.cod_veiculo = m.cod_equipamento
             inner join oper.v$veiculo_marca vm
                on vm.marca_id =v.marca_id
             inner join almoxarifado.v$material_dados ma
                     on ma.material_id = m.material_id
             inner join oper.v$veiculo_modelo vmo
                on vmo.modelo_id = v.modelo_id
            <cfif Len(trim(arguments.analisados))>
              left join manutencao.v$equipamento_analise ea
                     on ea.equipamento_id = m.equipamento_id
            </cfif>
             where 1 = 1
            <cfif Len(Trim(arguments.equipamento_id))>
               and m.equipamento_id = #arguments.equipamento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
               and m.cod_equipamento = '#arguments.cod_equipamento#'
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (m.cod_equipamento = '#arguments.placa#'
                    or m.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
                   )
            </cfif>
            <cfif arguments.sem_modelo eq 1>
               and not exists (select 'x'
                                 from manutencao.v$equipamento_modelo em
                                where em.equipamento_id = m.equipamento_id
                                  and em.data_final is null)
            </cfif>
            <cfif Len(trim(arguments.equipamento))>
               and upper(ma.material) like upper('%#arguments.equipamento#%')
            </cfif>
            <cfif Len(trim(arguments.analisados))>
               and ea.data_analise is null
            </cfif>
             order by ma.material, m.cod_equipamento
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>


</cfcomponent>
