<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init" output="yes">
	<!--- 
	-- PROPSITO
	-- Consulta o funcionrio pelo cdigo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_funcionario" displayname="Consulta funcionrio pelo cdigo" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no" default="">
		<cfargument name="pessoa" required="no" default="0">
		<cfargument name="nome" required="no" default="">
		<cfargument name="ativos" required="no" default="0">
		<cfargument name="filtro" required="no" default="">
        <cfargument name="num_modalidade" required="no" default="">
		<cfif arguments.pessoa EQ 0>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				<cfif session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/' or session.site eq 'braf/'>
				    select distinct fma.num_matricula as cod_funcionario
					     , f.nome_funcionario
						 , f.cpf_funcionario
						 , f.cod_pessoa
						 , f.cod_entreposto as empresa
				         , (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
					          from folha.v$funcionario_organizacional fo
						     where fo.funcionario_id = f2.funcionario_id ) as organizacional_id
					     , (select o.cod_organizacional
					     	  from kss.v$organizacional o
						     where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
							                                from folha.v$funcionario_organizacional fo
													       where fo.funcionario_id = f2.funcionario_id )) as cod_organizacional
					     , (select kss.pkg_organizacional.fnc_descricao_completa(o.organizacional_id)
					      	  from kss.v$organizacional o
						     where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
							                    		    from folha.v$funcionario_organizacional fo
													       where fo.funcionario_id = f2.funcionario_id )) as descricao
                      from oper.v$rh_funcionario f
                      left join kss.v$funcionario_matr_atual fma
                        on fma.cod_pessoa = f.cod_pessoa
				      left join folha.v$funcionario f2
                        on f2.cod_pessoa = f.cod_pessoa
                     where 1 = 1
                <cfelse>
				    <cfif session.site eq 'bbmtransportes/'>
				        select distinct f.cod_funcionario
						     , f.nome_funcionario
							 , f.cpf_funcionario
							 , f.cod_pessoa
							 , f.cod_entreposto as empresa
					         , (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
					              from folha.v$funcionario_organizacional fo
						         where fo.funcionario_id = f2.funcionario_id ) as organizacional_id
					         , (select o.cod_organizacional
					              from kss.v$organizacional o
						         where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
						         					            from folha.v$funcionario_organizacional fo
								                               where fo.funcionario_id = f2.funcionario_id )) as cod_organizacional
					         , (select kss.pkg_organizacional.fnc_descricao_completa(o.organizacional_id)
						          from kss.v$organizacional o
						         where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
						           						        from folha.v$funcionario_organizacional fo
											                   where fo.funcionario_id = f2.funcionario_id )) as descricao
				          from oper.v$rh_funcionario f
			              left join folha.v$funcionario f2
                            on f2.cod_pessoa = f.cod_pessoa
				         where 1=1
				    <cfelseif session.site eq 'transemba/' or session.site eq 'axon/'>
                        select fd.matricula as cod_funcionario
                             , fd.nome as nome_funcionario
                             , fd.cpf as cpf_funcionario
                             , fd.cod_pessoa
                             , fd.cod_pessoa_empresa as empresa
					 	     , (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
						          from folha.v$funcionario_organizacional fo
							     where fo.funcionario_id = fd.funcionario_id ) as organizacional_id
						     , (select o.cod_organizacional
						          from kss.v$organizacional o
							     where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
							         					        from folha.v$funcionario_organizacional fo
									                           where fo.funcionario_id = fd.funcionario_id )) as cod_organizacional
						     , (select kss.pkg_organizacional.fnc_descricao_completa(o.organizacional_id)
							      from kss.v$organizacional o
							     where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
							           						    from folha.v$funcionario_organizacional fo
												               where fo.funcionario_id = fd.funcionario_id )) as descricao
                          from folha.v$funcionario_dados fd
                         where fd.data_demissao is null
                 	    <cfif Len(Trim(session.cod_pessoa))>
                   		   and fd.cod_pessoa_empresa = #session.cod_pessoa#
                        </cfif>
				    <cfelse>
						select distinct oper.pkg_global.fnc_get_cod_funcionario(f.cod_pessoa) as cod_funcionario
						     , f.nome_funcionario
							 , f.cpf_funcionario
							 , f.cod_pessoa
							 , f.cod_entreposto as empresa
						     , (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
						          from folha.v$funcionario_organizacional fo
							     where fo.funcionario_id = f2.funcionario_id ) as organizacional_id
						     , (select o.cod_organizacional
						          from kss.v$organizacional o
							     where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
							         					        from folha.v$funcionario_organizacional fo
									                           where fo.funcionario_id = f2.funcionario_id )) as cod_organizacional
						     ,  (select kss.pkg_organizacional.fnc_descricao_completa(o.organizacional_id)
							       from kss.v$organizacional o
							      where o.organizacional_id = (select max(fo.organizacional_id) keep(dense_rank last order by fo.data)
							           						     from folha.v$funcionario_organizacional fo
												                where fo.funcionario_id = f2.funcionario_id )) as descricao
					      from oper.v$rh_funcionario f
					      left join folha.v$funcionario f2
                            on f2.cod_pessoa = f.cod_pessoa   
				          left join folha.v$funcionario_rescisao  fr
                            on fr.funcionario_id = f2.funcionario_id		
					     where fr.data_demissao is null
					       and exists (select 1
                                         from kss.v$pessoa_modalidade pm
                                        where pm.cod_pessoa = f.cod_pessoa
									      and pm.num_modalidade in (1,4,6)
									      and pm.situacao = 1)   			  
						<cfif Len(Trim(arguments.FILTRO))>
							<cfif IsNumeric(arguments.FILTRO)>
						   and f.cod_funcionario = #arguments.FILTRO#
							<cfelse>
						   and upper(kss.pkg_string.fnc_string_clean(f.nome_funcionario)) like upper('%#arguments.FILTRO#%')
							</cfif>
						</cfif>
				    </cfif>
                </cfif>
				<cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and session.site neq 'ouroverde/' and session.site neq 'transgires/' and session.site neq 'transemba/' and session.site neq 'vialacteos/' and session.site neq 'axon/'>
				   and (to_char(f.cod_funcionario) = '#arguments.cod_funcionario#' or oper.pkg_global.fnc_get_cod_funcionario(f.cod_pessoa) = '#arguments.cod_funcionario#')
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/')>
				   and fma.num_matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'transemba/' or session.site eq 'axon/')>
				   and fd.matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif Len(Trim(arguments.num_modalidade)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'braf/')>
                   and fma.num_modalidade in (#arguments.num_modalidade#)
                </cfif>
				<cfif len(trim(arguments.nome)) and session.site neq 'transemba/' and session.site neq 'axon/'>
				   and upper(f.nome_funcionario) like upper('%#arguments.nome#%')
                <cfelseif len(trim(arguments.nome))>
                   and upper(fd.nome) like upper('%#arguments.nome#%')
				</cfif>
				<cfif session.site neq 'transemba/' and session.site neq 'axon/' and session.site eq 'bbmtransportes/' and Isdefined("arguments.ativos") and arguments.ativos eq 1>
				   and exists (select 1
                                 from oper.v$rh_funcionario fnc
                                where fnc.cod_funcionario = f.cod_funcionario
                                  and exists (select mrh.cod_pessoa
                                                from oper.v$motorista_reg_historico mrh
                                               where cod_registro = to_char(fnc.cod_funcionario)
                                                 and mrh.data_fim is null)
                                   or exists (select distinct pf.cod_pessoa
                                                from kss.pessoa_fisica pf
                                               inner join oper.v$rh_funcionario rhf
                                                  on pf.cpf = substr(rhf.cpf_funcionario, 1, 9)
                                                 and pf.cpf_dv = substr(rhf.cpf_funcionario, 10, 2)
                                               where rhf.cod_funcionario = to_char(fnc.cod_funcionario)
                                                 and rhf.data_demissao is null)
                                   or exists (select distinct pa.cod_pessoa_motorista
                                                from oper.v$agregado_motorista pa
                                               inner join kss.v$pessoa_modalidade psm
                                                  on psm.cod_pessoa = pa.cod_pessoa_motorista
                                                 and psm.situacao = 1
                                               where pa.cod_pessoa_motorista = fnc.cod_funcionario))
				</cfif>
                <cfif session.site neq 'transemba/' and session.site neq 'axon/'>
				 order by f.nome_funcionario
                <cfelse>
				 order by fd.nome
				</cfif>
			</cfquery>  
			<cfif qr_funcionario.RecordCount  EQ 0 and len(trim(arguments.cod_funcionario)) and session.site neq 'transemba/' 
			  and (not Isdefined("arguments.ativos") or arguments.ativos neq 1)
			and session.site neq 'vialacteos/' and session.site neq 'axon/' and session.site neq 'transgires/'>
				<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
					select p.cod_pessoa as cod_funcionario, p.nome as nome_funcionario, p.cod_pessoa, 0 as empresa
					   , null as organizacional_id
                       , null as cod_organizacional
                       , null as descricao
					 from kss.v$pessoa_fisica p
						where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
				</cfquery>			
			</cfif>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa as cod_funcionario, p.nome as nome_funcionario, p.cod_pessoa, 0 as empresa
				 from oper.v$pessoa_fisica p
				 where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#) 
			</cfquery>			
		</cfif>			
		
		<cfreturn qr_funcionario>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Lista filiais
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 24/02/2006 - criado
	--->	
	<cffunction name="get_filial" displayname="Lista filiais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa,
				   razao_social,
				   nome,
				   identificador,
				   cnpj_cpf,
				   inscricao_estadual,
				   endereco,
				   bairro,
				   cep,
				   municipio,
				   uf,
				   municipio_uf,
				   municipio_id,
				   telefone,
				   pais_id,
				   pais,
				   filial
			  from oper.v$filial
			 where 1=1
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif len(trim(arguments.nome))>
			   and upper(razao_social) like upper('%#arguments.nome#%')
			 </cfif>
		     order by nome, razao_social, municipio_uf			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    
    
 </cfcomponent>
