<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">    
    <!--- 
	-- PROPSITO 
	-- Busca estrutura organizacional
	-- GUTO 29/05/2009
	--->		
	<cffunction name="get_organizacional" access="remote" returntype="query" output="true">
    	<cfargument name="organizacional_id" required="no" default="" />
        <cfargument name="operacao_id" required="no" default="" />
        <cfargument name="multipla_consulta" required="no" default="0" hint="0-Busca de pelo ID e/ou pela operao separadamente; 1-Busca pelo ID e pela operao juntamente;" />
        <cfargument name="entrada_saida" required="no" default="" hint="0-Entrada; 1-Sada;" />
        <cfargument name="somente_ativos" required="no" default="0">
        <cfargument name="somente_folhas" required="no" default="0">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="cod_organizacional" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.organizacional_id, o.organizacional_id_pai, 
            	   upper(o.cod_organizacional) as cod_organizacional, o.descricao,
                   substr(replace(sys_connect_by_path(o.descricao, '@@'),'@@','/'),2) as descricao_completa, 
                   /*trim(substr(sys_connect_by_path(o.cod_organizacional, '.'),2)) as codigo_completo,*/
                   connect_by_isleaf as folha
              from kss.v$organizacional o
              where 1 = 1
              	<cfif len(trim(arguments.cod_organizacional))>
                 and o.cod_organizacional = '#arguments.cod_organizacional#'
                </cfif>
                <cfif len(trim(arguments.descricao))>
                 and lower(o.descricao) like lower('%#arguments.descricao#%')
                </cfif>
				<cfif arguments.multipla_consulta eq 1>
                   and (o.organizacional_id in (#arguments.organizacional_id#)
                        or (o.organizacional_id in (select op.organizacional_id
                                                     from logistica.v$operacao_organizacional op
                                                    where op.operacao_id = #arguments.operacao_id#)
                            or not exists (select op.organizacional_id
                                             from logistica.v$operacao_organizacional op
                                            where op.operacao_id = #arguments.operacao_id#)
                           )
                       )
                <cfelse>
                    <cfif Len(Trim(arguments.organizacional_id))>
                        and o.organizacional_id in (#arguments.organizacional_id#)
                    </cfif>
                    <cfif Len(Trim(arguments.operacao_id))>
                        and (o.organizacional_id in (select op.organizacional_id
                                                       from logistica.v$operacao_organizacional op
                                                      where op.operacao_id = #arguments.operacao_id#))
                    </cfif>
                </cfif>
                <cfif Len(Trim(arguments.entrada_saida))>
                    <cfif arguments.entrada_saida eq 0>
                        and o.tipo in (0,2)
                    <cfelseif arguments.entrada_saida eq 1>
                        and o.tipo in (1,2)
                    </cfif>
                </cfif>
                <cfif arguments.somente_ativos eq 1>
                   and o.ativo = 1
                </cfif>
                <cfif arguments.somente_folhas eq 1>
                   and connect_by_isleaf = 1
                </cfif>
             start with o.organizacional_id_pai = -1
            connect by prior o.organizacional_id = o.organizacional_id_pai
            order siblings by o.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Nota fiscal de terceiro emitida
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_nf_terceiro" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nf.num_nota_id, nf.num_nota_fiscal, p.identificador, p.razao_social, p.cliente,
			       nf.calc_valor_total_nota
			  from fiscal.v$nf_terceiro nf
			 inner join kss.v$pessoa p 
						on p.cod_pessoa = nf.cod_emitente
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

</cfcomponent>