<?php
$headers = getallheaders();
$isDebug = $headers["Debug"] == 1;

/**
 * Funções uteis
 */
class Utils {

   // http://stackoverflow.com/questions/173400/how-to-check-if-php-array-is-associative-or-sequential
   public static function isAssoc($arr) {
      return array_keys($arr) !== range(0, count($arr) - 1);
   }

   // Lê os elementos de um nó recursivamente e retorna seu valor
   private static function readElement($element) {
      if(!($element["type"] == "string" || $element["type"] == "object" || $element["type"] == "array") && ($element == null || ($element."") == "" ||  strtolower($element."") == "null"))
         return null;
      if($element["type"] == "string") {
         return $element."";
      } else if($element["type"] == "number") {
            return doubleval($element);
      } else if($element["type"] == "boolean") {
         if($element."" == "true" || $element == "1" || $element == 1) {
            return true;
         } else if($element."" == "false" || $element == "0" || $element == 0) {
            return false;
         } else {
            return "";
         }
      } else if($element["type"] == "object") {
         $array = array();
         foreach ($element->children() as $key => $value) {
            $array[$key] = self::readElement($value);
         }
         return $array;
      } else if($element["type"] == "array") {
         $array = array();
         $i = 0;
         foreach ($element->children() as $key => $value) {
            $array[$i] = self::readElement($value);
            $i++;
         }
         return $array;
      } else {
         $node = dom_import_simplexml($element);
         throw new \Exception("Nó '" . $node->getNodePath() ."' não contem um tipo definido no retorno do XML." , 500);
      }
   }

   public static function xmlToArray($xml) {
      $xml = '<?xml version="1.0" encoding="ISO-8859-1"?>'.$xml;
      libxml_use_internal_errors(true);
      $xmlObj = simplexml_load_string($xml, "SimpleXMLElement", LIBXML_NOCDATA);
      if($xmlObj === false) {
         $errors = libxml_get_errors();
         throw new Exception($errors[0]->message, $errors[0]->code);
      }
      
      $result = array();
      foreach ($xmlObj->children() as $key => $element) {
         if($result[$key] == null) {
            $result[$key] = array();
         }
         $result[$key] = self::readElement($element);
      }
      return $result;
   }


   private static function readElementXml($value, &$node) {
         $type = gettype($value);
         if($type == "NULL") {
            $type = "object";
            $value = "";
         } else if($type == "integer" || $type == "float" || $type == "double") {
            $type = "number";
         } else if($type == "string") {
            // Faz nada
         } else if($type == "boolean") {
            $value = $value ? "true" : "false";
         } else if($type == "array") {
            $type = Utils::isAssoc($value) ? "object" : "array";
            foreach ($value as $key => $v) {
               $n = $node->addChild($type == "object" ? "$key" : "arrayItem");
               $result = self::readElementXml($v, $n);
               $resultType = gettype($result);
               if($resultType !== "array" && $resultType !== "object") {
                  $n[0] = $result;
               }
            }
         }
         
         if($node !== NULL)
            $node->addAttribute("type", $type);
         return $value;   
   }

   public static function arrayToXml($array, $rootElement = "response") {
      $xml = new SimpleXMLElement("<$rootElement />");
      $xml->addAttribute("type", "object");
      foreach ($array as $key => $value) {
         $node = $xml->addChild("$key");
         $result = self::readElementXml($value, $node);
         if(gettype($result) !== "array") {
            $node[0] = $result;
         }
      }
      return $xml->asXML();
   }

   public static function jsonToArray($json) {
      return json_decode($json, true);
   }

   public static function arrayToJson($array) {
      return json_encode($array);
   }

   public static function jsonToXml($json) {
      return self::arrayToXml(self::jsonToArray($json));
   }

   public static function xmlToJson($xml) {
      return self::arrayToJson(self::xmlToArray($xml));
   }

   public static function hasValue($arg, $key = null) {
      if(is_array($arg)) {
         $arg = $arg[$key];
      }
      return isset($arg) && $arg !== "";
   }

}


if (!function_exists('http_response_code')) {
   function http_response_code($code = NULL) {
      if ($code !== NULL) {
         switch ($code) {
            case 100: $text = 'Continue'; break;
            case 101: $text = 'Switching Protocols'; break;
            case 200: $text = 'OK'; break;
            case 201: $text = 'Created'; break;
            case 202: $text = 'Accepted'; break;
            case 203: $text = 'Non-Authoritative Information'; break;
            case 204: $text = 'No Content'; break;
            case 205: $text = 'Reset Content'; break;
            case 206: $text = 'Partial Content'; break;
            case 300: $text = 'Multiple Choices'; break;
            case 301: $text = 'Moved Permanently'; break;
            case 302: $text = 'Moved Temporarily'; break;
            case 303: $text = 'See Other'; break;
            case 304: $text = 'Not Modified'; break;
            case 305: $text = 'Use Proxy'; break;
            case 400: $text = 'Bad Request'; break;
            case 401: $text = 'Unauthorized'; break;
            case 402: $text = 'Payment Required'; break;
            case 403: $text = 'Forbidden'; break;
            case 404: $text = 'Not Found'; break;
            case 405: $text = 'Method Not Allowed'; break;
            case 406: $text = 'Not Acceptable'; break;
            case 407: $text = 'Proxy Authentication Required'; break;
            case 408: $text = 'Request Time-out'; break;
            case 409: $text = 'Conflict'; break;
            case 410: $text = 'Gone'; break;
            case 411: $text = 'Length Required'; break;
            case 412: $text = 'Precondition Failed'; break;
            case 413: $text = 'Request Entity Too Large'; break;
            case 414: $text = 'Request-URI Too Large'; break;
            case 415: $text = 'Unsupported Media Type'; break;
            case 501: $text = 'Not Implemented'; break;
            case 502: $text = 'Bad Gateway'; break;
            case 503: $text = 'Service Unavailable'; break;
            case 504: $text = 'Gateway Time-out'; break;
            case 505: $text = 'HTTP Version not supported'; break;
            case 500: 
            default:
               $text = 'Internal Server Error'; break;
            break;
         }
         $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
         header($protocol . ' ' . $code . ' ' . $text);
         $GLOBALS['http_response_code'] = $code;
      } else  {
         $code = (isset($GLOBALS['http_response_code']) ? $GLOBALS['http_response_code'] : 200);
      }
      return $code;
   }
}
