<?php
// https://pt.wikipedia.org/wiki/Lista_de_c%C3%B3digos_de_status_HTTP
require_once "Utils.class.php";

/**
 * Classe para converter os dados da requisição
 * @author Lukas Jacomin
 */
class Request
{
    private $header = array();
    private $input = array();
    private $charset = "ISO-8859-1";
    private $compressionInput;
    private $compressionOutput;

    public function __construct()
    {
        $this->header = getallheaders();
    }

    public function handle()
    {
        if (!$this->isXML() && !$this->isJSON() && !$this->isText()) {
            throw new Exception("Somente aceitos requisições XML ou JSON.", 500);
            die();
        }
        $content = file_get_contents("php://input");

        if ($this->isInputZIP()) {
            if ($this->$compressionInput === "zlib") {
                $content = gzuncompress($content);
            } else {
                throw new Exception("Método de compressão não disponível no header KMM-Input-Compression: "+$this->$compressionInput, 400);
            }
        }

        $this->isOutputZIP();

        if ($this->isXML()) {
            $this->input = Utils::xmlToArray($content);
        } else if ($this->isJSON()) {
            $this->input = Utils::jsonToArray($content);
        } else {
            $encrypted = $content;
            $decrypted = self::encrypt_decrypt('decrypt', $encrypted);

            if ($decrypted == null){
               throw new Exception("Conteúdo criptografado inválido. ", 206);
            }

            $this->input = Utils::jsonToArray($decrypted);
        }

        if ($this->input === null) {
            if ($content === null || $content == "") {
                throw new Exception("Conteúdo vazio fornecido", 204);
            } else {
                throw new Exception("Conteúdo inválido fornecido", 206);
            }
        }
    }

    public function encrypt_decrypt($action, $string)
    {
        $output = false;
        $encrypt_method = "AES-128-CBC";
        $secret_key = self::hex2bin("0003456789edcbaf0123456789abcaaa");
        $secret_iv = self::hex2bin("abcdef9876543210abcdef9876543210");
        if ($action == 'encrypt') {
            $output = openssl_encrypt($string, $encrypt_method, $secret_key, 0, $secret_iv);
        } else {
            if ($action == 'decrypt') {
                $output = openssl_decrypt($string, $encrypt_method, $secret_key, 0, $secret_iv);
            }
        }
        return $output;
    }

    public function hex2bin($hexstr)
    {
        $n = strlen($hexstr);
        $sbin = "";
        $i = 0;
        while ($i < $n) {
            $a = substr($hexstr, $i, 2);
            $c = pack("H*", $a);
            if ($i == 0) {$sbin = $c;} else { $sbin .= $c;}
            $i += 2;
        }
        return $sbin;
    }

    public function isInputZIP()
    {
        if ($this->header["KMM-Input-Compression"]) {
            $this->$compressionInput = $this->header["KMM-Input-Compression"];
            return true;
        } else {
            return false;
        }
    }

    public function isOutputZIP()
    {
        if ($this->header["KMM-Output-Compression"]) {
            $this->$compressionOutput = $this->header["KMM-Output-Compression"];
            return true;
        } else {
            return false;
        }
    }

    public function isXML()
    {
        if ($this->header["Content-Type"]) {
            return (strpos($this->header["Content-Type"], "application/xml") !== false || strpos($this->header["Content-Type"], "text/xml") !== false);
        } else {
            return (strpos($this->header["content-type"], "application/xml") !== false || strpos($this->header["content-type"], "text/xml") !== false);
        }
    }

    public function isJSON()
    {
        if ($this->header["Content-Type"]) {
            return strpos($this->header["Content-Type"], "application/json") !== false;
        } else {
            return strpos($this->header["content-type"], "application/json") !== false;
        }
    }

    public function isText()
    {
        if ($this->header["Content-Type"]) {
            return strpos($this->header["Content-Type"], "text/plain") !== false;
        } else {
            return strpos($this->header["content-type"], "text/plain") !== false;
        }
    }

    public function input($key = null)
    {
        if (isset($key) && $key != "") {
            return $this->$key;
        } else {
            return $this->input;
        }
    }

    public function header($key = null)
    {
        if (isset($key) && $key != "") {
            return $this->header[$key];
        } else {
            return $this->header;
        }
    }

    // Headers para habilitar CORS - Cross-origin resource sharing
    public function responseHeaders()
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: POST");
        header("Access-Control-Allow-Headers: Content-Type, Debug, Authorization, Token-Time-Hours, KMM-Platform, KMM-Input-Compression, KMM-Output-Compression, Signature");
    }

    public function showResponse($response = array())
    {
        $this->responseHeaders();
        if ($this->isXML()) {
            header("Content-Type: text/xml; charset={$this->charset}");
            $responseConverted = Utils::arrayToXml($response);
        } else {
            header("Content-Type: application/json; charset={$this->charset}");
            $responseConverted = Utils::arrayToJson($response);
        }

        if ($this->isOutputZIP() && strlen($responseConverted) > 512) {
            if ($this->getCompressionOutput() === "zlib") {
                $responseConverted = gzcompress($responseConverted);
                header("KMM-Compressed: true");
            } else {
                throw new Exception("Método de compressão não disponível no header KMM-Output-Compression: "+$$this->getCompressionOutput(), 400);
            }
        } else {
            header("KMM-Compressed: false");
        }

        echo $responseConverted;
    }

    public function isDebug()
    {
        return $this->header["Debug"] == 1;
    }

    public function getCompressionInput()
    {
        return $this->$compressionInput;
    }

    public function getCompressionOutput()
    {
        return $this->$compressionOutput;
    }

    // --
    public function __get($key)
    {
        return $this->input[$key];
    }

    public function __set($key, $value)
    {
        $this->input[$key] = $value;
    }
}
