<?php

/**
 * Implementação do Json Web Token
 *
 * @author Lukas Jacomin
 */
class JWT
{

    private static $privateKey = "=@KMMauthKMM!";
    private static $privateKey2 = "!#@g1l32019#!";
    private static $algorithms = array('HS256' => 'sha256', 'HS384' => 'sha384', 'HS512' => 'sha512');

    private function __construct()
    {

    }

    public static function encode($tokenId, $issuedAt, $notBefore, $expire, $serverName, $dataT, $algorithm = "HS256")
    {
        $data = array(
            'iat' => $issuedAt, // Issued at: time when the token was generated
            'jti' => $tokenId, // Json Token Id: an unique identifier for the token
            'iss' => $serverName, // Issuer
            'nbf' => $notBefore, // Not before
            'exp' => $expire, // Expire
            'data' => $dataT,
        );

        $dataStr = json_encode($data);

        $header = json_encode(array(
            "alg" => $algorithm,
            "typ" => "JWT",
        ));

        if (!isset(self::$algorithms[$algorithm])) {
            return false;
        }

        $hmac = self::$algorithms[$algorithm];

        $hash = hash($hmac, $header . $dataStr . self::$privateKey);

        $token = base64_encode($dataStr) . "." . base64_encode($hash);
        return $token;
    }

    public static function generateToken($data, $validUntil = 600, $startIn = 5)
    {
        $tokenId = base64_encode(mt_rand(32, 4454554));
        $issuedAt = time();
        $notBefore = $issuedAt + $startIn;
        $expire = $notBefore + $validUntil;
        $serverName = $_SERVER["HTTP_HOST"];
        return self::encode($tokenId, $issuedAt, $notBefore, $expire, $serverName, $data);
    }

    public static function validate($token)
    {
        $tokenArr = explode(".", $token);
        $header = json_decode(base64_decode($tokenArr[0]), true);

        // Pega a primeira parte do token e converte para extrair os dados
        // $data = json_decode(base64_decode($tokenArr[1]), true);
        $data = json_decode(base64_decode($tokenArr[0]), true);
        // Gera um novo baseado nas informações vindas do token
        // $encodedInput = self::encode($data["jti"], $data["iat"], $data["nbf"], $data["exp"], $data["iss"], $data["data"], $header["alg"]);
        $encodedInput = self::encode($data["jti"], $data["iat"], $data["nbf"], $data["exp"], $data["iss"], $data["data"]);

        // Se o que veio for diferente do que foi gerado, quer dizer que os dados foram alterados
        if ($encodedInput !== $token) {
            throw new Exception("Invalid Token", 401);
        }

        $time = time();
        // Token expirado
        if ($time > $data["exp"]) {
            throw new Exception("Token expired", 401);
        }

        return $data["data"];
    }

    public static function validateIntegrity($content, $signature)
    {
        $algorithm = "HS256";
        $algo = self::$algorithms[$algorithm];
        $hash = hash_hmac($algo, $content, self::$privateKey2);

        if ($hash !== $signature) {
            throw new Exception("Invalid signature", 401);
        }

        return true;
    }
}
