# **Telemertria**

Este documento tem como objetivo descrever o funcionamento dos serviços da telemetria, tanto a busca dos dados nos fornecedores quanto os endpoints criados para serem consumidos inicialmente pelo TMS.

# **Sumário**
1. [Histórico de revisões](#historico)
2. [Tecnologias utilizadas](#tecnologias)
3. [Arquitetura](#arquitetura)
4. [Drivers disponíveis](#drivers)
5. [Endpoints disponíveis](#endpoints)

<br>

# **1. Histórico de revisões**<a name="#historico"></a>

| Versão | Autor | Atualização realizada | Data 
|:--:|:--:|------|:-----------:|
|1.0   | Fabio Garcia | <li>versão inicial da integração</li> | 27/04/2021 |

<br>


# **2. Tecnologias utilizadas**<a name="tecnologias"></a>

Foram criados 2 serviços para realização da integração, ambos utilizando Java. Os dados baixados são armazenados em um banco de dados não relacional, e para este projeto foi utilizado o MongoDB, sendo que cada cliente possui seu próprio banco, rodando de forma clusterizada (isso será explicitado no tópico de arquitetura). Os fontes estão versionados no SVN em **"\SVN\Software\_dev\Modulos\Informacoes Corporativas\Integracoes com Sistemas Externos\Telemetria\"**. São eles:

* **TelemetriaService**: este serviço é responsável por conectar nas API's dos fornecedores, baixar, tratar e armazenar os dados no Mongo. Este serviço roda dentro de um container, sendo denominado "stack", e cada cliente possui sua própria stack rodando em paralelo.

* **TelemetriaServiceConsumer**: este serviço é responsável por prover os endpoints a serem consumidos pelo TMS. Ele recebe as requisições e filtra de acordo com o que foi recebido como parametro, buscando do Mongo (ou faz o "by-pass" para drivers do tipo "gateway"), tratando e devolvendo os dados de acordo com o que foi solicitado.

Os serviços estão hospedados no OCI (Oracle Cloud Infrastructure).

<br>

# **3. Arquitetura**<a name="tecnologias"></a>

A arquitetura elaborada foi pensada em microserviços, os quais estão distribuidos em 2 maquinas (virtuais), rodando dentro de containers e orquestrados pelo Rancher. A imagem abaixo ilustra como foi montado esse ambiente e na sequencia a explicação do mesmo.

|  |
|:-:|
|![Arquitetura dos serviços](./Imagens/arquitetura.png "Arquitetura dos serviços")| 
|Figura 1 - Arquitetura dos serviços|

## **Definições**

**Stack**: Container rodando o serviço que consome as API's dos fornecedores, rodando um container **por cliente**, e uma thread para cada fornecedor que o cliente em questão possui. Por exemplo, se o cliente XPTO possui veiculos com telemetria habilitada da Volvo e Scania, a aplicação terá 1 container com 2 threads que rodam as buscas nos respectivos fornecedores. A sincronia da telemetria ocorre a cada minuto, e a sincronia de veículos a cada 60 minutos. Esse container roda em apenas um dos servidores, e caso a maquina apresente algum problema, o orquestrador provisionará um novo container para rodar no servidor que encontra-se funcional. Basicamente a stack consiste na aplicação TelemetriaService rodando individualmente por cliente, e com seus drivers configurados via arquivo de configuração.

**Consumer**: Containers responsáveis por servir os dados dos endpoints disponibilizados (5. Endpoints disponíveis). Existem N containers rodando o serviço TelemetriaServiceConsumer, o qual recebe requisições atráves do orquestrador (Rancher) funcionando como uma espécie de load balance do próprio servidor. Externamente temos um load balance do OCI entre os servidores, o qual distribui as requisições entre as N máquinas (no momento são 2) 

**Cluster Mongo**: O banco de dados do Mongo também esta distribuido entre as N maquinas (novamente, no momento 2). Com isso, ganhamos redundância, disponibilidade e perfomance na busca dos dados. Cabe ao orsquestrador, que atua como um load balance enviar a requisição para um dos "mongo routers", o qual considera-se a "porta de acesso" aos dados efetivamente. A estrutura da base consiste em:
* Uma database por cliente;
* Uma collection por veículo, a qual grava os dados de telemetria;
* Uma collection para guardar a data da ultima busca da telemetria, utilizada sempre na busca como parametro de data inicial.

<br>

# **4. Drivers disponíveis**<a name="drivers"></a>

| Driver | Tipo | Endpoints consumidos | 
|:--:|------|:-----------:|
|volvo | persistente | <li align="left">Sincronização de veículos: https://api.volvotrucks.com/vehicle/vehicles?additionalContent=VOLVOGROUPVEHICLE</li><li align="left">Sincronização de telemetria: https://api.volvotrucks.com/vehicle/vehiclestatuses?latestOnly=false&additionalContent=VOLVOGROUPSNAPSHOT&contentFilter=SNAPSHOT</li>
|scania | persistente | <li align="left">Sincronização de veículos: https://dataaccess.scania.com/rfms2/vehicles</li><li align="left">Sincronização de telemetria: https://dataaccess.scania.com/rfms2/vehiclestatuses?latestOnly=false&contentFilter=SNAPSHOT&datetype=received</li><li align="left">Autenticação (challenge): https://fmsauth.scania.com/auth/S2S4DA/ClientId2Challenge</li><li align="left">Autenticação (token): https://fmsauth.scania.com/auth/S2S4DA/Response2Token</li>
|gobrax | gateway | <li align="left">Sincronização de veículos: http://api.gobrax.com.br:8085/v1/vehicles?customerId=XXX</li><li align="left">Sincronização de telemetria: http://api.gobrax.com.br:8085/v1/consumptions/vehicle</li>

<br>

# **5. Endpoints disponíveis**<a name="drivers"></a>

Para comunicação com os endpoints, é necessário enviar um cabeçalho denonimado "X-CLIENT-KEY", com o valor criado pelo time de arquitetura. Através dessa key, o TelemetriaServiceConsumer saberá para qual database apontar, bem como utilizará a mesma para identificar quais drivers o cliente associado a ela possui ativo. A passagem de parametros é de acordo com o endpoint a ser chamado, e pode ser enviado via GET ou POST, os quais serão automaticamente tratados pela aplicação, desde que possuam nomes de acordo com a especificação abaixo. 

A URL base da aplicação é:

```
https://telemetry.kmm.app.br
```

Cabeçalhos de envio (todas as requisições)
```
Content-Type: application/json
X-CLIENT-KEY: YYYYYYYYYYYYYYYYYYYYYY
```

## Métodos

**Retorna todos os veículos (Request)**

URL
```
https://telemetry.kmm.app.br/allVehicles
```

Parametros (POST)
```json
{
    "driver": "volvo"
}
```

Parametros (GET)
```
https://telemetry.kmm.app.br/allVehicles?driver=volvo
```

**Retorna todos os veículos (Response)**
```json
{
    "vehicles": [
        {
            "driver": "volvo",
            "registrationNumber": "BDP1837",
            "vin": "9BVRG20C0JE856554",
            "model": "FH (4)    ",
            "_id": {
                "$oid": "607b3dce24f55758f44b619a"
            },
            "customerVehicleName": "BDP1837",
            "type": "TRUCK",
            "brand": "VOLVO TRUCKS",
            "emissionLevel": "EURO_V"
        }
        ...
    ]
}
```
___
**Retorna a telemetria processada (Request)**

URL
```
https://telemetry.kmm.app.br/processedTelemetry
```

Parametros (POST)
```json
{
    "driver": "volvo",
    "vin": "9BVRG20C9LE867860", --para o driver Volvo e Scania
    "plate": "BDP1837", --para o driver GoBrax
    "start_date": "2021-03-16T19:48:49",
    "end_date": "2021-03-19T01:02:42"
}
```

Parametros (GET)
```
https://telemetry.kmm.app.br/processedTelemetry?driver=volvo&vin=9BVRG20C9LE867860&start_date=2021-03-16T19:48:49&end_date=2021-03-19T01:02:42
```

**Retorna a telemetria processada (Response)**
```json
{
    "processed_telemetry": {
        "totalRegisters": 1916,
        "hrTotalVehicleDistance": 734350,
        "last": {
            "localDateTime": "19-03-2021 01:00:00",
            "hrTotalVehicleDistance": 159647610,
            "engineTotalFuelUsed": 68268910,
            "createdDateTime": "2021-03-19T01:00:00Z",
            "fuelLevel1": 38
        },
        "engineTotalFuelUsed": 191460,
        "lastFuelLevel1": 38,
        "first": {
            "localDateTime": "16-03-2021 19:54:24",
            "wheelBasedSpeed": 0,
            "hrTotalVehicleDistance": 158913260,
            "engineTotalFuelUsed": 68077450,
            "createdDateTime": "2021-03-16T19:54:24Z",
            "fuelLevel1": 61
        }
    }
}
```
___
**Retorna todas as telemetrias do veiculo para o periodo (Request)**

URL
```
https://telemetry.kmm.app.br/allTelemetry
```

Parametros (POST)
```json
{
    "driver": "volvo",
    "vin": "9BVRG20C9LE867860", --para o driver Volvo e Scania
    "plate": "BDP1837", --para o driver GoBrax
    "start_date": "2021-03-16T19:48:49",
    "end_date": "2021-03-19T01:02:42"
}
```

Parametros (GET)
```
http://telemetry.kmm.app.br/allTelemetry?driver=volvo&vin=9BVRG20C9LE867860&start_date=2021-03-16T19:48:49&end_date=2021-03-19T01:02:42
```

**Retorna todas as telemetrias do veiculo para o periodo**
```json
{
    "all_telemetry": [
        {
            "localDateTime": "16-03-2021 19:54:24",
            "wheelBasedSpeed": 0,
            "hrTotalVehicleDistance": 158913260,
            "engineTotalFuelUsed": 68077450,
            "createdDateTime": "2021-03-16T19:54:24Z",
            "_id": {
                "$oid": "605e8869a7980418d79291a7"
            },
            "fuelLevel1": 61
        },
        {
            "localDateTime": "16-03-2021 19:54:24",
            "wheelBasedSpeed": 0,
            "hrTotalVehicleDistance": 158913260,
            "engineTotalFuelUsed": 68077450,
            "createdDateTime": "2021-03-16T19:54:24Z",
            "_id": {
                "$oid": "60629755a7980418d7b082f4"
            },
            "fuelLevel1": 61
        }
		...
    ]
}
```
___
