<cfswitch expression="#vars.CONSULTA#">
	<cfcase value="1">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrConhecimento = conn.get_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrItens 	   = conn.get_item_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrCustos 	   = conn.get_custo_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrAnexos 	   = conn.get_anexo_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrFronteiras   = conn.get_fronteira_crt(conhecimento_id = vars.CONHECIMENTO_ID);
            qrComplemento  = conn.get_intc_conhecimento_complemento(conhecimento_id = vars.CONHECIMENTO_ID);
            qrDivisao      = conn.get_intc_crt_divisao(conhecimento_id = vars.CONHECIMENTO_ID);
			qrUltimaVersao = conn.get_crt_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
        </cfscript>
        <cfif qrConhecimento.RecordCount gt 0>
			<script type="text/javascript">
                    parent.f_limpar_MERCADORIAS();
                    parent.f_limpar_CUSTOS();
                    parent.f_limpar_ANEXOS();
                    parent.f_limpar_FRONTEIRAS();
                    parent.f_limpar_DIVISAO();
                    parent.f_limpar_COMPLEMENTO();
					
                    with(parent.document.form_crt) {
                        OPERACAO_ID_CRT.value = '';
                        OPERACAO_ID_CRT_HIDDEN.value = '';
                        OPERACAO_CRT.value = '';
                        OPERACAO_CRT_HIDDEN.value = '';
                    }
            </script>
            
            <cfoutput query="qrItens">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_MERCADORIAS();
                        MERC_ITEM_ID.value = '#JSStringFormat(qrItens.ITEM_ID)#';
                        MERC_PRODUTO_ID.value = '#JSStringFormat(qrItens.PRODUTO_ID)#';
                        MERC_QUANTIDADE.value = '#JSStringFormat(qrItens.QUANTIDADE)#';
                        MERC_UNIDADE_ID.value = '#JSStringFormat(qrItens.UNIDADE_ID)#';
                        MERC_DESCRICAO.value = '#JSStringFormat(qrItens.DESCRICAO)#';
                        MERC_NUM_ESPECIE.value = '#JSStringFormat(qrItens.NUM_ESPECIE)#';
                        MERC_PESO_BRUTO.value = '#JSStringFormat(qrItens.PESO_BRUTO)#';
                        MERC_PESO_LIQUIDO.value = '#JSStringFormat(qrItens.PESO_LIQUIDO)#';
                        MERC_VOLUME.value = '#JSStringFormat(qrItens.m3)#';
                        parent.f_salvar_MERCADORIAS();
                    }
                </script>	
            </cfoutput>
            
            <cfoutput query="qrAnexos">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_ANEXOS();
                        ANEXO_ID.value = '#JSStringFormat(qrAnexos.ANEXO_ID)#';
                        ANEXO_DESCRICAO.value = '#JSStringFormat(qrAnexos.DESCRICAO)#';
                        parent.f_salvar_ANEXOS();
                    }
                    parent.parent.f_habilitar_botao('pdf', 'iconteudo.f_pdf()');
                </script>
            </cfoutput>	
        
            <cfoutput query="qrFronteiras">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_FRONTEIRAS();
                        CONTROLE_ID.value = '#JSStringFormat(qrFronteiras.CONTROLE_ID)#';
                        FRONTEIRA_ID.value = '#JSStringFormat(qrFronteiras.FRONTEIRA_ID)#';
                        parent.f_salvar_FRONTEIRAS();
                    }
                    parent.parent.f_habilitar_botao('pdf', 'iconteudo.f_pdf()');
                </script>
            </cfoutput>
            
            <cfoutput query="qrConhecimento" maxrows="1"> 
                <script type="text/javascript">
                    with (parent.document.form_crt) {
                    <cfloop list="#qrConhecimento.columnlist#" index="v_index">
                        try {
                            if(#v_index#.type != 'checkbox' && #v_index#.type != 'radio')
                                #v_index#.value = '#JsstringFormat(qrConhecimento[v_index][1])#';
                        } catch(e) {}
                    </cfloop>
					PERMISSO.value = '#qrConhecimento["NUMERO_COD_PAIS"][1]#|#qrConhecimento["NUMERO_CERTIFICADO"][1]#|#qrConhecimento["SERIE"][1]#';
					parent.f_separa_numero_crt();
                    parent.f_seleciona_filial(#qrConhecimento["COD_PESSOA_FILIAL"][1]#);			
                    parent.f_seleciona_centro_custo();
					
                    COD_CENTRO_CUSTO.value = '#qrConhecimento["COD_CENTRO_CUSTO"][1]#';			
                    COD_ORGANOGRAMA.value = '#qrConhecimento["COD_ORGANOGRAMA"][1]#';
                    OPERACAO_ID_CRT.value = '#qrConhecimento["OPERACAO_ID"][1]#';
					PEDIDO_SHIPMENT.value = '#qrConhecimento["PEDIDO_SHIPMENT"][1]#';
                    <!---if (OPERACAO_ID_CRT.value){--->
                        parent.f_busca_operacao('#qrConhecimento["ORGANIZACIONAL_ID_GERENCIAL"][1]#');				
                    <!---}
                    ORGANIZACIONAL_ID_GERENCIAL.value = '#qrConhecimento["ORGANIZACIONAL_ID_GERENCIAL"][1]#';
                    ORGANIZACIONAL_ID_GERENCIAL.onchange();--->
                    COTACAO.value =  Number(COTACAO.value).toFixed(4);
                    
                    parent.document.getElementById('date_update').innerHTML = '#DateFormat(qrConhecimento["DATE_UPDATE"][1],'dd/mm/yyyy')# #TimeFormat(qrConhecimento["DATE_UPDATE"][1],'HH:MM:SS')#  por #qrConhecimento["USER_UPDATE"][1]# verso: #qrConhecimento["VERSAO"][1]#';
        
                    parent.document.getElementById('duplicidade').innerHTML = '';
					REM_CNPJ_CPF.value = '#JsstringFormat(qrConhecimento["REMETENTE_CNPJ_CPF"][1])#';
                    REM_MUNICIPIO.value = '#JsstringFormat(qrConhecimento["REM_CIDADE"][1])#';
                    DEST_MUNICIPIO.value = '#JsstringFormat(qrConhecimento["DEST_CIDADE"][1])#';
                    CONS_MUNICIPIO.value = '#JsstringFormat(qrConhecimento["CONS_CIDADE"][1])#';
                    NOT_MUNICIPIO.value = '#JsstringFormat(qrConhecimento["NOT_CIDADE"][1])#';
					
                    EMISSAO_DATA.value = '#JsstringFormat(qrConhecimento["EMISSAO_DATA_CHAR"][1])#';
        
                    parent.f_limpa_select(NUM_EMBARQUE); 
                        for (var i=1;i<=QTDE_VEICULOS.value;i++) { 
                            parent.f_cria_option(i,i,NUM_EMBARQUE); 
                        }
                    }
                    parent.f_km_rota_crt();
                </script>
            </cfoutput>
            
            <script>
                with(parent.document.forms[0]) {		
                <cfif qrComplemento.recordcount>
                    parent.f_aba_complemento(true);
                    <cfoutput query="qrComplemento">
						parent.f_incluir_COMPLEMENTO();
						TIPO_COMPLEMENTO.value = '#JSStringFormat(qrComplemento.tipo_id)#';
						CONHECIMENTO_COMPLEMENTO_ID.value = '#JSStringFormat(qrComplemento.conhecimento_id_complemento)#';
						CRT_COMPLEMENTO.value = '#JSStringFormat(qrComplemento.numero_crt_complemento)#';
						parent.f_salvar_COMPLEMENTO();
                    </cfoutput>
                <cfelse>
                    parent.f_aba_complemento(false);
                </cfif>
                }
            </script>
        	
            <cfoutput query="qrCustos">
				<script type="text/javascript">
                    with (parent.document.form_crt) {
                        parent.f_incluir_CUSTOS();
                        CUST_ITEM_ID.value = '#JSStringFormat(qrCustos.ITEM_ID)#';
                        CUST_DESCRICAO.value = '#JSStringFormat(qrCustos.DESCRICAO)#';
                        CUST_VALOR_ORIGEM.value = '#JSStringFormat(qrCustos.VALOR_ORIGEM)#';
                        CUST_VALOR_ORIGEM_COD_MOEDA.value = '#JSStringFormat(qrCustos.VALOR_ORIGEM_COD_MOEDA)#';
                        CUST_VALOR_DESTINO.value = '#JSStringFormat(qrCustos.VALOR_DESTINO)#';
                        CUST_VALOR_DESTINO_COD_MOEDA.value = '#JSStringFormat(qrCustos.VALOR_DESTINO_COD_MOEDA)#';
                        parent.f_salvar_CUSTOS();
                            
                    }
                </script>
            </cfoutput>
                
            <script type="text/javascript">
                parent.parent.f_habilitar_botao('pdf', 'f_pdf()');
                parent.parent.f_habilitar_botao('copiar_crt', 'f_copiar_crt()');
                parent.parent.f_habilitar_botao('complementar_crt', 'f_complementar_crt()');
                
                <cfif qrConhecimento.CANCELADO eq 1>
                    parent.document.getElementById('SITUACAO').innerHTML = 'CANCELADO';
                    parent.parent.f_desabilitar_botao('editar');
                    parent.parent.f_desabilitar_botao('cancelar_doc');
					parent.parent.f_desabilitar_botao('complementar_crt');
                <cfelse>
                    parent.parent.f_habilitar_botao('cancelar_doc', 'f_cancelar_doc()');
					parent.parent.f_habilitar_botao('complementar_crt', 'f_complementar_crt()');
                    parent.document.getElementById('SITUACAO').innerHTML = '';
                </cfif>
                
                parent.parent.f_habilitar_botao('copiar_crt', 'f_copiar_crt()');
            </script>	
            
            <cfset v_num_embarque = 0>
            <cfset v_embarque_id = 0>
            <cfoutput query="qrDivisao">
                <script type="text/javascript">
                    with (parent.document.form_crt) {
                        PLACA_CONTROLE.obrigatorio = 0;
                        DIVISAO_COD_MOTORISTA.obrigatorio = 0;
                        DIVISAO_ROTA_ID.obrigatorio = 0;
                        parent.f_incluir_DIVISAO();
                        <cfif qrDivisao.EMBARQUE_ID neq v_embarque_id>
                            <cfset v_num_embarque = v_num_embarque + 1>
                            <cfset v_embarque_id = qrDivisao.EMBARQUE_ID>
                        </cfif>
                        parent.f_cria_option(#v_num_embarque#,#v_num_embarque#,NUM_EMBARQUE);
                        NUM_EMBARQUE.value = '#v_num_embarque#';
                        DATE_INSERT.value = '#JSStringFormat(qrDivisao.DATE_INSERT)#';
                        USER_INSERT.value = '#JSStringFormat(qrDivisao.USER_INSERT)#';
                        DATA_CANCELAMENTO.value = '#JSStringFormat(qrDivisao.DATA_CANCELAMENTO)#';
        //				NUM_EMBARQUE.value = '#qrDivisao.NUM_EMBARQUE#';
                        DIVISAO_CONTROLE_ID.value = '';
                        EMBARQUE_ID.value = '#qrDivisao.EMBARQUE_ID#';
                        DIVISAO_ID.value = '#qrDivisao.DIVISAO_ID#';
                        EMBARQUE_DATA.value = '#qrDivisao.DATA_EMBARQUE#';
                        DIVISAO_DATA.value = '#qrDivisao.DATA_DIVISAO#';
                        PLACA_CONTROLE.value = '#qrDivisao.PLACA_CONTROLE#';
                        PLACA_REFERENCIA_COMPOSICAO.value = '#qrDivisao.PLACA_REFERENCIA_COMPOSICAO#';
                        parent.f_limpar_engates();
                        
                        <cfloop list="#qrDivisao.PLACA_REFERENCIA_COMPOSICAO#" index="placas">
                            parent.v_obj = parent.f_engata();
                            parent.v_obj.setValue('#placas#');
                        </cfloop>
                        KM_ROTA_CRT.value = '#qrDivisao.KM_CRT#';
                        DIVISAO_COD_MOTORISTA.value = '#qrDivisao.COD_PESSOA_MOTORISTA#';
                        DIVISAO_MOTORISTA.value = '#qrDivisao.MOTORISTA#';
                        DIVISAO_COD_PESSOA_MOTORISTA.value = '#qrDivisao.COD_PESSOA_MOTORISTA#';
                        DIVISAO_ROTA_ABREVIATURA.value = '#qrDivisao.ABREVIATURA#';
                        parent.f_cria_option('#qrDivisao.ROTA_ID#','#qrDivisao.DESCRICAO_ROTA#',DIVISAO_ROTA_ID);
                        DIVISAO_ROTA_ID.value = "#qrDivisao.ROTA_ID#";
                        DIVISAO_KM.value = '#qrDivisao.DISTANCIA_PADRAO#';
                        DIVISAO_PERCENTUAL.value = '#qrDivisao.PERCENTUAL_CRT#';
                        DIVISAO_COD_MOEDA.value = '#qrDivisao.COD_MOEDA#';
                        DIVISAO_VALOR.value = '#qrDivisao.VALOR#';
                        parent.f_salvar_DIVISAO();
                        parent.f_limpa_select(DIVISAO_ROTA_ID);
                        PLACA_CONTROLE.obrigatorio = 1;
                        DIVISAO_COD_MOTORISTA.obrigatorio = 1;
                        DIVISAO_ROTA_ID.obrigatorio = 1;
                    }
                </script>	
            </cfoutput>
            
            <cfif qrUltimaVersao.RecordCount gt 0>
            	<script type="text/javascript">
					with(parent.document.forms[0]) {
						parent.v_emite_tabela_frete = 1;
						
						<cfoutput>
							CLASSIFICACAO_NATUREZA_ID.value  = '#JSStringFormat(qrUltimaVersao.CLASSIFICACAO_NATUREZA_ID)#';
							CLASSIFICACAO_COMERCIAL_ID.value = '#JSStringFormat(qrUltimaVersao.CLASSIFICACAO_COMERCIAL_ID)#';
						</cfoutput>
						
						parent.f_utiliza_tabela_frete(3);
						parent.f_atualiza_filtros_indicativos();
						parent.f_busca_versoes();
					}
				</script>
            <cfelse>
            	<script type="text/javascript">
					with(parent.document.forms[0]) {
						parent.v_emite_tabela_frete = 0;
						
						CLASSIFICACAO_NATUREZA_ID.value  = '';
						CLASSIFICACAO_COMERCIAL_ID.value = '';
						
						parent.f_utiliza_tabela_frete(1);
					}
				</script>
            </cfif>
        <cfelse>
            <script type="text/javascript">
                alert('No foi possvel localizar o C.R.T.!');			
            </script>
        </cfif>
	</cfcase>
    
    <cfcase value="2">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrAlfandega = conn.get_alfandega();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                ALFANDEGA_ORIGEM_ID.add(novo);

                for (var q=ALFANDEGA_ORIGEM_ID.options.length; q>=0; q--) 
                    ALFANDEGA_ORIGEM_ID.options[q]=null;

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                ALFANDEGA_DESTINO_ID.add(novo);

                for (var q=ALFANDEGA_DESTINO_ID.options.length; q>=0; q--) 
                    ALFANDEGA_DESTINO_ID.options[q]=null;
        
                <cfoutput query="qrAlfandega">
                    novo = document.createElement("option") ;
                    novo.value = '#qrAlfandega.ALFANDEGA_ID#';
                    novo.text = '#JSStringFormat(qrAlfandega.DESCRICAO)#';
                    ALFANDEGA_ORIGEM_ID.add(novo);						
                </cfoutput>
                
                <cfoutput query="qrAlfandega">
                    novo = document.createElement("option") ;
                    novo.value = '#qrAlfandega.ALFANDEGA_ID#';
                    novo.text = '#JSStringFormat(qrAlfandega.DESCRICAO)#';
                    ALFANDEGA_DESTINO_ID.add(novo);						
                </cfoutput>
            }		
        </script>	
    </cfcase>
    
    <cfcase value="3">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrProdutos = conn.get_produtos();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {
                for (var q=MERC_PRODUTO_ID.options.length; q>=0; q--) 
                    MERC_PRODUTO_ID.options[q]=null;

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                MERC_PRODUTO_ID.add(novo);

                <cfoutput query="qrProdutos">
                    novo = document.createElement("option") ;
                    novo.value = '#qrProdutos.PRODUTO_ID#';
                    novo.text = '#JSStringFormat(qrProdutos.DESCRICAO)#';
                    MERC_PRODUTO_ID.add(novo);						
                </cfoutput>
            }		
        </script>
    </cfcase>
    
    <cfcase value="4">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrEspecies = conn.get_especies();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {
                for (var q=MERC_NUM_ESPECIE.options.length; q>=0; q--) 
                    MERC_NUM_ESPECIE.options[q]=null;

                novo = document.createElement("option") ;
                novo.value = '';
                novo.text = '-- Selecione --';
                MERC_NUM_ESPECIE.add(novo);

                <cfoutput query="qrEspecies">
                    novo = document.createElement("option") ;
                    novo.value = '#qrEspecies.NUM_ESPECIE#';
                    novo.text = '#JSStringFormat(qrEspecies.ABREVIATURA)#';
                    MERC_NUM_ESPECIE.add(novo);						
                </cfoutput>
            }		
        </script>
    </cfcase>
    
    <cfcase value="5">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            qrFronteira = conn.get_fronteira();
        </cfscript>
		<script type="text/javascript">
            var novo;
            with (parent.document.form_crt) {
                parent.f_limpa_select(FRONTEIRA_ID);
                parent.f_cria_option('','-- Selecione --',FRONTEIRA_ID);
                <cfoutput query="qrFronteira">
                parent.f_cria_option('#qrFronteira.FRONTEIRA_ID#','#JSStringFormat(qrFronteira.DESCRICAO)#',FRONTEIRA_ID);						
                parent.v_cidade_1['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.MUNICIPIO_1)#';
                parent.v_cidade_2['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.MUNICIPIO_2)#';
                parent.v_pais_1['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.PAIS_01)#';
                parent.v_pais_2['#qrFronteira.fronteira_id#'] = '#JSStringFormat(qrFronteira.PAIS_02)#';
                </cfoutput>
            }		
        </script>
    </cfcase>
    
    <cfcase value="6">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
            if(not len(trim(vars.numero))) {
                vars.numero = -1;
            }
            qrConhecimento = conn.get_crt(num_crt_completo = vars.numero);
        </cfscript>
        <cfdump var="#qrConhecimento#">
        <cfif qrConhecimento.RecordCount gt 0>
            <script>
                alert('Nmero do CRT j cadastrado, verifique!');
                parent.document.getElementById('duplicidade').innerHTML = 'Nmero do CRT j cadastrado!';
            </script>
        <cfelse>
            <script>
                parent.document.getElementById('duplicidade').innerHTML = '';
            </script>
        </cfif>
    </cfcase>
    
    <cfcase value="7">
        <cfscript>
            conn = CreateComponent("_transportes.consulta.logistica.cfc_operacao");
            qrOperacao= conn.get_operacao(argumentCollection = vars, internacional = 1);
        </cfscript>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td class="texto">
                    <table width="100%" border="0" cellspacing="1" cellpadding="1">
                        <tr class="titulo_2">
                            <td nowrap align="left">C&oacute;d. Opera&ccedil;&atilde;o</td>
                            <td nowrap align="left">Descri&ccedil;&atilde;o</td>                  
                        </tr>
                        <cfoutput query="qrOperacao">
                        <tr class="linha_#(qrOperacao.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrOperacao.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrOperacao.OPERACAO_ID)#', '#JSStringFormat(qrOperacao.DESCRICAO)#')">
                            <td nowrap align="left">#qrOperacao.OPERACAO_ID#</td>
                            <td nowrap align="left">#qrOperacao.operacao_completa#</td>
                        </tr>
                        </cfoutput>
                        <cfif qrOperacao.RecordCount eq 0>
                        <tr>
                            <td colspan="2" align="center" valign="middle" class="obrigatorio">Nenhuma opera&ccedil;&atilde;o foi encontrada.</td>
                        </tr>
                        </cfif>
                    </table>
                </td>
            </tr>
        </table>
    </cfcase>
    
    <cfcase value="8">
    	<cfset v_retorno = structnew()>
        <cftry>
            <cfscript>
                conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
                qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= vars.RESP_MUNICIPIO_ID,
                                                                            	 DESTINO_MUNICIPIO_ID 		= vars.ENTREGA_MUNICIPIO_ID,
                                                                            	 COD_NEGOCIADOR       		= vars.COD_NEGOCIADOR,
                                                                            	 CLASSIFICACAO_NATUREZA_ID	= vars.CLASSIFICACAO_NATUREZA_ID,
                                                                            	 CLASSIFICACAO_COMERCIAL_ID = vars.CLASSIFICACAO_COMERCIAL_ID);
            </cfscript>
            <cfif qrTabelaFreteRotaId.erro>
                <cfthrow object="#qrTabelaFreteRotaId.mensagem#">
            </cfif>
            
            <cfscript>
                qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
                
                vars.TABELA_FRETE_ID	  = qrTabelaFreteRota.TABELA_FRETE_ID;
                vars.TABELA_FRETE_ROTA_ID = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID;
                
                // Constantes
                
                // ----------
                
                qrCalculo = conn_cons_tf.calculo_tabela_frete(argumentCollection = vars);
            </cfscript>
            <cfif qrCalculo.erro>
                <cfthrow object="#qrCalculo.mensagem#">
            </cfif>
            
            <div id="div_negociacao_tabela_frete" style="display: none;">
                <table border="0" cellpadding="0" cellspacing="0">
                    <tr>
                        <td valign="top">
                            <table border="0">
                                <tr>
                                    <td valign="top">
                                        <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                            <tr class="titulo_1">
                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                <td nowrap align="left">Valor</td>
                                                <td nowrap align="center">Tipo</td>
                                            </tr>
                                            <cfoutput query="qrCalculo.query">
                                                <cfswitch expression="#qrCalculo.query.TIPO#">
                                                    <cfcase value="0">
                                                        <cfset v_imagem = 'seta_matriz'>
                                                        <cfset v_tipo   = 'Interna - No Editvel'>
                                                    </cfcase>
                                                    <cfcase value="1">
                                                        <cfset v_imagem = 'fx'>
                                                        <cfset v_tipo   = 'Frmula'>
                                                    </cfcase>
                                                    <cfcase value="2">
                                                        <cfset v_imagem = 'arquivo_detalhes'>
                                                        <cfset v_tipo   = 'Valor - Informando na Tabela'>
                                                    </cfcase>
                                                    <cfcase value="3">
                                                        <cfset v_imagem = 'editar'>
                                                        <cfset v_tipo   = 'Valor - Informando na Emisso do Documento'>
                                                    </cfcase>
                                                </cfswitch>
                                                <tr class="linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#';">
                                                    <td nowrap align="left">#qrCalculo.query.DESCRICAO#</td>
                                                    <td nowrap align="left"><input type="text" name="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" id="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" maxlength="15" value="<cfif IsNumeric(qrCalculo.query.VALOR)>#NumberFormat(Replace(qrCalculo.query.VALOR, ',', '.', 'all'), '_.__')#<cfelse>#qrCalculo.query.VALOR#</cfif>" <cfif qrCalculo.query.TIPO eq 3>obrigatorio="1"<cfelse>readonly</cfif> <cfif IsNumeric(qrCalculo.query.VALOR)>tipo="numerico"</cfif> display="#UCase(qrCalculo.query.DESCRICAO)#" onChange="this.value = Number(this.value); <cfif qrCalculo.query.TIPO eq 3>f_calculos();</cfif>" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px; text-align: right;" /></td>
                                                    <td nowrap align="center"><img src="/_imagens/botoes/16x16/#v_imagem#.gif" alt="#v_tipo#" title="#v_tipo#" width="16" height="16" align="absmiddle" /></td>
                                                </tr>
                                                <cfif qrCalculo.query.CurrentRow neq qrCalculo.query.RecordCount and qrCalculo.query.CurrentRow%10 eq 0>
                                                    </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                    <tr class="titulo_1">
                                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                        <td nowrap align="left">Valor</td>
                                                        <td nowrap align="center">Tipo</td>
                                                    </tr>
                                                </cfif>
                                            </cfoutput>
                                            <tr class="linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#';">
                                                <td colspan="2" nowrap align="left">&nbsp;</td>
                                                <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_calculos()"><img src="/_imagens/botoes/16x16/calculadora.gif" alt="Executar C&aacute;lculos" title="Executar C&aacute;lculos" width="16" height="16" align="absmiddle" /></button></td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td valign="top" style="padding-left: 20px;">
                            <fieldset><legend>Dados da Tabela de Frete</legend>
                            <table border="0" cellspacing="1" cellpadding="3">
                                <cfoutput>
                                <tr>
                                    <td nowrap align="left" class="texto">Tabela de Frete:</td>
                                    <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                                </tr>
                                <tr>
                                    <td nowrap align="left" class="texto">Rota:</td>
                                    <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                                </tr>
                                <tr>
                                    <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                                    <td nowrap align="left" class="texto_negrito">
                                    	<cfif qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_ID eq vars.CLASSIFICACAO_NATUREZA_ID>
                                        	#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#
                                        <cfelse>
                                        	<span style="color: ##F00">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC# <img src="/_imagens/botoes/16x16/ajuda.gif" alt="Foi utilizada uma classifica&ccedil;&atilde;o de natureza gen&eacute;ria em rela&ccedil;&atilde;o &agrave; selecionada" title="Foi utilizada uma classifica&ccedil;&atilde;o de natureza gen&eacute;ria em rela&ccedil;&atilde;o &agrave; selecionada" width="16" height="16" align="absmiddle" style="margin-left: 10px;" /></span>
                                        </cfif>
									</td>
                                </tr>
                                <tr>
                                    <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                                    <td nowrap align="left" class="texto_negrito">
                                    	<cfif qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_ID eq vars.CLASSIFICACAO_COMERCIAL_ID>
                                        	#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#
                                        <cfelse>
                                        	<span style="color: ##F00">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC# <img src="/_imagens/botoes/16x16/ajuda.gif" alt="Foi utilizada uma classifica&ccedil;&atilde;o comercial gen&eacute;ria em rela&ccedil;&atilde;o &agrave; selecionada" title="Foi utilizada uma classifica&ccedil;&atilde;o comercial gen&eacute;ria em rela&ccedil;&atilde;o &agrave; selecionada" width="16" height="16" align="absmiddle" style="margin-left: 10px;" /></span>
                                        </cfif>
                                    </td>
                                </tr>
                                </cfoutput>
                            </table>
                            </fieldset>
                        </td>
                    </tr>
                </table>
            </div>
            
            <cfset v_retorno.erro = false>
            <cfcatch>
                <cfset v_retorno.erro = true>
                <cfset v_retorno.mensagem = cfcatch>
                
                <div id="div_negociacao_tabela_frete" style="display: none;">
                    <table border="0" cellspacing="1" cellpadding="3">
                        <tr class="obrigatorio">
                            <td align="left"><button type="button" class="botao-16x16" onClick="f_calculos()" style="margin-right: 5px;"><img src="/_imagens/botoes/16x16/atualizar.gif" alt="Tentar Novamente" title="Tentar Novamente" width="16" height="16" align="absmiddle" /></button>
                                <cfoutput>#JSStringFormat(Trim(fnc_format_erro(argumentCollection = v_retorno)))#</cfoutput></td>
                        </tr>
                    </table>
                </div>
            </cfcatch>
        </cftry>
        
        <script type="text/javascript">
            parent.document.getElementById('tr_negociacao_carregando').style.display = 'none';
            
            parent.document.getElementById('td_negociacao_tabela_frete').innerHTML = document.getElementById('div_negociacao_tabela_frete').innerHTML;
        </script>
        
        <cfscript>
            fnc_trata_erros(struct_erro = v_retorno, mostra_msg_ok = false);
        </cfscript>
        
        <script type="text/javascript">
            parent.f_habilitar_botao('confirmar', 'f_confirmar()');
        </script>
    </cfcase>
    
    <cfcase value="9">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
			qrVersao       = conn.get_crt_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID);
			qrUltimaVersao = conn.get_crt_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
			qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = qrUltimaVersao.VERSAO_ID);
			
			conn = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
			qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrUltimaVersao.TABELA_FRETE_ROTA_ID);
		</cfscript>
    	<fieldset><legend>Vers&otilde;es</legend>
        <table width="100%" border="0" cellspacing="1" cellpadding="3">
            <tr class="titulo_1">
                <td width="1%" nowrap align="center">&nbsp;</td>
                <td width="1%" nowrap align="center">N&ordm; Vers&atilde;o</td>
                <td width="1%" nowrap align="left">Inserido por</td>
                <td nowrap align="left">Data de Inser&ccedil;&atilde;o</td>
            </tr>
            <cfoutput query="qrVersao">
                <tr class="titulo_4">
                    <td nowrap align="center"><button type="button" id="BTN_MOSTRAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_mostrar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow eq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/mostrar.gif" alt="Mostrar Tarifas" title="Mostrar Tarifas" width="16" height="16" align="absmiddle" /></button>
                        <button type="button" id="BTN_OCULTAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_ocultar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow neq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/ocultar.gif" alt="Ocultar Tarifas" title="Ocultar Tarifas" width="16" height="16" align="absmiddle" /></button></td>
                    <td nowrap align="center">#qrVersao.NUM_VERSAO#</td>
                    <td nowrap align="left">#qrVersao.USER_INSERT#</td>
                    <td nowrap align="left">#qrVersao.DATE_INSERT#</td>
                </tr>
                <cfif qrVersao.CurrentRow eq 1>
                <tr id="tr_versao_#qrVersao.VERSAO_ID#">
                    <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4">
                        <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td valign="top">
                                    <table border="0">
                                        <tr>
                                            <td valign="top">
                                                <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                    <tr class="titulo_1">
                                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                        <td nowrap align="right">Valor</td>
                                                    </tr>
                                                    <cfloop query="qrVersaoTarifa">
                                                        <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                                            <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                                            <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                                        </tr>
                                                        <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                                            </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                            <tr class="titulo_1">
                                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                                <td nowrap align="right">Valor</td>
                                                            </tr>
                                                        </cfif>
                                                    </cfloop>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" style="padding-left: 20px;">
                                    <fieldset><legend>Dados da Tabela de Frete</legend>
                                    <table border="0" cellspacing="1" cellpadding="3">
                                        <tr>
                                            <td nowrap align="left" class="texto">Tabela de Frete:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Rota:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#</td>
                                        </tr>
                                    </table>
                                    </fieldset>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <cfelse>
                <tr id="tr_versao_#qrVersao.VERSAO_ID#" style="display: none;">
                    <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4"></td>
                </tr>
                </cfif>
            </cfoutput>
        </table>
        </fieldset>
    </cfcase>
    
    <cfcase value="10">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
			qrVersao       = conn.get_crt_comercial_versao(versao_id = vars.VERSAO_ID);
			qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = vars.VERSAO_ID);
			
			conn = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
			qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrVersao.TABELA_FRETE_ROTA_ID);
		</cfscript>
        <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td valign="top">
                    <table border="0">
                        <tr>
                            <td valign="top">
                                <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                    <tr class="titulo_1">
                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                        <td nowrap align="right">Valor</td>
                                    </tr>
                                    <cfoutput query="qrVersaoTarifa">
                                        <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                            <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                            <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                        </tr>
                                        <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                            </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                            <tr class="titulo_1">
                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                <td nowrap align="right">Valor</td>
                                            </tr>
                                        </cfif>
                                    </cfoutput>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
                <td valign="top" style="padding-left: 20px;">
                    <fieldset><legend>Dados da Tabela de Frete</legend>
                    <table border="0" cellspacing="1" cellpadding="3">
                    	<cfoutput>
                        <tr>
                            <td nowrap align="left" class="texto">Tabela de Frete:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                        </tr>
                        <tr>
                            <td nowrap align="left" class="texto">Rota:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                        </tr>
                        <tr>
                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#</td>
                        </tr>
                        <tr>
                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#</td>
                        </tr>
                        </cfoutput>
                    </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </cfcase>
    
	<cfdefaultcase>
		<script defer="defer">
	    	alert('Operao no programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>
