<cfcomponent extends="_transportes.manipulacao.cfc_pneus">
<!--- 
	-- PROPSITO
	-- Realiza um inventario de Pneu e se for o caso, monta-o
	-- LEOPOLDOS 19/01/2006
	--->
    <cffunction name='ins_inventario_montagem_pneu' displayname='Realiza um inventario de Pneu /e monta' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_PNEU' required='yes'>
		<cfargument name='NUM_INTERNO' required='no' default=''>
		<cfargument name='SERIE' required='no' default="1">
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='SULCO_ATUAL' required='yes'>
		<cfargument name='ANO_FABRICACAO' required='yes'>
		<cfargument name='DATA_AQUISICAO' required='yes'>
		<cfargument name='PNEU_REFORMADO' required='yes'>
		<cfargument name='REFORMAS' required='yes'>
        <cfargument name='MONTADO' required='yes'>
		<cfargument name='BORRACHA_ID' required='no' default="">
		<cfargument name='DESENHO_ID' required='no' default="">
		<cfargument name='KM_INICIAL' required='no' default="">
        <cfargument name="POSICAO" required="no" default="">
		<cfargument name="PLACA" required="no" default="">
		<cfargument name="COD_VEICULO" required="no" default="">
        <cfargument name='KM_VEICULO' required='no' default="0">
		<cftry>
        	<cfset retorno3 = StructNew()>
			<cftransaction action='begin'>
            <cfscript>
            if(arguments.PNEU_REFORMADO eq "1"){
					qrResultado = this.ins_inventario_pneu( num_pneu = arguments.NUM_PNEU
														  , marca_id = arguments.MARCA_ID
														  , modelo_id = arguments.MODELO_ID
														  , sulco_atual = arguments.SULCO_ATUAL
														  , ano_fabricacao = arguments.ANO_FABRICACAO
														  , data_aquisicao = arguments.DATA_AQUISICAO
														  , pneu_reformado = arguments.PNEU_REFORMADO
														  , reformas = arguments.REFORMAS
														  , borracha_id = arguments.BORRACHA_ID
														  , desenho_id = arguments.DESENHO_ID
														  , km_inicial = arguments.KM_INICIAL
														  , cod_pessoa_filial = session.cod_pessoa
														  , cod_departamento = session.cod_departamento
														  , cod_setor = session.cod_setor
														  , cod_centro_custo = session.cod_centro_custo );

				}else{
					qrResultado = this.ins_inventario_pneu( num_pneu = arguments.NUM_PNEU
														  , marca_id = arguments.MARCA_ID
														  , modelo_id = arguments.MODELO_ID
														  , sulco_atual = arguments.SULCO_ATUAL
														  , ano_fabricacao = arguments.ANO_FABRICACAO
														  , data_aquisicao = arguments.DATA_AQUISICAO
														  , pneu_reformado = arguments.PNEU_REFORMADO
														  , reformas = arguments.REFORMAS
														  , km_inicial = arguments.KM_INICIAL
														  , cod_pessoa_filial = session.cod_pessoa
														  , cod_departamento = session.cod_departamento
														  , cod_setor = session.cod_setor
														  , cod_centro_custo = session.cod_centro_custo );
				}
				
				</cfscript>
                <cfif qrResultado.erro>
    				<cfthrow object="#qrResultado.mensagem#">
	            </cfif>
                <cfscript>
				
				retorno3.mensagem = "Pneu inventariado com sucesso.";
				
				if (arguments.MONTADO eq 1) {
					v_data_hora = DateFormat(Now(),'dd/mm/yyyy') & ' ' & TimeFormat(Now(),'HH:MM:SS');
					set_montagem2 = this.mov_montagem( num_gabarito = ListGetAt(arguments.POSICAO,1,'_')
													, num_eixo     = ListGetAt(arguments.POSICAO,2,'_')
													, posicao      = ListGetAt(arguments.POSICAO,3,'_')
													, cod_veiculo  = arguments.PLACA
													, pneu_id      = qrResultado.PNEU_ID
													, data_montagem = v_data_hora
													, cod_pessoa_responsavel = session.cod_pessoa_usuario
												  );
					retorno3.mensagem = "Pneu inventariado e montado com sucesso.";
				}	
			</cfscript>
            <cfif IsDefined('set_montagem2')>
				<cfif set_montagem2.erro>
                    <cfthrow object="#set_montagem2.mensagem#">
                </cfif>
            </cfif>
            <cfset retorno3.erro = false>
<!---			<cfset retorno.mensagem = JSStringFormat(mensagem)>--->
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno3.erro = true>
				<cfset retorno3.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>