<cfcomponent extends="_transportes.consulta.cfc_veiculo">
	<!--- 
	-- PROPSITO
	-- Retorna a relao de veiculos ativos na data
	-- NOTAS EXPLICATIVAS
	-- 13/01/2006 - criado
	--->
	<cffunction name="get_veiculos_ativos" access="remote" returntype="query" output="true">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_veiculos" username="#session.usuario#" password="#session.senha#">
            select decode(vl.empresa, 1, 'Frota', 'agregado') as proprietario
                 , vl.placa
                 , vl.marca
                 , vl.modelo
                 , vl.combustivel
              from (select (substr(v.placa, 1, 3) || '-' || substr(v.placa, 4, 7)) as placa
                         , vm.marca
                         , vmod.modelo
                         , pp.descricao as combustivel
                         , vfg.empresa
                      from (select vt.tipo_carroceria_id as tipo_id
                                 , vt.descricao as tipo
                                 , vc.articulado as articulado
                              from oper.v$veiculo_tipo_carroceria vt
                             inner join oper.v$veiculo_agrupamento vc
                                     on vt.agrupamento_id = vc.agrupamento_id
                             where vc.tracao = 1
                               and vc.controla = 1) vt
                     inner join oper.v$veiculo_dados v
                             on v.tipo_carroceria_id = vt.tipo_id
                     inner join oper.v$veiculo_marca vm
                             on vm.marca_id = v.marca_id
                     inner join oper.v$veiculo_modelo vmod
                             on vmod.marca_id = v.marca_id
                            and vmod.modelo_id = v.modelo_id
                     inner join oper.v$veiculo_frota_geral vfg
                             on vfg.placa = v.placa,
                     oper.v$posto_produto pp
                     where pp.produto_id in (1)
                       and pp.ativo <> 2
                       and v.situacao_id = 1
                     order by vm.marca, vmod.modelo) vl
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and replace(upper(vl.placa), '-', '') = replace(upper('#arguments.placa#'), '-', '')
            </cfif>
			<cfif Len(Trim(arguments.cod_veiculo))>
               and upper(vl.cod_veiculo) like upper('#arguments.cod_veiculo#%')
            </cfif>
  		</cfquery>	
		<cfreturn qr_veiculos>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca classificao
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/07/2006
	--->
	<cffunction name="get_classificacao" access="remote" returntype="query" output="true">
		<cfargument name="agrupamento_id" required="no" default="">
		<cfargument name="tipo_carroceria_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select va.agrupamento_id, 
            	   va.num_agrupamento, 
                   va.descricao as agrupamento,
                   vc.tipo_carroceria_id, 
                   vc.num_tipo_carroceria, 
                   vc.descricao as classificacao
              from oper.v$veiculo_tipo_carroceria vc
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vc.agrupamento_id
               where 1=1
               <cfif Len(Trim(arguments.agrupamento_id))>
               	 and va.agrupamento_id = any(#arguments.agrupamento_id#)
               </cfif>
               <cfif Len(Trim(arguments.tipo_carroceria_id))>
               	 and va.tipo_carroceria_id = #arguments.tipo_carroceria_id#
               </cfif>
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca CENTRO DE CUSTO do veiculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2008
	--->
	<cffunction name="get_centro_custo_veiculo" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select vcc.placa, vcc.data, cc.cod_centro_custo, cc.centro_custo
              from oper.v$veiculo_ccusto_todos vcc
                inner join kss.v$centro_custo cc
                        on cc.cod_centro_custo = vcc.cod_centro_custo
             where vcc.data_cancelamento is null
               and vcc.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
               and vcc.data = (select max(vcc2.data) 
                                   from oper.v$veiculo_ccusto_todos vcc2
                                  where vcc2.data_cancelamento is null
                                    and vcc2.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
				                <cfif Len(Trim(arguments.data))>
                                    and vcc2.data <= '#arguments.data#')
               					<cfelse>
                                    and vcc2.data <= sysdate)
								</cfif>
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_localizar" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="tipo" required="no" default="">
        <cfargument name="valor" required="no" default="">
        <cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
        <cfargument name="trazer_proprietario" required="no" default="1">
        <cfargument name="trazer_agrupamento_id" required="no" default="0">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select * from (select distinct vd.placa,
							vd.cod_veiculo,
							vd.marca_id,
							ma.marca,
							vd.modelo_id,
                            <cfif arguments.trazer_agrupamento_id eq 1>
								tpc.agrupamento_id,
							</cfif>
                            vd.tipo_carroceria_id,
							vd.uf,
							md.modelo,
                            <cfif arguments.trazer_proprietario eq 1>
                            	oper.pkg_veiculo.fnc_veiculo_proprietario(vd.placa) as proprietario,
							</cfif>
							vd.observacao,
							vd.cor_predominante,
							vd.ano,
							vd.chassis,
							vd.renavan, /* Relacionado ao pessoa_atributo */
                            vd.capacidade_tanque,
							oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
							oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao /* Relacionado ao pessoa_atributo */
			  from oper.v$veiculo vd
			 inner join oper.v$veiculo_modelo md
					 on md.modelo_id = vd.modelo_id
					and md.marca_id  = vd.marca_id
			 inner join oper.v$veiculo_marca ma
					 on ma.marca_id  = vd.marca_id
			<cfif arguments.trazer_agrupamento_id eq 1>
			 inner join oper.v$veiculo_tipo_carroceria tpc
             		 on tpc.tipo_carroceria_id = vd.tipo_carroceria_id
			</cfif>
	          left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
   			   and vp.data_fim is null
             where 1 = 1
			<cfif Len(Trim(arguments.tipo))>
            	<cfif arguments.tipo eq 1>
					and upper(vd.cod_veiculo) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 2>
                	and upper(vd.placa) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 3>
                	and upper(vd.renavan) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 4>
                	and upper(ma.marca) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 5>
                	and upper(md.modelo) like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 6>
                	and upper(vd.uf) like upper('%#arguments.valor#%')
                </cfif>
            </cfif>
			<cfif Len(Trim(arguments.placa))>
			   and upper(vd.placa) like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('%#arguments.cod_veiculo#%')
			</cfif>		
			<cfif Len(Trim(arguments.proprietario))>
			</cfif>
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('%'||'#arguments.frota#%')
			       or vd.cod_veiculo like upper('%'||'#arguments.frota#%'))
			</cfif>	)vd	
			 where 1 = 1
			<cfif Len(Trim(arguments.proprietario))>
			   and oper.pkg_veiculo.fnc_veiculo_proprietario(vd.placa) in (#arguments.proprietario#)
			</cfif>
			 order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

    <!--- 
	-- PROPSITO
	-- Retorna todos os modelos de veculos cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_modelos" displayname="Retorna todos os modelos de veculos cadastradas" output="true" returntype="query" access="remote">
		<cfargument name="marca_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vm.marca_id, vm.modelo_id, vm.modelo
			  from oper.v$veiculo_modelo vm
             where 1=1			  
			<cfif Len(Trim(arguments.marca_id))>
			   and marca_id = #arguments.marca_id#
			</cfif>		
			order by modelo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
    
	<!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_proprietario" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa, 
             		p.cliente as nome, 
                    p.cnpj_cpf, 
                    p.identificador, 
                    to_char(vp.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio, 
                    vp.cod_pessoa,
		 		    v.chassis, 
                    m.marca, 
                    v.ano,
       				pe.logradouro||' '||pe.numero as endereco,
			        pe.municipio as municipio_uf

	     from oper.v$veiculo v
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
		 inner join oper.v$veiculo_proprietario vp
				 on vp.placa = v.placa
				and vp.data_fim is null 
		 inner join kss.v$pessoa p
				 on p.cod_pessoa = vp.cod_pessoa
         inner join kss.v$pessoa_endereco pe on pe.cod_pessoa = p.cod_pessoa
                                    and pe.endereco_padrao = 1        
			  where 1=1				  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>		
            
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_proprietario_doc" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa, 
             		p.cliente as nome, 
                    p.cnpj_cpf, 
                    p.identificador, 
                    vp.data_inicio, 
                    vp.cod_pessoa,
		 		    v.chassis, 
                    m.marca, 
                    v.ano
	           from oper.v$veiculo v
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
		 inner join oper.v$veiculo_proprietario_doc vp
				 on vp.placa = v.placa
				and vp.data_fim is null 
		 inner join kss.v$pessoa p
				 on p.cod_pessoa = vp.cod_pessoa
        
			  where 1=1				  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>
            
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	


    
	<!--- 
	-- PROPSITO
	-- Retorna dados do permissionario do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_permissionario" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.placa,
                   p.cliente as nome,
                   p.razao_social,
                   p.cnpj_cpf,
                   p.identificador,
                   vp.data_inicio,
                   vp.cod_pessoa,
                   v.chassis,
                   m.marca,
                   v.ano,
                   oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, sysdate) as capacidade,
                   pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero ||
                   decode(pe.complemento, '', '', ' - ') || pe.complemento endereco,
                   pe.municipio as local,
                   pe.uf,
                   pe.municipio_id,
                   pe.municipio as municipio_uf,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 6) as permisso_numero,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 7) as permisso_data,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 8) as apolice_numero,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9) as apolice_vencimento,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'TARA') as tara,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'CAPACIDADE_TRACAO') as capacidade_tracao,
                   trunc(to_date(decode(kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9), '0', to_char(sysdate, 'dd/mm/yyyy'), kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9)), 'dd/mm/yyyy') - sysdate) as dias_venc_apolice
              from oper.v$veiculo v
             inner join oper.v$veiculo_permissionario vp
                     on vp.placa = v.placa
                    and vp.data_fim is null
             inner join kss.v$pessoa p
                     on p.cod_pessoa = vp.cod_pessoa
              left join kss.v$pessoa_endereco pe
                     on pe.cod_pessoa = vp.cod_pessoa
                    and pe.endereco_padrao = 1
              left join oper.v$veiculo_marca m
                     on m.marca_id = v.marca_id
              left join oper.v$veiculo_modelo md
                     on md.marca_id = v.marca_id
                    and md.modelo_id = v.modelo_id
             where 1 = 1
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = oper.pkg_veiculo.fnc_get_placa(upper('#arguments.placa#'))
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna dados do proprietrio do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo_motorista" displayname="Retorna dados do proprietrio do veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa,
                   p.cliente as nome,
                   p.cnpj_cpf,
                   p.identificador,
                   to_char(vp.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio,
                   vp.cod_pessoa,
                   v.chassis,
                   m.marca,
                   v.ano,
                   pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento endereco,
                   pe.municipio as local,
                   pe.uf as municipio_uf,
                   pe.municipio_id,
                   pf.cart_ident_num,
                   pf.cart_ident_orgao
              from oper.v$veiculo v
              left join oper.v$veiculo_marca m 
                     on m.marca_id = v.marca_id
              left join oper.v$veiculo_modelo md 
                     on md.marca_id = v.marca_id
                    and md.modelo_id = v.modelo_id
             inner join oper.v$veiculo_motorista vp 
                     on vp.placa = v.placa
                    and vp.data_fim is null
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = vp.cod_pessoa
             inner join kss.v$pessoa_fisica pf
                     on pf.cod_pessoa = p.cod_pessoa
              left join kss.v$pessoa_endereco pe
                     on pe.cod_pessoa = p.cod_pessoa
                    and pe.endereco_padrao = 1
             where 1 = 1		  
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			    and vp.placa = upper('#arguments.placa#')
			</cfif>		
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os proprietrios cadastrados para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_proprietario_geral" displayname="Retorna os proprietrios cadastrados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.placa, vp.cod_pessoa, to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(vp.data_fim, 'dd/mm/yyyy hh24:mi:ss') as data_fim, vp.rowid,
                   to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as old_data_inicio,
                   to_date(to_char(vp.data_inicio, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_ini,
                   to_date(to_char(vp.data_inicio, 'hh24:mi:ss'), 'hh24:mi:ss') hora_ini,
                   to_date(to_char(vp.data_fim, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(vp.data_fim, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   p.cnpj_cpf, p.razao_social,
                   vp.user_insert, vp.user_update,
                   to_char(vp.data_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert, to_char(vp.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   rownum as keyfield
              from oper.v$veiculo_proprietario vp
             inner join kss.v$pessoa p
                on p.cod_pessoa = vp.cod_pessoa 
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(vp.placa) = upper('#arguments.placa#')
            </cfif>
              order by vp.data_inicio desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Retorna os permissionrios cadastrados para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_permissionario_geral" displayname="Retorna os permissionrios cadastrados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.placa, vp.cod_pessoa, to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(vp.data_fim, 'dd/mm/yyyy hh24:mi:ss') as data_fim, vp.rowid,
                   to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as old_data_inicio,
                   to_date(to_char(vp.data_inicio, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_ini,
                   to_date(to_char(vp.data_inicio, 'hh24:mi:ss'), 'hh24:mi:ss') hora_ini,
                   to_date(to_char(vp.data_fim, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(vp.data_fim, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   p.cnpj_cpf, p.razao_social,
                   vp.user_insert, vp.user_update,
                   to_char(vp.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert, to_char(vp.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   rownum as keyfield
              from oper.v$veiculo_permissionario vp
             inner join kss.v$pessoa p
                on p.cod_pessoa = vp.cod_pessoa 
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(vp.placa) = upper('#arguments.placa#')
            </cfif>
             order by vp.data_inicio desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os proprietrios de documentos cadastrados para um veculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 23/03/2009
	--->	
	<cffunction name="get_veiculo_proprietario_doc_geral" displayname="Retorna os proprietrios de documentos cadastrados para um veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.placa, vp.cod_pessoa, to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(vp.data_fim, 'dd/mm/yyyy hh24:mi:ss') as data_fim, vp.rowid,
                   to_char(vp.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as old_data_inicio,
                   to_date(to_char(vp.data_inicio, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_ini,
                   to_date(to_char(vp.data_inicio, 'hh24:mi:ss'), 'hh24:mi:ss') hora_ini,
                   to_date(to_char(vp.data_fim, 'dd/mm/yyyy'), 'dd/mm/yyyy') data_f,
                   to_date(to_char(vp.data_fim, 'hh24:mi:ss'), 'hh24:mi:ss') hora_f,
                   p.cnpj_cpf, p.razao_social,
                   vp.user_insert, vp.user_update,
                   to_char(vp.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert, to_char(vp.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update, 
                   rownum as keyfield
              from oper.v$veiculo_proprietario_doc vp
             inner join kss.v$pessoa p
                on p.cod_pessoa = vp.cod_pessoa
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and upper(vp.placa) = upper('#arguments.placa#')
            </cfif>
             order by vp.data_inicio desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do veculo desengatados
	-- NOTAS EXPLICATIVAS
	-- 07/12/2005 - criado
	--->	
    <cffunction name="get_desengate" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
         <cfargument name="placa" required="yes"> 
         <cfargument name="somente_engatados" required="no" default="0" >
         <cfquery datasource="#session.dsn#" name="qr_engate" username="#session.usuario#" password="#session.senha#">
                    select to_char(data_hora_engate,'dd/mm/yyyy hh24:mi:ss') as data_hora_engate, km_engate,
                           to_char(data_hora_desengate,'dd/mm/yyyy hh24:mi:ss') as data_hora_desengate
                    from oper.v$veiculo_composicao
                    where placa_1 = '#arguments.PLACA#'
                    <cfif arguments.somente_engatados eq 1 >
                      and data_hora_desengate is null
                    </cfif>
           </cfquery>        
       <cfreturn qr_engate>
     </cffunction>   
      
</cfcomponent>