<cfcomponent extends="_transportes.manipulacao.cfc_pneus">

	<!--- 
	-- PROPSITO
	-- Registra uma nova observao para o pneu
	-- CRISTOFER 08/02/2006
	--->	
	<cffunction name="registra_observacao" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="no">
		<cfargument name="observacoes" required="no">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update oper.v$pneu
				   set observacoes = '[' || user || '] ' || to_char(sysdate,'dd/mm hh24:mi') || ' - #arguments.observacoes# ' || decode(observacoes,null,observacoes, chr(10) || observacoes)
				 where pneu_id = #arguments.pneu_id#
			</cfquery>			
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Observao registrada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Envia um pneu para o conserto
	-- CRISTOFER 02/02/2006
	--->
	<cffunction name="envia_pneu_conserto" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="data" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_envia_pneu_conserto" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
				<cfprocparam type="in" dbvarname="p_data_envio_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Registrado o envio do pneu para conserto.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	    
    
    <!--- 
	-- PROPSITO
	-- Cancela o envio de um pneu para a reforma
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="cancela_envio_reforma" returntype="struct" access="remote">
		<cfargument name="conserto_id" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_del_envio_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Envio para reforma cancelado com sucesso. Pneu novamente no estoque.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o conserto do pneu
	-- CRISTOFER 02/02/2006
	--->
	<cffunction name="confirma_retorno_conserto" returntype="struct" access="remote">
		<cfargument name="conserto_id" required="yes">
		<cfargument name="data_retorno_reforma" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="num_nota_fiscal" required="yes">
		<cfargument name="tipo_conserto_id" required="yes">
		<cfargument name="mm_sulco" required="yes">
		<cfargument name="consertos" required="no">		
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_confirma_retorno_conserto" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_tipo_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.tipo_conserto_id#">
				<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#">
				<cfprocparam type="in" dbvarname="p_custo" cfsqltype="cf_sql_float" value="#arguments.valor#">
				<cfprocparam type="in" dbvarname="p_data_retorno_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
				<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
				<cfprocparam type="in" dbvarname="p_mm_sulco" cfsqltype="cf_sql_integer" value="#arguments.mm_sulco#" null="#iif(isdefined("arguments.mm_sulco") and len(trim(arguments.mm_sulco)),de("no"),de("yes"))#" >
			</cfstoredproc>
			<cfscript>
				v_tipo_conserto_id = this.ListaToArray (lista = arguments, variavel = "L_TIPO_CONSERTO_ID_CONSERTOS");
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "L_QUANTIDADE_CONSERTOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_tipo_conserto_id)#" index="count">
				<cfloop from="1" to="#v_quantidade[count]#" index="qnt">
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_ins_conserto_reforma" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
						<cfprocparam type="in" dbvarname="p_data" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
						<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#">
						<cfprocparam type="in" dbvarname="p_tipo_conserto_id" cfsqltype="cf_sql_integer" value="#v_tipo_conserto_id[count]#">
					</cfstoredproc>			
				</cfloop>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Retorno do conserto confirmado com sucesso. Pneu novamente no estoque.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Envia uma listagem de pneus para a reforma
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="envia_lista_pneus_reforma" returntype="struct" access="remote">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="data_envio_reforma" required="yes">
		<cftry>
			<cfscript>
				v_pneu_id = this.ListaToArray (lista = arguments, variavel = "PNEU_ID_PNEUS");
			</cfscript>
			<cfset retorno.erro = false>
			<cfloop from="1" to="#ArrayLen(v_pneu_id)#" index="count">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_envia_pneu_reforma" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#v_pneu_id[count]#">
					<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#">
					<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
					<cfprocparam type="in" dbvarname="p_data_envio_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data_envio_reforma#">
				</cfstoredproc>				
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu(s) enviado(s) para reforma com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		
    
    <!--- 
	-- PROPSITO
	-- Confirma o retorno de um pneu da reforma
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="confirma_retorno_reforma" returntype="struct" access="remote">
		<cfargument name="conserto_id" required="yes">
		<cfargument name="data_retorno_reforma" required="yes">
		<cfargument name="custo" required="yes">
		<cfargument name="garantia_carcaca" required="no">
		<cfargument name="garantia_reforma" required="no">
		<cfargument name="num_nota_fiscal" required="yes">
		<cfargument name="recusa_reforma" required="no">
		<cfargument name="motivo_recusa" required="no">
		<cfargument name="pneu_id" required="no">		
		<cfargument name="sucatear" required="no">
		<cfargument name="novos_consertos" required="no">
		<cfargument name="consertos" required="no">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_confirma_retorno_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
				<cfprocparam type="in" dbvarname="p_data_retorno_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
				<cfprocparam type="in" dbvarname="p_custo" cfsqltype="cf_sql_float" value="#arguments.custo#" null="#iif(isdefined("arguments.custo") and len(trim(arguments.custo)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_garantia_carcaca" cfsqltype="cf_sql_integer" value="#arguments.garantia_carcaca#" null="#iif(isdefined("arguments.garantia_carcaca") and len(trim(arguments.garantia_carcaca)),de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_garantia_reforma" cfsqltype="cf_sql_integer" value="#arguments.garantia_reforma#" null="#iif(isdefined("arguments.garantia_reforma") and len(trim(arguments.garantia_reforma)),de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#" null="#iif(isdefined("arguments.num_nota_fiscal") and len(trim(arguments.num_nota_fiscal)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_recusa_reforma" cfsqltype="cf_sql_integer" value="#arguments.recusa_reforma#">
				<cfprocparam type="in" dbvarname="p_motivo_recusa" cfsqltype="cf_sql_varchar" value="#arguments.motivo_recusa#" null="#iif(isdefined("arguments.motivo_recusa") and len(trim(arguments.motivo_recusa)),de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_pneu_id_garantia" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#" null="#iif(isdefined("arguments.pneu_id") and len(trim(arguments.pneu_id)) and arguments.GARANTIA_OUTRO_PNEU eq 1,de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_sucatear" cfsqltype="cf_sql_integer" value="#arguments.sucatear#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_tecnico_analise" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
			</cfstoredproc>
			<cfscript>
				v_tipo_conserto_id = this.ListaToArray (lista = arguments, variavel = "L_TIPO_CONSERTO_ID_CONSERTOS");
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "L_QUANTIDADE_CONSERTOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_tipo_conserto_id)#" index="count">
				<cfloop from="1" to="#v_quantidade[count]#" index="qnt">
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_ins_conserto_reforma" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
						<cfprocparam type="in" dbvarname="p_data" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
						<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#">
						<cfprocparam type="in" dbvarname="p_tipo_conserto_id" cfsqltype="cf_sql_integer" value="#v_tipo_conserto_id[count]#">
					</cfstoredproc>			
				</cfloop>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Retorno do pneu confirmado com sucesso! Pneu novamente no estoque.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	
	<!--- 
	-- PROPSITO
	-- Realiza uma recapagem do pneu
	-- CRISTOFER 27/01/2006
	--->
	<cffunction name="mov_recapagem" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="km_veiculo" required="yes">
		<cfargument name="laudo_desmontagem_id" required="yes">
		<cfargument name="data_hora" required="yes">
		<cfargument name="mm_desmontagem" required="yes">
		<cfargument name="medida_1" required="yes">
		<cfargument name="medida_2" required="yes">
		<cfargument name="medida_3" required="yes">
		<cfargument name="laudo_analise" required="no">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="cod_pessoa_motorista" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_km_veiculo" cfsqltype="cf_sql_integer" value="#arguments.km_veiculo#">
				<cfprocparam type="in" dbvarname="p_laudo_desmontagem_id" cfsqltype="cf_sql_integer" value="#arguments.laudo_desmontagem_id#">
				<cfprocparam type="in" dbvarname="p_data_desmontagem" cfsqltype="cf_sql_varchar" value="#arguments.data_hora#">
				<cfprocparam type="in" dbvarname="p_mm_desmontagem" cfsqltype="cf_sql_integer" value="#arguments.mm_desmontagem#">
				<cfprocparam type="in" dbvarname="p_medida_1" cfsqltype="cf_sql_integer" value="#arguments.medida_1#">
				<cfprocparam type="in" dbvarname="p_medida_2" cfsqltype="cf_sql_integer" value="#arguments.medida_2#">
				<cfprocparam type="in" dbvarname="p_medida_3" cfsqltype="cf_sql_integer" value="#arguments.medida_3#">
				<cfprocparam type="in" dbvarname="p_laudo_analise" cfsqltype="cf_sql_integer" value="#arguments.laudo_analise#" null="#iif(isDefined("arguments.laudo_analise") and Len(Trim(arguments.laudo_analise)),DE("no"),DE("yes"))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_departamento" cfsqltype="cf_sql_integer" value="#session.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" cfsqltype="cf_sql_integer" value="#session.cod_setor#">
				<cfprocparam type="in" dbvarname="p_cod_centro_custo" cfsqltype="cf_sql_integer" value="#session.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#">
				<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_responsavel" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_responsavel#" null="#iif(len(trim(arguments.cod_pessoa_responsavel)) ,DE('no'),DE('yes'))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu desmontado e enviado para a reforma com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>			
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Realiza um inventario de Pneu
	-- CRISTOFER 19/01/2006
	--->
	<cffunction name='ins_inventario_pneu' displayname='Realiza um inventario de Pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_PNEU' required='yes'>
		<cfargument name='NUM_INTERNO' required='no' default=''>
		<cfargument name='SERIE' required='no' default="1">
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='SULCO_ATUAL' required='yes'>
		<cfargument name='ANO_FABRICACAO' required='yes'>
		<cfargument name='DATA_AQUISICAO' required='yes'>
		<cfargument name='PNEU_REFORMADO' required='yes'>
		<cfargument name='REFORMAS' required='yes'>
		<cfargument name='BORRACHA_ID' required='yes'>
		<cfargument name='DESENHO_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_pneu_inventario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PNEU'  value='#arguments.NUM_PNEU#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_INTERNO'  value='#arguments.NUM_INTERNO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MODELO_ID'  value='#ListGetAt(arguments.MODELO_ID, 1, '_')#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MEDIDA_ID'  value='#ListGetAt(arguments.MODELO_ID, 2, '_')#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MEDIDA_RODA_ID'  value='#ListGetAt(arguments.MODELO_ID, 3, '_')#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SULCO_ATUAL'  value='#arguments.SULCO_ATUAL#'  null='#iif(len(trim(arguments.SULCO_ATUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ANO_FABRICACAO'  value='#arguments.ANO_FABRICACAO#'  null='#iif(len(trim(arguments.ANO_FABRICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AQUISICAO'  value='#arguments.DATA_AQUISICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_PNEU_REFORMADO'  value='#arguments.PNEU_REFORMADO#'  null='#iif(len(trim(arguments.PNEU_REFORMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_REFORMAS'  value='#arguments.REFORMAS#'  null='#iif(len(trim(arguments.REFORMAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_BORRACHA_ID'  value='#arguments.BORRACHA_ID#'  null='#iif(len(trim(arguments.BORRACHA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DESENHO_ID'  value='#arguments.DESENHO_ID#'  null='#iif(len(trim(arguments.DESENHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_PNEU_ID' variable="retorno.PNEU_ID" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pneu inventariado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Monta um pneu na posio
	-- CRISTOFER 26/01/2006
	--->
	<cffunction name="mov_montagem" returntype="struct" access="remote">
		<cfargument name="num_gabarito" required="yes">
		<cfargument name="num_eixo" required="yes">
		<cfargument name="posicao" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="data_montagem" required="yes">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_montagem" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_num_gabarito" 	cfsqltype="cf_sql_integer" value="#arguments.num_gabarito#">
				<cfprocparam type="in" dbvarname="p_num_eixo" 		cfsqltype="cf_sql_integer" value="#arguments.num_eixo#">
				<cfprocparam type="in" dbvarname="p_posicao" 		cfsqltype="cf_sql_varchar" value="#arguments.posicao#">
				<cfprocparam type="in" dbvarname="p_placa"			cfsqltype="cf_sql_varchar" value="#arguments.placa#">
				<cfprocparam type="in" dbvarname="p_pneu_id" 		cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_data_montagem" 	cfsqltype="cf_sql_varchar" value="#arguments.data_montagem#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_responsavel" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_responsavel#" null="#iif(len(trim(arguments.cod_pessoa_responsavel)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu montado com sucesso!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gera a 
	-- CRISTOFER 19/01/2006
	--->
	<cffunction name="gera_relacao_envio" returntype="struct" access="remote">
		<cfargument name="lista_pneus" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="observacao" required="yes">
		<cftry>
			<cfset retorno.num_relacao = 0>
			<cfloop list="#arguments.lista_pneus#" index="i">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_ins_pneu_rel_reforma" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" dbvarname="p_num_relacao" cfsqltype="cf_sql_integer" value="#retorno.num_relacao#" variable="retorno.num_relacao">
					<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#i#">
					<cfprocparam type="in" dbvarname="p_reformador_id" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
					<cfprocparam type="in" dbvarname="p_data_envio" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
					<cfprocparam type="in" dbvarname="p_observacao" cfsqltype="cf_sql_varchar" value="#arguments.observacao#">
				</cfstoredproc>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Ficha de envio para reforma gerada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um pneu da analise de garantia
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="retorno_garantia" returntype="struct" access="remote">
		<cfargument name="num_pneu" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="cod_pessoa_fornecedor" required="yes">
		<cfargument name="data_envio_analise" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="sucata" required="no" default="0">
		<cfargument name="reforma" required="no" default="0">
		<cfargument name="observacao" required="no">
		<cfargument name="laudo_id" required="no">
		<cfargument name="cod_pessoa_mot_resp" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="desenho_id" required="no" default="">
		<cfargument name="num_nota_fiscal" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_retorno_analise_garantia" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_fornecedor" cfsqltype="cf_sql_integer" value="#arguments.COD_PESSOA_FORNECEDOR#">
				<cfprocparam type="in" dbvarname="p_data_envio_analise" cfsqltype="cf_sql_varchar" value="#DateFormat(arguments.DATA_ENVIO_ANALISE,'dd/mm/yyyy')# #TimeFormat(arguments.DATA_ENVIO_ANALISE,'HH:MM:SS')#">
				<cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_float" value="#arguments.VALOR#" null="#iif(len(trim(arguments.valor)), de('no'), de('yes'))#">
				<cfprocparam type="in" dbvarname="p_sucata" cfsqltype="cf_sql_integer" value="#arguments.SUCATA#">
				<cfprocparam type="in" dbvarname="p_reforma" cfsqltype="cf_sql_integer" value="#arguments.REFORMA#">
				<cfprocparam type="in" dbvarname="p_observacao" cfsqltype="cf_sql_varchar" value="#arguments.OBSERVACAO#">
				<cfprocparam type="in" dbvarname="p_laudo_id" cfsqltype="cf_sql_varchar" value="#arguments.LAUDO_ID#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_tecnico_analise" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_mot_resp" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_mot_resp#"  null="#iif(isdefined("arguments.cod_pessoa_mot_resp") and len(trim(arguments.cod_pessoa_mot_resp)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#"  null="#iif(isdefined("arguments.borracha_id") and len(trim(arguments.borracha_id)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#" null="#iif(isdefined("arguments.desenho_id") and len(trim(arguments.desenho_id)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#" null="#iif(isdefined("arguments.num_nota_fiscal") and len(trim(arguments.num_nota_fiscal)),de("no"),de("yes"))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu num. " & #arguments.num_pneu# & " teve sua anlise de garantia avaliada com sucesso.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Realiza uma venda do pneu
	-- CRISTOFER 01/02/2006
	--->	
	<cffunction name="venda_pneu" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="data_venda" required="yes">
		<cfargument name="valor_venda" required="yes">
		<cfargument name="cod_pessoa_comprador" required="yes">
		<cfargument name="complemento" required="yes">
		<cftry>
			<cfif not len(trim(session.cod_pessoa))>
				<cfthrow message="No foi possvel determinar a lotao do usurio">
			</cfif>
			<cfstoredproc procedure='oper.pkg_pneu.prc_venda_pneu' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PNEU_ID'  value='#arguments.PNEU_ID#'  null='#iif(len(trim(arguments.PNEU_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENDA'  value='#arguments.DATA_VENDA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_VENDA'  value='#arguments.VALOR_VENDA#'  null='#iif(len(trim(arguments.VALOR_VENDA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_COMPRADOR'  value='#arguments.COD_PESSOA_COMPRADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_COMPRADOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_TECNICO_ANALISE'  value='#session.cod_pessoa#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARCELAS'  value='#arguments.PARCELAS#'  null='#iif(len(trim(arguments.PARCELAS)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu vendido com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
</cfcomponent>