<cfcomponent extends="_transportes.consulta.cfc_pneus">
	<!---
	-- PROPSITO
	-- Busca os pneus apartir de uma lista
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_pneus" returntype="query" access="remote">
		<cfargument name="lista_pneus" required="no">
		<cfargument name="lista_localizacao" required="no">
		<cfargument name="pneu_id" required="no">
		<cfargument name="num_pneu" required="no">
		<cfargument name="situacao_id" required="no">
		<cfargument name="transferencia" required="no">
		<cfargument name="varios" required="no" default="">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, p.num_pneu, p.situacao_id, to_char(p.data_aquisicao,'dd/mm/yyyy') as data_aquisicao,  p.custo,
                   p.nota_fiscal_numero, p.nota_fiscal_serie, pj2.cnpj_cpf as cnpj_cpf, p.ano_fabricacao, p.marca_id, p.marca,
                   p.modelo_id, p.modelo, pb.borracha_id, pb.descricao as borracha, pd.desenho_id, pd.descricao as desenho,
                   p.sulco, p.medida_id, p.medida, p.medida_roda_id,
                   p.medida_roda, p.reformas, decode(p.reformas,0,'Novo','Reforma ' || p.reformas) as status,
                   oper.pkg_pneu.fnc_valor_pneu(p.pneu_id) as valor_estimado,
                   p.situacao,p.situacao_id,p.formato_borracha,
                   pj.cliente as filial, pl.cod_pessoa,
                   pr.data_retorno_reforma,
                   p.observacoes,
                           pj.cod_pessoa as cod_filial,
                   oper.pkg_pneu.fnc_km_rodado_pneu(p.pneu_id) as km_rodado_total,
                   (select count(*)
                    from oper.v$pneu_reforma
                   where pneu_id = p.pneu_id
                     and conserto = 1
                     and furo = 0) quant_reparos,
                   (select count(*)
                    from oper.v$pneu_reforma
                   where pneu_id = p.pneu_id
                     and conserto = 1
                     and furo = 1) quant_furos,
                  oper.pkg_pneu.fnc_reforma_bloqueada(p.pneu_id) as reforma_bloqueada,
                  p.libera_reforma_manual,
                  nvl(p.usuario_bloqueio,'Sistema') as usuario_bloqueio,
                  oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as sulco_estimado,
                  oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco_atual,
                  nvl((select pm.placa
                    from oper.v$pneu_movimentacao pm
                   where pm.pneu_id = p.pneu_id
                     and pm.data_desmontagem is null),'Desmontado') as montado_em,
                   pj2.cnpj_cpf as cnpj_cpf_proprietario,
                   pp.cod_pessoa as cod_pessoa_proprietario,
                   pj2.razao_social as proprietario,
                   (select cliente
                      from oper.v$pessoa pj
                     where pj.cod_pessoa = pr.cod_pessoa_reformador) as reformador,
                   (select nvl(sum(custo),0)
                     from oper.v$pneu_reforma pc
                      where pc.pneu_id = p.pneu_id
                      and pc.conserto = 1
                      and pc.cod_pessoa_reformador = 1) as conserto_estrada,
                    (select nvl(sum(custo),0)
                     from oper.v$pneu_reforma pc
                      where pc.pneu_id = p.pneu_id
                      and pc.conserto = 1
                      and pc.cod_pessoa_reformador <> 1) as outros_consertos, p.recompra, p.lancto_compra_pendente
                from oper.v$pneu_dados p
               left join oper.v$pneu_localizacao_atual pl
                       on pl.pneu_id = p.pneu_id
                   left join oper.v$pessoa pj
                            on pj.cod_pessoa = pl.cod_pessoa
                   left join oper.v$pneu_proprietario pp
                            on p.pneu_id = pp.pneu_id
                   and pp.data_fim is null
               left join oper.v$pessoa pj2
                     on pj2.cod_pessoa = pp.cod_pessoa
               left join oper.v$pneu_reforma pr
                      on pr.pneu_id = p.pneu_id
                   and pr.conserto = 0
              left join oper.v$pneu_borracha pb
                  on pb.borracha_id = pr.borracha_id
              left join oper.v$pneu_desenho pd
                  on pd.borracha_id = pr.borracha_id
                   and pd.desenho_id = pr.desenho_id
               where 1=1
			 and (pr.data_retorno_reforma is null or pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                         from oper.v$pneu_reforma pr2
                                        where pr2.pneu_id = pr.pneu_id
                                         and pr2.conserto = 0))
			 <cfif IsDefined("arguments.lista_pneus") and Len(Trim(arguments.lista_pneus))>
			   and p.pneu_id in (#arguments.lista_pneus#)
			 </cfif>
			 <cfif ((Len(trim(arguments.varios))) and (IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))))>
			   	and p.pneu_id in (#arguments.pneu_id#)
			 <cfelse>
			 		<cfif IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))>
			   			and p.pneu_id = #arguments.pneu_id#
			 		</cfif>
			 </cfif>
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = #arguments.num_pneu#
			 </cfif>
			 <cfif IsDefined("arguments.lista_localizacao") and Len(Trim(arguments.lista_localizacao))>
			   and pl.localizacao_id in (#arguments.lista_localizacao#)
			 </cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
			   and p.situacao_id = #arguments.situacao_id#
			 </cfif>
			 order by p.num_pneu
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as inspees de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_inspecoes" returntype="query" access="remote">
		<cfargument name="pneu_id" required="no" default="">
        <cfargument name="num_pneu" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_inspecoes" username="#session.usuario#" password="#session.senha#">
			select x.*
                 , (select count(*)
                      from oper.v$pneu_reforma pr
                     where pr.pneu_id = x.pneu_id
                       and pr.data_retorno_reforma between ultima_inspecao and x.data_inspecao) as sofreu_reforma
              from ( select pi.num_inspecao
                          , p.num_pneu
                          , p.pneu_id
                          , pi.placa
                          , oper.fnc_get_cod_veiculo(pi.placa) as cod_veiculo
                          , pi.posicao
                          , pi.data_ult_inspecao
                          , pi.km_ult_inspecao
                          , pi.mm_ult_inspecao
                          , pi.data_inspecao
                          , pi.km_inspecao
                          , pi.mm_inspecao
                          , pi.medida_1
                          , pi.medida_2
                          , pi.medida_3
                          , pi.movimentacao
                          , pa.descricao as laudo
                          , lag(pi.data_inspecao) over (order by pi.data_inspecao) as ultima_inspecao
                          , pi.pressao_encontrada
                          , pi.km_carregado
                          , pi.km_vazio
                          from oper.v$pneu_dados p
                         inner join oper.v$pneu_inspecao pi
                           on pi.pneu_id = p.pneu_id
                         left join oper.v$pneu_laudo_analise pa
                           on pa.laudo_id = pi.laudo_analise_id
                            where 1 = 1
                           <cfif Len(Trim(arguments.PNEU_ID))>
                              and pi.pneu_id = #arguments.PNEU_ID#
                           </cfif>
                           <cfif Len(Trim(arguments.NUM_PNEU))>
                              and p.num_pneu = #arguments.NUM_PNEU#
                           </cfif>
                         order by pi.data_inspecao) x
		</cfquery>
		<cfreturn qr_inspecoes>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as reformas de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_reformas" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_inspecoes" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ pr.custo, pr.conserto_id, pd.num_pneu, pd.pneu_id, pr.data_envio_reforma, pr.data_retorno_reforma, pb.descricao as borracha,
				   pr.desenho_id, d.descricao as desenho, pr.borracha_id, pj.cliente as nome_fantasia
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_reforma pr
					 on pr.pneu_id = pd.pneu_id
					and pr.conserto = 0
			 inner join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			 inner join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador
			<cfif IsDefined("arguments.PNEU_ID")>
				 where pd.pneu_id = #arguments.pneu_id#
			</cfif>
			order by pr.data_envio_reforma
		</cfquery>
		<cfreturn qr_inspecoes>
	</cffunction>


	<!---
	-- PROPSITO
	-- Busca outros custos do pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_demais_custos" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select r.conserto_id,
				   r.pneu_id,
				   r.cod_pessoa_reformador,
				   r.borracha_id,
				   r.desenho_id,
				   r.data_envio_reforma,
				   r.data_retorno_reforma,
				   r.num_relacao,
				   r.num_recibo_viagem,
				   r.num_nota_fiscal,
				   r.custo,
				   r.cod_moeda,
				   r.pneu_id_garantia,
				   r.garantia_carcaca,
				   r.garantia_reforma,
				   r.conserto,
				   r.tipo_conserto_id,
				   r.furo,
				   r.analise_garantia,
				   p.razao_social as local,
				   t.descricao as tipo
			  from oper.v$pneu_reforma r
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = r.cod_pessoa_reformador
			 inner join oper.v$pneu_tipo_conserto t
					 on r.TIPO_CONSERTO_ID = t.tipo_conserto_id
			 where r.pneu_id = #arguments.pneu_id#
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>

	<!---
	-- PROPSITO
	--
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO -  - criado
	--->
	<cffunction name="get_pneu_calibragens" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_pneu" required="no" default=""/>
		<cfargument name="pneu_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select pc.controle_id, pc.placa, oper.fnc_get_cod_veiculo(pc.placa) as frota, p.num_pneu, pm.posicao, pc.data_calibragem,
				   pc.pressao_encontrada, pc.pressao_calibrada
			  from oper.v$pneu_calibragem pc
			 inner join oper.v$pneu_movimentacao pm
					 on pm.pneu_id = pc.pneu_id
					and pm.placa = pc.placa
					and pm.data_desmontagem is null
			 inner join oper.v$pneu_veiculo_posicao pvp
					 on pvp.placa = pm.placa
					and pvp.posicao = pm.posicao
			 inner join oper.v$pneu p
					 on p.pneu_id = pc.pneu_id
			where 1=1
			<cfif Len(Trim(arguments.PNEU_ID)) >
			  and pc.pneu_id = #arguments.PNEU_ID#
		    </cfif>
			<cfif Len(Trim(arguments.NUM_PNEU)) >
			  and p.num_pneu = #arguments.NUM_PNEU#
		    </cfif>
			order by pc.data_calibragem
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o gabarito do veculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 20/01/2006
	--->
	<cffunction name="get_gabarito_veiculo" returntype="query" access="remote">
		<cfargument name="placa" 	required="no" default="">
		<cfargument name="cod_veiculo" 	required="no" default="">
		<cfargument name="pneu_id" 	required="no" default="">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = arguments.placa, sem_aspas = 1)>

		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ num_pneu, modelo, marca, borracha , desenho,  pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao,
				   placa, oper.fnc_get_cod_veiculo(placa) as frota,
				   pneu_id, data_montagem, mm_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem,
				   veiculo_modelo, suspenso, modelo_eixo_id, tipo_veiculo,
 			       decode(data_montagem,null,0,oper.pkg_pneu.fnc_km_rodado(placa, data_montagem, suspenso) ) as km_rodado,
				   trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) as dias_ult_inspecao,
				   oper.pkg_pneu.fnc_ultima_inspecao(pneu_id) as data_ult_inspecao,
				   oper.pkg_pneu.fnc_km_atual(placa) as km_atual, reformas,
				   case
					 when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0) >= mm_montagem then -1
				   else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0)
				   end mm_estimado
			  from oper.v$pneu_veiculo_gabarito pg
			 where instr('#qr_veiculo.COMPOSICAO#', placa) > 0
			 <cfif len(trim(arguments.pneu_id))>
			   and pg.pneu_id = #arguments.pneu_id#
			 </cfif>
		     order by instr('#qr_veiculo.COMPOSICAO#', placa), posicao_gabarito, ordem, num_eixo
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>


	<!---
	-- PROPSITO
	-- Busca os parametros
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 20/01/2006
	--->
	<cffunction name="get_parametros" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrParametros" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_global.fnc_get_parametro(1,'PNEU') as tolerancia_inspecao,
				   oper.pkg_global.fnc_get_parametro(2,'PNEU') as mm_minimo_reforma,
				   oper.pkg_global.fnc_get_parametro(3,'PNEU') as mm_liberacao_primeiro_eixo
			  from dual
 		</cfquery>
		<cfset session.tolerancia_inspecao = qrParametros.tolerancia_inspecao>
		<cfset session.mm_minimo_reforma = qrParametros.mm_minimo_reforma>
		<cfset session.mm_liberacao_primeiro_eixo = qrParametros.mm_liberacao_primeiro_eixo>
		<cfreturn qrParametros>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca todos os pneus enviados para a reforma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneus_enviados_reforma" returntype="query" access="remote">
		<cfargument name="conserto_id" required="no">
		<cfargument name="sem_ficha" required="no">
		<cfargument name="inclui_consertos" required="no">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS*/  pr.conserto_id, p.num_pneu, pr.pneu_id, pr.cod_pessoa_reformador,
				   pj.cliente as nome_fantasia, pr.data_envio_reforma,
				   p.marca, p.modelo, p.reformas, p.medida, p.medida_roda,
				   bo.descricao as borracha, de.descricao as desenho, pr.user_insert as usuario,
				   decode(pr.conserto,1,'Conserto','Reforma') as tipo
			  from oper.v$pneu_reforma pr
			 inner join oper.v$pneu_dados p
					 on p.pneu_id = pr.pneu_id
			 inner join oper.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador
			 inner join oper.v$pneu_localizacao_atual pl
					 on pl.pneu_id = pr.pneu_id
					and pl.data_saida is null
			 left join	oper.v$pneu_borracha bo
			         on bo.borracha_id = pr.borracha_id
		     left join oper.v$pneu_desenho de
			         on de.borracha_id = pr.borracha_id
					and de.desenho_id = pr.desenho_id
			 where pr.data_retorno_reforma is null
			   <cfif not IsDefined("arguments.inclui_consertos")>
				   and pr.conserto = 0
			   </cfif>
			   <cfif IsDefined("arguments.conserto_id")>
				   and pr.conserto_id = #arguments.conserto_id#
			   </cfif>
			   <cfif IsDefined("arguments.sem_ficha")>
				   and num_relacao is null
			   </cfif>
			   order by p.num_pneu
   		</cfquery>
		<cfreturn qrPneus>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca todos os pneus enviados para conserto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneus_enviados_conserto" returntype="query" access="remote">
		<cfargument name="conserto_id" required="no" default="">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS*/  pr.conserto_id, p.num_pneu, pr.pneu_id, pr.cod_pessoa_reformador,
				   pj.cliente as nome_fantasia, pr.data_envio_reforma,
				   p.marca, p.modelo, p.reformas, pr.user_insert as usuario,
          		   greatest(pi.medida_1, pi.medida_2, pi.medida_3) as medida_maxima
			  from oper.v$pneu_reforma pr
			 inner join oper.v$pneu_dados p
					 on p.pneu_id = pr.pneu_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador
 			  left join oper.v$pneu_localizacao_atual pl
					 on pl.pneu_id = pr.pneu_id
					and pl.data_saida is null
       		  left join oper.v$pneu_inspecao pi
					  on pi.pneu_id = pr.pneu_id
			 where pr.data_retorno_reforma is null
			   and pr.conserto = 1
			   and (pl.cod_pessoa = '#session.cod_pessoa#' or pl.cod_pessoa is null)
			   and (pi.data_inspecao = (select max(pi2.data_inspecao)
										   from oper.v$pneu_inspecao pi2
										  where pi2.pneu_id = pi.pneu_id)
				    or pi.data_inspecao is null)
			   <cfif IsDefined("arguments.conserto_id") and Len(Trim(arguments.conserto_id))>
				   and pr.conserto_id = #arguments.conserto_id#
			   </cfif>
			   order by p.num_pneu
   		</cfquery>
		<cfreturn qrPneus>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as inspecoes em aberto nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_inspecoes_abertas" returntype="query" access="remote">
		<cfargument name="todas" required="no" default="0">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.todas eq 1>
				select /*+ FIRST_ROWS*/
					    oper.fnc_get_cod_veiculo(pi.placa) as frota, pi.placa, pi.km_inspecao as km_veiculo,
						max(pi.data_inspecao) as data_inspecao, pi.user_insert, max(pi.data_insert) as data_insert,
						(select distinct cod_pessoa
						   from kss.v$kss_usuario_lotacao
						  where usuario = pi.user_insert) as cod_pessoa_filial
				  from oper.v$pneu_inspecao pi
				 where pi.mm_inspecao is null
				 group by pi.placa, pi.km_inspecao, pi.user_insert

				union
			</cfif>
			select /*+ FIRST_ROWS*/
					oper.fnc_get_cod_veiculo(pi.placa) as frota, pi.placa, pi.km_inspecao as km_veiculo,
					max(pi.data_inspecao) as data_inspecao, pi.user_insert, max(pi.data_insert) as data_insert,
					(select distinct cod_pessoa
					   from kss.v$kss_usuario_lotacao
					  where usuario = pi.user_insert) as cod_pessoa_filial
			  from oper.v$pneu_inspecao pi
			 where pi.mm_inspecao is null
			   and (oper.pkg_veiculo.fnc_veiculo_tracao(pi.placa) = 1 or
					  not exists (select 'x'
									from oper.v$veiculo_composicao vc
								   where vc.placa_2 = pi.placa
									 and vc.DATA_HORA_DESENGATE is null))
			 group by pi.placa, pi.km_inspecao, pi.user_insert

			 order by 3
   		</cfquery>
		<cfreturn qrPneus>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os dados para a montagem dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 25/01/2006
	--->
	<cffunction name="get_dados_pneu_montagem" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="posicao" required="yes">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfquery name="qrPneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_pneu.fnc_pneu_geminado('#arguments.placa#','#arguments.posicao#') as parceiro,
				   oper.pkg_pneu.fnc_medida_roda_veiculo('#arguments.placa#') as medida_roda_id,
				   num_gabarito, num_eixo, null as medida_id, null as marca_id, null as modelo_id, null as reformas,
				   null as borracha_id, null as desenho_id,
				   null as parc_num_pneu, null as parc_data_inspecao, null as parc_mm_inspecao, null as parc_mm_estimado
			  from oper.v$pneu_veiculo_posicao
			  where placa = '#arguments.placa#'
			    and posicao = '#arguments.posicao#'
   		</cfquery>
		<cfif Len(Trim(qrPneu.parceiro)) >
			<cfquery name="qrPneuParceiro"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ FIRST_ROWS */ p.num_pneu as PARC_NUM_PNEU,
					   oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as PARC_MM_ESTIMADO,
					   data_inspecao as PARC_DATA_INSPECAO, oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as PARC_MM_INSPECAO,
			           marca_id, modelo_id, medida_id, reformas, borracha_id, desenho_id,
					   #qrPneu.medida_roda_id# as medida_roda_id, #qrPneu.num_gabarito# as num_gabarito,
					   #qrPneu.num_eixo# as num_eixo, #qrPneu.parceiro# as parceiro, sulco
				  from (select pd.pneu_id, pd.num_pneu, pm.mm_montagem,
							   oper.pkg_pneu.fnc_km_rodado(pm.placa, nvl(pi.data_inspecao,pm.data_montagem), pvp.suspenso) as km_rodado,
							   oper.pkg_pneu.fnc_rendimento_pneu(pm.pneu_id, pvp.modelo_eixo_id, pvp.num_eixo, pvp.tipo_veiculo) as rendimento,
							   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.medida_id, pd.reformas, pr.borracha_id, pr.desenho_id, pd.medida_roda_id,
							   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, pd.medida, pd.medida_roda,
							   pm.placa, pm.data_montagem, pm.km_montagem, pvp.suspenso, pvp.geminado, pvp.cod_posicao,
							   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro,
							   pi.data_inspecao, pi.mm_inspecao, trunc(sysdate - pi.data_inspecao) as dias_ult_inspecao,
							   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco
						  from oper.v$pneu_dados pd
						 inner join oper.v$pneu_movimentacao pm
									 on pm.pneu_id = pd.pneu_id
						 inner join oper.v$pneu_veiculo_posicao pvp
									 on pvp.placa = pm.placa
									and pvp.num_gabarito = pm.num_gabarito
									and pvp.num_eixo = pm.num_eixo
									and pvp.posicao = pm.posicao
						 left join oper.v$pneu_inspecao pi
								 on pd.pneu_id = pi.pneu_id
						 left join oper.v$pneu_reforma pr
							    on pr.pneu_id = pd.pneu_id
						 left join oper.v$pneu_borracha pb
							 	on pb.borracha_id = pr.borracha_id
						 left join oper.v$pneu_desenho d
								on d.borracha_id = pr.borracha_id
							   and d.desenho_id = pr.desenho_id
						where pm.data_desmontagem is null
						  and pd.pneu_id = #qrPneu.parceiro#
						  and (pi.data_inspecao = (select max(pi2.data_inspecao)
						                            from oper.v$pneu_inspecao pi2
						                           where pi2.pneu_id = pi.pneu_id)
					           or pi.data_inspecao is null)
						  and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0)
							   or (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0) is null)) p

			</cfquery>
			<cfreturn qrPneuParceiro>
		</cfif>
		<cfreturn qrPneu>
	</cffunction>

    <!---
	-- PROPSITO
	-- Monta a ficha de inspecao do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_ficha_inspecao" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="ficha_inspecao" hint="Quando for uma ficha para inspeo e no movimentacao" required="no">
		<cfif Len(Trim(arguments.cod_veiculo))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = arguments.placa, sem_aspas = 1)>
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select p.num_pneu,
				   p.modelo,
				   p.marca,
				   p.borracha,
				   p.desenho,
				   pmov_id,
				   p.num_gabarito,
				   p.num_eixo,
				   caminho_imagem,
				   posicao,
				   placa,
				   oper.fnc_get_cod_veiculo(placa) as frota,
				   p.pneu_id,
				   p.data_montagem,
				   mm_montagem,
				   km_montagem,
				   eixo_posicao,
				   posicao_gabarito,
				   ordem,
				   veiculo_modelo,
				   suspenso,
				   modelo_eixo_id,
				   tipo_veiculo,
				   decode(p.num_eixo,0,0,(oper.pkg_pneu.fnc_km_rodado(p.placa, p.data_montagem, suspenso)))as km_rodado,
				   oper.pkg_pneu.fnc_km_atual(placa) as km_atual,
				   p.reformas,
				   oper.pkg_pneu.fnc_reforma_bloqueada(p.pneu_id) as reforma_bloqueada,
				   pj.cliente as reformador,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 0) quant_reparos,
				   (select count(*)
					  from oper.v$viagem_recibo
					 where placa = p.placa
					   and confirmado = 0) quant_consertos_enviados,
				   case
					 when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id), 1), 0) >= mm_montagem
					 then -1
					 else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id), 1), 0)
				   end mm_estimado,
				   to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 1)) as tolerancia,
				   decode(pn.observacoes, null, 0, 1) as possui_observacoes,
                   1 as ordem_placa,
                   0 as dias_ult_inspecao,
       null as ordem_placa
			  from oper.v$pneu_veiculo_gabarito p
			  left join oper.v$pneu pn on pn.pneu_id = p.pneu_id
			  left join kss.v$pessoa pj on pj.cod_pessoa =
													 p.cod_pessoa_reformador
			 where instr('#qr_veiculo.COMPOSICAO#', placa) > 0
			 order by instr('#qr_veiculo.COMPOSICAO#', placa), num_eixo, ordem
			 </cfquery>
		<cfreturn qr_pneus>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as ocorrencias de pneus no veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_ocorrencias_veiculo" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="yes">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="data_inicial_desmontagem" required="no" default="">
		<cfargument name="data_final_desmontagem" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select case when pm.data_desmontagem is null then 1 else 0 end as montado,
				   p.num_pneu,
				   pm.pmov_id,
				   pm.num_eixo,
				   pm.posicao,
				   pg.COD_POSICAO,
				   oper.fnc_get_cod_veiculo(pm.placa) placa,
				   pm.pneu_id,
				   pm.data_montagem,
				   pm.mm_montagem,
				   pm.km_montagem,
				   pm.data_desmontagem,
				   pm.mm_desmontagem,
				   pm.km_desmontagem,
				   pm.laudo_desmontagem_id,
				   pl.descricao as laudo,
				   pm.medida_1,
				   pm.medida_2,
				   pm.medida_3,
				   pm.user_insert as inserido_por,
				   pm.user_update as alterado_por
			  from oper.v$pneu_movimentacao pm
			 inner join oper.v$pneu_dados p
					 on p.pneu_id = pm.pneu_id
			 inner join oper.v$pneu_gabarito_posicao pg
					 on pm.NUM_GABARITO = pg.NUM_GABARITO
					and pm.NUM_EIXO = pg.NUM_EIXO
					and pm.POSICAO = pg.POSICAO
			  left join oper.v$pneu_laudo_desmontagem pl
					 on pl.LAUDO_ID = pm.LAUDO_DESMONTAGEM_ID
			 inner join oper.v$pneu_posicao pp
					 on pg.cod_posicao = pp.COD_POSICAO
			 where placa = oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#')
			 <cfif len(trim(arguments.data_inicial))>
			 	and trunc(data_montagem) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			 	and trunc(data_montagem) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.data_inicial_desmontagem))>
			 	and trunc(data_desmontagem) >= '#arguments.data_inicial_desmontagem#'
			 </cfif>
			 <cfif len(trim(arguments.data_final_desmontagem))>
			 	and trunc(data_desmontagem) <= '#arguments.data_final_desmontagem#'
			 </cfif>
			 order by 1 desc , pm.num_eixo, pp.ordem
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>


	<!---
	-- PROPSITO
	-- Busca as borracharias
	-- CRISTOFER  31/08/2006
	--->
	<cffunction name="get_borracharia" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_organograma,
				   municipio
			  from oper.v$setor_informacoes s
			 where possui_borracharia = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o rendimento sintetico
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="perc_consumido" required="no">
		<cfargument name="considera_peso" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
			select a.marca_borracha || '-' || medida as marca_borracha,
				   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
					   round(decode(a.peso_tracionado,1,a.rendimento, a.rendimento * (a.peso_tracionado/b.max_peso))) as rendimento,
				   <cfelse>
					   a.rendimento,
				   </cfif>
				   a.peso_tracionado,b.max_peso, mm_consumido,
				   case
					  when eixo = 'D' then 1
					  when eixo = 'T' then 2
					  when eixo = 'R' then 3
					  when eixo = '1' then 4
					  when eixo = '2' then 5
					  when eixo = '3' then 6
				   end ordem,
				   case
					  when eixo = 'D' then 'eixo Dianteiro'
					  when eixo = 'T' then 'eixo Tracao'
					  when eixo = 'R' then 'eixo Truck'
					  when eixo = '1' then 'Primeiro eixo'
					  when eixo = '2' then 'Segundo eixo'
					  when eixo = '3' then 'Terceiro eixo'
				   end eixo
			  from (select eixo, marca_borracha, medida, round(km_percorrido/mm_consumido) as rendimento,
						   round(decode(eixo,'T',peso_tracionado,1)) as peso_tracionado, mm_consumido
					  from (select eixo,  decode(r.reformas, 0, marca, borracha) as marca_borracha,r.medida,
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
									  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
								  <cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
								     and r.perc_consumido >= #arguments.perc_consumido#
								  </cfif>
									 group by eixo, decode(r.reformas, 0,  marca, borracha), r.medida
									 order by eixo,  decode(r.reformas, 0,marca, borracha)
								 )) a,
					(select max(round(decode(eixo,'T',peso_tracionado,1))) as max_peso
					  from (select eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha) as marca_borracha,r.medida,
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
							  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
									 group by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha), r.medida
									 order by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha)
								 )) b
				where a.mm_consumido > 50
				  order by ordem
		</cfquery>
		<cfreturn qr_rendimento>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o rendimento sintetico parcial
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico_parcial" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="considera_peso" required="no">
		<cfargument name="mm_ate" required="yes">
		<cfargument name="perc_consumido" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
		  <cfif IsDefined("arguments.reformas") and ((ListLen(arguments.reformas) gte 1 and ListFind(arguments.reformas,'0')) or not Len(Trim(arguments.reformas)))>
				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case
							  when eixo = 'D' then 1
							  when eixo = 'T' then 2
							  when eixo = 'R' then 3
							  when eixo = '1' then 4
							  when eixo = '2' then 5
							  when eixo = '3' then 6
						   end ordem,
						   case
							  when eixo = 'D' then 'eixo Dianteiro'
							  when eixo = 'T' then 'eixo Tracao'
							  when eixo = 'R' then 'eixo Truck'
							  when eixo = '1' then 'Primeiro eixo'
							  when eixo = '2' then 'Segundo eixo'
							  when eixo = '3' then 'Terceiro eixo'
						   end eixo,
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo,
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'T',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'T',peso_tracionado,1)) as peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, r.marca, r.modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido)
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido)
												  over (partition by r.marca_id, r.modelo_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido)
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where reformas = 0
										<cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
										  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
										</cfif>
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#)
				   where rank =1
				     and mm > 50
			   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>
				   union
			   </cfif>
			</cfif>

		   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>

				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case
							  when eixo = 'D' then 1
							  when eixo = 'T' then 2
							  when eixo = 'R' then 3
							  when eixo = '1' then 4
							  when eixo = '2' then 5
							  when eixo = '3' then 6
						   end ordem,
						   case
							  when eixo = 'D' then 'eixo Dianteiro'
							  when eixo = 'T' then 'eixo Tracao'
							  when eixo = 'R' then 'eixo Truck'
							  when eixo = '1' then 'Primeiro eixo'
							  when eixo = '2' then 'Segundo eixo'
							  when eixo = '3' then 'Terceiro eixo'
						   end eixo,
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo,
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'T',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'T',peso_tracionado,1)) as peso_tracionado,
								 			  borracha_id as marca_id, desenho_id as modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo,
											  r.borracha as marca, r.desenho as modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido)
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido)
												  over (partition by r.borracha_id, r.desenho_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido)
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where 1=1
										<cfif Len(Trim(arguments.reformas))>
										  and reformas in (#arguments.reformas#)
										<cfelse>
										  and reformas > 0
										</cfif>
										<cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
										   and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
										</cfif>
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#)
				   where rank =1
				     and mm > 50
			  </cfif>
				  order by ordem, 1
		</cfquery>
		<cfreturn qr_rendimento>
	</cffunction>
	<!---
	-- PROPSITO
	-- Busca o rendimento dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneu_rendimento" returntype="query" access="remote">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="marca_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="borracha_id" required="no">
		<cfargument name="medida_id" required="no">
		<cfargument name="medida_roda_id" required="no">
		<cfargument name="desenho_id" required="no">
		<cfargument name="eixo" required="no">
		<cfargument name="lado" required="no">
		<cfargument name="faixa_peso_inicio" required="no">
		<cfargument name="faixa_peso_final" required="no">
		<cfargument name="de_perc_consumido" required="no">
		<cfargument name="ate_perc_consumido" required="no">
		<cfargument name="ordem" required="no" default="num_pneu">
		<cfargument name="inspecoes_desde" required="no" default="">
		<cfargument name="inspecoes_ate" required="no" default="">
		<cfargument name="data_aquisicao" required="no" default="">
		<cfargument name="data_aquisicao_final" required="no" default="">
		<cfargument name="grupo" required="no">
		<cfargument name="desgaste_excessivo" required="no">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
		select r.pneu_id,
		       r.num_pneu,
			   r.marca,
			   r.marca_id,
			   r.modelo,
			   r.modelo_id,
			   r.borracha,
			   r.borracha_id,
			   r.desenho_id,
			   r.desenho,
			   posicao, placa, sulco_manta,
			   data_aquisicao,
			   decode(r.reformas,0,'Novo','Reforma ' || r.reformas) as reformas, num_eixo, tipo_veiculo_id, tipo_veiculo, eixo,
			   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
			   decode(r.reformas, 0, marca, borracha) as marca_borracha,
			   decode(r.reformas, 0, modelo || ' - ' || medida, desenho) as modelo_desenho,
			   round(avg(peso_tracionado)/1000) as peso_tracionado,
			   decode( sum(mm_consumido),0, sum(km_percorrido),round(sum(km_percorrido) / sum(mm_consumido))) as rendimento,
			   round((r.sulco_manta-2) * decode(sum(mm_consumido),0,sum(km_percorrido), round(sum(km_percorrido) / sum(mm_consumido)))) as projetado,
			   situacao, round(((sum(mm_consumido))/(sulco_manta-2))*100) as perc_consumido,
			   r.sulco_manta,
			   case when exists (select 'x'
								 from oper.v$pneu_movimentacao pm
								where pm.placa = r.placa
								  and pm.PNEU_ID = r.pneu_id
								  and pm.data_desmontagem is null) then 1 else 0 end as montado,
	           pr.custo as custo_reforma
		 <cfif IsDefined("arguments.DESGASTE_EXCESSIVO") AND arguments.DESGASTE_EXCESSIVO EQ 1>
			  from oper.v$pneu_rendimento_total r
		 <cfelse>
			  from oper.v$pneu_rendimento r
		 </cfif>
			  left join oper.v$pneu_reforma pr
					 on pr.conserto_id = r.reforma_id
 			 where 1=1
			 <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
			   and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
			 </cfif>
			 <cfif IsDefined("arguments.marca_id") and Len(Trim(arguments.marca_id))>
			   and marca_id = #arguments.marca_id#
			 </cfif>
			 <cfif IsDefined("arguments.modelo_id") and Len(Trim(arguments.modelo_id))>
			   and modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif IsDefined("arguments.borracha_id") and  Len(Trim(arguments.borracha_id))>
			   and borracha_id = #arguments.borracha_id#
			 </cfif>
			 <cfif IsDefined("arguments.medida_roda_id") and Len(Trim(arguments.medida_roda_id))>
			   and medida_roda_id in (#arguments.medida_roda_id#)
			 </cfif>
			 <cfif IsDefined("arguments.medida_id") and  Len(Trim(arguments.medida_id))>
			   and medida_id in (#arguments.medida_id#)
			 </cfif>
			 <cfif IsDefined("arguments.desenho_id") and Len(Trim(arguments.desenho_id))>
			   and desenho_id = #arguments.desenho_id#
			 </cfif>
			 <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
			   and reformas in (#arguments.reformas#)
			 </cfif>
			 <cfif IsDefined("arguments.eixo") and Len(Trim(arguments.eixo))>
			   and eixo = '#arguments.eixo#'
			 </cfif>
			 <cfif len(trim(arguments.faixa_peso_inicio))>
			   and round(peso_tracionado/1000) between #arguments.faixa_peso_inicio# and #arguments.faixa_peso_final#
			 </cfif>
			 <cfif len(trim(arguments.inspecoes_desde))>
			   and trunc(data_inspecao) >= '#arguments.inspecoes_desde#'
			 </cfif>
			 <cfif len(trim(arguments.inspecoes_ate))>
			   and trunc(data_inspecao) <= '#arguments.inspecoes_ate#'
			 </cfif>
			 <cfif len(trim(arguments.data_aquisicao))>
			   and trunc(data_aquisicao) >= '#arguments.data_aquisicao#'
			 </cfif>
			 <cfif len(trim(arguments.data_aquisicao_final))>
			   and trunc(data_aquisicao) <= '#arguments.data_aquisicao_final#'
			 </cfif>
			 <cfif len(trim(arguments.grupo))>
			   and grupo in (#ListQualify(arguments.grupo, "'", ",")#)
			 </cfif>
			 <cfif IsDefined("arguments.lado") and Len(Trim(arguments.lado))>
			   and cod_posicao in (#ListQualify(UCase(arguments.lado),"'",",")#)
			 </cfif>

			 group by r.pneu_id,
			          r.num_pneu,
					  r.marca,
					  r.marca_id,
					  r.modelo,
					  r.modelo_id,
					  r.medida,
					  r.borracha,
					  r.borracha_id,
					  r.desenho_id,
					  r.desenho,
					  r.posicao,
					  placa,
					  pr.custo,
					  decode(r.reformas, 0, 'Novo', 'Reforma ' || r.reformas), r.reformas, num_eixo,
									tipo_veiculo_id, tipo_veiculo, eixo,
									decode(r.reformas, 0, marca, borracha),
									decode(r.reformas, 0, modelo, desenho), sulco_manta, data_aquisicao,situacao
			 having 1=1
			 <cfif IsDefined("arguments.de_perc_consumido") and Len(Trim(arguments.de_perc_consumido))>
			   and round(((sum(mm_consumido))/(sulco_manta-2))*100) >= #arguments.de_perc_consumido#
			 </cfif>
			 <cfif IsDefined("arguments.ate_perc_consumido") and Len(Trim(arguments.ate_perc_consumido))>
			   and round(((sum(mm_consumido))/(sulco_manta-2))*100) <= #arguments.ate_perc_consumido#
			 </cfif>

				 order by r.reformas, tipo_veiculo_id, eixo, decode(r.reformas, 0, marca, borracha),
						  decode(r.reformas, 0, modelo, desenho)
			</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 18/01/2006
	--->
	<cffunction name="get_reformadores" returntype="query" access="remote">
		<cfargument name="cod_pessoa_reformador" required="no">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="sem_imagem" required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select pj.cliente as nome_fantasia,
				   prb.cod_pessoa_reformador,
				   pb.borracha_id,
				   pb.descricao as borracha
			  from oper.v$pneu_reformador_bandeira prb
			 inner join oper.v$pneu_borracha pb
					 on pb.borracha_id = prb.borracha_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = prb.cod_pessoa_reformador
			 where 1=1
			   <cfif IsDefined("arguments.cod_pessoa_reformador")>
			   and prb.cod_pessoa_reformador = #arguments.cod_pessoa_reformador#
			   </cfif>
			   <cfif len(trim(arguments.borracha_id))>
			   and pb.borracha_id = #arguments.borracha_id#
			   </cfif>
			order by pj.cliente
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os dados para a troca dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 24/01/2006
	--->
	<cffunction name="get_dados_pneu_troca" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
        <cfargument name="desmontagem" required="no" default="0">
        <cfquery name="qrPneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED */ pneu_id, num_pneu, num_gabarito, num_eixo ,marca_id, mm_montagem, data_montagem, pmov_id,
                   modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
                   medida, medida_roda, placa, data_montagem, km_montagem, suspenso, geminado, cod_posicao, parceiro,
                   null as parc_num_pneu, null as parc_data_inspecao, null as parc_mm_inspecao, null as parc_mm_estimado,
                   0 as dias_ult_inspecao, posicao,
                   case
                      when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) >= 2 then mm_montagem
                      when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) < 2 then oper.pkg_pneu.fnc_sulco_atual(pneu_id)
                   end sulco_parametro, medida_id, tempo_montagem
              from (select pm.pneu_id, pd.num_pneu, pm.mm_montagem, pm.posicao, pm.pmov_id,
                           pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas,
                           pr.borracha_id, pr.desenho_id, pd.medida_roda_id, pd.medida_id,
                           pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha,
                           pd.medida, pd.medida_roda, pm.placa, to_char(pm.data_montagem,'dd/mm/yyyy hh24:mi') as data_montagem, pm.km_montagem,
                           round(sysdate - pm.data_montagem)*24 as tempo_montagem,
                           pvp.suspenso, pvp.geminado, pvp.cod_posicao,
                           oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro
                      from oper.v$pneu_dados pd
                     inner join oper.v$pneu_movimentacao pm
                                 on pm.pneu_id = pd.pneu_id
                     inner join oper.v$pneu_veiculo_posicao pvp
                                 on pvp.placa = pm.placa
                                and pvp.num_gabarito = pm.num_gabarito
                                and pvp.num_eixo = pm.num_eixo
                                and pvp.posicao = pm.posicao
                      left join oper.v$pneu_reforma pr
                             on pr.pneu_id = pd.pneu_id
                      left join oper.v$pneu_borracha pb
                             on pb.borracha_id = pr.borracha_id
                      left join oper.v$pneu_desenho d
                             on d.borracha_id = pr.borracha_id
                            and d.desenho_id = pr.desenho_id
                    where pd.pneu_id = #arguments.pneu_id#
                      and pm.data_desmontagem is null
                      and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
                                                     from oper.v$pneu_reforma r2
                                                    where r2.pneu_id = pr.pneu_id
                                                      and r2.data_retorno_reforma is not null
                                                      and r2.conserto = 0)
                           or (select max(r2.data_retorno_reforma)
                                                     from oper.v$pneu_reforma r2
                                                    where r2.pneu_id = pr.pneu_id
                                                      and r2.data_retorno_reforma is not null
                                                      and r2.conserto = 0) is null)
                      )
        </cfquery>
		<cfif Len(Trim(qrPneu.parceiro)) >
			<cfquery name="qrPneuParceiro"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ FIRST_ROWS */ p.num_pneu as PARC_NUM_PNEU,
					   decode(p.rendimento,0,-1, round(nvl(mm_inspecao, p.mm_montagem) - (p.km_rodado/p.rendimento),1)) as PARC_MM_ESTIMADO,
					   data_inspecao as PARC_DATA_INSPECAO,
					   mm_inspecao as PARC_MM_INSPECAO, parceiro,
					   num_gabarito, num_eixo ,marca_id,
					   #qrPneu.mm_montagem# as mm_montagem,
					   modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
					   medida, medida_roda, placa, data_montagem as data_montagem_parceiro,  km_montagem, suspenso, geminado, cod_posicao,
					   #qrPneu.num_pneu# as num_pneu,
					   dias_ult_inspecao, '#qrPneu.posicao#' as posicao, sulco, to_date('#LSDateFormat(qrPneu.DATA_MONTAGEM)#','dd/mm/yyyy') as data_montagem,
					   '#qrPneu.PMOV_ID#' as pmov_id, '#qrPneu.sulco_parametro#' as sulco_parametro, medida_id,
                       tempo_montagem
				  from (select pd.pneu_id, pd.num_pneu, pm.mm_montagem,
							   oper.pkg_pneu.fnc_km_rodado(pm.placa, nvl(pi.data_inspecao,pm.data_montagem), pvp.suspenso) as km_rodado,
							   oper.pkg_pneu.fnc_rendimento_pneu(pm.pneu_id, pvp.modelo_eixo_id, pvp.num_eixo, pvp.tipo_veiculo) as rendimento,
							   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas, pr.borracha_id, pr.desenho_id, pd.medida_roda_id,
							   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, pd.medida, pd.medida_roda,
							   pm.placa, to_char(pm.data_montagem,'dd/mm/yyyy hh24:mi') as data_montagem, pm.km_montagem, pvp.suspenso, pvp.geminado, pvp.cod_posicao,
							   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro,
							   nvl(pi.data_inspecao,pm.data_montagem) as data_inspecao, nvl(pi.mm_inspecao,pm.mm_montagem) as mm_inspecao, trunc(sysdate - pi.data_inspecao) as dias_ult_inspecao,
							   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco, pd.medida_id,
                               round(sysdate - pm.data_montagem)*24 as tempo_montagem
						  from oper.v$pneu_dados pd
						 inner join oper.v$pneu_movimentacao pm
									 on pm.pneu_id = pd.pneu_id
						 inner join oper.v$pneu_veiculo_posicao pvp
									 on pvp.placa = pm.placa
									and pvp.num_gabarito = pm.num_gabarito
									and pvp.num_eixo = pm.num_eixo
									and pvp.posicao = pm.posicao
						 left join oper.v$pneu_inspecao pi
								 on pd.pneu_id = pi.pneu_id
						 left join oper.v$pneu_reforma pr
							    on pr.pneu_id = pd.pneu_id
						 left join oper.v$pneu_borracha pb
							 	on pb.borracha_id = pr.borracha_id
						 left join oper.v$pneu_desenho d
								on d.borracha_id = pr.borracha_id
							   and d.desenho_id = pr.desenho_id
						where pm.data_desmontagem is null
                        <cfif arguments.desmontagem eq 1>
                          and pd.pneu_id = #arguments.pneu_id#
                        <cfelse>
						  and pd.pneu_id = #qrPneu.parceiro#
                        </cfif>
						  and (pi.data_inspecao = (select max(pi2.data_inspecao)
												  from oper.v$pneu_inspecao pi2
												 where pi2.pneu_id = pi.pneu_id)
							   or pi.data_inspecao is null)
						  and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0)
							   or (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0) is null)) p
			</cfquery>
			<cfreturn qrPneuParceiro>
		</cfif>
		<cfreturn qrPneu>
	</cffunction>



	<!---
	-- PROPSITO
	-- Busca todos os pneus cadastrados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_relacao_pneus" returntype="query" access="remote">
		<cfargument name="sulco" required="no">
		<cfargument name="sulco_final" required="no">
		<cfargument name="situacao_id" required="no">
		<cfargument name="medida_id" required="no">
		<cfargument name="medida_roda_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="eixo" required="no">
		<cfargument name="cod_pessoa_filial" required="no">
		<cfargument name="operador" required="no">
		<cfargument name="reformas" required="no" default="">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="formato_borracha" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#" timeout="300">
			select pneu_id,
				   num_pneu,
				   modelo_id,
				   decode(reformas, 0, 'Novo', 'Reforma ' || reformas) as reformas,
				   reformas as nro_reformas,
				   marca,
				   modelo,
				   medida,
				   medida_roda,
				   sulco,
				   oper.fnc_get_cod_veiculo(placa) as placa,
				   posicao,
				   borracha,
				   desenho,
				   filial,
				   cod_pessoa,
				   zero_km,
				   formato_borracha,
				   cliente,
       			   cod_pessoa_proprietario

			  from (select /*+ USE_HASH(PVP R) */ r.pneu_id,
						   r.num_pneu,
						   r.modelo_id,
						   r.reformas,
						   r.marca,
						   r.modelo,
						   r.medida,
						   r.medida_roda,
						   r.medida_roda_id,
						   r.medida_id,
						   r.num_eixo,
						   r.num_gabarito,
						   r.sulco,
						   r.placa,
						   r.posicao,
						   r.borracha,
						   r.desenho,
						   r.filial,
						   r.situacao_id,
						   r.cod_pessoa,
						   r.borracha_id,
						   r.desenho_id,
						   r.zero_km,
						   pvp.prefixo as eixo,
						   formato_borracha,
						   r.cliente,
               			   r.cod_pessoa_proprietario
					  from oper.v$pneu_veiculo_posicao pvp
					  right join (select pd.pneu_id,
								   pd.num_pneu,
								   pd.modelo_id,
								   pd.reformas,
								   pd.marca,
								   pd.modelo,
								   pd.medida,
								   pd.medida_roda,
								   pd.medida_roda_id,
								   pm.num_gabarito,
								   pm.num_eixo,
								   pd.medida_id,
								   case
									 when p.sulco < 0 then
									  0
									 when p.sulco is null then
									  oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)
									 else
									  p.sulco
								   end sulco,
								   nvl(pm.placa, pm2.placa) as placa,
								   nvl(pm.posicao, pm2.posicao) as posicao,
								   null as borracha,
								   null as desenho,
								   (select cliente
									  from kss.v$pessoa
									 where cod_pessoa = pl.cod_pessoa) as filial,
								   pd.situacao_id,
								   pl.cod_pessoa,
								   null as borracha_id,
								   null as desenho_id,
								   case
									 when not exists (select 'x'
											 from oper.v$pneu_movimentacao pm4
											where pm4.pneu_id = pd.pneu_id) then
									  1
									 else
									  0
								   end as zero_km,
								   pd.formato_borracha,
								   ps.cliente,
                       			   pp.cod_pessoa as cod_pessoa_proprietario
							  from oper.v$pneu_dados pd

							  left join oper.v$pneu_localizacao_atual pl on pd.pneu_id =
																			pl.pneu_id
																		and pl.data_saida is null
							  left join oper.pneu_sulco_estimado p on p.pneu_id =
																	  pd.pneu_id
							  left join oper.v$pneu_movimentacao pm on pm.pneu_id =
																	   pd.pneu_id
																   and pm.data_desmontagem is null
							  left join oper.v$pneu_movimentacao pm2 on pm2.pneu_id =
																		pm.pneu_id
																	and pm2.data_desmontagem is not null

							  left join oper.v$pneu_proprietario pp on pp.pneu_id = pd.pneu_id
                 			  left join kss.v$pessoa ps on ps.cod_pessoa = pp.cod_pessoa
							 where pd.reformas = 0
							 and pp.data_fim is null
				<cfif arguments.situacao_id neq 2>
							   and not exists (select 'x'
											  from oper.v$pneu_movimentacao pm3
											 where pm3.pneu_id = p.pneu_id
											   and pm3.data_desmontagem is null)
				</cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and pd.situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and pd.situacao_id = 1
				</cfif>
			 <cfelse>
				   and pd.situacao_id in (1, 2, 3, 4, 5, 6, 8, 9, 10)
			 </cfif>
							   ) r
					  on pvp.placa = r.placa
															   and pvp.num_gabarito =
																   r.num_gabarito
															   and pvp.num_eixo =
																   r.num_eixo
															   and pvp.posicao =
																   r.posicao
					union
					select /*+ USE_HASH(PVP R) */ r.pneu_id,
						   r.num_pneu,
						   r.modelo_id,
						   r.reformas,
						   r.marca,
						   r.modelo,
						   r.medida,
						   r.medida_roda,
						   r.medida_roda_id,
						   r.medida_id,
						   r.num_eixo,
						   r.num_gabarito,
						   r.sulco,
						   r.placa,
						   r.posicao,
						   r.borracha,
						   r.desenho,
						   r.filial,
						   r.situacao_id,
						   r.cod_pessoa,
						   r.borracha_id,
						   r.desenho_id,
						   r.zero_km,
						   pvp.prefixo as eixo,
						   r.formato_borracha,
						   r.cliente,
               			   r.cod_pessoa_proprietario
					  from oper.v$pneu_veiculo_posicao pvp
					  right join (select
							 pd.pneu_id,
							 pd.num_pneu,
							 pd.modelo_id,
							 pd.reformas,
							 pd.marca,
							 pd.modelo,
							 pd.medida,
							 pd.medida_roda,
							 pd.medida_roda_id,
							 pd.medida_id,
							 pm.num_gabarito,
							 pm.num_eixo,
							 case
							   when p.sulco < 0 then
								0
							   when p.sulco is null then
								oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)
							   else
								p.sulco
							 end sulco,
							 nvl(pm.placa, pm2.placa) as placa,
							 nvl(pm.posicao, pm2.posicao) as posicao,
							 pb.descricao as borracha,
							 d.descricao as desenho,
							 (select cliente
								from kss.v$pessoa
							   where cod_pessoa = pl.cod_pessoa) as filial,
							 pd.situacao_id,
							 pl.cod_pessoa,
							 pb.borracha_id as borracha_id,
							 d.desenho_id as desenho_id,
							 case
							   when not exists
								(select 'x'
									   from oper.v$pneu_movimentacao pm4
									  where pm4.pneu_id = pd.pneu_id
										and pm4.data_montagem > pr.data_retorno_reforma) then
								1
							   else
								0
							 end as zero_km,
							 pd.formato_borracha,
							 ps.cliente,
                 			 pp.cod_pessoa as cod_pessoa_proprietario
							  from oper.v$pneu_dados pd

							 inner join oper.v$pneu_reforma pr on pr.pneu_id = pd.pneu_id
															  and pr.conserto = 0
							 inner join oper.v$pneu_borracha pb on pb.borracha_id =
																   pr.borracha_id
							 inner join oper.v$pneu_desenho d on d.borracha_id =
																 pr.borracha_id
															 and d.desenho_id =
																 pr.desenho_id
							  left join oper.v$pneu_localizacao_atual pl on pd.pneu_id =
																			pl.pneu_id
																		and pl.data_saida is null
							  left join oper.pneu_sulco_estimado p on p.pneu_id =
																	  pd.pneu_id
							  left join oper.v$pneu_movimentacao pm on pm.pneu_id =
																	   pd.pneu_id
																   and pm.data_desmontagem is null
							  left join oper.v$pneu_movimentacao pm2 on pm2.pneu_id =
																		pm.pneu_id
																	and pm2.data_desmontagem is not null
							  left join oper.v$pneu_proprietario pp on pp.pneu_id = pd.pneu_id
                  			 left join kss.v$pessoa ps on ps.cod_pessoa = pp.cod_pessoa
							 where pd.reformas > 0
							 and pp.data_fim is null
				<cfif arguments.situacao_id neq 2>
							   and not exists
							 (select 'x'
									  from oper.v$pneu_movimentacao pm3
									 where pm3.pneu_id = p.pneu_id
									   and pm3.data_desmontagem is null)
				</cfif>
							   and pr.data_retorno_reforma =
								   (select max(pr2.data_retorno_reforma)
									  from oper.v$pneu_reforma pr2
									 where pr2.pneu_id = pr.pneu_id
									   and pr2.conserto = 0)
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and pd.situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and pd.situacao_id = 1
				</cfif>
			 <cfelse>
				   and pd.situacao_id in (1, 2, 3, 4, 5, 6, 8, 9, 10)
			 </cfif>
							   ) r
					   on pvp.placa = r.placa
															   and pvp.num_gabarito =
																   r.num_gabarito
															   and pvp.num_eixo =
																   r.num_eixo
															   and pvp.posicao =
																   r.posicao)
			 where 1 = 1
			 <cfif arguments.operador eq 'BETWEEN'>
			   and sulco between #arguments.sulco# and #arguments.sulco_final#
			 <cfelse>
			   and sulco #arguments.operador# #arguments.sulco#
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial))>
			   and cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif IsDefined("arguments.medida_id") and Len(Trim(arguments.medida_id))>
			   and medida_id = #arguments.medida_id#
			 </cfif>
			 <cfif IsDefined("arguments.medida_roda_id") and Len(Trim(arguments.medida_roda_id))>
			   and medida_roda_id = #arguments.medida_roda_id#
			 </cfif>
			 <cfif IsDefined("arguments.eixo") and Len(Trim(arguments.eixo))>
			   and eixo = '#arguments.eixo#'
			 </cfif>
			 <cfif IsDefined("arguments.modelo_id") and Len(Trim(arguments.modelo_id))>
			   and modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
			   and reformas in (#arguments.reformas#)
			 </cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and situacao_id = 1
				</cfif>
			 </cfif>
			 <cfif len(trim(arguments.borracha_id))>
				and borracha_id = #arguments.borracha_id# and reformas > 0
			 </cfif>
			 <cfif len(trim(arguments.proprietario))>
				and cod_pessoa_proprietario in (#arguments.proprietario#)
			 </cfif>
			 <cfif len(trim(arguments.desenho_id))>
				and desenho_id = #arguments.desenho_id# and reformas > 0
			 </cfif>
			 <cfif len(trim(arguments.formato_borracha))>
			    and formato_borracha = '#arguments.formato_borracha#'
			 </cfif>
			 order by cod_pessoa_proprietario, reformas, marca, num_pneu, modelo, medida, medida_roda, sulco
		</cfquery>

		<cfreturn qr_desenhos>
	</cffunction>
	<!---
	-- PROPSITO
	-- Busca todas as posicoes vagas nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_posicoes_vagas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_posicoes_vagas" username="#session.usuario#" password="#session.senha#">
			select oper.fnc_get_cod_veiculo(pvp.placa) as placa,
				   pvp.num_gabarito,
				   pvp.num_eixo,
				   pvp.posicao,
				   pvp.cod_posicao,
				   pvp.ordem,
				   pvp.modelo_eixo_id,
				   pvp.caminho_imagem,
				   pvp.veiculo_modelo,
				   pvp.tipo_veiculo,
				   pvp.suspenso,
				   pvp.geminado,
				   pvp.num_veiculos,
				   pvp.pmov_id,
				   pmv.data_desmontagem,
				   pmv.user_update as usuario_desmontagem,
				   (select num_pneu
					  from oper.v$pneu p1
					 where p1.pneu_id = pmv.pneu_id) as num_pneu,
				   pld.DESCRICAO as laudo_desmontagem,
				   (select t.landmark
					  from oper.v$rank_frota t
					 where (placa_controle = pvp.placa or placa_referencia = pvp.placa)
					   and rownum = 1) as ultima_posicao
			  from (select /*+ ORDERED */
					 pvp.placa,
					 pvp.num_gabarito,
					 pvp.num_eixo,
					 pvp.posicao,
					 pvp.cod_posicao,
					 pvp.ordem,
					 pvp.modelo_eixo_id,
					 pvp.caminho_imagem,
					 pvp.veiculo_modelo,
					 pvp.tipo_veiculo,
					 pvp.suspenso,
					 pvp.geminado,
					 (select count(*)
						from (select distinct pvp.placa
								from oper.v$pneu_veiculo_posicao pvp
							   where not exists (select 'x'
										from oper.v$pneu_movimentacao pm
									   where pm.placa = pvp.placa
										 and pm.num_gabarito = pvp.num_gabarito
										 and pm.num_eixo = pvp.num_eixo
										 and pm.posicao = pvp.posicao
										 and pm.data_desmontagem is null)
								 and (pvp.empresa = 1 or exists
									  (select 1
										  from oper.v$veiculo_proprietario vp
										 inner join oper.v$agregado_gestao_individual ag
											on vp.cod_pessoa = ag.cod_pessoa
										   and ag.id = 30
										   and ag.percentual = 1
										 where vp.data_fim is null 
										   and vp.placa = pvp.placa
										   and exists (select 1
														 from kss.v$pessoa_modalidade pm
														where pm.cod_pessoa = vp.cod_pessoa
														  and pm.num_modalidade = 10
														  and pm.situacao = 1)
									   ))
							   group by pvp.placa)) as num_veiculos
					 /* ------------------------------------------------- */,
					 (select max(pmov_id)
						from oper.v$pneu_movimentacao pm
					   where pm.placa = pvp.placa
						 and pm.num_gabarito = pvp.num_gabarito
						 and pm.num_eixo = pvp.num_eixo
						 and pm.posicao = pvp.posicao
						 and pm.data_desmontagem =
							 (select max(data_desmontagem)
								from oper.v$pneu_movimentacao pm
							   where pm.placa = pvp.placa
								 and pm.num_gabarito = pvp.num_gabarito
								 and pm.num_eixo = pvp.num_eixo
								 and pm.posicao = pvp.posicao)) as pmov_id
					/* ------------------------------------------------- */
					  from oper.v$pneu_veiculo_posicao pvp
					 where not exists (select 'x'
							  from oper.v$pneu_movimentacao pm
							 where pm.placa = pvp.placa
							   and pm.num_gabarito = pvp.num_gabarito
							   and pm.num_eixo = pvp.num_eixo
							   and pm.posicao = pvp.posicao
							   and pm.data_desmontagem is null)
					   and (pvp.empresa = 1 or exists
							(select 1
 							  from oper.v$veiculo_proprietario vp
 							 inner join oper.v$agregado_gestao_individual ag
								on vp.cod_pessoa = ag.cod_pessoa
							   and ag.id = 30
							   and ag.percentual = 1
							 where vp.data_fim is null 
							   and vp.placa = pvp.placa
							   and exists (select 1
											 from kss.v$pessoa_modalidade pm
											where pm.cod_pessoa = vp.cod_pessoa
											  and pm.num_modalidade = 10
											  and pm.situacao = 1)
						   ))

					 order by pvp.placa, num_eixo, ordem) pvp
			  left join oper.v$pneu_movimentacao pmv
					 on pmv.pmov_id = pvp.pmov_id
			  left join oper.v$pneu_laudo_desmontagem pld
					 on pld.LAUDO_ID = pmv.laudo_desmontagem_id
		</cfquery>
		<cfreturn qr_posicoes_vagas>
	</cffunction>
	<!---
	-- PROPSITO
	-- Busca o rendimento dos pneus do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="get_rendimento" returntype="query" access="remote" output="true">
		<cfargument name="cod_veiculo" required="no">
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = '#this.get_placa(arguments.cod_veiculo)#', sem_aspas = true)>
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select /*+ RULE */  num_pneu, modelo, marca, borracha, desenho, pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao,
					   oper.fnc_get_cod_veiculo(placa) as placa, pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem, veiculo_modelo,
					   suspenso, modelo_eixo_id, tipo_veiculo, mm_montagem, km_rodado, mm_estimado, rendimento, mm_gastos,
					   peso_tracionado, peso_tracionado_familia, dias_ult_inspecao, reformas,
					  case
						 when mm_estimado <= 0 then 'SP'
					  else  to_char(round(km_rodado / decode((mm_montagem - mm_estimado),0,1,(mm_montagem - mm_estimado)))) end rendimento_pneu
			  from (
							select num_pneu, modelo, marca, borracha , desenho,  pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao, placa,
								   pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem,
								   veiculo_modelo, suspenso, modelo_eixo_id, tipo_veiculo, mm_montagem,
									oper.pkg_pneu.fnc_km_rodado(placa,data_montagem,suspenso) as km_rodado,
								   decode(oper.pkg_pneu.fnc_rendimento_pneu(pneu_id,modelo_eixo_id, num_eixo, tipo_veiculo), 0, -1,
								   round(mm_montagem - ((oper.pkg_pneu.fnc_km_atual(placa) - decode(suspenso,0,0,oper.pkg_pneu.fnc_km_vazio(placa, data_montagem, sysdate)) - km_montagem) /
								   oper.pkg_pneu.fnc_rendimento_pneu(pneu_id, modelo_eixo_id, num_eixo, tipo_veiculo)), 1)) as mm_estimado,
								   oper.pkg_pneu.fnc_rendimento_pneu(pneu_id,modelo_eixo_id, num_eixo, tipo_veiculo) as rendimento,
								   oper.pkg_pneu.fnc_rendimento_pneu_mm(pneu_id,modelo_eixo_id, num_eixo, tipo_veiculo) as mm_gastos,
								   oper.pkg_pneu.fnc_peso_medio_tracionado(pneu_id) as peso_tracionado,
								   oper.pkg_pneu.fnc_peso_medio_tracionado(pneu_id, modelo_eixo_id, num_eixo, tipo_veiculo) as peso_tracionado_familia,
								   trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) as dias_ult_inspecao, reformas
							  from (select num_pneu, modelo, marca, borracha , desenho,  pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao, placa,
												   pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem,
												   veiculo_modelo, suspenso, modelo_eixo_id, tipo_veiculo,
										   mm_montagem, reformas
									  from oper.v$pneu_veiculo_gabarito
									 where instr('#qr_veiculo.COMPOSICAO#',placa) > 0)
								     order by instr('#qr_veiculo.COMPOSICAO#',placa), num_eixo, ordem)
		</cfquery>
		<cfreturn qr_rendimento>
	</cffunction>
	<!---
	-- PROPSITO
	-- Monta busca fichas de envio
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_fichas_reforma" returntype="query" access="remote">
		<cfargument name="num_relacao" required="no">
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */  r.num_relacao, r.data_envio, pr.cod_pessoa_reformador, pj.cliente as reformador, pb.imagem,
  				   oper.pkg_global.fnc_busca_nome_pessoa(u.cod_pessoa) as usuario,
  				   pd.num_pneu, pd.marca, pd.modelo, d.descricao as desenho, pr.data_envio_reforma,
  				   rel.num_pneus
			  from oper.v$pneu_relacao_envio_reforma r
		     inner join oper.v$pneu_reforma pr
			         on pr.num_relacao = r.num_relacao
					and pr.cod_pessoa_reformador = r.cod_pessoa_reformador
					and pr.data_retorno_reforma is null
			 inner join kss.v$pessoa pj
			         on pj.cod_pessoa = pr.cod_pessoa_reformador
			 left join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			 left join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = pr.pneu_id
			 inner join kss.kss_usuarios u
					 on u.usuario = pr.user_insert,
				   (select r2.num_relacao, count(*) as num_pneus
				      from oper.v$pneu_reforma r2
					 group by r2.num_relacao) rel
		    where rel.num_relacao = r.num_relacao
			  <cfif IsDefined("arguments.num_relacao")>
				  and r.num_relacao = #arguments.num_relacao#
			  </cfif>
			  order by num_relacao
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os tipos de veiculo
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 17/04/2009
	--->
	<cffunction name="get_veiculo_tipo_carroceria" displayname="Consulta todos as Marcas dos Veculos" access="remote" output="true" returntype="query">
		<cfargument name="com_pneus" required="false" default="0">
		<cfargument name="tipo_carroceria_id" required="false" default="">
		<cfquery name="qr_tipo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct vc.tipo_carroceria_id,
                            vc.carroceria as descricao
              from oper.v$veiculo v
              left join oper.v$veiculo_modelo vm
                     on vm.marca_id = v.marca_id
                    and vm.modelo_id = v.modelo_id
             inner join oper.v$veiculo_carroceria vc
                     on vc.tipo_carroceria_id = vm.tipo_carroceria_id
             where 1 = 1
			 <cfif arguments.com_pneus eq 1>
               and exists (select 'x'
                             from oper.v$pneu_movimentacao p
                            where p.placa = v.placa)
			 <cfif Len(Trim(arguments.tipo_carroceria_id))>
               and vc.tipo_carroceria_id in (#arguments.tipo_carroceria_id#)
			 </cfif>
			 </cfif>
             order by vc.carroceria asc
		</cfquery>
		<cfreturn qr_tipo>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as Reformadores para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_reformadores" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrReformadores" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select case
							  when quantidade/total < 0.05 then 0
							  else cod_pessoa_reformador end cod_pessoa_reformador, quantidade
					from (select pr.cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
										  where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																			from oper.v$pneu_reforma pr2
																		   where pr2.pneu_id = pr.pneu_id
																			 and pr2.conserto = 0)) as total
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
								where p.situacao_id in (1,2,3,4,5,6,8,9,10)
								   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																	from oper.v$pneu_reforma pr2
																   where pr2.pneu_id = pr.pneu_id
																	 and pr2.conserto = 0)
							group by pr.COD_PESSOA_REFORMADOR))
			left join oper.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador
			group by cod_pessoa_reformador, cliente
		</cfquery>
		<cfreturn qrReformadores>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca todas os reformadores de pneu para a montagem do relatorio de reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_reformador" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select cod_pessoa_reformador, quantidade
					from (select pr.cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
                    where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                  																		from oper.v$pneu_reforma pr2
                  																	   where pr2.pneu_id = pr.pneu_id
                  																		 and pr2.conserto = 0)) as total
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
								where  p.situacao_id in (1,2,3,4,5,6,8,9,10)
							   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																from oper.v$pneu_reforma pr2
															   where pr2.pneu_id = pr.pneu_id
																 and pr2.conserto = 0)

							group by pr.COD_PESSOA_REFORMADOR))
			left join oper.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador
			group by cod_pessoa_reformador, cliente
		  order by 3 desc
		</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>

    <!---
    -- PROPSITO
    -- Busca os grupos de veculos
    -- ANDERSON 19/08/2009 - CRIADO
    --->
    <cffunction name="get_grupos_veiculos" access="remote" returntype="query" output="true">
        <cfargument name="cod_grupo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.grupo_id
                 , t.cod_grupo
                 , t.cod_grupo || decode(t.situacao_id, 1, ' (Ativo)', ' (Inativo)') as cod_grupo_situacao
                 , t.descricao
              from oper.v$veiculo_grupo_setup t
             where 1 = 1
			<cfif Len(Trim(arguments.cod_grupo))>
			   and t.cod_grupo in (#ListQualify(arguments.cod_grupo, "'")#)
            </cfif>
             order by t.situacao_id desc, t.cod_grupo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca os dados do pneu para envio para reforma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneu_envio_reforma" returntype="query" access="remote">
		<cfargument name="num_relacao" required="no">
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select pr.cod_pessoa_reformador, pj.cliente || ' - ' || pj.razao_social as reformador, pb.imagem,
				   oper.pkg_global.fnc_busca_nome_pessoa(u.cod_pessoa) as usuario,
				   pd.num_pneu, pd.marca, pd.modelo, d.descricao as desenho, pr.data_envio_reforma,
				   pr.data_retorno_reforma, pd.medida,
				   m.largura_manta, r.observacao, r.situacao, r.num_relacao
			  from oper.v$pneu_relacao_envio_reforma r
			 inner join oper.v$pneu_reforma pr
			         on pr.num_relacao = r.num_relacao
					and pr.cod_pessoa_reformador = r.cod_pessoa_reformador
			 inner join oper.v$pessoa pj
			         on pj.cod_pessoa = pr.cod_pessoa_reformador
			 left join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			 left join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = pr.pneu_id
		     inner join oper.v$pneu_modelo m
			         on m.marca_id = pd.marca_id
					and m.modelo_id = pd.modelo_id
					and m.medida_id = pd.medida_id
					and m.medida_roda_id = pd.medida_roda_id
			 inner join kss.kss_usuarios u
					 on u.usuario = pr.user_insert
			  where 1=1
			  <cfif IsDefined("arguments.num_relacao")>
				and pr.num_relacao = #arguments.num_relacao#
			  <cfelse>
			    and pr.data_retorno_reforma is null
			  </cfif>
			  order by pr.cod_pessoa_reformador
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os pneus reformados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneus_reformados" returntype="query" access="remote">
	    <cfargument name="num_pneu" required="yes">
	    <cfargument name="data_inicio" required="yes">
	    <cfargument name="data_termino" required="yes">
	    <cfargument name="somente_reformados" required="no">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="reformas_1" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="desenho_id" required="no" default="">
		<cfargument name="localizacao" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ pd.num_pneu, pd.marca, pd.modelo, pd.medida, pd.medida_roda,
				   pr.cod_pessoa_reformador, pj.cliente as reformador, pr.data_envio_reforma, pr.data_retorno_reforma,
				   pb.descricao as borracha, d.descricao as desenho, pr.custo,
	               sum(pr.custo) over(partition by pr.cod_pessoa_reformador order by pr.cod_pessoa_reformador) as total_por_reformador,
		           sum(pr.custo) over() as custo_total,
                   count(*) over () as recordcount
			  from oper.v$pneu_reforma pr
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = pr.pneu_id
			 inner join oper.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador
			 inner join oper.v$pneu_borracha pb
					 on pr.borracha_id = pb.borracha_id
			 inner join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			  left join oper.v$pneu_proprietario pp
                     on pp.pneu_id = pr.pneu_id
                    and pp.data_fim is null
			  left join oper.v$pneu_localizacao_atual pla
			  		 on	pla.pneu_id = pr.pneu_id
			 where 1=1
			 <cfif IsDefined("arguments.data_inicio") and Len(Trim(arguments.data_inicio))>
			   and pr.data_envio_reforma between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_termino#','dd/mm/yyyy')
			<cfelse>
			   and pr.conserto = 0
			   and pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
			                                  from oper.v$pneu_reforma pr2
											 where pr2.pneu_id = pr.pneu_id
											   and pr2.conserto = 0)
			 </cfif>
			 <cfif IsDefined("arguments.somente_reformados")>
			   and pr.data_retorno_reforma is not null
			 </cfif>
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and pd.num_pneu = #arguments.num_pneu#
			 </cfif>
			 <cfif len(trim(arguments.marca_id))>
			   and pd.marca_id in (#arguments.marca_id#)
			 </cfif>
			 <cfif len(trim(arguments.modelo_id))>
			   and pd.modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif len(trim(arguments.medida_id))>
			   and pd.medida_id in (#arguments.medida_id#)
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and pp.cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif len(trim(arguments.reformas_1))>
			 	<cfif IsDefined("arguments.data_inicio") and Len(Trim(arguments.data_inicio))>
				and #arguments.reformas_1# = (select count(*)
					  from oper.v$pneu_reforma pr2
					 where pr2.pneu_id = pr.pneu_id
						   and pr2.conserto = 0
						   and pr2.data_envio_reforma < to_date('#arguments.data_inicio#','dd/mm/yyyy'))
				<cfelse>
				   and pd.reformas - 1 = #arguments.reformas_1#
				</cfif>
			 </cfif>
			 <cfif len(trim(arguments.borracha_id))>
			   and pr.borracha_id in (#arguments.borracha_id#)
			 </cfif>
			 <cfif len(trim(arguments.desenho_id))>
			   and pr.desenho_id in (#arguments.desenho_id#)
			 </cfif>
			  <cfif len(trim(arguments.localizacao))>
			   and pla.cod_pessoa = #arguments.localizacao#
			  </cfif>
			   and pr.conserto = 0
			order by pj.cliente, pd.marca, pd.modelo, pd.medida, pd.medida_roda
		</cfquery>
		<cfreturn qrPneus>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os dados para o Painel de Sucateamento
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_painel_sucateamento" returntype="query" access="remote">
		<cfargument name="laudo_id" required="no" default="">
		<cfargument name="relatorio_por" required="yes">
		<cfargument name="reformados" required="no">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfquery name="qr_sucatas" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select #relatorio_por# as label,
				   round(avg(decode(oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id))),2) as media_mm_perdido,
				   sum(decode(oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id))) as mm_perdido,
				   count(*) as num_pneus
		      from oper.v$pneu_sucateamento ps
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = ps.pneu_id
			 <cfif IsDefined("arguments.reformados") and Len(Trim(arguments.reformados))>
				 inner join oper.v$pneu_reforma pr
						 on pr.pneu_id = ps.pneu_id
						and pr.conserto = 0
                 inner join oper.v$pneu_reformador_bandeira prb
                         on prb.cod_pessoa_reformador = pr.cod_pessoa_reformador
				 inner join kss.v$pessoa pj
				         on pj.cod_pessoa = prb.cod_pessoa_reformador
				 inner join oper.v$pneu_borracha b
						 on b.borracha_id = pr.borracha_id
			  </cfif>
			  where 1=1
                and ps.situacao_id = 1
			  <cfif IsDefined("arguments.reformados") and Len(Trim(arguments.reformados))>
				and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
												 from oper.v$pneu_reforma pr2
												where pr2.pneu_id = pr.pneu_id
												  and pr2.conserto = 0)
			  </cfif>
			  <cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO)) AND IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
					and ps.data_sucateamento between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#'
			  </cfif>
			  <cfif IsDefined("arguments.laudo_id") and Len(Trim(arguments.laudo_id))>
				 and laudo_id  in (#ListQualify(arguments.laudo_id,"'",",")#)
			 </cfif>
			group by #relatorio_por#
			order by 2 desc
		</cfquery>
		<cfreturn qr_sucatas>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as placas com calibragem em aberto
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/04/2007
	--->
	<cffunction name="get_calibragens_abertas" returntype="query" access="remote">
		<cfargument name="todas" required="no" default="0">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.todas eq 1>
				select /*+ FIRST_ROWS*/
					    oper.fnc_get_cod_veiculo(pi.placa) as frota, pi.placa,
						max(pi.data_calibragem) as data_calibragem, pi.user_insert, max(pi.date_insert) as date_insert,
						(select distinct cod_pessoa
						   from kss.v$kss_usuario_lotacao
						  where usuario = pi.user_insert) as cod_pessoa_filial
				  from oper.v$pneu_calibragem pi
				 where pi.pressao_encontrada is null
				 group by pi.placa, pi.user_insert

				union
			</cfif>
			select /*+ FIRST_ROWS*/
					oper.fnc_get_cod_veiculo(pi.placa) as frota, pi.placa,
					max(pi.data_calibragem) as data_calibragem, pi.user_insert, max(pi.date_insert) as date_insert,
					(select distinct cod_pessoa
					   from kss.v$kss_usuario_lotacao
					  where usuario = pi.user_insert) as cod_pessoa_filial
			  from oper.v$pneu_calibragem pi
			 where pi.pressao_encontrada is null
			   and (oper.pkg_veiculo.fnc_veiculo_tracao(pi.placa) = 1 or
					  not exists (select 'x'
									from oper.v$veiculo_composicao vc
								   where vc.placa_2 = pi.placa
									 and vc.DATA_HORA_DESENGATE is null))
			 group by pi.placa, pi.user_insert

			 order by 3
   		</cfquery>
		<cfreturn qrPneus>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca ficha de calibragem em aberto
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 02/04/2007 - criado
	--->
	<cffunction name="get_dados_calibragem" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select pc.controle_id, pc.placa, p.num_pneu, pm.posicao, pc.data_calibragem,
				   pc.pressao_calibrada, pc.user_insert as gerada_por,
				   oper.fnc_get_cod_veiculo(pc.placa) as frota, 0 as km_atual, 0 as pressao_ideal
			  from oper.v$pneu_calibragem pc
			 inner join oper.v$pneu_movimentacao pm
					 on pm.pneu_id = pc.pneu_id
					and pm.placa = pc.placa
					and pm.data_desmontagem is null
			 inner join oper.v$pneu_veiculo_posicao pvp
					 on pvp.placa = pm.placa
					and pvp.posicao = pm.posicao
			 inner join oper.v$pneu p
					 on p.pneu_id = pc.pneu_id
			 inner join (select column_value placa, rownum as composicao,
									 oper.fnc_get_cod_veiculo(column_value) cod_veiculo
							  from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao(oper.fnc_get_placa('#arguments.placa#')),'|')) t,
									 (select oper.pkg_veiculo.fnc_capacidade_carga_compo(oper.fnc_get_placa('#arguments.placa#')) as capacidade from dual)
							 where column_value is not null) vc
					 on vc.placa = pc.placa
			where pc.pressao_encontrada is null
			order by vc.composicao, pvp.num_eixo, pvp.ordem
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca CONTA CORRENTE de compradores de pneus
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_compradores_conta" returntype="query" access="remote">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.cod_conta, cc.descricao_conta, cc.cod_pessoa, cc.data_abertura,
            	   p.cliente as favorecido
              from finan.v$ccorrente cc
              inner join kss.v$pessoa p
                      on p.cod_pessoa = cc.cod_pessoa
             where cc.modalidade_id = 12
               and cc.ativo = 1
             order by cc.descricao_conta
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Os dados da ficha de inspecao do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_dados_inspecao" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfif Len(Trim(arguments.cod_veiculo))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = arguments.placa, sem_aspas = true)>
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select pneu_id, num_pneu, situacao_id, marca_id, marca,
			   modelo_id, modelo, sulco, medida_id, medida,
			   medida_roda_id, medida_roda, reformas, posicao,
			   placa, oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as frota,
			   data_inspecao, data_ult_inspecao, user_insert, num_inspecao, nvl(mm_montagem,0) as mm_montagem,
 			   sulco_atual,  oper.pkg_global.fnc_get_parametro(1,'PNEU')/100 as tolerancia
		  from ( 	select p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, p.marca,
						   p.modelo_id, p.modelo, p.sulco, p.medida_id, p.medida,
						   p.medida_roda_id, p.medida_roda, p.reformas, pm.posicao, pi.placa,
						   pi.data_inspecao, pi.data_ult_inspecao, pi.user_insert, pi.num_inspecao,
						   case
      					     when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id),1),0) >= mm_montagem then -1
      				       else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id),1),0)
      				       end sulco_atual,
						   pvp.num_eixo, pvp.ordem, pm.km_montagem, pm.mm_montagem
					  from oper.v$pneu_inspecao pi
					 inner join oper.v$pneu_dados p
							 on p.pneu_id = pi.pneu_id
							and pi.mm_inspecao is null
					 inner join oper.v$pneu_veiculo_posicao pvp
 						     on pvp.placa = pi.placa
					        and pvp.posicao = pi.posicao
					 inner join oper.v$pneu_movimentacao pm
							 on pm.placa = pi.placa
									and pm.pneu_id = pi.pneu_id
								  and pm.data_desmontagem is null
					 where instr('#qr_veiculo.COMPOSICAO#',pi.placa) > 0)
		 order by instr('#qr_veiculo.COMPOSICAO#',placa)
		 , num_eixo ,ordem
   		</cfquery>
		<cfreturn qrPneus>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca as ocorrencias do pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_ocorrencias" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfargument name="pneu_id" required="no">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" required="no">
		<cfargument name="operacao" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="num_ocorrencia" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_ocorrencias" username="#session.usuario#" password="#session.senha#">
			select /*+ first_rows_1000 */ pd.pneu_id
                 , pd.num_pneu
                 , pd.situacao_id
                 , pd.data_aquisicao
                 , pd.marca_id
                 , pd.marca
				 , pd.modelo_id
                 , pd.modelo
                 , pd.sulco
                 , pd.medida_id
                 , pd.medida
                 , pd.medida_roda_id
                 , pd.medida_roda
				 , pd.reformas
                 , pd.situacao
                 , pd.formato_borracha
                 , p.operacao
                 , p.usuario
                 , to_char(p.data_ocorrencia,'dd/mm/yyyy hh24:mi') as data_ocorrencia
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_ocorrencia p
					 on p.pneu_id = pd.pneu_id
			 where 1 = 1
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu)) and arguments.num_pneu neq -1>
			  and pd.num_pneu = #arguments.num_pneu#
			 </cfif>
			 <cfif IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id)) and arguments.pneu_id neq -1>
			  and pd.pneu_id = #arguments.pneu_id#
			 </cfif>
			 <cfif IsDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial)) and IsDefined("arguments.data_final") and Len(Trim(arguments.data_final))>
			  and trunc(p.data_ocorrencia) between '#arguments.data_inicial#' and '#arguments.data_final#'
			 <cfelseif IsDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial))>
			  and trunc(p.data_ocorrencia) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.operacao))>
			  and ( 1=0
				  <cfloop list="#arguments.operacao#" index="v_item" delimiters=",">
				  or upper(p.operacao) like upper('%#v_item#%')
				  </cfloop>
				  )
			 </cfif>
			 <cfif len(trim(arguments.num_ocorrencia))>
			  and p.num_ocorrencia in (#arguments.num_ocorrencia#)
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			 	and p.usuario in (''
				<cfloop list="#arguments.usuario#" delimiters="," index="v_item">
					, '#v_item#'
				</cfloop>
				)
			 </cfif>
			 order by p.pneu_id, p.data_ocorrencia
		</cfquery>
		<cfreturn qr_ocorrencias>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca Resumo Geral dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_resumo_geral" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_marcas" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa
                 , nome_fantasia
                 , situacao
                 , situacao_id
                 , descricao
                 , cliente
                 , novos_0km
                 , novos
                 , reformados_0km
                 , reformados
                 , novos_0km + novos + reformados_0km + reformados as quantidade
              from(
                   select t.cod_pessoa
                        , t.nome_fantasia
                        , t.situacao
                        , t.situacao_id
                        , t.descricao
                        , t.cliente
                        , t.novos_0km
                        , t.novos
                        , t.reformados_0km
                        , t.reformados
                     from (select /*+ PARALLEL */
                                  pl.cod_pessoa
                                , nvl(pj.cliente, 'No identificado') as nome_fantasia
                                , ps.descricao as situacao
                                , p.situacao_id
                                , ps.descricao
                                , pj.cliente
                                , (select count(*)
                                     from oper.v$pneu_dados p2
                                     left join oper.v$pneu_localizacao_atual pl2
                                       on pl2.pneu_id = p2.pneu_id
                                    where nvl(pl2.cod_pessoa,-1) = nvl(pl.cod_pessoa,-1)
                                      and p2.situacao_id = p.situacao_id
                                      and p2.reformas = 0
                                      and not exists (select 'x'
                                                        from oper.v$pneu_movimentacao pm
                                                       where pm.pneu_id = p2.pneu_id)) as novos_0km
                                , (select count(*)
                                     from oper.v$pneu_dados p2
                                     left join oper.v$pneu_localizacao_atual pl2
                                       on pl2.pneu_id = p2.pneu_id
                                    where nvl(pl2.cod_pessoa,-1) = nvl(pl.cod_pessoa,-1)
                                      and p2.situacao_id = p.situacao_id
                                      and p2.reformas = 0
                                      and exists (select 'x'
                                                    from oper.v$pneu_movimentacao pm
                                                   where pm.pneu_id = p2.pneu_id)) as novos
                                , (select nvl(sum(b.total_pneus), 0)
                                     from (select /*+ USE_HASH(p2 pl2 pr) */
                                                  count(*) as total_pneus
                                                , pl2.cod_pessoa
                                                , p2.situacao_id
                                             from oper.v$pneu_dados p2
                                             left join oper.v$pneu_localizacao_atual pl2
                                               on pl2.pneu_id = p2.pneu_id
                                             left join oper.v$pneu_reforma_completo pr
                                               on pr.pneu_id = p2.pneu_id
                                              and pr.conserto = 0
                                            where p2.reformas > 0
                                              and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                                                                                from oper.v$pneu_reforma pr2
                                                                               where pr2.pneu_id = pr.pneu_id
                                                                                 and pr2.conserto = 0)
                                                   or (pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                                                                  from oper.v$pneu_reforma_completo pr2
                                                                                 where pr2.pneu_id = pr.pneu_id
                                                                                   and pr2.conserto = 0)
                                                       and not exists (select 1
                                                                         from oper.v$pneu_reforma pr2
                                                                        where pr2.pneu_id = pr.pneu_id
                                                                          and pr2.conserto = 0)
                                                      )

                                                  )
                                              and not exists (select 'x'
                                                                from oper.v$pneu_movimentacao pm
                                                               where pm.pneu_id = pr.pneu_id
                                                                 and pm.data_montagem > pr.data_retorno_reforma)
                                         group by pl2.cod_pessoa
                                                , p2.situacao_id
                                                ) b
                                    where 1 = 1
                                      and nvl(b.cod_pessoa, -1) = nvl(pl.cod_pessoa, -1)
                                      and b.situacao_id = p.situacao_id
                                      ) as reformados_0km
                                , (select nvl(sum(b.total_pneus), 0)
                                     from (select /*+ USE_HASH(p2 pl2 pr) */
                                                  count(*) as total_pneus
                                                , pl2.cod_pessoa
                                                , p2.situacao_id
                                             from oper.v$pneu_dados p2
                                             left join oper.v$pneu_localizacao_atual pl2
                                               on pl2.pneu_id = p2.pneu_id
                                             left join oper.v$pneu_reforma_completo pr
                                               on pr.pneu_id = p2.pneu_id
                                              and pr.conserto = 0
                                            where p2.reformas > 0
                                              and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                                                                                from oper.v$pneu_reforma pr2
                                                                               where pr2.pneu_id = pr.pneu_id
                                                                                 and pr2.conserto = 0)
                                                   or (pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                                                                  from oper.v$pneu_reforma_completo pr2
                                                                                 where pr2.pneu_id = pr.pneu_id
                                                                                   and pr2.conserto = 0)
                                                       and not exists (select 1
                                                                         from oper.v$pneu_reforma pr2
                                                                        where pr2.pneu_id = pr.pneu_id
                                                                          and pr2.conserto = 0)
                                                      )

                                                  )
                                              and exists (select 'x'
                                                            from oper.v$pneu_movimentacao pm
                                                           where pm.pneu_id = pr.pneu_id
                                                             and pm.data_montagem > pr.data_retorno_reforma)
                                         group by pl2.cod_pessoa
                                                , p2.situacao_id
                                                ) b
                                    where 1 = 1
                                      and nvl(b.cod_pessoa, -1) = nvl(pl.cod_pessoa, -1)
                                      and b.situacao_id = p.situacao_id) as reformados
                             from oper.v$pneu p
                            inner join oper.v$pneu_situacao ps
                               on ps.situacao_id = p.situacao_id
                             left join oper.v$pneu_localizacao_atual pl
                               on pl.pneu_id = p.pneu_id
                              and pl.data_entrada is not null
                             left join kss.v$pessoa pj
                               on pj.cod_pessoa = pl.cod_pessoa


                               ) t
                    where 1 = 1

                 group by t.situacao_id
                        , t.descricao
                        , t.cod_pessoa
                        , t.cliente
                        , t.nome_fantasia
                        , t.novos_0km
                        , t.novos
                        , t.reformados_0km
                        , t.reformados
                 order by t.situacao_id
                        , t.descricao
                        , t.cod_pessoa
                        , t.cliente
                  ) y



		</cfquery>
		<cfreturn qr_marcas>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os custos de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_pneu_custo" returntype="query" access="remote">
	    <cfargument name="num_pneu" required="yes">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.custo as custo_novo
			     , p.sulco as sulco_novo
			     , pr.custo as custo_reforma
			     , pd.sulco as sulco_reforma
			     , nvl(pc.valor,0) as custo_carcaca
			     , case
					  when p.reformas = 0 then
					     ROUND((p.custo - nvl(pc.valor,0)) / ( (p.sulco-2) ),2)
					  when p.reformas = 1 then
					     ROUND((pr.custo + nvl(pc.valor,0) - nvl(pc.valor *0.5 ,0)) / (pd.sulco-2) ,2)
					  when p.reformas = 2 then
					     ROUND((pr.custo + nvl(pc.valor * 0.5 ,0) - nvl(pc.valor * 0.25 ,0)) / (pd.sulco - 2),2)
					  when p.reformas = 3 then
					     ROUND((pr.custo + nvl(pc.valor * 0.25 ,0) - nvl(pc.valor * 0.125 ,0)) / (pd.sulco - 2),2)
					  else
					     ROUND((pr.custo + nvl(pc.valor,0)) / (pd.sulco - 2),2)
				   end custo_mm
			     , oper.pkg_pneu.fnc_valor_pneu(p.pneu_id) as valor_pneu
			  from oper.v$pneu_dados p
			 left join oper.v$pneu_carcaca pc
					on pc.marca_id = p.marca_id
				   and pc.medida_id = p.medida_id
				   and pc.data_fim is null
			 left join oper.v$pneu_reforma pr
					on pr.pneu_id = p.pneu_id
				   and pr.conserto = 0
			 left join oper.v$pneu_desenho pd
					on pd.borracha_id = pr.borracha_id
				   and pd.desenho_id = pr.desenho_id
				 where 1=1
				   and (pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
												  from oper.v$pneu_reforma pr2
												 where pr2.pneu_id = pr.pneu_id)
												 or(select max(pr2.data_envio_reforma)
												  from oper.v$pneu_reforma pr2
												 where pr2.pneu_id = pr.pneu_id) is null)
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = trim('#arguments.num_pneu#')
			 </cfif>
		</cfquery>
		<cfreturn qrPneus>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca os custos de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_pneu_custo_referencia" returntype="query" access="remote">
	    <cfargument name="marca_id" required="yes">
	    <cfargument name="modelo_id" required="yes">
	    <cfargument name="medida_id" required="yes">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select custo
			     , data_aquisicao
			     , num_pneu
            from (select custo, to_char(data_aquisicao,'dd/mm/yyyy') as data_aquisicao, num_pneu
                    from oper.v$pneu p
                   where 1=1
                     and marca_id = #arguments.marca_id#
                     and modelo_id = #arguments.modelo_id#
                     and medida_id = #arguments.medida_id#
                   order by p.data_aquisicao desc, p.num_pneu desc)
           where rownum = 1
		</cfquery>
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pneus adquiridos no periodo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  27/03/2006
	--->		
	<cffunction name="get_pneus_adquiridos" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="yes">
		<cfargument name="data_fim" required="yes">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="formato_borracha" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="situacao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select 	pd.pneu_id,
						pd.num_pneu,
						pd.situacao_id,
						pd.data_aquisicao,
						pd.custo,
						pd.marca,
						pd.modelo,
						pd.medida,
						pd.situacao,
						pd.sulco,
						pd.formato_borracha,
						ps.cliente as filial
					 from oper.v$pneu_dados pd
				left join oper.v$pneu_localizacao_atual pl
					   on pd.pneu_id = pl.pneu_id and pl.data_saida is null
				left join kss.v$pessoa ps
					   on pl.cod_pessoa = ps.cod_pessoa
			 	where 1=1
			   and trunc(pd.data_aquisicao) >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
			   and trunc(pd.data_aquisicao) <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
			  <cfif len(trim(marca_id))>
			   and pd.marca_id in (#arguments.marca_id#)
			  </cfif> 
			  <cfif len(trim(modelo_id))>
			   and pd.modelo_id in (#arguments.modelo_id#)
			  </cfif> 
			  <cfif len(trim(formato_borracha))>
			   and pd.formato_borracha in (#ListQualify(arguments.formato_borracha, "'", ',')#)
			  </cfif> 
			  <cfif len(trim(medida_id))>
			   and pd.medida_id in (#arguments.medida_id#)
			  </cfif>
			  <cfif len(trim(arguments.situacao)) and arguments.situacao eq 1>
			   and pd.nota_fiscal_numero is not null
			  </cfif> 
			 order by data_aquisicao
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

</cfcomponent>
