<!-- KM&M Componentes -->
<cfcomponent extends="_transportes.consulta.cfc_pneus">		
	<!--- 
	-- PROPSITO 
	-- Busca Vendas
	-- NOTAS EXPLICATIVAS
	-- WAGNER 07/10/2006
	--->
	<cffunction name="get_venda_pneu" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no" default="">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select  p.pneu_id
				   ,p.num_pneu
				   ,(    select pp1.cod_pessoa
						   from oper.v$pneu_proprietario pp1
						  where pp1.pneu_id = p.pneu_id
							and pp1.DATA_FIM is not null
							and pp1.data_fim = ( 	select max(pp2.data_fim) 
												      from oper.v$pneu_proprietario pp2
												 	  where pp2.pneu_id = p.pneu_id
												 		and pp2.DATA_FIM is not null)) as cod_ultimo_proprietario
				   ,nvl(oper.pkg_global.fnc_busca_nome_pessoa(
						(select pp1.cod_pessoa
						   from oper.v$pneu_proprietario pp1
						  where pp1.pneu_id = p.pneu_id
							and pp1.DATA_FIM is not null
							and pp1.data_fim = ( 	select max(pp2.data_fim) 
												  	  from oper.v$pneu_proprietario pp2
												 	 where pp2.pneu_id = p.pneu_id
												 	   and pp2.DATA_FIM is not null))),'No Consta.') as ultimo_proprietario
				   
				   ,(    select pp3.cod_pessoa 
						   from oper.v$pneu_proprietario pp3
						  where pp3.pneu_id = p.pneu_id
							and pp3.data_fim is null) as cod_proprietario
				   ,oper.pkg_global.fnc_busca_nome_pessoa(
						(select pp3.cod_pessoa 
						   from oper.v$pneu_proprietario pp3
						  where pp3.pneu_id = p.pneu_id
							and pp3.data_fim is null)) as proprietario
				   ,po.situacao_id
				   ,po.date_insert as data_venda
				   ,po.operacao
			  from oper.v$pneu p
	    inner join oper.v$pneu_ocorrencia po
				on po.pneu_id = p.pneu_id
			   and po.SITUACAO_ID in (11,7)
			 where 1=1
			   and p.SITUACAO_ID in (11,7)
			 <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
			   and trunc(po.DATE_INSERT) between  '#arguments.data_inicial#' and '#arguments.data_final#'
			 </cfif>
			 <cfif Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = #arguments.num_pneu#
			 </cfif>
             order by p.pneu_id
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>