<cfcomponent displayname="Consultas da referentes a CTE" extends="_transportes.consulta.cfc_cte">
	<!--- 
	-- PROPSITO 
	-- Busca os CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_cte_lista" displayname="Busca Modelos para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="data_inicio" required="no" default="#DateFormat(now() - 7, 'DD/MM/YYYY')#">
        <cfargument name="data_termino" required="no" default="#DateFormat(now(), 'DD/MM/YYYY')#">
        <cfargument name="dacte_impresso" required="no" default="">
        <cfargument name="num_cte" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="serie" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select cte.conhecimento_id      
                 , cte.num_conhecimento
                 , cte.serie
                 , to_char(cte.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , cte.num_romaneio
                 , cte.rem_razao_social
                 , kss.pkg_string.fnc_formata_cnpj_cpf(cte.rem_cnpj_cpf) as rem_cnpj_cpf
                 , cte.dest_razao_social
                 , kss.pkg_string.fnc_formata_cnpj_cpf(cte.dest_cnpj_cpf) as dest_cnpj_cpf
                 , dc.documento_id
                 , ds.cod_status
                 , ds.descricao_status
                 , nvl(ds.situacao_id, 0) as situacao_id
                 , ds.emitido
                 , ds.permite_editar
                 , ds.permite_cancelar
                 , cte.user_insert
                 , nvl(cte.status_email_remetente,0) as status_email_remetente
                 , nvl(cte.status_email_destinatario,0) as status_email_destinatario
                 , nvl(cte.status_email_recebedor,0) as status_email_recebedor
                 , nvl(cte.status_email_expedidor,0) as status_email_expedidor
                 , nvl(cte.status_email_tomador,0) as status_email_tomador
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_remetente) as email_remetente
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_destinatario) as email_destinatario
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.entrega_cod_pessoa) as email_recebedor
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.coleta_cod_pessoa) as email_expedidor
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_consignatario) as email_tomador
                 , (select p.cliente
                      from kss.v$pessoa p
                      where p.cod_pessoa = cte.cod_pessoa_filial) as filial
                 , cte.coleta_municipio || ' - ' || cte.coleta_uf as coleta
                 , cte.entrega_municipio || ' - ' || cte.entrega_uf as entrega
                 , (select te.descricao
                      from sefaz.v$tipo_emissao te
                     where te.cod_docto = 'CTE'
                       and te.tipo_emissao_id =  ds.tipo_emissao_id) as tipo_emissao
                 , ds.tipo_emissao_id
                 , d.ambiente_id
                 , cte.liberado_impressao
                 , fiscal.pkg_cte.fnc_permite_liberar_impressao(cte.conhecimento_id) as libera_impressao
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(cte.placa_tracao) as cod_veiculo_tracao
                 , cte.modalidade
                 , cte.nome_motorista
                 , cte.cod_organizacional || ' - ' ||
                   (select descricao
                      from kss.v$organizacional org
                     where org.organizacional_id = cte.organizacional_id ) as organizacional
              from fiscal.v$conhecimento cte
        inner join fiscal.v$documento_cte dc
                on dc.conhecimento_id = cte.conhecimento_id
        inner join fiscal.v$documento_status ds
                on ds.documento_id = dc.documento_id
        inner join sefaz.documento d
                on d.documento_id = ds.documento_id
             where 1 = 1
             <cfif (Len(Trim(arguments.situacao_id)) and (arguments.situacao_id neq '0,1,2,3,4,5'))>
             	and nvl(ds.situacao_id, 0) in(#arguments.situacao_id#)
             </cfif>
             <cfif Len(Trim(arguments.cod_pessoa_filial))>
             	and cte.cod_pessoa_filial = #arguments.cod_pessoa_filial#
             </cfif>
             <cfif Len(Trim(arguments.serie)) and Len(Trim(arguments.serie))>
                and cte.serie in (#ListQualify(arguments.serie,"'",",")#)
             </cfif>
             <cfif isDefined("arguments.conhecimento_tipo_id") and Len(Trim(arguments.conhecimento_tipo_id)) >
               and cte.conhecimento_tipo_id = #arguments.conhecimento_tipo_id#
           </cfif>
			 <cfif Len(Trim(arguments.num_cte))>
             	and cte.num_conhecimento = #arguments.num_cte#             					
             <cfelse>
				 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                    and trunc(cte.data_emissao) between trunc(to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi:ss')) and trunc(to_date('#arguments.data_termino#', 'dd/mm/yyyy hh24:mi:ss'))
                 </cfif>
                 <cfif arguments.dacte_impresso eq 0>
                    and cte.impressao_dacte is null
                 <cfelseif arguments.dacte_impresso eq 1>
                    and cte.impressao_dacte is not null
                 </cfif>
           	 </cfif>
           order by lpad(cte.serie,3,'0') asc , cte.num_conhecimento desc
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados resumidos do CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 01/12/2010
	--->
	<cffunction name="get_cte_resumo" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select dc.documento_id
            	 , c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
                 , (select d.chave
                      from fiscal.v$dacte d
                     where d.documento_id = dc.documento_id) as chave_cte
                 , ds.cod_status
                 , ds.situacao_id
                 , ds.descricao_status
                 , ds.permite_editar
                 , ds.permite_inutilizar
                 , ds.emitido
				 , d.tipo_emissao_id
                 , c.liberado_impressao
                 , fiscal.pkg_cte.fnc_permite_liberar_impressao(c.conhecimento_id) as libera_impressao
              from fiscal.v$conhecimento c
             inner join fiscal.v$documento_cte dc
                on dc.conhecimento_id = c.conhecimento_id
             inner join sefaz.documento d
                on d.documento_id = dc.documento_id
             inner join fiscal.v$documento_status ds
               on ds.documento_id = dc.documento_id
             where c.conhecimento_id = #arguments.conhecimento_id#
		</cfquery> 
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>
