<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de clientes" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as filas de carga do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  02/02/2006
	--->
	<cffunction name="get_fila_carga" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */  
            	   distinct 
                   pj.nome_fantasia, 
                   rhv.placa_controle, oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_controle) as frota,
				   rd.num_romaneio, 
                   rd.item_id, 
                   to_char(rd.inicio_carga_veiculo,'dd/mm/yyyy hh24:mi') as inicio_carga_veiculo,
                   to_char(rd.inicio_carga_fabrica,'dd/mm/yyyy hh24:mi') as inicio_carga_fabrica,
				   oper.pkg_global.fnc_tempo_formatado( (sysdate - rd.inicio_carga_fabrica)*60*60*24 ) as tempo_carga,
				   (sysdate - rd.inicio_carga_fabrica)*60*60*24 as tempo_carga_seg,
  				   (select placa_2
					  from oper.v$veiculo_composicao vc
				     where vc.placa_1 = (select placa_2 
					 				 	   from oper.v$veiculo_composicao vc2
										  where vc2.placa_1 = r.placa_controle
										    and vc2.data_hora_desengate is null)
					   and vc.data_hora_desengate is null) as placa_bitrem,
				   gld.fluxo_carga*60 as fluxo_carga
			  from oper.v$romaneio_carga rd
		     inner join oper.v$romaneio r
					 on r.num_romaneio = rd.num_romaneio 
					and r.data_inicio > sysdate - 30					 
			 inner join oper.v$romaneio_item ri
					 on ri.num_romaneio = rd.num_romaneio 
					and ri.item_id = rd.item_id
		 	 inner join oper.v$romaneio_hist_veiculo rhv
			         on rhv.num_romaneio = r.num_romaneio
				    and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate))
                                                           from oper.v$romaneio_hist_veiculo rhv2
                                                          where rhv.num_romaneio = rhv2.num_romaneio)                                               
			 inner join oper.v$grupo_logistico_acesso gld
					 on gld.cod_pessoa_carga = ri.cod_remetente
			 inner join kss.v$pessoa_juridica pj
					 on pj.cod_pessoa = ri.cod_remetente    
			 where rd.termino_carga is null    
               and ri.cod_destinatario in (select gld.cod_pessoa_descarga 
                                            from oper.v$grupo_logistico_acesso gld)
			   and  ((rhv.placa_controle in (select placa
			                                from oper.v$grupo_logistico_veiculo_user)
                    or rhv.placa_referencia in (select placa
			                                from oper.v$grupo_logistico_veiculo_user)                    
                   )  or gld.somente_veiculos = 0)               
                   
			 order by pj.nome_fantasia, inicio_carga_fabrica
   		</cfquery>	
		<cfreturn qr_horario>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as filas de descarga do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  02/02/2006
	--->
	<cffunction name="get_fila_descarga" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
			select /*+ LEADING(RD) USE_HASH(RD R) */  distinct pj.nome_fantasia, 
				   rhv.placa_controle, oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_controle) as frota
                   ,rd.num_romaneio, rd.item_id, 
                   to_char(rd.inicio_descarga_veiculo,'dd/mm/yyyy hh24:mi') as inicio_descarga_veiculo,
                   to_char(rd.inicio_descarga_fabrica,'dd/mm/yyyy hh24:mi') as inicio_descarga_fabrica,

				   oper.pkg_global.fnc_tempo_formatado( (sysdate - rd.inicio_descarga_fabrica)*60*60*24 ) as tempo_descarga,
				   (sysdate - rd.inicio_descarga_fabrica)*60*60*24 as tempo_descarga_seg,
 				   (select /*+first_rows*/placa_2
					  from oper.v$veiculo_composicao vc
				     where vc.placa_1 = (select placa_2 
										   from oper.v$veiculo_composicao vc2
										  where vc2.placa_1 = r.placa_controle
										    and vc2.data_hora_desengate is null)
					   and vc.data_hora_desengate is null) as placa_bitrem,
					   gld.fluxo_descarga*60 as fluxo_descarga, r.remetente
			  from oper.v$romaneio_descarga rd
			 inner join oper.v$romaneio r
					 on r.num_romaneio = rd.num_romaneio 
		            and r.data_inicio > sysdate - 30					 
		 	 inner join oper.v$romaneio_hist_veiculo rhv
			         on rhv.num_romaneio = r.num_romaneio
				    and rhv.data_termino is null
			 inner join oper.v$romaneio_item ri
					 on ri.num_romaneio = rd.num_romaneio 
					and ri.item_id = rd.item_id
			 inner join oper.v$grupo_logistico_acesso gld
					 on gld.cod_pessoa_descarga = ri.cod_destinatario
			 inner join kss.v$pessoa_juridica pj
					 on pj.cod_pessoa = ri.cod_destinatario        
			 where rd.termino_descarga is null 
			   and ((rhv.placa_controle in (select placa
			                                from oper.v$grupo_logistico_veiculo_user)
                    or rhv.placa_referencia in (select placa
			                                from oper.v$grupo_logistico_veiculo_user)
                   )  or gld.somente_veiculos = 0)
                   
			   and ri.cod_remetente in (select cod_pessoa_carga
			                              from oper.v$grupo_logistico_acesso)    
			   and ri.cod_destinatario in (select cod_pessoa_descarga
  			                                 from oper.v$grupo_logistico_acesso)
			order by pj.nome_fantasia, inicio_descarga_fabrica desc 
   		</cfquery>	
		<cfreturn qr_horario>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca o fluxo de carga do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/02/2006
	--->	
	<cffunction name="get_fluxo_carga" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="yes">
		<cfargument name="data_fim" required="yes">
		<cfargument name="grupo_id" required="no" default="">
		<cfscript>
		    if (not len(trim(arguments.grupo_id))) {
				qrGrupo = this.get_grupo_corrente();
				arguments.grupo_id = qrGrupo.grupo_id;
			}
		</cfscript>
		<cfquery name="qrFluxoViagens" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif DateCompare(arguments.data_fim,DateFormat(Now(),'dd/mm/yyyy')) eq 0>
					select /*+ ORDERED */ 
                                 2 as tipo, 
                                   cod_remetente, 
                                   null as cod_destinatario, 
                                   'Carregando' as nome_fantasia, 
                                   num_romaneio, 
                                   placa_controle,
                       motorista, 
                                   carregamento, 
                                   to_char(data_inicio_carga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga, 
                                   to_char(data_termino_carga,'dd/mm/yyyy hh24:mi:ss') as data_termino_carga, 
                                   to_char(data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada, 
                       decode(tempo_carga_seg,null,'  00 : 00',tempo_carga) as tempo_carga,
                       tempo_parado, 
                       destino, 
                                   to_char(data_inicio_descarga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga, 
                                   to_char(data_chegada_descarga,'dd/mm/yyyy hh24:mi:ss') as data_chegada_descarga, 
                                   to_char(data_termino_descarga,'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga, 
                       decode(tempo_descarga_seg,null,'  00 : 00',tempo_descarga) as tempo_descarga,
                       tempo_parado_descarga,
                       avg(tempo_carga_seg) over() as media_geral_carga_seg, 
                       avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente) as media_tempo_carga_seg, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over()) as media_geral_carga, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_carga, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_parado_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_parado, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga, 
                       (sum(peso_total) over())/1000 as peso_total_carga,
                       (count(*) over()) as total_viagens_carga,
                       (sum(peso_total) over(partition by cod_remetente order by cod_remetente))/1000 as peso_total,
                       (count(*) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as total_viagens_dest,
                       (count(*) over(partition by cod_remetente order by cod_remetente)) as total_viagens
                    from (select rit.cod_remetente, 
                                       rit.cod_destinatario, 
                                           r.num_romaneio,
                           r.placa_controle, 
                                           pf.nome as motorista, 
                                           r.carregamento,
                           rc.inicio_carga_veiculo as data_chegada, 
                           rc.inicio_carga_fabrica as data_inicio_carga,
                           rc.termino_carga as data_termino_carga, 
                                           r.peso_total,
                           oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_fabrica) * 86400) tempo_carga,
                           oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_veiculo) * 86400) tempo_parado,
                           case  
                            when rc.termino_carga < rc.inicio_carga_fabrica then null
                            else nvl((rc.termino_carga -  rc.inicio_carga_fabrica),0) * 86400 
                                           end tempo_carga_seg,
                           nvl((rc.termino_carga -  rc.inicio_carga_veiculo),0) * 86400 as tempo_parado_seg,
                           r.destino, 
                                           rd.inicio_descarga_veiculo as data_chegada_descarga, 
                                           rd.inicio_descarga_fabrica as data_inicio_descarga, 
                           rd.termino_descarga as data_termino_descarga,
                           oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_fabrica) * 86400) as tempo_descarga,
                           oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_veiculo) * 86400) as tempo_parado_descarga,
                           case
                            when rd.termino_descarga < rd.inicio_descarga_fabrica then null
                            else nvl((rd.termino_descarga - rd.inicio_descarga_fabrica),0) * 86400 
                                           end tempo_descarga_seg,
                           (rd.termino_descarga -  rd.inicio_descarga_veiculo) * 86400 as tempo_parado_descarga_seg,
                           rank() over (partition by r.num_romaneio order by rit.item_id) rank
                        from oper.v$romaneio r
                       inner join oper.v$romaneio_item rit 
                           on rit.num_romaneio = r.num_romaneio         
                          and rit.redespacho = 0
                       inner join oper.v$romaneio_carga rc
                           on rc.num_romaneio = rit.num_romaneio
                          and rc.item_id = rit.item_id
                       left join oper.v$romaneio_descarga rd
                         on rd.num_romaneio = rit.num_romaneio
                        and rd.item_id = rit.item_id
                       inner join oper.v$romaneio_evento rev
                           on rev.num_romaneio = r.num_romaneio         
                       inner join oper.v$evento_operacao evo
                               on evo.controle_evo_id = rev.controle_evo_id
                       inner join oper.v$romaneio_hist_veiculo rhv 
                           on rhv.num_romaneio = r.num_romaneio
                            and rhv.placa_controle = r.placa_controle
                          and rhv.data_inicio = (select max(rhv2.data_inicio)
                                       from oper.v$romaneio_hist_veiculo rhv2
                                      where rhv2.num_romaneio = rhv.num_romaneio)             
                       inner join kss.v$pessoa_fisica pf 
                               on pf.cod_pessoa = rhv.cod_pessoa
                       where rit.cod_remetente in (select cod_pessoa_carga 
                                       from oper.v$grupo_logistico_carga
                                        where grupo_id = #arguments.GRUPO_ID#)
                         and evo.num_evento = 2) a
                  where rank = 1 
                      and (cod_destinatario is null and data_termino_carga is null)
				union
				</cfif>  
				
                    select /*+ ORDERED */ 
                    	   1 as tipo, 
                           cod_remetente, 
                           cod_destinatario, 
                           pj.nome_fantasia, 
                           num_romaneio, 
                           placa_controle,
                           motorista, 
                           carregamento, 
                           to_char(data_inicio_carga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga, 
                           to_char(data_termino_carga,'dd/mm/yyyy hh24:mi:ss') as data_termino_carga, 
                           to_char(data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada, 
                           decode(tempo_carga_seg,null,'  00 : 00',tempo_carga) as tempo_carga,
                           tempo_parado, 
                           destino, 
                           to_char(data_inicio_descarga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga, 
                           to_char(data_chegada_descarga,'dd/mm/yyyy hh24:mi:ss') as data_chegada_descarga, 
                           to_char(data_termino_descarga,'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga, 
                           decode(tempo_descarga_seg,null,'  00 : 00',tempo_descarga) as tempo_descarga,
                           tempo_parado_descarga,
                           avg(tempo_carga_seg) over() as media_geral_carga_seg, 
                           avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente) as media_tempo_carga_seg, 
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over()) as media_geral_carga, 
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_carga, 
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_parado_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_parado, 
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga, 
                           oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga, 
                           (sum(peso_total) over())/1000 as peso_total_carga,
                           (count(*) over()) as total_viagens_carga,
                           (sum(peso_total) over(partition by cod_remetente order by cod_remetente))/1000 as peso_total,
                           (count(*) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as total_viagens_dest,
                           (count(*) over(partition by cod_remetente order by cod_remetente)) as total_viagens
                      from (select rit.cod_remetente, 
                      			   rit.cod_destinatario, 
                                   r.num_romaneio,
                                   r.placa_controle, 
                                   pf.nome as motorista, 
                                   r.carregamento,
                                   rc.inicio_carga_veiculo as data_chegada, 
                                   rc.inicio_carga_fabrica as data_inicio_carga,
                                   rc.termino_carga as data_termino_carga, r.peso_total,
                                   case  
                                      when rc.termino_carga < rc.inicio_carga_fabrica then ' 00 : 00'
                                      when rc.termino_carga is not null and rc.inicio_carga_fabrica is not null then oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_fabrica) * 86400)
                                      else null 
                                   end tempo_carga,
                                   oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_veiculo) * 86400) tempo_parado,
                                   case  
                                      when rc.termino_carga < rc.inicio_carga_fabrica then 0
                                      when rc.termino_carga is not null and rc.inicio_carga_fabrica is not null then nvl((rc.termino_carga -	rc.inicio_carga_fabrica),0) * 86400
                                      else null 
                                   end tempo_carga_seg,
                                   nvl((rc.termino_carga -	rc.inicio_carga_veiculo),0) * 86400 as tempo_parado_seg,
                                   r.destino, 
                                   rd.inicio_descarga_veiculo as data_chegada_descarga, 
                                   rd.inicio_descarga_fabrica as data_inicio_descarga, 
                                   rd.termino_descarga as data_termino_descarga,
                                   case  
                                      when nvl(rd.termino_descarga,sysdate) < rd.inicio_descarga_fabrica then ' 00 : 00'
                                      else oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_fabrica) * 86400) 
                                   end tempo_descarga,
                                   oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_veiculo) * 86400) as tempo_parado_descarga,
                                   case
                                      when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
                                      when rd.termino_descarga is not null and rd.inicio_descarga_fabrica is not null then nvl((rd.termino_descarga - rd.inicio_descarga_fabrica),0) * 86400
                                      else null 
                                   end tempo_descarga_seg,
                                   (rd.termino_descarga -	rd.inicio_descarga_veiculo) * 86400 as tempo_parado_descarga_seg,
                                   rank() over (partition by r.num_romaneio order by rit.item_id) rank
                              from oper.v$romaneio r
                             inner join oper.v$romaneio_item rit 
                                     on rit.num_romaneio = r.num_romaneio				 
                                    and rit.redespacho = 0
                             inner join oper.v$romaneio_carga rc
                                     on rc.num_romaneio = rit.num_romaneio
                                    and rc.item_id = rit.item_id
                             left join oper.v$romaneio_descarga rd
                                     on rd.num_romaneio = rit.num_romaneio
                                    and rd.item_id = rit.item_id
                             inner join oper.v$romaneio_hist_veiculo rhv 
                                     on rhv.num_romaneio = r.num_romaneio
                                    and rhv.placa_controle = r.placa_controle
                                    and rhv.data_inicio = (select max(rhv2.data_inicio)
                                                             from oper.v$romaneio_hist_veiculo rhv2
                                                            where rhv2.num_romaneio = rhv.num_romaneio)						 
                             inner join kss.v$pessoa_fisica pf 
                                     on pf.cod_pessoa = rhv.cod_pessoa
                             where rit.cod_remetente in (select cod_pessoa_carga
                                                           from oper.v$grupo_logistico_carga
                                                          where grupo_id = #arguments.grupo_id#)
                               and rit.cod_destinatario in (select cod_pessoa_descarga 
                                                              from oper.v$grupo_logistico_descarga
                                                             where grupo_id = #arguments.grupo_id#)
                               and trunc(r.data_termino_carga) between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#') a,
                           kss.v$pessoa_juridica pj
                     where pj.cod_pessoa = cod_destinatario
                       and rank = 1 
                     order by carregamento, tipo, data_chegada  
			</cfquery>
		<cfreturn qrFluxoViagens>
	</cffunction>				

	<!--- 
	-- PROPSITO 
	-- Busca o fluxo de descarga do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->
	<cffunction name="get_fluxo_descarga" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="yes">
		<cfargument name="data_inicio" required="yes">
		<cfargument name="data_fim" required="yes">
			<cfquery name="qrFluxoViagens" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ ORDERED */ 
                	   cod_remetente, 
                       cod_destinatario, 
                       pj.nome_fantasia, 
                       num_romaneio, 
                       placa_controle,
					   motorista, 
                       carregamento, 
                       to_char(data_inicio_carga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga, 
                       to_char(data_termino_carga,'dd/mm/yyyy hh24:mi:ss') as data_termino_carga, 
                       to_char(data_chegada_descarga,'dd/mm/yyyy hh24:mi:ss') as data_chegada_descarga,
   					   tempo_carga,
               		   destino, 
                       to_char(data_inicio_descarga,'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga, 
                       to_char(data_termino_descarga,'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga, 
               		   tempo_descarga, 
                       to_char(data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada,
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga_seg) over(partition by cod_remetente order by cod_remetente)) as media_tempo_carga, 
                       avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario) as media_tempo_descarga_seg, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as media_tempo_descarga, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_descarga_seg) over(partition by cod_remetente order by cod_remetente)) as media_geral_descarga, 
                       oper.pkg_global.fnc_tempo_formatado(avg(tempo_parado_descarga_seg) over(partition by cod_remetente order by cod_remetente)) as media_geral_parado_descarga, 
                       avg(tempo_descarga_seg) over(partition by cod_remetente order by cod_remetente) as media_geral_descarga_seg, 
                       (sum(peso_total) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario))/1000 as peso_total,
                       (count(*) over(partition by cod_remetente, cod_destinatario order by cod_remetente, cod_destinatario)) as total_viagens_dest,
                       (count(*) over(partition by cod_remetente order by cod_remetente)) as total_viagens
				  from (select rit.cod_remetente, 
                  			   rit.cod_destinatario, 
                               r.num_romaneio,
							   r.placa_controle, 
                               pf.nome as motorista, 
                               r.carregamento,
                               rc.inicio_carga_veiculo as data_chegada, 
                               rc.inicio_carga_fabrica as data_inicio_carga,
                               rc.termino_carga as data_termino_carga, r.peso_total,
                               case  
                                  when rc.termino_carga < rc.inicio_carga_fabrica then ' 00 : 00'
                                  when rc.termino_carga is not null and  rc.inicio_carga_fabrica is not null then oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_fabrica) * 86400)
                                  else null 
                               end tempo_carga,
                               oper.pkg_global.fnc_tempo_formatado((rc.termino_carga - rc.inicio_carga_veiculo) * 86400) as tempo_parado,
                               case  
                                  when rc.termino_carga < rc.inicio_carga_fabrica then 0
                                  when rc.termino_carga is not null and  rc.inicio_carga_fabrica is not null then nvl((rc.termino_carga -	rc.inicio_carga_fabrica),0) * 86400
                                  else null 
                               end tempo_carga_seg,
                               nvl((rc.termino_carga -	rc.inicio_carga_veiculo),0) * 86400 as tempo_parado_seg,
                               r.destino, 
                               rd.inicio_descarga_veiculo as data_chegada_descarga, 
                               rd.inicio_descarga_fabrica as data_inicio_descarga, 
                               rd.termino_descarga as data_termino_descarga,
                               case
                                  when rd.termino_descarga < rd.inicio_descarga_fabrica then ' 00 : 00'
                                  when rd.termino_descarga is not null and rd.inicio_descarga_fabrica is not null then oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_fabrica) * 86400)
                                  else null 
                               end tempo_descarga,
                               oper.pkg_global.fnc_tempo_formatado((nvl(rd.termino_descarga,sysdate) - rd.inicio_descarga_veiculo) * 86400) as tempo_parado_descarga,
                               case
                                  when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
                                  when rd.termino_descarga is not null and rd.inicio_descarga_fabrica is not null then nvl((rd.termino_descarga - rd.inicio_descarga_fabrica),0) * 86400
                                  else null 
                               end tempo_descarga_seg,
                               (rd.termino_descarga -	rd.inicio_descarga_veiculo) * 86400 as tempo_parado_descarga_seg,
                               rank() over (partition by r.num_romaneio order by rit.item_id) rank
                          from oper.v$romaneio r
                         inner join oper.v$romaneio_item rit 
                                 on rit.num_romaneio = r.num_romaneio				 
                                and rit.redespacho = 0
                          left join oper.v$romaneio_carga rc 
                                 on rc.num_romaneio = rit.num_romaneio
                                and rc.item_id = rit.item_id
                          left join oper.v$romaneio_descarga rd 
                                 on rd.num_romaneio = rit.num_romaneio
                                and rd.item_id = rit.item_id         
						 inner join oper.v$romaneio_hist_veiculo rhv 
								 on rhv.num_romaneio = r.num_romaneio
								and rhv.placa_controle = r.placa_controle
								and rhv.data_inicio = (select max(rhv2.data_inicio)
													     from oper.v$romaneio_hist_veiculo rhv2
														where rhv2.num_romaneio = rhv.num_romaneio)						 
						 inner join kss.v$pessoa_fisica pf 
                                 on pf.cod_pessoa = rhv.cod_pessoa
						 where rit.cod_remetente in (select cod_pessoa_carga 
													   from oper.v$grupo_logistico_carga
													  where grupo_id = #arguments.grupo_id#)
						   and rit.cod_destinatario in (select cod_pessoa_descarga 
														  from oper.v$grupo_logistico_descarga
														 where grupo_id = #arguments.grupo_id#)
						   and trunc(r.data_termino_descarga) between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#') a,
					   kss.v$pessoa_juridica pj
				 where pj.cod_pessoa = cod_destinatario
				   and rank = 1 
				 order by cod_remetente, cod_destinatario, data_chegada_descarga
			</cfquery>
		<cfreturn qrFluxoViagens>
	</cffunction>		
			
	<!--- 
	-- PROPSITO 
	-- Busca o grupo do usuario corrente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  13/02/2006
	--->		
	<cffunction name="get_grupo_corrente" access="remote" returntype="query" output="true">
		<cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select grupo_id, somente_veiculos 
   			  from oper.v$grupo_logistico_user
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os grupos logisticos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  06/03/2006
	--->
	<cffunction name="get_grupos" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_grupos" username="#session.usuario#" password="#session.senha#">
			select gl.grupo_id, 
            	   gl.descricao
			  from oper.v$grupo_logistico gl
   		</cfquery>	
		<cfreturn qr_grupos>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os horarios de carga do local
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->
	<cffunction name="get_local_carga_horario" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" 		required="no" default="">
		<cfargument name="cod_pessoa_carga" required="no" default="">
		<cfscript>
			if(not len(trim(arguments.grupo_id)) and not len(trim(arguments.cod_pessoa_carga))) {
				qrGrupo = this.get_grupo_corrente();
				arguments.grupo_id = qrGrupo.grupo_id;
			}
		</cfscript>		
		<cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
			select distinct pj.nome_fantasia, gla.cod_pessoa_carga, lch.dia_semana, 
				   kss.to_tempo(lch.hora_inicio,4).retorno as hora_inicio, 
                   ceil((extract (HOUR from lch.hora_inicio)*60+extract (MINUTE from lch.hora_inicio))*(958/1440)) as inicio_pixel,
                   ceil((extract (HOUR from lch.hora_fim)*60+extract (MINUTE from lch.hora_fim))*(958/1440)) as fim_pixel,
				   kss.to_tempo(lch.hora_fim,4).retorno as hora_fim 
			  from oper.v$horario_carga_pessoa lch
			 inner join oper.v$grupo_logistico_<cfif not len(trim("arguments.grupo_id"))>acesso<cfelse>carga</cfif> gla
					 on gla.cod_pessoa_carga = lch.cod_pessoa
		     inner join kss.v$pessoa_juridica pj
			         on pj.cod_pessoa = gla.cod_pessoa_carga
			 <cfif Len(Trim(arguments.grupo_id))>
			   and gla.grupo_id = #arguments.grupo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_carga))>
			   and gla.cod_pessoa_carga = #arguments.cod_pessoa_carga#
			 </cfif>					 
			 order by gla.cod_pessoa_carga, dia_semana, hora_inicio

   		</cfquery>	
		<cfreturn qr_horario>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os horarios de carga do local por data
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->
	<cffunction name="get_local_carga_horario_por_data" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="no" default="">
		<cfargument name="cod_pessoa_carga" required="no" default="">
		<cfscript>
			if(not len(trim(arguments.grupo_id)) and not len(trim(arguments.cod_pessoa_carga))) {
				qrGrupo = this.get_grupo_corrente();
				arguments.grupo_id = qrGrupo.grupo_id;
			}
		</cfscript>			
		<cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
			select distinct pj.nome_fantasia, lch.cod_pessoa_carga,  
		  		   lch.data_hora_inicio as hora_inicio, 
                   trunc(lch.data_hora_inicio) as dia,
                   ceil((extract (HOUR from lch.data_hora_inicio)*60+extract (MINUTE from lch.data_hora_inicio))*(964/1440)) as inicio_pixel,
                   ceil((extract (HOUR from lch.data_hora_fim)*60+extract (MINUTE from lch.data_hora_fim))*(964/1440)) as fim_pixel,
				   lch.data_hora_fim as hora_fim
			  from oper.v$local_carga_grade lch
			 inner join oper.v$grupo_logistico_carga gla
					 on gla.cod_pessoa_carga = lch.cod_pessoa_carga
		     inner join kss.v$pessoa_juridica pj
			         on pj.cod_pessoa = gla.cod_pessoa_carga
			 where 1 = 1
			   and lch.data_hora_inicio > sysdate - 15
			 <cfif Len(Trim(arguments.grupo_id))>
			   and gla.grupo_id = #arguments.grupo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_carga))>
			   and gla.cod_pessoa_carga = #arguments.cod_pessoa_carga#
			 </cfif>
			 order by lch.cod_pessoa_carga, data_hora_inicio
   		</cfquery>	
		<cfreturn qr_horario>
	</cffunction>	
			
	<!--- 
	-- PROPSITO 
	-- Busca os horarios de descarga do local
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->
	<cffunction name="get_local_descarga_horario" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" 		required="no" default="">
		<cfargument name="cod_pessoa_descarga" required="no" default="">
		<cfscript>
			if(not len(trim(arguments.grupo_id)) and not len(trim(arguments.cod_pessoa_descarga))) {
				qrGrupo = this.get_grupo_corrente();
				arguments.grupo_id = qrGrupo.grupo_id;
			}
		</cfscript>			
		<cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
			select distinct pj.nome_fantasia, gla.cod_pessoa_descarga as cod_pessoa_carga, lch.dia_semana, 
				   kss.to_tempo(lch.hora_inicio,4).retorno as hora_inicio, 
                   ceil((extract (HOUR from lch.hora_inicio)*60+extract (MINUTE from lch.hora_inicio))*(958/1440)) as inicio_pixel,
                   ceil((extract (HOUR from lch.hora_fim)*60+extract (MINUTE from lch.hora_fim))*(958/1440)) as fim_pixel,
				   kss.to_tempo(lch.hora_fim,4).retorno as hora_fim  
			  from oper.v$horario_descarga_pessoa lch
			 inner join oper.v$grupo_logistico_<cfif not len(trim("arguments.grupo_id"))>acesso<cfelse>descarga</cfif> gla
					 on gla.cod_pessoa_descarga = lch.cod_pessoa
		     inner join kss.v$pessoa_juridica pj
			         on pj.cod_pessoa = gla.cod_pessoa_descarga
			 <cfif Len(Trim(arguments.cod_pessoa_descarga))>
			   and gla.cod_pessoa_descarga = #arguments.cod_pessoa_descarga#
			 </cfif>					 					 
			 where 1=1
			 <cfif len(trim("arguments.grupo_id"))>
			   and gla.grupo_id = #arguments.grupo_id#
			 </cfif>
			 order by gla.cod_pessoa_descarga, dia_semana, hora_inicio
   		</cfquery>	
		<cfreturn qr_horario>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os horarios de descarga do local por data
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->
	<cffunction name="get_local_descarga_horario_por_data" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="no" default="">
		<cfargument name="cod_pessoa_descarga" required="no" default="">
		<cfscript>
			if(not len(trim(arguments.grupo_id)) and not len(trim(arguments.cod_pessoa_descarga))) {
				qrGrupo = this.get_grupo_corrente();
				arguments.grupo_id = qrGrupo.grupo_id;
			}
		</cfscript>			
		<cfquery datasource="#session.dsn#" name="qr_horario" username="#session.usuario#" password="#session.senha#">
			select distinct pj.nome_fantasia, lch.cod_pessoa_descarga cod_pessoa_carga,  
		  		   lch.data_hora_inicio hora_inicio, trunc(lch.data_hora_inicio) as dia,
                   ceil((extract (HOUR from lch.data_hora_inicio)*60+extract (MINUTE from lch.data_hora_inicio))*(958/1440)) as inicio_pixel,
                   ceil((extract (HOUR from lch.data_hora_fim)*60+extract (MINUTE from lch.data_hora_fim))*(958/1440)) as fim_pixel,
				   lch.data_hora_fim hora_fim	
			  from oper.v$local_descarga_grade lch
			 inner join oper.v$grupo_logistico_descarga gla
					 on gla.cod_pessoa_descarga = lch.cod_pessoa_descarga
		     inner join kss.v$pessoa_juridica pj
			         on pj.cod_pessoa = gla.cod_pessoa_descarga
			 where 1 = 1
			   and lch.data_hora_inicio > sysdate - 15
			 <cfif Len(Trim(arguments.grupo_id))>
			   and gla.grupo_id = #arguments.grupo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_descarga))>
			   and gla.cod_pessoa_descarga = #arguments.cod_pessoa_descarga#
			 </cfif>
			 order by lch.cod_pessoa_descarga, data_hora_inicio
   		</cfquery>	
		<cfreturn qr_horario>
	</cffunction>		
				
	<!--- 
	-- PROPSITO 
	-- Busca o total de peso de Carga
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->		
	<cffunction name="get_peso_carga" access="remote" returntype="query" output="true">
		<cfargument name="TIPO" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.TIPO eq 'MENSAL'>
             select	cod_remetente, remetente, 
				    dia as dia_mes,
					dia as mes, 
					peso_total/1000 as peso_total
			   from (select distinct 
			   				cod_remetente, remetente,
							cod_destinatario,
					 		sum(peso_total) over(partition by cod_remetente, to_char(data_termino_carga,'yyyymm') order by cod_remetente, to_char(data_termino_carga,'yyyymm')) as peso_total,
							to_char(data_termino_carga,'mm/yyyy') as dia, 
							to_char(data_termino_carga,'yyyymm') as ordem
					   from (select /*+ORDERED*/rit.cod_remetente, roo.remetente, 
					                rit.cod_destinatario, 
						            roo.data_termino_carga, 
									roo.num_romaneio, 
									roo.peso_total,
									rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
							   from oper.v$romaneio roo 
							  inner join oper.v$romaneio_item rit 
								      on roo.num_romaneio = rit.num_romaneio) 
					  where rank = 1
					    and to_date(to_char(data_termino_carga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')) a
			  where cod_remetente in (select distinct kc.cod_pessoa_carga
										from oper.v$grupo_logistico_carga kc
                                         inner join kss.v$pessoa p
                              	      			 on p.cod_pessoa = kc.cod_pessoa_carga
                                         where grupo_id = #arguments.grupo_id#
                                       )
	 	      group by cod_remetente, remetente, dia, peso_total, ordem
			  order by cod_remetente,ordem
			<cfelse>
			select cod_remetente, remetente,
			       dia, 
				   mes, 
				   lpad(dia,2,'0') || '/' || lpad(mes,2,'0') as dia_mes,
				   sum(peso_total) as peso_total
			  from (select cod_remetente, remetente,
			               to_number(dia) as dia, 
						   to_number(mes) as mes, 
						   to_number(ano) as ano, 
						   peso_total/1000 as peso_total
          		      from (select distinct cod_remetente, remetente,
					               cod_destinatario,
          				           sum(peso_total) over(partition by cod_remetente, to_char(data_termino_carga,'yyyymmdd') order by cod_remetente, to_char(data_termino_carga,'yyyymmdd')) as peso_total,
          						   to_char(data_termino_carga,'dd') as dia, 
								   to_char(data_termino_carga,'mm') as mes,  
								   to_char(data_termino_carga,'yyyy') as ano, 
								   to_char(data_termino_carga,'yyyymmdd') as ordem
                              from (select /*+ORDERED*/rit.cod_remetente, roo.remetente,
							               rit.cod_destinatario, 
          					               roo.data_termino_carga, 
										   roo.num_romaneio, 
										   roo.peso_total,
										   rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
          							  from oper.v$romaneio roo 
          							 inner join oper.v$romaneio_item rit 
                                             on roo.num_romaneio = rit.num_romaneio) 
                             where rank = 1
          				       and trunc(data_termino_carga) >= trunc(sysdate-29)) a
          			 where cod_remetente in (select kc.cod_pessoa_carga
          								       from oper.v$grupo_logistico_carga kc
											  where grupo_id = #arguments.grupo_id#)
          		     group by cod_remetente, remetente,dia, mes, ano, peso_total, ordem
   				    union
                    select distinct gl2.cod_pessoa_carga as cod_remetente,remetente, 
					    extract(day from dm.data) as dia, 
						   extract(month from dm.data) as mes, 
						   extract(year from dm.data) as ano, 
						   0 
                      from (select trunc(sysdate-level) as data       
			                  from dual connect by level <= 30) dm,
    					   (select gl.cod_pessoa_carga, p.cliente as remetente
							  from oper.v$grupo_logistico_carga gl
                              inner join kss.v$pessoa p
                              	      on p.cod_pessoa = gl.cod_pessoa_carga
							 where gl.grupo_id = #arguments.grupo_id#) gl2)
    			group by cod_remetente, remetente, dia, mes, ano
   			    order by cod_remetente, ano, mes, dia
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o peso descarregado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->		
	<cffunction name="get_peso_descarga" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 'MENSAL'>
				select cod_remetente, 
				       cod_destinatario, 
					   dia as dia_mes,
					   dia as mes, 
					   '' as dia,
					   peso_total/1000 as peso_total, 
					   pj.nome_fantasia
				  from (select distinct cod_remetente, 
				               cod_destinatario,
						       sum(peso_total) over(partition by cod_remetente, cod_destinatario, to_char(data_termino_descarga,'yyyymm') order by cod_remetente, cod_destinatario, to_char(data_termino_descarga,'yyyymm')) as peso_total,
							   to_char(data_termino_descarga,'mm/yyyy') as dia, to_char(data_termino_descarga,'yyyymm') as ordem
						  from (select /*+ORDERED*/rit.cod_remetente, 
						               rit.cod_destinatario, 
							           roo.data_termino_descarga, roo.num_romaneio, roo.peso_total,
									   rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
								  from oper.v$romaneio roo 
							     inner join oper.v$romaneio_item rit 
								  	     on roo.num_romaneio = rit.num_romaneio) 
						 where rank = 1
						   and to_date(to_char(data_termino_descarga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')) a,
				       kss.v$pessoa_juridica pj      
				 where cod_remetente in (select kc.cod_pessoa_carga
				 						   from oper.v$grupo_logistico_carga kc
										  where grupo_id = #arguments.grupo_id#)
				   and pj.cod_pessoa = cod_destinatario
				   and cod_destinatario in (select kc.cod_pessoa_descarga
											  from oper.v$grupo_logistico_descarga kc
											 where grupo_id = #arguments.grupo_id#)                        
				 group by cod_remetente, cod_destinatario, pj.nome_fantasia, dia, peso_total, ordem
				 order by cod_destinatario, ordem
			 <cfelse>
                 select cod_destinatario, 
				        nome_fantasia, 
						dia, 
						mes, 
				   		lpad(dia,2,'0') || '/' || lpad(mes,2,'0') as dia_mes,
						sum(peso_total) as peso_total
		           from (select cod_destinatario, 
				                pj.nome_fantasia, 
								to_number(dia) as dia, 
								to_number(mes) as mes, 
								to_number(ano) as ano, 
								peso_total/1000 as peso_total
    		               from (select distinct cod_remetente, 
						                cod_destinatario,
										sum(peso_total) over(partition by cod_remetente, cod_destinatario, to_char(data_termino_descarga,'yyyymmdd') order by cod_remetente, cod_destinatario, to_char(data_termino_descarga,'yyyymmdd')) as peso_total,
      						            to_char(data_termino_descarga,'dd') as dia, to_char(data_termino_descarga,'mm') as mes, to_char(data_termino_descarga,'yyyy') as ano, to_char(data_termino_descarga,'yyyymmdd') as ordem
    				               from (select /*+ORDERED*/rit.cod_remetente, 
								                rit.cod_destinatario,
												roo.data_termino_descarga, 
												roo.num_romaneio, 
												roo.peso_total,
    										    rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
     							           from oper.v$romaneio roo 
    							          inner join oper.v$romaneio_item rit 
    									         on roo.num_romaneio = rit.num_romaneio) 
     					           where rank = 1
    				                 and trunc(data_termino_descarga) >= trunc(sysdate-29)) a,
    		                    kss.v$pessoa_juridica pj      
     			          where cod_remetente in (select distinct kc.cod_pessoa_carga
    								                from oper.v$grupo_logistico_carga kc
									               where grupo_id = #arguments.grupo_id#)
     		                and pj.cod_pessoa = cod_destinatario
    		                and cod_destinatario in (select distinct kc.cod_pessoa_descarga
    								                   from oper.v$grupo_logistico_descarga kc
										              where grupo_id = #arguments.grupo_id#)                        
    		              group by cod_remetente, cod_destinatario, pj.nome_fantasia, dia, mes, ano, peso_total, ordem
				union
				 select /*+ORDERED*/ gl2.cod_pessoa_descarga as cod_destinatario, 
				        pj.nome_fantasia, 
						extract(day from dm.data) as dia, 
      extract(month from dm.data) as mes, 
      extract(year from dm.data) as ano, 
						0 peso_total
				   from (select trunc(sysdate-level) as data       
		                  from dual connect by level <= 30) dm,
						(select gl.cod_pessoa_descarga 
						   from oper.v$grupo_logistico_descarga gl
						  where gl.grupo_id = #arguments.grupo_id#) gl2
				  inner join kss.v$pessoa_juridica pj
				  		  on gl2.cod_pessoa_descarga = pj.cod_pessoa
				 )
		group by cod_destinatario, nome_fantasia, dia, mes, ano
		  order by cod_destinatario, ano, mes, dia		
		  </cfif> 
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o relatorio de peso recebido pelo cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->		
	<cffunction name="get_peso_recebido" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 'MENSAL'>
			select cod_destinatario, destinatario,
				      dia as dia_mes,
			       dia as mes, 
				   peso_total/1000 as peso_total
			  from (select distinct cod_remetente, 
			               cod_destinatario, destinatario,
					             sum(peso_total) over(partition by cod_destinatario, to_char(data_termino_descarga,'yyyymm') order by cod_destinatario, to_char(data_termino_descarga,'yyyymm')) as peso_total,
						            to_char(data_termino_descarga,'mm/yyyy') as dia, to_char(data_termino_descarga,'yyyymm') as ordem
					        from (select /*+ORDERED*/rit.cod_remetente, 
					                     rit.cod_destinatario, roo.destinatario,
						                    roo.data_termino_descarga, 
								                  roo.num_romaneio, 
								                  roo.peso_total,
								                  rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
							              from oper.v$romaneio roo 
							             inner join oper.v$romaneio_item rit 
                            on roo.num_romaneio = rit.num_romaneio) 
					               where rank = 1
					                 and to_date(to_char(data_termino_descarga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')) a
  			         where cod_destinatario in (select distinct kc.cod_pessoa_carga
										                                 from oper.v$grupo_logistico_carga kc
										                                where grupo_id = #arguments.grupo_id#)
		     group by cod_destinatario, destinatario, dia, peso_total, ordem
		     order by cod_destinatario,ordem
		   <cfelse>
			select cod_destinatario,  destinatario,
			       dia, 
				      mes, 
				      lpad(dia,2,'0') || '/' || lpad(mes,2,'0') as dia_mes,
				      sum(peso_total) as peso_total
			  from (select cod_destinatario, destinatario, 
			               to_number(dia) as dia, 
						   								 to_number(mes) as mes, 
						   									to_number(ano) as ano, 
						   									peso_total/1000 as peso_total
          		      from (select distinct cod_remetente, 
					                          cod_destinatario, destinatario,
          				                 sum(peso_total) over(partition by cod_destinatario, to_char(data_termino_descarga,'yyyymmdd') order by cod_destinatario, to_char(data_termino_descarga,'yyyymmdd')) as peso_total,
          						               to_char(data_termino_descarga,'dd') as dia, 
								                       to_char(data_termino_descarga,'mm') as mes, 
								                       to_char(data_termino_descarga,'yyyy') as ano, 
								                       to_char(data_termino_descarga,'yyyymmdd') as ordem
          				            from (select /*+ORDERED*/rit.cod_remetente, 
							                                rit.cod_destinatario, roo.destinatario,
          					                        roo.data_termino_descarga, 
										                             roo.num_romaneio, 
										                             roo.peso_total,
          								                     rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
          							                 from oper.v$romaneio roo 
          							                inner join oper.v$romaneio_item rit 
          									                      on roo.num_romaneio = rit.num_romaneio) 
          					                  where rank = 1
          				                     and trunc(data_termino_descarga) >= trunc(sysdate-30)) a
          			                    where cod_destinatario in (select kc.cod_pessoa_carga
          								                                            from oper.v$grupo_logistico_carga kc
											                                                  where grupo_id = #arguments.grupo_id#)
        group by cod_destinatario, destinatario, dia, mes, ano, peso_total, ordem
   			  union
    				select distinct gl2.cod_pessoa_carga as cod_destinatario, destinatario,
					          extract(day from dm.data) as dia, extract(month from dm.data) as mes, 
               extract(year from dm.data) as ano, 0 
    				  from (select trunc(sysdate-level) as data       
							                  from dual connect by level <= 30) dm,
    				       (select gl.cod_pessoa_carga, p.cliente as destinatario
						            from oper.v$grupo_logistico_carga gl
                  inner join kss.v$pessoa p
                          on p.cod_pessoa = gl.cod_pessoa_carga
							          where gl.grupo_id = #arguments.grupo_id#) gl2)
    			 group by cod_destinatario, destinatario, dia, mes, ano
    			  order by cod_destinatario,destinatario, ano, mes, dia
			</cfif>			 
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o rank de ociosidado do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  02/02/2006
	--->		
	<cffunction name="get_rank_cliente" access="remote" returntype="query" output="true">
		<cfscript>
			qrGrupo = this.get_grupo_corrente();
		</cfscript>		
		<cfquery name="qr_rank" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select  placa_tracao, 
                             placa_reboque,
                               placa_controle, 
                               possui_rastreador, 
                               rastreador_com_problemas, 
                       veiculo_empresa, 
                               placa_referencia, 
                               cod_funcionario, 
                               com_motorista, 
                               distancia, 
                               r.referencia, 
                       landmark, 
                               latitude, 
                               longitude, 
                               num_evento, 
                               status, 
                               segundos, 
                               segundos_tempo_evento, 
                       tempo, 
                               tempo_evento, 
                               r.num_romaneio, 
                               origem, 
                               carregamento, 
                               destino, 
                               cliente, 
                               remetente, 
                       destinatario, 
                               to_char(data_evento,'dd/mm/yyyy hh24:mi:ss') as data_evento, 
                               data_evento_resumida, 
                               to_char(data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio, 
                               data_inicio_resumida, 
                               to_char(previsao_descarga,'dd/mm/yyyy hh24:mi:ss') as previsao_descarga, 
                       previsao_descarga_resumida, 
                               to_char(previsao_vazio,'dd/mm/yyyy hh24:mi:ss') as previsao_vazio, 
                               to_char(previsao_carregado,'dd/mm/yyyy hh24:mi') as previsao_carregado, 
                               cod_pessoa_atraso_carr, 
                       bloquear_previsao_carr, 
                               bloquear_previsao_vazio, 
                               peso_total, 
                               referencia_id, 
                       status_id, 
                               previsao_texto, 
                               destino_clear, 
                               temp_maxima, 
                               temp_minima,
                               notas_fiscais,
                               round(distancia_destino, 2) as distancia_destino,
                               to_char(maxdatahora + (((distancia_destino * 60 /* 1 Hora */) / 60 /* Mdia de Km/h */) / 1440), 'dd/mm/yyyy hh24:mi') as previsao_chegada,
                               case 
                                 when cr.redespacho = 0 and cr.cod_remetente = cr.cod_remetente
                                 then 'Despachando'
                                 else 'Recebendo'
                               end as tipo,
                       count(*) over(partition by case 
                                                             when cr.redespacho = 0 and cr.cod_remetente = cr.cod_remetente
                                                             then 'Despachando'
                                                             else 'Recebendo'
                                                           end,status order by case 
                                                                                  when cr.redespacho = 0 and cr.cod_remetente = cr.cod_remetente
                                                                                  then 'Despachando'
                                                                                  else 'Recebendo'
                                                                               end,status) as qtde_caminhoes
                    from (select placa_tracao, 
                                   placa_reboque, 
                                       placa_controle,
                           possui_rastreador, 
                                       rastreador_com_problemas,
                                       veiculo_empresa, 
                                       placa_referencia, 
                                       cod_funcionario,
                                       com_motorista, 
                                       distancia, 
                                       referencia, 
                                       referencia as landmark, 
                                       latitude, 
                                       longitude, 
                                       num_evento,
                                       status, 
                                       segundos, 
                                       segundos_tempo_evento, 
                                       tempo, 
                                       tempo_evento,
                                       r.num_romaneio, 
                                       origem, 
                                       carregamento, 
                                       destino, 
                                       cliente, 
                                       remetente,
                                       (case 
                                           when num_evento = 1 and destinatario is null then
                                            'Retornando com' || (select to_char(evd.valor, '000')
                                                                    from oper.v$evento_operacao_dado evd
                                                                   where evd.controle_evo_id = r.roo_evo_id
                                                                     and evd.dado_id = 14) || ' Embalagens/Paletes'
                                           else destinatario end) as destinatario,   
                                       data_evento, 
                                       data_evento_resumida, 
                                       data_inicio,
                                       data_inicio_resumida, 
                                       previsao_descarga, 
                                       previsao_descarga_resumida,
                                       previsao_vazio, 
                                       previsao_carregado, 
                                       cod_pessoa_atraso_carr,
                                       bloquear_previsao_carr, 
                                       bloquear_previsao_vazio, 
                                       peso_total, 
                                       referencia_id,   
                                       case num_evento
                                          when 100 then 1
                                          when  1  then 1
                                          when  2  then 2
                                          when  3  then 3
                                          when  4  then 4
                                          else 5 
                                       end status_id, 
                                       r.previsao_texto_descarga previsao_texto,
                                       upper(kss.pkg_string.fnc_string_clean(destino)) as destino_clear,
                                     temp_maxima_descarga temp_maxima, 
                                       temp_minima_descarga temp_minima,
                                       
                                       (select /*+ first_rows */ kss.fnc_concat_all(kss.to_concat_expr(cnt.numero,','))
                                        from fiscal.v$conhecimento c
                                        inner join fiscal.v$conhecimento_nota_fiscal cnt
                                                on cnt.conhecimento_id = c.conhecimento_id
                                        where c.num_romaneio = r.num_romaneio
                                        and rownum <= 2) as notas_fiscais,
                                       nvl((select (1 - ce.percentual_concluido) * nvl(ce.distancia_km, 0)
                                              from oper.v$cerca_eletronica ce
                                             where ce.num_romaneio = r.num_romaneio
                                               and ce.tipo_id = 1), r.distancia_destino) as distancia_destino,
                                       r.maxdatahora
                        from oper.v$controle_trafego r
                       where 1=1
                         /* and possui_rastreador = 1
                          and engatada = 1 */
                                   and num_evento in (100,1,2,3,4,5)) r
                   inner join (select r.num_romaneio, #session.cod_pessoa_usuario#  cod_pessoa, nvl(cod_remetente,#session.cod_pessoa_usuario#) as cod_remetente, nvl(redespacho,0) as redespacho
                                  from oper.v$romaneio r
                                <cfif qrGrupo.SOMENTE_VEICULOS eq 1>left<cfelse>inner</cfif> join oper.v$romaneio_item rit
                                        on rit.num_romaneio = r.num_romaneio
                                       and (rit.cod_remetente in (select cod_pessoa_carga
                                                                    from oper.v$grupo_logistico_acesso) 
                                       and rit.cod_destinatario in (select cod_pessoa_descarga
                                                                      from oper.v$grupo_logistico_acesso gl))                                          
                                where (r.num_romaneio in (select rhv.num_romaneio 
                                                              from oper.v$controle_trafego rhv 
                                                             where (rhv.placa_controle in (select glv.placa 
                                                                                             from oper.v$grupo_logistico_veiculo_user glv)
                                                                   or rhv.placa_referencia in (select glv.placa 
                                                                                                 from oper.v$grupo_logistico_veiculo_user glv))
                                                                   )
                                        )
                               ) cr
                                 on cr.num_romaneio = r.num_romaneio
                   order by case 
                                     when cr.redespacho = 0 and cr.cod_remetente = cr.cod_pessoa
                                     then 'Despachando'
                                     else 'Recebendo'
                                  end, status_id
    	</cfquery>
		<cfreturn qr_rank>		
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as Notas fiscais dos Romanios
	-- NOTAS EXPLICATIVAS
	-- Rafael Rudnik  30/07/2008
	--->	
	<cffunction name="get_notas_fiscais" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes">
    	
		<cfquery datasource="#session.dsn#" name="qr_notas" username="#session.usuario#" password="#session.senha#">
			select /*+ first_rows */ cnt.numero, cnt.data_emissao, cnt.valor_total
              from fiscal.v$conhecimento c
              inner join fiscal.v$conhecimento_nota_fiscal cnt
                      on cnt.conhecimento_id = c.conhecimento_id
            where c.num_romaneio = #arguments.num_romaneio#
            order by cnt.numero            
            
   		</cfquery>
        	
		<cfreturn qr_notas>
	</cffunction>
    			
	
	<!--- 
	-- PROPSITO 
	-- Busca as mdias de tempo de carga e descarga no periodo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  14/02/2006
	--->	
	<cffunction name="get_tempo_carga_descarga" displayname="Consulta veiculos" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="yes">
		<cfargument name="data_fim" required="yes">
		<cfargument name="grupo_id" required="no" default="">
		<cfscript>
			if(not len(trim(arguments.grupo_id))) {
				qrGrupo = this.get_grupo_corrente();
				arguments.grupo_id = qrGrupo.grupo_id;
			}
		</cfscript>
		<cfquery name="qr_rank" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ORDERED*/ distinct cod_remetente,
                     cod_destinatario,
                     oper.pkg_global.fnc_mascara_cnpj_cpf(pj.cod_pessoa) cnpj_remetente,
                     pjd.nome_fantasia destinatario,
                     pdd.municipio destinatario_mun,
                     pj.nome_fantasia remetente,
                     pd.municipio || '-' || pd.uf municipio,
                     oper.pkg_global.fnc_tempo_formatado(media_tempo_carga) media_tempo_carga,
                     oper.pkg_global.fnc_tempo_formatado(media_tempo_descarga) media_tempo_descarga,
                     media_tempo_carga as media_tempo_carga_seg,
                     media_tempo_descarga as media_tempo_descarga_seg,
                     qtde_viagem,
                     qtde_viagem_dest
			   from (select distinct cod_remetente,  cod_destinatario,
                   sum(tempo_carga) over (partition by cod_remetente order by cod_remetente) tempo_carga, 
                   sum(tempo_descarga) over (partition by cod_destinatario order by cod_remetente, cod_destinatario) tempo_descarga, 
                   avg(tempo_carga) over (partition by cod_remetente order by cod_remetente)  media_tempo_carga, 
                   avg(tempo_descarga) over (partition by cod_destinatario order by cod_remetente, cod_destinatario)  media_tempo_descarga, 
                   count(distinct num_romaneio) over (partition by cod_remetente) as qtde_viagem,
                   count(distinct num_romaneio) over (partition by cod_destinatario) as qtde_viagem_dest 
         from (select /*+ORDERED*/rit.cod_remetente, rit.cod_destinatario, rc.termino_carga as data_termino_carga, roo.num_romaneio, 
                                case when rc.termino_carga < rc.inicio_carga_fabrica then 0
								     when rc.inicio_carga_fabrica is not null and rc.termino_carga is not null then 
                                         (rc.termino_carga - rc.inicio_carga_fabrica)*60*60*24 
                                else null end tempo_carga, 
                                case when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
								     when rd.inicio_descarga_fabrica is not null and rd.termino_descarga is not null then 
                                         (rd.termino_descarga - rd.inicio_descarga_fabrica)*60*60*24 
                                else null end tempo_descarga, 
                                rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
                      from oper.v$romaneio roo 
                     inner join oper.v$romaneio_item rit 
                                  on roo.num_romaneio = rit.num_romaneio
					 inner join oper.v$romaneio_carga rc
					         on rc.num_romaneio = rit.num_romaneio
							and rc.item_id = rit.item_id
					 left join oper.v$romaneio_descarga rd
					         on rd.num_romaneio = rit.num_romaneio
							and rd.item_id = rit.item_id) 
            where rank = 1
		  				and trunc(data_termino_carga) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy') 
            ), 
					kss.v$pessoa_juridica pj
          inner join kss.v$pessoa_endereco_padrao pd
                  on pd.cod_pessoa = pj.cod_pessoa,
					kss.pessoa_juridica pjd
          inner join kss.v$pessoa_endereco_padrao pdd
                  on pdd.cod_pessoa = pjd.cod_pessoa
			  where pj.cod_pessoa = cod_remetente  
          and pjd.cod_pessoa = cod_destinatario
		  and pjd.cod_pessoa in (select cod_pessoa_descarga
		                           from oper.v$grupo_logistico_descarga 
								  where grupo_id = #arguments.grupo_id#)
		  and pj.cod_pessoa in (select cod_pessoa_carga
		                          from oper.v$grupo_logistico_carga 
								 where grupo_id = #arguments.grupo_id#)    	
		</cfquery>
		<cfreturn qr_rank>		
	</cffunction>		


	<!--- 
	-- PROPSITO 
	-- Busca o tempo de Carga
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->		
	<cffunction name="get_tempo_carga" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="yes">
		<cfargument name="tipo" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 'MENSAL'>
				select cod_remetente,
       				   remetente,
					   mes, 
					   tempo_carga
				  from (select distinct cod_remetente, 
                       remetente,
				               cod_destinatario,
							   oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy') order by cod_remetente))  media_tempo_carga, 
							   round((avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy') order by cod_remetente))/3600,1) tempo_carga, 
							   count(distinct num_romaneio) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy')) as qtde_viagem,
							   to_char(data_termino_carga,'mm/yyyy') as mes, to_char(data_termino_carga,'yyyymm') as ordem
						  from (select /*+ORDERED*/rit.cod_remetente, 
                           roo.REMETENTE,
						               rit.cod_destinatario, 
									   roo.data_termino_carga, 
									   roo.num_romaneio, 
									   case 
									     when rc.termino_carga < rc.inicio_carga_fabrica then 0
										 when rc.inicio_carga_fabrica is not null and rc.termino_carga is not null then (rc.termino_carga - rc.inicio_carga_fabrica)*60*60*24 
										 else null 
									   end tempo_carga, 
									   rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
								  from oper.v$romaneio roo 
							     inner join oper.v$romaneio_item rit 
										 on roo.num_romaneio = rit.num_romaneio
								 inner join oper.v$romaneio_carga rc
										 on rc.num_romaneio = rit.num_romaneio
										and rc.item_id = rit.item_id) 
						 where rank = 1
						   and to_date(to_char(data_termino_carga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')) a
				 where a.cod_remetente in (select cod_pessoa_carga
											 from oper.v$grupo_logistico_carga
                       inner join kss.v$pessoa p on p.cod_pessoa = cod_pessoa_carga
										    where grupo_id = #arguments.grupo_id#)
				 group by cod_remetente,remetente, mes, tempo_carga, ordem
				 order by cod_remetente,remetente,ordem
             <cfelse>   
				select cod_remetente,
                   		remetente,
                         dia, 
                         mes, 
                         sum(tempo_carga) as tempo_carga
                      from (select cod_remetente,  remetente,
                                   to_number(dia) as dia, 
                             to_number(mes) as mes, 
                             to_number(ano) as ano, 
                             tempo_carga
                          from (select /*+ORDERED*/ distinct cod_remetente, remetente,
                                       cod_destinatario,
                                 oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'dd/mm') order by cod_remetente))  media_tempo_carga, 
                                 round((avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'dd/mm') order by cod_remetente))/3600,1) tempo_carga, 
                                 count(distinct num_romaneio) over (partition by cod_remetente, to_char(data_termino_carga,'dd/mm')) as qtde_viagem,
                                 to_char(data_termino_carga,'dd') as dia, to_char(data_termino_carga,'mm') as mes, to_char(data_termino_carga,'yyyy') as ano, to_char(data_termino_carga,'yyyymmdd') as ordem
                              from (select rit.cod_remetente, 
                                           roo.REMETENTE,
                                           rit.cod_destinatario, 
                                     roo.data_termino_carga, 
                                     roo.num_romaneio,
                                     case 
                                       when rc.termino_carga < rc.inicio_carga_fabrica then 0
                                     when rc.inicio_carga_fabrica is not null and rc.termino_carga is not null then (rc.termino_carga - rc.inicio_carga_fabrica)*60*60*24
                                     else null 
                                     end tempo_carga, 
                                     rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
                                  from oper.v$romaneio roo 
                                 inner join oper.v$romaneio_item rit 
                                         on roo.num_romaneio = rit.num_romaneio
                                         inner join oper.v$romaneio_carga rc
                                           on rc.num_romaneio = rit.num_romaneio
                                          and rc.item_id = rit.item_id) 
                                 where rank = 1
                                   and trunc(data_termino_carga) >= trunc(sysdate-30)) a
                             where cod_remetente in (select cod_pessoa_carga
                                           from oper.v$grupo_logistico_carga
                                           inner join kss.v$pessoa p on p.cod_pessoa = cod_pessoa_carga
                                          where grupo_id = #arguments.grupo_id#)
                                group by cod_remetente,remetente, dia, mes, ano, tempo_carga, ordem
                              union
                            select /*+ORDERED*/ distinct gl2.cod_pessoa_carga as cod_remetente, 
                                  remetente,
                                  extract(day from dm.data) as dia, extract(month from dm.data) as mes, 
																			               extract(year from dm.data) as ano,
                                 0 
                              from (select trunc(sysdate-level) as data       
					                 from dual connect by level <= 30) dm,
                                 (select gl.cod_pessoa_carga, p.cliente as remetente
                              from oper.v$grupo_logistico_carga gl
                             inner join kss.v$pessoa p on p.cod_pessoa = gl.cod_pessoa_carga
                             where gl.grupo_id = #arguments.grupo_id#) gl2)
                      group by cod_remetente, remetente, dia, mes, ano             
                        order by cod_remetente, remetente, ano, mes, dia				   
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	<!--- 
	-- PROPSITO 
	-- Busca o tempo parado de carga
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->		
	<cffunction name="get_tempo_carga_parado" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select remetente, cod_remetente, mes, tempo_carga
			  from (select distinct cod_remetente, remetente, cod_destinatario,
							   oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy') order by cod_remetente))  media_tempo_carga, 
							   round((avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy') order by cod_remetente))/3600,1) tempo_carga, 
							   count(distinct num_romaneio) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy')) as qtde_viagem,
							   to_char(data_termino_carga,'mm/yyyy') as mes, to_char(data_termino_carga,'yyyymm') as ordem
					 from (select /*+ORDERED*/rit.cod_remetente, roo.remetente, rit.cod_destinatario, roo.data_termino_carga, roo.num_romaneio, 
											case when roo.data_inicio_carga is not null and roo.data_termino_carga is not null then 
													 (roo.data_termino_carga - roo.data_inicio_carga)*60*60*24 
											else null end tempo_carga, 
											case when roo.data_inicio_descarga is not null and roo.data_termino_descarga is not null then 
													 (roo.data_termino_descarga - roo.data_inicio_descarga)*60*60*24 
											else null end tempo_descarga, 
											rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
								  from oper.v$romaneio roo 
								 inner join oper.v$romaneio_item rit 
											  on roo.num_romaneio = rit.num_romaneio) 
						where rank = 1
					and to_date(to_char(data_termino_carga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')) a
				where a.cod_remetente in (select cod_pessoa_carga
											from oper.v$grupo_logistico_carga
										   where grupo_id = #arguments.grupo_id#)
			   group by cod_remetente,remetente, mes, tempo_carga, ordem
			   order by cod_remetente, ordem
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o tempo de descarga do Cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->		
	<cffunction name="get_tempo_descarga" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 'MENSAL'>
				select cod_destinatario, oper.pkg_global.fnc_busca_nome_pessoa(cod_remetente) as remetente,
               pj.nome_fantasia, 
             mes, 
             tempo_descarga
          from (select distinct cod_remetente, 
                       cod_destinatario,
                 round((avg(tempo_descarga) over (partition by cod_remetente, cod_destinatario, to_char(data_termino_descarga,'mm/yyyy') order by cod_remetente, cod_destinatario))/3600,1) tempo_descarga, 
                 to_char(data_termino_descarga,'mm/yyyy') as mes, to_char(data_termino_descarga,'yyyymm') as ordem
              from (select /*+ORDERED*/rit.cod_remetente, 
                           rit.cod_destinatario, 
                     roo.data_termino_descarga, 
                     roo.num_romaneio, 
                     case 
                       when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
                     when rd.inicio_descarga_fabrica is not null and rd.termino_descarga is not null then (rd.termino_descarga - rd.inicio_descarga_fabrica)*60*60*24 
                     else null 
                     end tempo_descarga, 
                     rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
                  from oper.v$romaneio roo 
                   inner join oper.v$romaneio_item rit 
                     on roo.num_romaneio = rit.num_romaneio
                 inner join oper.v$romaneio_descarga rd
                     on rd.num_romaneio = rit.num_romaneio
                    and rd.item_id = rit.item_id) 
             where rank = 1
               and to_date(to_char(data_termino_descarga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')) a,
               kss.v$pessoa_juridica pj        
         where pj.cod_pessoa = a.cod_destinatario
           and cod_remetente in (select cod_pessoa_carga
                       from oper.v$grupo_logistico_carga
                      where grupo_id = #arguments.grupo_id#)
           and a.cod_destinatario in (select cod_pessoa_descarga
                        from oper.v$grupo_logistico_descarga 
                         where grupo_id = #arguments.grupo_id#)    
         group by cod_destinatario, cod_remetente, pj.nome_fantasia, mes, tempo_descarga, ordem
         order by cod_destinatario,cod_remetente, ordem
			<cfelse>  
				select cod_destinatario, 
                     nome_fantasia, 
                   dia, 
                   sum(tempo_descarga) as tempo_descarga
                  from (select cod_destinatario, 
                       pj.nome_fantasia, 
                 to_number(dia) as dia, 
                 to_number(mes) as mes, 
                  tempo_descarga
              from (select /*+ORDERED*/ distinct cod_remetente, 
                           cod_destinatario,
                     round((avg(tempo_descarga) over (partition by cod_remetente, cod_destinatario, to_char(data_termino_descarga,'dd/mm') order by cod_remetente, cod_destinatario))/3600,1) tempo_descarga, 
                     to_char(data_termino_descarga,'dd') as dia, 
                     to_char(data_termino_descarga,'mm') as mes, 
                     
                     to_char(data_termino_descarga,'mmdd') as ordem
                  from (select rit.cod_remetente, 
                               rit.cod_destinatario, 
                         roo.data_termino_descarga, 
                         roo.num_romaneio, 
                         case 
                           when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
                               when rd.inicio_descarga_fabrica is not null and rd.termino_descarga is not null then (rd.termino_descarga - rd.inicio_descarga_fabrica)*60*60*24 
                         else null 
                         end tempo_descarga, 
                         rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
                      from oper.v$romaneio roo 
                       inner join oper.v$romaneio_item rit 
                             on roo.num_romaneio = rit.num_romaneio
                   inner join oper.v$romaneio_descarga rd
                         on rd.num_romaneio = rit.num_romaneio
                      and rd.item_id = rit.item_id) 
                 where rank = 1
                   and trunc(data_termino_descarga) >= trunc(sysdate-29)) a,
                 kss.v$pessoa_juridica pj        
              where pj.cod_pessoa = a.cod_destinatario
               and cod_remetente in (select cod_pessoa_carga
                           from oper.v$grupo_logistico_carga
                          where grupo_id = #arguments.grupo_id#)
               and a.cod_destinatario in (select cod_pessoa_descarga
                            from oper.v$grupo_logistico_descarga
                             where grupo_id = #arguments.grupo_id#)    
             group by cod_destinatario, pj.nome_fantasia, dia, mes, tempo_descarga, ordem
             union
            select /*+ORDERED*/ gl.cod_pessoa_descarga as cod_destinatario, 
                   pj.nome_fantasia, 
                   extract(day from dm.data) as dia, extract(month from dm.data) as mes, 
                   0 tempo_descarga
              from (select trunc(sysdate-level) as data       
			                 from dual connect by level <= 30) dm,
                 (select gl2.cod_pessoa_descarga 
                  from oper.v$grupo_logistico_descarga gl2
                 where gl2.grupo_id = #arguments.grupo_id#) gl
             inner join kss.v$pessoa_juridica pj
                 on gl.cod_pessoa_descarga = pj.cod_pessoa)
        group by cod_destinatario, nome_fantasia, dia             
          order by cod_destinatario,dia
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o tempo de descarga parado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->		
	<cffunction name="get_tempo_descarga_parado" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 'MENSAL'>
				select cod_destinatario,
                           remetente,
                           pj.nome_fantasia,
                           mes,
                           tempo_descarga
                      from (select distinct cod_remetente,
                                            remetente,
                                            cod_destinatario,
                                            round((avg(tempo_descarga)
                                                   over(partition by cod_remetente,
                                                        remetente,
                                                        cod_destinatario,
                                                        to_char(data_termino_descarga, 'mm/yyyy')
                                                        order by cod_remetente,remetente,
                                                        cod_destinatario)) / 3600,
                                                  1) tempo_descarga,
                                            to_char(data_termino_descarga, 'mm/yyyy') as mes,
                                            to_char(data_termino_descarga, 'yyyymm') as ordem
                              from (select /*+ORDERED*/
                                     rit.cod_remetente,
                                     rit.cod_destinatario,
                                     roo.REMETENTE,
                                     roo.data_termino_descarga,
                                     roo.num_romaneio,
                                     case
                                       when roo.data_inicio_carga is not null and
                                            roo.data_termino_carga is not null then
                                        (roo.data_termino_carga - roo.data_inicio_carga) * 60 * 60 * 24
                                       else
                                        null
                                     end tempo_carga,
                                     case
                                       when roo.data_inicio_descarga is not null and
                                            roo.data_termino_descarga is not null then
                                        (roo.data_termino_descarga - roo.data_inicio_descarga) * 60 * 60 * 24
                                       else
                                        null
                                     end tempo_descarga,
                                     rank() over(partition by roo.num_romaneio order by rit.item_id) rank
                                      from oper.v$romaneio roo
                                     inner join oper.v$romaneio_item rit on roo.num_romaneio =
                                                                            rit.num_romaneio)
                             where rank = 1
                               and to_date(to_char(data_termino_descarga, 'mm/yyyy'), 'mm/yyyy') >=
                                   to_date(to_char(add_months(sysdate, -6), 'mm/yyyy'),
                                           'mm/yyyy')) a,
                           kss.v$pessoa_juridica pj
                     where pj.cod_pessoa = a.cod_destinatario
                       and cod_remetente in
                           (select cod_pessoa_carga
                              from oper.v$grupo_logistico_carga
                              inner join kss.v$pessoa p on p.cod_pessoa = cod_pessoa_carga
                             where grupo_id = #arguments.grupo_id#)
                       and a.cod_destinatario in
                           (select cod_pessoa_descarga
                              from oper.v$grupo_logistico_descarga
                              inner join kss.v$pessoa p on p.cod_pessoa = cod_pessoa_descarga
                             where grupo_id = #arguments.grupo_id#)
                     group by cod_destinatario,remetente, pj.nome_fantasia, mes, tempo_descarga, ordem
                     order by cod_destinatario,remetente, ordem
			<cfelse>
				select cod_destinatario, 
					   nome_fantasia, 
					   dia, 
					   mes, 
					   sum(tempo_descarga) as tempo_descarga,
					   count(*) over(partition by cod_destinatario order by cod_destinatario) as qtde_dias
				  from (select cod_destinatario, 
				               pj.nome_fantasia, 
							   to_number(dia) as dia, 
							   to_number(mes) as mes, 
							   to_number(ano) as ano, 
							   tempo_descarga
						  from (select /*+ORDERED*/ distinct cod_remetente, 
						               cod_destinatario,
									   round((avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_descarga,'dd/mm') order by cod_remetente))/3600,1) tempo_carga, 
									   round((avg(tempo_descarga) over (partition by cod_remetente, cod_destinatario, to_char(data_termino_descarga,'dd/mm') order by cod_remetente, cod_destinatario))/3600,1) tempo_descarga,
									   to_char(data_termino_descarga,'dd') as dia, to_char(data_termino_descarga,'mm') as mes, to_char(data_termino_descarga,'yyyy') as ano, 
									   to_char(data_termino_descarga,'yyyymmdd') as ordem
								  from (select rit.cod_remetente, 
								               rit.cod_destinatario, 
											   roo.data_termino_descarga, 
											   roo.num_romaneio, 
											   case 
											     when roo.data_inicio_carga is not null and roo.data_termino_carga is not null then (roo.data_termino_carga - roo.data_inicio_carga)*60*60*24 
												 else null 
											   end tempo_carga, 
										       case 
											     when roo.data_inicio_descarga is not null and roo.data_termino_descarga is not null then (roo.data_termino_descarga - roo.data_inicio_descarga)*60*60*24 
												 else null 
											   end tempo_descarga, 
											   rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
										  from oper.v$romaneio roo 
										 inner join oper.v$romaneio_item rit 
										         on roo.num_romaneio = rit.num_romaneio) 
								 where rank = 1
								   and trunc(data_termino_descarga) >= trunc(sysdate-30)) a,
							   kss.v$pessoa_juridica pj        
					 	 where pj.cod_pessoa = a.cod_destinatario
						   and cod_remetente in (select cod_pessoa_carga
												   from oper.v$grupo_logistico_carga
												  where grupo_id = #arguments.grupo_id#)
						   and a.cod_destinatario in (select cod_pessoa_descarga
													    from oper.v$grupo_logistico_descarga
													   where grupo_id = #arguments.grupo_id#)		
						 group by cod_destinatario, pj.nome_fantasia, dia, mes, ano, tempo_descarga, ordem
					   union
						select /*+ORDERED*/ gl.cod_pessoa_descarga as cod_destinatario, 
						       pj.nome_fantasia, 
							   extract(day from dm.data) as dia, extract(month from dm.data) as mes, extract(year from dm.data) as ano,
							   0 tempo_descarga
						  from (select trunc(sysdate-level) as data       
			                 from dual connect by level <= 30) dm,
							   (select gl2.cod_pessoa_descarga 
								  from oper.v$grupo_logistico_descarga gl2
								 where gl2.grupo_id = #arguments.grupo_id#) gl
						 inner join kss.v$pessoa_juridica pj
								 on gl.cod_pessoa_descarga = pj.cod_pessoa)
  					     group by cod_destinatario, nome_fantasia, dia, mes, ano
					     order by cod_destinatario, ano, mes, dia
			</cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>			  

	<!--- 
	-- PROPSITO 
	-- Busca o tempo parado
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->		
	<cffunction name="get_tempo_parado" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_remetente,
       			   remetente,
                   dia,
                   mes,
                   ano,
                   sum(tempo_carga) as tempo_carga
                      from (select cod_remetente,
                                   remetente,
                                   to_number(dia) as dia,
                                   to_number(mes) as mes,
                                   to_number(ano) as ano,
                                   tempo_carga
                              from (select /*+ORDERED*/
                                    distinct cod_remetente,
                                             remetente,
                                             cod_destinatario,
                                             oper.pkg_global.fnc_tempo_formatado(avg(tempo_carga)
                                                                                 over(partition by
                                                                                      cod_remetente,remetente,
                                                                                      to_char(data_termino_carga,
                                                                                              'dd/mm')
                                                                                      order by
                                                                                      cod_remetente,remetente)) media_tempo_carga,
                                             round((avg(tempo_carga)
                                                    over(partition by cod_remetente,remetente,
                                                         to_char(data_termino_carga, 'dd/mm') order by
                                                         cod_remetente,remetente)) / 3600,
                                                   1) tempo_carga,
                                             count(distinct num_romaneio) over(partition by cod_remetente,remetente, to_char(data_termino_carga, 'dd/mm')) as qtde_viagem,
                                             to_char(data_termino_carga, 'dd') as dia,
                                             to_char(data_termino_carga, 'mm') as mes,
                                             to_char(data_termino_carga, 'yyyy') as ano,
                                             to_char(data_termino_carga, 'yyyymmdd') as ordem
                                      from (select rit.cod_remetente,
                                                   roo.remetente,
                                                   rit.cod_destinatario,
                                                   roo.data_termino_carga,
                                                   roo.num_romaneio,
                                                   case
                                                     when roo.data_inicio_carga is not null and
                                                          roo.data_termino_carga is not null then
                                                      (roo.data_termino_carga -
                                                      roo.data_inicio_carga) * 60 * 60 * 24
                                                     else
                                                      null
                                                   end tempo_carga,
                                                   case
                                                     when roo.data_inicio_descarga is not null and
                                                          roo.data_termino_descarga is not null then
                                                      (roo.data_termino_descarga -
                                                      roo.data_inicio_descarga) * 60 * 60 * 24
                                                     else
                                                      null
                                                   end tempo_descarga,
                                                   rank() over(partition by roo.num_romaneio order by rit.item_id) rank
                                              from oper.v$romaneio roo
                                             inner join oper.v$romaneio_item rit on roo.num_romaneio =
                                                                                    rit.num_romaneio)
                                     where rank = 1
                                       and trunc(data_termino_carga) >= trunc(sysdate - 30)) a
                             where cod_remetente in (select lc.cod_pessoa_carga
                                                       from oper.v$grupo_logistico_carga lc
                                                       inner join kss.v$pessoa p on p.cod_pessoa = lc.cod_pessoa_carga
                                                      where grupo_id = #arguments.grupo_id#)
                             group by cod_remetente,remetente, dia, mes, ano, tempo_carga, ordem
                              union
                                        select distinct gl2.cod_pessoa_carga as cod_remetente,remetente, 
                                     extract(day from dm.data) as dia, 
                                   extract(month from dm.data) as mes, 
                                   extract(year from dm.data) as ano, 
                                   0 
                                          from (select trunc(sysdate-level) as data       
								                 from dual connect by level <= 30) dm,
                                     (select gl.cod_pessoa_carga, p.cliente as remetente
                                    from oper.v$grupo_logistico_carga gl
                                                  inner join kss.v$pessoa p
                                                          on p.cod_pessoa = gl.cod_pessoa_carga
                                   where gl.grupo_id = #arguments.grupo_id#) gl2
                                 )
                              group by cod_remetente, remetente, dia, mes, ano
                                 order by cod_remetente, ano, mes, dia
                            </cfquery>
		<cfreturn qr_result>		
	</cffunction>				  
		  
	<!--- 
	-- PROPSITO 
	-- Busca o tempo total do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->		
	<cffunction name="get_tempo_total" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 'MENSAL'> 
            select cod_remetente, cnpj_remetente, remetente, municipio, mes, avg(tempo_total) as tempo_total
			from (select /*+ORDERED*/cod_remetente, 
					oper.pkg_global.fnc_mascara_cnpj_cpf(pj.cod_pessoa) cnpj_remetente, 
					pj.nome_fantasia remetente, 
					peg.municipio ||'-'||peg.uf municipio, 
					round((tempo_carga+tempo_descarga)/3600,1) as tempo_total, 
					mes, ordem          
				   from (select distinct cod_remetente, to_char(data_termino_carga,'mm/yyyy') as mes, to_char(data_termino_carga,'yyyymm') as ordem,
					   avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy') order by cod_remetente)  tempo_carga, 
					   avg(tempo_descarga) over (partition by cod_remetente, to_char(data_termino_descarga,'mm/yyyy') order by cod_remetente) tempo_descarga
			 from (select /*+ORDERED*/rit.cod_remetente, rit.cod_destinatario, roo.data_termino_carga, roo.data_termino_descarga, roo.num_romaneio, 
									case when rc.termino_carga < rc.inicio_carga_fabrica then 0
						 when rc.inicio_carga_fabrica is not null and rc.termino_carga is not null then 
											 (rc.termino_carga - rc.inicio_carga_fabrica)*60*60*24 
									else 0 end tempo_carga, 
									case when rd.termino_descarga < rd.inicio_descarga_fabrica then 0
						 when rd.inicio_descarga_fabrica is not null and rd.termino_descarga is not null then 
											 (rd.termino_descarga - rd.inicio_descarga_fabrica)*60*60*24 
									else 0 end tempo_descarga, 
									rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
						  from oper.v$romaneio roo 
						 inner join oper.v$romaneio_item rit 
									  on roo.num_romaneio = rit.num_romaneio
			   inner join oper.v$romaneio_carga rc
					   on rc.num_romaneio = rit.num_romaneio
					  and rc.item_id = rit.item_id
			   inner join oper.v$romaneio_descarga rd
					   on rd.num_romaneio = rit.num_romaneio
					  and rd.item_id = rit.item_id) 
				where rank = 1
				  and to_date(to_char(data_termino_carga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')
				), 
						kss.v$pessoa_juridica pj
                         inner join kss.v$pessoa_endereco_padrao peg
                                 on peg.cod_pessoa = pj.cod_pessoa
				  where pj.cod_pessoa = cod_remetente
					and cod_remetente in (select cod_pessoa_carga
											from oper.v$grupo_logistico_carga
										   where grupo_id = #arguments.grupo_id#)
				  order by ordem)
			group by cod_remetente, cnpj_remetente, remetente, municipio, ordem, mes
    	<cfelse>        
          select cod_remetente, cnpj_remetente, remetente, municipio,
                 dia, mes, ano, sum(tempo_total) as tempo_total
            from 
                  (select cod_remetente,
                         cnpj_remetente,
                         remetente,
                         municipio,
                         dia, mes, ano,
                         avg(tempo_total) as tempo_total
                                from (select /*+ORDERED*/
                                       cod_remetente,
                                       oper.pkg_global.fnc_mascara_cnpj_cpf(pj.cod_pessoa) cnpj_remetente,
                                       pj.nome_fantasia remetente,
                                       pep.municipio || '-' || pep.uf municipio,
                                       round((tempo_carga + tempo_descarga) / 3600, 1) as tempo_total,
                                       dia, mes, ano,
                                       ordem
                                        from (select distinct cod_remetente,
                                                              extract(day from data_termino_carga) as dia,
                                                              extract(month from data_termino_carga) as mes,
                                                              extract(year from data_termino_carga) as ano,
                                                              to_char(data_termino_carga, 'yyyymmdd') as ordem,
                                                              avg(tempo_carga) over(partition by cod_remetente, to_char(data_termino_carga, 'dd/mm/yyyy') order by cod_remetente) tempo_carga,
                                                              avg(tempo_descarga) over(partition by cod_remetente, to_char(data_termino_descarga, 'dd/mm/yyyy') order by cod_remetente) tempo_descarga
                                                from (select /*+ORDERED*/
                                                       rit.cod_remetente,
                                                       rit.cod_destinatario,
                                                       roo.data_termino_carga,
                                                       roo.data_termino_descarga,
                                                       roo.num_romaneio,
                                                       case
                                                         when rc.termino_carga < rc.inicio_carga_fabrica then
                                                          0
                                                         when rc.inicio_carga_fabrica is not null and
                                                              rc.termino_carga is not null then
                                                          (rc.termino_carga - rc.inicio_carga_fabrica) * 60 * 60 * 24
                                                         else
                                                          0
                                                       end tempo_carga,
                                                       case
                                                         when rd.termino_descarga < rd.inicio_descarga_fabrica then
                                                          0
                                                         when rd.inicio_descarga_fabrica is not null and
                                                              rd.termino_descarga is not null then
                                                          (rd.termino_descarga - rd.inicio_descarga_fabrica) * 60 * 60 * 24
                                                         else
                                                          0
                                                       end tempo_descarga,
                                                       rank() over(partition by roo.num_romaneio order by rit.item_id) rank
                                                        from oper.v$romaneio roo
                                                       inner join oper.v$romaneio_item rit on roo.num_romaneio =
                                                                                              rit.num_romaneio
                                                       inner join oper.v$romaneio_carga rc on rc.num_romaneio =
                                                                                              rit.num_romaneio
                                                                                          and rc.item_id =
                                                                                              rit.item_id
                                                       inner join oper.v$romaneio_descarga rd on rd.num_romaneio =
                                                                                                 rit.num_romaneio
                                                                                             and rd.item_id =
                                                                                                 rit.item_id)
                                               where rank = 1
                               and trunc(data_termino_carga) >= trunc(sysdate-30)),
                                             kss.v$pessoa_juridica pj
                                       inner join kss.v$pessoa_endereco_padrao pep
                                              on pep.cod_pessoa = pj.cod_pessoa
                                       where pj.cod_pessoa = cod_remetente
                          
                                         and cod_remetente in
                                             (select cod_pessoa_carga
                                                from oper.v$grupo_logistico_carga
                                               where grupo_id = #arguments.grupo_id#)
                                       order by ordem, dia)														
                               group by cod_remetente, cnpj_remetente, remetente, municipio, ordem, dia, mes, ano
                union
                select /*+ORDERED*/
                    distinct gl2.cod_pessoa_carga as cod_remetente,
                             cnpj, 
                         remetente,municipio,
                         extract(day from dm.data) as dia,
                         extract(month from dm.data) as mes,
                         extract(year from dm.data) as ano,
                         0
                     from (select trunc(sysdate-level) as data       
			                 from dual connect by level <= 30) dm,
                        (select gl.cod_pessoa_carga, 
                                p.nome_fantasia as remetente, 
                            oper.pkg_global.fnc_mascara_cnpj_cpf(p.cod_pessoa) as cnpj,
                            peg.municipio || '-' || peg.uf as municipio
                         from oper.v$grupo_logistico_carga gl
                         inner join kss.v$pessoa_juridica p 
                                 on p.cod_pessoa = gl.cod_pessoa_carga
                         inner join kss.v$pessoa_endereco_padrao peg
                                 on peg.cod_pessoa = p.cod_pessoa                         
                         where gl.grupo_id = #arguments.grupo_id#) gl2
             )
          group by cod_remetente, cnpj_remetente, remetente, municipio,
                   dia, mes, ano	 
          order by cod_remetente, ano, mes, dia				 
		</cfif>
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca o tempo total parado do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->		
	<cffunction name="get_tempo_total_parado" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 'MENSAL'>
				select cod_remetente, cnpj_remetente, remetente, municipio, mes, avg(tempo_total) as tempo_total
				from (select /*+ORDERED*/cod_remetente, 
								oper.pkg_global.fnc_mascara_cnpj_cpf(pj.cod_pessoa) cnpj_remetente, 
								pj.nome_fantasia remetente, 
								pep.municipio ||'-'||pep.uf municipio, 
								round((tempo_carga+tempo_descarga)/3600,1) as tempo_total, 
								mes, ordem
							   from (select distinct cod_remetente, to_char(data_termino_carga,'mm/yyyy') as mes, to_char(data_termino_carga,'yyyymm') as ordem,
								   avg(tempo_carga) over (partition by cod_remetente, to_char(data_termino_carga,'mm/yyyy') order by cod_remetente)  tempo_carga, 
								   avg(tempo_descarga) over (partition by cod_remetente, to_char(data_termino_descarga,'mm/yyyy') order by cod_remetente) tempo_descarga
						 from (select /*+ORDERED*/rit.cod_remetente, rit.cod_destinatario, roo.data_termino_carga, roo.data_termino_descarga, roo.num_romaneio, 
												case when roo.data_inicio_carga is not null and roo.data_termino_carga is not null then 
														 (roo.data_termino_carga - roo.data_inicio_carga)*60*60*24 
												else 0 end tempo_carga, 
												case when roo.data_inicio_descarga is not null and roo.data_termino_descarga is not null then 
														 (roo.data_termino_descarga - roo.data_inicio_descarga)*60*60*24 
												else 0 end tempo_descarga, 
												rank() over (partition by roo.num_romaneio order by rit.item_id) rank 
									  from oper.v$romaneio roo 
									 inner join oper.v$romaneio_item rit 
												  on roo.num_romaneio = rit.num_romaneio) 
							where rank = 1
							  and to_date(to_char(data_termino_carga,'mm/yyyy'),'mm/yyyy') >= to_date(to_char(add_months(sysdate,-6),'mm/yyyy'),'mm/yyyy')
							), 
									kss.v$pessoa_juridica pj
                                     inner join kss.v$pessoa_endereco_padrao pep 
                                             on pep.cod_pessoa = pj.cod_pessoa
							  where pj.cod_pessoa = cod_remetente
								and cod_remetente in (select cod_pessoa_carga
														from oper.v$grupo_logistico_carga
													   where grupo_id = #arguments.grupo_id#)
							  order by ordem)
				group by cod_remetente, cnpj_remetente, remetente, municipio, ordem, mes	
                order by ordem
			<cfelse>
                   select cod_remetente,
                         remetente,
                         nome_fantasia,
                         dia,
                         sum(tempo_carga) as tempo_carga,
                         count(*) over(partition by cod_remetente order by cod_remetente) as qtde_dias
                              from (select cod_remetente,
                                           remetente,
                                           pj.nome_fantasia,
                                           to_number(dia) as dia,
                                           to_number(mes) as mes,
                                           to_number(ano) as ano,
                                           tempo_carga
                                      from (select /*+ORDERED*/
                                            distinct cod_remetente,
                                                     remetente,
                                                     cod_destinatario,
                                                     round((avg(tempo_carga)
                                                            over(partition by cod_remetente,
                                                                 to_char(data_termino_carga, 'dd/mm') order by
                                                                 cod_remetente)) / 3600,
                                                           1) tempo_carga,
                                                     round((avg(tempo_descarga)
                                                            over(partition by cod_remetente,
                                                                 cod_destinatario,
                                                                 to_char(data_termino_carga, 'dd/mm') order by
                                                                 cod_remetente,
                                                                 cod_destinatario)) / 3600,
                                                           1) tempo_descarga,
                                                     to_char(data_termino_carga, 'dd') as dia,
                                                     to_char(data_termino_carga, 'mm') as mes,
                                                     to_char(data_termino_carga, 'yyyy') as ano,
                                                     to_char(data_termino_carga, 'yyyymmdd') as ordem
                                              from (select rit.cod_remetente,
                                                           roo.REMETENTE,
                                                           rit.cod_destinatario,
                                                           roo.data_termino_carga,
                                                           roo.num_romaneio,
                                                           case
                                                             when roo.data_inicio_carga is not null and
                                                                  roo.data_termino_carga is not null then
                                                              (roo.data_termino_carga -
                                                              roo.data_inicio_carga) * 60 * 60 * 24
                                                             else
                                                              null
                                                           end tempo_carga,
                                                           case
                                                             when roo.data_inicio_descarga is not null and
                                                                  roo.data_termino_descarga is not null then
                                                              (roo.data_termino_descarga -
                                                              roo.data_inicio_descarga) * 60 * 60 * 24
                                                             else
                                                              null
                                                           end tempo_descarga,
                                                           rank() over(partition by roo.num_romaneio order by rit.item_id) rank
                                                      from oper.v$romaneio roo
                                                     inner join oper.v$romaneio_item rit on roo.num_romaneio =
                                                                                            rit.num_romaneio)
                                             where rank = 1
                                               and trunc(data_termino_carga) >= trunc(sysdate - 30)) a,
                                           kss.v$pessoa_juridica pj
                                     where pj.cod_pessoa = a.cod_remetente
                                       and cod_remetente in
                                           (select cod_pessoa_carga
                                              from oper.v$grupo_logistico_carga
                                              inner join kss.v$pessoa pc
                                               on pc.cod_pessoa = cod_pessoa_carga
                                             where grupo_id = #arguments.grupo_id#)
                                       and a.cod_destinatario in
                                           (select cod_pessoa_descarga
                                              from oper.v$grupo_logistico_descarga
                                              inner join kss.v$pessoa pc
                                                        on pc.cod_pessoa = cod_pessoa_descarga
                                             where grupo_id = #arguments.grupo_id#)
                                     group by cod_remetente,
                                              remetente,
                                              pj.nome_fantasia,
                                              dia,
                                              mes,
                                              ano,
                                              tempo_carga,
                                              ordem
                                    union
                                    select /*+ORDERED*/
                                     gl.cod_pessoa_carga as cod_destinatario,
                                     remetente,
                                     pj.nome_fantasia,
                                     extract(day from dm.data) as dia,
                                     extract(month from dm.data) as mes,
                                     extract(year from dm.data) as ano,
                                     0 tempo_carga
                                      from (select trunc(sysdate-level) as data       
							                  from dual connect by level <= 30) dm,
                                           (select gl2.cod_pessoa_carga, p.cliente as remetente
                                              from oper.v$grupo_logistico_carga gl2
                                              inner join kss.v$pessoa p on p.cod_pessoa =
                                                                            gl2.cod_pessoa_carga
                                             where gl2.grupo_id = #arguments.grupo_id#) gl
                                     inner join kss.v$pessoa_juridica pj 
                                             on gl.cod_pessoa_carga = pj.cod_pessoa
                                     inner join kss.v$pessoa_endereco_padrao pep 
                                             on pep.cod_pessoa = pj.cod_pessoa)
                             group by cod_remetente,remetente, nome_fantasia, dia, ano
                             order by cod_remetente,remetente, ano, dia     
                        </cfif>
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as Unidades do Cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/02/2006
	--->	
	<cffunction name="get_unidades" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_unidades" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED*/ pjc.cod_pessoa as cod_pessoa_carga, pjc.nome_fantasia as unidade_carga,
				   pjd.cod_pessoa as cod_pessoa_descarga, pjd.nome_fantasia as unidade_descarga
			  from oper.v$grupo_logistico_acesso gl
			 inner join kss.v$pessoa_juridica pjc
					 on pjc.cod_pessoa = gl.cod_pessoa_carga 
			 inner join kss.v$pessoa_juridica pjd
					 on pjd.cod_pessoa = gl.cod_pessoa_descarga
   		</cfquery>	
		<cfreturn qr_unidades>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca as Unidades de carga e descarga
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  06/03/2006
	--->		
	<cffunction name="get_unidades_grupo" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */ gl.grupo_id, gl.descricao, glc.fluxo_carga, 
				   glc.cod_pessoa_carga, pc.cliente as unidade_carga, 
				   gld.cod_pessoa_descarga, pd.cliente as unidade_descarga, gld.fluxo_descarga
			  from oper.v$grupo_logistico gl
			 inner join oper.v$grupo_logistico_carga glc
					 on glc.grupo_id = gl.grupo_id
			 inner join kss.v$pessoa pc
					 on pc.cod_pessoa = glc.cod_pessoa_carga
			 inner join oper.v$grupo_logistico_descarga gld
					 on gld.grupo_id = gl.grupo_id
			 inner join kss.v$pessoa pd
					 on pd.cod_pessoa = gld.cod_pessoa_descarga
			 where 1 = 1
			 <cfif IsDefined("arguments.grupo_id") and Len(Trim(arguments.grupo_id))>
			   and gl.grupo_id = #arguments.grupo_id#
			 </cfif>
			 order by glc.cod_pessoa_carga, gld.cod_pessoa_descarga
   		</cfquery>	
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Buscas os veculos e as posies no mapa
	-- NOTAS EXPLICATIVAS
	-- FABIOG 18/03/2011
	--->		
	<cffunction name="get_veiculos_mapa" access="remote" returntype="query" output="true">
		<cfscript>
			qrGrupo = this.get_grupo_corrente();
		</cfscript>	
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select placa_tracao
                 , placa_reboque
                 , placa_controle
                 , placa_referencia
                 , r.referencia
                 , latitude 
                 , longitude
                 , r.num_romaneio                 
              from (select placa_tracao
              			 , placa_reboque
                         , placa_controle
                 		 , placa_referencia
                         , referencia
                         , latitude
                         , longitude
                         , r.num_romaneio 
                      from oper.v$controle_trafego r
                     where 1=1
                       and num_evento in (100,1,2,3,4,5)
                   ) r
             inner join (select r.num_romaneio
                              , #session.cod_pessoa_usuario# cod_pessoa
                              , nvl(cod_remetente,#session.cod_pessoa_usuario#) as cod_remetente
                              , nvl(redespacho,0) as redespacho
                           from oper.v$romaneio r
                       <cfif qrGrupo.SOMENTE_VEICULOS eq 1>left<cfelse>inner</cfif> 
                           join oper.v$romaneio_item rit
                             on rit.num_romaneio = r.num_romaneio
                            and (rit.cod_remetente in (select cod_pessoa_carga
                                                         from oper.v$grupo_logistico_acesso) 
                            and rit.cod_destinatario in (select cod_pessoa_descarga
                                                           from oper.v$grupo_logistico_acesso gl))                                          
                          where (r.num_romaneio in (select rhv.num_romaneio 
                                                      from oper.v$controle_trafego rhv 
                                                     where (rhv.placa_controle in (select glv.placa 
                                                                                     from oper.v$grupo_logistico_veiculo_user glv)
                                                        or rhv.placa_referencia in(select glv.placa 
                                                                                     from oper.v$grupo_logistico_veiculo_user glv))
                                                           )
                                 )
                         ) cr
                     on cr.num_romaneio = r.num_romaneio
             order by r.placa_tracao
   		</cfquery>	
		<cfreturn qr_result>
	</cffunction>				
</cfcomponent> 